/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.annotation.Ignore;
import org.msgpack.annotation.Index;
import org.msgpack.annotation.MessagePackMessage;
import org.msgpack.annotation.Nullable;
import org.msgpack.annotation.Optional;
import org.msgpack.annotation.Required;
import org.msgpack.template.BeansFieldEntry;
import org.msgpack.template.FieldEntry;
import org.msgpack.template.FieldList;
import org.msgpack.template.FieldOption;
import org.msgpack.template.IFieldEntry;
import org.msgpack.template.IFieldEntryReader;
import org.msgpack.template.TemplateBuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansFieldEntryReader
implements IFieldEntryReader {
    @Override
    public IFieldEntry[] convertFieldEntries(Class<?> targetClass, FieldList flist) throws NoSuchFieldException {
        List<FieldList.Entry> src = flist.getList();
        IFieldEntry[] result = new FieldEntry[src.size()];
        for (int i = 0; i < src.size(); ++i) {
            FieldList.Entry s = src.get(i);
            result[i] = s.isAvailable() ? new FieldEntry(targetClass.getDeclaredField(s.getName()), s.getOption()) : new FieldEntry();
        }
        return result;
    }

    @Override
    public IFieldEntry[] readFieldEntries(Class<?> targetClass, FieldOption implicitOption) {
        int i;
        BeanInfo desc;
        try {
            desc = Introspector.getBeanInfo(targetClass);
        }
        catch (IntrospectionException e1) {
            throw new TemplateBuildException("Class must be java beans class:" + targetClass.getName());
        }
        PropertyDescriptor[] props = desc.getPropertyDescriptors();
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        for (int i2 = 0; i2 < props.length; ++i2) {
            PropertyDescriptor pd = props[i2];
            if (this.isIgnoreProp(pd)) continue;
            list.add(pd);
        }
        props = new PropertyDescriptor[list.size()];
        list.toArray(props);
        IFieldEntry[] entries = new BeansFieldEntry[props.length];
        for (int i3 = 0; i3 < props.length; ++i3) {
            PropertyDescriptor p = props[i3];
            int index = this.readPropIndex(p);
            if (index < 0) continue;
            if (entries[index] != null) {
                throw new TemplateBuildException("duplicated index: " + index);
            }
            if (index >= entries.length) {
                throw new TemplateBuildException("invalid index: " + index);
            }
            entries[index] = new BeansFieldEntry(p);
            props[index] = null;
        }
        int insertIndex = 0;
        for (i = 0; i < props.length; ++i) {
            PropertyDescriptor p = props[i];
            if (p == null) continue;
            while (entries[insertIndex] != null) {
                ++insertIndex;
            }
            entries[insertIndex] = new BeansFieldEntry(p);
        }
        for (i = 0; i < entries.length; ++i) {
            IFieldEntry e = entries[i];
            FieldOption op = this.readPropOption(((BeansFieldEntry)e).desc, implicitOption);
            ((BeansFieldEntry)e).setOption(op);
        }
        return entries;
    }

    @Override
    public FieldOption readImplicitFieldOption(Class<?> targetClass) {
        MessagePackMessage a = targetClass.getAnnotation(MessagePackMessage.class);
        if (a == null) {
            return FieldOption.DEFAULT;
        }
        return a.value();
    }

    private FieldOption readPropOption(PropertyDescriptor desc, FieldOption implicitOption) {
        FieldOption forGetter = this.readMethodOption(desc.getReadMethod());
        if (forGetter != FieldOption.DEFAULT) {
            return forGetter;
        }
        FieldOption forSetter = this.readMethodOption(desc.getWriteMethod());
        if (forSetter != FieldOption.DEFAULT) {
            return forSetter;
        }
        return implicitOption;
    }

    private FieldOption readMethodOption(Method method) {
        if (this.isAnnotated(method, Ignore.class)) {
            return FieldOption.IGNORE;
        }
        if (this.isAnnotated(method, Required.class)) {
            return FieldOption.REQUIRED;
        }
        if (this.isAnnotated(method, Optional.class)) {
            return FieldOption.OPTIONAL;
        }
        if (this.isAnnotated(method, Nullable.class)) {
            if (method.getDeclaringClass().isPrimitive()) {
                return FieldOption.REQUIRED;
            }
            return FieldOption.NULLABLE;
        }
        return FieldOption.DEFAULT;
    }

    private int readPropIndex(PropertyDescriptor desc) {
        int forGetter = this.readMethodIndex(desc.getReadMethod());
        if (forGetter >= 0) {
            return forGetter;
        }
        int forSetter = this.readMethodIndex(desc.getWriteMethod());
        return forSetter;
    }

    private int readMethodIndex(Method method) {
        Index a = method.getAnnotation(Index.class);
        if (a == null) {
            return -1;
        }
        return a.value();
    }

    private boolean isAnnotated(AccessibleObject ao, Class<? extends Annotation> with) {
        return ao.getAnnotation(with) != null;
    }

    boolean isIgnoreProp(PropertyDescriptor desc) {
        if (desc == null) {
            return true;
        }
        Method getter = desc.getReadMethod();
        Method setter = desc.getWriteMethod();
        return getter == null || setter == null || !Modifier.isPublic(getter.getModifiers()) || !Modifier.isPublic(setter.getModifiers()) || this.isAnnotated(getter, Ignore.class) || this.isAnnotated(setter, Ignore.class);
    }
}

