/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.object;

import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.object.BigIntegerTypeIMPL;
import org.msgpack.object.IntegerType;
import org.msgpack.object.LongIntegerTypeIMPL;

class ShortIntegerTypeIMPL
extends IntegerType {
    private int value;

    ShortIntegerTypeIMPL(int value) {
        this.value = value;
    }

    public byte asByte() {
        if (this.value > 127) {
            throw new MessageTypeException("type error");
        }
        return (byte)this.value;
    }

    public short asShort() {
        if (this.value > Short.MAX_VALUE) {
            throw new MessageTypeException("type error");
        }
        return (short)this.value;
    }

    public int asInt() {
        return this.value;
    }

    public long asLong() {
        return this.value;
    }

    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void messagePack(Packer pk) throws IOException {
        pk.packInt(this.value);
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            if (obj.getClass() == LongIntegerTypeIMPL.class) {
                return (long)this.value == ((LongIntegerTypeIMPL)obj).longValue();
            }
            if (obj.getClass() == BigIntegerTypeIMPL.class) {
                return ((BigIntegerTypeIMPL)obj).bigIntegerValue().equals(BigInteger.valueOf(this.value));
            }
            return false;
        }
        return ((ShortIntegerTypeIMPL)obj).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public Object clone() {
        return new ShortIntegerTypeIMPL(this.value);
    }
}

