/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.object;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.MessagePackObject;
import org.msgpack.Packer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapType
extends MessagePackObject {
    private MessagePackObject[] map;

    MapType(MessagePackObject[] map) {
        this.map = map;
    }

    public static MapType create(MessagePackObject[] map) {
        return new MapType(map);
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public Map<MessagePackObject, MessagePackObject> asMap() {
        HashMap<MessagePackObject, MessagePackObject> m = new HashMap<MessagePackObject, MessagePackObject>(this.map.length / 2);
        int i = 0;
        while (i < this.map.length) {
            MessagePackObject k = this.map[i++];
            MessagePackObject v = this.map[i++];
            m.put(k, v);
        }
        return m;
    }

    @Override
    public void messagePack(Packer pk) throws IOException {
        pk.packMap(this.map.length / 2);
        for (int i = 0; i < this.map.length; ++i) {
            this.map[i].messagePack(pk);
        }
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return Arrays.equals(((MapType)obj).map, this.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object clone() {
        MessagePackObject[] copy = new MessagePackObject[this.map.length];
        for (int i = 0; i < this.map.length; ++i) {
            copy[i] = (MessagePackObject)this.map[i].clone();
        }
        return copy;
    }
}

