/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.object;

import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.Packer;
import org.msgpack.object.FloatType;

class DoubleTypeIMPL
extends FloatType {
    private double value;

    public DoubleTypeIMPL(double value) {
        this.value = value;
    }

    public float asFloat() {
        return (float)this.value;
    }

    public double asDouble() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf((long)this.value);
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void messagePack(Packer pk) throws IOException {
        pk.packDouble(this.value);
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return ((DoubleTypeIMPL)obj).value == this.value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public Object clone() {
        return new DoubleTypeIMPL(this.value);
    }
}

