/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.object;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.msgpack.MessagePackObject;
import org.msgpack.Packer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType
extends MessagePackObject {
    private MessagePackObject[] array;

    ArrayType(MessagePackObject[] array) {
        this.array = array;
    }

    public static ArrayType create(MessagePackObject[] array) {
        return new ArrayType(array);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public MessagePackObject[] asArray() {
        return this.array;
    }

    @Override
    public List<MessagePackObject> asList() {
        return Arrays.asList(this.array);
    }

    @Override
    public void messagePack(Packer pk) throws IOException {
        pk.packArray(this.array.length);
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i].messagePack(pk);
        }
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return Arrays.equals(((ArrayType)obj).array, this.array);
    }

    public int hashCode() {
        return this.array.hashCode();
    }

    @Override
    public Object clone() {
        MessagePackObject[] copy = new MessagePackObject[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            copy[i] = (MessagePackObject)this.array[i].clone();
        }
        return copy;
    }
}

