/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.msgpack.BufferedUnpackerImpl;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.MessageUnpackable;
import org.msgpack.Template;
import org.msgpack.UnpackException;
import org.msgpack.UnpackIterator;
import org.msgpack.UnpackResult;
import org.msgpack.template.TemplateRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unpacker
implements Iterable<MessagePackObject> {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    protected int parsed = 0;
    protected int bufferReserveSize;
    protected InputStream stream;
    final BufferedUnpackerMixin impl = new BufferedUnpackerMixin();

    public Unpacker() {
        this(32768);
    }

    public Unpacker(int bufferReserveSize) {
        this(null, bufferReserveSize);
    }

    public Unpacker(InputStream stream) {
        this(stream, 32768);
    }

    public Unpacker(InputStream stream, int bufferReserveSize) {
        this.bufferReserveSize = bufferReserveSize / 2;
        this.stream = stream;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public void feed(byte[] buffer) {
        this.feed(buffer, 0, buffer.length);
    }

    public void feed(byte[] buffer, int offset, int length) {
        this.reserveBuffer(length);
        System.arraycopy(buffer, offset, this.impl.buffer, this.impl.offset, length);
        this.bufferConsumed(length);
    }

    public void feed(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (length == 0) {
            return;
        }
        this.reserveBuffer(length);
        buffer.get(this.impl.buffer, this.impl.offset, length);
        this.bufferConsumed(length);
    }

    public void wrap(byte[] buffer) {
        this.wrap(buffer, 0, buffer.length);
    }

    public void wrap(byte[] buffer, int offset, int length) {
        this.impl.buffer = buffer;
        this.impl.offset = offset;
        this.impl.filled = length;
        this.impl.bufferReferenced = false;
    }

    public boolean fill() throws IOException {
        return this.impl.fill();
    }

    @Override
    public Iterator<MessagePackObject> iterator() {
        return new UnpackIterator(this);
    }

    public UnpackResult next() throws IOException, UnpackException {
        UnpackResult result = new UnpackResult();
        this.impl.next(result);
        return result;
    }

    public boolean next(UnpackResult result) throws IOException, UnpackException {
        return this.impl.next(result);
    }

    public void reserveBuffer(int require) {
        int nextSize;
        if (this.impl.buffer == null) {
            int nextSize2 = this.bufferReserveSize < require ? require : this.bufferReserveSize;
            this.impl.buffer = new byte[nextSize2];
            this.impl.bufferReferenced = false;
            return;
        }
        if (!this.impl.bufferReferenced && this.impl.filled <= this.impl.offset) {
            this.impl.filled = 0;
            this.impl.offset = 0;
        }
        if (this.impl.buffer.length - this.impl.filled >= require) {
            return;
        }
        int notParsed = this.impl.filled - this.impl.offset;
        for (nextSize = this.impl.buffer.length * 2; nextSize < require + notParsed; nextSize *= 2) {
        }
        byte[] tmp = new byte[nextSize];
        System.arraycopy(this.impl.buffer, this.impl.offset, tmp, 0, this.impl.filled - this.impl.offset);
        this.impl.buffer = tmp;
        this.impl.filled = notParsed;
        this.impl.offset = 0;
        this.impl.bufferReferenced = false;
    }

    public byte[] getBuffer() {
        return this.impl.buffer;
    }

    public int getBufferCapacity() {
        return this.impl.buffer.length - this.impl.filled;
    }

    public int getBufferOffset() {
        return this.impl.filled;
    }

    public void bufferConsumed(int size) {
        this.impl.filled += size;
    }

    public boolean execute() throws UnpackException {
        int noffset = this.impl.execute(this.impl.buffer, this.impl.offset, this.impl.filled);
        if (noffset <= this.impl.offset) {
            return false;
        }
        this.parsed += noffset - this.impl.offset;
        this.impl.offset = noffset;
        return this.impl.isFinished();
    }

    public int execute(byte[] buffer) throws UnpackException {
        return this.execute(buffer, 0, buffer.length);
    }

    public int execute(byte[] buffer, int offset, int length) throws UnpackException {
        int noffset = this.impl.execute(buffer, offset, length);
        if (this.impl.isFinished()) {
            this.impl.resetState();
        }
        return noffset;
    }

    public MessagePackObject getData() {
        return this.impl.getData();
    }

    public boolean isFinished() {
        return this.impl.isFinished();
    }

    public void reset() {
        this.impl.reset();
    }

    public int getMessageSize() {
        return this.parsed - this.impl.offset + this.impl.filled;
    }

    public int getParsedSize() {
        return this.parsed;
    }

    public int getNonParsedSize() {
        return this.impl.filled - this.impl.offset;
    }

    public void skipNonparsedBuffer(int size) {
        this.impl.offset += size;
    }

    public void removeNonparsedBuffer() {
        this.impl.filled = this.impl.offset;
    }

    public byte unpackByte() throws IOException, MessageTypeException {
        return this.impl.unpackByte();
    }

    public short unpackShort() throws IOException, MessageTypeException {
        return this.impl.unpackShort();
    }

    public int unpackInt() throws IOException, MessageTypeException {
        return this.impl.unpackInt();
    }

    public long unpackLong() throws IOException, MessageTypeException {
        return this.impl.unpackLong();
    }

    public BigInteger unpackBigInteger() throws IOException, MessageTypeException {
        return this.impl.unpackBigInteger();
    }

    public float unpackFloat() throws IOException, MessageTypeException {
        return this.impl.unpackFloat();
    }

    public double unpackDouble() throws IOException, MessageTypeException {
        return this.impl.unpackDouble();
    }

    public Object unpackNull() throws IOException, MessageTypeException {
        return this.impl.unpackNull();
    }

    public boolean unpackBoolean() throws IOException, MessageTypeException {
        return this.impl.unpackBoolean();
    }

    public int unpackArray() throws IOException, MessageTypeException {
        return this.impl.unpackArray();
    }

    public int unpackMap() throws IOException, MessageTypeException {
        return this.impl.unpackMap();
    }

    public int unpackRaw() throws IOException, MessageTypeException {
        return this.impl.unpackRaw();
    }

    public byte[] unpackRawBody(int length) throws IOException {
        return this.impl.unpackRawBody(length);
    }

    public byte[] unpackByteArray() throws IOException {
        return this.impl.unpackByteArray();
    }

    public ByteBuffer unpackByteBuffer() throws IOException {
        return this.impl.unpackByteBuffer();
    }

    public final String unpackString() throws IOException, MessageTypeException {
        return this.impl.unpackString();
    }

    public final MessagePackObject unpackObject() throws IOException {
        return this.impl.unpackObject();
    }

    public final boolean tryUnpackNull() throws IOException {
        return this.impl.tryUnpackNull();
    }

    public final void unpack(MessageUnpackable obj) throws IOException, MessageTypeException {
        obj.messageUnpack(this);
    }

    public final <T> T unpack(T to) throws IOException, MessageTypeException {
        return (T)this.unpack(to.getClass(), to);
    }

    public final <T> T unpack(Class<T> klass) throws IOException, MessageTypeException {
        return this.unpack(klass, null);
    }

    public final <T> T unpack(Class<T> klass, T to) throws IOException, MessageTypeException {
        if (this.tryUnpackNull()) {
            return null;
        }
        return (T)TemplateRegistry.lookup(klass).unpack(this, to);
    }

    public final Object unpack(Template tmpl) throws IOException, MessageTypeException {
        return this.unpack(tmpl, null);
    }

    public final <T> T unpack(Template tmpl, T to) throws IOException, MessageTypeException {
        return (T)tmpl.unpack(this, to);
    }

    final class BufferedUnpackerMixin
    extends BufferedUnpackerImpl {
        BufferedUnpackerMixin() {
        }

        boolean fill() throws IOException {
            if (Unpacker.this.stream == null) {
                return false;
            }
            Unpacker.this.reserveBuffer(Unpacker.this.bufferReserveSize);
            int rl = Unpacker.this.stream.read(this.buffer, this.filled, this.buffer.length - this.filled);
            if (rl <= 0) {
                return false;
            }
            Unpacker.this.bufferConsumed(rl);
            return true;
        }
    }
}

