/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.msgpack.MessagePackable;
import org.msgpack.MessageTypeException;
import org.msgpack.Template;
import org.msgpack.template.TemplateRegistry;

public class Packer {
    protected byte[] castBytes = new byte[9];
    protected OutputStream out;

    public static void load() {
    }

    public Packer(OutputStream out) {
        this.out = out;
    }

    public Packer packByte(byte d) throws IOException {
        if (d < -32) {
            this.castBytes[0] = -48;
            this.castBytes[1] = d;
            this.out.write(this.castBytes, 0, 2);
        } else {
            this.out.write(d);
        }
        return this;
    }

    public Packer packShort(short d) throws IOException {
        if (d < -32) {
            if (d < -128) {
                this.castBytes[0] = -47;
                this.castBytes[1] = (byte)(d >> 8);
                this.castBytes[2] = (byte)(d >> 0);
                this.out.write(this.castBytes, 0, 3);
            } else {
                this.castBytes[0] = -48;
                this.castBytes[1] = (byte)d;
                this.out.write(this.castBytes, 0, 2);
            }
        } else if (d < 128) {
            this.out.write((byte)d);
        } else if (d < 256) {
            this.castBytes[0] = -52;
            this.castBytes[1] = (byte)d;
            this.out.write(this.castBytes, 0, 2);
        } else {
            this.castBytes[0] = -51;
            this.castBytes[1] = (byte)(d >> 8);
            this.castBytes[2] = (byte)(d >> 0);
            this.out.write(this.castBytes, 0, 3);
        }
        return this;
    }

    public Packer packInt(int d) throws IOException {
        if (d < -32) {
            if (d < Short.MIN_VALUE) {
                this.castBytes[0] = -46;
                this.castBytes[1] = (byte)(d >> 24);
                this.castBytes[2] = (byte)(d >> 16);
                this.castBytes[3] = (byte)(d >> 8);
                this.castBytes[4] = (byte)(d >> 0);
                this.out.write(this.castBytes, 0, 5);
            } else if (d < -128) {
                this.castBytes[0] = -47;
                this.castBytes[1] = (byte)(d >> 8);
                this.castBytes[2] = (byte)(d >> 0);
                this.out.write(this.castBytes, 0, 3);
            } else {
                this.castBytes[0] = -48;
                this.castBytes[1] = (byte)d;
                this.out.write(this.castBytes, 0, 2);
            }
        } else if (d < 128) {
            this.out.write((byte)d);
        } else if (d < 256) {
            this.castBytes[0] = -52;
            this.castBytes[1] = (byte)d;
            this.out.write(this.castBytes, 0, 2);
        } else if (d < 65536) {
            this.castBytes[0] = -51;
            this.castBytes[1] = (byte)(d >> 8);
            this.castBytes[2] = (byte)(d >> 0);
            this.out.write(this.castBytes, 0, 3);
        } else {
            this.castBytes[0] = -50;
            this.castBytes[1] = (byte)(d >> 24);
            this.castBytes[2] = (byte)(d >> 16);
            this.castBytes[3] = (byte)(d >> 8);
            this.castBytes[4] = (byte)(d >> 0);
            this.out.write(this.castBytes, 0, 5);
        }
        return this;
    }

    public Packer packLong(long d) throws IOException {
        if (d < -32L) {
            if (d < -32768L) {
                if (d < Integer.MIN_VALUE) {
                    this.castBytes[0] = -45;
                    this.castBytes[1] = (byte)(d >> 56);
                    this.castBytes[2] = (byte)(d >> 48);
                    this.castBytes[3] = (byte)(d >> 40);
                    this.castBytes[4] = (byte)(d >> 32);
                    this.castBytes[5] = (byte)(d >> 24);
                    this.castBytes[6] = (byte)(d >> 16);
                    this.castBytes[7] = (byte)(d >> 8);
                    this.castBytes[8] = (byte)(d >> 0);
                    this.out.write(this.castBytes, 0, 9);
                } else {
                    this.castBytes[0] = -46;
                    this.castBytes[1] = (byte)(d >> 24);
                    this.castBytes[2] = (byte)(d >> 16);
                    this.castBytes[3] = (byte)(d >> 8);
                    this.castBytes[4] = (byte)(d >> 0);
                    this.out.write(this.castBytes, 0, 5);
                }
            } else if (d < -128L) {
                this.castBytes[0] = -47;
                this.castBytes[1] = (byte)(d >> 8);
                this.castBytes[2] = (byte)(d >> 0);
                this.out.write(this.castBytes, 0, 3);
            } else {
                this.castBytes[0] = -48;
                this.castBytes[1] = (byte)d;
                this.out.write(this.castBytes, 0, 2);
            }
        } else if (d < 128L) {
            this.out.write((byte)d);
        } else if (d < 65536L) {
            if (d < 256L) {
                this.castBytes[0] = -52;
                this.castBytes[1] = (byte)d;
                this.out.write(this.castBytes, 0, 2);
            } else {
                this.castBytes[0] = -51;
                this.castBytes[1] = (byte)((d & 0xFF00L) >> 8);
                this.castBytes[2] = (byte)((d & 0xFFL) >> 0);
                this.out.write(this.castBytes, 0, 3);
            }
        } else if (d < 0x100000000L) {
            this.castBytes[0] = -50;
            this.castBytes[1] = (byte)((d & 0xFFFFFFFFFF000000L) >> 24);
            this.castBytes[2] = (byte)((d & 0xFF0000L) >> 16);
            this.castBytes[3] = (byte)((d & 0xFF00L) >> 8);
            this.castBytes[4] = (byte)((d & 0xFFL) >> 0);
            this.out.write(this.castBytes, 0, 5);
        } else {
            this.castBytes[0] = -49;
            this.castBytes[1] = (byte)(d >> 56);
            this.castBytes[2] = (byte)(d >> 48);
            this.castBytes[3] = (byte)(d >> 40);
            this.castBytes[4] = (byte)(d >> 32);
            this.castBytes[5] = (byte)(d >> 24);
            this.castBytes[6] = (byte)(d >> 16);
            this.castBytes[7] = (byte)(d >> 8);
            this.castBytes[8] = (byte)(d >> 0);
            this.out.write(this.castBytes, 0, 9);
        }
        return this;
    }

    public Packer packBigInteger(BigInteger d) throws IOException {
        if (d.bitLength() <= 63) {
            return this.packLong(d.longValue());
        }
        if (d.bitLength() <= 64 && d.signum() >= 0) {
            this.castBytes[0] = -49;
            byte[] barray = d.toByteArray();
            this.castBytes[1] = barray[barray.length - 8];
            this.castBytes[2] = barray[barray.length - 7];
            this.castBytes[3] = barray[barray.length - 6];
            this.castBytes[4] = barray[barray.length - 5];
            this.castBytes[5] = barray[barray.length - 4];
            this.castBytes[6] = barray[barray.length - 3];
            this.castBytes[7] = barray[barray.length - 2];
            this.castBytes[8] = barray[barray.length - 1];
            this.out.write(this.castBytes, 0, 9);
            return this;
        }
        throw new MessageTypeException("can't pack BigInteger larger than 0xffffffffffffffff");
    }

    public Packer packFloat(float d) throws IOException {
        this.castBytes[0] = -54;
        int f = Float.floatToRawIntBits(d);
        this.castBytes[1] = (byte)(f >> 24);
        this.castBytes[2] = (byte)(f >> 16);
        this.castBytes[3] = (byte)(f >> 8);
        this.castBytes[4] = (byte)(f >> 0);
        this.out.write(this.castBytes, 0, 5);
        return this;
    }

    public Packer packDouble(double d) throws IOException {
        this.castBytes[0] = -53;
        long f = Double.doubleToRawLongBits(d);
        this.castBytes[1] = (byte)(f >> 56);
        this.castBytes[2] = (byte)(f >> 48);
        this.castBytes[3] = (byte)(f >> 40);
        this.castBytes[4] = (byte)(f >> 32);
        this.castBytes[5] = (byte)(f >> 24);
        this.castBytes[6] = (byte)(f >> 16);
        this.castBytes[7] = (byte)(f >> 8);
        this.castBytes[8] = (byte)(f >> 0);
        this.out.write(this.castBytes, 0, 9);
        return this;
    }

    public Packer packNil() throws IOException {
        this.out.write(-64);
        return this;
    }

    public Packer packTrue() throws IOException {
        this.out.write(-61);
        return this;
    }

    public Packer packFalse() throws IOException {
        this.out.write(-62);
        return this;
    }

    public Packer packBoolean(boolean d) throws IOException {
        return d ? this.packTrue() : this.packFalse();
    }

    public Packer packArray(int n) throws IOException {
        if (n < 16) {
            int d = 0x90 | n;
            this.out.write((byte)d);
        } else if (n < 65536) {
            this.castBytes[0] = -36;
            this.castBytes[1] = (byte)(n >> 8);
            this.castBytes[2] = (byte)(n >> 0);
            this.out.write(this.castBytes, 0, 3);
        } else {
            this.castBytes[0] = -35;
            this.castBytes[1] = (byte)(n >> 24);
            this.castBytes[2] = (byte)(n >> 16);
            this.castBytes[3] = (byte)(n >> 8);
            this.castBytes[4] = (byte)(n >> 0);
            this.out.write(this.castBytes, 0, 5);
        }
        return this;
    }

    public Packer packMap(int n) throws IOException {
        if (n < 16) {
            int d = 0x80 | n;
            this.out.write((byte)d);
        } else if (n < 65536) {
            this.castBytes[0] = -34;
            this.castBytes[1] = (byte)(n >> 8);
            this.castBytes[2] = (byte)(n >> 0);
            this.out.write(this.castBytes, 0, 3);
        } else {
            this.castBytes[0] = -33;
            this.castBytes[1] = (byte)(n >> 24);
            this.castBytes[2] = (byte)(n >> 16);
            this.castBytes[3] = (byte)(n >> 8);
            this.castBytes[4] = (byte)(n >> 0);
            this.out.write(this.castBytes, 0, 5);
        }
        return this;
    }

    public Packer packRaw(int n) throws IOException {
        if (n < 32) {
            int d = 0xA0 | n;
            this.out.write((byte)d);
        } else if (n < 65536) {
            this.castBytes[0] = -38;
            this.castBytes[1] = (byte)(n >> 8);
            this.castBytes[2] = (byte)(n >> 0);
            this.out.write(this.castBytes, 0, 3);
        } else {
            this.castBytes[0] = -37;
            this.castBytes[1] = (byte)(n >> 24);
            this.castBytes[2] = (byte)(n >> 16);
            this.castBytes[3] = (byte)(n >> 8);
            this.castBytes[4] = (byte)(n >> 0);
            this.out.write(this.castBytes, 0, 5);
        }
        return this;
    }

    public Packer packRawBody(byte[] b) throws IOException {
        this.out.write(b);
        return this;
    }

    public Packer packRawBody(byte[] b, int off, int length) throws IOException {
        this.out.write(b, off, length);
        return this;
    }

    public Packer packByteArray(byte[] b) throws IOException {
        this.packRaw(b.length);
        return this.packRawBody(b, 0, b.length);
    }

    public Packer packByteArray(byte[] b, int off, int length) throws IOException {
        this.packRaw(length);
        return this.packRawBody(b, off, length);
    }

    public Packer packByteBuffer(ByteBuffer buf) throws IOException {
        this.packRaw(buf.remaining());
        return this.packRawBody(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
    }

    public Packer packString(String s) throws IOException {
        byte[] b = s.getBytes("UTF-8");
        this.packRaw(b.length);
        return this.packRawBody(b);
    }

    public Packer pack(boolean o) throws IOException {
        if (o) {
            return this.packTrue();
        }
        return this.packFalse();
    }

    public Packer pack(byte o) throws IOException {
        return this.packByte(o);
    }

    public Packer pack(short o) throws IOException {
        return this.packShort(o);
    }

    public Packer pack(int o) throws IOException {
        return this.packInt(o);
    }

    public Packer pack(long o) throws IOException {
        return this.packLong(o);
    }

    public Packer pack(float o) throws IOException {
        return this.packFloat(o);
    }

    public Packer pack(double o) throws IOException {
        return this.packDouble(o);
    }

    public Packer pack(Boolean o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        if (o.booleanValue()) {
            return this.packTrue();
        }
        return this.packFalse();
    }

    public Packer pack(Byte o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        return this.packByte(o);
    }

    public Packer pack(Short o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        return this.packShort(o);
    }

    public Packer pack(Integer o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        return this.packInt(o);
    }

    public Packer pack(Long o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        return this.packLong(o);
    }

    public Packer pack(BigInteger o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        return this.packBigInteger(o);
    }

    public Packer pack(Float o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        return this.packFloat(o.floatValue());
    }

    public Packer pack(Double o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        return this.packDouble(o);
    }

    public Packer pack(String o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        return this.packString(o);
    }

    public Packer pack(byte[] o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        this.packRaw(o.length);
        return this.packRawBody(o);
    }

    public Packer pack(ByteBuffer o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        this.packRaw(o.remaining());
        return this.packRawBody(o.array(), o.arrayOffset() + o.position(), o.remaining());
    }

    public Packer pack(List o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        this.packArray(o.size());
        for (Object i : o) {
            this.pack(i);
        }
        return this;
    }

    public Packer pack(Map o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        this.packMap(o.size());
        for (Map.Entry e : o.entrySet()) {
            this.pack(e.getKey());
            this.pack(e.getValue());
        }
        return this;
    }

    public Packer pack(MessagePackable o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        o.messagePack(this);
        return this;
    }

    public Packer pack(Object o) throws IOException {
        if (o == null) {
            return this.packNil();
        }
        TemplateRegistry.lookup(o.getClass()).pack(this, o);
        return this;
    }

    public Packer pack(Object o, Template tmpl) throws IOException {
        tmpl.pack(this, o);
        return this;
    }
}

