/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.transport;

import org.msgpack.MessagePackObject;
import org.msgpack.rpc.Server;
import org.msgpack.rpc.Session;
import org.msgpack.rpc.loop.EventLoop;
import org.msgpack.rpc.transport.MessageSendable;

public class RpcMessageHandler {
    protected final Session session;
    protected final Server server;
    protected final EventLoop loop;
    protected boolean useThread = false;

    public RpcMessageHandler(Session session) {
        this(session, null);
    }

    public RpcMessageHandler(Server server) {
        this(null, server);
    }

    public RpcMessageHandler(Session session, Server server) {
        this.session = session;
        this.server = server;
        this.loop = session == null ? server.getEventLoop() : session.getEventLoop();
    }

    public void useThread(boolean value) {
        this.useThread = value;
    }

    public void handleMessage(MessageSendable channel, MessagePackObject msg) {
        if (this.useThread) {
            this.loop.getWorkerExecutor().submit(new HandleMessageTask(this, channel, msg));
        } else {
            this.handleMessageImpl(channel, msg);
        }
    }

    private void handleMessageImpl(MessageSendable channel, MessagePackObject msg) {
        MessagePackObject[] array = msg.asArray();
        int type = array[0].asInt();
        if (type == 0) {
            int msgid = array[1].asInt();
            String method = array[2].asString();
            MessagePackObject args = array[3];
            this.handleRequest(channel, msgid, method, args);
        } else if (type == 1) {
            int msgid = array[1].asInt();
            MessagePackObject error = array[2];
            MessagePackObject result = array[3];
            this.handleResponse(channel, msgid, result, error);
        } else if (type == 2) {
            String method = array[1].asString();
            MessagePackObject args = array[2];
            this.handleNotify(channel, method, args);
        } else {
            throw new RuntimeException("unknown message type: " + type);
        }
    }

    private void handleRequest(MessageSendable channel, int msgid, String method, MessagePackObject args) {
        if (this.server == null) {
            return;
        }
        this.server.onRequest(channel, msgid, method, args);
    }

    private void handleNotify(MessageSendable channel, String method, MessagePackObject args) {
        if (this.server == null) {
            return;
        }
        this.server.onNotify(method, args);
    }

    private void handleResponse(MessageSendable channel, int msgid, MessagePackObject result, MessagePackObject error) {
        if (this.session == null) {
            return;
        }
        this.session.onResponse(msgid, result, error);
    }

    static class HandleMessageTask
    implements Runnable {
        private RpcMessageHandler handler;
        private MessageSendable channel;
        private MessagePackObject msg;

        HandleMessageTask(RpcMessageHandler handler, MessageSendable channel, MessagePackObject msg) {
            this.handler = handler;
            this.channel = channel;
            this.msg = msg;
        }

        public void run() {
            this.handler.handleMessageImpl(this.channel, this.msg);
        }
    }
}

