/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.MessagePack;
import org.msgpack.rpc.Session;
import org.msgpack.rpc.config.StreamClientConfig;
import org.msgpack.rpc.transport.ClientTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PooledStreamClientTransport<Channel, PendingBuffer extends OutputStream>
implements ClientTransport {
    private final Object lock = new Object();
    private final List<Channel> pool = new ArrayList<Channel>();
    private int reconnectionLimit;
    private int connecting = 0;
    protected final Session session;
    protected final StreamClientConfig config;
    private PendingBuffer pendingBuffer = null;

    public PooledStreamClientTransport(StreamClientConfig config, Session session) {
        this.session = session;
        this.config = config;
        this.reconnectionLimit = config.getReconnectionLimit();
    }

    protected Session getSession() {
        return this.session;
    }

    protected StreamClientConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Object msg) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connecting == -1) {
                return;
            }
            if (this.pool.isEmpty()) {
                if (this.connecting == 0) {
                    ++this.connecting;
                    this.startConnection();
                }
                if (this.pool.isEmpty()) {
                    try {
                        MessagePack.pack(this.getPendingBuffer(), (Object)msg);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
            }
            Channel c = this.pool.get(0);
            this.sendMessageChannel(c, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingBuffer != null) {
                this.closePendingBuffer(this.pendingBuffer);
                this.pendingBuffer = null;
            }
            this.connecting = -1;
            for (Channel c : this.pool) {
                this.closeChannel(c);
            }
            this.pool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected(Channel c) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connecting == -1) {
                this.closeChannel(c);
                return;
            }
            this.pool.add(c);
            this.connecting = 0;
            if (this.pendingBuffer != null) {
                this.flushPendingBuffer(this.pendingBuffer, c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectFailed(Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connecting == -1) {
                return;
            }
            if (this.connecting < this.reconnectionLimit) {
                ++this.connecting;
                this.startConnection();
            } else {
                this.connecting = 0;
                if (this.pendingBuffer != null) {
                    this.resetPendingBuffer(this.pendingBuffer);
                }
                this.session.transportConnectFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(Channel c) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connecting == -1) {
                return;
            }
            this.pool.remove(c);
        }
    }

    protected PendingBuffer getPendingBuffer() {
        if (this.pendingBuffer == null) {
            this.pendingBuffer = this.newPendingBuffer();
        }
        return this.pendingBuffer;
    }

    protected abstract PendingBuffer newPendingBuffer();

    protected abstract void resetPendingBuffer(PendingBuffer var1);

    protected abstract void flushPendingBuffer(PendingBuffer var1, Channel var2);

    protected abstract void closePendingBuffer(PendingBuffer var1);

    protected abstract void startConnection();

    protected abstract void sendMessageChannel(Channel var1, Object var2);

    protected abstract void closeChannel(Channel var1);
}

