/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.reflect;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.rpc.reflect.Invoker;
import org.msgpack.rpc.reflect.InvokerBuilder;
import org.msgpack.rpc.reflect.Proxy;
import org.msgpack.rpc.reflect.ProxyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflect {
    private static final Reflect instance = new Reflect();
    private Map<Class<?>, Proxy<?>> proxyCache = new HashMap();
    private Map<Method, Invoker> invokerCache = new HashMap<Method, Invoker>();

    public static <T> Proxy<T> reflectProxy(Class<T> iface) {
        return instance.getProxy(iface);
    }

    public static Invoker reflectInvoker(Method method) {
        return InvokerBuilder.build(method);
    }

    private Reflect() {
    }

    private synchronized <T> Proxy<T> getProxy(Class<T> iface) {
        Proxy<Object> proxy = this.proxyCache.get(iface);
        if (proxy == null) {
            proxy = ProxyBuilder.build(iface);
            this.proxyCache.put(iface, proxy);
        }
        return proxy;
    }

    private synchronized Invoker getInvoker(Method method) {
        Invoker invoker = this.invokerCache.get(method);
        if (invoker == null) {
            invoker = InvokerBuilder.build(method);
            this.invokerCache.put(method, invoker);
        }
        return invoker;
    }
}

