/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.msgpack.rpc.Future;
import org.msgpack.rpc.reflect.InvokerBuilder;
import org.msgpack.rpc.reflect.MethodSelector;
import org.msgpack.rpc.reflect.Proxy;
import org.msgpack.rpc.reflect.ReflectionProxyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyBuilder {
    private static ProxyBuilder instance;

    public abstract <T> Proxy<T> buildProxy(Class<T> var1, MethodEntry[] var2);

    public <T> Proxy<T> buildProxy(Class<T> iface) {
        ProxyBuilder.checkValidation(iface);
        MethodEntry[] entries = ProxyBuilder.readMethodEntries(iface);
        return this.buildProxy(iface, entries);
    }

    private static synchronized ProxyBuilder getInstance() {
        if (instance == null) {
            instance = ProxyBuilder.selectDefaultProxyBuilder();
        }
        return instance;
    }

    private static ProxyBuilder selectDefaultProxyBuilder() {
        return ReflectionProxyBuilder.getInstance();
    }

    static synchronized void setInstance(ProxyBuilder builder) {
        instance = builder;
    }

    public static <T> Proxy<T> build(Class<T> iface) {
        return ProxyBuilder.getInstance().buildProxy(iface);
    }

    static boolean isAsyncMethod(Method targetMethod) {
        return targetMethod.getReturnType().equals(Future.class) || targetMethod.getReturnType().equals(java.util.concurrent.Future.class);
    }

    private static void checkValidation(Class<?> iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException("not interface: " + iface);
        }
    }

    static MethodEntry[] readMethodEntries(Class<?> iface) {
        Method[] methods = MethodSelector.selectRpcClientMethod(iface);
        MethodEntry[] result = new MethodEntry[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            InvokerBuilder.ArgumentEntry[] argumentEntries = InvokerBuilder.readArgumentEntries(method, false);
            boolean async = ProxyBuilder.isAsyncMethod(method);
            String rpcName = method.getName();
            if (async && rpcName.endsWith("Async")) {
                rpcName = rpcName.substring(0, rpcName.length() - 5);
            }
            Type returnType = method.getGenericReturnType();
            if (async) {
                returnType = ((ParameterizedType)returnType).getActualTypeArguments()[0];
            }
            result[i] = new MethodEntry(method, rpcName, returnType, async, argumentEntries);
        }
        return result;
    }

    public static class MethodEntry {
        private Method method;
        private String rpcName;
        private Type genericReturnType;
        private boolean async;
        private InvokerBuilder.ArgumentEntry[] argumentEntries;

        public MethodEntry(Method method, String rpcName, Type genericReturnType, boolean async, InvokerBuilder.ArgumentEntry[] argumentEntries) {
            this.method = method;
            this.rpcName = rpcName;
            this.genericReturnType = genericReturnType;
            this.async = async;
            this.argumentEntries = argumentEntries;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getRpcName() {
            return this.rpcName;
        }

        public Type getGenericReturnType() {
            return this.genericReturnType;
        }

        public boolean isReturnTypeVoid() {
            return this.genericReturnType == Void.TYPE || this.genericReturnType == Void.class;
        }

        public boolean isAsync() {
            return this.async;
        }

        public InvokerBuilder.ArgumentEntry[] getArgumentEntries() {
            return this.argumentEntries;
        }
    }
}

