/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.loop.netty;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.msgpack.rpc.Server;
import org.msgpack.rpc.Session;
import org.msgpack.rpc.config.TcpClientConfig;
import org.msgpack.rpc.config.TcpServerConfig;
import org.msgpack.rpc.loop.EventLoop;
import org.msgpack.rpc.loop.netty.NettyTcpClientTransport;
import org.msgpack.rpc.loop.netty.NettyTcpServerTransport;
import org.msgpack.rpc.transport.ClientTransport;
import org.msgpack.rpc.transport.ServerTransport;

public class NettyEventLoop
extends EventLoop {
    private ClientSocketChannelFactory clientFactory = null;
    private ServerSocketChannelFactory serverFactory = null;

    public NettyEventLoop(ExecutorService workerExecutor, ExecutorService ioExecutor, ScheduledExecutorService scheduledExecutor) {
        super(workerExecutor, ioExecutor, scheduledExecutor);
    }

    public synchronized ClientSocketChannelFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new NioClientSocketChannelFactory((Executor)this.getIoExecutor(), (Executor)this.getWorkerExecutor());
        }
        return this.clientFactory;
    }

    public synchronized ServerSocketChannelFactory getServerFactory() {
        if (this.serverFactory == null) {
            this.serverFactory = new NioServerSocketChannelFactory((Executor)this.getIoExecutor(), (Executor)this.getIoExecutor());
        }
        return this.serverFactory;
    }

    protected ClientTransport openTcpTransport(TcpClientConfig config, Session session) {
        return new NettyTcpClientTransport(config, session, this);
    }

    protected ServerTransport listenTcpTransport(TcpServerConfig config, Server server) {
        return new NettyTcpServerTransport(config, server, this);
    }
}

