/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.loop;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.msgpack.rpc.Server;
import org.msgpack.rpc.Session;
import org.msgpack.rpc.config.ClientConfig;
import org.msgpack.rpc.config.ServerConfig;
import org.msgpack.rpc.config.TcpClientConfig;
import org.msgpack.rpc.config.TcpServerConfig;
import org.msgpack.rpc.loop.EventLoopFactory;
import org.msgpack.rpc.loop.netty.NettyEventLoopFactory;
import org.msgpack.rpc.transport.ClientTransport;
import org.msgpack.rpc.transport.ServerTransport;

public abstract class EventLoop {
    private static EventLoopFactory loopFactory;
    private static EventLoop defaultEventLoop;
    private ExecutorService workerExecutor;
    private ExecutorService ioExecutor;
    private ScheduledExecutorService scheduledExecutor;

    public static synchronized void setFactory(EventLoopFactory factory) {
        loopFactory = factory;
    }

    private static synchronized EventLoopFactory getFactory() {
        if (loopFactory == null) {
            loopFactory = new NettyEventLoopFactory();
        }
        return loopFactory;
    }

    public static synchronized void setDefaultEventLoop(EventLoop eventLoop) {
        defaultEventLoop = eventLoop;
    }

    public static synchronized EventLoop defaultEventLoop() {
        if (defaultEventLoop == null) {
            defaultEventLoop = EventLoop.start();
        }
        return defaultEventLoop;
    }

    public static EventLoop start() {
        return EventLoop.start(Executors.newCachedThreadPool());
    }

    public static EventLoop start(ExecutorService workerExecutor) {
        return EventLoop.start(workerExecutor, Executors.newCachedThreadPool());
    }

    public static EventLoop start(ExecutorService workerExecutor, ExecutorService ioExecutor) {
        return EventLoop.start(workerExecutor, ioExecutor, Executors.newScheduledThreadPool(2));
    }

    public static EventLoop start(ExecutorService workerExecutor, ExecutorService ioExecutor, ScheduledExecutorService scheduledExecutor) {
        return EventLoop.getFactory().make(workerExecutor, ioExecutor, scheduledExecutor);
    }

    public EventLoop(ExecutorService workerExecutor, ExecutorService ioExecutor, ScheduledExecutorService scheduledExecutor) {
        this.workerExecutor = workerExecutor;
        this.scheduledExecutor = scheduledExecutor;
        this.ioExecutor = ioExecutor;
    }

    public ExecutorService getWorkerExecutor() {
        return this.workerExecutor;
    }

    public ExecutorService getIoExecutor() {
        return this.ioExecutor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public void shutdown() {
        this.scheduledExecutor.shutdown();
        this.ioExecutor.shutdown();
        this.workerExecutor.shutdown();
    }

    public void join() throws InterruptedException {
        this.scheduledExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        this.ioExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        this.workerExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    public ClientTransport openTransport(ClientConfig config, Session session) {
        if (config instanceof TcpClientConfig) {
            return this.openTcpTransport((TcpClientConfig)config, session);
        }
        throw new RuntimeException("Unknown transport config: " + config.getClass().getName());
    }

    public ServerTransport listenTransport(ServerConfig config, Server server) throws IOException {
        if (config instanceof TcpServerConfig) {
            return this.listenTcpTransport((TcpServerConfig)config, server);
        }
        throw new RuntimeException("Unknown transport config: " + config.getClass().getName());
    }

    protected abstract ClientTransport openTcpTransport(TcpClientConfig var1, Session var2);

    protected abstract ServerTransport listenTcpTransport(TcpServerConfig var1, Server var2);
}

