/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.error;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessagePackable;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.object.ArrayType;
import org.msgpack.object.RawType;
import org.msgpack.rpc.error.RPCError;

public class RemoteError
extends RPCError
implements MessagePackable {
    private MessagePackObject data;
    public static final String CODE = "RemoteError";

    public RemoteError() {
        this.data = ArrayType.create((MessagePackObject[])new MessagePackObject[]{RawType.create((String)"unknown error")});
    }

    public RemoteError(String message) {
        super(message);
        this.data = ArrayType.create((MessagePackObject[])new MessagePackObject[]{RawType.create((String)message)});
    }

    public RemoteError(MessagePackObject data) {
        super(RemoteError.loadMessage(data));
        this.data = data;
    }

    public MessagePackObject getData() {
        return this.data;
    }

    public void messagePack(Packer pk) throws IOException {
        pk.pack((MessagePackable)this.data);
    }

    private static String loadMessage(MessagePackObject data) {
        try {
            if (data.isRawType()) {
                return data.asString();
            }
            return data.asArray()[0].asString();
        }
        catch (MessageTypeException e) {
            return "unknown error: " + data;
        }
    }

    public String getCode() {
        return CODE;
    }
}

