/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.dispatcher;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.rpc.Request;
import org.msgpack.rpc.dispatcher.Dispatcher;
import org.msgpack.rpc.reflect.Invoker;
import org.msgpack.rpc.reflect.MethodSelector;
import org.msgpack.rpc.reflect.Reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDispatcher
implements Dispatcher {
    protected Map<String, Invoker> methodMap;
    protected Object target;

    public MethodDispatcher(Object target) {
        this(target, target.getClass());
    }

    public MethodDispatcher(Object target, Class<?> iface) {
        this(target, MethodSelector.selectRpcServerMethod(iface));
    }

    public MethodDispatcher(Object target, Method[] methods) {
        this.target = target;
        this.methodMap = new HashMap<String, Invoker>();
        for (Method method : methods) {
            this.methodMap.put(method.getName(), Reflect.reflectInvoker(method));
        }
    }

    @Override
    public void dispatch(Request request) throws Exception {
        Invoker ivk = this.methodMap.get(request.getMethodName());
        if (ivk == null) {
            throw new IOException(".CallError.NoMethodError");
        }
        ivk.invoke(this.target, request);
    }
}

