/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.msgpack.rpc.Session;
import org.msgpack.rpc.address.Address;
import org.msgpack.rpc.address.IPAddress;
import org.msgpack.rpc.config.ClientConfig;
import org.msgpack.rpc.config.TcpClientConfig;
import org.msgpack.rpc.loop.EventLoop;

public class SessionPool
implements Closeable {
    private ClientConfig config;
    private EventLoop loop;
    private Map<Address, Session> pool = new HashMap<Address, Session>();
    private ScheduledFuture<?> timer;

    public SessionPool() {
        this(new TcpClientConfig());
    }

    public SessionPool(ClientConfig config) {
        this(config, EventLoop.defaultEventLoop());
    }

    public SessionPool(EventLoop loop) {
        this(new TcpClientConfig(), loop);
    }

    public SessionPool(ClientConfig config, EventLoop loop) {
        this.config = config;
        this.loop = loop;
        this.startTimer();
    }

    public EventLoop getEventLoop() {
        return this.loop;
    }

    public Session getSession(String host, int port) throws UnknownHostException {
        return this.getSession(new IPAddress(host, port));
    }

    public Session getSession(InetSocketAddress address) {
        return this.getSession(new IPAddress(address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Session getSession(Address address) {
        Map<Address, Session> map = this.pool;
        synchronized (map) {
            Session s = this.pool.get(address);
            if (s == null) {
                s = new Session(address, this.config, this.loop);
                this.pool.put(address, s);
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.timer.cancel(false);
        Map<Address, Session> map = this.pool;
        synchronized (map) {
            for (Map.Entry<Address, Session> pair : this.pool.entrySet()) {
                Session s = pair.getValue();
                s.closeSession();
            }
            this.pool.clear();
        }
    }

    private void startTimer() {
        Runnable command = new Runnable(){

            public void run() {
                SessionPool.this.stepTimeout();
            }
        };
        this.timer = this.loop.getScheduledExecutor().scheduleAtFixedRate(command, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stepTimeout() {
        Map<Address, Session> map = this.pool;
        synchronized (map) {
            for (Map.Entry<Address, Session> pair : this.pool.entrySet()) {
                Session s = pair.getValue();
                s.stepTimeout();
            }
        }
    }
}

