/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc;

import org.msgpack.MessagePackObject;
import org.msgpack.rpc.message.ResponseMessage;
import org.msgpack.rpc.transport.MessageSendable;

public class Request {
    private MessageSendable channel;
    private int msgid;
    private String method;
    private MessagePackObject args;

    public Request(MessageSendable channel, int msgid, String method, MessagePackObject args) {
        this.channel = channel;
        this.msgid = msgid;
        this.method = method;
        this.args = args;
    }

    public Request(String method, MessagePackObject args) {
        this.channel = null;
        this.msgid = 0;
        this.method = method;
        this.args = args;
    }

    public String getMethodName() {
        return this.method;
    }

    public MessagePackObject getArguments() {
        return this.args;
    }

    public int getMessageID() {
        return this.msgid;
    }

    public void sendResult(Object result) {
        this.sendResponse(result, null);
    }

    public void sendError(Object error) {
        this.sendResponse(null, error);
    }

    public void sendError(Object error, Object data) {
        this.sendResponse(data, error);
    }

    public synchronized void sendResponse(Object result, Object error) {
        if (this.channel == null) {
            return;
        }
        ResponseMessage msg = new ResponseMessage(this.msgid, error, result);
        this.channel.sendMessage(msg);
        this.channel = null;
    }
}

