/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.msgpack.MessagePackObject;
import org.msgpack.rpc.Session;

class FutureImpl {
    private Session session;
    private Runnable callback = null;
    private Object lock = new Object();
    private int timeout;
    private volatile boolean done = false;
    private MessagePackObject result;
    private MessagePackObject error;

    FutureImpl(Session session) {
        this.session = session;
        this.timeout = session.getRequestTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachCallback(Runnable callback) {
        Object object = this.lock;
        synchronized (object) {
            this.callback = callback;
        }
        if (this.done) {
            this.session.getEventLoop().getWorkerExecutor().submit(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void join() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void join(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                this.lock.wait(unit.toMillis(timeout));
            }
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public MessagePackObject getResult() {
        return this.result;
    }

    public MessagePackObject getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(MessagePackObject result, MessagePackObject error) {
        Object object = this.lock;
        synchronized (object) {
            this.result = result;
            this.error = error;
            this.done = true;
            this.lock.notifyAll();
        }
        if (this.callback != null) {
            this.callback.run();
        }
    }

    boolean stepTimeout() {
        if (this.timeout <= 0) {
            return true;
        }
        --this.timeout;
        return false;
    }
}

