/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.msgpack.rpc.Session;
import org.msgpack.rpc.address.Address;
import org.msgpack.rpc.address.IPAddress;
import org.msgpack.rpc.config.ClientConfig;
import org.msgpack.rpc.config.TcpClientConfig;
import org.msgpack.rpc.loop.EventLoop;

public class Client
extends Session
implements Closeable {
    private ScheduledFuture<?> timer;

    public Client(String host, int port) throws UnknownHostException {
        this(new IPAddress(host, port), (ClientConfig)new TcpClientConfig(), EventLoop.defaultEventLoop());
    }

    public Client(String host, int port, ClientConfig config) throws UnknownHostException {
        this(new IPAddress(host, port), config, EventLoop.defaultEventLoop());
    }

    public Client(String host, int port, EventLoop loop) throws UnknownHostException {
        this(new IPAddress(host, port), (ClientConfig)new TcpClientConfig(), loop);
    }

    public Client(String host, int port, ClientConfig config, EventLoop loop) throws UnknownHostException {
        this(new IPAddress(host, port), config, loop);
    }

    public Client(InetSocketAddress address) {
        this(new IPAddress(address), (ClientConfig)new TcpClientConfig(), EventLoop.defaultEventLoop());
    }

    public Client(InetSocketAddress address, ClientConfig config) {
        this(new IPAddress(address), config, EventLoop.defaultEventLoop());
    }

    public Client(InetSocketAddress address, EventLoop loop) {
        this(new IPAddress(address), (ClientConfig)new TcpClientConfig(), loop);
    }

    public Client(InetSocketAddress address, ClientConfig config, EventLoop loop) {
        this(new IPAddress(address), config, loop);
    }

    Client(Address address, ClientConfig config, EventLoop loop) {
        super(address, config, loop);
        this.startTimer();
    }

    private void startTimer() {
        Runnable command = new Runnable(){

            public void run() {
                Client.this.stepTimeout();
            }
        };
        this.timer = this.loop.getScheduledExecutor().scheduleAtFixedRate(command, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.timer.cancel(false);
        this.closeSession();
    }
}

