<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Services_Hatena Dispatcher
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     Makoto Tanaka
 * @copyright  2006 Makoto Tanaka
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */


define("HATENA_BASEDIR", "Services/Hatena/");

require_once(HATENA_BASEDIR . "base.php");


/**
 * Serveces Hatena Basic Class
 *
 * This class is for creating object using Hatena's 
 * Web Services API (search, autolink, bookmark, bookmarknum, foto, asin, similar,exist).
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     Makoto Tanaka
 * @copyright  2006 Makoto Tanaka
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena
{
    /**
     * constructer.
     *
     * @access  public
     */
    public function __construct() {}

    /**
     * create class and return.
     *
     * @access  public
     * @param   string $type servics name (search, autolink, asin, bookmarknum, bookmark, similar, foto, exist)
     * @return object class object for using API.
     */
    public function create($type)
    {

        switch ($type) {

        case "search"      : // class for Search API
        case "autolink"    : // class for autolink API
        case "bookmarknum" : // class for bookmarknum API
        case "asin"        : // class for asin API
        case "similar"     : // class for similar API
        case "bookmark"    : // class for bookmark API
        case "foto"        : // class for foto API
        case "exist"       : // class for exist API

            require_once(HATENA_BASEDIR . $type . ".php");
            $classname = "Services_Hatena_" . $type;

            if (class_exists($classname)) {
                return new $classname;
            } else {
                return PEAR::raiseError("missing the class.");
            }
            break;

        default :
            return PEAR::raiseError("missing the class.");
            break;
        }
    }
}
?>

