<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * search
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     Makoto Tanaka
 * @copyright  2006 Makoto Tanaka
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * Services_Hatena_search
 *
 * Interface for Hatena::Search with OpernSerch.
 * This class make Search function from Hatena.
 * The arguments is keyword to get a search result from Hatena.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     Makoto Tanaka
 * @copyright  2006 Makoto Tanaka
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_search extends Services_Hatena_base
{
    /**
     * To store OpenSearch Description Document URI.
     *
     * @see Services_Hatena_search
     */
    protected $osxml_url = "http://search.hatena.ne.jp/osxml";

    /**
     * To store OpenSearch object
     *
     * @see Services_Hatena_search
     */
    protected $os = null;

    /**
     * constructer
     *
     * create OpenSearch object
     *
     * @access  public
     */
    public function Services_Hatena_search()
    {
        require_once 'Services/OpenSearch.php';
        $this->os = new Services_OpenSearch($this->osxml_url);
    }

    /**
     * execute
     *
     * @access public
     * @param  string $keyword keyword
     * @return array search result
     */
    public function execute($keyword)
    {
        $keyword = mb_convert_encoding($keyword, "UTF-8", "ASCII,JIS,UTF-8,EUC-JP,SJIS");
        $this->result = $this->os->search($keyword);

        return $this->getResult();
    }

    /**
     * To get number of search result
     *
     * @access  public
     * @return  intger number of search result
     */
    public function getTotalSearchResult()
    {
        return $this->os->getTotalResults();
    }

    /**
     * To set start page for search
     *
     * @access public
     * @param integer $p page number
     */
    public function setStartPage($p)
    {
        $this->os->setStartPage($p);
    }

    /**
     * To get start page for search
     *
     * @access public
     * @return intger page number
     */
    public function getStartPage()
    {
        return $this->os->getStartPage();
    }

    /**
     * Retrieves the currently set entry count of per page.
     *
     * @access public
     * @return intger entry count
     */
    public function getCount()
    {
        return $this->os->getCount();
    }

    /**
     * To get previous page number
     *
     * @access public
     * @return page number
     */
    public function getPrevPage()
    {
        $s = $this->getStartPage();
        $r = $this->getTotalSearchResult();
        $c = $this->getCount();
  
        if ($s >= 2) {
            return $s - 1;
        }
        else {
        }
    }

    /**
     * To get next page number
     *
     * @access public
     * @return page number
     */
    public function getNextPage()
    {
        $s = $this->getStartPage();
        $r = $this->getTotalSearchResult();
        $c = $this->getCount();
  
        if (($r / $c) >= $s) {
            return $s + 1;
        }
        else {
        }
    }
}
?>

