<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Foto Life
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     Makoto Tanaka
 * @copyright  2006 Makoto Tanaka
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * Services_Hatena_foto
 *
 * Interface for Hatena::Fotolife's Atom API
 * This class serves get, add, edit and delete method
 * for your image file to Hatena::Fotolife.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     Makoto Tanaka
 * @copyright  2006 Makoto Tanaka
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_foto extends Services_Hatena_base
{
    /**
     * To store HTTP_Request Object
     *
     * @see Services_Hatena_foto
     */
    private   $http;

    /**
     * To store Foto Atom.POST URI
     *
     * @see add_foto
     */
    private   $addurl  = 'http://f.hatena.ne.jp/atom/post';

    /**
     * To store Foto Atom.EDIT URI
     *
     * @see get_foto,edit_foto,delete_foto
     */
    private   $editurl = 'http://f.hatena.ne.jp/atom/edit';

    protected $parameters;

    /**
     * constructer
     *
     * create HTTP_Request object.
     *
     * @access  public
     */
    public function Services_Hatena_foto()
    {
        $this->http = new HTTP_Request();
    }

    /**
     * To add image
     *
     * @access  public
     * @param   string $image image name
     * @param   string $title image title
     */
    public function add_foto($image, $title)
    {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $wsse = $this->getWSSEAuth();
        $based_image = base64_encode(file_get_contents($image));

        $rawdata = '
<entry xmlns="http://purl.org/atom/ns#">
<title>'.$title.'</title>
<content mode="base64" type="image/jpeg">'.$based_image.'</content>
</entry>';

        $this->setHeader(HTTP_REQUEST_METHOD_POST, $this->addurl);
        $this->http->addRawPostData($rawdata);

        $this->result = $this->http->sendRequest();
 
        // if you failed, you will be able to see PEAR::isError
    }

    /**
     * To get image title
     *
     * @access  public
     * @param   string $fid hatena foto id
     */
    public function get_foto($fid)
    {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $this->setHeader(HTTP_REQUEST_METHOD_GET, $this->editurl . "/$fid");

        $res = $this->http->sendRequest();
        $local_result = $this->http->getResponseBody();

        $matches = array();
        $pattern = '/<title>(.*)<\/title>/';
        preg_match($pattern, $local_result, $matches);

        if (isset($matches[1])) {
            $this->result = $matches[1];
        }
        else {
            $this->result = PEAR::raiseError("missing the result.");
        }
    }

    /**
     * To edit image title
     *
     * @access  public
     * @param   string $fid hatena foto id
     * @param   string $title image title
     */
    public function edit_foto($fid, $title)
    {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $rawdata = '
<entry xmlns="http://purl.org/atom/ns#">
<title>'.$title.'</title>
</entry>';


        $this->setHeader(HTTP_REQUEST_METHOD_PUT, $this->editurl . "/$fid");
        $this->http->addRawPostData($rawdata);

        $this->result = $this->http->sendRequest();

        // if you failed, you will be able to see PEAR::isError
    }

    /**
     * To delete image
     *
     * @access  public
     * @param   string $fid hatena foto id
     */
    public function delete_foto($fid)
    {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $this->setHeader(HTTP_REQUEST_METHOD_DELETE, $this->editurl . "/$fid");
        $this->http->addRawPostData($rawdata);

        $this->result = $this->http->sendRequest();

        // if you failed, you will be able to see PEAR::isError
    }

    /**
     * To make header
     *
     * @access  private
     * @param   string $method HTTP Method
     * @param   string $url Request URL
     */
    private function setHeader($method, $url)
    {
        $this->http->addHeader('Accept', 'application/x.atom+xml, application/xml, text/xml, */*');
        $this->http->addHeader('Authorization', 'WSSE profile="UsernameToken"');
        $this->http->addHeader('X-WSSE', $this->getWSSEAuth());
        $this->http->addHeader('Content-Type', 'application/x.atom+xml');
        $this->http->setMethod($method);
        $this->http->setURL($url);
    }
}
?>

