<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Services_Hatena base/login class
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     Makoto Tanaka
 * @copyright  2006 Makoto Tanaka
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * Services_Hatena base class
 *
 * This class is base for all class.
 * This class serves method to store or get result.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     Makoto Tanaka
 * @copyright  2006 Makoto Tanaka
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_base
{
    /**
     * To store result.
     *
     * @see getResult, getResultTotalNum
     */
    protected $result = null;

    /**
     * To store login object.
     *
     * @see hatena_login
     */
    protected $_login = null;

    /**
     * To store wsse.
     *
     * @see getWSSEAuth
     */
    protected $_wsse  = null;

    /**
     * constructer
     *
     * @access  public
     */
    public function Services_Hatena_base() {}

    /**
     * Return the result.
     *
     * @access  public
     * @return  string result
     */
    public function getResult() {
        return $this->result;
    }

    /**
     * Return the number of result.
     *
     * @access  public
     * @return  integer number of result
     */
    public function getResultTotalNum() {
        if (is_array($this->result)) {
          return count($this->result);
        } else {
          return strlen($this->result);
        }
    }

    /**
     * To login to hatena
     *
     * @param   string $user user name
     * @param   string $pass password
     * @access  public
     */
    public function hatena_login($user, $pass) {
        $this->_login = new Services_Hatena_login();
        $this->_wsse  = $this->_login->setWSSEAuth($user, $pass);
    }

    /**
     * Retrun wsse.
     *
     * @access  public
     * @return  string WSSE
     */
    public function getWSSEAuth() {
        return $this->_wsse;
    }
}

/**
 * Login class
 *
 * This class is login.
 * THis class serves method to create WSSE.
 * To login Hatena, you must call me with your username and password.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     Makoto Tanaka, shoma
 * @copyright  2006 Makoto Tanaka, shoma
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
require_once 'HTTP/Request.php';
class Services_Hatena_login extends HTTP_Request
{
    /**
     * constructer
     *
     * @access  public
     */
    function Services_Hatena_login() {}

    /**
     * To create string for WSSE
     *
     * @access  public
     * @param   string $user user name
     * @param   string $pass password
     * @return  string WSSE
     */
    function setWSSEAuth($user, $pass, $sha1 = false)
    {
         $nowtime = date('Y-m-d\TH:i:s\Z');
         $nonce   = pack('H*', sha1(md5(time())));
         $digest  = base64_encode(pack('H*', sha1($nonce.$nowtime.$pass)));
         $wsse = 'UsernameToken Username="'.$user.'", PasswordDigest="'.$digest.'", Created="'.$nowtime.'", Nonce="'.base64_encode($nonce).'"';

         return $wsse;
     }
}
?>

