<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * bookmarknum class
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * @class Services_Hatena_bookmarknum
 *
 * This is bookmarknum class.
 * for the Hatena API.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_bookmarknum extends Services_Hatena_base {
    protected $params;

    /**
     * @fn Services_Hatena_bookmarknum
     * @brief constructer for Services_Hatena_bookmarknum class
     *
     * @access  public
     */
    public function Services_Hatena_bookmarknum() {}

    /**
     * @fn execute
     * @brief you will be able to know number of bookmarked
     *
     * @access  public
     * @param   string url
     * @return  string number of bookmarked
     */
    public function execute($url) {
        mb_internal_encoding('euc');
        require_once "XML/RPC.php";

        $this->params = new XML_RPC_Value($url,"string");

        $msg      = new XML_RPC_Message("bookmark.getCount", array($this->params));
        $client   = new XML_RPC_Client("/xmlrpc", "b.hatena.ne.jp", 80);
        $response = $client->send($msg);

        if (!$response->faultCode()) {
          $r = $response->value()->scalarval();
          $this->result = $r[$url]->me["int"];
          return $this->getResult();
        }
        else {
          /** i do nothing */
        }
    }
}
