<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Search dispatcher
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * @class Services_Hatena_base
 *
 * This is basic class for using the Hatena API with PHP.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_base {
    protected $result = null;
    protected $_login = null;
    protected $_wsse  = null;

    /**
     * @fn Services_Hatena_base
     * @brief constructer for Services_Hatena_base class
     *
     * @access  public
     */
    public function Services_Hatena_base() {}

    /**
     * @fn getResult
     * @brief i will show you the result.
     *
     * @access  public
     * @return  string or array result
     */
    public function getResult() {
        return $this->result;
    }

    /**
     * @fn getResultTotalNum
     * @brief i will show you the result.
     *
     * @access  public
     * @return  string or array count of result
     */
    public function getResultTotalNum() {
        if ( is_array($this->result) ) {
          return count($this->result);
        }
        else {
          return strlen($this->result);
        }
    }

    /**
     * @fn hatena_login
     * @brief you will be able to login to Hatena
     *
     * @param   string user name
     * @param   string password
     * @access  public
     */
    public function hatena_login($user, $pass) {
        $this->_login = new Services_Hatena_login();
        $this->_wsse  = $this->_login->setWSSEAuth($user, $pass);
    }

    /**
     * @fn getWSSEAuth
     * @brief you will be able to get WSSE certification
     *
     * @access  public
     * @return  string wsse.certification
     */
    public function getWSSEAuth() {
        return $this->_wsse;
    }
}
?>
<?php
/**
 * login class
 *
 * This is basic login for using the Hatena API with PHP.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 shoma, gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
require_once 'HTTP/Request.php';
class Services_Hatena_login extends HTTP_Request
{
    /**
     * @fn Services_Hatena_login
     * @brief constructer for Services_Hatena_login class
     *
     * @access  public
     */
    function Services_Hatena_login() {}

    /**
     * @fn setWSSEAuth
     * @brief you will be able to make WSSE certification
     *
     * @access  public
     * @param   string username
     * @param   string password
     * @return  string wsse.certification
     */
    function setWSSEAuth($user, $pass, $sha1 = false)
    {
         $nowtime = date('Y-m-d\TH:i:s\Z');
         $nonce   = pack('H*', sha1(md5(time())));
         $digest  = base64_encode(pack('H*', sha1($nonce.$nowtime.$pass)));
         $wsse = 'UsernameToken Username="'.$user.'", PasswordDigest="'.$digest.'", Created="'.$nowtime.'", Nonce="'.base64_encode($nonce).'"';

         return $wsse;
     }
}
?>
