/*
 * All Rights Reserved, Copyright (C) 2003, Hitachi Software Engineering Co., Ltd.
 */
/* $Id: middle_lang.l,v 1.1.1.1 2003/01/20 02:39:36 ueno Exp $ */

/* lex definition for middle language */
%option nounput

%{
#include <stdio.h>
#include <string.h>

unsigned int policydb_lineno = 1;

unsigned int policydb_errors = 0;
%}
%array
letter  [A-Za-z]
digit   [0-9]
%%
domain {return(DOMAIN);}
role   {return(ROLE);}
user   {return(USER);}
allow {return(ALLOW);}
allowonly {return(ALLOWONLY);}
allownet {return(ALLOWNET);}
allowcom {return(ALLOWCOM);}
allowadm {return(ALLOWADM);}
allowtty {return(ALLOWTTY);}
allowpts {return(ALLOWPTS);}
allowproc {return(ALLOWPROC);}
allowtmpfs {return(ALLOWTMPFS);}
-raw {return(RAW);}
-tcp {return(TCP);}
-udp {return(UDP);}
-allport {return(ALLPORT);}
-wellknown {return(WELLKNOWN);}
-unix {return(UNIX);}
-sem {return(SEM);}
-msg {return(MSG);}
-msgq {return(MSGQ);}
-shm {return(SHM);}
-pipe {return(PIPE);}
-sig {return(SIG);}
-port {return(PORT);}
-security {return(SECURITY);}
-system {return(SYSTEM);}
-create {return(CREATE);}
-change {return(CHANGE);}
-self   {return(SELF);}
-other  {return(OTHER);}
-kmsg   {return(KMSG);}
-proc   {return(PROC);}


global {yylval=strdup("global"); return(GLOBAL_DOMAIN);}
general {yylval=strdup("general");return(GENERAL);}
deny {return(DENY);}
denyonly {return(DENYONLY);}
domain_trans {return(DOMAIN_TRANS);}
exclusive {return(EXCLUSIVE_FILE);}
"/"({letter}|{digit}|"."|_|-|"/")*	{ yylval=strdup(yytext);return(PATH); }
{letter}({letter}|{digit}|_)*	{ yylval=strdup(yytext);return(IDENTIFIER); }
{digit}* {yylval=strdup(yytext); return(NUMBER);}
#[^\n]*                         { /* delete comments */ }
[ \t\f]+			{ /* delete whitespace */ }
\n				{ /* delete whitespace */ policydb_lineno++; }
"," |
":" |
";" |
"(" |
")" |
"{" |
"}" |
"[" |
"-" |
"." |
"]" |
"~" |
"*"				{ yylval=strdup(yytext);return(yytext[0]); }
%%

int
 yyerror(char *msg)
{
	fprintf(stderr, "\nerror in the statement ending on line %d (token '%s'): %s\n\n", policydb_lineno, yytext, msg);
	policydb_errors++;
	return -1;
}

int
yywarn(char *msg)
{
	fprintf(stderr, "\nwarning about the statement ending on line %d (token '%s'): %s\n\n", policydb_lineno, yytext, msg);
	return 0;
}
