/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include "parselines_services.h"

//for debug
//#include <iostream>
//using namespace std;

//default constructor
ParseLinesServices::ParseLinesServices(){}
//constructor for Layout
ParseLinesServices::ParseLinesServices(QSplitter*&){}

//called from parse_services()
void ParseLinesServices::parse_services_replace_interfaces()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "refpolicy/policy/modules/services";
	path_to_be_written = "./interfaces_services_replace_interfaces.txt";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("*.if");
	colon = ":";
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				//QTextStream stream_echo( &file );
				var1="$1";
				var2="$2";
				var3="$3";
				var4="$4";
				var5="$5";
				var6="$6";
				////////////////////////////////////////////
				QRegExp rx_interface("^[interface]");
				QRegExp rx_interface2("interface\\(\\`"); 	
				////////////////////////////////////////////
				////////////////////////////////////////////
				//QRegExp rx_interface("^[define]");
				//QRegExp rx_interface2("define\\(\\`"); 	
				////////////////////////////////////////////
				QRegExp rx_interface3("\\'\\,\\`"); 	
				QRegExp rx_interface4("\\$1"); 	
				QRegExp rx_bracket_last("\\)"); 	
				QRegExp rx_interface5("\\$2"); 	
				QRegExp rx_interface6("\\$3");
				QRegExp rx_interface7("\\$4");
				QRegExp rx_interface8("\\$5");
				QRegExp rx_interface9("\\$6");
				QRegExp rx_can_exec("can_exec");
				QRegExp rx_gen_require("gen_require");
				QRegExp rx_gen_require_close("^[ \t\n\r\f]+\\'\\)");//close before many blanks
				QRegExp rx_summary("## <summary>");
				QRegExp rx_summary_title("<summary>*</summary>");
				rx_summary_title.setWildcard( TRUE ); 
				QRegExp rx_summary_close("## </summary>");

				int i,j,k,l = -1;
				tab = "	";
				//int check = 0;
				//int check2 = 0;

				//lines += colon + name; 	

				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					
					i = line_analized.find( rx_interface, 0);
					if(i != -1){
						line_analized.replace(rx_interface2,"");
						line_analized.replace(rx_interface3,"");

						line_analized_interface_name = line_analized;

						lines += "}";
						lines += "QRegExp rx_" + line_analized_interface_name +"(\"" + line_analized_interface_name + "\");";
						line_analized_if_clause = "if(line_analized.find( rx_" + line_analized_interface_name + ", 0) != -1){";
						lines += line_analized_if_clause;
						lines += tab + "line_analized.replace(\"" + line_analized_interface_name + "\",tab + \"" + line_analized_dollar_one + "\");";
				        }
					j = line_analized.find( rx_interface4, 0);
					if(j != -1){
						line_analized_dollar_one = line_analized.stripWhiteSpace();//this adds to lines. also append can be used
					}
					k = line_analized.find( rx_interface5, 0);
					if(k != -1){
						line_analized_dollar_two = line_analized.stripWhiteSpace();//this adds to lines. also append can be used
						lines += tab + "lines_break += tab + \"" + line_analized_dollar_two + "\";";
					}
					l = line_analized.find( rx_interface6, 0);
					if(l != -1){
						line_analized_dollar_three = line_analized.stripWhiteSpace();//this adds to lines. also append can be used
						lines += tab + "lines_break += tab + \"" + line_analized_dollar_three + "\";";
					}
					l = line_analized.find( rx_interface7, 0);
					if(l != -1){
						line_analized_dollar_four = line_analized.stripWhiteSpace();//this adds to lines. also append can be used
						lines += tab + "lines_break += tab + \"" + line_analized_dollar_four + "\";";
					}
					l = line_analized.find( rx_interface8, 0);
					if(l != -1){
						line_analized_dollar_five = line_analized.stripWhiteSpace();//this adds to lines. also append can be used
						lines += tab + "lines_break += tab + \"" + line_analized_dollar_five + "\";";
					}
					l = line_analized.find( rx_interface9, 0);
					if(l != -1){
						line_analized_dollar_six = line_analized.stripWhiteSpace();//this adds to lines. also append can be used
						lines += tab + "lines_break += tab + \"" + line_analized_dollar_six + "\";";
					}
				}
				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
					stream_w << *it << "\n";
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
}//end-parse_services_replace_interfaces()

void ParseLinesServices::parse_services()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "refpolicy/policy/modules/services";
	path_to_be_written = "./interfaces_services.txt";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("*.if");
	colon = ":";
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				//QTextStream stream_echo( &file );
				var1="$1";
				var2="$2";
				var3="$3";
				////////////////////////////////////////////
				QRegExp rx_interface("^[interface]");
				QRegExp rx_interface2("interface\\(\\`"); 	
				////////////////////////////////////////////
				////////////////////////////////////////////
				//QRegExp rx_interface("^[define]");
				//QRegExp rx_interface2("define\\(\\`"); 	
				////////////////////////////////////////////
				QRegExp rx_interface3("\\'\\,\\`"); 	
				QRegExp rx_interface4("\\$1"); 	
				QRegExp rx_bracket_last("\\)"); 	
				QRegExp rx_interface5("\\$2"); 	
				QRegExp rx_interface6("\\$3");
				QRegExp rx_can_exec("can_exec");
				QRegExp rx_gen_require("gen_require");
				QRegExp rx_gen_require_close("^[ \t\n\r\f]+\\'\\)");//close before many blanks
				QRegExp rx_summary("## <summary>");
				QRegExp rx_summary_title("<summary>*</summary>");
				rx_summary_title.setWildcard( TRUE ); 
				QRegExp rx_summary_close("## </summary>");

				int i,j,k,l = -1;
				int check = 0;
				int check2 = 0;

				lines_parse_admin += colon + name; 	

				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					
					i = line_analized.find( rx_interface, 0);
					if(i != -1){
						line_analized.replace(rx_interface2,"");
						line_analized.replace(rx_interface3,"");
						lines += line_analized;//this adds to lines. also append can be used
				        }
					
					j = line_analized.find( rx_interface4, 0);
					if(j != -1){
						lines += line_analized;//this adds to lines. also append can be used
					}
					k = line_analized.find( rx_interface5, 0);
					if(k != -1){
						lines += line_analized;//this adds to lines. also append can be used
					}
					l = line_analized.find( rx_interface6, 0);
					if(l != -1){
						lines += line_analized;//this adds to lines. also append can be used
					}
					if( line_analized.find( rx_summary_title, 0) != -1){
						continue;
					}
					if( line_analized.find( rx_summary_close, 0) != -1){
						check2 = 0;
					}
					if( check2 == 100){
						line_analized = line_analized.replace("#","");
						line_analized = line_analized.stripWhiteSpace();
						lines += "[summary]" + line_analized;
					}
					if( line_analized.find( rx_summary, 0) != -1){
						check2 = 100;
					}
					if( line_analized.find( rx_gen_require_close, 0) != -1){
						check = 0;
					}
					if( check == 100){
						line_analized = line_analized.stripWhiteSpace();
						lines += "[gen_require]" + line_analized;
					}
					if( line_analized.find( rx_gen_require, 0) != -1){
						check = 100;
					}
				}
				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
					stream_w << *it << "\n";
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
	parse_services_replace_interfaces();
}//end-parse_services()

void ParseLinesServices::break_services()
{
	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "refpolicy/policy/modules/services";
	path_to_be_written = "./interfaces_services_broken_up.txt";
	
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("*.if");
	colon = ":";
	/////////////////////////////////////////////////////////////
	//QStringList files = dir.entryList("*.spt");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
			
	
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				//QTextStream stream_echo( &file );
				var1="$1";
				var2="$2";
				var3="$3";
				//////////for continue (exclude template)/////////////////////////////////////////////
				QRegExp rx_template_start("template");
				QRegExp rx_template_end("^[\\'\\)]");
				//////////for raw sentences/////////////////////////////////////////////
				QRegExp rx_allow("^[ \t\n\r\f]+allow");//allow before many blanks 
				QRegExp rx_dontaudit("^[ \t\n\r\f]+dontaudit");//dontaudit before many blanks 
				QRegExp rx_typeattribute("^[ \t\n\r\f]+typeattribute");//typeattribute before many blanks
				///////////FIRST GET INTERFACE NAME////////////////////////////////
				QRegExp rx_interface("^[interface]");
				QRegExp rx_interface2("interface\\(\\`"); 
				//////////replaces//////////////////////////////////
				///////////////////////////////////////////////////////
				QRegExp rx_interface3("\\'\\,\\`"); 	
				QRegExp rx_interface4("\\$1"); 	
				QRegExp rx_bracket_last("\\)"); 	
				QRegExp rx_interface5("\\$2"); 	
				QRegExp rx_interface6("\\$3");
				//////////can_exec/////////////////////////////////////////////
				QRegExp rx_can_exec("can_exec");
				//////////misc/////////////////////////////////////////////
				QRegExp rx_corecmd_search_bin("^[ \t\n\r\f]+corecmd_search_bin");
				QRegExp rx_corecmd_exec_bin("^[ \t\n\r\f]+corecmd_exec_bin");
				QRegExp rx_domtrans_pattern("^[ \t\n\r\f]+domtrans_pattern");
				QRegExp rx_spec_domtrans_pattern("^[ \t\n\r\f]+spec_domtrans_pattern");
				//////////others/////////////////////////////////////////////
				QRegExp rx_files_search_var("files_search_var");
				QRegExp rx_files_search_var_lib("files_search_var_lib");
				QRegExp rx_amanda_search_lib("amanda_search_lib");
				QRegExp rx_files_search_usr("files_search_usr");
				QRegExp rx_files_read_etc_files("files_read_etc_files");
				//////////files_pattern/////////////////////////////////////////////
				QRegExp rx_getattr_dirs_pattern("rx_getattr_dirs_pattern");
				QRegExp rx_setattr_dirs_pattern("setattr_dirs_pattern");
				QRegExp rx_search_dirs_pattern("search_dirs_pattern");
				QRegExp rx_list_dirs_pattern("list_dirs_pattern");
				QRegExp rx_add_entry_dirs_pattern("add_entry_dirs_pattern");
				QRegExp rx_del_entry_dirs_pattern("del_entry_dirs_pattern");
				QRegExp rx_create_dirs_pattern("create_dirs_pattern");
				QRegExp rx_delete_dirs_pattern("delete_dirs_pattern");
				QRegExp rx_rename_dirs_pattern("rename_dirs_pattern");
				QRegExp rx_manage_dirs_pattern("manage_dirs_pattern");
				QRegExp rx_relabelfrom_dirs_pattern("relabelfrom_dirs_pattern");
				QRegExp rx_relabelto_dirs_pattern("relabelto_dirs_pattern");
				QRegExp rx_relabel_dirs_pattern("relabel_dirs_pattern");
				QRegExp rx_rw_dirs_pattern("rw_dirs_pattern");
				QRegExp rx_getattr_files_pattern("getattr_files_pattern");
				QRegExp rx_setattr_files_pattern("setattr_files_pattern");
				QRegExp rx_read_files_pattern("read_files_pattern");
				QRegExp rx_mmap_files_pattern("mmap_files_pattern");
				QRegExp rx_exec_files_pattern("exec_files_pattern");
				QRegExp rx_append_files_pattern("append_files_pattern");
				QRegExp rx_write_files_pattern("write_files_pattern");
				QRegExp rx_rw_files_pattern("rw_files_pattern");
				QRegExp rx_create_files_pattern("create_files_pattern");
				QRegExp rx_delete_files_pattern("delete_files_pattern");
				QRegExp rx_rename_files_pattern("rename_files_pattern");
				QRegExp rx_manage_files_pattern("manage_files_pattern");
				QRegExp rx_relabelfrom_files_pattern("relabelfrom_files_pattern");
				QRegExp rx_relabelto_files_pattern("relabelto_files_pattern");
				QRegExp rx_relabel_files_pattern("relabel_files_pattern");
				QRegExp rx_getattr_lnk_files_pattern("getattr_lnk_files_pattern");
				QRegExp rx_setattr_lnk_files_pattern("setattr_lnk_files_pattern");
				QRegExp rx_read_lnk_files_pattern("read_lnk_files_pattern");
				QRegExp rx_append_lnk_files_pattern("append_lnk_files_pattern");
				QRegExp rx_write_lnk_files_pattern("write_lnk_files_pattern");
				QRegExp rx_rw_lnk_files_pattern("rw_lnk_files_pattern");
				QRegExp rx_create_lnk_files_pattern("create_lnk_files_pattern");
				QRegExp rx_delete_lnk_files_pattern("delete_lnk_files_pattern");
				QRegExp rx_rename_lnk_files_pattern("rename_lnk_files_pattern");
				QRegExp rx_manage_lnk_files_pattern("manage_lnk_files_pattern");
				QRegExp rx_relabelfrom_lnk_files_pattern("relabelfrom_lnk_files_pattern");
				QRegExp rx_relabelto_lnk_files_pattern("relabelto_lnk_files_pattern");
				QRegExp rx_relabel_lnk_files_pattern("relabel_lnk_files_pattern");
				QRegExp rx_getattr_fifo_files_pattern("getattr_fifo_files_pattern");	
				QRegExp rx_setattr_fifo_files_pattern("setattr_fifo_files_pattern");
				QRegExp rx_read_fifo_files_pattern("read_fifo_files_pattern");
				QRegExp rx_append_fifo_files_pattern("append_fifo_files_pattern");
				QRegExp rx_write_fifo_files_pattern("write_fifo_files_pattern");
				QRegExp rx_rw_fifo_files_pattern("rw_fifo_files_pattern");
				QRegExp rx_create_fifo_files_pattern("create_fifo_files_pattern");
				QRegExp rx_delete_fifo_files_pattern("delete_fifo_files_pattern");
				QRegExp rx_rename_fifo_files_pattern("rename_fifo_files_pattern");
				QRegExp rx_manage_fifo_files_pattern("manage_fifo_files_pattern");
				QRegExp rx_relabelfrom_fifo_files_pattern("relabelfrom_fifo_files_pattern");
				QRegExp rx_relabelto_fifo_files_pattern("relabelto_fifo_files_pattern");
				QRegExp rx_relabel_fifo_files_pattern("relabel_fifo_files_pattern");
				QRegExp rx_getattr_sock_files_pattern("getattr_sock_files_pattern");
				QRegExp rx_setattr_sock_files_pattern("setattr_sock_files_pattern");
				QRegExp rx_read_sock_files_pattern("read_sock_files_pattern");	
				QRegExp rx_write_sock_files_pattern("write_sock_files_pattern");
				QRegExp rx_rw_sock_files_pattern("rw_sock_files_pattern");
				QRegExp rx_create_sock_files_pattern("create_sock_files_pattern");
				QRegExp rx_delete_sock_files_pattern("delete_sock_files_pattern");
				QRegExp rx_rename_sock_files_pattern("rename_sock_files_pattern");
				QRegExp rx_manage_sock_files_pattern("manage_sock_files_pattern");
				QRegExp rx_relabelfrom_sock_files_pattern("relabelfrom_sock_files_pattern");
				QRegExp rx_relabelto_sock_files_pattern("relabelto_sock_files_pattern");
				QRegExp rx_relabel_sock_files_pattern("relabel_sock_files_pattern");
				QRegExp rx_getattr_blk_files_pattern("getattr_blk_files_pattern");
				QRegExp rx_setattr_blk_files_pattern("setattr_blk_files_pattern");
				QRegExp rx_read_blk_files_pattern("read_blk_files_pattern");
				QRegExp rx_append_blk_files_pattern("append_blk_files_pattern");	
				QRegExp rx_write_blk_files_pattern("write_blk_files_pattern");
				QRegExp rx_rw_blk_files_pattern("rw_blk_files_pattern");
				QRegExp rx_create_blk_files_pattern("create_blk_files_pattern");
				QRegExp rx_delete_blk_files_pattern("delete_blk_files_pattern");
				QRegExp rx_rename_blk_files_pattern("rename_blk_files_pattern");
				QRegExp rx_manage_blk_files_pattern("manage_blk_files_pattern");
				QRegExp rx_relabelfrom_blk_files_pattern("relabelfrom_blk_files_pattern");
				QRegExp rx_relabelto_blk_files_pattern("relabelto_blk_files_pattern");
				QRegExp rx_relabel_blk_files_pattern("relabel_blk_files_pattern");
				QRegExp rx_getattr_chr_files_pattern("getattr_chr_files_pattern");
				QRegExp rx_setattr_chr_files_pattern("setattr_chr_files_pattern");
				QRegExp rx_read_chr_files_pattern("read_chr_files_pattern");
				QRegExp rx_append_chr_files_pattern("append_chr_files_pattern");
				QRegExp rx_write_chr_files_pattern("write_chr_files_pattern");
				QRegExp rx_rw_chr_files_pattern("rw_chr_files_pattern");
				QRegExp rx_create_chr_files_pattern("create_chr_files_pattern");
				QRegExp rx_delete_chr_files_pattern("delete_chr_files_pattern");
				QRegExp rx_rename_chr_files_pattern("rename_chr_files_pattern");
				QRegExp rx_manage_chr_files_pattern("manage_chr_files_pattern");
				QRegExp rx_relabelfrom_chr_files_pattern("relabelfrom_chr_files_pattern");
				QRegExp rx_relabelto_chr_files_pattern("relabelto_chr_files_pattern");
				QRegExp rx_relabel_chr_files_pattern("relabel_chr_files_pattern");
				QRegExp rx_filetrans_add_pattern("filetrans_add_pattern");
				QRegExp rx_filetrans_pattern("filetrans_pattern");				
				///////////letters to be greped////////////////////////////////////////
				QRegExp rx_letters("[a-zA-Z0-9]");
				//////////other variables/////////////////////////////////////////////				
				int skip_flag = 0;
				int iii = 0;
				QString interface_name_with_var,add0,layer_name,interface_raw_name,cumma,prefix_this;
				layer_name = "admin";
				tab = "	";
				cumma = ",";

				lines_break += colon + name; 	

				/////////now let's analize .if files.////////////////////////////////
				while ( !stream.atEnd() ) {
				    line_analized = stream.readLine(); // line of text excluding '\n'

					//skips templates
				    if(line_analized.find( rx_template_end, 0) != -1){
					skip_flag = 0;
					continue;
				    }
				    //this brace should be read only no templates.
				    if(skip_flag == 0){
					
					if(line_analized.find( rx_template_start, 0) != -1){
					skip_flag = 1;
					continue;
				        }
					//get the interface name
					if(line_analized.find( rx_interface, 0) != -1){
					    line_analized.replace(rx_interface2,"");
					    line_analized.replace(rx_interface3,"");
					    interface_raw_name = line_analized;
					    prefix_this = layer_name + cumma + interface_raw_name + cumma;
					    //for debug
					    //cout << "prefix_this:" << prefix_this << endl ;
					    //end-for debug
					    lines_break += line_analized;//this adds to lines. also append can be used
					}
					//add raw allow sentences
					if(line_analized.find( rx_allow, 0) != -1){
					    lines_break += tab + line_analized;
					}
					//add raw dontaudit sentences
					if(line_analized.find( rx_dontaudit, 0) != -1){
					    lines_break += tab + line_analized;
					}
					//add raw typeattribute sentences
					if(line_analized.find( rx_typeattribute, 0) != -1){
					    lines_break += tab + line_analized;
					}
					//////////////////////////////////////////////////////////////////////////////////////
					//replace pattern t "xxx_run_xxx..." these should be above domtrans_pattern
					//just add those needed it would be broken at final stage.
					//copy from interfaces_xxx_replace_interfaces.txt
QRegExp rx_aide_run("aide_run");
if(line_analized.find( rx_aide_run, 0) != -1){
	line_analized.replace("aide_run",tab + "domtrans_pattern($1,aide_exec_t,aide_t)");
	lines_break += tab + "role $2 types aide_t;";
	lines_break += tab + "allow aide_t $3:chr_file rw_chr_file_perms;";
}
QRegExp rx_amavis_spool_filetrans("amavis_spool_filetrans");
if(line_analized.find( rx_amavis_spool_filetrans, 0) != -1){
	line_analized.replace("amavis_spool_filetrans",tab + "manage_files_pattern($1,amavis_spool_t,amavis_spool_t)");
	lines_break += tab + "filetrans_pattern($1,amavis_spool_t,$2,$3)";
	lines_break += tab + "filetrans_pattern($1,amavis_spool_t,$2,$3)";
}
QRegExp rx_apache_run_helper("apache_run_helper");
if(line_analized.find( rx_apache_run_helper, 0) != -1){
	line_analized.replace("apache_run_helper",tab + "domtrans_pattern($1,httpd_helper_exec_t,httpd_helper_t)");
	lines_break += tab + "role $2 types httpd_helper_t;";
	lines_break += tab + "allow httpd_helper_t $3:chr_file rw_term_perms;";
}
QRegExp rx_apache_run_all_scripts("apache_run_all_scripts");
if(line_analized.find( rx_apache_run_all_scripts, 0) != -1){
	line_analized.replace("apache_run_all_scripts",tab + "typeattribute $1 httpd_exec_scripts;");
	lines_break += tab + "role $2 types httpd_script_domains;";
}
QRegExp rx_apache_cgi_domain("apache_cgi_domain");
if(line_analized.find( rx_apache_cgi_domain, 0) != -1){
	line_analized.replace("apache_cgi_domain",tab + "allow $1 httpd_sys_script_t:dir search_dir_perms;");
	lines_break += tab + "domtrans_pattern(httpd_t, $2, $1)";
}
QRegExp rx_bind_run_ndc("bind_run_ndc");
if(line_analized.find( rx_bind_run_ndc, 0) != -1){
	line_analized.replace("bind_run_ndc",tab + "allow $1 named_t:process signal;");
	lines_break += tab + "role $2 types ndc_t;";
	lines_break += tab + "allow ndc_t $3:chr_file rw_term_perms;";
}
QRegExp rx_bluetooth_run_helper("bluetooth_run_helper");
if(line_analized.find( rx_bluetooth_run_helper, 0) != -1){
	line_analized.replace("bluetooth_run_helper",tab + "allow bluetooth_t $1:dbus send_msg;");
	lines_break += tab + "role $2 types bluetooth_helper_t;";
	lines_break += tab + "allow bluetooth_helper_t $3:chr_file rw_term_perms;";
}
QRegExp rx_clockspeed_run_cli("clockspeed_run_cli");
if(line_analized.find( rx_clockspeed_run_cli, 0) != -1){
	line_analized.replace("clockspeed_run_cli",tab + "domtrans_pattern($1, clockspeed_cli_exec_t, clockspeed_cli_t)");
	lines_break += tab + "role $2 types clockspeed_cli_t;";
	lines_break += tab + "allow clockspeed_cli_t $3:chr_file { getattr read write ioctl };";
}
QRegExp rx_cron_system_entry("cron_system_entry");
if(line_analized.find( rx_cron_system_entry, 0) != -1){
	line_analized.replace("cron_system_entry",tab + "selinux_get_fs_mount($1_crontab_t)");
	lines_break += tab + "domain_auto_trans(system_crond_t, $2, $1)";
}
QRegExp rx_dcc_run_cdcc("dcc_run_cdcc");
if(line_analized.find( rx_dcc_run_cdcc, 0) != -1){
	line_analized.replace("dcc_run_cdcc",tab + "domtrans_pattern($1,cdcc_exec_t,cdcc_t)");
	lines_break += tab + "role $2 types cdcc_t;";
	lines_break += tab + "allow cdcc_t $3:chr_file rw_term_perms;";
}
QRegExp rx_dcc_run_client("dcc_run_client");
if(line_analized.find( rx_dcc_run_client, 0) != -1){
	line_analized.replace("dcc_run_client",tab + "domtrans_pattern($1,dcc_client_exec_t,dcc_client_t)");
	lines_break += tab + "role $2 types dcc_client_t;";
	lines_break += tab + "allow dcc_client_t $3:chr_file rw_term_perms;";
}
QRegExp rx_dcc_run_dbclean("dcc_run_dbclean");
if(line_analized.find( rx_dcc_run_dbclean, 0) != -1){
	line_analized.replace("dcc_run_dbclean",tab + "domtrans_pattern($1,dcc_dbclean_exec_t,dcc_dbclean_t)");
	lines_break += tab + "role $2 types dcc_dbclean_t;";
	lines_break += tab + "allow dcc_dbclean_t $3:chr_file rw_term_perms;";
}
QRegExp rx_inetd_core_service_domain("inetd_core_service_domain");
if(line_analized.find( rx_inetd_core_service_domain, 0) != -1){
	line_analized.replace("inetd_core_service_domain",tab + "allow $1 howl_t:process signal;");
	lines_break += tab + "domain_entry_file($1,$2)";
	lines_break += tab + "domtrans_pattern(inetd_t,$2,$1)";
}
QRegExp rx_inetd_tcp_service_domain("inetd_tcp_service_domain");
if(line_analized.find( rx_inetd_tcp_service_domain, 0) != -1){
	line_analized.replace("inetd_tcp_service_domain",tab + "allow inetd_t $1:process sigkill;");
	lines_break += tab + "inetd_core_service_domain($1,$2)";
}
QRegExp rx_inetd_udp_service_domain("inetd_udp_service_domain");
if(line_analized.find( rx_inetd_udp_service_domain, 0) != -1){
	line_analized.replace("inetd_udp_service_domain",tab + "allow $1 inetd_t:tcp_socket rw_stream_socket_perms;");
	lines_break += tab + "inetd_core_service_domain($1,$2)";
}
QRegExp rx_inetd_service_domain("inetd_service_domain");
if(line_analized.find( rx_inetd_service_domain, 0) != -1){
	line_analized.replace("inetd_service_domain",tab + "allow $1 inetd_t:udp_socket rw_socket_perms;");
	lines_break += tab + "inetd_core_service_domain($1,$2)";
}
QRegExp rx_lpd_run_checkpc("lpd_run_checkpc");
if(line_analized.find( rx_lpd_run_checkpc, 0) != -1){
	line_analized.replace("lpd_run_checkpc",tab + "domtrans_pattern($1,checkpc_exec_t,checkpc_t)");
	lines_break += tab + "role $2 types checkpc_t;";
	lines_break += tab + "allow checkpc_t $3:chr_file rw_term_perms;";
}
QRegExp rx_mta_mailserver("mta_mailserver");
if(line_analized.find( rx_mta_mailserver, 0) != -1){
	line_analized.replace("mta_mailserver",tab + "postfix_config_filetrans($1_mail_t,etc_aliases_t,{ dir file lnk_file sock_file fifo_file })");
	lines_break += tab + "init_daemon_domain($1,$2)";
}
QRegExp rx_mta_sendmail_domtrans("mta_sendmail_domtrans");
if(line_analized.find( rx_mta_sendmail_domtrans, 0) != -1){
	line_analized.replace("mta_sendmail_domtrans",tab + "allow mta_user_agent $1:fifo_file { read write };");
	lines_break += tab + "domain_auto_trans($1,sendmail_exec_t,$2)";
}
QRegExp rx_mta_spool_filetrans("mta_spool_filetrans");
if(line_analized.find( rx_mta_spool_filetrans, 0) != -1){
	line_analized.replace("mta_spool_filetrans",tab + "dontaudit $1 mail_spool_t:file getattr;");
	lines_break += tab + "filetrans_pattern($1,mail_spool_t,$2,$3)";
	lines_break += tab + "filetrans_pattern($1,mail_spool_t,$2,$3)";
}
QRegExp rx_nscd_run("nscd_run");
if(line_analized.find( rx_nscd_run, 0) != -1){
	line_analized.replace("nscd_run",tab + "allow $1 nscd_t:nscd *;");
	lines_break += tab + "role $2 types nscd_t;";
	lines_break += tab + "dontaudit nscd_t $3:chr_file rw_term_perms;";
}
QRegExp rx_oav_run_update("oav_run_update");
if(line_analized.find( rx_oav_run_update, 0) != -1){
	line_analized.replace("oav_run_update",tab + "domtrans_pattern($1,oav_update_exec_t,oav_update_t)");
	lines_break += tab + "role $2 types oav_update_t;";
	lines_break += tab + "allow oav_update_t $3:chr_file rw_term_perms;";
}
QRegExp rx_openvpn_run("openvpn_run");
if(line_analized.find( rx_openvpn_run, 0) != -1){
	line_analized.replace("openvpn_run",tab + "domtrans_pattern($1, openvpn_exec_t, openvpn_t)");
	lines_break += tab + "role $2 types openvpn_t;";
	lines_break += tab + "allow openvpn_t $3:chr_file rw_term_perms;";
}
QRegExp rx_portmap_run_helper("portmap_run_helper");
if(line_analized.find( rx_portmap_run_helper, 0) != -1){
	line_analized.replace("portmap_run_helper",tab + "domtrans_pattern($1,portmap_helper_exec_t,portmap_helper_t)");
	lines_break += tab + "role $2 types portmap_helper_t;";
	lines_break += tab + "allow portmap_helper_t $3:chr_file { getattr read write ioctl };";
}
QRegExp rx_postfix_config_filetrans("postfix_config_filetrans");
if(line_analized.find( rx_postfix_config_filetrans, 0) != -1){
	line_analized.replace("postfix_config_filetrans",tab + "files_search_etc($1)");
	lines_break += tab + "filetrans_pattern($1,postfix_etc_t,$2,$3)";
	lines_break += tab + "filetrans_pattern($1,postfix_etc_t,$2,$3)";
}
QRegExp rx_postfix_run_map("postfix_run_map");
if(line_analized.find( rx_postfix_run_map, 0) != -1){
	line_analized.replace("postfix_run_map",tab + "domtrans_pattern($1,postfix_map_exec_t,postfix_map_t)");
	lines_break += tab + "role $2 types postfix_map_t;";
	lines_break += tab + "allow postfix_map_t $3:chr_file rw_term_perms;";
}
QRegExp rx_ppp_run_cond("ppp_run_cond");
if(line_analized.find( rx_ppp_run_cond, 0) != -1){
	line_analized.replace("ppp_run_cond",tab + "domtrans_pattern($1, pppd_exec_t, pppd_t)");
	lines_break += tab + "role $2 types pppd_t;";
	lines_break += tab + "allow pppd_t $3:chr_file rw_term_perms;";
}
QRegExp rx_ppp_run("ppp_run");
if(line_analized.find( rx_ppp_run, 0) != -1){
	line_analized.replace("ppp_run",tab + "ppp_domtrans($1)");
	lines_break += tab + "role $2 types pppd_t;";
	lines_break += tab + "allow pppd_t $3:chr_file rw_term_perms;";
}
QRegExp rx_qmail_smtpd_service_domain("qmail_smtpd_service_domain");
if(line_analized.find( rx_qmail_smtpd_service_domain, 0) != -1){
	line_analized.replace("qmail_smtpd_service_domain",tab + "files_search_etc($1)");
	lines_break += tab + "domtrans_pattern(qmail_smtpd_t, $2, $1)";
}
QRegExp rx_rsync_entry_spec_domtrans("rsync_entry_spec_domtrans");
if(line_analized.find( rx_rsync_entry_spec_domtrans, 0) != -1){
	line_analized.replace("rsync_entry_spec_domtrans",tab + "domain_entry_file($1,rsync_exec_t)");
	lines_break += tab + "domain_trans($1,rsync_exec_t,$2)";
}
QRegExp rx_rsync_entry_domtrans("rsync_entry_domtrans");
if(line_analized.find( rx_rsync_entry_domtrans, 0) != -1){
	line_analized.replace("rsync_entry_domtrans",tab + "domain_trans($1,rsync_exec_t,$2)");
	lines_break += tab + "domain_auto_trans($1,rsync_exec_t,$2)";
}
QRegExp rx_samba_run_net("samba_run_net");
if(line_analized.find( rx_samba_run_net, 0) != -1){
	line_analized.replace("samba_run_net",tab + "domtrans_pattern($1,samba_net_exec_t,samba_net_t)");
	lines_break += tab + "role $2 types samba_net_t;";
	lines_break += tab + "allow samba_net_t $3:chr_file rw_term_perms;";
}
QRegExp rx_samba_run_winbind_helper("samba_run_winbind_helper");
if(line_analized.find( rx_samba_run_winbind_helper, 0) != -1){
	line_analized.replace("samba_run_winbind_helper",tab + "domtrans_pattern($1,winbind_helper_exec_t,winbind_helper_t)");
	lines_break += tab + "role $2 types winbind_helper_t;";
	lines_break += tab + "allow winbind_helper_t $3:chr_file rw_term_perms;";
}
QRegExp rx_tcpd_wrapped_domain("tcpd_wrapped_domain");
if(line_analized.find( rx_tcpd_wrapped_domain, 0) != -1){
	line_analized.replace("tcpd_wrapped_domain",tab + "domtrans_pattern($1, tcpd_exec_t, tcpd_t)");
	lines_break += tab + "domtrans_pattern(tcpd_t, $2, $1)";
}
QRegExp rx_ucspitcp_service_domain("ucspitcp_service_domain");
if(line_analized.find( rx_ucspitcp_service_domain, 0) != -1){
	line_analized.replace("ucspitcp_service_domain', `",tab + "domtrans_pattern($1,tor_exec_t,tor_t)");
	lines_break += tab + "domain_entry_file($1,$2)";
	lines_break += tab + "domain_auto_trans(ucspitcp_t, $2, $1)";
}
QRegExp rx_xserver_xsession_spec_domtrans("xserver_xsession_spec_domtrans");
if(line_analized.find( rx_xserver_xsession_spec_domtrans, 0) != -1){
	line_analized.replace("xserver_xsession_spec_domtrans",tab + "domain_entry_file($1,xsession_exec_t)");
	lines_break += tab + "domain_trans($1,xsession_exec_t,$2)";
}

					
					
					/////////////////misc//////////////////////
					//can_exec...					
					if(line_analized.find( rx_can_exec, 0) != -1){
					        line_analized.replace("can_exec($1,",tab + "allow $1 ");
					        line_analized.replace(")",":file { read getattr lock execute ioctl execute_no_trans };");
						lines_break += line_analized;
					}
					//misc patterns...
					//domtrans_pattern
					if(line_analized.find( rx_domtrans_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );					    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), " " );
						
						lines_break += tab + "allow " + first_var + " " + second_var + ":file { getattr read execute };";
						lines_break += tab + "allow " + first_var + " " + third_var + ":process transition;";
						lines_break += tab + "dontaudit " + first_var + " " + third_var + ":process { noatsecure siginh rlimitinh };";
						lines_break += tab + "type_transition " + first_var + " " + second_var +":process" + " " + third_var + ";";						
						lines_break += tab + "allow " + third_var + first_var + ":fd use;";
						lines_break += tab + "allow " + third_var + first_var + ":fifo_file { getattr read write append ioctl lock };";
						lines_break += tab + "allow " + third_var + first_var + ":process sigchld;";
					}
					//spec_domtrans_pattern
					if(line_analized.find( rx_spec_domtrans_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );					    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), " " );

						lines_break += tab + "allow " + first_var + " "+ "self:process setexec;";
						lines_break += tab + "allow " + first_var + " " + second_var + ":file { getattr read execute };";
						lines_break += tab + "allow " + first_var + " " + third_var + ":process transition;";
						lines_break += tab + "dontaudit " + first_var + " " + third_var +":process { noatsecure siginh rlimitinh };";						
						lines_break += tab + "allow " + third_var + first_var + ":fd use;";
						lines_break += tab + "allow " + third_var + first_var + ":fifo_file { getattr read write append ioctl lock };";
						lines_break += tab + "allow " + third_var + first_var + ":process sigchld;";
					}
					/////////////////////////core patterns///////////////////////////////////////////////////
					//corecmd_search_bin
					/////////////////////////end-core patterns////////////////////////////////////////////////
					/////////////////////////kernel interfaces////////////////////////////////////////////////
					//check number by less interface_kernel_prepare.txt|grep add_number =16; above.
					QString raw_interface_name,interface_name_with_var,add0,add1,add2,add3,add4,add5,add6,add7,add8,add9,add10,add11,add12,add13,add14,add15,add16;
					int add_number;
					add_number=0;
					//change number when argmented by new refpolicy.
					for(iii=0;iii<=3644;iii++){
					    //cout << "test" << endl;
					    //copy and past interface_kernel_prepare.txt here.
if(iii==0){
	add_number=0;
	raw_interface_name="corecmd_executable_file";
	add0="typeattribute $1 exec_type;";
	add1="files_type($1)";
	add_number =1;
}
if(iii==1){
	add_number=0;
	raw_interface_name="corecmd_bin_alias";
	add0="typealias bin_t alias $1;";
}
if(iii==2){
	add_number=0;
	raw_interface_name="corecmd_bin_entry_type";
	add0="domain_entry_file($1,bin_t)";
}
if(iii==3){
	add_number=0;
	raw_interface_name="corecmd_sbin_entry_type";
	add0="corecmd_bin_entry_type($1)";
}
if(iii==4){
	add_number=0;
	raw_interface_name="corecmd_shell_entry_type";
	add0="domain_entry_file($1,shell_exec_t)";
}
if(iii==5){
	add_number=0;
	raw_interface_name="corecmd_search_bin";
	add0="search_dirs_pattern($1,bin_t,bin_t)";
}
if(iii==6){
	add_number=0;
	raw_interface_name="corecmd_dontaudit_search_bin";
	add0="dontaudit $1 bin_t:dir search_dir_perms;";
}
if(iii==7){
	add_number=0;
	raw_interface_name="corecmd_list_bin";
	add0="list_dirs_pattern($1,bin_t,bin_t)";
}
if(iii==8){
	add_number=0;
	raw_interface_name="corecmd_dontaudit_write_bin_dirs";
	add0="dontaudit $1 bin_t:dir write;";
}
if(iii==9){
	add_number=0;
	raw_interface_name="corecmd_getattr_bin_files";
	add0="getattr_files_pattern($1,bin_t,bin_t)";
}
if(iii==10){
	add_number=0;
	raw_interface_name="corecmd_read_bin_files";
	add0="read_files_pattern($1,bin_t,bin_t)";
}
if(iii==11){
	add_number=0;
	raw_interface_name="corecmd_read_bin_symlinks";
	add0="read_lnk_files_pattern($1,bin_t,bin_t)";
}
if(iii==12){
	add_number=0;
	raw_interface_name="corecmd_read_bin_pipes";
	add0="read_fifo_files_pattern($1,bin_t,bin_t)";
}
if(iii==13){
	add_number=0;
	raw_interface_name="corecmd_read_bin_sockets";
	add0="read_sock_files_pattern($1,bin_t,bin_t)";
}
if(iii==14){
	add_number=0;
	raw_interface_name="corecmd_exec_bin";
	add0="read_lnk_files_pattern($1,bin_t,bin_t)";
	add1="list_dirs_pattern($1,bin_t,bin_t)";
	add_number =1;
	add2="allow $1 bin_t:file { read getattr lock execute ioctl execute_no_trans };";
	add_number =2;
	add3="allow $1 bin_t:file { read getattr lock execute ioctl execute_no_trans };";
	add_number =3;
}
if(iii==15){
	add_number=0;
	raw_interface_name="corecmd_manage_bin_files";
	add0="manage_files_pattern($1,bin_t,bin_t)";
}
if(iii==16){
	add_number=0;
	raw_interface_name="corecmd_relabel_bin_files";
	add0="relabel_files_pattern($1,bin_t,bin_t)";
}
if(iii==17){
	add_number=0;
	raw_interface_name="corecmd_mmap_bin_files";
	add0="allow $1 bin_t:dir search_dir_perms;";
	add1="allow $1 bin_t:file { getattr read execute };";
	add_number =1;
}
if(iii==18){
	add_number=0;
	raw_interface_name="corecmd_bin_spec_domtrans";
	add0="read_lnk_files_pattern($1,bin_t,bin_t)";
	add1="domain_transition_pattern($1,bin_t,$2)";
	add_number =1;
	add2="domain_transition_pattern($1,bin_t,$2)";
	add_number =2;
}
if(iii==19){
	add_number=0;
	raw_interface_name="corecmd_bin_domtrans";
	add0="corecmd_bin_spec_domtrans($1,$2)";
	add1="corecmd_bin_spec_domtrans($1,$2)";
	add_number =1;
	add2="type_transition $1 bin_t:process $2;";
	add_number =2;
	add3="type_transition $1 bin_t:process $2;";
	add_number =3;
}
if(iii==20){
	add_number=0;
	raw_interface_name="corecmd_search_sbin";
	add0="corecmd_search_bin($1)";
}
if(iii==21){
	add_number=0;
	raw_interface_name="corecmd_dontaudit_search_sbin";
	add0="corecmd_dontaudit_search_bin($1)";
}
if(iii==22){
	add_number=0;
	raw_interface_name="corecmd_list_sbin";
	add0="corecmd_list_bin($1)";
}
if(iii==23){
	add_number=0;
	raw_interface_name="corecmd_dontaudit_write_sbin_dirs";
	add0="corecmd_dontaudit_write_bin_dirs($1)";
}
if(iii==24){
	add_number=0;
	raw_interface_name="corecmd_getattr_sbin_files";
	add0="corecmd_getattr_bin_files($1)";
}
if(iii==25){
	add_number=0;
	raw_interface_name="corecmd_dontaudit_getattr_sbin_files";
	add0="corecmd_dontaudit_getattr_bin_files($1)";
}
if(iii==26){
	add_number=0;
	raw_interface_name="corecmd_read_sbin_files";
	add0="corecmd_read_bin_files($1)";
}
if(iii==27){
	add_number=0;
	raw_interface_name="corecmd_read_sbin_symlinks";
	add0="corecmd_read_bin_symlinks($1)";
}
if(iii==28){
	add_number=0;
	raw_interface_name="corecmd_read_sbin_pipes";
	add0="corecmd_read_bin_pipes($1)";
}
if(iii==29){
	add_number=0;
	raw_interface_name="corecmd_read_sbin_sockets";
	add0="corecmd_read_bin_sockets($1)";
}
if(iii==30){
	add_number=0;
	raw_interface_name="corecmd_exec_sbin";
	add0="corecmd_exec_bin($1)";
}
if(iii==31){
	add_number=0;
	raw_interface_name="corecmd_manage_sbin_files";
	add0="corecmd_manage_bin_files($1)";
}
if(iii==32){
	add_number=0;
	raw_interface_name="corecmd_relabel_sbin_files";
	add0="corecmd_relabel_bin_files($1)";
}
if(iii==33){
	add_number=0;
	raw_interface_name="corecmd_mmap_sbin_files";
	add0="corecmd_mmap_bin_files($1)";
}
if(iii==34){
	add_number=0;
	raw_interface_name="corecmd_sbin_domtrans";
	add0="corecmd_bin_domtrans($1,$2,$3)";
	add1="corecmd_bin_domtrans($1,$2,$3)";
	add_number =1;
	add2="corecmd_bin_domtrans($1,$2,$3)";
	add_number =2;
}
if(iii==35){
	add_number=0;
	raw_interface_name="corecmd_sbin_spec_domtrans";
	add0="corecmd_bin_spec_domtrans($1,$2,$3)";
	add1="corecmd_bin_spec_domtrans($1,$2,$3)";
	add_number =1;
	add2="corecmd_bin_spec_domtrans($1,$2,$3)";
	add_number =2;
}
if(iii==36){
	add_number=0;
	raw_interface_name="corecmd_check_exec_shell";
	add0="list_dirs_pattern($1,bin_t,bin_t)";
	add1="read_lnk_files_pattern($1,bin_t,bin_t)";
	add_number =1;
	add2="allow $1 shell_exec_t:file execute;";
	add_number =2;
}
if(iii==37){
	add_number=0;
	raw_interface_name="corecmd_exec_shell";
	add0="list_dirs_pattern($1,bin_t,bin_t)";
	add1="read_lnk_files_pattern($1,bin_t,bin_t)";
	add_number =1;
	add2="allow $1 shell_exec_t:file { read getattr lock execute ioctl execute_no_trans };";
	add_number =2;
	add3="allow $1 shell_exec_t:file { read getattr lock execute ioctl execute_no_trans };";
	add_number =3;
}
if(iii==38){
	add_number=0;
	raw_interface_name="corecmd_exec_ls";
	add0="corecmd_exec_bin($1)";
}
if(iii==39){
	add_number=0;
	raw_interface_name="corecmd_shell_spec_domtrans";
	add0="list_dirs_pattern($1,bin_t,bin_t)";
	add1="read_lnk_files_pattern($1,bin_t,bin_t)";
	add_number =1;
	add2="domain_transition_pattern($1,shell_exec_t,$2)";
	add_number =2;
	add3="domain_transition_pattern($1,shell_exec_t,$2)";
	add_number =3;
}
if(iii==40){
	add_number=0;
	raw_interface_name="corecmd_shell_domtrans";
	add0="corecmd_shell_spec_domtrans($1,$2)";
	add1="corecmd_shell_spec_domtrans($1,$2)";
	add_number =1;
	add2="type_transition $1 shell_exec_t:process $2;";
	add_number =2;
	add3="type_transition $1 shell_exec_t:process $2;";
	add_number =3;
}
if(iii==41){
	add_number=0;
	raw_interface_name="corecmd_exec_chroot";
	add0="read_lnk_files_pattern($1,bin_t,bin_t)";
	add1="allow $1 chroot_exec_t:file { read getattr lock execute ioctl execute_no_trans };";
	add_number =1;
	add2="allow $1 chroot_exec_t:file { read getattr lock execute ioctl execute_no_trans };";
	add_number =2;
	add3="allow $1 self:capability sys_chroot;";
	add_number =3;
}
if(iii==42){
	add_number=0;
	raw_interface_name="corecmd_getattr_all_executables";
	add0="allow $1 bin_t:dir list_dir_perms;";
	add1="getattr_files_pattern($1,bin_t,exec_type)";
	add_number =1;
}
if(iii==43){
	add_number=0;
	raw_interface_name="corecmd_exec_all_executables";
	add0="allow $1 exec_type:file { read getattr lock execute ioctl execute_no_trans };";
	add1="allow $1 exec_type:file { read getattr lock execute ioctl execute_no_trans };";
	add_number =1;
	add2="list_dirs_pattern($1,bin_t,bin_t)";
	add_number =2;
	add3="read_lnk_files_pattern($1,bin_t,exec_type)";
	add_number =3;
}
if(iii==44){
	add_number=0;
	raw_interface_name="corecmd_dontaudit_exec_all_executables";
	add0="dontaudit $1 exec_type:file { execute execute_no_trans };";
}
if(iii==45){
	add_number=0;
	raw_interface_name="corecmd_manage_all_executables";
	add0="manage_files_pattern($1,bin_t,exec_type)";
	add1="manage_lnk_files_pattern($1,bin_t,bin_t)";
	add_number =1;
}
if(iii==46){
	add_number=0;
	raw_interface_name="corecmd_relabel_all_executables";
	add0="relabel_files_pattern($1,bin_t,exec_type)";
}
if(iii==47){
	add_number=0;
	raw_interface_name="corecmd_mmap_all_executables";
	add0="mmap_files_pattern($1,bin_t,exec_type)";
	add1=":corenetwork.if";
	add_number =1;
}
if(iii==48){
	add_number=0;
	raw_interface_name="corenet_port";
	add0="typeattribute $1 port_type;";
}
if(iii==49){
	add_number=0;
	raw_interface_name="corenet_reserved_port";
	add0="typeattribute $1 reserved_port_type;";
}
if(iii==50){
	add_number=0;
	raw_interface_name="corenet_rpc_port";
	add0="typeattribute $1 rpc_port_type;";
}
if(iii==51){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_generic_if";
	add0="allow $1 netif_t:netif { tcp_send tcp_recv };";
}
if(iii==52){
	add_number=0;
	raw_interface_name="corenet_udp_send_generic_if";
	add0="allow $1 netif_t:netif udp_send;";
}
if(iii==53){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_generic_if";
	add0="dontaudit $1 netif_t:netif udp_send;";
}
if(iii==54){
	add_number=0;
	raw_interface_name="corenet_udp_receive_generic_if";
	add0="allow $1 netif_t:netif udp_recv;";
}
if(iii==55){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_generic_if";
	add0="dontaudit $1 netif_t:netif udp_recv;";
}
if(iii==56){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_generic_if";
	add0="corenet_udp_send_generic_if($1)";
	add1="corenet_udp_receive_generic_if($1)";
	add_number =1;
}
if(iii==57){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_generic_if";
	add0="corenet_dontaudit_udp_send_generic_if($1)";
	add1="corenet_dontaudit_udp_receive_generic_if($1)";
	add_number =1;
}
if(iii==58){
	add_number=0;
	raw_interface_name="corenet_raw_send_generic_if";
	add0="allow $1 netif_t:netif rawip_send;";
}
if(iii==59){
	add_number=0;
	raw_interface_name="corenet_raw_receive_generic_if";
	add0="allow $1 netif_t:netif rawip_recv;";
}
if(iii==60){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_generic_if";
	add0="corenet_raw_send_generic_if($1)";
	add1="corenet_raw_receive_generic_if($1)";
	add_number =1;
}
if(iii==61){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_all_if";
	add0="allow $1 netif_type:netif { tcp_send tcp_recv };";
}
if(iii==62){
	add_number=0;
	raw_interface_name="corenet_udp_send_all_if";
	add0="allow $1 netif_type:netif udp_send;";
}
if(iii==63){
	add_number=0;
	raw_interface_name="corenet_udp_receive_all_if";
	add0="allow $1 netif_type:netif udp_recv;";
}
if(iii==64){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_all_if";
	add0="corenet_udp_send_all_if($1)";
	add1="corenet_udp_receive_all_if($1)";
	add_number =1;
}
if(iii==65){
	add_number=0;
	raw_interface_name="corenet_raw_send_all_if";
	add0="allow $1 netif_type:netif rawip_send;";
}
if(iii==66){
	add_number=0;
	raw_interface_name="corenet_raw_receive_all_if";
	add0="allow $1 netif_type:netif rawip_recv;";
}
if(iii==67){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_all_if";
	add0="corenet_raw_send_all_if($1)";
	add1="corenet_raw_receive_all_if($1)";
	add_number =1;
}
if(iii==68){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_generic_node";
	add0="allow $1 node_t:node { tcp_send tcp_recv };";
}
if(iii==69){
	add_number=0;
	raw_interface_name="corenet_udp_send_generic_node";
	add0="allow $1 node_t:node udp_send;";
}
if(iii==70){
	add_number=0;
	raw_interface_name="corenet_udp_receive_generic_node";
	add0="allow $1 node_t:node udp_recv;";
}
if(iii==71){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_generic_node";
	add0="corenet_udp_send_generic_node($1)";
	add1="corenet_udp_receive_generic_node($1)";
	add_number =1;
}
if(iii==72){
	add_number=0;
	raw_interface_name="corenet_raw_send_generic_node";
	add0="allow $1 node_t:node rawip_send;";
}
if(iii==73){
	add_number=0;
	raw_interface_name="corenet_raw_receive_generic_node";
	add0="allow $1 node_t:node rawip_recv;";
}
if(iii==74){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_generic_node";
	add0="corenet_raw_send_generic_node($1)";
	add1="corenet_raw_receive_generic_node($1)";
	add_number =1;
}
if(iii==75){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_generic_node";
	add0="allow $1 node_t:tcp_socket node_bind;";
}
if(iii==76){
	add_number=0;
	raw_interface_name="corenet_udp_bind_generic_node";
	add0="allow $1 node_t:udp_socket node_bind;";
}
if(iii==77){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_all_nodes";
	add0="allow $1 node_type:node { tcp_send tcp_recv };";
}
if(iii==78){
	add_number=0;
	raw_interface_name="corenet_udp_send_all_nodes";
	add0="allow $1 node_type:node udp_send;";
}
if(iii==79){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_all_nodes";
	add0="dontaudit $1 node_type:node udp_send;";
}
if(iii==80){
	add_number=0;
	raw_interface_name="corenet_udp_receive_all_nodes";
	add0="allow $1 node_type:node udp_recv;";
}
if(iii==81){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_all_nodes";
	add0="dontaudit $1 node_type:node udp_recv;";
}
if(iii==82){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_all_nodes";
	add0="corenet_udp_send_all_nodes($1)";
	add1="corenet_udp_receive_all_nodes($1)";
	add_number =1;
}
if(iii==83){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_all_nodes";
	add0="corenet_dontaudit_udp_send_all_nodes($1)";
	add1="corenet_dontaudit_udp_receive_all_nodes($1)";
	add_number =1;
}
if(iii==84){
	add_number=0;
	raw_interface_name="corenet_raw_send_all_nodes";
	add0="allow $1 node_type:node rawip_send;";
}
if(iii==85){
	add_number=0;
	raw_interface_name="corenet_raw_receive_all_nodes";
	add0="allow $1 node_type:node rawip_recv;";
}
if(iii==86){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_all_nodes";
	add0="corenet_raw_send_all_nodes($1)";
	add1="corenet_raw_receive_all_nodes($1)";
	add_number =1;
}
if(iii==87){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_all_nodes";
	add0="allow $1 node_type:tcp_socket node_bind;";
}
if(iii==88){
	add_number=0;
	raw_interface_name="corenet_udp_bind_all_nodes";
	add0="allow $1 node_type:udp_socket node_bind;";
}
if(iii==89){
	add_number=0;
	raw_interface_name="corenet_raw_bind_all_nodes";
	add0="allow $1 node_type:rawip_socket node_bind;";
}
if(iii==90){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_generic_port";
	add0="allow $1 port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==91){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_sendrecv_generic_port";
	add0="dontaudit $1 port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==92){
	add_number=0;
	raw_interface_name="corenet_udp_send_generic_port";
	add0="allow $1 port_t:udp_socket send_msg;";
}
if(iii==93){
	add_number=0;
	raw_interface_name="corenet_udp_receive_generic_port";
	add0="allow $1 port_t:udp_socket recv_msg;";
}
if(iii==94){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_generic_port";
	add0="corenet_udp_send_generic_port($1)";
	add1="corenet_udp_receive_generic_port($1)";
	add_number =1;
}
if(iii==95){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_generic_port";
	add0="allow $1 port_t:tcp_socket name_bind;";
}
if(iii==96){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_bind_generic_port";
	add0="dontaudit $1 port_t:tcp_socket name_bind;";
}
if(iii==97){
	add_number=0;
	raw_interface_name="corenet_udp_bind_generic_port";
	add0="allow $1 port_t:udp_socket name_bind;";
}
if(iii==98){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_generic_port";
	add0="allow $1 port_t:tcp_socket name_connect;";
}
if(iii==99){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_all_ports";
	add0="allow $1 port_type:tcp_socket { send_msg recv_msg };";
}
if(iii==100){
	add_number=0;
	raw_interface_name="corenet_udp_send_all_ports";
	add0="allow $1 port_type:udp_socket send_msg;";
}
if(iii==101){
	add_number=0;
	raw_interface_name="corenet_udp_receive_all_ports";
	add0="allow $1 port_type:udp_socket recv_msg;";
}
if(iii==102){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_all_ports";
	add0="corenet_udp_send_all_ports($1)";
	add1="corenet_udp_receive_all_ports($1)";
	add_number =1;
}
if(iii==103){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_all_ports";
	add0="allow $1 port_type:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==104){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_bind_all_ports";
	add0="dontaudit $1 port_type:tcp_socket name_bind;";
}
if(iii==105){
	add_number=0;
	raw_interface_name="corenet_udp_bind_all_ports";
	add0="allow $1 port_type:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==106){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_bind_all_ports";
	add0="dontaudit $1 port_type:udp_socket name_bind;";
}
if(iii==107){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_all_ports";
	add0="allow $1 port_type:tcp_socket name_connect;";
}
if(iii==108){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_connect_all_ports";
	add0="dontaudit $1 port_type:tcp_socket name_connect;";
}
if(iii==109){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_reserved_port";
	add0="allow $1 reserved_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==110){
	add_number=0;
	raw_interface_name="corenet_udp_send_reserved_port";
	add0="allow $1 reserved_port_t:udp_socket send_msg;";
}
if(iii==111){
	add_number=0;
	raw_interface_name="corenet_udp_receive_reserved_port";
	add0="allow $1 reserved_port_t:udp_socket recv_msg;";
}
if(iii==112){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_reserved_port";
	add0="corenet_udp_send_reserved_port($1)";
	add1="corenet_udp_receive_reserved_port($1)";
	add_number =1;
}
if(iii==113){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_reserved_port";
	add0="allow $1 reserved_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==114){
	add_number=0;
	raw_interface_name="corenet_udp_bind_reserved_port";
	add0="allow $1 reserved_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==115){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_reserved_port";
	add0="allow $1 reserved_port_t:tcp_socket name_connect;";
}
if(iii==116){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_all_reserved_ports";
	add0="allow $1 reserved_port_type:tcp_socket { send_msg recv_msg };";
}
if(iii==117){
	add_number=0;
	raw_interface_name="corenet_udp_send_all_reserved_ports";
	add0="allow $1 reserved_port_type:udp_socket send_msg;";
}
if(iii==118){
	add_number=0;
	raw_interface_name="corenet_udp_receive_all_reserved_ports";
	add0="allow $1 reserved_port_type:udp_socket recv_msg;";
}
if(iii==119){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_all_reserved_ports";
	add0="corenet_udp_send_all_reserved_ports($1)";
	add1="corenet_udp_receive_all_reserved_ports($1)";
	add_number =1;
}
if(iii==120){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_all_reserved_ports";
	add0="allow $1 reserved_port_type:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==121){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_bind_all_reserved_ports";
	add0="dontaudit $1 reserved_port_type:tcp_socket name_bind;";
}
if(iii==122){
	add_number=0;
	raw_interface_name="corenet_udp_bind_all_reserved_ports";
	add0="allow $1 reserved_port_type:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==123){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_bind_all_reserved_ports";
	add0="dontaudit $1 reserved_port_type:udp_socket name_bind;";
}
if(iii==124){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_all_unreserved_ports";
	add0="allow $1 { port_type -reserved_port_type }:tcp_socket name_bind;";
}
if(iii==125){
	add_number=0;
	raw_interface_name="corenet_udp_bind_all_unreserved_ports";
	add0="allow $1 { port_type -reserved_port_type }:udp_socket name_bind;";
}
if(iii==126){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_all_reserved_ports";
	add0="allow $1 reserved_port_type:tcp_socket name_connect;";
}
if(iii==127){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_connect_all_reserved_ports";
	add0="dontaudit $1 reserved_port_type:tcp_socket name_connect;";
}
if(iii==128){
	add_number=0;
	raw_interface_name="corenet_rw_tun_tap_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tun_tap_device_t:chr_file { getattr read write ioctl  lock append };";
	add_number =1;
}
if(iii==129){
	add_number=0;
	raw_interface_name="corenet_rw_ppp_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ppp_device_t:chr_file rw_file_perms;";
	add_number =1;
}
if(iii==130){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_all_rpc_ports";
	add0="allow $1 rpc_port_type:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==131){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_bind_all_rpc_ports";
	add0="dontaudit $1 rpc_port_type:tcp_socket name_bind;";
}
if(iii==132){
	add_number=0;
	raw_interface_name="corenet_udp_bind_all_rpc_ports";
	add0="allow $1 rpc_port_type:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==133){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_bind_all_rpc_ports";
	add0="dontaudit $1 rpc_port_type:udp_socket name_bind;";
}
if(iii==134){
	add_number=0;
	raw_interface_name="corenet_non_ipsec_sendrecv";
	add0="corenet_all_recvfrom_unlabeled($1)";
}
if(iii==135){
	add_number=0;
	raw_interface_name="corenet_dontaudit_non_ipsec_sendrecv";
	add0="corenet_dontaudit_all_recvfrom_unlabeled($1)";
}
if(iii==136){
	add_number=0;
	raw_interface_name="corenet_tcp_recv_netlabel";
	add0="corenet_tcp_recvfrom_netlabel($1)";
}
if(iii==137){
	add_number=0;
	raw_interface_name="corenet_tcp_recvfrom_netlabel";
	add0="allow $1 netlabel_peer_t:tcp_socket recvfrom;";
}
if(iii==138){
	add_number=0;
	raw_interface_name="corenet_tcp_recvfrom_unlabeled";
	add0="kernel_tcp_recvfrom_unlabeled($1)";
	add1="kernel_sendrecv_unlabeled_association($1)";
	add_number =1;
}
if(iii==139){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_recv_netlabel";
	add0="corenet_dontaudit_tcp_recvfrom_netlabel($1)";
}
if(iii==140){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_recvfrom_netlabel";
	add0="dontaudit $1 netlabel_peer_t:tcp_socket recvfrom;";
}
if(iii==141){
	add_number=0;
	raw_interface_name="corenet_dontaudit_tcp_recvfrom_unlabeled";
	add0="kernel_dontaudit_tcp_recvfrom_unlabeled($1)";
	add1="kernel_dontaudit_sendrecv_unlabeled_association($1)";
	add_number =1;
}
if(iii==142){
	add_number=0;
	raw_interface_name="corenet_udp_recv_netlabel";
	add0="corenet_udp_recvfrom_netlabel($1)";
}
if(iii==143){
	add_number=0;
	raw_interface_name="corenet_udp_recvfrom_netlabel";
	add0="allow $1 netlabel_peer_t:udp_socket recvfrom;";
}
if(iii==144){
	add_number=0;
	raw_interface_name="corenet_udp_recvfrom_unlabeled";
	add0="kernel_udp_recvfrom_unlabeled($1)";
	add1="kernel_sendrecv_unlabeled_association($1)";
	add_number =1;
}
if(iii==145){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_recv_netlabel";
	add0="refpolicywarn(`$0($*) has been deprecated, use corenet_dontaudit_udp_recvfrom_netlabel($1) instead.')";
	add1="corenet_dontaudit_udp_recvfrom_netlabel($1)";
	add_number =1;
}
if(iii==146){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_recvfrom_netlabel";
	add0="dontaudit $1 netlabel_peer_t:udp_socket recvfrom;";
}
if(iii==147){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_recvfrom_unlabeled";
	add0="kernel_dontaudit_udp_recvfrom_unlabeled($1)";
	add1="kernel_dontaudit_sendrecv_unlabeled_association($1)";
	add_number =1;
}
if(iii==148){
	add_number=0;
	raw_interface_name="corenet_raw_recv_netlabel";
	add0="corenet_raw_recvfrom_netlabel($1)";
}
if(iii==149){
	add_number=0;
	raw_interface_name="corenet_raw_recvfrom_netlabel";
	add0="allow $1 netlabel_peer_t:rawip_socket recvfrom;";
}
if(iii==150){
	add_number=0;
	raw_interface_name="corenet_raw_recvfrom_unlabeled";
	add0="kernel_raw_recvfrom_unlabeled($1)";
	add1="kernel_sendrecv_unlabeled_association($1)";
	add_number =1;
}
if(iii==151){
	add_number=0;
	raw_interface_name="corenet_dontaudit_raw_recv_netlabel";
	add0="corenet_dontaudit_raw_recvfrom_netlabel($1)";
}
if(iii==152){
	add_number=0;
	raw_interface_name="corenet_dontaudit_raw_recvfrom_netlabel";
	add0="dontaudit $1 netlabel_peer_t:rawip_socket recvfrom;";
}
if(iii==153){
	add_number=0;
	raw_interface_name="corenet_dontaudit_raw_recvfrom_unlabeled";
	add0="kernel_dontaudit_raw_recvfrom_unlabeled($1)";
	add1="kernel_dontaudit_sendrecv_unlabeled_association($1)";
	add_number =1;
}
if(iii==154){
	add_number=0;
	raw_interface_name="corenet_all_recvfrom_unlabeled";
	add0="kernel_tcp_recvfrom_unlabeled($1)";
	add1="kernel_udp_recvfrom_unlabeled($1)";
	add_number =1;
	add2="kernel_raw_recvfrom_unlabeled($1)";
	add_number =2;
	add3="kernel_sendrecv_unlabeled_association($1)";
	add_number =3;
}
if(iii==155){
	add_number=0;
	raw_interface_name="corenet_all_recvfrom_netlabel";
	add0="allow $1 netlabel_peer_t:{ tcp_socket udp_socket rawip_socket } recvfrom;";
}
if(iii==156){
	add_number=0;
	raw_interface_name="corenet_dontaudit_all_recvfrom_unlabeled";
	add0="kernel_dontaudit_tcp_recvfrom_unlabeled($1)";
	add1="kernel_dontaudit_udp_recvfrom_unlabeled($1)";
	add_number =1;
	add2="kernel_dontaudit_raw_recvfrom_unlabeled($1)";
	add_number =2;
	add3="kernel_dontaudit_sendrecv_unlabeled_association($1)";
	add_number =3;
}
if(iii==157){
	add_number=0;
	raw_interface_name="corenet_dontaudit_all_recvfrom_netlabel";
	add0="dontaudit $1 netlabel_peer_t:{ tcp_socket udp_socket rawip_socket } recvfrom;";
}
if(iii==158){
	add_number=0;
	raw_interface_name="corenet_send_generic_client_packets";
	add0="allow $1 client_packet_t:packet send;";
}
if(iii==159){
	add_number=0;
	raw_interface_name="corenet_receive_generic_client_packets";
	add0="allow $1 client_packet_t:packet recv;";
}
if(iii==160){
	add_number=0;
	raw_interface_name="corenet_sendrecv_generic_client_packets";
	add0="corenet_send_generic_client_packets($1)";
	add1="corenet_receive_generic_client_packets($1)";
	add_number =1;
}
if(iii==161){
	add_number=0;
	raw_interface_name="corenet_relabelto_generic_client_packets";
	add0="allow $1 client_packet_t:packet relabelto;";
}
if(iii==162){
	add_number=0;
	raw_interface_name="corenet_send_generic_server_packets";
	add0="allow $1 server_packet_t:packet send;";
}
if(iii==163){
	add_number=0;
	raw_interface_name="corenet_receive_generic_server_packets";
	add0="allow $1 server_packet_t:packet recv;";
}
if(iii==164){
	add_number=0;
	raw_interface_name="corenet_sendrecv_generic_server_packets";
	add0="corenet_send_generic_server_packets($1)";
	add1="corenet_receive_generic_server_packets($1)";
	add_number =1;
}
if(iii==165){
	add_number=0;
	raw_interface_name="corenet_relabelto_generic_server_packets";
	add0="allow $1 server_packet_t:packet relabelto;";
}
if(iii==166){
	add_number=0;
	raw_interface_name="corenet_sendrecv_unlabeled_packets";
	add0="kernel_sendrecv_unlabeled_packets($1)";
}
if(iii==167){
	add_number=0;
	raw_interface_name="corenet_send_all_client_packets";
	add0="allow $1 client_packet_type:packet send;";
}
if(iii==168){
	add_number=0;
	raw_interface_name="corenet_receive_all_client_packets";
	add0="allow $1 client_packet_type:packet recv;";
}
if(iii==169){
	add_number=0;
	raw_interface_name="corenet_sendrecv_all_client_packets";
	add0="corenet_send_all_client_packets($1)";
	add1="corenet_receive_all_client_packets($1)";
	add_number =1;
}
if(iii==170){
	add_number=0;
	raw_interface_name="corenet_relabelto_all_client_packets";
	add0="allow $1 client_packet_type:packet relabelto;";
}
if(iii==171){
	add_number=0;
	raw_interface_name="corenet_send_all_server_packets";
	add0="allow $1 server_packet_type:packet send;";
}
if(iii==172){
	add_number=0;
	raw_interface_name="corenet_receive_all_server_packets";
	add0="allow $1 server_packet_type:packet recv;";
}
if(iii==173){
	add_number=0;
	raw_interface_name="corenet_sendrecv_all_server_packets";
	add0="corenet_send_all_server_packets($1)";
	add1="corenet_receive_all_server_packets($1)";
	add_number =1;
}
if(iii==174){
	add_number=0;
	raw_interface_name="corenet_relabelto_all_server_packets";
	add0="allow $1 server_packet_type:packet relabelto;";
}
if(iii==175){
	add_number=0;
	raw_interface_name="corenet_send_all_packets";
	add0="allow $1 packet_type:packet send;";
}
if(iii==176){
	add_number=0;
	raw_interface_name="corenet_receive_all_packets";
	add0="allow $1 packet_type:packet recv;";
}
if(iii==177){
	add_number=0;
	raw_interface_name="corenet_sendrecv_all_packets";
	add0="corenet_send_all_packets($1)";
	add1="corenet_receive_all_packets($1)";
	add_number =1;
}
if(iii==178){
	add_number=0;
	raw_interface_name="corenet_relabelto_all_packets";
	add0="allow $1 packet_type:packet relabelto;";
}
if(iii==179){
	add_number=0;
	raw_interface_name="corenet_unconfined";
	add0="typeattribute $1 corenet_unconfined_type;";
}
if(iii==180){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_afs_bos_port";
	add0="allow $1 afs_bos_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==181){
	add_number=0;
	raw_interface_name="corenet_udp_send_afs_bos_port";
	add0="allow $1 afs_bos_port_t:udp_socket send_msg;";
}
if(iii==182){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_afs_bos_port";
	add0="dontaudit $1 afs_bos_port_t:udp_socket send_msg;";
}
if(iii==183){
	add_number=0;
	raw_interface_name="corenet_udp_receive_afs_bos_port";
	add0="allow $1 afs_bos_port_t:udp_socket recv_msg;";
}
if(iii==184){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_afs_bos_port";
	add0="dontaudit $1 afs_bos_port_t:udp_socket recv_msg;";
}
if(iii==185){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_afs_bos_port";
	add0="corenet_udp_send_afs_bos_port($1)";
	add1="corenet_udp_receive_afs_bos_port($1)";
	add_number =1;
}
if(iii==186){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_afs_bos_port";
	add0="corenet_dontaudit_udp_send_afs_bos_port($1)";
	add1="corenet_dontaudit_udp_receive_afs_bos_port($1)";
	add_number =1;
}
if(iii==187){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_afs_bos_port";
	add0="allow $1 afs_bos_port_t:tcp_socket name_bind;";
}
if(iii==188){
	add_number=0;
	raw_interface_name="corenet_udp_bind_afs_bos_port";
	add0="allow $1 afs_bos_port_t:udp_socket name_bind;";
}
if(iii==189){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_afs_bos_port";
	add0="allow $1 afs_bos_port_t:tcp_socket name_connect;";
}
if(iii==190){
	add_number=0;
	raw_interface_name="corenet_send_afs_bos_client_packets";
	add0="allow $1 afs_bos_client_packet_t:packet send;";
}
if(iii==191){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_bos_client_packets";
	add0="dontaudit $1 afs_bos_client_packet_t:packet send;";
}
if(iii==192){
	add_number=0;
	raw_interface_name="corenet_receive_afs_bos_client_packets";
	add0="allow $1 afs_bos_client_packet_t:packet recv;";
}
if(iii==193){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_bos_client_packets";
	add0="dontaudit $1 afs_bos_client_packet_t:packet recv;";
}
if(iii==194){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_bos_client_packets";
	add0="corenet_send_afs_bos_client_packets($1)";
	add1="corenet_receive_afs_bos_client_packets($1)";
	add_number =1;
}
if(iii==195){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_bos_client_packets";
	add0="corenet_dontaudit_send_afs_bos_client_packets($1)";
	add1="corenet_dontaudit_receive_afs_bos_client_packets($1)";
	add_number =1;
}
if(iii==196){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_bos_client_packets";
	add0="allow $1 afs_bos_client_packet_t:packet relabelto;";
}
if(iii==197){
	add_number=0;
	raw_interface_name="corenet_send_afs_bos_server_packets";
	add0="allow $1 afs_bos_server_packet_t:packet send;";
}
if(iii==198){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_bos_server_packets";
	add0="dontaudit $1 afs_bos_server_packet_t:packet send;";
}
if(iii==199){
	add_number=0;
	raw_interface_name="corenet_receive_afs_bos_server_packets";
	add0="allow $1 afs_bos_server_packet_t:packet recv;";
}
if(iii==200){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_bos_server_packets";
	add0="dontaudit $1 afs_bos_server_packet_t:packet recv;";
}
if(iii==201){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_bos_server_packets";
	add0="corenet_send_afs_bos_server_packets($1)";
	add1="corenet_receive_afs_bos_server_packets($1)";
	add_number =1;
}
if(iii==202){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_bos_server_packets";
	add0="corenet_dontaudit_send_afs_bos_server_packets($1)";
	add1="corenet_dontaudit_receive_afs_bos_server_packets($1)";
	add_number =1;
}
if(iii==203){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_bos_server_packets";
	add0="allow $1 afs_bos_server_packet_t:packet relabelto;";
}
if(iii==204){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_afs_fs_port";
	add0="allow $1 afs_fs_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==205){
	add_number=0;
	raw_interface_name="corenet_udp_send_afs_fs_port";
	add0="allow $1 afs_fs_port_t:udp_socket send_msg;";
}
if(iii==206){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_afs_fs_port";
	add0="dontaudit $1 afs_fs_port_t:udp_socket send_msg;";
}
if(iii==207){
	add_number=0;
	raw_interface_name="corenet_udp_receive_afs_fs_port";
	add0="allow $1 afs_fs_port_t:udp_socket recv_msg;";
}
if(iii==208){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_afs_fs_port";
	add0="dontaudit $1 afs_fs_port_t:udp_socket recv_msg;";
}
if(iii==209){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_afs_fs_port";
	add0="corenet_udp_send_afs_fs_port($1)";
	add1="corenet_udp_receive_afs_fs_port($1)";
	add_number =1;
}
if(iii==210){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_afs_fs_port";
	add0="corenet_dontaudit_udp_send_afs_fs_port($1)";
	add1="corenet_dontaudit_udp_receive_afs_fs_port($1)";
	add_number =1;
}
if(iii==211){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_afs_fs_port";
	add0="allow $1 afs_fs_port_t:tcp_socket name_bind;";
}
if(iii==212){
	add_number=0;
	raw_interface_name="corenet_udp_bind_afs_fs_port";
	add0="allow $1 afs_fs_port_t:udp_socket name_bind;";
}
if(iii==213){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_afs_fs_port";
	add0="allow $1 afs_fs_port_t:tcp_socket name_connect;";
}
if(iii==214){
	add_number=0;
	raw_interface_name="corenet_send_afs_fs_client_packets";
	add0="allow $1 afs_fs_client_packet_t:packet send;";
}
if(iii==215){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_fs_client_packets";
	add0="dontaudit $1 afs_fs_client_packet_t:packet send;";
}
if(iii==216){
	add_number=0;
	raw_interface_name="corenet_receive_afs_fs_client_packets";
	add0="allow $1 afs_fs_client_packet_t:packet recv;";
}
if(iii==217){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_fs_client_packets";
	add0="dontaudit $1 afs_fs_client_packet_t:packet recv;";
}
if(iii==218){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_fs_client_packets";
	add0="corenet_send_afs_fs_client_packets($1)";
	add1="corenet_receive_afs_fs_client_packets($1)";
	add_number =1;
}
if(iii==219){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_fs_client_packets";
	add0="corenet_dontaudit_send_afs_fs_client_packets($1)";
	add1="corenet_dontaudit_receive_afs_fs_client_packets($1)";
	add_number =1;
}
if(iii==220){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_fs_client_packets";
	add0="allow $1 afs_fs_client_packet_t:packet relabelto;";
}
if(iii==221){
	add_number=0;
	raw_interface_name="corenet_send_afs_fs_server_packets";
	add0="allow $1 afs_fs_server_packet_t:packet send;";
}
if(iii==222){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_fs_server_packets";
	add0="dontaudit $1 afs_fs_server_packet_t:packet send;";
}
if(iii==223){
	add_number=0;
	raw_interface_name="corenet_receive_afs_fs_server_packets";
	add0="allow $1 afs_fs_server_packet_t:packet recv;";
}
if(iii==224){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_fs_server_packets";
	add0="dontaudit $1 afs_fs_server_packet_t:packet recv;";
}
if(iii==225){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_fs_server_packets";
	add0="corenet_send_afs_fs_server_packets($1)";
	add1="corenet_receive_afs_fs_server_packets($1)";
	add_number =1;
}
if(iii==226){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_fs_server_packets";
	add0="corenet_dontaudit_send_afs_fs_server_packets($1)";
	add1="corenet_dontaudit_receive_afs_fs_server_packets($1)";
	add_number =1;
}
if(iii==227){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_fs_server_packets";
	add0="allow $1 afs_fs_server_packet_t:packet relabelto;";
}
if(iii==228){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_afs_ka_port";
	add0="allow $1 afs_ka_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==229){
	add_number=0;
	raw_interface_name="corenet_udp_send_afs_ka_port";
	add0="allow $1 afs_ka_port_t:udp_socket send_msg;";
}
if(iii==230){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_afs_ka_port";
	add0="dontaudit $1 afs_ka_port_t:udp_socket send_msg;";
}
if(iii==231){
	add_number=0;
	raw_interface_name="corenet_udp_receive_afs_ka_port";
	add0="allow $1 afs_ka_port_t:udp_socket recv_msg;";
}
if(iii==232){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_afs_ka_port";
	add0="dontaudit $1 afs_ka_port_t:udp_socket recv_msg;";
}
if(iii==233){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_afs_ka_port";
	add0="corenet_udp_send_afs_ka_port($1)";
	add1="corenet_udp_receive_afs_ka_port($1)";
	add_number =1;
}
if(iii==234){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_afs_ka_port";
	add0="corenet_dontaudit_udp_send_afs_ka_port($1)";
	add1="corenet_dontaudit_udp_receive_afs_ka_port($1)";
	add_number =1;
}
if(iii==235){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_afs_ka_port";
	add0="allow $1 afs_ka_port_t:tcp_socket name_bind;";
}
if(iii==236){
	add_number=0;
	raw_interface_name="corenet_udp_bind_afs_ka_port";
	add0="allow $1 afs_ka_port_t:udp_socket name_bind;";
}
if(iii==237){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_afs_ka_port";
	add0="allow $1 afs_ka_port_t:tcp_socket name_connect;";
}
if(iii==238){
	add_number=0;
	raw_interface_name="corenet_send_afs_ka_client_packets";
	add0="allow $1 afs_ka_client_packet_t:packet send;";
}
if(iii==239){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_ka_client_packets";
	add0="dontaudit $1 afs_ka_client_packet_t:packet send;";
}
if(iii==240){
	add_number=0;
	raw_interface_name="corenet_receive_afs_ka_client_packets";
	add0="allow $1 afs_ka_client_packet_t:packet recv;";
}
if(iii==241){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_ka_client_packets";
	add0="dontaudit $1 afs_ka_client_packet_t:packet recv;";
}
if(iii==242){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_ka_client_packets";
	add0="corenet_send_afs_ka_client_packets($1)";
	add1="corenet_receive_afs_ka_client_packets($1)";
	add_number =1;
}
if(iii==243){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_ka_client_packets";
	add0="corenet_dontaudit_send_afs_ka_client_packets($1)";
	add1="corenet_dontaudit_receive_afs_ka_client_packets($1)";
	add_number =1;
}
if(iii==244){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_ka_client_packets";
	add0="allow $1 afs_ka_client_packet_t:packet relabelto;";
}
if(iii==245){
	add_number=0;
	raw_interface_name="corenet_send_afs_ka_server_packets";
	add0="allow $1 afs_ka_server_packet_t:packet send;";
}
if(iii==246){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_ka_server_packets";
	add0="dontaudit $1 afs_ka_server_packet_t:packet send;";
}
if(iii==247){
	add_number=0;
	raw_interface_name="corenet_receive_afs_ka_server_packets";
	add0="allow $1 afs_ka_server_packet_t:packet recv;";
}
if(iii==248){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_ka_server_packets";
	add0="dontaudit $1 afs_ka_server_packet_t:packet recv;";
}
if(iii==249){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_ka_server_packets";
	add0="corenet_send_afs_ka_server_packets($1)";
	add1="corenet_receive_afs_ka_server_packets($1)";
	add_number =1;
}
if(iii==250){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_ka_server_packets";
	add0="corenet_dontaudit_send_afs_ka_server_packets($1)";
	add1="corenet_dontaudit_receive_afs_ka_server_packets($1)";
	add_number =1;
}
if(iii==251){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_ka_server_packets";
	add0="allow $1 afs_ka_server_packet_t:packet relabelto;";
}
if(iii==252){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_afs_pt_port";
	add0="allow $1 afs_pt_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==253){
	add_number=0;
	raw_interface_name="corenet_udp_send_afs_pt_port";
	add0="allow $1 afs_pt_port_t:udp_socket send_msg;";
}
if(iii==254){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_afs_pt_port";
	add0="dontaudit $1 afs_pt_port_t:udp_socket send_msg;";
}
if(iii==255){
	add_number=0;
	raw_interface_name="corenet_udp_receive_afs_pt_port";
	add0="allow $1 afs_pt_port_t:udp_socket recv_msg;";
}
if(iii==256){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_afs_pt_port";
	add0="dontaudit $1 afs_pt_port_t:udp_socket recv_msg;";
}
if(iii==257){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_afs_pt_port";
	add0="corenet_udp_send_afs_pt_port($1)";
	add1="corenet_udp_receive_afs_pt_port($1)";
	add_number =1;
}
if(iii==258){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_afs_pt_port";
	add0="corenet_dontaudit_udp_send_afs_pt_port($1)";
	add1="corenet_dontaudit_udp_receive_afs_pt_port($1)";
	add_number =1;
}
if(iii==259){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_afs_pt_port";
	add0="allow $1 afs_pt_port_t:tcp_socket name_bind;";
}
if(iii==260){
	add_number=0;
	raw_interface_name="corenet_udp_bind_afs_pt_port";
	add0="allow $1 afs_pt_port_t:udp_socket name_bind;";
}
if(iii==261){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_afs_pt_port";
	add0="allow $1 afs_pt_port_t:tcp_socket name_connect;";
}
if(iii==262){
	add_number=0;
	raw_interface_name="corenet_send_afs_pt_client_packets";
	add0="allow $1 afs_pt_client_packet_t:packet send;";
}
if(iii==263){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_pt_client_packets";
	add0="dontaudit $1 afs_pt_client_packet_t:packet send;";
}
if(iii==264){
	add_number=0;
	raw_interface_name="corenet_receive_afs_pt_client_packets";
	add0="allow $1 afs_pt_client_packet_t:packet recv;";
}
if(iii==265){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_pt_client_packets";
	add0="dontaudit $1 afs_pt_client_packet_t:packet recv;";
}
if(iii==266){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_pt_client_packets";
	add0="corenet_send_afs_pt_client_packets($1)";
	add1="corenet_receive_afs_pt_client_packets($1)";
	add_number =1;
}
if(iii==267){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_pt_client_packets";
	add0="corenet_dontaudit_send_afs_pt_client_packets($1)";
	add1="corenet_dontaudit_receive_afs_pt_client_packets($1)";
	add_number =1;
}
if(iii==268){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_pt_client_packets";
	add0="allow $1 afs_pt_client_packet_t:packet relabelto;";
}
if(iii==269){
	add_number=0;
	raw_interface_name="corenet_send_afs_pt_server_packets";
	add0="allow $1 afs_pt_server_packet_t:packet send;";
}
if(iii==270){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_pt_server_packets";
	add0="dontaudit $1 afs_pt_server_packet_t:packet send;";
}
if(iii==271){
	add_number=0;
	raw_interface_name="corenet_receive_afs_pt_server_packets";
	add0="allow $1 afs_pt_server_packet_t:packet recv;";
}
if(iii==272){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_pt_server_packets";
	add0="dontaudit $1 afs_pt_server_packet_t:packet recv;";
}
if(iii==273){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_pt_server_packets";
	add0="corenet_send_afs_pt_server_packets($1)";
	add1="corenet_receive_afs_pt_server_packets($1)";
	add_number =1;
}
if(iii==274){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_pt_server_packets";
	add0="corenet_dontaudit_send_afs_pt_server_packets($1)";
	add1="corenet_dontaudit_receive_afs_pt_server_packets($1)";
	add_number =1;
}
if(iii==275){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_pt_server_packets";
	add0="allow $1 afs_pt_server_packet_t:packet relabelto;";
}
if(iii==276){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_afs_vl_port";
	add0="allow $1 afs_vl_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==277){
	add_number=0;
	raw_interface_name="corenet_udp_send_afs_vl_port";
	add0="allow $1 afs_vl_port_t:udp_socket send_msg;";
}
if(iii==278){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_afs_vl_port";
	add0="dontaudit $1 afs_vl_port_t:udp_socket send_msg;";
}
if(iii==279){
	add_number=0;
	raw_interface_name="corenet_udp_receive_afs_vl_port";
	add0="allow $1 afs_vl_port_t:udp_socket recv_msg;";
}
if(iii==280){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_afs_vl_port";
	add0="dontaudit $1 afs_vl_port_t:udp_socket recv_msg;";
}
if(iii==281){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_afs_vl_port";
	add0="corenet_udp_send_afs_vl_port($1)";
	add1="corenet_udp_receive_afs_vl_port($1)";
	add_number =1;
}
if(iii==282){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_afs_vl_port";
	add0="corenet_dontaudit_udp_send_afs_vl_port($1)";
	add1="corenet_dontaudit_udp_receive_afs_vl_port($1)";
	add_number =1;
}
if(iii==283){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_afs_vl_port";
	add0="allow $1 afs_vl_port_t:tcp_socket name_bind;";
}
if(iii==284){
	add_number=0;
	raw_interface_name="corenet_udp_bind_afs_vl_port";
	add0="allow $1 afs_vl_port_t:udp_socket name_bind;";
}
if(iii==285){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_afs_vl_port";
	add0="allow $1 afs_vl_port_t:tcp_socket name_connect;";
}
if(iii==286){
	add_number=0;
	raw_interface_name="corenet_send_afs_vl_client_packets";
	add0="allow $1 afs_vl_client_packet_t:packet send;";
}
if(iii==287){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_vl_client_packets";
	add0="dontaudit $1 afs_vl_client_packet_t:packet send;";
}
if(iii==288){
	add_number=0;
	raw_interface_name="corenet_receive_afs_vl_client_packets";
	add0="allow $1 afs_vl_client_packet_t:packet recv;";
}
if(iii==289){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_vl_client_packets";
	add0="dontaudit $1 afs_vl_client_packet_t:packet recv;";
}
if(iii==290){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_vl_client_packets";
	add0="corenet_send_afs_vl_client_packets($1)";
	add1="corenet_receive_afs_vl_client_packets($1)";
	add_number =1;
}
if(iii==291){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_vl_client_packets";
	add0="corenet_dontaudit_send_afs_vl_client_packets($1)";
	add1="corenet_dontaudit_receive_afs_vl_client_packets($1)";
	add_number =1;
}
if(iii==292){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_vl_client_packets";
	add0="allow $1 afs_vl_client_packet_t:packet relabelto;";
}
if(iii==293){
	add_number=0;
	raw_interface_name="corenet_send_afs_vl_server_packets";
	add0="allow $1 afs_vl_server_packet_t:packet send;";
}
if(iii==294){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_afs_vl_server_packets";
	add0="dontaudit $1 afs_vl_server_packet_t:packet send;";
}
if(iii==295){
	add_number=0;
	raw_interface_name="corenet_receive_afs_vl_server_packets";
	add0="allow $1 afs_vl_server_packet_t:packet recv;";
}
if(iii==296){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_afs_vl_server_packets";
	add0="dontaudit $1 afs_vl_server_packet_t:packet recv;";
}
if(iii==297){
	add_number=0;
	raw_interface_name="corenet_sendrecv_afs_vl_server_packets";
	add0="corenet_send_afs_vl_server_packets($1)";
	add1="corenet_receive_afs_vl_server_packets($1)";
	add_number =1;
}
if(iii==298){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_afs_vl_server_packets";
	add0="corenet_dontaudit_send_afs_vl_server_packets($1)";
	add1="corenet_dontaudit_receive_afs_vl_server_packets($1)";
	add_number =1;
}
if(iii==299){
	add_number=0;
	raw_interface_name="corenet_relabelto_afs_vl_server_packets";
	add0="allow $1 afs_vl_server_packet_t:packet relabelto;";
}
if(iii==300){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_amanda_port";
	add0="allow $1 amanda_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==301){
	add_number=0;
	raw_interface_name="corenet_udp_send_amanda_port";
	add0="allow $1 amanda_port_t:udp_socket send_msg;";
}
if(iii==302){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_amanda_port";
	add0="dontaudit $1 amanda_port_t:udp_socket send_msg;";
}
if(iii==303){
	add_number=0;
	raw_interface_name="corenet_udp_receive_amanda_port";
	add0="allow $1 amanda_port_t:udp_socket recv_msg;";
}
if(iii==304){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_amanda_port";
	add0="dontaudit $1 amanda_port_t:udp_socket recv_msg;";
}
if(iii==305){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_amanda_port";
	add0="corenet_udp_send_amanda_port($1)";
	add1="corenet_udp_receive_amanda_port($1)";
	add_number =1;
}
if(iii==306){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_amanda_port";
	add0="corenet_dontaudit_udp_send_amanda_port($1)";
	add1="corenet_dontaudit_udp_receive_amanda_port($1)";
	add_number =1;
}
if(iii==307){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_amanda_port";
	add0="allow $1 amanda_port_t:tcp_socket name_bind;";
}
if(iii==308){
	add_number=0;
	raw_interface_name="corenet_udp_bind_amanda_port";
	add0="allow $1 amanda_port_t:udp_socket name_bind;";
}
if(iii==309){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_amanda_port";
	add0="allow $1 amanda_port_t:tcp_socket name_connect;";
}
if(iii==310){
	add_number=0;
	raw_interface_name="corenet_send_amanda_client_packets";
	add0="allow $1 amanda_client_packet_t:packet send;";
}
if(iii==311){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_amanda_client_packets";
	add0="dontaudit $1 amanda_client_packet_t:packet send;";
}
if(iii==312){
	add_number=0;
	raw_interface_name="corenet_receive_amanda_client_packets";
	add0="allow $1 amanda_client_packet_t:packet recv;";
}
if(iii==313){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_amanda_client_packets";
	add0="dontaudit $1 amanda_client_packet_t:packet recv;";
}
if(iii==314){
	add_number=0;
	raw_interface_name="corenet_sendrecv_amanda_client_packets";
	add0="corenet_send_amanda_client_packets($1)";
	add1="corenet_receive_amanda_client_packets($1)";
	add_number =1;
}
if(iii==315){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_amanda_client_packets";
	add0="corenet_dontaudit_send_amanda_client_packets($1)";
	add1="corenet_dontaudit_receive_amanda_client_packets($1)";
	add_number =1;
}
if(iii==316){
	add_number=0;
	raw_interface_name="corenet_relabelto_amanda_client_packets";
	add0="allow $1 amanda_client_packet_t:packet relabelto;";
}
if(iii==317){
	add_number=0;
	raw_interface_name="corenet_send_amanda_server_packets";
	add0="allow $1 amanda_server_packet_t:packet send;";
}
if(iii==318){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_amanda_server_packets";
	add0="dontaudit $1 amanda_server_packet_t:packet send;";
}
if(iii==319){
	add_number=0;
	raw_interface_name="corenet_receive_amanda_server_packets";
	add0="allow $1 amanda_server_packet_t:packet recv;";
}
if(iii==320){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_amanda_server_packets";
	add0="dontaudit $1 amanda_server_packet_t:packet recv;";
}
if(iii==321){
	add_number=0;
	raw_interface_name="corenet_sendrecv_amanda_server_packets";
	add0="corenet_send_amanda_server_packets($1)";
	add1="corenet_receive_amanda_server_packets($1)";
	add_number =1;
}
if(iii==322){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_amanda_server_packets";
	add0="corenet_dontaudit_send_amanda_server_packets($1)";
	add1="corenet_dontaudit_receive_amanda_server_packets($1)";
	add_number =1;
}
if(iii==323){
	add_number=0;
	raw_interface_name="corenet_relabelto_amanda_server_packets";
	add0="allow $1 amanda_server_packet_t:packet relabelto;";
}
if(iii==324){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_amavisd_recv_port";
	add0="allow $1 amavisd_recv_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==325){
	add_number=0;
	raw_interface_name="corenet_udp_send_amavisd_recv_port";
	add0="allow $1 amavisd_recv_port_t:udp_socket send_msg;";
}
if(iii==326){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_amavisd_recv_port";
	add0="dontaudit $1 amavisd_recv_port_t:udp_socket send_msg;";
}
if(iii==327){
	add_number=0;
	raw_interface_name="corenet_udp_receive_amavisd_recv_port";
	add0="allow $1 amavisd_recv_port_t:udp_socket recv_msg;";
}
if(iii==328){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_amavisd_recv_port";
	add0="dontaudit $1 amavisd_recv_port_t:udp_socket recv_msg;";
}
if(iii==329){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_amavisd_recv_port";
	add0="corenet_udp_send_amavisd_recv_port($1)";
	add1="corenet_udp_receive_amavisd_recv_port($1)";
	add_number =1;
}
if(iii==330){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_amavisd_recv_port";
	add0="corenet_dontaudit_udp_send_amavisd_recv_port($1)";
	add1="corenet_dontaudit_udp_receive_amavisd_recv_port($1)";
	add_number =1;
}
if(iii==331){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_amavisd_recv_port";
	add0="allow $1 amavisd_recv_port_t:tcp_socket name_bind;";
}
if(iii==332){
	add_number=0;
	raw_interface_name="corenet_udp_bind_amavisd_recv_port";
	add0="allow $1 amavisd_recv_port_t:udp_socket name_bind;";
}
if(iii==333){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_amavisd_recv_port";
	add0="allow $1 amavisd_recv_port_t:tcp_socket name_connect;";
}
if(iii==334){
	add_number=0;
	raw_interface_name="corenet_send_amavisd_recv_client_packets";
	add0="allow $1 amavisd_recv_client_packet_t:packet send;";
}
if(iii==335){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_amavisd_recv_client_packets";
	add0="dontaudit $1 amavisd_recv_client_packet_t:packet send;";
}
if(iii==336){
	add_number=0;
	raw_interface_name="corenet_receive_amavisd_recv_client_packets";
	add0="allow $1 amavisd_recv_client_packet_t:packet recv;";
}
if(iii==337){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_amavisd_recv_client_packets";
	add0="dontaudit $1 amavisd_recv_client_packet_t:packet recv;";
}
if(iii==338){
	add_number=0;
	raw_interface_name="corenet_sendrecv_amavisd_recv_client_packets";
	add0="corenet_send_amavisd_recv_client_packets($1)";
	add1="corenet_receive_amavisd_recv_client_packets($1)";
	add_number =1;
}
if(iii==339){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_amavisd_recv_client_packets";
	add0="corenet_dontaudit_send_amavisd_recv_client_packets($1)";
	add1="corenet_dontaudit_receive_amavisd_recv_client_packets($1)";
	add_number =1;
}
if(iii==340){
	add_number=0;
	raw_interface_name="corenet_relabelto_amavisd_recv_client_packets";
	add0="allow $1 amavisd_recv_client_packet_t:packet relabelto;";
}
if(iii==341){
	add_number=0;
	raw_interface_name="corenet_send_amavisd_recv_server_packets";
	add0="allow $1 amavisd_recv_server_packet_t:packet send;";
}
if(iii==342){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_amavisd_recv_server_packets";
	add0="dontaudit $1 amavisd_recv_server_packet_t:packet send;";
}
if(iii==343){
	add_number=0;
	raw_interface_name="corenet_receive_amavisd_recv_server_packets";
	add0="allow $1 amavisd_recv_server_packet_t:packet recv;";
}
if(iii==344){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_amavisd_recv_server_packets";
	add0="dontaudit $1 amavisd_recv_server_packet_t:packet recv;";
}
if(iii==345){
	add_number=0;
	raw_interface_name="corenet_sendrecv_amavisd_recv_server_packets";
	add0="corenet_send_amavisd_recv_server_packets($1)";
	add1="corenet_receive_amavisd_recv_server_packets($1)";
	add_number =1;
}
if(iii==346){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_amavisd_recv_server_packets";
	add0="corenet_dontaudit_send_amavisd_recv_server_packets($1)";
	add1="corenet_dontaudit_receive_amavisd_recv_server_packets($1)";
	add_number =1;
}
if(iii==347){
	add_number=0;
	raw_interface_name="corenet_relabelto_amavisd_recv_server_packets";
	add0="allow $1 amavisd_recv_server_packet_t:packet relabelto;";
}
if(iii==348){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_amavisd_send_port";
	add0="allow $1 amavisd_send_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==349){
	add_number=0;
	raw_interface_name="corenet_udp_send_amavisd_send_port";
	add0="allow $1 amavisd_send_port_t:udp_socket send_msg;";
}
if(iii==350){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_amavisd_send_port";
	add0="dontaudit $1 amavisd_send_port_t:udp_socket send_msg;";
}
if(iii==351){
	add_number=0;
	raw_interface_name="corenet_udp_receive_amavisd_send_port";
	add0="allow $1 amavisd_send_port_t:udp_socket recv_msg;";
}
if(iii==352){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_amavisd_send_port";
	add0="dontaudit $1 amavisd_send_port_t:udp_socket recv_msg;";
}
if(iii==353){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_amavisd_send_port";
	add0="corenet_udp_send_amavisd_send_port($1)";
	add1="corenet_udp_receive_amavisd_send_port($1)";
	add_number =1;
}
if(iii==354){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_amavisd_send_port";
	add0="corenet_dontaudit_udp_send_amavisd_send_port($1)";
	add1="corenet_dontaudit_udp_receive_amavisd_send_port($1)";
	add_number =1;
}
if(iii==355){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_amavisd_send_port";
	add0="allow $1 amavisd_send_port_t:tcp_socket name_bind;";
}
if(iii==356){
	add_number=0;
	raw_interface_name="corenet_udp_bind_amavisd_send_port";
	add0="allow $1 amavisd_send_port_t:udp_socket name_bind;";
}
if(iii==357){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_amavisd_send_port";
	add0="allow $1 amavisd_send_port_t:tcp_socket name_connect;";
}
if(iii==358){
	add_number=0;
	raw_interface_name="corenet_send_amavisd_send_client_packets";
	add0="allow $1 amavisd_send_client_packet_t:packet send;";
}
if(iii==359){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_amavisd_send_client_packets";
	add0="dontaudit $1 amavisd_send_client_packet_t:packet send;";
}
if(iii==360){
	add_number=0;
	raw_interface_name="corenet_receive_amavisd_send_client_packets";
	add0="allow $1 amavisd_send_client_packet_t:packet recv;";
}
if(iii==361){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_amavisd_send_client_packets";
	add0="dontaudit $1 amavisd_send_client_packet_t:packet recv;";
}
if(iii==362){
	add_number=0;
	raw_interface_name="corenet_sendrecv_amavisd_send_client_packets";
	add0="corenet_send_amavisd_send_client_packets($1)";
	add1="corenet_receive_amavisd_send_client_packets($1)";
	add_number =1;
}
if(iii==363){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_amavisd_send_client_packets";
	add0="corenet_dontaudit_send_amavisd_send_client_packets($1)";
	add1="corenet_dontaudit_receive_amavisd_send_client_packets($1)";
	add_number =1;
}
if(iii==364){
	add_number=0;
	raw_interface_name="corenet_relabelto_amavisd_send_client_packets";
	add0="allow $1 amavisd_send_client_packet_t:packet relabelto;";
}
if(iii==365){
	add_number=0;
	raw_interface_name="corenet_send_amavisd_send_server_packets";
	add0="allow $1 amavisd_send_server_packet_t:packet send;";
}
if(iii==366){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_amavisd_send_server_packets";
	add0="dontaudit $1 amavisd_send_server_packet_t:packet send;";
}
if(iii==367){
	add_number=0;
	raw_interface_name="corenet_receive_amavisd_send_server_packets";
	add0="allow $1 amavisd_send_server_packet_t:packet recv;";
}
if(iii==368){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_amavisd_send_server_packets";
	add0="dontaudit $1 amavisd_send_server_packet_t:packet recv;";
}
if(iii==369){
	add_number=0;
	raw_interface_name="corenet_sendrecv_amavisd_send_server_packets";
	add0="corenet_send_amavisd_send_server_packets($1)";
	add1="corenet_receive_amavisd_send_server_packets($1)";
	add_number =1;
}
if(iii==370){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_amavisd_send_server_packets";
	add0="corenet_dontaudit_send_amavisd_send_server_packets($1)";
	add1="corenet_dontaudit_receive_amavisd_send_server_packets($1)";
	add_number =1;
}
if(iii==371){
	add_number=0;
	raw_interface_name="corenet_relabelto_amavisd_send_server_packets";
	add0="allow $1 amavisd_send_server_packet_t:packet relabelto;";
}
if(iii==372){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_aol_port";
	add0="allow $1 aol_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==373){
	add_number=0;
	raw_interface_name="corenet_udp_send_aol_port";
	add0="allow $1 aol_port_t:udp_socket send_msg;";
}
if(iii==374){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_aol_port";
	add0="dontaudit $1 aol_port_t:udp_socket send_msg;";
}
if(iii==375){
	add_number=0;
	raw_interface_name="corenet_udp_receive_aol_port";
	add0="allow $1 aol_port_t:udp_socket recv_msg;";
}
if(iii==376){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_aol_port";
	add0="dontaudit $1 aol_port_t:udp_socket recv_msg;";
}
if(iii==377){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_aol_port";
	add0="corenet_udp_send_aol_port($1)";
	add1="corenet_udp_receive_aol_port($1)";
	add_number =1;
}
if(iii==378){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_aol_port";
	add0="corenet_dontaudit_udp_send_aol_port($1)";
	add1="corenet_dontaudit_udp_receive_aol_port($1)";
	add_number =1;
}
if(iii==379){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_aol_port";
	add0="allow $1 aol_port_t:tcp_socket name_bind;";
}
if(iii==380){
	add_number=0;
	raw_interface_name="corenet_udp_bind_aol_port";
	add0="allow $1 aol_port_t:udp_socket name_bind;";
}
if(iii==381){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_aol_port";
	add0="allow $1 aol_port_t:tcp_socket name_connect;";
}
if(iii==382){
	add_number=0;
	raw_interface_name="corenet_send_aol_client_packets";
	add0="allow $1 aol_client_packet_t:packet send;";
}
if(iii==383){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_aol_client_packets";
	add0="dontaudit $1 aol_client_packet_t:packet send;";
}
if(iii==384){
	add_number=0;
	raw_interface_name="corenet_receive_aol_client_packets";
	add0="allow $1 aol_client_packet_t:packet recv;";
}
if(iii==385){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_aol_client_packets";
	add0="dontaudit $1 aol_client_packet_t:packet recv;";
}
if(iii==386){
	add_number=0;
	raw_interface_name="corenet_sendrecv_aol_client_packets";
	add0="corenet_send_aol_client_packets($1)";
	add1="corenet_receive_aol_client_packets($1)";
	add_number =1;
}
if(iii==387){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_aol_client_packets";
	add0="corenet_dontaudit_send_aol_client_packets($1)";
	add1="corenet_dontaudit_receive_aol_client_packets($1)";
	add_number =1;
}
if(iii==388){
	add_number=0;
	raw_interface_name="corenet_relabelto_aol_client_packets";
	add0="allow $1 aol_client_packet_t:packet relabelto;";
}
if(iii==389){
	add_number=0;
	raw_interface_name="corenet_send_aol_server_packets";
	add0="allow $1 aol_server_packet_t:packet send;";
}
if(iii==390){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_aol_server_packets";
	add0="dontaudit $1 aol_server_packet_t:packet send;";
}
if(iii==391){
	add_number=0;
	raw_interface_name="corenet_receive_aol_server_packets";
	add0="allow $1 aol_server_packet_t:packet recv;";
}
if(iii==392){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_aol_server_packets";
	add0="dontaudit $1 aol_server_packet_t:packet recv;";
}
if(iii==393){
	add_number=0;
	raw_interface_name="corenet_sendrecv_aol_server_packets";
	add0="corenet_send_aol_server_packets($1)";
	add1="corenet_receive_aol_server_packets($1)";
	add_number =1;
}
if(iii==394){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_aol_server_packets";
	add0="corenet_dontaudit_send_aol_server_packets($1)";
	add1="corenet_dontaudit_receive_aol_server_packets($1)";
	add_number =1;
}
if(iii==395){
	add_number=0;
	raw_interface_name="corenet_relabelto_aol_server_packets";
	add0="allow $1 aol_server_packet_t:packet relabelto;";
}
if(iii==396){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_apcupsd_port";
	add0="allow $1 apcupsd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==397){
	add_number=0;
	raw_interface_name="corenet_udp_send_apcupsd_port";
	add0="allow $1 apcupsd_port_t:udp_socket send_msg;";
}
if(iii==398){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_apcupsd_port";
	add0="dontaudit $1 apcupsd_port_t:udp_socket send_msg;";
}
if(iii==399){
	add_number=0;
	raw_interface_name="corenet_udp_receive_apcupsd_port";
	add0="allow $1 apcupsd_port_t:udp_socket recv_msg;";
}
if(iii==400){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_apcupsd_port";
	add0="dontaudit $1 apcupsd_port_t:udp_socket recv_msg;";
}
if(iii==401){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_apcupsd_port";
	add0="corenet_udp_send_apcupsd_port($1)";
	add1="corenet_udp_receive_apcupsd_port($1)";
	add_number =1;
}
if(iii==402){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_apcupsd_port";
	add0="corenet_dontaudit_udp_send_apcupsd_port($1)";
	add1="corenet_dontaudit_udp_receive_apcupsd_port($1)";
	add_number =1;
}
if(iii==403){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_apcupsd_port";
	add0="allow $1 apcupsd_port_t:tcp_socket name_bind;";
}
if(iii==404){
	add_number=0;
	raw_interface_name="corenet_udp_bind_apcupsd_port";
	add0="allow $1 apcupsd_port_t:udp_socket name_bind;";
}
if(iii==405){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_apcupsd_port";
	add0="allow $1 apcupsd_port_t:tcp_socket name_connect;";
}
if(iii==406){
	add_number=0;
	raw_interface_name="corenet_send_apcupsd_client_packets";
	add0="allow $1 apcupsd_client_packet_t:packet send;";
}
if(iii==407){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_apcupsd_client_packets";
	add0="dontaudit $1 apcupsd_client_packet_t:packet send;";
}
if(iii==408){
	add_number=0;
	raw_interface_name="corenet_receive_apcupsd_client_packets";
	add0="allow $1 apcupsd_client_packet_t:packet recv;";
}
if(iii==409){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_apcupsd_client_packets";
	add0="dontaudit $1 apcupsd_client_packet_t:packet recv;";
}
if(iii==410){
	add_number=0;
	raw_interface_name="corenet_sendrecv_apcupsd_client_packets";
	add0="corenet_send_apcupsd_client_packets($1)";
	add1="corenet_receive_apcupsd_client_packets($1)";
	add_number =1;
}
if(iii==411){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_apcupsd_client_packets";
	add0="corenet_dontaudit_send_apcupsd_client_packets($1)";
	add1="corenet_dontaudit_receive_apcupsd_client_packets($1)";
	add_number =1;
}
if(iii==412){
	add_number=0;
	raw_interface_name="corenet_relabelto_apcupsd_client_packets";
	add0="allow $1 apcupsd_client_packet_t:packet relabelto;";
}
if(iii==413){
	add_number=0;
	raw_interface_name="corenet_send_apcupsd_server_packets";
	add0="allow $1 apcupsd_server_packet_t:packet send;";
}
if(iii==414){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_apcupsd_server_packets";
	add0="dontaudit $1 apcupsd_server_packet_t:packet send;";
}
if(iii==415){
	add_number=0;
	raw_interface_name="corenet_receive_apcupsd_server_packets";
	add0="allow $1 apcupsd_server_packet_t:packet recv;";
}
if(iii==416){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_apcupsd_server_packets";
	add0="dontaudit $1 apcupsd_server_packet_t:packet recv;";
}
if(iii==417){
	add_number=0;
	raw_interface_name="corenet_sendrecv_apcupsd_server_packets";
	add0="corenet_send_apcupsd_server_packets($1)";
	add1="corenet_receive_apcupsd_server_packets($1)";
	add_number =1;
}
if(iii==418){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_apcupsd_server_packets";
	add0="corenet_dontaudit_send_apcupsd_server_packets($1)";
	add1="corenet_dontaudit_receive_apcupsd_server_packets($1)";
	add_number =1;
}
if(iii==419){
	add_number=0;
	raw_interface_name="corenet_relabelto_apcupsd_server_packets";
	add0="allow $1 apcupsd_server_packet_t:packet relabelto;";
}
if(iii==420){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_asterisk_port";
	add0="allow $1 asterisk_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==421){
	add_number=0;
	raw_interface_name="corenet_udp_send_asterisk_port";
	add0="allow $1 asterisk_port_t:udp_socket send_msg;";
}
if(iii==422){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_asterisk_port";
	add0="dontaudit $1 asterisk_port_t:udp_socket send_msg;";
}
if(iii==423){
	add_number=0;
	raw_interface_name="corenet_udp_receive_asterisk_port";
	add0="allow $1 asterisk_port_t:udp_socket recv_msg;";
}
if(iii==424){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_asterisk_port";
	add0="dontaudit $1 asterisk_port_t:udp_socket recv_msg;";
}
if(iii==425){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_asterisk_port";
	add0="corenet_udp_send_asterisk_port($1)";
	add1="corenet_udp_receive_asterisk_port($1)";
	add_number =1;
}
if(iii==426){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_asterisk_port";
	add0="corenet_dontaudit_udp_send_asterisk_port($1)";
	add1="corenet_dontaudit_udp_receive_asterisk_port($1)";
	add_number =1;
}
if(iii==427){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_asterisk_port";
	add0="allow $1 asterisk_port_t:tcp_socket name_bind;";
}
if(iii==428){
	add_number=0;
	raw_interface_name="corenet_udp_bind_asterisk_port";
	add0="allow $1 asterisk_port_t:udp_socket name_bind;";
}
if(iii==429){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_asterisk_port";
	add0="allow $1 asterisk_port_t:tcp_socket name_connect;";
}
if(iii==430){
	add_number=0;
	raw_interface_name="corenet_send_asterisk_client_packets";
	add0="allow $1 asterisk_client_packet_t:packet send;";
}
if(iii==431){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_asterisk_client_packets";
	add0="dontaudit $1 asterisk_client_packet_t:packet send;";
}
if(iii==432){
	add_number=0;
	raw_interface_name="corenet_receive_asterisk_client_packets";
	add0="allow $1 asterisk_client_packet_t:packet recv;";
}
if(iii==433){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_asterisk_client_packets";
	add0="dontaudit $1 asterisk_client_packet_t:packet recv;";
}
if(iii==434){
	add_number=0;
	raw_interface_name="corenet_sendrecv_asterisk_client_packets";
	add0="corenet_send_asterisk_client_packets($1)";
	add1="corenet_receive_asterisk_client_packets($1)";
	add_number =1;
}
if(iii==435){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_asterisk_client_packets";
	add0="corenet_dontaudit_send_asterisk_client_packets($1)";
	add1="corenet_dontaudit_receive_asterisk_client_packets($1)";
	add_number =1;
}
if(iii==436){
	add_number=0;
	raw_interface_name="corenet_relabelto_asterisk_client_packets";
	add0="allow $1 asterisk_client_packet_t:packet relabelto;";
}
if(iii==437){
	add_number=0;
	raw_interface_name="corenet_send_asterisk_server_packets";
	add0="allow $1 asterisk_server_packet_t:packet send;";
}
if(iii==438){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_asterisk_server_packets";
	add0="dontaudit $1 asterisk_server_packet_t:packet send;";
}
if(iii==439){
	add_number=0;
	raw_interface_name="corenet_receive_asterisk_server_packets";
	add0="allow $1 asterisk_server_packet_t:packet recv;";
}
if(iii==440){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_asterisk_server_packets";
	add0="dontaudit $1 asterisk_server_packet_t:packet recv;";
}
if(iii==441){
	add_number=0;
	raw_interface_name="corenet_sendrecv_asterisk_server_packets";
	add0="corenet_send_asterisk_server_packets($1)";
	add1="corenet_receive_asterisk_server_packets($1)";
	add_number =1;
}
if(iii==442){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_asterisk_server_packets";
	add0="corenet_dontaudit_send_asterisk_server_packets($1)";
	add1="corenet_dontaudit_receive_asterisk_server_packets($1)";
	add_number =1;
}
if(iii==443){
	add_number=0;
	raw_interface_name="corenet_relabelto_asterisk_server_packets";
	add0="allow $1 asterisk_server_packet_t:packet relabelto;";
}
if(iii==444){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_auth_port";
	add0="allow $1 auth_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==445){
	add_number=0;
	raw_interface_name="corenet_udp_send_auth_port";
	add0="allow $1 auth_port_t:udp_socket send_msg;";
}
if(iii==446){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_auth_port";
	add0="dontaudit $1 auth_port_t:udp_socket send_msg;";
}
if(iii==447){
	add_number=0;
	raw_interface_name="corenet_udp_receive_auth_port";
	add0="allow $1 auth_port_t:udp_socket recv_msg;";
}
if(iii==448){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_auth_port";
	add0="dontaudit $1 auth_port_t:udp_socket recv_msg;";
}
if(iii==449){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_auth_port";
	add0="corenet_udp_send_auth_port($1)";
	add1="corenet_udp_receive_auth_port($1)";
	add_number =1;
}
if(iii==450){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_auth_port";
	add0="corenet_dontaudit_udp_send_auth_port($1)";
	add1="corenet_dontaudit_udp_receive_auth_port($1)";
	add_number =1;
}
if(iii==451){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_auth_port";
	add0="allow $1 auth_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==452){
	add_number=0;
	raw_interface_name="corenet_udp_bind_auth_port";
	add0="allow $1 auth_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==453){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_auth_port";
	add0="allow $1 auth_port_t:tcp_socket name_connect;";
}
if(iii==454){
	add_number=0;
	raw_interface_name="corenet_send_auth_client_packets";
	add0="allow $1 auth_client_packet_t:packet send;";
}
if(iii==455){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_auth_client_packets";
	add0="dontaudit $1 auth_client_packet_t:packet send;";
}
if(iii==456){
	add_number=0;
	raw_interface_name="corenet_receive_auth_client_packets";
	add0="allow $1 auth_client_packet_t:packet recv;";
}
if(iii==457){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_auth_client_packets";
	add0="dontaudit $1 auth_client_packet_t:packet recv;";
}
if(iii==458){
	add_number=0;
	raw_interface_name="corenet_sendrecv_auth_client_packets";
	add0="corenet_send_auth_client_packets($1)";
	add1="corenet_receive_auth_client_packets($1)";
	add_number =1;
}
if(iii==459){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_auth_client_packets";
	add0="corenet_dontaudit_send_auth_client_packets($1)";
	add1="corenet_dontaudit_receive_auth_client_packets($1)";
	add_number =1;
}
if(iii==460){
	add_number=0;
	raw_interface_name="corenet_relabelto_auth_client_packets";
	add0="allow $1 auth_client_packet_t:packet relabelto;";
}
if(iii==461){
	add_number=0;
	raw_interface_name="corenet_send_auth_server_packets";
	add0="allow $1 auth_server_packet_t:packet send;";
}
if(iii==462){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_auth_server_packets";
	add0="dontaudit $1 auth_server_packet_t:packet send;";
}
if(iii==463){
	add_number=0;
	raw_interface_name="corenet_receive_auth_server_packets";
	add0="allow $1 auth_server_packet_t:packet recv;";
}
if(iii==464){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_auth_server_packets";
	add0="dontaudit $1 auth_server_packet_t:packet recv;";
}
if(iii==465){
	add_number=0;
	raw_interface_name="corenet_sendrecv_auth_server_packets";
	add0="corenet_send_auth_server_packets($1)";
	add1="corenet_receive_auth_server_packets($1)";
	add_number =1;
}
if(iii==466){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_auth_server_packets";
	add0="corenet_dontaudit_send_auth_server_packets($1)";
	add1="corenet_dontaudit_receive_auth_server_packets($1)";
	add_number =1;
}
if(iii==467){
	add_number=0;
	raw_interface_name="corenet_relabelto_auth_server_packets";
	add0="allow $1 auth_server_packet_t:packet relabelto;";
}
if(iii==468){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_bgp_port";
	add0="allow $1 bgp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==469){
	add_number=0;
	raw_interface_name="corenet_udp_send_bgp_port";
	add0="allow $1 bgp_port_t:udp_socket send_msg;";
}
if(iii==470){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_bgp_port";
	add0="dontaudit $1 bgp_port_t:udp_socket send_msg;";
}
if(iii==471){
	add_number=0;
	raw_interface_name="corenet_udp_receive_bgp_port";
	add0="allow $1 bgp_port_t:udp_socket recv_msg;";
}
if(iii==472){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_bgp_port";
	add0="dontaudit $1 bgp_port_t:udp_socket recv_msg;";
}
if(iii==473){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_bgp_port";
	add0="corenet_udp_send_bgp_port($1)";
	add1="corenet_udp_receive_bgp_port($1)";
	add_number =1;
}
if(iii==474){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_bgp_port";
	add0="corenet_dontaudit_udp_send_bgp_port($1)";
	add1="corenet_dontaudit_udp_receive_bgp_port($1)";
	add_number =1;
}
if(iii==475){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_bgp_port";
	add0="allow $1 bgp_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==476){
	add_number=0;
	raw_interface_name="corenet_udp_bind_bgp_port";
	add0="allow $1 bgp_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==477){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_bgp_port";
	add0="allow $1 bgp_port_t:tcp_socket name_connect;";
}
if(iii==478){
	add_number=0;
	raw_interface_name="corenet_send_bgp_client_packets";
	add0="allow $1 bgp_client_packet_t:packet send;";
}
if(iii==479){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_bgp_client_packets";
	add0="dontaudit $1 bgp_client_packet_t:packet send;";
}
if(iii==480){
	add_number=0;
	raw_interface_name="corenet_receive_bgp_client_packets";
	add0="allow $1 bgp_client_packet_t:packet recv;";
}
if(iii==481){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_bgp_client_packets";
	add0="dontaudit $1 bgp_client_packet_t:packet recv;";
}
if(iii==482){
	add_number=0;
	raw_interface_name="corenet_sendrecv_bgp_client_packets";
	add0="corenet_send_bgp_client_packets($1)";
	add1="corenet_receive_bgp_client_packets($1)";
	add_number =1;
}
if(iii==483){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_bgp_client_packets";
	add0="corenet_dontaudit_send_bgp_client_packets($1)";
	add1="corenet_dontaudit_receive_bgp_client_packets($1)";
	add_number =1;
}
if(iii==484){
	add_number=0;
	raw_interface_name="corenet_relabelto_bgp_client_packets";
	add0="allow $1 bgp_client_packet_t:packet relabelto;";
}
if(iii==485){
	add_number=0;
	raw_interface_name="corenet_send_bgp_server_packets";
	add0="allow $1 bgp_server_packet_t:packet send;";
}
if(iii==486){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_bgp_server_packets";
	add0="dontaudit $1 bgp_server_packet_t:packet send;";
}
if(iii==487){
	add_number=0;
	raw_interface_name="corenet_receive_bgp_server_packets";
	add0="allow $1 bgp_server_packet_t:packet recv;";
}
if(iii==488){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_bgp_server_packets";
	add0="dontaudit $1 bgp_server_packet_t:packet recv;";
}
if(iii==489){
	add_number=0;
	raw_interface_name="corenet_sendrecv_bgp_server_packets";
	add0="corenet_send_bgp_server_packets($1)";
	add1="corenet_receive_bgp_server_packets($1)";
	add_number =1;
}
if(iii==490){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_bgp_server_packets";
	add0="corenet_dontaudit_send_bgp_server_packets($1)";
	add1="corenet_dontaudit_receive_bgp_server_packets($1)";
	add_number =1;
}
if(iii==491){
	add_number=0;
	raw_interface_name="corenet_relabelto_bgp_server_packets";
	add0="allow $1 bgp_server_packet_t:packet relabelto;";
}
if(iii==492){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_clamd_port";
	add0="allow $1 clamd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==493){
	add_number=0;
	raw_interface_name="corenet_udp_send_clamd_port";
	add0="allow $1 clamd_port_t:udp_socket send_msg;";
}
if(iii==494){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_clamd_port";
	add0="dontaudit $1 clamd_port_t:udp_socket send_msg;";
}
if(iii==495){
	add_number=0;
	raw_interface_name="corenet_udp_receive_clamd_port";
	add0="allow $1 clamd_port_t:udp_socket recv_msg;";
}
if(iii==496){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_clamd_port";
	add0="dontaudit $1 clamd_port_t:udp_socket recv_msg;";
}
if(iii==497){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_clamd_port";
	add0="corenet_udp_send_clamd_port($1)";
	add1="corenet_udp_receive_clamd_port($1)";
	add_number =1;
}
if(iii==498){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_clamd_port";
	add0="corenet_dontaudit_udp_send_clamd_port($1)";
	add1="corenet_dontaudit_udp_receive_clamd_port($1)";
	add_number =1;
}
if(iii==499){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_clamd_port";
	add0="allow $1 clamd_port_t:tcp_socket name_bind;";
}
if(iii==500){
	add_number=0;
	raw_interface_name="corenet_udp_bind_clamd_port";
	add0="allow $1 clamd_port_t:udp_socket name_bind;";
}
if(iii==501){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_clamd_port";
	add0="allow $1 clamd_port_t:tcp_socket name_connect;";
}
if(iii==502){
	add_number=0;
	raw_interface_name="corenet_send_clamd_client_packets";
	add0="allow $1 clamd_client_packet_t:packet send;";
}
if(iii==503){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_clamd_client_packets";
	add0="dontaudit $1 clamd_client_packet_t:packet send;";
}
if(iii==504){
	add_number=0;
	raw_interface_name="corenet_receive_clamd_client_packets";
	add0="allow $1 clamd_client_packet_t:packet recv;";
}
if(iii==505){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_clamd_client_packets";
	add0="dontaudit $1 clamd_client_packet_t:packet recv;";
}
if(iii==506){
	add_number=0;
	raw_interface_name="corenet_sendrecv_clamd_client_packets";
	add0="corenet_send_clamd_client_packets($1)";
	add1="corenet_receive_clamd_client_packets($1)";
	add_number =1;
}
if(iii==507){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_clamd_client_packets";
	add0="corenet_dontaudit_send_clamd_client_packets($1)";
	add1="corenet_dontaudit_receive_clamd_client_packets($1)";
	add_number =1;
}
if(iii==508){
	add_number=0;
	raw_interface_name="corenet_relabelto_clamd_client_packets";
	add0="allow $1 clamd_client_packet_t:packet relabelto;";
}
if(iii==509){
	add_number=0;
	raw_interface_name="corenet_send_clamd_server_packets";
	add0="allow $1 clamd_server_packet_t:packet send;";
}
if(iii==510){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_clamd_server_packets";
	add0="dontaudit $1 clamd_server_packet_t:packet send;";
}
if(iii==511){
	add_number=0;
	raw_interface_name="corenet_receive_clamd_server_packets";
	add0="allow $1 clamd_server_packet_t:packet recv;";
}
if(iii==512){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_clamd_server_packets";
	add0="dontaudit $1 clamd_server_packet_t:packet recv;";
}
if(iii==513){
	add_number=0;
	raw_interface_name="corenet_sendrecv_clamd_server_packets";
	add0="corenet_send_clamd_server_packets($1)";
	add1="corenet_receive_clamd_server_packets($1)";
	add_number =1;
}
if(iii==514){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_clamd_server_packets";
	add0="corenet_dontaudit_send_clamd_server_packets($1)";
	add1="corenet_dontaudit_receive_clamd_server_packets($1)";
	add_number =1;
}
if(iii==515){
	add_number=0;
	raw_interface_name="corenet_relabelto_clamd_server_packets";
	add0="allow $1 clamd_server_packet_t:packet relabelto;";
}
if(iii==516){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_clockspeed_port";
	add0="allow $1 clockspeed_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==517){
	add_number=0;
	raw_interface_name="corenet_udp_send_clockspeed_port";
	add0="allow $1 clockspeed_port_t:udp_socket send_msg;";
}
if(iii==518){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_clockspeed_port";
	add0="dontaudit $1 clockspeed_port_t:udp_socket send_msg;";
}
if(iii==519){
	add_number=0;
	raw_interface_name="corenet_udp_receive_clockspeed_port";
	add0="allow $1 clockspeed_port_t:udp_socket recv_msg;";
}
if(iii==520){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_clockspeed_port";
	add0="dontaudit $1 clockspeed_port_t:udp_socket recv_msg;";
}
if(iii==521){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_clockspeed_port";
	add0="corenet_udp_send_clockspeed_port($1)";
	add1="corenet_udp_receive_clockspeed_port($1)";
	add_number =1;
}
if(iii==522){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_clockspeed_port";
	add0="corenet_dontaudit_udp_send_clockspeed_port($1)";
	add1="corenet_dontaudit_udp_receive_clockspeed_port($1)";
	add_number =1;
}
if(iii==523){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_clockspeed_port";
	add0="allow $1 clockspeed_port_t:tcp_socket name_bind;";
}
if(iii==524){
	add_number=0;
	raw_interface_name="corenet_udp_bind_clockspeed_port";
	add0="allow $1 clockspeed_port_t:udp_socket name_bind;";
}
if(iii==525){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_clockspeed_port";
	add0="allow $1 clockspeed_port_t:tcp_socket name_connect;";
}
if(iii==526){
	add_number=0;
	raw_interface_name="corenet_send_clockspeed_client_packets";
	add0="allow $1 clockspeed_client_packet_t:packet send;";
}
if(iii==527){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_clockspeed_client_packets";
	add0="dontaudit $1 clockspeed_client_packet_t:packet send;";
}
if(iii==528){
	add_number=0;
	raw_interface_name="corenet_receive_clockspeed_client_packets";
	add0="allow $1 clockspeed_client_packet_t:packet recv;";
}
if(iii==529){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_clockspeed_client_packets";
	add0="dontaudit $1 clockspeed_client_packet_t:packet recv;";
}
if(iii==530){
	add_number=0;
	raw_interface_name="corenet_sendrecv_clockspeed_client_packets";
	add0="corenet_send_clockspeed_client_packets($1)";
	add1="corenet_receive_clockspeed_client_packets($1)";
	add_number =1;
}
if(iii==531){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_clockspeed_client_packets";
	add0="corenet_dontaudit_send_clockspeed_client_packets($1)";
	add1="corenet_dontaudit_receive_clockspeed_client_packets($1)";
	add_number =1;
}
if(iii==532){
	add_number=0;
	raw_interface_name="corenet_relabelto_clockspeed_client_packets";
	add0="allow $1 clockspeed_client_packet_t:packet relabelto;";
}
if(iii==533){
	add_number=0;
	raw_interface_name="corenet_send_clockspeed_server_packets";
	add0="allow $1 clockspeed_server_packet_t:packet send;";
}
if(iii==534){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_clockspeed_server_packets";
	add0="dontaudit $1 clockspeed_server_packet_t:packet send;";
}
if(iii==535){
	add_number=0;
	raw_interface_name="corenet_receive_clockspeed_server_packets";
	add0="allow $1 clockspeed_server_packet_t:packet recv;";
}
if(iii==536){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_clockspeed_server_packets";
	add0="dontaudit $1 clockspeed_server_packet_t:packet recv;";
}
if(iii==537){
	add_number=0;
	raw_interface_name="corenet_sendrecv_clockspeed_server_packets";
	add0="corenet_send_clockspeed_server_packets($1)";
	add1="corenet_receive_clockspeed_server_packets($1)";
	add_number =1;
}
if(iii==538){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_clockspeed_server_packets";
	add0="corenet_dontaudit_send_clockspeed_server_packets($1)";
	add1="corenet_dontaudit_receive_clockspeed_server_packets($1)";
	add_number =1;
}
if(iii==539){
	add_number=0;
	raw_interface_name="corenet_relabelto_clockspeed_server_packets";
	add0="allow $1 clockspeed_server_packet_t:packet relabelto;";
}
if(iii==540){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_cluster_port";
	add0="allow $1 cluster_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==541){
	add_number=0;
	raw_interface_name="corenet_udp_send_cluster_port";
	add0="allow $1 cluster_port_t:udp_socket send_msg;";
}
if(iii==542){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_cluster_port";
	add0="dontaudit $1 cluster_port_t:udp_socket send_msg;";
}
if(iii==543){
	add_number=0;
	raw_interface_name="corenet_udp_receive_cluster_port";
	add0="allow $1 cluster_port_t:udp_socket recv_msg;";
}
if(iii==544){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_cluster_port";
	add0="dontaudit $1 cluster_port_t:udp_socket recv_msg;";
}
if(iii==545){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_cluster_port";
	add0="corenet_udp_send_cluster_port($1)";
	add1="corenet_udp_receive_cluster_port($1)";
	add_number =1;
}
if(iii==546){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_cluster_port";
	add0="corenet_dontaudit_udp_send_cluster_port($1)";
	add1="corenet_dontaudit_udp_receive_cluster_port($1)";
	add_number =1;
}
if(iii==547){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_cluster_port";
	add0="allow $1 cluster_port_t:tcp_socket name_bind;";
}
if(iii==548){
	add_number=0;
	raw_interface_name="corenet_udp_bind_cluster_port";
	add0="allow $1 cluster_port_t:udp_socket name_bind;";
}
if(iii==549){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_cluster_port";
	add0="allow $1 cluster_port_t:tcp_socket name_connect;";
}
if(iii==550){
	add_number=0;
	raw_interface_name="corenet_send_cluster_client_packets";
	add0="allow $1 cluster_client_packet_t:packet send;";
}
if(iii==551){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_cluster_client_packets";
	add0="dontaudit $1 cluster_client_packet_t:packet send;";
}
if(iii==552){
	add_number=0;
	raw_interface_name="corenet_receive_cluster_client_packets";
	add0="allow $1 cluster_client_packet_t:packet recv;";
}
if(iii==553){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_cluster_client_packets";
	add0="dontaudit $1 cluster_client_packet_t:packet recv;";
}
if(iii==554){
	add_number=0;
	raw_interface_name="corenet_sendrecv_cluster_client_packets";
	add0="corenet_send_cluster_client_packets($1)";
	add1="corenet_receive_cluster_client_packets($1)";
	add_number =1;
}
if(iii==555){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_cluster_client_packets";
	add0="corenet_dontaudit_send_cluster_client_packets($1)";
	add1="corenet_dontaudit_receive_cluster_client_packets($1)";
	add_number =1;
}
if(iii==556){
	add_number=0;
	raw_interface_name="corenet_relabelto_cluster_client_packets";
	add0="allow $1 cluster_client_packet_t:packet relabelto;";
}
if(iii==557){
	add_number=0;
	raw_interface_name="corenet_send_cluster_server_packets";
	add0="allow $1 cluster_server_packet_t:packet send;";
}
if(iii==558){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_cluster_server_packets";
	add0="dontaudit $1 cluster_server_packet_t:packet send;";
}
if(iii==559){
	add_number=0;
	raw_interface_name="corenet_receive_cluster_server_packets";
	add0="allow $1 cluster_server_packet_t:packet recv;";
}
if(iii==560){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_cluster_server_packets";
	add0="dontaudit $1 cluster_server_packet_t:packet recv;";
}
if(iii==561){
	add_number=0;
	raw_interface_name="corenet_sendrecv_cluster_server_packets";
	add0="corenet_send_cluster_server_packets($1)";
	add1="corenet_receive_cluster_server_packets($1)";
	add_number =1;
}
if(iii==562){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_cluster_server_packets";
	add0="corenet_dontaudit_send_cluster_server_packets($1)";
	add1="corenet_dontaudit_receive_cluster_server_packets($1)";
	add_number =1;
}
if(iii==563){
	add_number=0;
	raw_interface_name="corenet_relabelto_cluster_server_packets";
	add0="allow $1 cluster_server_packet_t:packet relabelto;";
}
if(iii==564){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_comsat_port";
	add0="allow $1 comsat_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==565){
	add_number=0;
	raw_interface_name="corenet_udp_send_comsat_port";
	add0="allow $1 comsat_port_t:udp_socket send_msg;";
}
if(iii==566){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_comsat_port";
	add0="dontaudit $1 comsat_port_t:udp_socket send_msg;";
}
if(iii==567){
	add_number=0;
	raw_interface_name="corenet_udp_receive_comsat_port";
	add0="allow $1 comsat_port_t:udp_socket recv_msg;";
}
if(iii==568){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_comsat_port";
	add0="dontaudit $1 comsat_port_t:udp_socket recv_msg;";
}
if(iii==569){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_comsat_port";
	add0="corenet_udp_send_comsat_port($1)";
	add1="corenet_udp_receive_comsat_port($1)";
	add_number =1;
}
if(iii==570){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_comsat_port";
	add0="corenet_dontaudit_udp_send_comsat_port($1)";
	add1="corenet_dontaudit_udp_receive_comsat_port($1)";
	add_number =1;
}
if(iii==571){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_comsat_port";
	add0="allow $1 comsat_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==572){
	add_number=0;
	raw_interface_name="corenet_udp_bind_comsat_port";
	add0="allow $1 comsat_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==573){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_comsat_port";
	add0="allow $1 comsat_port_t:tcp_socket name_connect;";
}
if(iii==574){
	add_number=0;
	raw_interface_name="corenet_send_comsat_client_packets";
	add0="allow $1 comsat_client_packet_t:packet send;";
}
if(iii==575){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_comsat_client_packets";
	add0="dontaudit $1 comsat_client_packet_t:packet send;";
}
if(iii==576){
	add_number=0;
	raw_interface_name="corenet_receive_comsat_client_packets";
	add0="allow $1 comsat_client_packet_t:packet recv;";
}
if(iii==577){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_comsat_client_packets";
	add0="dontaudit $1 comsat_client_packet_t:packet recv;";
}
if(iii==578){
	add_number=0;
	raw_interface_name="corenet_sendrecv_comsat_client_packets";
	add0="corenet_send_comsat_client_packets($1)";
	add1="corenet_receive_comsat_client_packets($1)";
	add_number =1;
}
if(iii==579){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_comsat_client_packets";
	add0="corenet_dontaudit_send_comsat_client_packets($1)";
	add1="corenet_dontaudit_receive_comsat_client_packets($1)";
	add_number =1;
}
if(iii==580){
	add_number=0;
	raw_interface_name="corenet_relabelto_comsat_client_packets";
	add0="allow $1 comsat_client_packet_t:packet relabelto;";
}
if(iii==581){
	add_number=0;
	raw_interface_name="corenet_send_comsat_server_packets";
	add0="allow $1 comsat_server_packet_t:packet send;";
}
if(iii==582){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_comsat_server_packets";
	add0="dontaudit $1 comsat_server_packet_t:packet send;";
}
if(iii==583){
	add_number=0;
	raw_interface_name="corenet_receive_comsat_server_packets";
	add0="allow $1 comsat_server_packet_t:packet recv;";
}
if(iii==584){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_comsat_server_packets";
	add0="dontaudit $1 comsat_server_packet_t:packet recv;";
}
if(iii==585){
	add_number=0;
	raw_interface_name="corenet_sendrecv_comsat_server_packets";
	add0="corenet_send_comsat_server_packets($1)";
	add1="corenet_receive_comsat_server_packets($1)";
	add_number =1;
}
if(iii==586){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_comsat_server_packets";
	add0="corenet_dontaudit_send_comsat_server_packets($1)";
	add1="corenet_dontaudit_receive_comsat_server_packets($1)";
	add_number =1;
}
if(iii==587){
	add_number=0;
	raw_interface_name="corenet_relabelto_comsat_server_packets";
	add0="allow $1 comsat_server_packet_t:packet relabelto;";
}
if(iii==588){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_cvs_port";
	add0="allow $1 cvs_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==589){
	add_number=0;
	raw_interface_name="corenet_udp_send_cvs_port";
	add0="allow $1 cvs_port_t:udp_socket send_msg;";
}
if(iii==590){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_cvs_port";
	add0="dontaudit $1 cvs_port_t:udp_socket send_msg;";
}
if(iii==591){
	add_number=0;
	raw_interface_name="corenet_udp_receive_cvs_port";
	add0="allow $1 cvs_port_t:udp_socket recv_msg;";
}
if(iii==592){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_cvs_port";
	add0="dontaudit $1 cvs_port_t:udp_socket recv_msg;";
}
if(iii==593){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_cvs_port";
	add0="corenet_udp_send_cvs_port($1)";
	add1="corenet_udp_receive_cvs_port($1)";
	add_number =1;
}
if(iii==594){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_cvs_port";
	add0="corenet_dontaudit_udp_send_cvs_port($1)";
	add1="corenet_dontaudit_udp_receive_cvs_port($1)";
	add_number =1;
}
if(iii==595){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_cvs_port";
	add0="allow $1 cvs_port_t:tcp_socket name_bind;";
}
if(iii==596){
	add_number=0;
	raw_interface_name="corenet_udp_bind_cvs_port";
	add0="allow $1 cvs_port_t:udp_socket name_bind;";
}
if(iii==597){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_cvs_port";
	add0="allow $1 cvs_port_t:tcp_socket name_connect;";
}
if(iii==598){
	add_number=0;
	raw_interface_name="corenet_send_cvs_client_packets";
	add0="allow $1 cvs_client_packet_t:packet send;";
}
if(iii==599){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_cvs_client_packets";
	add0="dontaudit $1 cvs_client_packet_t:packet send;";
}
if(iii==600){
	add_number=0;
	raw_interface_name="corenet_receive_cvs_client_packets";
	add0="allow $1 cvs_client_packet_t:packet recv;";
}
if(iii==601){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_cvs_client_packets";
	add0="dontaudit $1 cvs_client_packet_t:packet recv;";
}
if(iii==602){
	add_number=0;
	raw_interface_name="corenet_sendrecv_cvs_client_packets";
	add0="corenet_send_cvs_client_packets($1)";
	add1="corenet_receive_cvs_client_packets($1)";
	add_number =1;
}
if(iii==603){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_cvs_client_packets";
	add0="corenet_dontaudit_send_cvs_client_packets($1)";
	add1="corenet_dontaudit_receive_cvs_client_packets($1)";
	add_number =1;
}
if(iii==604){
	add_number=0;
	raw_interface_name="corenet_relabelto_cvs_client_packets";
	add0="allow $1 cvs_client_packet_t:packet relabelto;";
}
if(iii==605){
	add_number=0;
	raw_interface_name="corenet_send_cvs_server_packets";
	add0="allow $1 cvs_server_packet_t:packet send;";
}
if(iii==606){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_cvs_server_packets";
	add0="dontaudit $1 cvs_server_packet_t:packet send;";
}
if(iii==607){
	add_number=0;
	raw_interface_name="corenet_receive_cvs_server_packets";
	add0="allow $1 cvs_server_packet_t:packet recv;";
}
if(iii==608){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_cvs_server_packets";
	add0="dontaudit $1 cvs_server_packet_t:packet recv;";
}
if(iii==609){
	add_number=0;
	raw_interface_name="corenet_sendrecv_cvs_server_packets";
	add0="corenet_send_cvs_server_packets($1)";
	add1="corenet_receive_cvs_server_packets($1)";
	add_number =1;
}
if(iii==610){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_cvs_server_packets";
	add0="corenet_dontaudit_send_cvs_server_packets($1)";
	add1="corenet_dontaudit_receive_cvs_server_packets($1)";
	add_number =1;
}
if(iii==611){
	add_number=0;
	raw_interface_name="corenet_relabelto_cvs_server_packets";
	add0="allow $1 cvs_server_packet_t:packet relabelto;";
}
if(iii==612){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_dcc_port";
	add0="allow $1 dcc_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==613){
	add_number=0;
	raw_interface_name="corenet_udp_send_dcc_port";
	add0="allow $1 dcc_port_t:udp_socket send_msg;";
}
if(iii==614){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_dcc_port";
	add0="dontaudit $1 dcc_port_t:udp_socket send_msg;";
}
if(iii==615){
	add_number=0;
	raw_interface_name="corenet_udp_receive_dcc_port";
	add0="allow $1 dcc_port_t:udp_socket recv_msg;";
}
if(iii==616){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_dcc_port";
	add0="dontaudit $1 dcc_port_t:udp_socket recv_msg;";
}
if(iii==617){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_dcc_port";
	add0="corenet_udp_send_dcc_port($1)";
	add1="corenet_udp_receive_dcc_port($1)";
	add_number =1;
}
if(iii==618){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_dcc_port";
	add0="corenet_dontaudit_udp_send_dcc_port($1)";
	add1="corenet_dontaudit_udp_receive_dcc_port($1)";
	add_number =1;
}
if(iii==619){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_dcc_port";
	add0="allow $1 dcc_port_t:tcp_socket name_bind;";
}
if(iii==620){
	add_number=0;
	raw_interface_name="corenet_udp_bind_dcc_port";
	add0="allow $1 dcc_port_t:udp_socket name_bind;";
}
if(iii==621){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_dcc_port";
	add0="allow $1 dcc_port_t:tcp_socket name_connect;";
}
if(iii==622){
	add_number=0;
	raw_interface_name="corenet_send_dcc_client_packets";
	add0="allow $1 dcc_client_packet_t:packet send;";
}
if(iii==623){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dcc_client_packets";
	add0="dontaudit $1 dcc_client_packet_t:packet send;";
}
if(iii==624){
	add_number=0;
	raw_interface_name="corenet_receive_dcc_client_packets";
	add0="allow $1 dcc_client_packet_t:packet recv;";
}
if(iii==625){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dcc_client_packets";
	add0="dontaudit $1 dcc_client_packet_t:packet recv;";
}
if(iii==626){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dcc_client_packets";
	add0="corenet_send_dcc_client_packets($1)";
	add1="corenet_receive_dcc_client_packets($1)";
	add_number =1;
}
if(iii==627){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dcc_client_packets";
	add0="corenet_dontaudit_send_dcc_client_packets($1)";
	add1="corenet_dontaudit_receive_dcc_client_packets($1)";
	add_number =1;
}
if(iii==628){
	add_number=0;
	raw_interface_name="corenet_relabelto_dcc_client_packets";
	add0="allow $1 dcc_client_packet_t:packet relabelto;";
}
if(iii==629){
	add_number=0;
	raw_interface_name="corenet_send_dcc_server_packets";
	add0="allow $1 dcc_server_packet_t:packet send;";
}
if(iii==630){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dcc_server_packets";
	add0="dontaudit $1 dcc_server_packet_t:packet send;";
}
if(iii==631){
	add_number=0;
	raw_interface_name="corenet_receive_dcc_server_packets";
	add0="allow $1 dcc_server_packet_t:packet recv;";
}
if(iii==632){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dcc_server_packets";
	add0="dontaudit $1 dcc_server_packet_t:packet recv;";
}
if(iii==633){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dcc_server_packets";
	add0="corenet_send_dcc_server_packets($1)";
	add1="corenet_receive_dcc_server_packets($1)";
	add_number =1;
}
if(iii==634){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dcc_server_packets";
	add0="corenet_dontaudit_send_dcc_server_packets($1)";
	add1="corenet_dontaudit_receive_dcc_server_packets($1)";
	add_number =1;
}
if(iii==635){
	add_number=0;
	raw_interface_name="corenet_relabelto_dcc_server_packets";
	add0="allow $1 dcc_server_packet_t:packet relabelto;";
}
if(iii==636){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_dbskkd_port";
	add0="allow $1 dbskkd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==637){
	add_number=0;
	raw_interface_name="corenet_udp_send_dbskkd_port";
	add0="allow $1 dbskkd_port_t:udp_socket send_msg;";
}
if(iii==638){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_dbskkd_port";
	add0="dontaudit $1 dbskkd_port_t:udp_socket send_msg;";
}
if(iii==639){
	add_number=0;
	raw_interface_name="corenet_udp_receive_dbskkd_port";
	add0="allow $1 dbskkd_port_t:udp_socket recv_msg;";
}
if(iii==640){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_dbskkd_port";
	add0="dontaudit $1 dbskkd_port_t:udp_socket recv_msg;";
}
if(iii==641){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_dbskkd_port";
	add0="corenet_udp_send_dbskkd_port($1)";
	add1="corenet_udp_receive_dbskkd_port($1)";
	add_number =1;
}
if(iii==642){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_dbskkd_port";
	add0="corenet_dontaudit_udp_send_dbskkd_port($1)";
	add1="corenet_dontaudit_udp_receive_dbskkd_port($1)";
	add_number =1;
}
if(iii==643){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_dbskkd_port";
	add0="allow $1 dbskkd_port_t:tcp_socket name_bind;";
}
if(iii==644){
	add_number=0;
	raw_interface_name="corenet_udp_bind_dbskkd_port";
	add0="allow $1 dbskkd_port_t:udp_socket name_bind;";
}
if(iii==645){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_dbskkd_port";
	add0="allow $1 dbskkd_port_t:tcp_socket name_connect;";
}
if(iii==646){
	add_number=0;
	raw_interface_name="corenet_send_dbskkd_client_packets";
	add0="allow $1 dbskkd_client_packet_t:packet send;";
}
if(iii==647){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dbskkd_client_packets";
	add0="dontaudit $1 dbskkd_client_packet_t:packet send;";
}
if(iii==648){
	add_number=0;
	raw_interface_name="corenet_receive_dbskkd_client_packets";
	add0="allow $1 dbskkd_client_packet_t:packet recv;";
}
if(iii==649){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dbskkd_client_packets";
	add0="dontaudit $1 dbskkd_client_packet_t:packet recv;";
}
if(iii==650){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dbskkd_client_packets";
	add0="corenet_send_dbskkd_client_packets($1)";
	add1="corenet_receive_dbskkd_client_packets($1)";
	add_number =1;
}
if(iii==651){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dbskkd_client_packets";
	add0="corenet_dontaudit_send_dbskkd_client_packets($1)";
	add1="corenet_dontaudit_receive_dbskkd_client_packets($1)";
	add_number =1;
}
if(iii==652){
	add_number=0;
	raw_interface_name="corenet_relabelto_dbskkd_client_packets";
	add0="allow $1 dbskkd_client_packet_t:packet relabelto;";
}
if(iii==653){
	add_number=0;
	raw_interface_name="corenet_send_dbskkd_server_packets";
	add0="allow $1 dbskkd_server_packet_t:packet send;";
}
if(iii==654){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dbskkd_server_packets";
	add0="dontaudit $1 dbskkd_server_packet_t:packet send;";
}
if(iii==655){
	add_number=0;
	raw_interface_name="corenet_receive_dbskkd_server_packets";
	add0="allow $1 dbskkd_server_packet_t:packet recv;";
}
if(iii==656){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dbskkd_server_packets";
	add0="dontaudit $1 dbskkd_server_packet_t:packet recv;";
}
if(iii==657){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dbskkd_server_packets";
	add0="corenet_send_dbskkd_server_packets($1)";
	add1="corenet_receive_dbskkd_server_packets($1)";
	add_number =1;
}
if(iii==658){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dbskkd_server_packets";
	add0="corenet_dontaudit_send_dbskkd_server_packets($1)";
	add1="corenet_dontaudit_receive_dbskkd_server_packets($1)";
	add_number =1;
}
if(iii==659){
	add_number=0;
	raw_interface_name="corenet_relabelto_dbskkd_server_packets";
	add0="allow $1 dbskkd_server_packet_t:packet relabelto;";
}
if(iii==660){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_dhcpc_port";
	add0="allow $1 dhcpc_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==661){
	add_number=0;
	raw_interface_name="corenet_udp_send_dhcpc_port";
	add0="allow $1 dhcpc_port_t:udp_socket send_msg;";
}
if(iii==662){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_dhcpc_port";
	add0="dontaudit $1 dhcpc_port_t:udp_socket send_msg;";
}
if(iii==663){
	add_number=0;
	raw_interface_name="corenet_udp_receive_dhcpc_port";
	add0="allow $1 dhcpc_port_t:udp_socket recv_msg;";
}
if(iii==664){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_dhcpc_port";
	add0="dontaudit $1 dhcpc_port_t:udp_socket recv_msg;";
}
if(iii==665){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_dhcpc_port";
	add0="corenet_udp_send_dhcpc_port($1)";
	add1="corenet_udp_receive_dhcpc_port($1)";
	add_number =1;
}
if(iii==666){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_dhcpc_port";
	add0="corenet_dontaudit_udp_send_dhcpc_port($1)";
	add1="corenet_dontaudit_udp_receive_dhcpc_port($1)";
	add_number =1;
}
if(iii==667){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_dhcpc_port";
	add0="allow $1 dhcpc_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==668){
	add_number=0;
	raw_interface_name="corenet_udp_bind_dhcpc_port";
	add0="allow $1 dhcpc_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==669){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_dhcpc_port";
	add0="allow $1 dhcpc_port_t:tcp_socket name_connect;";
}
if(iii==670){
	add_number=0;
	raw_interface_name="corenet_send_dhcpc_client_packets";
	add0="allow $1 dhcpc_client_packet_t:packet send;";
}
if(iii==671){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dhcpc_client_packets";
	add0="dontaudit $1 dhcpc_client_packet_t:packet send;";
}
if(iii==672){
	add_number=0;
	raw_interface_name="corenet_receive_dhcpc_client_packets";
	add0="allow $1 dhcpc_client_packet_t:packet recv;";
}
if(iii==673){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dhcpc_client_packets";
	add0="dontaudit $1 dhcpc_client_packet_t:packet recv;";
}
if(iii==674){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dhcpc_client_packets";
	add0="corenet_send_dhcpc_client_packets($1)";
	add1="corenet_receive_dhcpc_client_packets($1)";
	add_number =1;
}
if(iii==675){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dhcpc_client_packets";
	add0="corenet_dontaudit_send_dhcpc_client_packets($1)";
	add1="corenet_dontaudit_receive_dhcpc_client_packets($1)";
	add_number =1;
}
if(iii==676){
	add_number=0;
	raw_interface_name="corenet_relabelto_dhcpc_client_packets";
	add0="allow $1 dhcpc_client_packet_t:packet relabelto;";
}
if(iii==677){
	add_number=0;
	raw_interface_name="corenet_send_dhcpc_server_packets";
	add0="allow $1 dhcpc_server_packet_t:packet send;";
}
if(iii==678){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dhcpc_server_packets";
	add0="dontaudit $1 dhcpc_server_packet_t:packet send;";
}
if(iii==679){
	add_number=0;
	raw_interface_name="corenet_receive_dhcpc_server_packets";
	add0="allow $1 dhcpc_server_packet_t:packet recv;";
}
if(iii==680){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dhcpc_server_packets";
	add0="dontaudit $1 dhcpc_server_packet_t:packet recv;";
}
if(iii==681){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dhcpc_server_packets";
	add0="corenet_send_dhcpc_server_packets($1)";
	add1="corenet_receive_dhcpc_server_packets($1)";
	add_number =1;
}
if(iii==682){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dhcpc_server_packets";
	add0="corenet_dontaudit_send_dhcpc_server_packets($1)";
	add1="corenet_dontaudit_receive_dhcpc_server_packets($1)";
	add_number =1;
}
if(iii==683){
	add_number=0;
	raw_interface_name="corenet_relabelto_dhcpc_server_packets";
	add0="allow $1 dhcpc_server_packet_t:packet relabelto;";
}
if(iii==684){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_dhcpd_port";
	add0="allow $1 dhcpd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==685){
	add_number=0;
	raw_interface_name="corenet_udp_send_dhcpd_port";
	add0="allow $1 dhcpd_port_t:udp_socket send_msg;";
}
if(iii==686){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_dhcpd_port";
	add0="dontaudit $1 dhcpd_port_t:udp_socket send_msg;";
}
if(iii==687){
	add_number=0;
	raw_interface_name="corenet_udp_receive_dhcpd_port";
	add0="allow $1 dhcpd_port_t:udp_socket recv_msg;";
}
if(iii==688){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_dhcpd_port";
	add0="dontaudit $1 dhcpd_port_t:udp_socket recv_msg;";
}
if(iii==689){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_dhcpd_port";
	add0="corenet_udp_send_dhcpd_port($1)";
	add1="corenet_udp_receive_dhcpd_port($1)";
	add_number =1;
}
if(iii==690){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_dhcpd_port";
	add0="corenet_dontaudit_udp_send_dhcpd_port($1)";
	add1="corenet_dontaudit_udp_receive_dhcpd_port($1)";
	add_number =1;
}
if(iii==691){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_dhcpd_port";
	add0="allow $1 dhcpd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==692){
	add_number=0;
	raw_interface_name="corenet_udp_bind_dhcpd_port";
	add0="allow $1 dhcpd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==693){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_dhcpd_port";
	add0="allow $1 dhcpd_port_t:tcp_socket name_connect;";
}
if(iii==694){
	add_number=0;
	raw_interface_name="corenet_send_dhcpd_client_packets";
	add0="allow $1 dhcpd_client_packet_t:packet send;";
}
if(iii==695){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dhcpd_client_packets";
	add0="dontaudit $1 dhcpd_client_packet_t:packet send;";
}
if(iii==696){
	add_number=0;
	raw_interface_name="corenet_receive_dhcpd_client_packets";
	add0="allow $1 dhcpd_client_packet_t:packet recv;";
}
if(iii==697){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dhcpd_client_packets";
	add0="dontaudit $1 dhcpd_client_packet_t:packet recv;";
}
if(iii==698){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dhcpd_client_packets";
	add0="corenet_send_dhcpd_client_packets($1)";
	add1="corenet_receive_dhcpd_client_packets($1)";
	add_number =1;
}
if(iii==699){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dhcpd_client_packets";
	add0="corenet_dontaudit_send_dhcpd_client_packets($1)";
	add1="corenet_dontaudit_receive_dhcpd_client_packets($1)";
	add_number =1;
}
if(iii==700){
	add_number=0;
	raw_interface_name="corenet_relabelto_dhcpd_client_packets";
	add0="allow $1 dhcpd_client_packet_t:packet relabelto;";
}
if(iii==701){
	add_number=0;
	raw_interface_name="corenet_send_dhcpd_server_packets";
	add0="allow $1 dhcpd_server_packet_t:packet send;";
}
if(iii==702){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dhcpd_server_packets";
	add0="dontaudit $1 dhcpd_server_packet_t:packet send;";
}
if(iii==703){
	add_number=0;
	raw_interface_name="corenet_receive_dhcpd_server_packets";
	add0="allow $1 dhcpd_server_packet_t:packet recv;";
}
if(iii==704){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dhcpd_server_packets";
	add0="dontaudit $1 dhcpd_server_packet_t:packet recv;";
}
if(iii==705){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dhcpd_server_packets";
	add0="corenet_send_dhcpd_server_packets($1)";
	add1="corenet_receive_dhcpd_server_packets($1)";
	add_number =1;
}
if(iii==706){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dhcpd_server_packets";
	add0="corenet_dontaudit_send_dhcpd_server_packets($1)";
	add1="corenet_dontaudit_receive_dhcpd_server_packets($1)";
	add_number =1;
}
if(iii==707){
	add_number=0;
	raw_interface_name="corenet_relabelto_dhcpd_server_packets";
	add0="allow $1 dhcpd_server_packet_t:packet relabelto;";
}
if(iii==708){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_dict_port";
	add0="allow $1 dict_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==709){
	add_number=0;
	raw_interface_name="corenet_udp_send_dict_port";
	add0="allow $1 dict_port_t:udp_socket send_msg;";
}
if(iii==710){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_dict_port";
	add0="dontaudit $1 dict_port_t:udp_socket send_msg;";
}
if(iii==711){
	add_number=0;
	raw_interface_name="corenet_udp_receive_dict_port";
	add0="allow $1 dict_port_t:udp_socket recv_msg;";
}
if(iii==712){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_dict_port";
	add0="dontaudit $1 dict_port_t:udp_socket recv_msg;";
}
if(iii==713){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_dict_port";
	add0="corenet_udp_send_dict_port($1)";
	add1="corenet_udp_receive_dict_port($1)";
	add_number =1;
}
if(iii==714){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_dict_port";
	add0="corenet_dontaudit_udp_send_dict_port($1)";
	add1="corenet_dontaudit_udp_receive_dict_port($1)";
	add_number =1;
}
if(iii==715){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_dict_port";
	add0="allow $1 dict_port_t:tcp_socket name_bind;";
}
if(iii==716){
	add_number=0;
	raw_interface_name="corenet_udp_bind_dict_port";
	add0="allow $1 dict_port_t:udp_socket name_bind;";
}
if(iii==717){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_dict_port";
	add0="allow $1 dict_port_t:tcp_socket name_connect;";
}
if(iii==718){
	add_number=0;
	raw_interface_name="corenet_send_dict_client_packets";
	add0="allow $1 dict_client_packet_t:packet send;";
}
if(iii==719){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dict_client_packets";
	add0="dontaudit $1 dict_client_packet_t:packet send;";
}
if(iii==720){
	add_number=0;
	raw_interface_name="corenet_receive_dict_client_packets";
	add0="allow $1 dict_client_packet_t:packet recv;";
}
if(iii==721){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dict_client_packets";
	add0="dontaudit $1 dict_client_packet_t:packet recv;";
}
if(iii==722){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dict_client_packets";
	add0="corenet_send_dict_client_packets($1)";
	add1="corenet_receive_dict_client_packets($1)";
	add_number =1;
}
if(iii==723){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dict_client_packets";
	add0="corenet_dontaudit_send_dict_client_packets($1)";
	add1="corenet_dontaudit_receive_dict_client_packets($1)";
	add_number =1;
}
if(iii==724){
	add_number=0;
	raw_interface_name="corenet_relabelto_dict_client_packets";
	add0="allow $1 dict_client_packet_t:packet relabelto;";
}
if(iii==725){
	add_number=0;
	raw_interface_name="corenet_send_dict_server_packets";
	add0="allow $1 dict_server_packet_t:packet send;";
}
if(iii==726){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dict_server_packets";
	add0="dontaudit $1 dict_server_packet_t:packet send;";
}
if(iii==727){
	add_number=0;
	raw_interface_name="corenet_receive_dict_server_packets";
	add0="allow $1 dict_server_packet_t:packet recv;";
}
if(iii==728){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dict_server_packets";
	add0="dontaudit $1 dict_server_packet_t:packet recv;";
}
if(iii==729){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dict_server_packets";
	add0="corenet_send_dict_server_packets($1)";
	add1="corenet_receive_dict_server_packets($1)";
	add_number =1;
}
if(iii==730){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dict_server_packets";
	add0="corenet_dontaudit_send_dict_server_packets($1)";
	add1="corenet_dontaudit_receive_dict_server_packets($1)";
	add_number =1;
}
if(iii==731){
	add_number=0;
	raw_interface_name="corenet_relabelto_dict_server_packets";
	add0="allow $1 dict_server_packet_t:packet relabelto;";
}
if(iii==732){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_distccd_port";
	add0="allow $1 distccd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==733){
	add_number=0;
	raw_interface_name="corenet_udp_send_distccd_port";
	add0="allow $1 distccd_port_t:udp_socket send_msg;";
}
if(iii==734){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_distccd_port";
	add0="dontaudit $1 distccd_port_t:udp_socket send_msg;";
}
if(iii==735){
	add_number=0;
	raw_interface_name="corenet_udp_receive_distccd_port";
	add0="allow $1 distccd_port_t:udp_socket recv_msg;";
}
if(iii==736){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_distccd_port";
	add0="dontaudit $1 distccd_port_t:udp_socket recv_msg;";
}
if(iii==737){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_distccd_port";
	add0="corenet_udp_send_distccd_port($1)";
	add1="corenet_udp_receive_distccd_port($1)";
	add_number =1;
}
if(iii==738){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_distccd_port";
	add0="corenet_dontaudit_udp_send_distccd_port($1)";
	add1="corenet_dontaudit_udp_receive_distccd_port($1)";
	add_number =1;
}
if(iii==739){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_distccd_port";
	add0="allow $1 distccd_port_t:tcp_socket name_bind;";
}
if(iii==740){
	add_number=0;
	raw_interface_name="corenet_udp_bind_distccd_port";
	add0="allow $1 distccd_port_t:udp_socket name_bind;";
}
if(iii==741){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_distccd_port";
	add0="allow $1 distccd_port_t:tcp_socket name_connect;";
}
if(iii==742){
	add_number=0;
	raw_interface_name="corenet_send_distccd_client_packets";
	add0="allow $1 distccd_client_packet_t:packet send;";
}
if(iii==743){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_distccd_client_packets";
	add0="dontaudit $1 distccd_client_packet_t:packet send;";
}
if(iii==744){
	add_number=0;
	raw_interface_name="corenet_receive_distccd_client_packets";
	add0="allow $1 distccd_client_packet_t:packet recv;";
}
if(iii==745){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_distccd_client_packets";
	add0="dontaudit $1 distccd_client_packet_t:packet recv;";
}
if(iii==746){
	add_number=0;
	raw_interface_name="corenet_sendrecv_distccd_client_packets";
	add0="corenet_send_distccd_client_packets($1)";
	add1="corenet_receive_distccd_client_packets($1)";
	add_number =1;
}
if(iii==747){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_distccd_client_packets";
	add0="corenet_dontaudit_send_distccd_client_packets($1)";
	add1="corenet_dontaudit_receive_distccd_client_packets($1)";
	add_number =1;
}
if(iii==748){
	add_number=0;
	raw_interface_name="corenet_relabelto_distccd_client_packets";
	add0="allow $1 distccd_client_packet_t:packet relabelto;";
}
if(iii==749){
	add_number=0;
	raw_interface_name="corenet_send_distccd_server_packets";
	add0="allow $1 distccd_server_packet_t:packet send;";
}
if(iii==750){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_distccd_server_packets";
	add0="dontaudit $1 distccd_server_packet_t:packet send;";
}
if(iii==751){
	add_number=0;
	raw_interface_name="corenet_receive_distccd_server_packets";
	add0="allow $1 distccd_server_packet_t:packet recv;";
}
if(iii==752){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_distccd_server_packets";
	add0="dontaudit $1 distccd_server_packet_t:packet recv;";
}
if(iii==753){
	add_number=0;
	raw_interface_name="corenet_sendrecv_distccd_server_packets";
	add0="corenet_send_distccd_server_packets($1)";
	add1="corenet_receive_distccd_server_packets($1)";
	add_number =1;
}
if(iii==754){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_distccd_server_packets";
	add0="corenet_dontaudit_send_distccd_server_packets($1)";
	add1="corenet_dontaudit_receive_distccd_server_packets($1)";
	add_number =1;
}
if(iii==755){
	add_number=0;
	raw_interface_name="corenet_relabelto_distccd_server_packets";
	add0="allow $1 distccd_server_packet_t:packet relabelto;";
}
if(iii==756){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_dns_port";
	add0="allow $1 dns_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==757){
	add_number=0;
	raw_interface_name="corenet_udp_send_dns_port";
	add0="allow $1 dns_port_t:udp_socket send_msg;";
}
if(iii==758){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_dns_port";
	add0="dontaudit $1 dns_port_t:udp_socket send_msg;";
}
if(iii==759){
	add_number=0;
	raw_interface_name="corenet_udp_receive_dns_port";
	add0="allow $1 dns_port_t:udp_socket recv_msg;";
}
if(iii==760){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_dns_port";
	add0="dontaudit $1 dns_port_t:udp_socket recv_msg;";
}
if(iii==761){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_dns_port";
	add0="corenet_udp_send_dns_port($1)";
	add1="corenet_udp_receive_dns_port($1)";
	add_number =1;
}
if(iii==762){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_dns_port";
	add0="corenet_dontaudit_udp_send_dns_port($1)";
	add1="corenet_dontaudit_udp_receive_dns_port($1)";
	add_number =1;
}
if(iii==763){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_dns_port";
	add0="allow $1 dns_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==764){
	add_number=0;
	raw_interface_name="corenet_udp_bind_dns_port";
	add0="allow $1 dns_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==765){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_dns_port";
	add0="allow $1 dns_port_t:tcp_socket name_connect;";
}
if(iii==766){
	add_number=0;
	raw_interface_name="corenet_send_dns_client_packets";
	add0="allow $1 dns_client_packet_t:packet send;";
}
if(iii==767){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dns_client_packets";
	add0="dontaudit $1 dns_client_packet_t:packet send;";
}
if(iii==768){
	add_number=0;
	raw_interface_name="corenet_receive_dns_client_packets";
	add0="allow $1 dns_client_packet_t:packet recv;";
}
if(iii==769){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dns_client_packets";
	add0="dontaudit $1 dns_client_packet_t:packet recv;";
}
if(iii==770){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dns_client_packets";
	add0="corenet_send_dns_client_packets($1)";
	add1="corenet_receive_dns_client_packets($1)";
	add_number =1;
}
if(iii==771){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dns_client_packets";
	add0="corenet_dontaudit_send_dns_client_packets($1)";
	add1="corenet_dontaudit_receive_dns_client_packets($1)";
	add_number =1;
}
if(iii==772){
	add_number=0;
	raw_interface_name="corenet_relabelto_dns_client_packets";
	add0="allow $1 dns_client_packet_t:packet relabelto;";
}
if(iii==773){
	add_number=0;
	raw_interface_name="corenet_send_dns_server_packets";
	add0="allow $1 dns_server_packet_t:packet send;";
}
if(iii==774){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_dns_server_packets";
	add0="dontaudit $1 dns_server_packet_t:packet send;";
}
if(iii==775){
	add_number=0;
	raw_interface_name="corenet_receive_dns_server_packets";
	add0="allow $1 dns_server_packet_t:packet recv;";
}
if(iii==776){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_dns_server_packets";
	add0="dontaudit $1 dns_server_packet_t:packet recv;";
}
if(iii==777){
	add_number=0;
	raw_interface_name="corenet_sendrecv_dns_server_packets";
	add0="corenet_send_dns_server_packets($1)";
	add1="corenet_receive_dns_server_packets($1)";
	add_number =1;
}
if(iii==778){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_dns_server_packets";
	add0="corenet_dontaudit_send_dns_server_packets($1)";
	add1="corenet_dontaudit_receive_dns_server_packets($1)";
	add_number =1;
}
if(iii==779){
	add_number=0;
	raw_interface_name="corenet_relabelto_dns_server_packets";
	add0="allow $1 dns_server_packet_t:packet relabelto;";
}
if(iii==780){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_fingerd_port";
	add0="allow $1 fingerd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==781){
	add_number=0;
	raw_interface_name="corenet_udp_send_fingerd_port";
	add0="allow $1 fingerd_port_t:udp_socket send_msg;";
}
if(iii==782){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_fingerd_port";
	add0="dontaudit $1 fingerd_port_t:udp_socket send_msg;";
}
if(iii==783){
	add_number=0;
	raw_interface_name="corenet_udp_receive_fingerd_port";
	add0="allow $1 fingerd_port_t:udp_socket recv_msg;";
}
if(iii==784){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_fingerd_port";
	add0="dontaudit $1 fingerd_port_t:udp_socket recv_msg;";
}
if(iii==785){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_fingerd_port";
	add0="corenet_udp_send_fingerd_port($1)";
	add1="corenet_udp_receive_fingerd_port($1)";
	add_number =1;
}
if(iii==786){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_fingerd_port";
	add0="corenet_dontaudit_udp_send_fingerd_port($1)";
	add1="corenet_dontaudit_udp_receive_fingerd_port($1)";
	add_number =1;
}
if(iii==787){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_fingerd_port";
	add0="allow $1 fingerd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==788){
	add_number=0;
	raw_interface_name="corenet_udp_bind_fingerd_port";
	add0="allow $1 fingerd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==789){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_fingerd_port";
	add0="allow $1 fingerd_port_t:tcp_socket name_connect;";
}
if(iii==790){
	add_number=0;
	raw_interface_name="corenet_send_fingerd_client_packets";
	add0="allow $1 fingerd_client_packet_t:packet send;";
}
if(iii==791){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_fingerd_client_packets";
	add0="dontaudit $1 fingerd_client_packet_t:packet send;";
}
if(iii==792){
	add_number=0;
	raw_interface_name="corenet_receive_fingerd_client_packets";
	add0="allow $1 fingerd_client_packet_t:packet recv;";
}
if(iii==793){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_fingerd_client_packets";
	add0="dontaudit $1 fingerd_client_packet_t:packet recv;";
}
if(iii==794){
	add_number=0;
	raw_interface_name="corenet_sendrecv_fingerd_client_packets";
	add0="corenet_send_fingerd_client_packets($1)";
	add1="corenet_receive_fingerd_client_packets($1)";
	add_number =1;
}
if(iii==795){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_fingerd_client_packets";
	add0="corenet_dontaudit_send_fingerd_client_packets($1)";
	add1="corenet_dontaudit_receive_fingerd_client_packets($1)";
	add_number =1;
}
if(iii==796){
	add_number=0;
	raw_interface_name="corenet_relabelto_fingerd_client_packets";
	add0="allow $1 fingerd_client_packet_t:packet relabelto;";
}
if(iii==797){
	add_number=0;
	raw_interface_name="corenet_send_fingerd_server_packets";
	add0="allow $1 fingerd_server_packet_t:packet send;";
}
if(iii==798){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_fingerd_server_packets";
	add0="dontaudit $1 fingerd_server_packet_t:packet send;";
}
if(iii==799){
	add_number=0;
	raw_interface_name="corenet_receive_fingerd_server_packets";
	add0="allow $1 fingerd_server_packet_t:packet recv;";
}
if(iii==800){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_fingerd_server_packets";
	add0="dontaudit $1 fingerd_server_packet_t:packet recv;";
}
if(iii==801){
	add_number=0;
	raw_interface_name="corenet_sendrecv_fingerd_server_packets";
	add0="corenet_send_fingerd_server_packets($1)";
	add1="corenet_receive_fingerd_server_packets($1)";
	add_number =1;
}
if(iii==802){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_fingerd_server_packets";
	add0="corenet_dontaudit_send_fingerd_server_packets($1)";
	add1="corenet_dontaudit_receive_fingerd_server_packets($1)";
	add_number =1;
}
if(iii==803){
	add_number=0;
	raw_interface_name="corenet_relabelto_fingerd_server_packets";
	add0="allow $1 fingerd_server_packet_t:packet relabelto;";
}
if(iii==804){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ftp_data_port";
	add0="allow $1 ftp_data_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==805){
	add_number=0;
	raw_interface_name="corenet_udp_send_ftp_data_port";
	add0="allow $1 ftp_data_port_t:udp_socket send_msg;";
}
if(iii==806){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ftp_data_port";
	add0="dontaudit $1 ftp_data_port_t:udp_socket send_msg;";
}
if(iii==807){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ftp_data_port";
	add0="allow $1 ftp_data_port_t:udp_socket recv_msg;";
}
if(iii==808){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ftp_data_port";
	add0="dontaudit $1 ftp_data_port_t:udp_socket recv_msg;";
}
if(iii==809){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ftp_data_port";
	add0="corenet_udp_send_ftp_data_port($1)";
	add1="corenet_udp_receive_ftp_data_port($1)";
	add_number =1;
}
if(iii==810){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ftp_data_port";
	add0="corenet_dontaudit_udp_send_ftp_data_port($1)";
	add1="corenet_dontaudit_udp_receive_ftp_data_port($1)";
	add_number =1;
}
if(iii==811){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ftp_data_port";
	add0="allow $1 ftp_data_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==812){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ftp_data_port";
	add0="allow $1 ftp_data_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==813){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ftp_data_port";
	add0="allow $1 ftp_data_port_t:tcp_socket name_connect;";
}
if(iii==814){
	add_number=0;
	raw_interface_name="corenet_send_ftp_data_client_packets";
	add0="allow $1 ftp_data_client_packet_t:packet send;";
}
if(iii==815){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ftp_data_client_packets";
	add0="dontaudit $1 ftp_data_client_packet_t:packet send;";
}
if(iii==816){
	add_number=0;
	raw_interface_name="corenet_receive_ftp_data_client_packets";
	add0="allow $1 ftp_data_client_packet_t:packet recv;";
}
if(iii==817){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ftp_data_client_packets";
	add0="dontaudit $1 ftp_data_client_packet_t:packet recv;";
}
if(iii==818){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ftp_data_client_packets";
	add0="corenet_send_ftp_data_client_packets($1)";
	add1="corenet_receive_ftp_data_client_packets($1)";
	add_number =1;
}
if(iii==819){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ftp_data_client_packets";
	add0="corenet_dontaudit_send_ftp_data_client_packets($1)";
	add1="corenet_dontaudit_receive_ftp_data_client_packets($1)";
	add_number =1;
}
if(iii==820){
	add_number=0;
	raw_interface_name="corenet_relabelto_ftp_data_client_packets";
	add0="allow $1 ftp_data_client_packet_t:packet relabelto;";
}
if(iii==821){
	add_number=0;
	raw_interface_name="corenet_send_ftp_data_server_packets";
	add0="allow $1 ftp_data_server_packet_t:packet send;";
}
if(iii==822){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ftp_data_server_packets";
	add0="dontaudit $1 ftp_data_server_packet_t:packet send;";
}
if(iii==823){
	add_number=0;
	raw_interface_name="corenet_receive_ftp_data_server_packets";
	add0="allow $1 ftp_data_server_packet_t:packet recv;";
}
if(iii==824){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ftp_data_server_packets";
	add0="dontaudit $1 ftp_data_server_packet_t:packet recv;";
}
if(iii==825){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ftp_data_server_packets";
	add0="corenet_send_ftp_data_server_packets($1)";
	add1="corenet_receive_ftp_data_server_packets($1)";
	add_number =1;
}
if(iii==826){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ftp_data_server_packets";
	add0="corenet_dontaudit_send_ftp_data_server_packets($1)";
	add1="corenet_dontaudit_receive_ftp_data_server_packets($1)";
	add_number =1;
}
if(iii==827){
	add_number=0;
	raw_interface_name="corenet_relabelto_ftp_data_server_packets";
	add0="allow $1 ftp_data_server_packet_t:packet relabelto;";
}
if(iii==828){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ftp_port";
	add0="allow $1 ftp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==829){
	add_number=0;
	raw_interface_name="corenet_udp_send_ftp_port";
	add0="allow $1 ftp_port_t:udp_socket send_msg;";
}
if(iii==830){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ftp_port";
	add0="dontaudit $1 ftp_port_t:udp_socket send_msg;";
}
if(iii==831){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ftp_port";
	add0="allow $1 ftp_port_t:udp_socket recv_msg;";
}
if(iii==832){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ftp_port";
	add0="dontaudit $1 ftp_port_t:udp_socket recv_msg;";
}
if(iii==833){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ftp_port";
	add0="corenet_udp_send_ftp_port($1)";
	add1="corenet_udp_receive_ftp_port($1)";
	add_number =1;
}
if(iii==834){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ftp_port";
	add0="corenet_dontaudit_udp_send_ftp_port($1)";
	add1="corenet_dontaudit_udp_receive_ftp_port($1)";
	add_number =1;
}
if(iii==835){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ftp_port";
	add0="allow $1 ftp_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==836){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ftp_port";
	add0="allow $1 ftp_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==837){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ftp_port";
	add0="allow $1 ftp_port_t:tcp_socket name_connect;";
}
if(iii==838){
	add_number=0;
	raw_interface_name="corenet_send_ftp_client_packets";
	add0="allow $1 ftp_client_packet_t:packet send;";
}
if(iii==839){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ftp_client_packets";
	add0="dontaudit $1 ftp_client_packet_t:packet send;";
}
if(iii==840){
	add_number=0;
	raw_interface_name="corenet_receive_ftp_client_packets";
	add0="allow $1 ftp_client_packet_t:packet recv;";
}
if(iii==841){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ftp_client_packets";
	add0="dontaudit $1 ftp_client_packet_t:packet recv;";
}
if(iii==842){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ftp_client_packets";
	add0="corenet_send_ftp_client_packets($1)";
	add1="corenet_receive_ftp_client_packets($1)";
	add_number =1;
}
if(iii==843){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ftp_client_packets";
	add0="corenet_dontaudit_send_ftp_client_packets($1)";
	add1="corenet_dontaudit_receive_ftp_client_packets($1)";
	add_number =1;
}
if(iii==844){
	add_number=0;
	raw_interface_name="corenet_relabelto_ftp_client_packets";
	add0="allow $1 ftp_client_packet_t:packet relabelto;";
}
if(iii==845){
	add_number=0;
	raw_interface_name="corenet_send_ftp_server_packets";
	add0="allow $1 ftp_server_packet_t:packet send;";
}
if(iii==846){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ftp_server_packets";
	add0="dontaudit $1 ftp_server_packet_t:packet send;";
}
if(iii==847){
	add_number=0;
	raw_interface_name="corenet_receive_ftp_server_packets";
	add0="allow $1 ftp_server_packet_t:packet recv;";
}
if(iii==848){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ftp_server_packets";
	add0="dontaudit $1 ftp_server_packet_t:packet recv;";
}
if(iii==849){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ftp_server_packets";
	add0="corenet_send_ftp_server_packets($1)";
	add1="corenet_receive_ftp_server_packets($1)";
	add_number =1;
}
if(iii==850){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ftp_server_packets";
	add0="corenet_dontaudit_send_ftp_server_packets($1)";
	add1="corenet_dontaudit_receive_ftp_server_packets($1)";
	add_number =1;
}
if(iii==851){
	add_number=0;
	raw_interface_name="corenet_relabelto_ftp_server_packets";
	add0="allow $1 ftp_server_packet_t:packet relabelto;";
}
if(iii==852){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_gatekeeper_port";
	add0="allow $1 gatekeeper_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==853){
	add_number=0;
	raw_interface_name="corenet_udp_send_gatekeeper_port";
	add0="allow $1 gatekeeper_port_t:udp_socket send_msg;";
}
if(iii==854){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_gatekeeper_port";
	add0="dontaudit $1 gatekeeper_port_t:udp_socket send_msg;";
}
if(iii==855){
	add_number=0;
	raw_interface_name="corenet_udp_receive_gatekeeper_port";
	add0="allow $1 gatekeeper_port_t:udp_socket recv_msg;";
}
if(iii==856){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_gatekeeper_port";
	add0="dontaudit $1 gatekeeper_port_t:udp_socket recv_msg;";
}
if(iii==857){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_gatekeeper_port";
	add0="corenet_udp_send_gatekeeper_port($1)";
	add1="corenet_udp_receive_gatekeeper_port($1)";
	add_number =1;
}
if(iii==858){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_gatekeeper_port";
	add0="corenet_dontaudit_udp_send_gatekeeper_port($1)";
	add1="corenet_dontaudit_udp_receive_gatekeeper_port($1)";
	add_number =1;
}
if(iii==859){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_gatekeeper_port";
	add0="allow $1 gatekeeper_port_t:tcp_socket name_bind;";
}
if(iii==860){
	add_number=0;
	raw_interface_name="corenet_udp_bind_gatekeeper_port";
	add0="allow $1 gatekeeper_port_t:udp_socket name_bind;";
}
if(iii==861){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_gatekeeper_port";
	add0="allow $1 gatekeeper_port_t:tcp_socket name_connect;";
}
if(iii==862){
	add_number=0;
	raw_interface_name="corenet_send_gatekeeper_client_packets";
	add0="allow $1 gatekeeper_client_packet_t:packet send;";
}
if(iii==863){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_gatekeeper_client_packets";
	add0="dontaudit $1 gatekeeper_client_packet_t:packet send;";
}
if(iii==864){
	add_number=0;
	raw_interface_name="corenet_receive_gatekeeper_client_packets";
	add0="allow $1 gatekeeper_client_packet_t:packet recv;";
}
if(iii==865){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_gatekeeper_client_packets";
	add0="dontaudit $1 gatekeeper_client_packet_t:packet recv;";
}
if(iii==866){
	add_number=0;
	raw_interface_name="corenet_sendrecv_gatekeeper_client_packets";
	add0="corenet_send_gatekeeper_client_packets($1)";
	add1="corenet_receive_gatekeeper_client_packets($1)";
	add_number =1;
}
if(iii==867){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_gatekeeper_client_packets";
	add0="corenet_dontaudit_send_gatekeeper_client_packets($1)";
	add1="corenet_dontaudit_receive_gatekeeper_client_packets($1)";
	add_number =1;
}
if(iii==868){
	add_number=0;
	raw_interface_name="corenet_relabelto_gatekeeper_client_packets";
	add0="allow $1 gatekeeper_client_packet_t:packet relabelto;";
}
if(iii==869){
	add_number=0;
	raw_interface_name="corenet_send_gatekeeper_server_packets";
	add0="allow $1 gatekeeper_server_packet_t:packet send;";
}
if(iii==870){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_gatekeeper_server_packets";
	add0="dontaudit $1 gatekeeper_server_packet_t:packet send;";
}
if(iii==871){
	add_number=0;
	raw_interface_name="corenet_receive_gatekeeper_server_packets";
	add0="allow $1 gatekeeper_server_packet_t:packet recv;";
}
if(iii==872){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_gatekeeper_server_packets";
	add0="dontaudit $1 gatekeeper_server_packet_t:packet recv;";
}
if(iii==873){
	add_number=0;
	raw_interface_name="corenet_sendrecv_gatekeeper_server_packets";
	add0="corenet_send_gatekeeper_server_packets($1)";
	add1="corenet_receive_gatekeeper_server_packets($1)";
	add_number =1;
}
if(iii==874){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_gatekeeper_server_packets";
	add0="corenet_dontaudit_send_gatekeeper_server_packets($1)";
	add1="corenet_dontaudit_receive_gatekeeper_server_packets($1)";
	add_number =1;
}
if(iii==875){
	add_number=0;
	raw_interface_name="corenet_relabelto_gatekeeper_server_packets";
	add0="allow $1 gatekeeper_server_packet_t:packet relabelto;";
}
if(iii==876){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_giftd_port";
	add0="allow $1 giftd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==877){
	add_number=0;
	raw_interface_name="corenet_udp_send_giftd_port";
	add0="allow $1 giftd_port_t:udp_socket send_msg;";
}
if(iii==878){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_giftd_port";
	add0="dontaudit $1 giftd_port_t:udp_socket send_msg;";
}
if(iii==879){
	add_number=0;
	raw_interface_name="corenet_udp_receive_giftd_port";
	add0="allow $1 giftd_port_t:udp_socket recv_msg;";
}
if(iii==880){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_giftd_port";
	add0="dontaudit $1 giftd_port_t:udp_socket recv_msg;";
}
if(iii==881){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_giftd_port";
	add0="corenet_udp_send_giftd_port($1)";
	add1="corenet_udp_receive_giftd_port($1)";
	add_number =1;
}
if(iii==882){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_giftd_port";
	add0="corenet_dontaudit_udp_send_giftd_port($1)";
	add1="corenet_dontaudit_udp_receive_giftd_port($1)";
	add_number =1;
}
if(iii==883){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_giftd_port";
	add0="allow $1 giftd_port_t:tcp_socket name_bind;";
}
if(iii==884){
	add_number=0;
	raw_interface_name="corenet_udp_bind_giftd_port";
	add0="allow $1 giftd_port_t:udp_socket name_bind;";
}
if(iii==885){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_giftd_port";
	add0="allow $1 giftd_port_t:tcp_socket name_connect;";
}
if(iii==886){
	add_number=0;
	raw_interface_name="corenet_send_giftd_client_packets";
	add0="allow $1 giftd_client_packet_t:packet send;";
}
if(iii==887){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_giftd_client_packets";
	add0="dontaudit $1 giftd_client_packet_t:packet send;";
}
if(iii==888){
	add_number=0;
	raw_interface_name="corenet_receive_giftd_client_packets";
	add0="allow $1 giftd_client_packet_t:packet recv;";
}
if(iii==889){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_giftd_client_packets";
	add0="dontaudit $1 giftd_client_packet_t:packet recv;";
}
if(iii==890){
	add_number=0;
	raw_interface_name="corenet_sendrecv_giftd_client_packets";
	add0="corenet_send_giftd_client_packets($1)";
	add1="corenet_receive_giftd_client_packets($1)";
	add_number =1;
}
if(iii==891){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_giftd_client_packets";
	add0="corenet_dontaudit_send_giftd_client_packets($1)";
	add1="corenet_dontaudit_receive_giftd_client_packets($1)";
	add_number =1;
}
if(iii==892){
	add_number=0;
	raw_interface_name="corenet_relabelto_giftd_client_packets";
	add0="allow $1 giftd_client_packet_t:packet relabelto;";
}
if(iii==893){
	add_number=0;
	raw_interface_name="corenet_send_giftd_server_packets";
	add0="allow $1 giftd_server_packet_t:packet send;";
}
if(iii==894){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_giftd_server_packets";
	add0="dontaudit $1 giftd_server_packet_t:packet send;";
}
if(iii==895){
	add_number=0;
	raw_interface_name="corenet_receive_giftd_server_packets";
	add0="allow $1 giftd_server_packet_t:packet recv;";
}
if(iii==896){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_giftd_server_packets";
	add0="dontaudit $1 giftd_server_packet_t:packet recv;";
}
if(iii==897){
	add_number=0;
	raw_interface_name="corenet_sendrecv_giftd_server_packets";
	add0="corenet_send_giftd_server_packets($1)";
	add1="corenet_receive_giftd_server_packets($1)";
	add_number =1;
}
if(iii==898){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_giftd_server_packets";
	add0="corenet_dontaudit_send_giftd_server_packets($1)";
	add1="corenet_dontaudit_receive_giftd_server_packets($1)";
	add_number =1;
}
if(iii==899){
	add_number=0;
	raw_interface_name="corenet_relabelto_giftd_server_packets";
	add0="allow $1 giftd_server_packet_t:packet relabelto;";
}
if(iii==900){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_gopher_port";
	add0="allow $1 gopher_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==901){
	add_number=0;
	raw_interface_name="corenet_udp_send_gopher_port";
	add0="allow $1 gopher_port_t:udp_socket send_msg;";
}
if(iii==902){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_gopher_port";
	add0="dontaudit $1 gopher_port_t:udp_socket send_msg;";
}
if(iii==903){
	add_number=0;
	raw_interface_name="corenet_udp_receive_gopher_port";
	add0="allow $1 gopher_port_t:udp_socket recv_msg;";
}
if(iii==904){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_gopher_port";
	add0="dontaudit $1 gopher_port_t:udp_socket recv_msg;";
}
if(iii==905){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_gopher_port";
	add0="corenet_udp_send_gopher_port($1)";
	add1="corenet_udp_receive_gopher_port($1)";
	add_number =1;
}
if(iii==906){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_gopher_port";
	add0="corenet_dontaudit_udp_send_gopher_port($1)";
	add1="corenet_dontaudit_udp_receive_gopher_port($1)";
	add_number =1;
}
if(iii==907){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_gopher_port";
	add0="allow $1 gopher_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==908){
	add_number=0;
	raw_interface_name="corenet_udp_bind_gopher_port";
	add0="allow $1 gopher_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==909){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_gopher_port";
	add0="allow $1 gopher_port_t:tcp_socket name_connect;";
}
if(iii==910){
	add_number=0;
	raw_interface_name="corenet_send_gopher_client_packets";
	add0="allow $1 gopher_client_packet_t:packet send;";
}
if(iii==911){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_gopher_client_packets";
	add0="dontaudit $1 gopher_client_packet_t:packet send;";
}
if(iii==912){
	add_number=0;
	raw_interface_name="corenet_receive_gopher_client_packets";
	add0="allow $1 gopher_client_packet_t:packet recv;";
}
if(iii==913){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_gopher_client_packets";
	add0="dontaudit $1 gopher_client_packet_t:packet recv;";
}
if(iii==914){
	add_number=0;
	raw_interface_name="corenet_sendrecv_gopher_client_packets";
	add0="corenet_send_gopher_client_packets($1)";
	add1="corenet_receive_gopher_client_packets($1)";
	add_number =1;
}
if(iii==915){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_gopher_client_packets";
	add0="corenet_dontaudit_send_gopher_client_packets($1)";
	add1="corenet_dontaudit_receive_gopher_client_packets($1)";
	add_number =1;
}
if(iii==916){
	add_number=0;
	raw_interface_name="corenet_relabelto_gopher_client_packets";
	add0="allow $1 gopher_client_packet_t:packet relabelto;";
}
if(iii==917){
	add_number=0;
	raw_interface_name="corenet_send_gopher_server_packets";
	add0="allow $1 gopher_server_packet_t:packet send;";
}
if(iii==918){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_gopher_server_packets";
	add0="dontaudit $1 gopher_server_packet_t:packet send;";
}
if(iii==919){
	add_number=0;
	raw_interface_name="corenet_receive_gopher_server_packets";
	add0="allow $1 gopher_server_packet_t:packet recv;";
}
if(iii==920){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_gopher_server_packets";
	add0="dontaudit $1 gopher_server_packet_t:packet recv;";
}
if(iii==921){
	add_number=0;
	raw_interface_name="corenet_sendrecv_gopher_server_packets";
	add0="corenet_send_gopher_server_packets($1)";
	add1="corenet_receive_gopher_server_packets($1)";
	add_number =1;
}
if(iii==922){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_gopher_server_packets";
	add0="corenet_dontaudit_send_gopher_server_packets($1)";
	add1="corenet_dontaudit_receive_gopher_server_packets($1)";
	add_number =1;
}
if(iii==923){
	add_number=0;
	raw_interface_name="corenet_relabelto_gopher_server_packets";
	add0="allow $1 gopher_server_packet_t:packet relabelto;";
}
if(iii==924){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_http_cache_port";
	add0="allow $1 http_cache_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==925){
	add_number=0;
	raw_interface_name="corenet_udp_send_http_cache_port";
	add0="allow $1 http_cache_port_t:udp_socket send_msg;";
}
if(iii==926){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_http_cache_port";
	add0="dontaudit $1 http_cache_port_t:udp_socket send_msg;";
}
if(iii==927){
	add_number=0;
	raw_interface_name="corenet_udp_receive_http_cache_port";
	add0="allow $1 http_cache_port_t:udp_socket recv_msg;";
}
if(iii==928){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_http_cache_port";
	add0="dontaudit $1 http_cache_port_t:udp_socket recv_msg;";
}
if(iii==929){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_http_cache_port";
	add0="corenet_udp_send_http_cache_port($1)";
	add1="corenet_udp_receive_http_cache_port($1)";
	add_number =1;
}
if(iii==930){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_http_cache_port";
	add0="corenet_dontaudit_udp_send_http_cache_port($1)";
	add1="corenet_dontaudit_udp_receive_http_cache_port($1)";
	add_number =1;
}
if(iii==931){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_http_cache_port";
	add0="allow $1 http_cache_port_t:tcp_socket name_bind;";
}
if(iii==932){
	add_number=0;
	raw_interface_name="corenet_udp_bind_http_cache_port";
	add0="allow $1 http_cache_port_t:udp_socket name_bind;";
}
if(iii==933){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_http_cache_port";
	add0="allow $1 http_cache_port_t:tcp_socket name_connect;";
}
if(iii==934){
	add_number=0;
	raw_interface_name="corenet_send_http_cache_client_packets";
	add0="allow $1 http_cache_client_packet_t:packet send;";
}
if(iii==935){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_http_cache_client_packets";
	add0="dontaudit $1 http_cache_client_packet_t:packet send;";
}
if(iii==936){
	add_number=0;
	raw_interface_name="corenet_receive_http_cache_client_packets";
	add0="allow $1 http_cache_client_packet_t:packet recv;";
}
if(iii==937){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_http_cache_client_packets";
	add0="dontaudit $1 http_cache_client_packet_t:packet recv;";
}
if(iii==938){
	add_number=0;
	raw_interface_name="corenet_sendrecv_http_cache_client_packets";
	add0="corenet_send_http_cache_client_packets($1)";
	add1="corenet_receive_http_cache_client_packets($1)";
	add_number =1;
}
if(iii==939){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_http_cache_client_packets";
	add0="corenet_dontaudit_send_http_cache_client_packets($1)";
	add1="corenet_dontaudit_receive_http_cache_client_packets($1)";
	add_number =1;
}
if(iii==940){
	add_number=0;
	raw_interface_name="corenet_relabelto_http_cache_client_packets";
	add0="allow $1 http_cache_client_packet_t:packet relabelto;";
}
if(iii==941){
	add_number=0;
	raw_interface_name="corenet_send_http_cache_server_packets";
	add0="allow $1 http_cache_server_packet_t:packet send;";
}
if(iii==942){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_http_cache_server_packets";
	add0="dontaudit $1 http_cache_server_packet_t:packet send;";
}
if(iii==943){
	add_number=0;
	raw_interface_name="corenet_receive_http_cache_server_packets";
	add0="allow $1 http_cache_server_packet_t:packet recv;";
}
if(iii==944){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_http_cache_server_packets";
	add0="dontaudit $1 http_cache_server_packet_t:packet recv;";
}
if(iii==945){
	add_number=0;
	raw_interface_name="corenet_sendrecv_http_cache_server_packets";
	add0="corenet_send_http_cache_server_packets($1)";
	add1="corenet_receive_http_cache_server_packets($1)";
	add_number =1;
}
if(iii==946){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_http_cache_server_packets";
	add0="corenet_dontaudit_send_http_cache_server_packets($1)";
	add1="corenet_dontaudit_receive_http_cache_server_packets($1)";
	add_number =1;
}
if(iii==947){
	add_number=0;
	raw_interface_name="corenet_relabelto_http_cache_server_packets";
	add0="allow $1 http_cache_server_packet_t:packet relabelto;";
}
if(iii==948){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_http_port";
	add0="allow $1 http_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==949){
	add_number=0;
	raw_interface_name="corenet_udp_send_http_port";
	add0="allow $1 http_port_t:udp_socket send_msg;";
}
if(iii==950){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_http_port";
	add0="dontaudit $1 http_port_t:udp_socket send_msg;";
}
if(iii==951){
	add_number=0;
	raw_interface_name="corenet_udp_receive_http_port";
	add0="allow $1 http_port_t:udp_socket recv_msg;";
}
if(iii==952){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_http_port";
	add0="dontaudit $1 http_port_t:udp_socket recv_msg;";
}
if(iii==953){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_http_port";
	add0="corenet_udp_send_http_port($1)";
	add1="corenet_udp_receive_http_port($1)";
	add_number =1;
}
if(iii==954){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_http_port";
	add0="corenet_dontaudit_udp_send_http_port($1)";
	add1="corenet_dontaudit_udp_receive_http_port($1)";
	add_number =1;
}
if(iii==955){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_http_port";
	add0="allow $1 http_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==956){
	add_number=0;
	raw_interface_name="corenet_udp_bind_http_port";
	add0="allow $1 http_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==957){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_http_port";
	add0="allow $1 http_port_t:tcp_socket name_connect;";
}
if(iii==958){
	add_number=0;
	raw_interface_name="corenet_send_http_client_packets";
	add0="allow $1 http_client_packet_t:packet send;";
}
if(iii==959){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_http_client_packets";
	add0="dontaudit $1 http_client_packet_t:packet send;";
}
if(iii==960){
	add_number=0;
	raw_interface_name="corenet_receive_http_client_packets";
	add0="allow $1 http_client_packet_t:packet recv;";
}
if(iii==961){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_http_client_packets";
	add0="dontaudit $1 http_client_packet_t:packet recv;";
}
if(iii==962){
	add_number=0;
	raw_interface_name="corenet_sendrecv_http_client_packets";
	add0="corenet_send_http_client_packets($1)";
	add1="corenet_receive_http_client_packets($1)";
	add_number =1;
}
if(iii==963){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_http_client_packets";
	add0="corenet_dontaudit_send_http_client_packets($1)";
	add1="corenet_dontaudit_receive_http_client_packets($1)";
	add_number =1;
}
if(iii==964){
	add_number=0;
	raw_interface_name="corenet_relabelto_http_client_packets";
	add0="allow $1 http_client_packet_t:packet relabelto;";
}
if(iii==965){
	add_number=0;
	raw_interface_name="corenet_send_http_server_packets";
	add0="allow $1 http_server_packet_t:packet send;";
}
if(iii==966){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_http_server_packets";
	add0="dontaudit $1 http_server_packet_t:packet send;";
}
if(iii==967){
	add_number=0;
	raw_interface_name="corenet_receive_http_server_packets";
	add0="allow $1 http_server_packet_t:packet recv;";
}
if(iii==968){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_http_server_packets";
	add0="dontaudit $1 http_server_packet_t:packet recv;";
}
if(iii==969){
	add_number=0;
	raw_interface_name="corenet_sendrecv_http_server_packets";
	add0="corenet_send_http_server_packets($1)";
	add1="corenet_receive_http_server_packets($1)";
	add_number =1;
}
if(iii==970){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_http_server_packets";
	add0="corenet_dontaudit_send_http_server_packets($1)";
	add1="corenet_dontaudit_receive_http_server_packets($1)";
	add_number =1;
}
if(iii==971){
	add_number=0;
	raw_interface_name="corenet_relabelto_http_server_packets";
	add0="allow $1 http_server_packet_t:packet relabelto;";
}
if(iii==972){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_howl_port";
	add0="allow $1 howl_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==973){
	add_number=0;
	raw_interface_name="corenet_udp_send_howl_port";
	add0="allow $1 howl_port_t:udp_socket send_msg;";
}
if(iii==974){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_howl_port";
	add0="dontaudit $1 howl_port_t:udp_socket send_msg;";
}
if(iii==975){
	add_number=0;
	raw_interface_name="corenet_udp_receive_howl_port";
	add0="allow $1 howl_port_t:udp_socket recv_msg;";
}
if(iii==976){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_howl_port";
	add0="dontaudit $1 howl_port_t:udp_socket recv_msg;";
}
if(iii==977){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_howl_port";
	add0="corenet_udp_send_howl_port($1)";
	add1="corenet_udp_receive_howl_port($1)";
	add_number =1;
}
if(iii==978){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_howl_port";
	add0="corenet_dontaudit_udp_send_howl_port($1)";
	add1="corenet_dontaudit_udp_receive_howl_port($1)";
	add_number =1;
}
if(iii==979){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_howl_port";
	add0="allow $1 howl_port_t:tcp_socket name_bind;";
}
if(iii==980){
	add_number=0;
	raw_interface_name="corenet_udp_bind_howl_port";
	add0="allow $1 howl_port_t:udp_socket name_bind;";
}
if(iii==981){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_howl_port";
	add0="allow $1 howl_port_t:tcp_socket name_connect;";
}
if(iii==982){
	add_number=0;
	raw_interface_name="corenet_send_howl_client_packets";
	add0="allow $1 howl_client_packet_t:packet send;";
}
if(iii==983){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_howl_client_packets";
	add0="dontaudit $1 howl_client_packet_t:packet send;";
}
if(iii==984){
	add_number=0;
	raw_interface_name="corenet_receive_howl_client_packets";
	add0="allow $1 howl_client_packet_t:packet recv;";
}
if(iii==985){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_howl_client_packets";
	add0="dontaudit $1 howl_client_packet_t:packet recv;";
}
if(iii==986){
	add_number=0;
	raw_interface_name="corenet_sendrecv_howl_client_packets";
	add0="corenet_send_howl_client_packets($1)";
	add1="corenet_receive_howl_client_packets($1)";
	add_number =1;
}
if(iii==987){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_howl_client_packets";
	add0="corenet_dontaudit_send_howl_client_packets($1)";
	add1="corenet_dontaudit_receive_howl_client_packets($1)";
	add_number =1;
}
if(iii==988){
	add_number=0;
	raw_interface_name="corenet_relabelto_howl_client_packets";
	add0="allow $1 howl_client_packet_t:packet relabelto;";
}
if(iii==989){
	add_number=0;
	raw_interface_name="corenet_send_howl_server_packets";
	add0="allow $1 howl_server_packet_t:packet send;";
}
if(iii==990){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_howl_server_packets";
	add0="dontaudit $1 howl_server_packet_t:packet send;";
}
if(iii==991){
	add_number=0;
	raw_interface_name="corenet_receive_howl_server_packets";
	add0="allow $1 howl_server_packet_t:packet recv;";
}
if(iii==992){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_howl_server_packets";
	add0="dontaudit $1 howl_server_packet_t:packet recv;";
}
if(iii==993){
	add_number=0;
	raw_interface_name="corenet_sendrecv_howl_server_packets";
	add0="corenet_send_howl_server_packets($1)";
	add1="corenet_receive_howl_server_packets($1)";
	add_number =1;
}
if(iii==994){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_howl_server_packets";
	add0="corenet_dontaudit_send_howl_server_packets($1)";
	add1="corenet_dontaudit_receive_howl_server_packets($1)";
	add_number =1;
}
if(iii==995){
	add_number=0;
	raw_interface_name="corenet_relabelto_howl_server_packets";
	add0="allow $1 howl_server_packet_t:packet relabelto;";
}
if(iii==996){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_hplip_port";
	add0="allow $1 hplip_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==997){
	add_number=0;
	raw_interface_name="corenet_udp_send_hplip_port";
	add0="allow $1 hplip_port_t:udp_socket send_msg;";
}
if(iii==998){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_hplip_port";
	add0="dontaudit $1 hplip_port_t:udp_socket send_msg;";
}
if(iii==999){
	add_number=0;
	raw_interface_name="corenet_udp_receive_hplip_port";
	add0="allow $1 hplip_port_t:udp_socket recv_msg;";
}
if(iii==1000){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_hplip_port";
	add0="dontaudit $1 hplip_port_t:udp_socket recv_msg;";
}
if(iii==1001){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_hplip_port";
	add0="corenet_udp_send_hplip_port($1)";
	add1="corenet_udp_receive_hplip_port($1)";
	add_number =1;
}
if(iii==1002){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_hplip_port";
	add0="corenet_dontaudit_udp_send_hplip_port($1)";
	add1="corenet_dontaudit_udp_receive_hplip_port($1)";
	add_number =1;
}
if(iii==1003){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_hplip_port";
	add0="allow $1 hplip_port_t:tcp_socket name_bind;";
}
if(iii==1004){
	add_number=0;
	raw_interface_name="corenet_udp_bind_hplip_port";
	add0="allow $1 hplip_port_t:udp_socket name_bind;";
}
if(iii==1005){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_hplip_port";
	add0="allow $1 hplip_port_t:tcp_socket name_connect;";
}
if(iii==1006){
	add_number=0;
	raw_interface_name="corenet_send_hplip_client_packets";
	add0="allow $1 hplip_client_packet_t:packet send;";
}
if(iii==1007){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_hplip_client_packets";
	add0="dontaudit $1 hplip_client_packet_t:packet send;";
}
if(iii==1008){
	add_number=0;
	raw_interface_name="corenet_receive_hplip_client_packets";
	add0="allow $1 hplip_client_packet_t:packet recv;";
}
if(iii==1009){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_hplip_client_packets";
	add0="dontaudit $1 hplip_client_packet_t:packet recv;";
}
if(iii==1010){
	add_number=0;
	raw_interface_name="corenet_sendrecv_hplip_client_packets";
	add0="corenet_send_hplip_client_packets($1)";
	add1="corenet_receive_hplip_client_packets($1)";
	add_number =1;
}
if(iii==1011){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_hplip_client_packets";
	add0="corenet_dontaudit_send_hplip_client_packets($1)";
	add1="corenet_dontaudit_receive_hplip_client_packets($1)";
	add_number =1;
}
if(iii==1012){
	add_number=0;
	raw_interface_name="corenet_relabelto_hplip_client_packets";
	add0="allow $1 hplip_client_packet_t:packet relabelto;";
}
if(iii==1013){
	add_number=0;
	raw_interface_name="corenet_send_hplip_server_packets";
	add0="allow $1 hplip_server_packet_t:packet send;";
}
if(iii==1014){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_hplip_server_packets";
	add0="dontaudit $1 hplip_server_packet_t:packet send;";
}
if(iii==1015){
	add_number=0;
	raw_interface_name="corenet_receive_hplip_server_packets";
	add0="allow $1 hplip_server_packet_t:packet recv;";
}
if(iii==1016){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_hplip_server_packets";
	add0="dontaudit $1 hplip_server_packet_t:packet recv;";
}
if(iii==1017){
	add_number=0;
	raw_interface_name="corenet_sendrecv_hplip_server_packets";
	add0="corenet_send_hplip_server_packets($1)";
	add1="corenet_receive_hplip_server_packets($1)";
	add_number =1;
}
if(iii==1018){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_hplip_server_packets";
	add0="corenet_dontaudit_send_hplip_server_packets($1)";
	add1="corenet_dontaudit_receive_hplip_server_packets($1)";
	add_number =1;
}
if(iii==1019){
	add_number=0;
	raw_interface_name="corenet_relabelto_hplip_server_packets";
	add0="allow $1 hplip_server_packet_t:packet relabelto;";
}
if(iii==1020){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_i18n_input_port";
	add0="allow $1 i18n_input_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1021){
	add_number=0;
	raw_interface_name="corenet_udp_send_i18n_input_port";
	add0="allow $1 i18n_input_port_t:udp_socket send_msg;";
}
if(iii==1022){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_i18n_input_port";
	add0="dontaudit $1 i18n_input_port_t:udp_socket send_msg;";
}
if(iii==1023){
	add_number=0;
	raw_interface_name="corenet_udp_receive_i18n_input_port";
	add0="allow $1 i18n_input_port_t:udp_socket recv_msg;";
}
if(iii==1024){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_i18n_input_port";
	add0="dontaudit $1 i18n_input_port_t:udp_socket recv_msg;";
}
if(iii==1025){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_i18n_input_port";
	add0="corenet_udp_send_i18n_input_port($1)";
	add1="corenet_udp_receive_i18n_input_port($1)";
	add_number =1;
}
if(iii==1026){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_i18n_input_port";
	add0="corenet_dontaudit_udp_send_i18n_input_port($1)";
	add1="corenet_dontaudit_udp_receive_i18n_input_port($1)";
	add_number =1;
}
if(iii==1027){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_i18n_input_port";
	add0="allow $1 i18n_input_port_t:tcp_socket name_bind;";
}
if(iii==1028){
	add_number=0;
	raw_interface_name="corenet_udp_bind_i18n_input_port";
	add0="allow $1 i18n_input_port_t:udp_socket name_bind;";
}
if(iii==1029){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_i18n_input_port";
	add0="allow $1 i18n_input_port_t:tcp_socket name_connect;";
}
if(iii==1030){
	add_number=0;
	raw_interface_name="corenet_send_i18n_input_client_packets";
	add0="allow $1 i18n_input_client_packet_t:packet send;";
}
if(iii==1031){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_i18n_input_client_packets";
	add0="dontaudit $1 i18n_input_client_packet_t:packet send;";
}
if(iii==1032){
	add_number=0;
	raw_interface_name="corenet_receive_i18n_input_client_packets";
	add0="allow $1 i18n_input_client_packet_t:packet recv;";
}
if(iii==1033){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_i18n_input_client_packets";
	add0="dontaudit $1 i18n_input_client_packet_t:packet recv;";
}
if(iii==1034){
	add_number=0;
	raw_interface_name="corenet_sendrecv_i18n_input_client_packets";
	add0="corenet_send_i18n_input_client_packets($1)";
	add1="corenet_receive_i18n_input_client_packets($1)";
	add_number =1;
}
if(iii==1035){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_i18n_input_client_packets";
	add0="corenet_dontaudit_send_i18n_input_client_packets($1)";
	add1="corenet_dontaudit_receive_i18n_input_client_packets($1)";
	add_number =1;
}
if(iii==1036){
	add_number=0;
	raw_interface_name="corenet_relabelto_i18n_input_client_packets";
	add0="allow $1 i18n_input_client_packet_t:packet relabelto;";
}
if(iii==1037){
	add_number=0;
	raw_interface_name="corenet_send_i18n_input_server_packets";
	add0="allow $1 i18n_input_server_packet_t:packet send;";
}
if(iii==1038){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_i18n_input_server_packets";
	add0="dontaudit $1 i18n_input_server_packet_t:packet send;";
}
if(iii==1039){
	add_number=0;
	raw_interface_name="corenet_receive_i18n_input_server_packets";
	add0="allow $1 i18n_input_server_packet_t:packet recv;";
}
if(iii==1040){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_i18n_input_server_packets";
	add0="dontaudit $1 i18n_input_server_packet_t:packet recv;";
}
if(iii==1041){
	add_number=0;
	raw_interface_name="corenet_sendrecv_i18n_input_server_packets";
	add0="corenet_send_i18n_input_server_packets($1)";
	add1="corenet_receive_i18n_input_server_packets($1)";
	add_number =1;
}
if(iii==1042){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_i18n_input_server_packets";
	add0="corenet_dontaudit_send_i18n_input_server_packets($1)";
	add1="corenet_dontaudit_receive_i18n_input_server_packets($1)";
	add_number =1;
}
if(iii==1043){
	add_number=0;
	raw_interface_name="corenet_relabelto_i18n_input_server_packets";
	add0="allow $1 i18n_input_server_packet_t:packet relabelto;";
}
if(iii==1044){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_imaze_port";
	add0="allow $1 imaze_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1045){
	add_number=0;
	raw_interface_name="corenet_udp_send_imaze_port";
	add0="allow $1 imaze_port_t:udp_socket send_msg;";
}
if(iii==1046){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_imaze_port";
	add0="dontaudit $1 imaze_port_t:udp_socket send_msg;";
}
if(iii==1047){
	add_number=0;
	raw_interface_name="corenet_udp_receive_imaze_port";
	add0="allow $1 imaze_port_t:udp_socket recv_msg;";
}
if(iii==1048){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_imaze_port";
	add0="dontaudit $1 imaze_port_t:udp_socket recv_msg;";
}
if(iii==1049){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_imaze_port";
	add0="corenet_udp_send_imaze_port($1)";
	add1="corenet_udp_receive_imaze_port($1)";
	add_number =1;
}
if(iii==1050){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_imaze_port";
	add0="corenet_dontaudit_udp_send_imaze_port($1)";
	add1="corenet_dontaudit_udp_receive_imaze_port($1)";
	add_number =1;
}
if(iii==1051){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_imaze_port";
	add0="allow $1 imaze_port_t:tcp_socket name_bind;";
}
if(iii==1052){
	add_number=0;
	raw_interface_name="corenet_udp_bind_imaze_port";
	add0="allow $1 imaze_port_t:udp_socket name_bind;";
}
if(iii==1053){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_imaze_port";
	add0="allow $1 imaze_port_t:tcp_socket name_connect;";
}
if(iii==1054){
	add_number=0;
	raw_interface_name="corenet_send_imaze_client_packets";
	add0="allow $1 imaze_client_packet_t:packet send;";
}
if(iii==1055){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_imaze_client_packets";
	add0="dontaudit $1 imaze_client_packet_t:packet send;";
}
if(iii==1056){
	add_number=0;
	raw_interface_name="corenet_receive_imaze_client_packets";
	add0="allow $1 imaze_client_packet_t:packet recv;";
}
if(iii==1057){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_imaze_client_packets";
	add0="dontaudit $1 imaze_client_packet_t:packet recv;";
}
if(iii==1058){
	add_number=0;
	raw_interface_name="corenet_sendrecv_imaze_client_packets";
	add0="corenet_send_imaze_client_packets($1)";
	add1="corenet_receive_imaze_client_packets($1)";
	add_number =1;
}
if(iii==1059){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_imaze_client_packets";
	add0="corenet_dontaudit_send_imaze_client_packets($1)";
	add1="corenet_dontaudit_receive_imaze_client_packets($1)";
	add_number =1;
}
if(iii==1060){
	add_number=0;
	raw_interface_name="corenet_relabelto_imaze_client_packets";
	add0="allow $1 imaze_client_packet_t:packet relabelto;";
}
if(iii==1061){
	add_number=0;
	raw_interface_name="corenet_send_imaze_server_packets";
	add0="allow $1 imaze_server_packet_t:packet send;";
}
if(iii==1062){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_imaze_server_packets";
	add0="dontaudit $1 imaze_server_packet_t:packet send;";
}
if(iii==1063){
	add_number=0;
	raw_interface_name="corenet_receive_imaze_server_packets";
	add0="allow $1 imaze_server_packet_t:packet recv;";
}
if(iii==1064){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_imaze_server_packets";
	add0="dontaudit $1 imaze_server_packet_t:packet recv;";
}
if(iii==1065){
	add_number=0;
	raw_interface_name="corenet_sendrecv_imaze_server_packets";
	add0="corenet_send_imaze_server_packets($1)";
	add1="corenet_receive_imaze_server_packets($1)";
	add_number =1;
}
if(iii==1066){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_imaze_server_packets";
	add0="corenet_dontaudit_send_imaze_server_packets($1)";
	add1="corenet_dontaudit_receive_imaze_server_packets($1)";
	add_number =1;
}
if(iii==1067){
	add_number=0;
	raw_interface_name="corenet_relabelto_imaze_server_packets";
	add0="allow $1 imaze_server_packet_t:packet relabelto;";
}
if(iii==1068){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_inetd_child_port";
	add0="allow $1 inetd_child_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1069){
	add_number=0;
	raw_interface_name="corenet_udp_send_inetd_child_port";
	add0="allow $1 inetd_child_port_t:udp_socket send_msg;";
}
if(iii==1070){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_inetd_child_port";
	add0="dontaudit $1 inetd_child_port_t:udp_socket send_msg;";
}
if(iii==1071){
	add_number=0;
	raw_interface_name="corenet_udp_receive_inetd_child_port";
	add0="allow $1 inetd_child_port_t:udp_socket recv_msg;";
}
if(iii==1072){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_inetd_child_port";
	add0="dontaudit $1 inetd_child_port_t:udp_socket recv_msg;";
}
if(iii==1073){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_inetd_child_port";
	add0="corenet_udp_send_inetd_child_port($1)";
	add1="corenet_udp_receive_inetd_child_port($1)";
	add_number =1;
}
if(iii==1074){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_inetd_child_port";
	add0="corenet_dontaudit_udp_send_inetd_child_port($1)";
	add1="corenet_dontaudit_udp_receive_inetd_child_port($1)";
	add_number =1;
}
if(iii==1075){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_inetd_child_port";
	add0="allow $1 inetd_child_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1076){
	add_number=0;
	raw_interface_name="corenet_udp_bind_inetd_child_port";
	add0="allow $1 inetd_child_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1077){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_inetd_child_port";
	add0="allow $1 inetd_child_port_t:tcp_socket name_connect;";
}
if(iii==1078){
	add_number=0;
	raw_interface_name="corenet_send_inetd_child_client_packets";
	add0="allow $1 inetd_child_client_packet_t:packet send;";
}
if(iii==1079){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_inetd_child_client_packets";
	add0="dontaudit $1 inetd_child_client_packet_t:packet send;";
}
if(iii==1080){
	add_number=0;
	raw_interface_name="corenet_receive_inetd_child_client_packets";
	add0="allow $1 inetd_child_client_packet_t:packet recv;";
}
if(iii==1081){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_inetd_child_client_packets";
	add0="dontaudit $1 inetd_child_client_packet_t:packet recv;";
}
if(iii==1082){
	add_number=0;
	raw_interface_name="corenet_sendrecv_inetd_child_client_packets";
	add0="corenet_send_inetd_child_client_packets($1)";
	add1="corenet_receive_inetd_child_client_packets($1)";
	add_number =1;
}
if(iii==1083){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_inetd_child_client_packets";
	add0="corenet_dontaudit_send_inetd_child_client_packets($1)";
	add1="corenet_dontaudit_receive_inetd_child_client_packets($1)";
	add_number =1;
}
if(iii==1084){
	add_number=0;
	raw_interface_name="corenet_relabelto_inetd_child_client_packets";
	add0="allow $1 inetd_child_client_packet_t:packet relabelto;";
}
if(iii==1085){
	add_number=0;
	raw_interface_name="corenet_send_inetd_child_server_packets";
	add0="allow $1 inetd_child_server_packet_t:packet send;";
}
if(iii==1086){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_inetd_child_server_packets";
	add0="dontaudit $1 inetd_child_server_packet_t:packet send;";
}
if(iii==1087){
	add_number=0;
	raw_interface_name="corenet_receive_inetd_child_server_packets";
	add0="allow $1 inetd_child_server_packet_t:packet recv;";
}
if(iii==1088){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_inetd_child_server_packets";
	add0="dontaudit $1 inetd_child_server_packet_t:packet recv;";
}
if(iii==1089){
	add_number=0;
	raw_interface_name="corenet_sendrecv_inetd_child_server_packets";
	add0="corenet_send_inetd_child_server_packets($1)";
	add1="corenet_receive_inetd_child_server_packets($1)";
	add_number =1;
}
if(iii==1090){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_inetd_child_server_packets";
	add0="corenet_dontaudit_send_inetd_child_server_packets($1)";
	add1="corenet_dontaudit_receive_inetd_child_server_packets($1)";
	add_number =1;
}
if(iii==1091){
	add_number=0;
	raw_interface_name="corenet_relabelto_inetd_child_server_packets";
	add0="allow $1 inetd_child_server_packet_t:packet relabelto;";
}
if(iii==1092){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_innd_port";
	add0="allow $1 innd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1093){
	add_number=0;
	raw_interface_name="corenet_udp_send_innd_port";
	add0="allow $1 innd_port_t:udp_socket send_msg;";
}
if(iii==1094){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_innd_port";
	add0="dontaudit $1 innd_port_t:udp_socket send_msg;";
}
if(iii==1095){
	add_number=0;
	raw_interface_name="corenet_udp_receive_innd_port";
	add0="allow $1 innd_port_t:udp_socket recv_msg;";
}
if(iii==1096){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_innd_port";
	add0="dontaudit $1 innd_port_t:udp_socket recv_msg;";
}
if(iii==1097){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_innd_port";
	add0="corenet_udp_send_innd_port($1)";
	add1="corenet_udp_receive_innd_port($1)";
	add_number =1;
}
if(iii==1098){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_innd_port";
	add0="corenet_dontaudit_udp_send_innd_port($1)";
	add1="corenet_dontaudit_udp_receive_innd_port($1)";
	add_number =1;
}
if(iii==1099){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_innd_port";
	add0="allow $1 innd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1100){
	add_number=0;
	raw_interface_name="corenet_udp_bind_innd_port";
	add0="allow $1 innd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1101){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_innd_port";
	add0="allow $1 innd_port_t:tcp_socket name_connect;";
}
if(iii==1102){
	add_number=0;
	raw_interface_name="corenet_send_innd_client_packets";
	add0="allow $1 innd_client_packet_t:packet send;";
}
if(iii==1103){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_innd_client_packets";
	add0="dontaudit $1 innd_client_packet_t:packet send;";
}
if(iii==1104){
	add_number=0;
	raw_interface_name="corenet_receive_innd_client_packets";
	add0="allow $1 innd_client_packet_t:packet recv;";
}
if(iii==1105){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_innd_client_packets";
	add0="dontaudit $1 innd_client_packet_t:packet recv;";
}
if(iii==1106){
	add_number=0;
	raw_interface_name="corenet_sendrecv_innd_client_packets";
	add0="corenet_send_innd_client_packets($1)";
	add1="corenet_receive_innd_client_packets($1)";
	add_number =1;
}
if(iii==1107){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_innd_client_packets";
	add0="corenet_dontaudit_send_innd_client_packets($1)";
	add1="corenet_dontaudit_receive_innd_client_packets($1)";
	add_number =1;
}
if(iii==1108){
	add_number=0;
	raw_interface_name="corenet_relabelto_innd_client_packets";
	add0="allow $1 innd_client_packet_t:packet relabelto;";
}
if(iii==1109){
	add_number=0;
	raw_interface_name="corenet_send_innd_server_packets";
	add0="allow $1 innd_server_packet_t:packet send;";
}
if(iii==1110){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_innd_server_packets";
	add0="dontaudit $1 innd_server_packet_t:packet send;";
}
if(iii==1111){
	add_number=0;
	raw_interface_name="corenet_receive_innd_server_packets";
	add0="allow $1 innd_server_packet_t:packet recv;";
}
if(iii==1112){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_innd_server_packets";
	add0="dontaudit $1 innd_server_packet_t:packet recv;";
}
if(iii==1113){
	add_number=0;
	raw_interface_name="corenet_sendrecv_innd_server_packets";
	add0="corenet_send_innd_server_packets($1)";
	add1="corenet_receive_innd_server_packets($1)";
	add_number =1;
}
if(iii==1114){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_innd_server_packets";
	add0="corenet_dontaudit_send_innd_server_packets($1)";
	add1="corenet_dontaudit_receive_innd_server_packets($1)";
	add_number =1;
}
if(iii==1115){
	add_number=0;
	raw_interface_name="corenet_relabelto_innd_server_packets";
	add0="allow $1 innd_server_packet_t:packet relabelto;";
}
if(iii==1116){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ipp_port";
	add0="allow $1 ipp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1117){
	add_number=0;
	raw_interface_name="corenet_udp_send_ipp_port";
	add0="allow $1 ipp_port_t:udp_socket send_msg;";
}
if(iii==1118){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ipp_port";
	add0="dontaudit $1 ipp_port_t:udp_socket send_msg;";
}
if(iii==1119){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ipp_port";
	add0="allow $1 ipp_port_t:udp_socket recv_msg;";
}
if(iii==1120){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ipp_port";
	add0="dontaudit $1 ipp_port_t:udp_socket recv_msg;";
}
if(iii==1121){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ipp_port";
	add0="corenet_udp_send_ipp_port($1)";
	add1="corenet_udp_receive_ipp_port($1)";
	add_number =1;
}
if(iii==1122){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ipp_port";
	add0="corenet_dontaudit_udp_send_ipp_port($1)";
	add1="corenet_dontaudit_udp_receive_ipp_port($1)";
	add_number =1;
}
if(iii==1123){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ipp_port";
	add0="allow $1 ipp_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1124){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ipp_port";
	add0="allow $1 ipp_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1125){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ipp_port";
	add0="allow $1 ipp_port_t:tcp_socket name_connect;";
}
if(iii==1126){
	add_number=0;
	raw_interface_name="corenet_send_ipp_client_packets";
	add0="allow $1 ipp_client_packet_t:packet send;";
}
if(iii==1127){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ipp_client_packets";
	add0="dontaudit $1 ipp_client_packet_t:packet send;";
}
if(iii==1128){
	add_number=0;
	raw_interface_name="corenet_receive_ipp_client_packets";
	add0="allow $1 ipp_client_packet_t:packet recv;";
}
if(iii==1129){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ipp_client_packets";
	add0="dontaudit $1 ipp_client_packet_t:packet recv;";
}
if(iii==1130){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ipp_client_packets";
	add0="corenet_send_ipp_client_packets($1)";
	add1="corenet_receive_ipp_client_packets($1)";
	add_number =1;
}
if(iii==1131){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ipp_client_packets";
	add0="corenet_dontaudit_send_ipp_client_packets($1)";
	add1="corenet_dontaudit_receive_ipp_client_packets($1)";
	add_number =1;
}
if(iii==1132){
	add_number=0;
	raw_interface_name="corenet_relabelto_ipp_client_packets";
	add0="allow $1 ipp_client_packet_t:packet relabelto;";
}
if(iii==1133){
	add_number=0;
	raw_interface_name="corenet_send_ipp_server_packets";
	add0="allow $1 ipp_server_packet_t:packet send;";
}
if(iii==1134){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ipp_server_packets";
	add0="dontaudit $1 ipp_server_packet_t:packet send;";
}
if(iii==1135){
	add_number=0;
	raw_interface_name="corenet_receive_ipp_server_packets";
	add0="allow $1 ipp_server_packet_t:packet recv;";
}
if(iii==1136){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ipp_server_packets";
	add0="dontaudit $1 ipp_server_packet_t:packet recv;";
}
if(iii==1137){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ipp_server_packets";
	add0="corenet_send_ipp_server_packets($1)";
	add1="corenet_receive_ipp_server_packets($1)";
	add_number =1;
}
if(iii==1138){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ipp_server_packets";
	add0="corenet_dontaudit_send_ipp_server_packets($1)";
	add1="corenet_dontaudit_receive_ipp_server_packets($1)";
	add_number =1;
}
if(iii==1139){
	add_number=0;
	raw_interface_name="corenet_relabelto_ipp_server_packets";
	add0="allow $1 ipp_server_packet_t:packet relabelto;";
}
if(iii==1140){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ircd_port";
	add0="allow $1 ircd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1141){
	add_number=0;
	raw_interface_name="corenet_udp_send_ircd_port";
	add0="allow $1 ircd_port_t:udp_socket send_msg;";
}
if(iii==1142){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ircd_port";
	add0="dontaudit $1 ircd_port_t:udp_socket send_msg;";
}
if(iii==1143){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ircd_port";
	add0="allow $1 ircd_port_t:udp_socket recv_msg;";
}
if(iii==1144){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ircd_port";
	add0="dontaudit $1 ircd_port_t:udp_socket recv_msg;";
}
if(iii==1145){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ircd_port";
	add0="corenet_udp_send_ircd_port($1)";
	add1="corenet_udp_receive_ircd_port($1)";
	add_number =1;
}
if(iii==1146){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ircd_port";
	add0="corenet_dontaudit_udp_send_ircd_port($1)";
	add1="corenet_dontaudit_udp_receive_ircd_port($1)";
	add_number =1;
}
if(iii==1147){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ircd_port";
	add0="allow $1 ircd_port_t:tcp_socket name_bind;";
}
if(iii==1148){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ircd_port";
	add0="allow $1 ircd_port_t:udp_socket name_bind;";
}
if(iii==1149){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ircd_port";
	add0="allow $1 ircd_port_t:tcp_socket name_connect;";
}
if(iii==1150){
	add_number=0;
	raw_interface_name="corenet_send_ircd_client_packets";
	add0="allow $1 ircd_client_packet_t:packet send;";
}
if(iii==1151){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ircd_client_packets";
	add0="dontaudit $1 ircd_client_packet_t:packet send;";
}
if(iii==1152){
	add_number=0;
	raw_interface_name="corenet_receive_ircd_client_packets";
	add0="allow $1 ircd_client_packet_t:packet recv;";
}
if(iii==1153){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ircd_client_packets";
	add0="dontaudit $1 ircd_client_packet_t:packet recv;";
}
if(iii==1154){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ircd_client_packets";
	add0="corenet_send_ircd_client_packets($1)";
	add1="corenet_receive_ircd_client_packets($1)";
	add_number =1;
}
if(iii==1155){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ircd_client_packets";
	add0="corenet_dontaudit_send_ircd_client_packets($1)";
	add1="corenet_dontaudit_receive_ircd_client_packets($1)";
	add_number =1;
}
if(iii==1156){
	add_number=0;
	raw_interface_name="corenet_relabelto_ircd_client_packets";
	add0="allow $1 ircd_client_packet_t:packet relabelto;";
}
if(iii==1157){
	add_number=0;
	raw_interface_name="corenet_send_ircd_server_packets";
	add0="allow $1 ircd_server_packet_t:packet send;";
}
if(iii==1158){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ircd_server_packets";
	add0="dontaudit $1 ircd_server_packet_t:packet send;";
}
if(iii==1159){
	add_number=0;
	raw_interface_name="corenet_receive_ircd_server_packets";
	add0="allow $1 ircd_server_packet_t:packet recv;";
}
if(iii==1160){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ircd_server_packets";
	add0="dontaudit $1 ircd_server_packet_t:packet recv;";
}
if(iii==1161){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ircd_server_packets";
	add0="corenet_send_ircd_server_packets($1)";
	add1="corenet_receive_ircd_server_packets($1)";
	add_number =1;
}
if(iii==1162){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ircd_server_packets";
	add0="corenet_dontaudit_send_ircd_server_packets($1)";
	add1="corenet_dontaudit_receive_ircd_server_packets($1)";
	add_number =1;
}
if(iii==1163){
	add_number=0;
	raw_interface_name="corenet_relabelto_ircd_server_packets";
	add0="allow $1 ircd_server_packet_t:packet relabelto;";
}
if(iii==1164){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_isakmp_port";
	add0="allow $1 isakmp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1165){
	add_number=0;
	raw_interface_name="corenet_udp_send_isakmp_port";
	add0="allow $1 isakmp_port_t:udp_socket send_msg;";
}
if(iii==1166){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_isakmp_port";
	add0="dontaudit $1 isakmp_port_t:udp_socket send_msg;";
}
if(iii==1167){
	add_number=0;
	raw_interface_name="corenet_udp_receive_isakmp_port";
	add0="allow $1 isakmp_port_t:udp_socket recv_msg;";
}
if(iii==1168){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_isakmp_port";
	add0="dontaudit $1 isakmp_port_t:udp_socket recv_msg;";
}
if(iii==1169){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_isakmp_port";
	add0="corenet_udp_send_isakmp_port($1)";
	add1="corenet_udp_receive_isakmp_port($1)";
	add_number =1;
}
if(iii==1170){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_isakmp_port";
	add0="corenet_dontaudit_udp_send_isakmp_port($1)";
	add1="corenet_dontaudit_udp_receive_isakmp_port($1)";
	add_number =1;
}
if(iii==1171){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_isakmp_port";
	add0="allow $1 isakmp_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1172){
	add_number=0;
	raw_interface_name="corenet_udp_bind_isakmp_port";
	add0="allow $1 isakmp_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1173){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_isakmp_port";
	add0="allow $1 isakmp_port_t:tcp_socket name_connect;";
}
if(iii==1174){
	add_number=0;
	raw_interface_name="corenet_send_isakmp_client_packets";
	add0="allow $1 isakmp_client_packet_t:packet send;";
}
if(iii==1175){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_isakmp_client_packets";
	add0="dontaudit $1 isakmp_client_packet_t:packet send;";
}
if(iii==1176){
	add_number=0;
	raw_interface_name="corenet_receive_isakmp_client_packets";
	add0="allow $1 isakmp_client_packet_t:packet recv;";
}
if(iii==1177){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_isakmp_client_packets";
	add0="dontaudit $1 isakmp_client_packet_t:packet recv;";
}
if(iii==1178){
	add_number=0;
	raw_interface_name="corenet_sendrecv_isakmp_client_packets";
	add0="corenet_send_isakmp_client_packets($1)";
	add1="corenet_receive_isakmp_client_packets($1)";
	add_number =1;
}
if(iii==1179){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_isakmp_client_packets";
	add0="corenet_dontaudit_send_isakmp_client_packets($1)";
	add1="corenet_dontaudit_receive_isakmp_client_packets($1)";
	add_number =1;
}
if(iii==1180){
	add_number=0;
	raw_interface_name="corenet_relabelto_isakmp_client_packets";
	add0="allow $1 isakmp_client_packet_t:packet relabelto;";
}
if(iii==1181){
	add_number=0;
	raw_interface_name="corenet_send_isakmp_server_packets";
	add0="allow $1 isakmp_server_packet_t:packet send;";
}
if(iii==1182){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_isakmp_server_packets";
	add0="dontaudit $1 isakmp_server_packet_t:packet send;";
}
if(iii==1183){
	add_number=0;
	raw_interface_name="corenet_receive_isakmp_server_packets";
	add0="allow $1 isakmp_server_packet_t:packet recv;";
}
if(iii==1184){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_isakmp_server_packets";
	add0="dontaudit $1 isakmp_server_packet_t:packet recv;";
}
if(iii==1185){
	add_number=0;
	raw_interface_name="corenet_sendrecv_isakmp_server_packets";
	add0="corenet_send_isakmp_server_packets($1)";
	add1="corenet_receive_isakmp_server_packets($1)";
	add_number =1;
}
if(iii==1186){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_isakmp_server_packets";
	add0="corenet_dontaudit_send_isakmp_server_packets($1)";
	add1="corenet_dontaudit_receive_isakmp_server_packets($1)";
	add_number =1;
}
if(iii==1187){
	add_number=0;
	raw_interface_name="corenet_relabelto_isakmp_server_packets";
	add0="allow $1 isakmp_server_packet_t:packet relabelto;";
}
if(iii==1188){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_iscsi_port";
	add0="allow $1 iscsi_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1189){
	add_number=0;
	raw_interface_name="corenet_udp_send_iscsi_port";
	add0="allow $1 iscsi_port_t:udp_socket send_msg;";
}
if(iii==1190){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_iscsi_port";
	add0="dontaudit $1 iscsi_port_t:udp_socket send_msg;";
}
if(iii==1191){
	add_number=0;
	raw_interface_name="corenet_udp_receive_iscsi_port";
	add0="allow $1 iscsi_port_t:udp_socket recv_msg;";
}
if(iii==1192){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_iscsi_port";
	add0="dontaudit $1 iscsi_port_t:udp_socket recv_msg;";
}
if(iii==1193){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_iscsi_port";
	add0="corenet_udp_send_iscsi_port($1)";
	add1="corenet_udp_receive_iscsi_port($1)";
	add_number =1;
}
if(iii==1194){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_iscsi_port";
	add0="corenet_dontaudit_udp_send_iscsi_port($1)";
	add1="corenet_dontaudit_udp_receive_iscsi_port($1)";
	add_number =1;
}
if(iii==1195){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_iscsi_port";
	add0="allow $1 iscsi_port_t:tcp_socket name_bind;";
}
if(iii==1196){
	add_number=0;
	raw_interface_name="corenet_udp_bind_iscsi_port";
	add0="allow $1 iscsi_port_t:udp_socket name_bind;";
}
if(iii==1197){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_iscsi_port";
	add0="allow $1 iscsi_port_t:tcp_socket name_connect;";
}
if(iii==1198){
	add_number=0;
	raw_interface_name="corenet_send_iscsi_client_packets";
	add0="allow $1 iscsi_client_packet_t:packet send;";
}
if(iii==1199){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_iscsi_client_packets";
	add0="dontaudit $1 iscsi_client_packet_t:packet send;";
}
if(iii==1200){
	add_number=0;
	raw_interface_name="corenet_receive_iscsi_client_packets";
	add0="allow $1 iscsi_client_packet_t:packet recv;";
}
if(iii==1201){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_iscsi_client_packets";
	add0="dontaudit $1 iscsi_client_packet_t:packet recv;";
}
if(iii==1202){
	add_number=0;
	raw_interface_name="corenet_sendrecv_iscsi_client_packets";
	add0="corenet_send_iscsi_client_packets($1)";
	add1="corenet_receive_iscsi_client_packets($1)";
	add_number =1;
}
if(iii==1203){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_iscsi_client_packets";
	add0="corenet_dontaudit_send_iscsi_client_packets($1)";
	add1="corenet_dontaudit_receive_iscsi_client_packets($1)";
	add_number =1;
}
if(iii==1204){
	add_number=0;
	raw_interface_name="corenet_relabelto_iscsi_client_packets";
	add0="allow $1 iscsi_client_packet_t:packet relabelto;";
}
if(iii==1205){
	add_number=0;
	raw_interface_name="corenet_send_iscsi_server_packets";
	add0="allow $1 iscsi_server_packet_t:packet send;";
}
if(iii==1206){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_iscsi_server_packets";
	add0="dontaudit $1 iscsi_server_packet_t:packet send;";
}
if(iii==1207){
	add_number=0;
	raw_interface_name="corenet_receive_iscsi_server_packets";
	add0="allow $1 iscsi_server_packet_t:packet recv;";
}
if(iii==1208){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_iscsi_server_packets";
	add0="dontaudit $1 iscsi_server_packet_t:packet recv;";
}
if(iii==1209){
	add_number=0;
	raw_interface_name="corenet_sendrecv_iscsi_server_packets";
	add0="corenet_send_iscsi_server_packets($1)";
	add1="corenet_receive_iscsi_server_packets($1)";
	add_number =1;
}
if(iii==1210){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_iscsi_server_packets";
	add0="corenet_dontaudit_send_iscsi_server_packets($1)";
	add1="corenet_dontaudit_receive_iscsi_server_packets($1)";
	add_number =1;
}
if(iii==1211){
	add_number=0;
	raw_interface_name="corenet_relabelto_iscsi_server_packets";
	add0="allow $1 iscsi_server_packet_t:packet relabelto;";
}
if(iii==1212){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_jabber_client_port";
	add0="allow $1 jabber_client_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1213){
	add_number=0;
	raw_interface_name="corenet_udp_send_jabber_client_port";
	add0="allow $1 jabber_client_port_t:udp_socket send_msg;";
}
if(iii==1214){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_jabber_client_port";
	add0="dontaudit $1 jabber_client_port_t:udp_socket send_msg;";
}
if(iii==1215){
	add_number=0;
	raw_interface_name="corenet_udp_receive_jabber_client_port";
	add0="allow $1 jabber_client_port_t:udp_socket recv_msg;";
}
if(iii==1216){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_jabber_client_port";
	add0="dontaudit $1 jabber_client_port_t:udp_socket recv_msg;";
}
if(iii==1217){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_jabber_client_port";
	add0="corenet_udp_send_jabber_client_port($1)";
	add1="corenet_udp_receive_jabber_client_port($1)";
	add_number =1;
}
if(iii==1218){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_jabber_client_port";
	add0="corenet_dontaudit_udp_send_jabber_client_port($1)";
	add1="corenet_dontaudit_udp_receive_jabber_client_port($1)";
	add_number =1;
}
if(iii==1219){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_jabber_client_port";
	add0="allow $1 jabber_client_port_t:tcp_socket name_bind;";
}
if(iii==1220){
	add_number=0;
	raw_interface_name="corenet_udp_bind_jabber_client_port";
	add0="allow $1 jabber_client_port_t:udp_socket name_bind;";
}
if(iii==1221){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_jabber_client_port";
	add0="allow $1 jabber_client_port_t:tcp_socket name_connect;";
}
if(iii==1222){
	add_number=0;
	raw_interface_name="corenet_send_jabber_client_client_packets";
	add0="allow $1 jabber_client_client_packet_t:packet send;";
}
if(iii==1223){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_jabber_client_client_packets";
	add0="dontaudit $1 jabber_client_client_packet_t:packet send;";
}
if(iii==1224){
	add_number=0;
	raw_interface_name="corenet_receive_jabber_client_client_packets";
	add0="allow $1 jabber_client_client_packet_t:packet recv;";
}
if(iii==1225){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_jabber_client_client_packets";
	add0="dontaudit $1 jabber_client_client_packet_t:packet recv;";
}
if(iii==1226){
	add_number=0;
	raw_interface_name="corenet_sendrecv_jabber_client_client_packets";
	add0="corenet_send_jabber_client_client_packets($1)";
	add1="corenet_receive_jabber_client_client_packets($1)";
	add_number =1;
}
if(iii==1227){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_jabber_client_client_packets";
	add0="corenet_dontaudit_send_jabber_client_client_packets($1)";
	add1="corenet_dontaudit_receive_jabber_client_client_packets($1)";
	add_number =1;
}
if(iii==1228){
	add_number=0;
	raw_interface_name="corenet_relabelto_jabber_client_client_packets";
	add0="allow $1 jabber_client_client_packet_t:packet relabelto;";
}
if(iii==1229){
	add_number=0;
	raw_interface_name="corenet_send_jabber_client_server_packets";
	add0="allow $1 jabber_client_server_packet_t:packet send;";
}
if(iii==1230){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_jabber_client_server_packets";
	add0="dontaudit $1 jabber_client_server_packet_t:packet send;";
}
if(iii==1231){
	add_number=0;
	raw_interface_name="corenet_receive_jabber_client_server_packets";
	add0="allow $1 jabber_client_server_packet_t:packet recv;";
}
if(iii==1232){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_jabber_client_server_packets";
	add0="dontaudit $1 jabber_client_server_packet_t:packet recv;";
}
if(iii==1233){
	add_number=0;
	raw_interface_name="corenet_sendrecv_jabber_client_server_packets";
	add0="corenet_send_jabber_client_server_packets($1)";
	add1="corenet_receive_jabber_client_server_packets($1)";
	add_number =1;
}
if(iii==1234){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_jabber_client_server_packets";
	add0="corenet_dontaudit_send_jabber_client_server_packets($1)";
	add1="corenet_dontaudit_receive_jabber_client_server_packets($1)";
	add_number =1;
}
if(iii==1235){
	add_number=0;
	raw_interface_name="corenet_relabelto_jabber_client_server_packets";
	add0="allow $1 jabber_client_server_packet_t:packet relabelto;";
}
if(iii==1236){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_jabber_interserver_port";
	add0="allow $1 jabber_interserver_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1237){
	add_number=0;
	raw_interface_name="corenet_udp_send_jabber_interserver_port";
	add0="allow $1 jabber_interserver_port_t:udp_socket send_msg;";
}
if(iii==1238){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_jabber_interserver_port";
	add0="dontaudit $1 jabber_interserver_port_t:udp_socket send_msg;";
}
if(iii==1239){
	add_number=0;
	raw_interface_name="corenet_udp_receive_jabber_interserver_port";
	add0="allow $1 jabber_interserver_port_t:udp_socket recv_msg;";
}
if(iii==1240){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_jabber_interserver_port";
	add0="dontaudit $1 jabber_interserver_port_t:udp_socket recv_msg;";
}
if(iii==1241){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_jabber_interserver_port";
	add0="corenet_udp_send_jabber_interserver_port($1)";
	add1="corenet_udp_receive_jabber_interserver_port($1)";
	add_number =1;
}
if(iii==1242){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_jabber_interserver_port";
	add0="corenet_dontaudit_udp_send_jabber_interserver_port($1)";
	add1="corenet_dontaudit_udp_receive_jabber_interserver_port($1)";
	add_number =1;
}
if(iii==1243){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_jabber_interserver_port";
	add0="allow $1 jabber_interserver_port_t:tcp_socket name_bind;";
}
if(iii==1244){
	add_number=0;
	raw_interface_name="corenet_udp_bind_jabber_interserver_port";
	add0="allow $1 jabber_interserver_port_t:udp_socket name_bind;";
}
if(iii==1245){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_jabber_interserver_port";
	add0="allow $1 jabber_interserver_port_t:tcp_socket name_connect;";
}
if(iii==1246){
	add_number=0;
	raw_interface_name="corenet_send_jabber_interserver_client_packets";
	add0="allow $1 jabber_interserver_client_packet_t:packet send;";
}
if(iii==1247){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_jabber_interserver_client_packets";
	add0="dontaudit $1 jabber_interserver_client_packet_t:packet send;";
}
if(iii==1248){
	add_number=0;
	raw_interface_name="corenet_receive_jabber_interserver_client_packets";
	add0="allow $1 jabber_interserver_client_packet_t:packet recv;";
}
if(iii==1249){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_jabber_interserver_client_packets";
	add0="dontaudit $1 jabber_interserver_client_packet_t:packet recv;";
}
if(iii==1250){
	add_number=0;
	raw_interface_name="corenet_sendrecv_jabber_interserver_client_packets";
	add0="corenet_send_jabber_interserver_client_packets($1)";
	add1="corenet_receive_jabber_interserver_client_packets($1)";
	add_number =1;
}
if(iii==1251){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_jabber_interserver_client_packets";
	add0="corenet_dontaudit_send_jabber_interserver_client_packets($1)";
	add1="corenet_dontaudit_receive_jabber_interserver_client_packets($1)";
	add_number =1;
}
if(iii==1252){
	add_number=0;
	raw_interface_name="corenet_relabelto_jabber_interserver_client_packets";
	add0="allow $1 jabber_interserver_client_packet_t:packet relabelto;";
}
if(iii==1253){
	add_number=0;
	raw_interface_name="corenet_send_jabber_interserver_server_packets";
	add0="allow $1 jabber_interserver_server_packet_t:packet send;";
}
if(iii==1254){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_jabber_interserver_server_packets";
	add0="dontaudit $1 jabber_interserver_server_packet_t:packet send;";
}
if(iii==1255){
	add_number=0;
	raw_interface_name="corenet_receive_jabber_interserver_server_packets";
	add0="allow $1 jabber_interserver_server_packet_t:packet recv;";
}
if(iii==1256){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_jabber_interserver_server_packets";
	add0="dontaudit $1 jabber_interserver_server_packet_t:packet recv;";
}
if(iii==1257){
	add_number=0;
	raw_interface_name="corenet_sendrecv_jabber_interserver_server_packets";
	add0="corenet_send_jabber_interserver_server_packets($1)";
	add1="corenet_receive_jabber_interserver_server_packets($1)";
	add_number =1;
}
if(iii==1258){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_jabber_interserver_server_packets";
	add0="corenet_dontaudit_send_jabber_interserver_server_packets($1)";
	add1="corenet_dontaudit_receive_jabber_interserver_server_packets($1)";
	add_number =1;
}
if(iii==1259){
	add_number=0;
	raw_interface_name="corenet_relabelto_jabber_interserver_server_packets";
	add0="allow $1 jabber_interserver_server_packet_t:packet relabelto;";
}
if(iii==1260){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_kerberos_admin_port";
	add0="allow $1 kerberos_admin_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1261){
	add_number=0;
	raw_interface_name="corenet_udp_send_kerberos_admin_port";
	add0="allow $1 kerberos_admin_port_t:udp_socket send_msg;";
}
if(iii==1262){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_kerberos_admin_port";
	add0="dontaudit $1 kerberos_admin_port_t:udp_socket send_msg;";
}
if(iii==1263){
	add_number=0;
	raw_interface_name="corenet_udp_receive_kerberos_admin_port";
	add0="allow $1 kerberos_admin_port_t:udp_socket recv_msg;";
}
if(iii==1264){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_kerberos_admin_port";
	add0="dontaudit $1 kerberos_admin_port_t:udp_socket recv_msg;";
}
if(iii==1265){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_kerberos_admin_port";
	add0="corenet_udp_send_kerberos_admin_port($1)";
	add1="corenet_udp_receive_kerberos_admin_port($1)";
	add_number =1;
}
if(iii==1266){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_kerberos_admin_port";
	add0="corenet_dontaudit_udp_send_kerberos_admin_port($1)";
	add1="corenet_dontaudit_udp_receive_kerberos_admin_port($1)";
	add_number =1;
}
if(iii==1267){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_kerberos_admin_port";
	add0="allow $1 kerberos_admin_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1268){
	add_number=0;
	raw_interface_name="corenet_udp_bind_kerberos_admin_port";
	add0="allow $1 kerberos_admin_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1269){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_kerberos_admin_port";
	add0="allow $1 kerberos_admin_port_t:tcp_socket name_connect;";
}
if(iii==1270){
	add_number=0;
	raw_interface_name="corenet_send_kerberos_admin_client_packets";
	add0="allow $1 kerberos_admin_client_packet_t:packet send;";
}
if(iii==1271){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_kerberos_admin_client_packets";
	add0="dontaudit $1 kerberos_admin_client_packet_t:packet send;";
}
if(iii==1272){
	add_number=0;
	raw_interface_name="corenet_receive_kerberos_admin_client_packets";
	add0="allow $1 kerberos_admin_client_packet_t:packet recv;";
}
if(iii==1273){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_kerberos_admin_client_packets";
	add0="dontaudit $1 kerberos_admin_client_packet_t:packet recv;";
}
if(iii==1274){
	add_number=0;
	raw_interface_name="corenet_sendrecv_kerberos_admin_client_packets";
	add0="corenet_send_kerberos_admin_client_packets($1)";
	add1="corenet_receive_kerberos_admin_client_packets($1)";
	add_number =1;
}
if(iii==1275){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_kerberos_admin_client_packets";
	add0="corenet_dontaudit_send_kerberos_admin_client_packets($1)";
	add1="corenet_dontaudit_receive_kerberos_admin_client_packets($1)";
	add_number =1;
}
if(iii==1276){
	add_number=0;
	raw_interface_name="corenet_relabelto_kerberos_admin_client_packets";
	add0="allow $1 kerberos_admin_client_packet_t:packet relabelto;";
}
if(iii==1277){
	add_number=0;
	raw_interface_name="corenet_send_kerberos_admin_server_packets";
	add0="allow $1 kerberos_admin_server_packet_t:packet send;";
}
if(iii==1278){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_kerberos_admin_server_packets";
	add0="dontaudit $1 kerberos_admin_server_packet_t:packet send;";
}
if(iii==1279){
	add_number=0;
	raw_interface_name="corenet_receive_kerberos_admin_server_packets";
	add0="allow $1 kerberos_admin_server_packet_t:packet recv;";
}
if(iii==1280){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_kerberos_admin_server_packets";
	add0="dontaudit $1 kerberos_admin_server_packet_t:packet recv;";
}
if(iii==1281){
	add_number=0;
	raw_interface_name="corenet_sendrecv_kerberos_admin_server_packets";
	add0="corenet_send_kerberos_admin_server_packets($1)";
	add1="corenet_receive_kerberos_admin_server_packets($1)";
	add_number =1;
}
if(iii==1282){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_kerberos_admin_server_packets";
	add0="corenet_dontaudit_send_kerberos_admin_server_packets($1)";
	add1="corenet_dontaudit_receive_kerberos_admin_server_packets($1)";
	add_number =1;
}
if(iii==1283){
	add_number=0;
	raw_interface_name="corenet_relabelto_kerberos_admin_server_packets";
	add0="allow $1 kerberos_admin_server_packet_t:packet relabelto;";
}
if(iii==1284){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_kerberos_master_port";
	add0="allow $1 kerberos_master_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1285){
	add_number=0;
	raw_interface_name="corenet_udp_send_kerberos_master_port";
	add0="allow $1 kerberos_master_port_t:udp_socket send_msg;";
}
if(iii==1286){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_kerberos_master_port";
	add0="dontaudit $1 kerberos_master_port_t:udp_socket send_msg;";
}
if(iii==1287){
	add_number=0;
	raw_interface_name="corenet_udp_receive_kerberos_master_port";
	add0="allow $1 kerberos_master_port_t:udp_socket recv_msg;";
}
if(iii==1288){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_kerberos_master_port";
	add0="dontaudit $1 kerberos_master_port_t:udp_socket recv_msg;";
}
if(iii==1289){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_kerberos_master_port";
	add0="corenet_udp_send_kerberos_master_port($1)";
	add1="corenet_udp_receive_kerberos_master_port($1)";
	add_number =1;
}
if(iii==1290){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_kerberos_master_port";
	add0="corenet_dontaudit_udp_send_kerberos_master_port($1)";
	add1="corenet_dontaudit_udp_receive_kerberos_master_port($1)";
	add_number =1;
}
if(iii==1291){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_kerberos_master_port";
	add0="allow $1 kerberos_master_port_t:tcp_socket name_bind;";
}
if(iii==1292){
	add_number=0;
	raw_interface_name="corenet_udp_bind_kerberos_master_port";
	add0="allow $1 kerberos_master_port_t:udp_socket name_bind;";
}
if(iii==1293){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_kerberos_master_port";
	add0="allow $1 kerberos_master_port_t:tcp_socket name_connect;";
}
if(iii==1294){
	add_number=0;
	raw_interface_name="corenet_send_kerberos_master_client_packets";
	add0="allow $1 kerberos_master_client_packet_t:packet send;";
}
if(iii==1295){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_kerberos_master_client_packets";
	add0="dontaudit $1 kerberos_master_client_packet_t:packet send;";
}
if(iii==1296){
	add_number=0;
	raw_interface_name="corenet_receive_kerberos_master_client_packets";
	add0="allow $1 kerberos_master_client_packet_t:packet recv;";
}
if(iii==1297){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_kerberos_master_client_packets";
	add0="dontaudit $1 kerberos_master_client_packet_t:packet recv;";
}
if(iii==1298){
	add_number=0;
	raw_interface_name="corenet_sendrecv_kerberos_master_client_packets";
	add0="corenet_send_kerberos_master_client_packets($1)";
	add1="corenet_receive_kerberos_master_client_packets($1)";
	add_number =1;
}
if(iii==1299){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_kerberos_master_client_packets";
	add0="corenet_dontaudit_send_kerberos_master_client_packets($1)";
	add1="corenet_dontaudit_receive_kerberos_master_client_packets($1)";
	add_number =1;
}
if(iii==1300){
	add_number=0;
	raw_interface_name="corenet_relabelto_kerberos_master_client_packets";
	add0="allow $1 kerberos_master_client_packet_t:packet relabelto;";
}
if(iii==1301){
	add_number=0;
	raw_interface_name="corenet_send_kerberos_master_server_packets";
	add0="allow $1 kerberos_master_server_packet_t:packet send;";
}
if(iii==1302){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_kerberos_master_server_packets";
	add0="dontaudit $1 kerberos_master_server_packet_t:packet send;";
}
if(iii==1303){
	add_number=0;
	raw_interface_name="corenet_receive_kerberos_master_server_packets";
	add0="allow $1 kerberos_master_server_packet_t:packet recv;";
}
if(iii==1304){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_kerberos_master_server_packets";
	add0="dontaudit $1 kerberos_master_server_packet_t:packet recv;";
}
if(iii==1305){
	add_number=0;
	raw_interface_name="corenet_sendrecv_kerberos_master_server_packets";
	add0="corenet_send_kerberos_master_server_packets($1)";
	add1="corenet_receive_kerberos_master_server_packets($1)";
	add_number =1;
}
if(iii==1306){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_kerberos_master_server_packets";
	add0="corenet_dontaudit_send_kerberos_master_server_packets($1)";
	add1="corenet_dontaudit_receive_kerberos_master_server_packets($1)";
	add_number =1;
}
if(iii==1307){
	add_number=0;
	raw_interface_name="corenet_relabelto_kerberos_master_server_packets";
	add0="allow $1 kerberos_master_server_packet_t:packet relabelto;";
}
if(iii==1308){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_kerberos_port";
	add0="allow $1 kerberos_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1309){
	add_number=0;
	raw_interface_name="corenet_udp_send_kerberos_port";
	add0="allow $1 kerberos_port_t:udp_socket send_msg;";
}
if(iii==1310){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_kerberos_port";
	add0="dontaudit $1 kerberos_port_t:udp_socket send_msg;";
}
if(iii==1311){
	add_number=0;
	raw_interface_name="corenet_udp_receive_kerberos_port";
	add0="allow $1 kerberos_port_t:udp_socket recv_msg;";
}
if(iii==1312){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_kerberos_port";
	add0="dontaudit $1 kerberos_port_t:udp_socket recv_msg;";
}
if(iii==1313){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_kerberos_port";
	add0="corenet_udp_send_kerberos_port($1)";
	add1="corenet_udp_receive_kerberos_port($1)";
	add_number =1;
}
if(iii==1314){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_kerberos_port";
	add0="corenet_dontaudit_udp_send_kerberos_port($1)";
	add1="corenet_dontaudit_udp_receive_kerberos_port($1)";
	add_number =1;
}
if(iii==1315){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_kerberos_port";
	add0="allow $1 kerberos_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1316){
	add_number=0;
	raw_interface_name="corenet_udp_bind_kerberos_port";
	add0="allow $1 kerberos_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1317){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_kerberos_port";
	add0="allow $1 kerberos_port_t:tcp_socket name_connect;";
}
if(iii==1318){
	add_number=0;
	raw_interface_name="corenet_send_kerberos_client_packets";
	add0="allow $1 kerberos_client_packet_t:packet send;";
}
if(iii==1319){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_kerberos_client_packets";
	add0="dontaudit $1 kerberos_client_packet_t:packet send;";
}
if(iii==1320){
	add_number=0;
	raw_interface_name="corenet_receive_kerberos_client_packets";
	add0="allow $1 kerberos_client_packet_t:packet recv;";
}
if(iii==1321){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_kerberos_client_packets";
	add0="dontaudit $1 kerberos_client_packet_t:packet recv;";
}
if(iii==1322){
	add_number=0;
	raw_interface_name="corenet_sendrecv_kerberos_client_packets";
	add0="corenet_send_kerberos_client_packets($1)";
	add1="corenet_receive_kerberos_client_packets($1)";
	add_number =1;
}
if(iii==1323){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_kerberos_client_packets";
	add0="corenet_dontaudit_send_kerberos_client_packets($1)";
	add1="corenet_dontaudit_receive_kerberos_client_packets($1)";
	add_number =1;
}
if(iii==1324){
	add_number=0;
	raw_interface_name="corenet_relabelto_kerberos_client_packets";
	add0="allow $1 kerberos_client_packet_t:packet relabelto;";
}
if(iii==1325){
	add_number=0;
	raw_interface_name="corenet_send_kerberos_server_packets";
	add0="allow $1 kerberos_server_packet_t:packet send;";
}
if(iii==1326){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_kerberos_server_packets";
	add0="dontaudit $1 kerberos_server_packet_t:packet send;";
}
if(iii==1327){
	add_number=0;
	raw_interface_name="corenet_receive_kerberos_server_packets";
	add0="allow $1 kerberos_server_packet_t:packet recv;";
}
if(iii==1328){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_kerberos_server_packets";
	add0="dontaudit $1 kerberos_server_packet_t:packet recv;";
}
if(iii==1329){
	add_number=0;
	raw_interface_name="corenet_sendrecv_kerberos_server_packets";
	add0="corenet_send_kerberos_server_packets($1)";
	add1="corenet_receive_kerberos_server_packets($1)";
	add_number =1;
}
if(iii==1330){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_kerberos_server_packets";
	add0="corenet_dontaudit_send_kerberos_server_packets($1)";
	add1="corenet_dontaudit_receive_kerberos_server_packets($1)";
	add_number =1;
}
if(iii==1331){
	add_number=0;
	raw_interface_name="corenet_relabelto_kerberos_server_packets";
	add0="allow $1 kerberos_server_packet_t:packet relabelto;";
}
if(iii==1332){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ktalkd_port";
	add0="allow $1 ktalkd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1333){
	add_number=0;
	raw_interface_name="corenet_udp_send_ktalkd_port";
	add0="allow $1 ktalkd_port_t:udp_socket send_msg;";
}
if(iii==1334){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ktalkd_port";
	add0="dontaudit $1 ktalkd_port_t:udp_socket send_msg;";
}
if(iii==1335){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ktalkd_port";
	add0="allow $1 ktalkd_port_t:udp_socket recv_msg;";
}
if(iii==1336){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ktalkd_port";
	add0="dontaudit $1 ktalkd_port_t:udp_socket recv_msg;";
}
if(iii==1337){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ktalkd_port";
	add0="corenet_udp_send_ktalkd_port($1)";
	add1="corenet_udp_receive_ktalkd_port($1)";
	add_number =1;
}
if(iii==1338){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ktalkd_port";
	add0="corenet_dontaudit_udp_send_ktalkd_port($1)";
	add1="corenet_dontaudit_udp_receive_ktalkd_port($1)";
	add_number =1;
}
if(iii==1339){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ktalkd_port";
	add0="allow $1 ktalkd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1340){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ktalkd_port";
	add0="allow $1 ktalkd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1341){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ktalkd_port";
	add0="allow $1 ktalkd_port_t:tcp_socket name_connect;";
}
if(iii==1342){
	add_number=0;
	raw_interface_name="corenet_send_ktalkd_client_packets";
	add0="allow $1 ktalkd_client_packet_t:packet send;";
}
if(iii==1343){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ktalkd_client_packets";
	add0="dontaudit $1 ktalkd_client_packet_t:packet send;";
}
if(iii==1344){
	add_number=0;
	raw_interface_name="corenet_receive_ktalkd_client_packets";
	add0="allow $1 ktalkd_client_packet_t:packet recv;";
}
if(iii==1345){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ktalkd_client_packets";
	add0="dontaudit $1 ktalkd_client_packet_t:packet recv;";
}
if(iii==1346){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ktalkd_client_packets";
	add0="corenet_send_ktalkd_client_packets($1)";
	add1="corenet_receive_ktalkd_client_packets($1)";
	add_number =1;
}
if(iii==1347){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ktalkd_client_packets";
	add0="corenet_dontaudit_send_ktalkd_client_packets($1)";
	add1="corenet_dontaudit_receive_ktalkd_client_packets($1)";
	add_number =1;
}
if(iii==1348){
	add_number=0;
	raw_interface_name="corenet_relabelto_ktalkd_client_packets";
	add0="allow $1 ktalkd_client_packet_t:packet relabelto;";
}
if(iii==1349){
	add_number=0;
	raw_interface_name="corenet_send_ktalkd_server_packets";
	add0="allow $1 ktalkd_server_packet_t:packet send;";
}
if(iii==1350){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ktalkd_server_packets";
	add0="dontaudit $1 ktalkd_server_packet_t:packet send;";
}
if(iii==1351){
	add_number=0;
	raw_interface_name="corenet_receive_ktalkd_server_packets";
	add0="allow $1 ktalkd_server_packet_t:packet recv;";
}
if(iii==1352){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ktalkd_server_packets";
	add0="dontaudit $1 ktalkd_server_packet_t:packet recv;";
}
if(iii==1353){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ktalkd_server_packets";
	add0="corenet_send_ktalkd_server_packets($1)";
	add1="corenet_receive_ktalkd_server_packets($1)";
	add_number =1;
}
if(iii==1354){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ktalkd_server_packets";
	add0="corenet_dontaudit_send_ktalkd_server_packets($1)";
	add1="corenet_dontaudit_receive_ktalkd_server_packets($1)";
	add_number =1;
}
if(iii==1355){
	add_number=0;
	raw_interface_name="corenet_relabelto_ktalkd_server_packets";
	add0="allow $1 ktalkd_server_packet_t:packet relabelto;";
}
if(iii==1356){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ldap_port";
	add0="allow $1 ldap_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1357){
	add_number=0;
	raw_interface_name="corenet_udp_send_ldap_port";
	add0="allow $1 ldap_port_t:udp_socket send_msg;";
}
if(iii==1358){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ldap_port";
	add0="dontaudit $1 ldap_port_t:udp_socket send_msg;";
}
if(iii==1359){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ldap_port";
	add0="allow $1 ldap_port_t:udp_socket recv_msg;";
}
if(iii==1360){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ldap_port";
	add0="dontaudit $1 ldap_port_t:udp_socket recv_msg;";
}
if(iii==1361){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ldap_port";
	add0="corenet_udp_send_ldap_port($1)";
	add1="corenet_udp_receive_ldap_port($1)";
	add_number =1;
}
if(iii==1362){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ldap_port";
	add0="corenet_dontaudit_udp_send_ldap_port($1)";
	add1="corenet_dontaudit_udp_receive_ldap_port($1)";
	add_number =1;
}
if(iii==1363){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ldap_port";
	add0="allow $1 ldap_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1364){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ldap_port";
	add0="allow $1 ldap_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1365){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ldap_port";
	add0="allow $1 ldap_port_t:tcp_socket name_connect;";
}
if(iii==1366){
	add_number=0;
	raw_interface_name="corenet_send_ldap_client_packets";
	add0="allow $1 ldap_client_packet_t:packet send;";
}
if(iii==1367){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ldap_client_packets";
	add0="dontaudit $1 ldap_client_packet_t:packet send;";
}
if(iii==1368){
	add_number=0;
	raw_interface_name="corenet_receive_ldap_client_packets";
	add0="allow $1 ldap_client_packet_t:packet recv;";
}
if(iii==1369){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ldap_client_packets";
	add0="dontaudit $1 ldap_client_packet_t:packet recv;";
}
if(iii==1370){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ldap_client_packets";
	add0="corenet_send_ldap_client_packets($1)";
	add1="corenet_receive_ldap_client_packets($1)";
	add_number =1;
}
if(iii==1371){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ldap_client_packets";
	add0="corenet_dontaudit_send_ldap_client_packets($1)";
	add1="corenet_dontaudit_receive_ldap_client_packets($1)";
	add_number =1;
}
if(iii==1372){
	add_number=0;
	raw_interface_name="corenet_relabelto_ldap_client_packets";
	add0="allow $1 ldap_client_packet_t:packet relabelto;";
}
if(iii==1373){
	add_number=0;
	raw_interface_name="corenet_send_ldap_server_packets";
	add0="allow $1 ldap_server_packet_t:packet send;";
}
if(iii==1374){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ldap_server_packets";
	add0="dontaudit $1 ldap_server_packet_t:packet send;";
}
if(iii==1375){
	add_number=0;
	raw_interface_name="corenet_receive_ldap_server_packets";
	add0="allow $1 ldap_server_packet_t:packet recv;";
}
if(iii==1376){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ldap_server_packets";
	add0="dontaudit $1 ldap_server_packet_t:packet recv;";
}
if(iii==1377){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ldap_server_packets";
	add0="corenet_send_ldap_server_packets($1)";
	add1="corenet_receive_ldap_server_packets($1)";
	add_number =1;
}
if(iii==1378){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ldap_server_packets";
	add0="corenet_dontaudit_send_ldap_server_packets($1)";
	add1="corenet_dontaudit_receive_ldap_server_packets($1)";
	add_number =1;
}
if(iii==1379){
	add_number=0;
	raw_interface_name="corenet_relabelto_ldap_server_packets";
	add0="allow $1 ldap_server_packet_t:packet relabelto;";
}
if(iii==1380){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_lmtp_port";
	add0="allow $1 lmtp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1381){
	add_number=0;
	raw_interface_name="corenet_udp_send_lmtp_port";
	add0="allow $1 lmtp_port_t:udp_socket send_msg;";
}
if(iii==1382){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_lmtp_port";
	add0="dontaudit $1 lmtp_port_t:udp_socket send_msg;";
}
if(iii==1383){
	add_number=0;
	raw_interface_name="corenet_udp_receive_lmtp_port";
	add0="allow $1 lmtp_port_t:udp_socket recv_msg;";
}
if(iii==1384){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_lmtp_port";
	add0="dontaudit $1 lmtp_port_t:udp_socket recv_msg;";
}
if(iii==1385){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_lmtp_port";
	add0="corenet_udp_send_lmtp_port($1)";
	add1="corenet_udp_receive_lmtp_port($1)";
	add_number =1;
}
if(iii==1386){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_lmtp_port";
	add0="corenet_dontaudit_udp_send_lmtp_port($1)";
	add1="corenet_dontaudit_udp_receive_lmtp_port($1)";
	add_number =1;
}
if(iii==1387){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_lmtp_port";
	add0="allow $1 lmtp_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1388){
	add_number=0;
	raw_interface_name="corenet_udp_bind_lmtp_port";
	add0="allow $1 lmtp_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1389){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_lmtp_port";
	add0="allow $1 lmtp_port_t:tcp_socket name_connect;";
}
if(iii==1390){
	add_number=0;
	raw_interface_name="corenet_send_lmtp_client_packets";
	add0="allow $1 lmtp_client_packet_t:packet send;";
}
if(iii==1391){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_lmtp_client_packets";
	add0="dontaudit $1 lmtp_client_packet_t:packet send;";
}
if(iii==1392){
	add_number=0;
	raw_interface_name="corenet_receive_lmtp_client_packets";
	add0="allow $1 lmtp_client_packet_t:packet recv;";
}
if(iii==1393){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_lmtp_client_packets";
	add0="dontaudit $1 lmtp_client_packet_t:packet recv;";
}
if(iii==1394){
	add_number=0;
	raw_interface_name="corenet_sendrecv_lmtp_client_packets";
	add0="corenet_send_lmtp_client_packets($1)";
	add1="corenet_receive_lmtp_client_packets($1)";
	add_number =1;
}
if(iii==1395){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_lmtp_client_packets";
	add0="corenet_dontaudit_send_lmtp_client_packets($1)";
	add1="corenet_dontaudit_receive_lmtp_client_packets($1)";
	add_number =1;
}
if(iii==1396){
	add_number=0;
	raw_interface_name="corenet_relabelto_lmtp_client_packets";
	add0="allow $1 lmtp_client_packet_t:packet relabelto;";
}
if(iii==1397){
	add_number=0;
	raw_interface_name="corenet_send_lmtp_server_packets";
	add0="allow $1 lmtp_server_packet_t:packet send;";
}
if(iii==1398){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_lmtp_server_packets";
	add0="dontaudit $1 lmtp_server_packet_t:packet send;";
}
if(iii==1399){
	add_number=0;
	raw_interface_name="corenet_receive_lmtp_server_packets";
	add0="allow $1 lmtp_server_packet_t:packet recv;";
}
if(iii==1400){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_lmtp_server_packets";
	add0="dontaudit $1 lmtp_server_packet_t:packet recv;";
}
if(iii==1401){
	add_number=0;
	raw_interface_name="corenet_sendrecv_lmtp_server_packets";
	add0="corenet_send_lmtp_server_packets($1)";
	add1="corenet_receive_lmtp_server_packets($1)";
	add_number =1;
}
if(iii==1402){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_lmtp_server_packets";
	add0="corenet_dontaudit_send_lmtp_server_packets($1)";
	add1="corenet_dontaudit_receive_lmtp_server_packets($1)";
	add_number =1;
}
if(iii==1403){
	add_number=0;
	raw_interface_name="corenet_relabelto_lmtp_server_packets";
	add0="allow $1 lmtp_server_packet_t:packet relabelto;";
}
if(iii==1404){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_mail_port";
	add0="allow $1 mail_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1405){
	add_number=0;
	raw_interface_name="corenet_udp_send_mail_port";
	add0="allow $1 mail_port_t:udp_socket send_msg;";
}
if(iii==1406){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_mail_port";
	add0="dontaudit $1 mail_port_t:udp_socket send_msg;";
}
if(iii==1407){
	add_number=0;
	raw_interface_name="corenet_udp_receive_mail_port";
	add0="allow $1 mail_port_t:udp_socket recv_msg;";
}
if(iii==1408){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_mail_port";
	add0="dontaudit $1 mail_port_t:udp_socket recv_msg;";
}
if(iii==1409){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_mail_port";
	add0="corenet_udp_send_mail_port($1)";
	add1="corenet_udp_receive_mail_port($1)";
	add_number =1;
}
if(iii==1410){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_mail_port";
	add0="corenet_dontaudit_udp_send_mail_port($1)";
	add1="corenet_dontaudit_udp_receive_mail_port($1)";
	add_number =1;
}
if(iii==1411){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_mail_port";
	add0="allow $1 mail_port_t:tcp_socket name_bind;";
}
if(iii==1412){
	add_number=0;
	raw_interface_name="corenet_udp_bind_mail_port";
	add0="allow $1 mail_port_t:udp_socket name_bind;";
}
if(iii==1413){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_mail_port";
	add0="allow $1 mail_port_t:tcp_socket name_connect;";
}
if(iii==1414){
	add_number=0;
	raw_interface_name="corenet_send_mail_client_packets";
	add0="allow $1 mail_client_packet_t:packet send;";
}
if(iii==1415){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_mail_client_packets";
	add0="dontaudit $1 mail_client_packet_t:packet send;";
}
if(iii==1416){
	add_number=0;
	raw_interface_name="corenet_receive_mail_client_packets";
	add0="allow $1 mail_client_packet_t:packet recv;";
}
if(iii==1417){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_mail_client_packets";
	add0="dontaudit $1 mail_client_packet_t:packet recv;";
}
if(iii==1418){
	add_number=0;
	raw_interface_name="corenet_sendrecv_mail_client_packets";
	add0="corenet_send_mail_client_packets($1)";
	add1="corenet_receive_mail_client_packets($1)";
	add_number =1;
}
if(iii==1419){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_mail_client_packets";
	add0="corenet_dontaudit_send_mail_client_packets($1)";
	add1="corenet_dontaudit_receive_mail_client_packets($1)";
	add_number =1;
}
if(iii==1420){
	add_number=0;
	raw_interface_name="corenet_relabelto_mail_client_packets";
	add0="allow $1 mail_client_packet_t:packet relabelto;";
}
if(iii==1421){
	add_number=0;
	raw_interface_name="corenet_send_mail_server_packets";
	add0="allow $1 mail_server_packet_t:packet send;";
}
if(iii==1422){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_mail_server_packets";
	add0="dontaudit $1 mail_server_packet_t:packet send;";
}
if(iii==1423){
	add_number=0;
	raw_interface_name="corenet_receive_mail_server_packets";
	add0="allow $1 mail_server_packet_t:packet recv;";
}
if(iii==1424){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_mail_server_packets";
	add0="dontaudit $1 mail_server_packet_t:packet recv;";
}
if(iii==1425){
	add_number=0;
	raw_interface_name="corenet_sendrecv_mail_server_packets";
	add0="corenet_send_mail_server_packets($1)";
	add1="corenet_receive_mail_server_packets($1)";
	add_number =1;
}
if(iii==1426){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_mail_server_packets";
	add0="corenet_dontaudit_send_mail_server_packets($1)";
	add1="corenet_dontaudit_receive_mail_server_packets($1)";
	add_number =1;
}
if(iii==1427){
	add_number=0;
	raw_interface_name="corenet_relabelto_mail_server_packets";
	add0="allow $1 mail_server_packet_t:packet relabelto;";
}
if(iii==1428){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_mmcc_port";
	add0="allow $1 mmcc_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1429){
	add_number=0;
	raw_interface_name="corenet_udp_send_mmcc_port";
	add0="allow $1 mmcc_port_t:udp_socket send_msg;";
}
if(iii==1430){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_mmcc_port";
	add0="dontaudit $1 mmcc_port_t:udp_socket send_msg;";
}
if(iii==1431){
	add_number=0;
	raw_interface_name="corenet_udp_receive_mmcc_port";
	add0="allow $1 mmcc_port_t:udp_socket recv_msg;";
}
if(iii==1432){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_mmcc_port";
	add0="dontaudit $1 mmcc_port_t:udp_socket recv_msg;";
}
if(iii==1433){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_mmcc_port";
	add0="corenet_udp_send_mmcc_port($1)";
	add1="corenet_udp_receive_mmcc_port($1)";
	add_number =1;
}
if(iii==1434){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_mmcc_port";
	add0="corenet_dontaudit_udp_send_mmcc_port($1)";
	add1="corenet_dontaudit_udp_receive_mmcc_port($1)";
	add_number =1;
}
if(iii==1435){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_mmcc_port";
	add0="allow $1 mmcc_port_t:tcp_socket name_bind;";
}
if(iii==1436){
	add_number=0;
	raw_interface_name="corenet_udp_bind_mmcc_port";
	add0="allow $1 mmcc_port_t:udp_socket name_bind;";
}
if(iii==1437){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_mmcc_port";
	add0="allow $1 mmcc_port_t:tcp_socket name_connect;";
}
if(iii==1438){
	add_number=0;
	raw_interface_name="corenet_send_mmcc_client_packets";
	add0="allow $1 mmcc_client_packet_t:packet send;";
}
if(iii==1439){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_mmcc_client_packets";
	add0="dontaudit $1 mmcc_client_packet_t:packet send;";
}
if(iii==1440){
	add_number=0;
	raw_interface_name="corenet_receive_mmcc_client_packets";
	add0="allow $1 mmcc_client_packet_t:packet recv;";
}
if(iii==1441){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_mmcc_client_packets";
	add0="dontaudit $1 mmcc_client_packet_t:packet recv;";
}
if(iii==1442){
	add_number=0;
	raw_interface_name="corenet_sendrecv_mmcc_client_packets";
	add0="corenet_send_mmcc_client_packets($1)";
	add1="corenet_receive_mmcc_client_packets($1)";
	add_number =1;
}
if(iii==1443){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_mmcc_client_packets";
	add0="corenet_dontaudit_send_mmcc_client_packets($1)";
	add1="corenet_dontaudit_receive_mmcc_client_packets($1)";
	add_number =1;
}
if(iii==1444){
	add_number=0;
	raw_interface_name="corenet_relabelto_mmcc_client_packets";
	add0="allow $1 mmcc_client_packet_t:packet relabelto;";
}
if(iii==1445){
	add_number=0;
	raw_interface_name="corenet_send_mmcc_server_packets";
	add0="allow $1 mmcc_server_packet_t:packet send;";
}
if(iii==1446){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_mmcc_server_packets";
	add0="dontaudit $1 mmcc_server_packet_t:packet send;";
}
if(iii==1447){
	add_number=0;
	raw_interface_name="corenet_receive_mmcc_server_packets";
	add0="allow $1 mmcc_server_packet_t:packet recv;";
}
if(iii==1448){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_mmcc_server_packets";
	add0="dontaudit $1 mmcc_server_packet_t:packet recv;";
}
if(iii==1449){
	add_number=0;
	raw_interface_name="corenet_sendrecv_mmcc_server_packets";
	add0="corenet_send_mmcc_server_packets($1)";
	add1="corenet_receive_mmcc_server_packets($1)";
	add_number =1;
}
if(iii==1450){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_mmcc_server_packets";
	add0="corenet_dontaudit_send_mmcc_server_packets($1)";
	add1="corenet_dontaudit_receive_mmcc_server_packets($1)";
	add_number =1;
}
if(iii==1451){
	add_number=0;
	raw_interface_name="corenet_relabelto_mmcc_server_packets";
	add0="allow $1 mmcc_server_packet_t:packet relabelto;";
}
if(iii==1452){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_msnp_port";
	add0="allow $1 msnp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1453){
	add_number=0;
	raw_interface_name="corenet_udp_send_msnp_port";
	add0="allow $1 msnp_port_t:udp_socket send_msg;";
}
if(iii==1454){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_msnp_port";
	add0="dontaudit $1 msnp_port_t:udp_socket send_msg;";
}
if(iii==1455){
	add_number=0;
	raw_interface_name="corenet_udp_receive_msnp_port";
	add0="allow $1 msnp_port_t:udp_socket recv_msg;";
}
if(iii==1456){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_msnp_port";
	add0="dontaudit $1 msnp_port_t:udp_socket recv_msg;";
}
if(iii==1457){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_msnp_port";
	add0="corenet_udp_send_msnp_port($1)";
	add1="corenet_udp_receive_msnp_port($1)";
	add_number =1;
}
if(iii==1458){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_msnp_port";
	add0="corenet_dontaudit_udp_send_msnp_port($1)";
	add1="corenet_dontaudit_udp_receive_msnp_port($1)";
	add_number =1;
}
if(iii==1459){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_msnp_port";
	add0="allow $1 msnp_port_t:tcp_socket name_bind;";
}
if(iii==1460){
	add_number=0;
	raw_interface_name="corenet_udp_bind_msnp_port";
	add0="allow $1 msnp_port_t:udp_socket name_bind;";
}
if(iii==1461){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_msnp_port";
	add0="allow $1 msnp_port_t:tcp_socket name_connect;";
}
if(iii==1462){
	add_number=0;
	raw_interface_name="corenet_send_msnp_client_packets";
	add0="allow $1 msnp_client_packet_t:packet send;";
}
if(iii==1463){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_msnp_client_packets";
	add0="dontaudit $1 msnp_client_packet_t:packet send;";
}
if(iii==1464){
	add_number=0;
	raw_interface_name="corenet_receive_msnp_client_packets";
	add0="allow $1 msnp_client_packet_t:packet recv;";
}
if(iii==1465){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_msnp_client_packets";
	add0="dontaudit $1 msnp_client_packet_t:packet recv;";
}
if(iii==1466){
	add_number=0;
	raw_interface_name="corenet_sendrecv_msnp_client_packets";
	add0="corenet_send_msnp_client_packets($1)";
	add1="corenet_receive_msnp_client_packets($1)";
	add_number =1;
}
if(iii==1467){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_msnp_client_packets";
	add0="corenet_dontaudit_send_msnp_client_packets($1)";
	add1="corenet_dontaudit_receive_msnp_client_packets($1)";
	add_number =1;
}
if(iii==1468){
	add_number=0;
	raw_interface_name="corenet_relabelto_msnp_client_packets";
	add0="allow $1 msnp_client_packet_t:packet relabelto;";
}
if(iii==1469){
	add_number=0;
	raw_interface_name="corenet_send_msnp_server_packets";
	add0="allow $1 msnp_server_packet_t:packet send;";
}
if(iii==1470){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_msnp_server_packets";
	add0="dontaudit $1 msnp_server_packet_t:packet send;";
}
if(iii==1471){
	add_number=0;
	raw_interface_name="corenet_receive_msnp_server_packets";
	add0="allow $1 msnp_server_packet_t:packet recv;";
}
if(iii==1472){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_msnp_server_packets";
	add0="dontaudit $1 msnp_server_packet_t:packet recv;";
}
if(iii==1473){
	add_number=0;
	raw_interface_name="corenet_sendrecv_msnp_server_packets";
	add0="corenet_send_msnp_server_packets($1)";
	add1="corenet_receive_msnp_server_packets($1)";
	add_number =1;
}
if(iii==1474){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_msnp_server_packets";
	add0="corenet_dontaudit_send_msnp_server_packets($1)";
	add1="corenet_dontaudit_receive_msnp_server_packets($1)";
	add_number =1;
}
if(iii==1475){
	add_number=0;
	raw_interface_name="corenet_relabelto_msnp_server_packets";
	add0="allow $1 msnp_server_packet_t:packet relabelto;";
}
if(iii==1476){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_monopd_port";
	add0="allow $1 monopd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1477){
	add_number=0;
	raw_interface_name="corenet_udp_send_monopd_port";
	add0="allow $1 monopd_port_t:udp_socket send_msg;";
}
if(iii==1478){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_monopd_port";
	add0="dontaudit $1 monopd_port_t:udp_socket send_msg;";
}
if(iii==1479){
	add_number=0;
	raw_interface_name="corenet_udp_receive_monopd_port";
	add0="allow $1 monopd_port_t:udp_socket recv_msg;";
}
if(iii==1480){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_monopd_port";
	add0="dontaudit $1 monopd_port_t:udp_socket recv_msg;";
}
if(iii==1481){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_monopd_port";
	add0="corenet_udp_send_monopd_port($1)";
	add1="corenet_udp_receive_monopd_port($1)";
	add_number =1;
}
if(iii==1482){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_monopd_port";
	add0="corenet_dontaudit_udp_send_monopd_port($1)";
	add1="corenet_dontaudit_udp_receive_monopd_port($1)";
	add_number =1;
}
if(iii==1483){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_monopd_port";
	add0="allow $1 monopd_port_t:tcp_socket name_bind;";
}
if(iii==1484){
	add_number=0;
	raw_interface_name="corenet_udp_bind_monopd_port";
	add0="allow $1 monopd_port_t:udp_socket name_bind;";
}
if(iii==1485){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_monopd_port";
	add0="allow $1 monopd_port_t:tcp_socket name_connect;";
}
if(iii==1486){
	add_number=0;
	raw_interface_name="corenet_send_monopd_client_packets";
	add0="allow $1 monopd_client_packet_t:packet send;";
}
if(iii==1487){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_monopd_client_packets";
	add0="dontaudit $1 monopd_client_packet_t:packet send;";
}
if(iii==1488){
	add_number=0;
	raw_interface_name="corenet_receive_monopd_client_packets";
	add0="allow $1 monopd_client_packet_t:packet recv;";
}
if(iii==1489){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_monopd_client_packets";
	add0="dontaudit $1 monopd_client_packet_t:packet recv;";
}
if(iii==1490){
	add_number=0;
	raw_interface_name="corenet_sendrecv_monopd_client_packets";
	add0="corenet_send_monopd_client_packets($1)";
	add1="corenet_receive_monopd_client_packets($1)";
	add_number =1;
}
if(iii==1491){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_monopd_client_packets";
	add0="corenet_dontaudit_send_monopd_client_packets($1)";
	add1="corenet_dontaudit_receive_monopd_client_packets($1)";
	add_number =1;
}
if(iii==1492){
	add_number=0;
	raw_interface_name="corenet_relabelto_monopd_client_packets";
	add0="allow $1 monopd_client_packet_t:packet relabelto;";
}
if(iii==1493){
	add_number=0;
	raw_interface_name="corenet_send_monopd_server_packets";
	add0="allow $1 monopd_server_packet_t:packet send;";
}
if(iii==1494){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_monopd_server_packets";
	add0="dontaudit $1 monopd_server_packet_t:packet send;";
}
if(iii==1495){
	add_number=0;
	raw_interface_name="corenet_receive_monopd_server_packets";
	add0="allow $1 monopd_server_packet_t:packet recv;";
}
if(iii==1496){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_monopd_server_packets";
	add0="dontaudit $1 monopd_server_packet_t:packet recv;";
}
if(iii==1497){
	add_number=0;
	raw_interface_name="corenet_sendrecv_monopd_server_packets";
	add0="corenet_send_monopd_server_packets($1)";
	add1="corenet_receive_monopd_server_packets($1)";
	add_number =1;
}
if(iii==1498){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_monopd_server_packets";
	add0="corenet_dontaudit_send_monopd_server_packets($1)";
	add1="corenet_dontaudit_receive_monopd_server_packets($1)";
	add_number =1;
}
if(iii==1499){
	add_number=0;
	raw_interface_name="corenet_relabelto_monopd_server_packets";
	add0="allow $1 monopd_server_packet_t:packet relabelto;";
}
if(iii==1500){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_mysqld_port";
	add0="allow $1 mysqld_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1501){
	add_number=0;
	raw_interface_name="corenet_udp_send_mysqld_port";
	add0="allow $1 mysqld_port_t:udp_socket send_msg;";
}
if(iii==1502){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_mysqld_port";
	add0="dontaudit $1 mysqld_port_t:udp_socket send_msg;";
}
if(iii==1503){
	add_number=0;
	raw_interface_name="corenet_udp_receive_mysqld_port";
	add0="allow $1 mysqld_port_t:udp_socket recv_msg;";
}
if(iii==1504){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_mysqld_port";
	add0="dontaudit $1 mysqld_port_t:udp_socket recv_msg;";
}
if(iii==1505){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_mysqld_port";
	add0="corenet_udp_send_mysqld_port($1)";
	add1="corenet_udp_receive_mysqld_port($1)";
	add_number =1;
}
if(iii==1506){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_mysqld_port";
	add0="corenet_dontaudit_udp_send_mysqld_port($1)";
	add1="corenet_dontaudit_udp_receive_mysqld_port($1)";
	add_number =1;
}
if(iii==1507){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_mysqld_port";
	add0="allow $1 mysqld_port_t:tcp_socket name_bind;";
}
if(iii==1508){
	add_number=0;
	raw_interface_name="corenet_udp_bind_mysqld_port";
	add0="allow $1 mysqld_port_t:udp_socket name_bind;";
}
if(iii==1509){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_mysqld_port";
	add0="allow $1 mysqld_port_t:tcp_socket name_connect;";
}
if(iii==1510){
	add_number=0;
	raw_interface_name="corenet_send_mysqld_client_packets";
	add0="allow $1 mysqld_client_packet_t:packet send;";
}
if(iii==1511){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_mysqld_client_packets";
	add0="dontaudit $1 mysqld_client_packet_t:packet send;";
}
if(iii==1512){
	add_number=0;
	raw_interface_name="corenet_receive_mysqld_client_packets";
	add0="allow $1 mysqld_client_packet_t:packet recv;";
}
if(iii==1513){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_mysqld_client_packets";
	add0="dontaudit $1 mysqld_client_packet_t:packet recv;";
}
if(iii==1514){
	add_number=0;
	raw_interface_name="corenet_sendrecv_mysqld_client_packets";
	add0="corenet_send_mysqld_client_packets($1)";
	add1="corenet_receive_mysqld_client_packets($1)";
	add_number =1;
}
if(iii==1515){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_mysqld_client_packets";
	add0="corenet_dontaudit_send_mysqld_client_packets($1)";
	add1="corenet_dontaudit_receive_mysqld_client_packets($1)";
	add_number =1;
}
if(iii==1516){
	add_number=0;
	raw_interface_name="corenet_relabelto_mysqld_client_packets";
	add0="allow $1 mysqld_client_packet_t:packet relabelto;";
}
if(iii==1517){
	add_number=0;
	raw_interface_name="corenet_send_mysqld_server_packets";
	add0="allow $1 mysqld_server_packet_t:packet send;";
}
if(iii==1518){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_mysqld_server_packets";
	add0="dontaudit $1 mysqld_server_packet_t:packet send;";
}
if(iii==1519){
	add_number=0;
	raw_interface_name="corenet_receive_mysqld_server_packets";
	add0="allow $1 mysqld_server_packet_t:packet recv;";
}
if(iii==1520){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_mysqld_server_packets";
	add0="dontaudit $1 mysqld_server_packet_t:packet recv;";
}
if(iii==1521){
	add_number=0;
	raw_interface_name="corenet_sendrecv_mysqld_server_packets";
	add0="corenet_send_mysqld_server_packets($1)";
	add1="corenet_receive_mysqld_server_packets($1)";
	add_number =1;
}
if(iii==1522){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_mysqld_server_packets";
	add0="corenet_dontaudit_send_mysqld_server_packets($1)";
	add1="corenet_dontaudit_receive_mysqld_server_packets($1)";
	add_number =1;
}
if(iii==1523){
	add_number=0;
	raw_interface_name="corenet_relabelto_mysqld_server_packets";
	add0="allow $1 mysqld_server_packet_t:packet relabelto;";
}
if(iii==1524){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_nessus_port";
	add0="allow $1 nessus_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1525){
	add_number=0;
	raw_interface_name="corenet_udp_send_nessus_port";
	add0="allow $1 nessus_port_t:udp_socket send_msg;";
}
if(iii==1526){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_nessus_port";
	add0="dontaudit $1 nessus_port_t:udp_socket send_msg;";
}
if(iii==1527){
	add_number=0;
	raw_interface_name="corenet_udp_receive_nessus_port";
	add0="allow $1 nessus_port_t:udp_socket recv_msg;";
}
if(iii==1528){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_nessus_port";
	add0="dontaudit $1 nessus_port_t:udp_socket recv_msg;";
}
if(iii==1529){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_nessus_port";
	add0="corenet_udp_send_nessus_port($1)";
	add1="corenet_udp_receive_nessus_port($1)";
	add_number =1;
}
if(iii==1530){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_nessus_port";
	add0="corenet_dontaudit_udp_send_nessus_port($1)";
	add1="corenet_dontaudit_udp_receive_nessus_port($1)";
	add_number =1;
}
if(iii==1531){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_nessus_port";
	add0="allow $1 nessus_port_t:tcp_socket name_bind;";
}
if(iii==1532){
	add_number=0;
	raw_interface_name="corenet_udp_bind_nessus_port";
	add0="allow $1 nessus_port_t:udp_socket name_bind;";
}
if(iii==1533){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_nessus_port";
	add0="allow $1 nessus_port_t:tcp_socket name_connect;";
}
if(iii==1534){
	add_number=0;
	raw_interface_name="corenet_send_nessus_client_packets";
	add0="allow $1 nessus_client_packet_t:packet send;";
}
if(iii==1535){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_nessus_client_packets";
	add0="dontaudit $1 nessus_client_packet_t:packet send;";
}
if(iii==1536){
	add_number=0;
	raw_interface_name="corenet_receive_nessus_client_packets";
	add0="allow $1 nessus_client_packet_t:packet recv;";
}
if(iii==1537){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_nessus_client_packets";
	add0="dontaudit $1 nessus_client_packet_t:packet recv;";
}
if(iii==1538){
	add_number=0;
	raw_interface_name="corenet_sendrecv_nessus_client_packets";
	add0="corenet_send_nessus_client_packets($1)";
	add1="corenet_receive_nessus_client_packets($1)";
	add_number =1;
}
if(iii==1539){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_nessus_client_packets";
	add0="corenet_dontaudit_send_nessus_client_packets($1)";
	add1="corenet_dontaudit_receive_nessus_client_packets($1)";
	add_number =1;
}
if(iii==1540){
	add_number=0;
	raw_interface_name="corenet_relabelto_nessus_client_packets";
	add0="allow $1 nessus_client_packet_t:packet relabelto;";
}
if(iii==1541){
	add_number=0;
	raw_interface_name="corenet_send_nessus_server_packets";
	add0="allow $1 nessus_server_packet_t:packet send;";
}
if(iii==1542){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_nessus_server_packets";
	add0="dontaudit $1 nessus_server_packet_t:packet send;";
}
if(iii==1543){
	add_number=0;
	raw_interface_name="corenet_receive_nessus_server_packets";
	add0="allow $1 nessus_server_packet_t:packet recv;";
}
if(iii==1544){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_nessus_server_packets";
	add0="dontaudit $1 nessus_server_packet_t:packet recv;";
}
if(iii==1545){
	add_number=0;
	raw_interface_name="corenet_sendrecv_nessus_server_packets";
	add0="corenet_send_nessus_server_packets($1)";
	add1="corenet_receive_nessus_server_packets($1)";
	add_number =1;
}
if(iii==1546){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_nessus_server_packets";
	add0="corenet_dontaudit_send_nessus_server_packets($1)";
	add1="corenet_dontaudit_receive_nessus_server_packets($1)";
	add_number =1;
}
if(iii==1547){
	add_number=0;
	raw_interface_name="corenet_relabelto_nessus_server_packets";
	add0="allow $1 nessus_server_packet_t:packet relabelto;";
}
if(iii==1548){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_netsupport_port";
	add0="allow $1 netsupport_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1549){
	add_number=0;
	raw_interface_name="corenet_udp_send_netsupport_port";
	add0="allow $1 netsupport_port_t:udp_socket send_msg;";
}
if(iii==1550){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_netsupport_port";
	add0="dontaudit $1 netsupport_port_t:udp_socket send_msg;";
}
if(iii==1551){
	add_number=0;
	raw_interface_name="corenet_udp_receive_netsupport_port";
	add0="allow $1 netsupport_port_t:udp_socket recv_msg;";
}
if(iii==1552){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_netsupport_port";
	add0="dontaudit $1 netsupport_port_t:udp_socket recv_msg;";
}
if(iii==1553){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_netsupport_port";
	add0="corenet_udp_send_netsupport_port($1)";
	add1="corenet_udp_receive_netsupport_port($1)";
	add_number =1;
}
if(iii==1554){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_netsupport_port";
	add0="corenet_dontaudit_udp_send_netsupport_port($1)";
	add1="corenet_dontaudit_udp_receive_netsupport_port($1)";
	add_number =1;
}
if(iii==1555){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_netsupport_port";
	add0="allow $1 netsupport_port_t:tcp_socket name_bind;";
}
if(iii==1556){
	add_number=0;
	raw_interface_name="corenet_udp_bind_netsupport_port";
	add0="allow $1 netsupport_port_t:udp_socket name_bind;";
}
if(iii==1557){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_netsupport_port";
	add0="allow $1 netsupport_port_t:tcp_socket name_connect;";
}
if(iii==1558){
	add_number=0;
	raw_interface_name="corenet_send_netsupport_client_packets";
	add0="allow $1 netsupport_client_packet_t:packet send;";
}
if(iii==1559){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_netsupport_client_packets";
	add0="dontaudit $1 netsupport_client_packet_t:packet send;";
}
if(iii==1560){
	add_number=0;
	raw_interface_name="corenet_receive_netsupport_client_packets";
	add0="allow $1 netsupport_client_packet_t:packet recv;";
}
if(iii==1561){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_netsupport_client_packets";
	add0="dontaudit $1 netsupport_client_packet_t:packet recv;";
}
if(iii==1562){
	add_number=0;
	raw_interface_name="corenet_sendrecv_netsupport_client_packets";
	add0="corenet_send_netsupport_client_packets($1)";
	add1="corenet_receive_netsupport_client_packets($1)";
	add_number =1;
}
if(iii==1563){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_netsupport_client_packets";
	add0="corenet_dontaudit_send_netsupport_client_packets($1)";
	add1="corenet_dontaudit_receive_netsupport_client_packets($1)";
	add_number =1;
}
if(iii==1564){
	add_number=0;
	raw_interface_name="corenet_relabelto_netsupport_client_packets";
	add0="allow $1 netsupport_client_packet_t:packet relabelto;";
}
if(iii==1565){
	add_number=0;
	raw_interface_name="corenet_send_netsupport_server_packets";
	add0="allow $1 netsupport_server_packet_t:packet send;";
}
if(iii==1566){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_netsupport_server_packets";
	add0="dontaudit $1 netsupport_server_packet_t:packet send;";
}
if(iii==1567){
	add_number=0;
	raw_interface_name="corenet_receive_netsupport_server_packets";
	add0="allow $1 netsupport_server_packet_t:packet recv;";
}
if(iii==1568){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_netsupport_server_packets";
	add0="dontaudit $1 netsupport_server_packet_t:packet recv;";
}
if(iii==1569){
	add_number=0;
	raw_interface_name="corenet_sendrecv_netsupport_server_packets";
	add0="corenet_send_netsupport_server_packets($1)";
	add1="corenet_receive_netsupport_server_packets($1)";
	add_number =1;
}
if(iii==1570){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_netsupport_server_packets";
	add0="corenet_dontaudit_send_netsupport_server_packets($1)";
	add1="corenet_dontaudit_receive_netsupport_server_packets($1)";
	add_number =1;
}
if(iii==1571){
	add_number=0;
	raw_interface_name="corenet_relabelto_netsupport_server_packets";
	add0="allow $1 netsupport_server_packet_t:packet relabelto;";
}
if(iii==1572){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_nmbd_port";
	add0="allow $1 nmbd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1573){
	add_number=0;
	raw_interface_name="corenet_udp_send_nmbd_port";
	add0="allow $1 nmbd_port_t:udp_socket send_msg;";
}
if(iii==1574){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_nmbd_port";
	add0="dontaudit $1 nmbd_port_t:udp_socket send_msg;";
}
if(iii==1575){
	add_number=0;
	raw_interface_name="corenet_udp_receive_nmbd_port";
	add0="allow $1 nmbd_port_t:udp_socket recv_msg;";
}
if(iii==1576){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_nmbd_port";
	add0="dontaudit $1 nmbd_port_t:udp_socket recv_msg;";
}
if(iii==1577){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_nmbd_port";
	add0="corenet_udp_send_nmbd_port($1)";
	add1="corenet_udp_receive_nmbd_port($1)";
	add_number =1;
}
if(iii==1578){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_nmbd_port";
	add0="corenet_dontaudit_udp_send_nmbd_port($1)";
	add1="corenet_dontaudit_udp_receive_nmbd_port($1)";
	add_number =1;
}
if(iii==1579){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_nmbd_port";
	add0="allow $1 nmbd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1580){
	add_number=0;
	raw_interface_name="corenet_udp_bind_nmbd_port";
	add0="allow $1 nmbd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1581){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_nmbd_port";
	add0="allow $1 nmbd_port_t:tcp_socket name_connect;";
}
if(iii==1582){
	add_number=0;
	raw_interface_name="corenet_send_nmbd_client_packets";
	add0="allow $1 nmbd_client_packet_t:packet send;";
}
if(iii==1583){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_nmbd_client_packets";
	add0="dontaudit $1 nmbd_client_packet_t:packet send;";
}
if(iii==1584){
	add_number=0;
	raw_interface_name="corenet_receive_nmbd_client_packets";
	add0="allow $1 nmbd_client_packet_t:packet recv;";
}
if(iii==1585){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_nmbd_client_packets";
	add0="dontaudit $1 nmbd_client_packet_t:packet recv;";
}
if(iii==1586){
	add_number=0;
	raw_interface_name="corenet_sendrecv_nmbd_client_packets";
	add0="corenet_send_nmbd_client_packets($1)";
	add1="corenet_receive_nmbd_client_packets($1)";
	add_number =1;
}
if(iii==1587){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_nmbd_client_packets";
	add0="corenet_dontaudit_send_nmbd_client_packets($1)";
	add1="corenet_dontaudit_receive_nmbd_client_packets($1)";
	add_number =1;
}
if(iii==1588){
	add_number=0;
	raw_interface_name="corenet_relabelto_nmbd_client_packets";
	add0="allow $1 nmbd_client_packet_t:packet relabelto;";
}
if(iii==1589){
	add_number=0;
	raw_interface_name="corenet_send_nmbd_server_packets";
	add0="allow $1 nmbd_server_packet_t:packet send;";
}
if(iii==1590){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_nmbd_server_packets";
	add0="dontaudit $1 nmbd_server_packet_t:packet send;";
}
if(iii==1591){
	add_number=0;
	raw_interface_name="corenet_receive_nmbd_server_packets";
	add0="allow $1 nmbd_server_packet_t:packet recv;";
}
if(iii==1592){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_nmbd_server_packets";
	add0="dontaudit $1 nmbd_server_packet_t:packet recv;";
}
if(iii==1593){
	add_number=0;
	raw_interface_name="corenet_sendrecv_nmbd_server_packets";
	add0="corenet_send_nmbd_server_packets($1)";
	add1="corenet_receive_nmbd_server_packets($1)";
	add_number =1;
}
if(iii==1594){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_nmbd_server_packets";
	add0="corenet_dontaudit_send_nmbd_server_packets($1)";
	add1="corenet_dontaudit_receive_nmbd_server_packets($1)";
	add_number =1;
}
if(iii==1595){
	add_number=0;
	raw_interface_name="corenet_relabelto_nmbd_server_packets";
	add0="allow $1 nmbd_server_packet_t:packet relabelto;";
}
if(iii==1596){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ntp_port";
	add0="allow $1 ntp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1597){
	add_number=0;
	raw_interface_name="corenet_udp_send_ntp_port";
	add0="allow $1 ntp_port_t:udp_socket send_msg;";
}
if(iii==1598){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ntp_port";
	add0="dontaudit $1 ntp_port_t:udp_socket send_msg;";
}
if(iii==1599){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ntp_port";
	add0="allow $1 ntp_port_t:udp_socket recv_msg;";
}
if(iii==1600){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ntp_port";
	add0="dontaudit $1 ntp_port_t:udp_socket recv_msg;";
}
if(iii==1601){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ntp_port";
	add0="corenet_udp_send_ntp_port($1)";
	add1="corenet_udp_receive_ntp_port($1)";
	add_number =1;
}
if(iii==1602){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ntp_port";
	add0="corenet_dontaudit_udp_send_ntp_port($1)";
	add1="corenet_dontaudit_udp_receive_ntp_port($1)";
	add_number =1;
}
if(iii==1603){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ntp_port";
	add0="allow $1 ntp_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1604){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ntp_port";
	add0="allow $1 ntp_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1605){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ntp_port";
	add0="allow $1 ntp_port_t:tcp_socket name_connect;";
}
if(iii==1606){
	add_number=0;
	raw_interface_name="corenet_send_ntp_client_packets";
	add0="allow $1 ntp_client_packet_t:packet send;";
}
if(iii==1607){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ntp_client_packets";
	add0="dontaudit $1 ntp_client_packet_t:packet send;";
}
if(iii==1608){
	add_number=0;
	raw_interface_name="corenet_receive_ntp_client_packets";
	add0="allow $1 ntp_client_packet_t:packet recv;";
}
if(iii==1609){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ntp_client_packets";
	add0="dontaudit $1 ntp_client_packet_t:packet recv;";
}
if(iii==1610){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ntp_client_packets";
	add0="corenet_send_ntp_client_packets($1)";
	add1="corenet_receive_ntp_client_packets($1)";
	add_number =1;
}
if(iii==1611){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ntp_client_packets";
	add0="corenet_dontaudit_send_ntp_client_packets($1)";
	add1="corenet_dontaudit_receive_ntp_client_packets($1)";
	add_number =1;
}
if(iii==1612){
	add_number=0;
	raw_interface_name="corenet_relabelto_ntp_client_packets";
	add0="allow $1 ntp_client_packet_t:packet relabelto;";
}
if(iii==1613){
	add_number=0;
	raw_interface_name="corenet_send_ntp_server_packets";
	add0="allow $1 ntp_server_packet_t:packet send;";
}
if(iii==1614){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ntp_server_packets";
	add0="dontaudit $1 ntp_server_packet_t:packet send;";
}
if(iii==1615){
	add_number=0;
	raw_interface_name="corenet_receive_ntp_server_packets";
	add0="allow $1 ntp_server_packet_t:packet recv;";
}
if(iii==1616){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ntp_server_packets";
	add0="dontaudit $1 ntp_server_packet_t:packet recv;";
}
if(iii==1617){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ntp_server_packets";
	add0="corenet_send_ntp_server_packets($1)";
	add1="corenet_receive_ntp_server_packets($1)";
	add_number =1;
}
if(iii==1618){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ntp_server_packets";
	add0="corenet_dontaudit_send_ntp_server_packets($1)";
	add1="corenet_dontaudit_receive_ntp_server_packets($1)";
	add_number =1;
}
if(iii==1619){
	add_number=0;
	raw_interface_name="corenet_relabelto_ntp_server_packets";
	add0="allow $1 ntp_server_packet_t:packet relabelto;";
}
if(iii==1620){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ocsp_port";
	add0="allow $1 ocsp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1621){
	add_number=0;
	raw_interface_name="corenet_udp_send_ocsp_port";
	add0="allow $1 ocsp_port_t:udp_socket send_msg;";
}
if(iii==1622){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ocsp_port";
	add0="dontaudit $1 ocsp_port_t:udp_socket send_msg;";
}
if(iii==1623){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ocsp_port";
	add0="allow $1 ocsp_port_t:udp_socket recv_msg;";
}
if(iii==1624){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ocsp_port";
	add0="dontaudit $1 ocsp_port_t:udp_socket recv_msg;";
}
if(iii==1625){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ocsp_port";
	add0="corenet_udp_send_ocsp_port($1)";
	add1="corenet_udp_receive_ocsp_port($1)";
	add_number =1;
}
if(iii==1626){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ocsp_port";
	add0="corenet_dontaudit_udp_send_ocsp_port($1)";
	add1="corenet_dontaudit_udp_receive_ocsp_port($1)";
	add_number =1;
}
if(iii==1627){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ocsp_port";
	add0="allow $1 ocsp_port_t:tcp_socket name_bind;";
}
if(iii==1628){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ocsp_port";
	add0="allow $1 ocsp_port_t:udp_socket name_bind;";
}
if(iii==1629){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ocsp_port";
	add0="allow $1 ocsp_port_t:tcp_socket name_connect;";
}
if(iii==1630){
	add_number=0;
	raw_interface_name="corenet_send_ocsp_client_packets";
	add0="allow $1 ocsp_client_packet_t:packet send;";
}
if(iii==1631){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ocsp_client_packets";
	add0="dontaudit $1 ocsp_client_packet_t:packet send;";
}
if(iii==1632){
	add_number=0;
	raw_interface_name="corenet_receive_ocsp_client_packets";
	add0="allow $1 ocsp_client_packet_t:packet recv;";
}
if(iii==1633){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ocsp_client_packets";
	add0="dontaudit $1 ocsp_client_packet_t:packet recv;";
}
if(iii==1634){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ocsp_client_packets";
	add0="corenet_send_ocsp_client_packets($1)";
	add1="corenet_receive_ocsp_client_packets($1)";
	add_number =1;
}
if(iii==1635){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ocsp_client_packets";
	add0="corenet_dontaudit_send_ocsp_client_packets($1)";
	add1="corenet_dontaudit_receive_ocsp_client_packets($1)";
	add_number =1;
}
if(iii==1636){
	add_number=0;
	raw_interface_name="corenet_relabelto_ocsp_client_packets";
	add0="allow $1 ocsp_client_packet_t:packet relabelto;";
}
if(iii==1637){
	add_number=0;
	raw_interface_name="corenet_send_ocsp_server_packets";
	add0="allow $1 ocsp_server_packet_t:packet send;";
}
if(iii==1638){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ocsp_server_packets";
	add0="dontaudit $1 ocsp_server_packet_t:packet send;";
}
if(iii==1639){
	add_number=0;
	raw_interface_name="corenet_receive_ocsp_server_packets";
	add0="allow $1 ocsp_server_packet_t:packet recv;";
}
if(iii==1640){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ocsp_server_packets";
	add0="dontaudit $1 ocsp_server_packet_t:packet recv;";
}
if(iii==1641){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ocsp_server_packets";
	add0="corenet_send_ocsp_server_packets($1)";
	add1="corenet_receive_ocsp_server_packets($1)";
	add_number =1;
}
if(iii==1642){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ocsp_server_packets";
	add0="corenet_dontaudit_send_ocsp_server_packets($1)";
	add1="corenet_dontaudit_receive_ocsp_server_packets($1)";
	add_number =1;
}
if(iii==1643){
	add_number=0;
	raw_interface_name="corenet_relabelto_ocsp_server_packets";
	add0="allow $1 ocsp_server_packet_t:packet relabelto;";
}
if(iii==1644){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_openvpn_port";
	add0="allow $1 openvpn_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1645){
	add_number=0;
	raw_interface_name="corenet_udp_send_openvpn_port";
	add0="allow $1 openvpn_port_t:udp_socket send_msg;";
}
if(iii==1646){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_openvpn_port";
	add0="dontaudit $1 openvpn_port_t:udp_socket send_msg;";
}
if(iii==1647){
	add_number=0;
	raw_interface_name="corenet_udp_receive_openvpn_port";
	add0="allow $1 openvpn_port_t:udp_socket recv_msg;";
}
if(iii==1648){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_openvpn_port";
	add0="dontaudit $1 openvpn_port_t:udp_socket recv_msg;";
}
if(iii==1649){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_openvpn_port";
	add0="corenet_udp_send_openvpn_port($1)";
	add1="corenet_udp_receive_openvpn_port($1)";
	add_number =1;
}
if(iii==1650){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_openvpn_port";
	add0="corenet_dontaudit_udp_send_openvpn_port($1)";
	add1="corenet_dontaudit_udp_receive_openvpn_port($1)";
	add_number =1;
}
if(iii==1651){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_openvpn_port";
	add0="allow $1 openvpn_port_t:tcp_socket name_bind;";
}
if(iii==1652){
	add_number=0;
	raw_interface_name="corenet_udp_bind_openvpn_port";
	add0="allow $1 openvpn_port_t:udp_socket name_bind;";
}
if(iii==1653){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_openvpn_port";
	add0="allow $1 openvpn_port_t:tcp_socket name_connect;";
}
if(iii==1654){
	add_number=0;
	raw_interface_name="corenet_send_openvpn_client_packets";
	add0="allow $1 openvpn_client_packet_t:packet send;";
}
if(iii==1655){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_openvpn_client_packets";
	add0="dontaudit $1 openvpn_client_packet_t:packet send;";
}
if(iii==1656){
	add_number=0;
	raw_interface_name="corenet_receive_openvpn_client_packets";
	add0="allow $1 openvpn_client_packet_t:packet recv;";
}
if(iii==1657){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_openvpn_client_packets";
	add0="dontaudit $1 openvpn_client_packet_t:packet recv;";
}
if(iii==1658){
	add_number=0;
	raw_interface_name="corenet_sendrecv_openvpn_client_packets";
	add0="corenet_send_openvpn_client_packets($1)";
	add1="corenet_receive_openvpn_client_packets($1)";
	add_number =1;
}
if(iii==1659){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_openvpn_client_packets";
	add0="corenet_dontaudit_send_openvpn_client_packets($1)";
	add1="corenet_dontaudit_receive_openvpn_client_packets($1)";
	add_number =1;
}
if(iii==1660){
	add_number=0;
	raw_interface_name="corenet_relabelto_openvpn_client_packets";
	add0="allow $1 openvpn_client_packet_t:packet relabelto;";
}
if(iii==1661){
	add_number=0;
	raw_interface_name="corenet_send_openvpn_server_packets";
	add0="allow $1 openvpn_server_packet_t:packet send;";
}
if(iii==1662){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_openvpn_server_packets";
	add0="dontaudit $1 openvpn_server_packet_t:packet send;";
}
if(iii==1663){
	add_number=0;
	raw_interface_name="corenet_receive_openvpn_server_packets";
	add0="allow $1 openvpn_server_packet_t:packet recv;";
}
if(iii==1664){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_openvpn_server_packets";
	add0="dontaudit $1 openvpn_server_packet_t:packet recv;";
}
if(iii==1665){
	add_number=0;
	raw_interface_name="corenet_sendrecv_openvpn_server_packets";
	add0="corenet_send_openvpn_server_packets($1)";
	add1="corenet_receive_openvpn_server_packets($1)";
	add_number =1;
}
if(iii==1666){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_openvpn_server_packets";
	add0="corenet_dontaudit_send_openvpn_server_packets($1)";
	add1="corenet_dontaudit_receive_openvpn_server_packets($1)";
	add_number =1;
}
if(iii==1667){
	add_number=0;
	raw_interface_name="corenet_relabelto_openvpn_server_packets";
	add0="allow $1 openvpn_server_packet_t:packet relabelto;";
}
if(iii==1668){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_pegasus_http_port";
	add0="allow $1 pegasus_http_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1669){
	add_number=0;
	raw_interface_name="corenet_udp_send_pegasus_http_port";
	add0="allow $1 pegasus_http_port_t:udp_socket send_msg;";
}
if(iii==1670){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_pegasus_http_port";
	add0="dontaudit $1 pegasus_http_port_t:udp_socket send_msg;";
}
if(iii==1671){
	add_number=0;
	raw_interface_name="corenet_udp_receive_pegasus_http_port";
	add0="allow $1 pegasus_http_port_t:udp_socket recv_msg;";
}
if(iii==1672){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_pegasus_http_port";
	add0="dontaudit $1 pegasus_http_port_t:udp_socket recv_msg;";
}
if(iii==1673){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_pegasus_http_port";
	add0="corenet_udp_send_pegasus_http_port($1)";
	add1="corenet_udp_receive_pegasus_http_port($1)";
	add_number =1;
}
if(iii==1674){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_pegasus_http_port";
	add0="corenet_dontaudit_udp_send_pegasus_http_port($1)";
	add1="corenet_dontaudit_udp_receive_pegasus_http_port($1)";
	add_number =1;
}
if(iii==1675){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_pegasus_http_port";
	add0="allow $1 pegasus_http_port_t:tcp_socket name_bind;";
}
if(iii==1676){
	add_number=0;
	raw_interface_name="corenet_udp_bind_pegasus_http_port";
	add0="allow $1 pegasus_http_port_t:udp_socket name_bind;";
}
if(iii==1677){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_pegasus_http_port";
	add0="allow $1 pegasus_http_port_t:tcp_socket name_connect;";
}
if(iii==1678){
	add_number=0;
	raw_interface_name="corenet_send_pegasus_http_client_packets";
	add0="allow $1 pegasus_http_client_packet_t:packet send;";
}
if(iii==1679){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pegasus_http_client_packets";
	add0="dontaudit $1 pegasus_http_client_packet_t:packet send;";
}
if(iii==1680){
	add_number=0;
	raw_interface_name="corenet_receive_pegasus_http_client_packets";
	add0="allow $1 pegasus_http_client_packet_t:packet recv;";
}
if(iii==1681){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pegasus_http_client_packets";
	add0="dontaudit $1 pegasus_http_client_packet_t:packet recv;";
}
if(iii==1682){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pegasus_http_client_packets";
	add0="corenet_send_pegasus_http_client_packets($1)";
	add1="corenet_receive_pegasus_http_client_packets($1)";
	add_number =1;
}
if(iii==1683){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pegasus_http_client_packets";
	add0="corenet_dontaudit_send_pegasus_http_client_packets($1)";
	add1="corenet_dontaudit_receive_pegasus_http_client_packets($1)";
	add_number =1;
}
if(iii==1684){
	add_number=0;
	raw_interface_name="corenet_relabelto_pegasus_http_client_packets";
	add0="allow $1 pegasus_http_client_packet_t:packet relabelto;";
}
if(iii==1685){
	add_number=0;
	raw_interface_name="corenet_send_pegasus_http_server_packets";
	add0="allow $1 pegasus_http_server_packet_t:packet send;";
}
if(iii==1686){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pegasus_http_server_packets";
	add0="dontaudit $1 pegasus_http_server_packet_t:packet send;";
}
if(iii==1687){
	add_number=0;
	raw_interface_name="corenet_receive_pegasus_http_server_packets";
	add0="allow $1 pegasus_http_server_packet_t:packet recv;";
}
if(iii==1688){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pegasus_http_server_packets";
	add0="dontaudit $1 pegasus_http_server_packet_t:packet recv;";
}
if(iii==1689){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pegasus_http_server_packets";
	add0="corenet_send_pegasus_http_server_packets($1)";
	add1="corenet_receive_pegasus_http_server_packets($1)";
	add_number =1;
}
if(iii==1690){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pegasus_http_server_packets";
	add0="corenet_dontaudit_send_pegasus_http_server_packets($1)";
	add1="corenet_dontaudit_receive_pegasus_http_server_packets($1)";
	add_number =1;
}
if(iii==1691){
	add_number=0;
	raw_interface_name="corenet_relabelto_pegasus_http_server_packets";
	add0="allow $1 pegasus_http_server_packet_t:packet relabelto;";
}
if(iii==1692){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_pegasus_https_port";
	add0="allow $1 pegasus_https_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1693){
	add_number=0;
	raw_interface_name="corenet_udp_send_pegasus_https_port";
	add0="allow $1 pegasus_https_port_t:udp_socket send_msg;";
}
if(iii==1694){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_pegasus_https_port";
	add0="dontaudit $1 pegasus_https_port_t:udp_socket send_msg;";
}
if(iii==1695){
	add_number=0;
	raw_interface_name="corenet_udp_receive_pegasus_https_port";
	add0="allow $1 pegasus_https_port_t:udp_socket recv_msg;";
}
if(iii==1696){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_pegasus_https_port";
	add0="dontaudit $1 pegasus_https_port_t:udp_socket recv_msg;";
}
if(iii==1697){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_pegasus_https_port";
	add0="corenet_udp_send_pegasus_https_port($1)";
	add1="corenet_udp_receive_pegasus_https_port($1)";
	add_number =1;
}
if(iii==1698){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_pegasus_https_port";
	add0="corenet_dontaudit_udp_send_pegasus_https_port($1)";
	add1="corenet_dontaudit_udp_receive_pegasus_https_port($1)";
	add_number =1;
}
if(iii==1699){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_pegasus_https_port";
	add0="allow $1 pegasus_https_port_t:tcp_socket name_bind;";
}
if(iii==1700){
	add_number=0;
	raw_interface_name="corenet_udp_bind_pegasus_https_port";
	add0="allow $1 pegasus_https_port_t:udp_socket name_bind;";
}
if(iii==1701){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_pegasus_https_port";
	add0="allow $1 pegasus_https_port_t:tcp_socket name_connect;";
}
if(iii==1702){
	add_number=0;
	raw_interface_name="corenet_send_pegasus_https_client_packets";
	add0="allow $1 pegasus_https_client_packet_t:packet send;";
}
if(iii==1703){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pegasus_https_client_packets";
	add0="dontaudit $1 pegasus_https_client_packet_t:packet send;";
}
if(iii==1704){
	add_number=0;
	raw_interface_name="corenet_receive_pegasus_https_client_packets";
	add0="allow $1 pegasus_https_client_packet_t:packet recv;";
}
if(iii==1705){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pegasus_https_client_packets";
	add0="dontaudit $1 pegasus_https_client_packet_t:packet recv;";
}
if(iii==1706){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pegasus_https_client_packets";
	add0="corenet_send_pegasus_https_client_packets($1)";
	add1="corenet_receive_pegasus_https_client_packets($1)";
	add_number =1;
}
if(iii==1707){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pegasus_https_client_packets";
	add0="corenet_dontaudit_send_pegasus_https_client_packets($1)";
	add1="corenet_dontaudit_receive_pegasus_https_client_packets($1)";
	add_number =1;
}
if(iii==1708){
	add_number=0;
	raw_interface_name="corenet_relabelto_pegasus_https_client_packets";
	add0="allow $1 pegasus_https_client_packet_t:packet relabelto;";
}
if(iii==1709){
	add_number=0;
	raw_interface_name="corenet_send_pegasus_https_server_packets";
	add0="allow $1 pegasus_https_server_packet_t:packet send;";
}
if(iii==1710){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pegasus_https_server_packets";
	add0="dontaudit $1 pegasus_https_server_packet_t:packet send;";
}
if(iii==1711){
	add_number=0;
	raw_interface_name="corenet_receive_pegasus_https_server_packets";
	add0="allow $1 pegasus_https_server_packet_t:packet recv;";
}
if(iii==1712){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pegasus_https_server_packets";
	add0="dontaudit $1 pegasus_https_server_packet_t:packet recv;";
}
if(iii==1713){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pegasus_https_server_packets";
	add0="corenet_send_pegasus_https_server_packets($1)";
	add1="corenet_receive_pegasus_https_server_packets($1)";
	add_number =1;
}
if(iii==1714){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pegasus_https_server_packets";
	add0="corenet_dontaudit_send_pegasus_https_server_packets($1)";
	add1="corenet_dontaudit_receive_pegasus_https_server_packets($1)";
	add_number =1;
}
if(iii==1715){
	add_number=0;
	raw_interface_name="corenet_relabelto_pegasus_https_server_packets";
	add0="allow $1 pegasus_https_server_packet_t:packet relabelto;";
}
if(iii==1716){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_pop_port";
	add0="allow $1 pop_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1717){
	add_number=0;
	raw_interface_name="corenet_udp_send_pop_port";
	add0="allow $1 pop_port_t:udp_socket send_msg;";
}
if(iii==1718){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_pop_port";
	add0="dontaudit $1 pop_port_t:udp_socket send_msg;";
}
if(iii==1719){
	add_number=0;
	raw_interface_name="corenet_udp_receive_pop_port";
	add0="allow $1 pop_port_t:udp_socket recv_msg;";
}
if(iii==1720){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_pop_port";
	add0="dontaudit $1 pop_port_t:udp_socket recv_msg;";
}
if(iii==1721){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_pop_port";
	add0="corenet_udp_send_pop_port($1)";
	add1="corenet_udp_receive_pop_port($1)";
	add_number =1;
}
if(iii==1722){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_pop_port";
	add0="corenet_dontaudit_udp_send_pop_port($1)";
	add1="corenet_dontaudit_udp_receive_pop_port($1)";
	add_number =1;
}
if(iii==1723){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_pop_port";
	add0="allow $1 pop_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1724){
	add_number=0;
	raw_interface_name="corenet_udp_bind_pop_port";
	add0="allow $1 pop_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1725){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_pop_port";
	add0="allow $1 pop_port_t:tcp_socket name_connect;";
}
if(iii==1726){
	add_number=0;
	raw_interface_name="corenet_send_pop_client_packets";
	add0="allow $1 pop_client_packet_t:packet send;";
}
if(iii==1727){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pop_client_packets";
	add0="dontaudit $1 pop_client_packet_t:packet send;";
}
if(iii==1728){
	add_number=0;
	raw_interface_name="corenet_receive_pop_client_packets";
	add0="allow $1 pop_client_packet_t:packet recv;";
}
if(iii==1729){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pop_client_packets";
	add0="dontaudit $1 pop_client_packet_t:packet recv;";
}
if(iii==1730){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pop_client_packets";
	add0="corenet_send_pop_client_packets($1)";
	add1="corenet_receive_pop_client_packets($1)";
	add_number =1;
}
if(iii==1731){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pop_client_packets";
	add0="corenet_dontaudit_send_pop_client_packets($1)";
	add1="corenet_dontaudit_receive_pop_client_packets($1)";
	add_number =1;
}
if(iii==1732){
	add_number=0;
	raw_interface_name="corenet_relabelto_pop_client_packets";
	add0="allow $1 pop_client_packet_t:packet relabelto;";
}
if(iii==1733){
	add_number=0;
	raw_interface_name="corenet_send_pop_server_packets";
	add0="allow $1 pop_server_packet_t:packet send;";
}
if(iii==1734){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pop_server_packets";
	add0="dontaudit $1 pop_server_packet_t:packet send;";
}
if(iii==1735){
	add_number=0;
	raw_interface_name="corenet_receive_pop_server_packets";
	add0="allow $1 pop_server_packet_t:packet recv;";
}
if(iii==1736){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pop_server_packets";
	add0="dontaudit $1 pop_server_packet_t:packet recv;";
}
if(iii==1737){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pop_server_packets";
	add0="corenet_send_pop_server_packets($1)";
	add1="corenet_receive_pop_server_packets($1)";
	add_number =1;
}
if(iii==1738){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pop_server_packets";
	add0="corenet_dontaudit_send_pop_server_packets($1)";
	add1="corenet_dontaudit_receive_pop_server_packets($1)";
	add_number =1;
}
if(iii==1739){
	add_number=0;
	raw_interface_name="corenet_relabelto_pop_server_packets";
	add0="allow $1 pop_server_packet_t:packet relabelto;";
}
if(iii==1740){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_portmap_port";
	add0="allow $1 portmap_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1741){
	add_number=0;
	raw_interface_name="corenet_udp_send_portmap_port";
	add0="allow $1 portmap_port_t:udp_socket send_msg;";
}
if(iii==1742){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_portmap_port";
	add0="dontaudit $1 portmap_port_t:udp_socket send_msg;";
}
if(iii==1743){
	add_number=0;
	raw_interface_name="corenet_udp_receive_portmap_port";
	add0="allow $1 portmap_port_t:udp_socket recv_msg;";
}
if(iii==1744){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_portmap_port";
	add0="dontaudit $1 portmap_port_t:udp_socket recv_msg;";
}
if(iii==1745){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_portmap_port";
	add0="corenet_udp_send_portmap_port($1)";
	add1="corenet_udp_receive_portmap_port($1)";
	add_number =1;
}
if(iii==1746){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_portmap_port";
	add0="corenet_dontaudit_udp_send_portmap_port($1)";
	add1="corenet_dontaudit_udp_receive_portmap_port($1)";
	add_number =1;
}
if(iii==1747){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_portmap_port";
	add0="allow $1 portmap_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1748){
	add_number=0;
	raw_interface_name="corenet_udp_bind_portmap_port";
	add0="allow $1 portmap_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1749){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_portmap_port";
	add0="allow $1 portmap_port_t:tcp_socket name_connect;";
}
if(iii==1750){
	add_number=0;
	raw_interface_name="corenet_send_portmap_client_packets";
	add0="allow $1 portmap_client_packet_t:packet send;";
}
if(iii==1751){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_portmap_client_packets";
	add0="dontaudit $1 portmap_client_packet_t:packet send;";
}
if(iii==1752){
	add_number=0;
	raw_interface_name="corenet_receive_portmap_client_packets";
	add0="allow $1 portmap_client_packet_t:packet recv;";
}
if(iii==1753){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_portmap_client_packets";
	add0="dontaudit $1 portmap_client_packet_t:packet recv;";
}
if(iii==1754){
	add_number=0;
	raw_interface_name="corenet_sendrecv_portmap_client_packets";
	add0="corenet_send_portmap_client_packets($1)";
	add1="corenet_receive_portmap_client_packets($1)";
	add_number =1;
}
if(iii==1755){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_portmap_client_packets";
	add0="corenet_dontaudit_send_portmap_client_packets($1)";
	add1="corenet_dontaudit_receive_portmap_client_packets($1)";
	add_number =1;
}
if(iii==1756){
	add_number=0;
	raw_interface_name="corenet_relabelto_portmap_client_packets";
	add0="allow $1 portmap_client_packet_t:packet relabelto;";
}
if(iii==1757){
	add_number=0;
	raw_interface_name="corenet_send_portmap_server_packets";
	add0="allow $1 portmap_server_packet_t:packet send;";
}
if(iii==1758){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_portmap_server_packets";
	add0="dontaudit $1 portmap_server_packet_t:packet send;";
}
if(iii==1759){
	add_number=0;
	raw_interface_name="corenet_receive_portmap_server_packets";
	add0="allow $1 portmap_server_packet_t:packet recv;";
}
if(iii==1760){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_portmap_server_packets";
	add0="dontaudit $1 portmap_server_packet_t:packet recv;";
}
if(iii==1761){
	add_number=0;
	raw_interface_name="corenet_sendrecv_portmap_server_packets";
	add0="corenet_send_portmap_server_packets($1)";
	add1="corenet_receive_portmap_server_packets($1)";
	add_number =1;
}
if(iii==1762){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_portmap_server_packets";
	add0="corenet_dontaudit_send_portmap_server_packets($1)";
	add1="corenet_dontaudit_receive_portmap_server_packets($1)";
	add_number =1;
}
if(iii==1763){
	add_number=0;
	raw_interface_name="corenet_relabelto_portmap_server_packets";
	add0="allow $1 portmap_server_packet_t:packet relabelto;";
}
if(iii==1764){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_postgresql_port";
	add0="allow $1 postgresql_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1765){
	add_number=0;
	raw_interface_name="corenet_udp_send_postgresql_port";
	add0="allow $1 postgresql_port_t:udp_socket send_msg;";
}
if(iii==1766){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_postgresql_port";
	add0="dontaudit $1 postgresql_port_t:udp_socket send_msg;";
}
if(iii==1767){
	add_number=0;
	raw_interface_name="corenet_udp_receive_postgresql_port";
	add0="allow $1 postgresql_port_t:udp_socket recv_msg;";
}
if(iii==1768){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_postgresql_port";
	add0="dontaudit $1 postgresql_port_t:udp_socket recv_msg;";
}
if(iii==1769){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_postgresql_port";
	add0="corenet_udp_send_postgresql_port($1)";
	add1="corenet_udp_receive_postgresql_port($1)";
	add_number =1;
}
if(iii==1770){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_postgresql_port";
	add0="corenet_dontaudit_udp_send_postgresql_port($1)";
	add1="corenet_dontaudit_udp_receive_postgresql_port($1)";
	add_number =1;
}
if(iii==1771){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_postgresql_port";
	add0="allow $1 postgresql_port_t:tcp_socket name_bind;";
}
if(iii==1772){
	add_number=0;
	raw_interface_name="corenet_udp_bind_postgresql_port";
	add0="allow $1 postgresql_port_t:udp_socket name_bind;";
}
if(iii==1773){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_postgresql_port";
	add0="allow $1 postgresql_port_t:tcp_socket name_connect;";
}
if(iii==1774){
	add_number=0;
	raw_interface_name="corenet_send_postgresql_client_packets";
	add0="allow $1 postgresql_client_packet_t:packet send;";
}
if(iii==1775){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_postgresql_client_packets";
	add0="dontaudit $1 postgresql_client_packet_t:packet send;";
}
if(iii==1776){
	add_number=0;
	raw_interface_name="corenet_receive_postgresql_client_packets";
	add0="allow $1 postgresql_client_packet_t:packet recv;";
}
if(iii==1777){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_postgresql_client_packets";
	add0="dontaudit $1 postgresql_client_packet_t:packet recv;";
}
if(iii==1778){
	add_number=0;
	raw_interface_name="corenet_sendrecv_postgresql_client_packets";
	add0="corenet_send_postgresql_client_packets($1)";
	add1="corenet_receive_postgresql_client_packets($1)";
	add_number =1;
}
if(iii==1779){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_postgresql_client_packets";
	add0="corenet_dontaudit_send_postgresql_client_packets($1)";
	add1="corenet_dontaudit_receive_postgresql_client_packets($1)";
	add_number =1;
}
if(iii==1780){
	add_number=0;
	raw_interface_name="corenet_relabelto_postgresql_client_packets";
	add0="allow $1 postgresql_client_packet_t:packet relabelto;";
}
if(iii==1781){
	add_number=0;
	raw_interface_name="corenet_send_postgresql_server_packets";
	add0="allow $1 postgresql_server_packet_t:packet send;";
}
if(iii==1782){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_postgresql_server_packets";
	add0="dontaudit $1 postgresql_server_packet_t:packet send;";
}
if(iii==1783){
	add_number=0;
	raw_interface_name="corenet_receive_postgresql_server_packets";
	add0="allow $1 postgresql_server_packet_t:packet recv;";
}
if(iii==1784){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_postgresql_server_packets";
	add0="dontaudit $1 postgresql_server_packet_t:packet recv;";
}
if(iii==1785){
	add_number=0;
	raw_interface_name="corenet_sendrecv_postgresql_server_packets";
	add0="corenet_send_postgresql_server_packets($1)";
	add1="corenet_receive_postgresql_server_packets($1)";
	add_number =1;
}
if(iii==1786){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_postgresql_server_packets";
	add0="corenet_dontaudit_send_postgresql_server_packets($1)";
	add1="corenet_dontaudit_receive_postgresql_server_packets($1)";
	add_number =1;
}
if(iii==1787){
	add_number=0;
	raw_interface_name="corenet_relabelto_postgresql_server_packets";
	add0="allow $1 postgresql_server_packet_t:packet relabelto;";
}
if(iii==1788){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_postgrey_port";
	add0="allow $1 postgrey_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1789){
	add_number=0;
	raw_interface_name="corenet_udp_send_postgrey_port";
	add0="allow $1 postgrey_port_t:udp_socket send_msg;";
}
if(iii==1790){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_postgrey_port";
	add0="dontaudit $1 postgrey_port_t:udp_socket send_msg;";
}
if(iii==1791){
	add_number=0;
	raw_interface_name="corenet_udp_receive_postgrey_port";
	add0="allow $1 postgrey_port_t:udp_socket recv_msg;";
}
if(iii==1792){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_postgrey_port";
	add0="dontaudit $1 postgrey_port_t:udp_socket recv_msg;";
}
if(iii==1793){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_postgrey_port";
	add0="corenet_udp_send_postgrey_port($1)";
	add1="corenet_udp_receive_postgrey_port($1)";
	add_number =1;
}
if(iii==1794){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_postgrey_port";
	add0="corenet_dontaudit_udp_send_postgrey_port($1)";
	add1="corenet_dontaudit_udp_receive_postgrey_port($1)";
	add_number =1;
}
if(iii==1795){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_postgrey_port";
	add0="allow $1 postgrey_port_t:tcp_socket name_bind;";
}
if(iii==1796){
	add_number=0;
	raw_interface_name="corenet_udp_bind_postgrey_port";
	add0="allow $1 postgrey_port_t:udp_socket name_bind;";
}
if(iii==1797){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_postgrey_port";
	add0="allow $1 postgrey_port_t:tcp_socket name_connect;";
}
if(iii==1798){
	add_number=0;
	raw_interface_name="corenet_send_postgrey_client_packets";
	add0="allow $1 postgrey_client_packet_t:packet send;";
}
if(iii==1799){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_postgrey_client_packets";
	add0="dontaudit $1 postgrey_client_packet_t:packet send;";
}
if(iii==1800){
	add_number=0;
	raw_interface_name="corenet_receive_postgrey_client_packets";
	add0="allow $1 postgrey_client_packet_t:packet recv;";
}
if(iii==1801){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_postgrey_client_packets";
	add0="dontaudit $1 postgrey_client_packet_t:packet recv;";
}
if(iii==1802){
	add_number=0;
	raw_interface_name="corenet_sendrecv_postgrey_client_packets";
	add0="corenet_send_postgrey_client_packets($1)";
	add1="corenet_receive_postgrey_client_packets($1)";
	add_number =1;
}
if(iii==1803){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_postgrey_client_packets";
	add0="corenet_dontaudit_send_postgrey_client_packets($1)";
	add1="corenet_dontaudit_receive_postgrey_client_packets($1)";
	add_number =1;
}
if(iii==1804){
	add_number=0;
	raw_interface_name="corenet_relabelto_postgrey_client_packets";
	add0="allow $1 postgrey_client_packet_t:packet relabelto;";
}
if(iii==1805){
	add_number=0;
	raw_interface_name="corenet_send_postgrey_server_packets";
	add0="allow $1 postgrey_server_packet_t:packet send;";
}
if(iii==1806){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_postgrey_server_packets";
	add0="dontaudit $1 postgrey_server_packet_t:packet send;";
}
if(iii==1807){
	add_number=0;
	raw_interface_name="corenet_receive_postgrey_server_packets";
	add0="allow $1 postgrey_server_packet_t:packet recv;";
}
if(iii==1808){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_postgrey_server_packets";
	add0="dontaudit $1 postgrey_server_packet_t:packet recv;";
}
if(iii==1809){
	add_number=0;
	raw_interface_name="corenet_sendrecv_postgrey_server_packets";
	add0="corenet_send_postgrey_server_packets($1)";
	add1="corenet_receive_postgrey_server_packets($1)";
	add_number =1;
}
if(iii==1810){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_postgrey_server_packets";
	add0="corenet_dontaudit_send_postgrey_server_packets($1)";
	add1="corenet_dontaudit_receive_postgrey_server_packets($1)";
	add_number =1;
}
if(iii==1811){
	add_number=0;
	raw_interface_name="corenet_relabelto_postgrey_server_packets";
	add0="allow $1 postgrey_server_packet_t:packet relabelto;";
}
if(iii==1812){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_printer_port";
	add0="allow $1 printer_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1813){
	add_number=0;
	raw_interface_name="corenet_udp_send_printer_port";
	add0="allow $1 printer_port_t:udp_socket send_msg;";
}
if(iii==1814){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_printer_port";
	add0="dontaudit $1 printer_port_t:udp_socket send_msg;";
}
if(iii==1815){
	add_number=0;
	raw_interface_name="corenet_udp_receive_printer_port";
	add0="allow $1 printer_port_t:udp_socket recv_msg;";
}
if(iii==1816){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_printer_port";
	add0="dontaudit $1 printer_port_t:udp_socket recv_msg;";
}
if(iii==1817){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_printer_port";
	add0="corenet_udp_send_printer_port($1)";
	add1="corenet_udp_receive_printer_port($1)";
	add_number =1;
}
if(iii==1818){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_printer_port";
	add0="corenet_dontaudit_udp_send_printer_port($1)";
	add1="corenet_dontaudit_udp_receive_printer_port($1)";
	add_number =1;
}
if(iii==1819){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_printer_port";
	add0="allow $1 printer_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1820){
	add_number=0;
	raw_interface_name="corenet_udp_bind_printer_port";
	add0="allow $1 printer_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==1821){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_printer_port";
	add0="allow $1 printer_port_t:tcp_socket name_connect;";
}
if(iii==1822){
	add_number=0;
	raw_interface_name="corenet_send_printer_client_packets";
	add0="allow $1 printer_client_packet_t:packet send;";
}
if(iii==1823){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_printer_client_packets";
	add0="dontaudit $1 printer_client_packet_t:packet send;";
}
if(iii==1824){
	add_number=0;
	raw_interface_name="corenet_receive_printer_client_packets";
	add0="allow $1 printer_client_packet_t:packet recv;";
}
if(iii==1825){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_printer_client_packets";
	add0="dontaudit $1 printer_client_packet_t:packet recv;";
}
if(iii==1826){
	add_number=0;
	raw_interface_name="corenet_sendrecv_printer_client_packets";
	add0="corenet_send_printer_client_packets($1)";
	add1="corenet_receive_printer_client_packets($1)";
	add_number =1;
}
if(iii==1827){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_printer_client_packets";
	add0="corenet_dontaudit_send_printer_client_packets($1)";
	add1="corenet_dontaudit_receive_printer_client_packets($1)";
	add_number =1;
}
if(iii==1828){
	add_number=0;
	raw_interface_name="corenet_relabelto_printer_client_packets";
	add0="allow $1 printer_client_packet_t:packet relabelto;";
}
if(iii==1829){
	add_number=0;
	raw_interface_name="corenet_send_printer_server_packets";
	add0="allow $1 printer_server_packet_t:packet send;";
}
if(iii==1830){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_printer_server_packets";
	add0="dontaudit $1 printer_server_packet_t:packet send;";
}
if(iii==1831){
	add_number=0;
	raw_interface_name="corenet_receive_printer_server_packets";
	add0="allow $1 printer_server_packet_t:packet recv;";
}
if(iii==1832){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_printer_server_packets";
	add0="dontaudit $1 printer_server_packet_t:packet recv;";
}
if(iii==1833){
	add_number=0;
	raw_interface_name="corenet_sendrecv_printer_server_packets";
	add0="corenet_send_printer_server_packets($1)";
	add1="corenet_receive_printer_server_packets($1)";
	add_number =1;
}
if(iii==1834){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_printer_server_packets";
	add0="corenet_dontaudit_send_printer_server_packets($1)";
	add1="corenet_dontaudit_receive_printer_server_packets($1)";
	add_number =1;
}
if(iii==1835){
	add_number=0;
	raw_interface_name="corenet_relabelto_printer_server_packets";
	add0="allow $1 printer_server_packet_t:packet relabelto;";
}
if(iii==1836){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ptal_port";
	add0="allow $1 ptal_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1837){
	add_number=0;
	raw_interface_name="corenet_udp_send_ptal_port";
	add0="allow $1 ptal_port_t:udp_socket send_msg;";
}
if(iii==1838){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ptal_port";
	add0="dontaudit $1 ptal_port_t:udp_socket send_msg;";
}
if(iii==1839){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ptal_port";
	add0="allow $1 ptal_port_t:udp_socket recv_msg;";
}
if(iii==1840){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ptal_port";
	add0="dontaudit $1 ptal_port_t:udp_socket recv_msg;";
}
if(iii==1841){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ptal_port";
	add0="corenet_udp_send_ptal_port($1)";
	add1="corenet_udp_receive_ptal_port($1)";
	add_number =1;
}
if(iii==1842){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ptal_port";
	add0="corenet_dontaudit_udp_send_ptal_port($1)";
	add1="corenet_dontaudit_udp_receive_ptal_port($1)";
	add_number =1;
}
if(iii==1843){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ptal_port";
	add0="allow $1 ptal_port_t:tcp_socket name_bind;";
}
if(iii==1844){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ptal_port";
	add0="allow $1 ptal_port_t:udp_socket name_bind;";
}
if(iii==1845){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ptal_port";
	add0="allow $1 ptal_port_t:tcp_socket name_connect;";
}
if(iii==1846){
	add_number=0;
	raw_interface_name="corenet_send_ptal_client_packets";
	add0="allow $1 ptal_client_packet_t:packet send;";
}
if(iii==1847){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ptal_client_packets";
	add0="dontaudit $1 ptal_client_packet_t:packet send;";
}
if(iii==1848){
	add_number=0;
	raw_interface_name="corenet_receive_ptal_client_packets";
	add0="allow $1 ptal_client_packet_t:packet recv;";
}
if(iii==1849){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ptal_client_packets";
	add0="dontaudit $1 ptal_client_packet_t:packet recv;";
}
if(iii==1850){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ptal_client_packets";
	add0="corenet_send_ptal_client_packets($1)";
	add1="corenet_receive_ptal_client_packets($1)";
	add_number =1;
}
if(iii==1851){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ptal_client_packets";
	add0="corenet_dontaudit_send_ptal_client_packets($1)";
	add1="corenet_dontaudit_receive_ptal_client_packets($1)";
	add_number =1;
}
if(iii==1852){
	add_number=0;
	raw_interface_name="corenet_relabelto_ptal_client_packets";
	add0="allow $1 ptal_client_packet_t:packet relabelto;";
}
if(iii==1853){
	add_number=0;
	raw_interface_name="corenet_send_ptal_server_packets";
	add0="allow $1 ptal_server_packet_t:packet send;";
}
if(iii==1854){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ptal_server_packets";
	add0="dontaudit $1 ptal_server_packet_t:packet send;";
}
if(iii==1855){
	add_number=0;
	raw_interface_name="corenet_receive_ptal_server_packets";
	add0="allow $1 ptal_server_packet_t:packet recv;";
}
if(iii==1856){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ptal_server_packets";
	add0="dontaudit $1 ptal_server_packet_t:packet recv;";
}
if(iii==1857){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ptal_server_packets";
	add0="corenet_send_ptal_server_packets($1)";
	add1="corenet_receive_ptal_server_packets($1)";
	add_number =1;
}
if(iii==1858){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ptal_server_packets";
	add0="corenet_dontaudit_send_ptal_server_packets($1)";
	add1="corenet_dontaudit_receive_ptal_server_packets($1)";
	add_number =1;
}
if(iii==1859){
	add_number=0;
	raw_interface_name="corenet_relabelto_ptal_server_packets";
	add0="allow $1 ptal_server_packet_t:packet relabelto;";
}
if(iii==1860){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_pxe_port";
	add0="allow $1 pxe_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1861){
	add_number=0;
	raw_interface_name="corenet_udp_send_pxe_port";
	add0="allow $1 pxe_port_t:udp_socket send_msg;";
}
if(iii==1862){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_pxe_port";
	add0="dontaudit $1 pxe_port_t:udp_socket send_msg;";
}
if(iii==1863){
	add_number=0;
	raw_interface_name="corenet_udp_receive_pxe_port";
	add0="allow $1 pxe_port_t:udp_socket recv_msg;";
}
if(iii==1864){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_pxe_port";
	add0="dontaudit $1 pxe_port_t:udp_socket recv_msg;";
}
if(iii==1865){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_pxe_port";
	add0="corenet_udp_send_pxe_port($1)";
	add1="corenet_udp_receive_pxe_port($1)";
	add_number =1;
}
if(iii==1866){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_pxe_port";
	add0="corenet_dontaudit_udp_send_pxe_port($1)";
	add1="corenet_dontaudit_udp_receive_pxe_port($1)";
	add_number =1;
}
if(iii==1867){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_pxe_port";
	add0="allow $1 pxe_port_t:tcp_socket name_bind;";
}
if(iii==1868){
	add_number=0;
	raw_interface_name="corenet_udp_bind_pxe_port";
	add0="allow $1 pxe_port_t:udp_socket name_bind;";
}
if(iii==1869){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_pxe_port";
	add0="allow $1 pxe_port_t:tcp_socket name_connect;";
}
if(iii==1870){
	add_number=0;
	raw_interface_name="corenet_send_pxe_client_packets";
	add0="allow $1 pxe_client_packet_t:packet send;";
}
if(iii==1871){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pxe_client_packets";
	add0="dontaudit $1 pxe_client_packet_t:packet send;";
}
if(iii==1872){
	add_number=0;
	raw_interface_name="corenet_receive_pxe_client_packets";
	add0="allow $1 pxe_client_packet_t:packet recv;";
}
if(iii==1873){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pxe_client_packets";
	add0="dontaudit $1 pxe_client_packet_t:packet recv;";
}
if(iii==1874){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pxe_client_packets";
	add0="corenet_send_pxe_client_packets($1)";
	add1="corenet_receive_pxe_client_packets($1)";
	add_number =1;
}
if(iii==1875){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pxe_client_packets";
	add0="corenet_dontaudit_send_pxe_client_packets($1)";
	add1="corenet_dontaudit_receive_pxe_client_packets($1)";
	add_number =1;
}
if(iii==1876){
	add_number=0;
	raw_interface_name="corenet_relabelto_pxe_client_packets";
	add0="allow $1 pxe_client_packet_t:packet relabelto;";
}
if(iii==1877){
	add_number=0;
	raw_interface_name="corenet_send_pxe_server_packets";
	add0="allow $1 pxe_server_packet_t:packet send;";
}
if(iii==1878){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pxe_server_packets";
	add0="dontaudit $1 pxe_server_packet_t:packet send;";
}
if(iii==1879){
	add_number=0;
	raw_interface_name="corenet_receive_pxe_server_packets";
	add0="allow $1 pxe_server_packet_t:packet recv;";
}
if(iii==1880){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pxe_server_packets";
	add0="dontaudit $1 pxe_server_packet_t:packet recv;";
}
if(iii==1881){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pxe_server_packets";
	add0="corenet_send_pxe_server_packets($1)";
	add1="corenet_receive_pxe_server_packets($1)";
	add_number =1;
}
if(iii==1882){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pxe_server_packets";
	add0="corenet_dontaudit_send_pxe_server_packets($1)";
	add1="corenet_dontaudit_receive_pxe_server_packets($1)";
	add_number =1;
}
if(iii==1883){
	add_number=0;
	raw_interface_name="corenet_relabelto_pxe_server_packets";
	add0="allow $1 pxe_server_packet_t:packet relabelto;";
}
if(iii==1884){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_pyzor_port";
	add0="allow $1 pyzor_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1885){
	add_number=0;
	raw_interface_name="corenet_udp_send_pyzor_port";
	add0="allow $1 pyzor_port_t:udp_socket send_msg;";
}
if(iii==1886){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_pyzor_port";
	add0="dontaudit $1 pyzor_port_t:udp_socket send_msg;";
}
if(iii==1887){
	add_number=0;
	raw_interface_name="corenet_udp_receive_pyzor_port";
	add0="allow $1 pyzor_port_t:udp_socket recv_msg;";
}
if(iii==1888){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_pyzor_port";
	add0="dontaudit $1 pyzor_port_t:udp_socket recv_msg;";
}
if(iii==1889){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_pyzor_port";
	add0="corenet_udp_send_pyzor_port($1)";
	add1="corenet_udp_receive_pyzor_port($1)";
	add_number =1;
}
if(iii==1890){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_pyzor_port";
	add0="corenet_dontaudit_udp_send_pyzor_port($1)";
	add1="corenet_dontaudit_udp_receive_pyzor_port($1)";
	add_number =1;
}
if(iii==1891){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_pyzor_port";
	add0="allow $1 pyzor_port_t:tcp_socket name_bind;";
}
if(iii==1892){
	add_number=0;
	raw_interface_name="corenet_udp_bind_pyzor_port";
	add0="allow $1 pyzor_port_t:udp_socket name_bind;";
}
if(iii==1893){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_pyzor_port";
	add0="allow $1 pyzor_port_t:tcp_socket name_connect;";
}
if(iii==1894){
	add_number=0;
	raw_interface_name="corenet_send_pyzor_client_packets";
	add0="allow $1 pyzor_client_packet_t:packet send;";
}
if(iii==1895){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pyzor_client_packets";
	add0="dontaudit $1 pyzor_client_packet_t:packet send;";
}
if(iii==1896){
	add_number=0;
	raw_interface_name="corenet_receive_pyzor_client_packets";
	add0="allow $1 pyzor_client_packet_t:packet recv;";
}
if(iii==1897){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pyzor_client_packets";
	add0="dontaudit $1 pyzor_client_packet_t:packet recv;";
}
if(iii==1898){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pyzor_client_packets";
	add0="corenet_send_pyzor_client_packets($1)";
	add1="corenet_receive_pyzor_client_packets($1)";
	add_number =1;
}
if(iii==1899){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pyzor_client_packets";
	add0="corenet_dontaudit_send_pyzor_client_packets($1)";
	add1="corenet_dontaudit_receive_pyzor_client_packets($1)";
	add_number =1;
}
if(iii==1900){
	add_number=0;
	raw_interface_name="corenet_relabelto_pyzor_client_packets";
	add0="allow $1 pyzor_client_packet_t:packet relabelto;";
}
if(iii==1901){
	add_number=0;
	raw_interface_name="corenet_send_pyzor_server_packets";
	add0="allow $1 pyzor_server_packet_t:packet send;";
}
if(iii==1902){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_pyzor_server_packets";
	add0="dontaudit $1 pyzor_server_packet_t:packet send;";
}
if(iii==1903){
	add_number=0;
	raw_interface_name="corenet_receive_pyzor_server_packets";
	add0="allow $1 pyzor_server_packet_t:packet recv;";
}
if(iii==1904){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_pyzor_server_packets";
	add0="dontaudit $1 pyzor_server_packet_t:packet recv;";
}
if(iii==1905){
	add_number=0;
	raw_interface_name="corenet_sendrecv_pyzor_server_packets";
	add0="corenet_send_pyzor_server_packets($1)";
	add1="corenet_receive_pyzor_server_packets($1)";
	add_number =1;
}
if(iii==1906){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_pyzor_server_packets";
	add0="corenet_dontaudit_send_pyzor_server_packets($1)";
	add1="corenet_dontaudit_receive_pyzor_server_packets($1)";
	add_number =1;
}
if(iii==1907){
	add_number=0;
	raw_interface_name="corenet_relabelto_pyzor_server_packets";
	add0="allow $1 pyzor_server_packet_t:packet relabelto;";
}
if(iii==1908){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_radacct_port";
	add0="allow $1 radacct_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1909){
	add_number=0;
	raw_interface_name="corenet_udp_send_radacct_port";
	add0="allow $1 radacct_port_t:udp_socket send_msg;";
}
if(iii==1910){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_radacct_port";
	add0="dontaudit $1 radacct_port_t:udp_socket send_msg;";
}
if(iii==1911){
	add_number=0;
	raw_interface_name="corenet_udp_receive_radacct_port";
	add0="allow $1 radacct_port_t:udp_socket recv_msg;";
}
if(iii==1912){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_radacct_port";
	add0="dontaudit $1 radacct_port_t:udp_socket recv_msg;";
}
if(iii==1913){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_radacct_port";
	add0="corenet_udp_send_radacct_port($1)";
	add1="corenet_udp_receive_radacct_port($1)";
	add_number =1;
}
if(iii==1914){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_radacct_port";
	add0="corenet_dontaudit_udp_send_radacct_port($1)";
	add1="corenet_dontaudit_udp_receive_radacct_port($1)";
	add_number =1;
}
if(iii==1915){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_radacct_port";
	add0="allow $1 radacct_port_t:tcp_socket name_bind;";
}
if(iii==1916){
	add_number=0;
	raw_interface_name="corenet_udp_bind_radacct_port";
	add0="allow $1 radacct_port_t:udp_socket name_bind;";
}
if(iii==1917){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_radacct_port";
	add0="allow $1 radacct_port_t:tcp_socket name_connect;";
}
if(iii==1918){
	add_number=0;
	raw_interface_name="corenet_send_radacct_client_packets";
	add0="allow $1 radacct_client_packet_t:packet send;";
}
if(iii==1919){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_radacct_client_packets";
	add0="dontaudit $1 radacct_client_packet_t:packet send;";
}
if(iii==1920){
	add_number=0;
	raw_interface_name="corenet_receive_radacct_client_packets";
	add0="allow $1 radacct_client_packet_t:packet recv;";
}
if(iii==1921){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_radacct_client_packets";
	add0="dontaudit $1 radacct_client_packet_t:packet recv;";
}
if(iii==1922){
	add_number=0;
	raw_interface_name="corenet_sendrecv_radacct_client_packets";
	add0="corenet_send_radacct_client_packets($1)";
	add1="corenet_receive_radacct_client_packets($1)";
	add_number =1;
}
if(iii==1923){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_radacct_client_packets";
	add0="corenet_dontaudit_send_radacct_client_packets($1)";
	add1="corenet_dontaudit_receive_radacct_client_packets($1)";
	add_number =1;
}
if(iii==1924){
	add_number=0;
	raw_interface_name="corenet_relabelto_radacct_client_packets";
	add0="allow $1 radacct_client_packet_t:packet relabelto;";
}
if(iii==1925){
	add_number=0;
	raw_interface_name="corenet_send_radacct_server_packets";
	add0="allow $1 radacct_server_packet_t:packet send;";
}
if(iii==1926){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_radacct_server_packets";
	add0="dontaudit $1 radacct_server_packet_t:packet send;";
}
if(iii==1927){
	add_number=0;
	raw_interface_name="corenet_receive_radacct_server_packets";
	add0="allow $1 radacct_server_packet_t:packet recv;";
}
if(iii==1928){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_radacct_server_packets";
	add0="dontaudit $1 radacct_server_packet_t:packet recv;";
}
if(iii==1929){
	add_number=0;
	raw_interface_name="corenet_sendrecv_radacct_server_packets";
	add0="corenet_send_radacct_server_packets($1)";
	add1="corenet_receive_radacct_server_packets($1)";
	add_number =1;
}
if(iii==1930){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_radacct_server_packets";
	add0="corenet_dontaudit_send_radacct_server_packets($1)";
	add1="corenet_dontaudit_receive_radacct_server_packets($1)";
	add_number =1;
}
if(iii==1931){
	add_number=0;
	raw_interface_name="corenet_relabelto_radacct_server_packets";
	add0="allow $1 radacct_server_packet_t:packet relabelto;";
}
if(iii==1932){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_radius_port";
	add0="allow $1 radius_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1933){
	add_number=0;
	raw_interface_name="corenet_udp_send_radius_port";
	add0="allow $1 radius_port_t:udp_socket send_msg;";
}
if(iii==1934){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_radius_port";
	add0="dontaudit $1 radius_port_t:udp_socket send_msg;";
}
if(iii==1935){
	add_number=0;
	raw_interface_name="corenet_udp_receive_radius_port";
	add0="allow $1 radius_port_t:udp_socket recv_msg;";
}
if(iii==1936){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_radius_port";
	add0="dontaudit $1 radius_port_t:udp_socket recv_msg;";
}
if(iii==1937){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_radius_port";
	add0="corenet_udp_send_radius_port($1)";
	add1="corenet_udp_receive_radius_port($1)";
	add_number =1;
}
if(iii==1938){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_radius_port";
	add0="corenet_dontaudit_udp_send_radius_port($1)";
	add1="corenet_dontaudit_udp_receive_radius_port($1)";
	add_number =1;
}
if(iii==1939){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_radius_port";
	add0="allow $1 radius_port_t:tcp_socket name_bind;";
}
if(iii==1940){
	add_number=0;
	raw_interface_name="corenet_udp_bind_radius_port";
	add0="allow $1 radius_port_t:udp_socket name_bind;";
}
if(iii==1941){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_radius_port";
	add0="allow $1 radius_port_t:tcp_socket name_connect;";
}
if(iii==1942){
	add_number=0;
	raw_interface_name="corenet_send_radius_client_packets";
	add0="allow $1 radius_client_packet_t:packet send;";
}
if(iii==1943){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_radius_client_packets";
	add0="dontaudit $1 radius_client_packet_t:packet send;";
}
if(iii==1944){
	add_number=0;
	raw_interface_name="corenet_receive_radius_client_packets";
	add0="allow $1 radius_client_packet_t:packet recv;";
}
if(iii==1945){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_radius_client_packets";
	add0="dontaudit $1 radius_client_packet_t:packet recv;";
}
if(iii==1946){
	add_number=0;
	raw_interface_name="corenet_sendrecv_radius_client_packets";
	add0="corenet_send_radius_client_packets($1)";
	add1="corenet_receive_radius_client_packets($1)";
	add_number =1;
}
if(iii==1947){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_radius_client_packets";
	add0="corenet_dontaudit_send_radius_client_packets($1)";
	add1="corenet_dontaudit_receive_radius_client_packets($1)";
	add_number =1;
}
if(iii==1948){
	add_number=0;
	raw_interface_name="corenet_relabelto_radius_client_packets";
	add0="allow $1 radius_client_packet_t:packet relabelto;";
}
if(iii==1949){
	add_number=0;
	raw_interface_name="corenet_send_radius_server_packets";
	add0="allow $1 radius_server_packet_t:packet send;";
}
if(iii==1950){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_radius_server_packets";
	add0="dontaudit $1 radius_server_packet_t:packet send;";
}
if(iii==1951){
	add_number=0;
	raw_interface_name="corenet_receive_radius_server_packets";
	add0="allow $1 radius_server_packet_t:packet recv;";
}
if(iii==1952){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_radius_server_packets";
	add0="dontaudit $1 radius_server_packet_t:packet recv;";
}
if(iii==1953){
	add_number=0;
	raw_interface_name="corenet_sendrecv_radius_server_packets";
	add0="corenet_send_radius_server_packets($1)";
	add1="corenet_receive_radius_server_packets($1)";
	add_number =1;
}
if(iii==1954){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_radius_server_packets";
	add0="corenet_dontaudit_send_radius_server_packets($1)";
	add1="corenet_dontaudit_receive_radius_server_packets($1)";
	add_number =1;
}
if(iii==1955){
	add_number=0;
	raw_interface_name="corenet_relabelto_radius_server_packets";
	add0="allow $1 radius_server_packet_t:packet relabelto;";
}
if(iii==1956){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_razor_port";
	add0="allow $1 razor_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1957){
	add_number=0;
	raw_interface_name="corenet_udp_send_razor_port";
	add0="allow $1 razor_port_t:udp_socket send_msg;";
}
if(iii==1958){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_razor_port";
	add0="dontaudit $1 razor_port_t:udp_socket send_msg;";
}
if(iii==1959){
	add_number=0;
	raw_interface_name="corenet_udp_receive_razor_port";
	add0="allow $1 razor_port_t:udp_socket recv_msg;";
}
if(iii==1960){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_razor_port";
	add0="dontaudit $1 razor_port_t:udp_socket recv_msg;";
}
if(iii==1961){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_razor_port";
	add0="corenet_udp_send_razor_port($1)";
	add1="corenet_udp_receive_razor_port($1)";
	add_number =1;
}
if(iii==1962){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_razor_port";
	add0="corenet_dontaudit_udp_send_razor_port($1)";
	add1="corenet_dontaudit_udp_receive_razor_port($1)";
	add_number =1;
}
if(iii==1963){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_razor_port";
	add0="allow $1 razor_port_t:tcp_socket name_bind;";
}
if(iii==1964){
	add_number=0;
	raw_interface_name="corenet_udp_bind_razor_port";
	add0="allow $1 razor_port_t:udp_socket name_bind;";
}
if(iii==1965){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_razor_port";
	add0="allow $1 razor_port_t:tcp_socket name_connect;";
}
if(iii==1966){
	add_number=0;
	raw_interface_name="corenet_send_razor_client_packets";
	add0="allow $1 razor_client_packet_t:packet send;";
}
if(iii==1967){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_razor_client_packets";
	add0="dontaudit $1 razor_client_packet_t:packet send;";
}
if(iii==1968){
	add_number=0;
	raw_interface_name="corenet_receive_razor_client_packets";
	add0="allow $1 razor_client_packet_t:packet recv;";
}
if(iii==1969){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_razor_client_packets";
	add0="dontaudit $1 razor_client_packet_t:packet recv;";
}
if(iii==1970){
	add_number=0;
	raw_interface_name="corenet_sendrecv_razor_client_packets";
	add0="corenet_send_razor_client_packets($1)";
	add1="corenet_receive_razor_client_packets($1)";
	add_number =1;
}
if(iii==1971){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_razor_client_packets";
	add0="corenet_dontaudit_send_razor_client_packets($1)";
	add1="corenet_dontaudit_receive_razor_client_packets($1)";
	add_number =1;
}
if(iii==1972){
	add_number=0;
	raw_interface_name="corenet_relabelto_razor_client_packets";
	add0="allow $1 razor_client_packet_t:packet relabelto;";
}
if(iii==1973){
	add_number=0;
	raw_interface_name="corenet_send_razor_server_packets";
	add0="allow $1 razor_server_packet_t:packet send;";
}
if(iii==1974){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_razor_server_packets";
	add0="dontaudit $1 razor_server_packet_t:packet send;";
}
if(iii==1975){
	add_number=0;
	raw_interface_name="corenet_receive_razor_server_packets";
	add0="allow $1 razor_server_packet_t:packet recv;";
}
if(iii==1976){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_razor_server_packets";
	add0="dontaudit $1 razor_server_packet_t:packet recv;";
}
if(iii==1977){
	add_number=0;
	raw_interface_name="corenet_sendrecv_razor_server_packets";
	add0="corenet_send_razor_server_packets($1)";
	add1="corenet_receive_razor_server_packets($1)";
	add_number =1;
}
if(iii==1978){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_razor_server_packets";
	add0="corenet_dontaudit_send_razor_server_packets($1)";
	add1="corenet_dontaudit_receive_razor_server_packets($1)";
	add_number =1;
}
if(iii==1979){
	add_number=0;
	raw_interface_name="corenet_relabelto_razor_server_packets";
	add0="allow $1 razor_server_packet_t:packet relabelto;";
}
if(iii==1980){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ricci_port";
	add0="allow $1 ricci_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==1981){
	add_number=0;
	raw_interface_name="corenet_udp_send_ricci_port";
	add0="allow $1 ricci_port_t:udp_socket send_msg;";
}
if(iii==1982){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ricci_port";
	add0="dontaudit $1 ricci_port_t:udp_socket send_msg;";
}
if(iii==1983){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ricci_port";
	add0="allow $1 ricci_port_t:udp_socket recv_msg;";
}
if(iii==1984){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ricci_port";
	add0="dontaudit $1 ricci_port_t:udp_socket recv_msg;";
}
if(iii==1985){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ricci_port";
	add0="corenet_udp_send_ricci_port($1)";
	add1="corenet_udp_receive_ricci_port($1)";
	add_number =1;
}
if(iii==1986){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ricci_port";
	add0="corenet_dontaudit_udp_send_ricci_port($1)";
	add1="corenet_dontaudit_udp_receive_ricci_port($1)";
	add_number =1;
}
if(iii==1987){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ricci_port";
	add0="allow $1 ricci_port_t:tcp_socket name_bind;";
}
if(iii==1988){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ricci_port";
	add0="allow $1 ricci_port_t:udp_socket name_bind;";
}
if(iii==1989){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ricci_port";
	add0="allow $1 ricci_port_t:tcp_socket name_connect;";
}
if(iii==1990){
	add_number=0;
	raw_interface_name="corenet_send_ricci_client_packets";
	add0="allow $1 ricci_client_packet_t:packet send;";
}
if(iii==1991){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ricci_client_packets";
	add0="dontaudit $1 ricci_client_packet_t:packet send;";
}
if(iii==1992){
	add_number=0;
	raw_interface_name="corenet_receive_ricci_client_packets";
	add0="allow $1 ricci_client_packet_t:packet recv;";
}
if(iii==1993){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ricci_client_packets";
	add0="dontaudit $1 ricci_client_packet_t:packet recv;";
}
if(iii==1994){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ricci_client_packets";
	add0="corenet_send_ricci_client_packets($1)";
	add1="corenet_receive_ricci_client_packets($1)";
	add_number =1;
}
if(iii==1995){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ricci_client_packets";
	add0="corenet_dontaudit_send_ricci_client_packets($1)";
	add1="corenet_dontaudit_receive_ricci_client_packets($1)";
	add_number =1;
}
if(iii==1996){
	add_number=0;
	raw_interface_name="corenet_relabelto_ricci_client_packets";
	add0="allow $1 ricci_client_packet_t:packet relabelto;";
}
if(iii==1997){
	add_number=0;
	raw_interface_name="corenet_send_ricci_server_packets";
	add0="allow $1 ricci_server_packet_t:packet send;";
}
if(iii==1998){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ricci_server_packets";
	add0="dontaudit $1 ricci_server_packet_t:packet send;";
}
if(iii==1999){
	add_number=0;
	raw_interface_name="corenet_receive_ricci_server_packets";
	add0="allow $1 ricci_server_packet_t:packet recv;";
}
if(iii==2000){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ricci_server_packets";
	add0="dontaudit $1 ricci_server_packet_t:packet recv;";
}
if(iii==2001){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ricci_server_packets";
	add0="corenet_send_ricci_server_packets($1)";
	add1="corenet_receive_ricci_server_packets($1)";
	add_number =1;
}
if(iii==2002){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ricci_server_packets";
	add0="corenet_dontaudit_send_ricci_server_packets($1)";
	add1="corenet_dontaudit_receive_ricci_server_packets($1)";
	add_number =1;
}
if(iii==2003){
	add_number=0;
	raw_interface_name="corenet_relabelto_ricci_server_packets";
	add0="allow $1 ricci_server_packet_t:packet relabelto;";
}
if(iii==2004){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ricci_modcluster_port";
	add0="allow $1 ricci_modcluster_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2005){
	add_number=0;
	raw_interface_name="corenet_udp_send_ricci_modcluster_port";
	add0="allow $1 ricci_modcluster_port_t:udp_socket send_msg;";
}
if(iii==2006){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ricci_modcluster_port";
	add0="dontaudit $1 ricci_modcluster_port_t:udp_socket send_msg;";
}
if(iii==2007){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ricci_modcluster_port";
	add0="allow $1 ricci_modcluster_port_t:udp_socket recv_msg;";
}
if(iii==2008){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ricci_modcluster_port";
	add0="dontaudit $1 ricci_modcluster_port_t:udp_socket recv_msg;";
}
if(iii==2009){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ricci_modcluster_port";
	add0="corenet_udp_send_ricci_modcluster_port($1)";
	add1="corenet_udp_receive_ricci_modcluster_port($1)";
	add_number =1;
}
if(iii==2010){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ricci_modcluster_port";
	add0="corenet_dontaudit_udp_send_ricci_modcluster_port($1)";
	add1="corenet_dontaudit_udp_receive_ricci_modcluster_port($1)";
	add_number =1;
}
if(iii==2011){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ricci_modcluster_port";
	add0="allow $1 ricci_modcluster_port_t:tcp_socket name_bind;";
}
if(iii==2012){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ricci_modcluster_port";
	add0="allow $1 ricci_modcluster_port_t:udp_socket name_bind;";
}
if(iii==2013){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ricci_modcluster_port";
	add0="allow $1 ricci_modcluster_port_t:tcp_socket name_connect;";
}
if(iii==2014){
	add_number=0;
	raw_interface_name="corenet_send_ricci_modcluster_client_packets";
	add0="allow $1 ricci_modcluster_client_packet_t:packet send;";
}
if(iii==2015){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ricci_modcluster_client_packets";
	add0="dontaudit $1 ricci_modcluster_client_packet_t:packet send;";
}
if(iii==2016){
	add_number=0;
	raw_interface_name="corenet_receive_ricci_modcluster_client_packets";
	add0="allow $1 ricci_modcluster_client_packet_t:packet recv;";
}
if(iii==2017){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ricci_modcluster_client_packets";
	add0="dontaudit $1 ricci_modcluster_client_packet_t:packet recv;";
}
if(iii==2018){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ricci_modcluster_client_packets";
	add0="corenet_send_ricci_modcluster_client_packets($1)";
	add1="corenet_receive_ricci_modcluster_client_packets($1)";
	add_number =1;
}
if(iii==2019){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ricci_modcluster_client_packets";
	add0="corenet_dontaudit_send_ricci_modcluster_client_packets($1)";
	add1="corenet_dontaudit_receive_ricci_modcluster_client_packets($1)";
	add_number =1;
}
if(iii==2020){
	add_number=0;
	raw_interface_name="corenet_relabelto_ricci_modcluster_client_packets";
	add0="allow $1 ricci_modcluster_client_packet_t:packet relabelto;";
}
if(iii==2021){
	add_number=0;
	raw_interface_name="corenet_send_ricci_modcluster_server_packets";
	add0="allow $1 ricci_modcluster_server_packet_t:packet send;";
}
if(iii==2022){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ricci_modcluster_server_packets";
	add0="dontaudit $1 ricci_modcluster_server_packet_t:packet send;";
}
if(iii==2023){
	add_number=0;
	raw_interface_name="corenet_receive_ricci_modcluster_server_packets";
	add0="allow $1 ricci_modcluster_server_packet_t:packet recv;";
}
if(iii==2024){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ricci_modcluster_server_packets";
	add0="dontaudit $1 ricci_modcluster_server_packet_t:packet recv;";
}
if(iii==2025){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ricci_modcluster_server_packets";
	add0="corenet_send_ricci_modcluster_server_packets($1)";
	add1="corenet_receive_ricci_modcluster_server_packets($1)";
	add_number =1;
}
if(iii==2026){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ricci_modcluster_server_packets";
	add0="corenet_dontaudit_send_ricci_modcluster_server_packets($1)";
	add1="corenet_dontaudit_receive_ricci_modcluster_server_packets($1)";
	add_number =1;
}
if(iii==2027){
	add_number=0;
	raw_interface_name="corenet_relabelto_ricci_modcluster_server_packets";
	add0="allow $1 ricci_modcluster_server_packet_t:packet relabelto;";
}
if(iii==2028){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_rlogind_port";
	add0="allow $1 rlogind_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2029){
	add_number=0;
	raw_interface_name="corenet_udp_send_rlogind_port";
	add0="allow $1 rlogind_port_t:udp_socket send_msg;";
}
if(iii==2030){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_rlogind_port";
	add0="dontaudit $1 rlogind_port_t:udp_socket send_msg;";
}
if(iii==2031){
	add_number=0;
	raw_interface_name="corenet_udp_receive_rlogind_port";
	add0="allow $1 rlogind_port_t:udp_socket recv_msg;";
}
if(iii==2032){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_rlogind_port";
	add0="dontaudit $1 rlogind_port_t:udp_socket recv_msg;";
}
if(iii==2033){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_rlogind_port";
	add0="corenet_udp_send_rlogind_port($1)";
	add1="corenet_udp_receive_rlogind_port($1)";
	add_number =1;
}
if(iii==2034){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_rlogind_port";
	add0="corenet_dontaudit_udp_send_rlogind_port($1)";
	add1="corenet_dontaudit_udp_receive_rlogind_port($1)";
	add_number =1;
}
if(iii==2035){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_rlogind_port";
	add0="allow $1 rlogind_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2036){
	add_number=0;
	raw_interface_name="corenet_udp_bind_rlogind_port";
	add0="allow $1 rlogind_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2037){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_rlogind_port";
	add0="allow $1 rlogind_port_t:tcp_socket name_connect;";
}
if(iii==2038){
	add_number=0;
	raw_interface_name="corenet_send_rlogind_client_packets";
	add0="allow $1 rlogind_client_packet_t:packet send;";
}
if(iii==2039){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rlogind_client_packets";
	add0="dontaudit $1 rlogind_client_packet_t:packet send;";
}
if(iii==2040){
	add_number=0;
	raw_interface_name="corenet_receive_rlogind_client_packets";
	add0="allow $1 rlogind_client_packet_t:packet recv;";
}
if(iii==2041){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rlogind_client_packets";
	add0="dontaudit $1 rlogind_client_packet_t:packet recv;";
}
if(iii==2042){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rlogind_client_packets";
	add0="corenet_send_rlogind_client_packets($1)";
	add1="corenet_receive_rlogind_client_packets($1)";
	add_number =1;
}
if(iii==2043){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rlogind_client_packets";
	add0="corenet_dontaudit_send_rlogind_client_packets($1)";
	add1="corenet_dontaudit_receive_rlogind_client_packets($1)";
	add_number =1;
}
if(iii==2044){
	add_number=0;
	raw_interface_name="corenet_relabelto_rlogind_client_packets";
	add0="allow $1 rlogind_client_packet_t:packet relabelto;";
}
if(iii==2045){
	add_number=0;
	raw_interface_name="corenet_send_rlogind_server_packets";
	add0="allow $1 rlogind_server_packet_t:packet send;";
}
if(iii==2046){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rlogind_server_packets";
	add0="dontaudit $1 rlogind_server_packet_t:packet send;";
}
if(iii==2047){
	add_number=0;
	raw_interface_name="corenet_receive_rlogind_server_packets";
	add0="allow $1 rlogind_server_packet_t:packet recv;";
}
if(iii==2048){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rlogind_server_packets";
	add0="dontaudit $1 rlogind_server_packet_t:packet recv;";
}
if(iii==2049){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rlogind_server_packets";
	add0="corenet_send_rlogind_server_packets($1)";
	add1="corenet_receive_rlogind_server_packets($1)";
	add_number =1;
}
if(iii==2050){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rlogind_server_packets";
	add0="corenet_dontaudit_send_rlogind_server_packets($1)";
	add1="corenet_dontaudit_receive_rlogind_server_packets($1)";
	add_number =1;
}
if(iii==2051){
	add_number=0;
	raw_interface_name="corenet_relabelto_rlogind_server_packets";
	add0="allow $1 rlogind_server_packet_t:packet relabelto;";
}
if(iii==2052){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_rndc_port";
	add0="allow $1 rndc_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2053){
	add_number=0;
	raw_interface_name="corenet_udp_send_rndc_port";
	add0="allow $1 rndc_port_t:udp_socket send_msg;";
}
if(iii==2054){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_rndc_port";
	add0="dontaudit $1 rndc_port_t:udp_socket send_msg;";
}
if(iii==2055){
	add_number=0;
	raw_interface_name="corenet_udp_receive_rndc_port";
	add0="allow $1 rndc_port_t:udp_socket recv_msg;";
}
if(iii==2056){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_rndc_port";
	add0="dontaudit $1 rndc_port_t:udp_socket recv_msg;";
}
if(iii==2057){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_rndc_port";
	add0="corenet_udp_send_rndc_port($1)";
	add1="corenet_udp_receive_rndc_port($1)";
	add_number =1;
}
if(iii==2058){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_rndc_port";
	add0="corenet_dontaudit_udp_send_rndc_port($1)";
	add1="corenet_dontaudit_udp_receive_rndc_port($1)";
	add_number =1;
}
if(iii==2059){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_rndc_port";
	add0="allow $1 rndc_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2060){
	add_number=0;
	raw_interface_name="corenet_udp_bind_rndc_port";
	add0="allow $1 rndc_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2061){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_rndc_port";
	add0="allow $1 rndc_port_t:tcp_socket name_connect;";
}
if(iii==2062){
	add_number=0;
	raw_interface_name="corenet_send_rndc_client_packets";
	add0="allow $1 rndc_client_packet_t:packet send;";
}
if(iii==2063){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rndc_client_packets";
	add0="dontaudit $1 rndc_client_packet_t:packet send;";
}
if(iii==2064){
	add_number=0;
	raw_interface_name="corenet_receive_rndc_client_packets";
	add0="allow $1 rndc_client_packet_t:packet recv;";
}
if(iii==2065){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rndc_client_packets";
	add0="dontaudit $1 rndc_client_packet_t:packet recv;";
}
if(iii==2066){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rndc_client_packets";
	add0="corenet_send_rndc_client_packets($1)";
	add1="corenet_receive_rndc_client_packets($1)";
	add_number =1;
}
if(iii==2067){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rndc_client_packets";
	add0="corenet_dontaudit_send_rndc_client_packets($1)";
	add1="corenet_dontaudit_receive_rndc_client_packets($1)";
	add_number =1;
}
if(iii==2068){
	add_number=0;
	raw_interface_name="corenet_relabelto_rndc_client_packets";
	add0="allow $1 rndc_client_packet_t:packet relabelto;";
}
if(iii==2069){
	add_number=0;
	raw_interface_name="corenet_send_rndc_server_packets";
	add0="allow $1 rndc_server_packet_t:packet send;";
}
if(iii==2070){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rndc_server_packets";
	add0="dontaudit $1 rndc_server_packet_t:packet send;";
}
if(iii==2071){
	add_number=0;
	raw_interface_name="corenet_receive_rndc_server_packets";
	add0="allow $1 rndc_server_packet_t:packet recv;";
}
if(iii==2072){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rndc_server_packets";
	add0="dontaudit $1 rndc_server_packet_t:packet recv;";
}
if(iii==2073){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rndc_server_packets";
	add0="corenet_send_rndc_server_packets($1)";
	add1="corenet_receive_rndc_server_packets($1)";
	add_number =1;
}
if(iii==2074){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rndc_server_packets";
	add0="corenet_dontaudit_send_rndc_server_packets($1)";
	add1="corenet_dontaudit_receive_rndc_server_packets($1)";
	add_number =1;
}
if(iii==2075){
	add_number=0;
	raw_interface_name="corenet_relabelto_rndc_server_packets";
	add0="allow $1 rndc_server_packet_t:packet relabelto;";
}
if(iii==2076){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_router_port";
	add0="allow $1 router_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2077){
	add_number=0;
	raw_interface_name="corenet_udp_send_router_port";
	add0="allow $1 router_port_t:udp_socket send_msg;";
}
if(iii==2078){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_router_port";
	add0="dontaudit $1 router_port_t:udp_socket send_msg;";
}
if(iii==2079){
	add_number=0;
	raw_interface_name="corenet_udp_receive_router_port";
	add0="allow $1 router_port_t:udp_socket recv_msg;";
}
if(iii==2080){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_router_port";
	add0="dontaudit $1 router_port_t:udp_socket recv_msg;";
}
if(iii==2081){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_router_port";
	add0="corenet_udp_send_router_port($1)";
	add1="corenet_udp_receive_router_port($1)";
	add_number =1;
}
if(iii==2082){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_router_port";
	add0="corenet_dontaudit_udp_send_router_port($1)";
	add1="corenet_dontaudit_udp_receive_router_port($1)";
	add_number =1;
}
if(iii==2083){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_router_port";
	add0="allow $1 router_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2084){
	add_number=0;
	raw_interface_name="corenet_udp_bind_router_port";
	add0="allow $1 router_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2085){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_router_port";
	add0="allow $1 router_port_t:tcp_socket name_connect;";
}
if(iii==2086){
	add_number=0;
	raw_interface_name="corenet_send_router_client_packets";
	add0="allow $1 router_client_packet_t:packet send;";
}
if(iii==2087){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_router_client_packets";
	add0="dontaudit $1 router_client_packet_t:packet send;";
}
if(iii==2088){
	add_number=0;
	raw_interface_name="corenet_receive_router_client_packets";
	add0="allow $1 router_client_packet_t:packet recv;";
}
if(iii==2089){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_router_client_packets";
	add0="dontaudit $1 router_client_packet_t:packet recv;";
}
if(iii==2090){
	add_number=0;
	raw_interface_name="corenet_sendrecv_router_client_packets";
	add0="corenet_send_router_client_packets($1)";
	add1="corenet_receive_router_client_packets($1)";
	add_number =1;
}
if(iii==2091){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_router_client_packets";
	add0="corenet_dontaudit_send_router_client_packets($1)";
	add1="corenet_dontaudit_receive_router_client_packets($1)";
	add_number =1;
}
if(iii==2092){
	add_number=0;
	raw_interface_name="corenet_relabelto_router_client_packets";
	add0="allow $1 router_client_packet_t:packet relabelto;";
}
if(iii==2093){
	add_number=0;
	raw_interface_name="corenet_send_router_server_packets";
	add0="allow $1 router_server_packet_t:packet send;";
}
if(iii==2094){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_router_server_packets";
	add0="dontaudit $1 router_server_packet_t:packet send;";
}
if(iii==2095){
	add_number=0;
	raw_interface_name="corenet_receive_router_server_packets";
	add0="allow $1 router_server_packet_t:packet recv;";
}
if(iii==2096){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_router_server_packets";
	add0="dontaudit $1 router_server_packet_t:packet recv;";
}
if(iii==2097){
	add_number=0;
	raw_interface_name="corenet_sendrecv_router_server_packets";
	add0="corenet_send_router_server_packets($1)";
	add1="corenet_receive_router_server_packets($1)";
	add_number =1;
}
if(iii==2098){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_router_server_packets";
	add0="corenet_dontaudit_send_router_server_packets($1)";
	add1="corenet_dontaudit_receive_router_server_packets($1)";
	add_number =1;
}
if(iii==2099){
	add_number=0;
	raw_interface_name="corenet_relabelto_router_server_packets";
	add0="allow $1 router_server_packet_t:packet relabelto;";
}
if(iii==2100){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_rsh_port";
	add0="allow $1 rsh_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2101){
	add_number=0;
	raw_interface_name="corenet_udp_send_rsh_port";
	add0="allow $1 rsh_port_t:udp_socket send_msg;";
}
if(iii==2102){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_rsh_port";
	add0="dontaudit $1 rsh_port_t:udp_socket send_msg;";
}
if(iii==2103){
	add_number=0;
	raw_interface_name="corenet_udp_receive_rsh_port";
	add0="allow $1 rsh_port_t:udp_socket recv_msg;";
}
if(iii==2104){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_rsh_port";
	add0="dontaudit $1 rsh_port_t:udp_socket recv_msg;";
}
if(iii==2105){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_rsh_port";
	add0="corenet_udp_send_rsh_port($1)";
	add1="corenet_udp_receive_rsh_port($1)";
	add_number =1;
}
if(iii==2106){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_rsh_port";
	add0="corenet_dontaudit_udp_send_rsh_port($1)";
	add1="corenet_dontaudit_udp_receive_rsh_port($1)";
	add_number =1;
}
if(iii==2107){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_rsh_port";
	add0="allow $1 rsh_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2108){
	add_number=0;
	raw_interface_name="corenet_udp_bind_rsh_port";
	add0="allow $1 rsh_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2109){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_rsh_port";
	add0="allow $1 rsh_port_t:tcp_socket name_connect;";
}
if(iii==2110){
	add_number=0;
	raw_interface_name="corenet_send_rsh_client_packets";
	add0="allow $1 rsh_client_packet_t:packet send;";
}
if(iii==2111){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rsh_client_packets";
	add0="dontaudit $1 rsh_client_packet_t:packet send;";
}
if(iii==2112){
	add_number=0;
	raw_interface_name="corenet_receive_rsh_client_packets";
	add0="allow $1 rsh_client_packet_t:packet recv;";
}
if(iii==2113){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rsh_client_packets";
	add0="dontaudit $1 rsh_client_packet_t:packet recv;";
}
if(iii==2114){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rsh_client_packets";
	add0="corenet_send_rsh_client_packets($1)";
	add1="corenet_receive_rsh_client_packets($1)";
	add_number =1;
}
if(iii==2115){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rsh_client_packets";
	add0="corenet_dontaudit_send_rsh_client_packets($1)";
	add1="corenet_dontaudit_receive_rsh_client_packets($1)";
	add_number =1;
}
if(iii==2116){
	add_number=0;
	raw_interface_name="corenet_relabelto_rsh_client_packets";
	add0="allow $1 rsh_client_packet_t:packet relabelto;";
}
if(iii==2117){
	add_number=0;
	raw_interface_name="corenet_send_rsh_server_packets";
	add0="allow $1 rsh_server_packet_t:packet send;";
}
if(iii==2118){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rsh_server_packets";
	add0="dontaudit $1 rsh_server_packet_t:packet send;";
}
if(iii==2119){
	add_number=0;
	raw_interface_name="corenet_receive_rsh_server_packets";
	add0="allow $1 rsh_server_packet_t:packet recv;";
}
if(iii==2120){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rsh_server_packets";
	add0="dontaudit $1 rsh_server_packet_t:packet recv;";
}
if(iii==2121){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rsh_server_packets";
	add0="corenet_send_rsh_server_packets($1)";
	add1="corenet_receive_rsh_server_packets($1)";
	add_number =1;
}
if(iii==2122){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rsh_server_packets";
	add0="corenet_dontaudit_send_rsh_server_packets($1)";
	add1="corenet_dontaudit_receive_rsh_server_packets($1)";
	add_number =1;
}
if(iii==2123){
	add_number=0;
	raw_interface_name="corenet_relabelto_rsh_server_packets";
	add0="allow $1 rsh_server_packet_t:packet relabelto;";
}
if(iii==2124){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_rsync_port";
	add0="allow $1 rsync_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2125){
	add_number=0;
	raw_interface_name="corenet_udp_send_rsync_port";
	add0="allow $1 rsync_port_t:udp_socket send_msg;";
}
if(iii==2126){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_rsync_port";
	add0="dontaudit $1 rsync_port_t:udp_socket send_msg;";
}
if(iii==2127){
	add_number=0;
	raw_interface_name="corenet_udp_receive_rsync_port";
	add0="allow $1 rsync_port_t:udp_socket recv_msg;";
}
if(iii==2128){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_rsync_port";
	add0="dontaudit $1 rsync_port_t:udp_socket recv_msg;";
}
if(iii==2129){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_rsync_port";
	add0="corenet_udp_send_rsync_port($1)";
	add1="corenet_udp_receive_rsync_port($1)";
	add_number =1;
}
if(iii==2130){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_rsync_port";
	add0="corenet_dontaudit_udp_send_rsync_port($1)";
	add1="corenet_dontaudit_udp_receive_rsync_port($1)";
	add_number =1;
}
if(iii==2131){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_rsync_port";
	add0="allow $1 rsync_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2132){
	add_number=0;
	raw_interface_name="corenet_udp_bind_rsync_port";
	add0="allow $1 rsync_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2133){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_rsync_port";
	add0="allow $1 rsync_port_t:tcp_socket name_connect;";
}
if(iii==2134){
	add_number=0;
	raw_interface_name="corenet_send_rsync_client_packets";
	add0="allow $1 rsync_client_packet_t:packet send;";
}
if(iii==2135){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rsync_client_packets";
	add0="dontaudit $1 rsync_client_packet_t:packet send;";
}
if(iii==2136){
	add_number=0;
	raw_interface_name="corenet_receive_rsync_client_packets";
	add0="allow $1 rsync_client_packet_t:packet recv;";
}
if(iii==2137){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rsync_client_packets";
	add0="dontaudit $1 rsync_client_packet_t:packet recv;";
}
if(iii==2138){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rsync_client_packets";
	add0="corenet_send_rsync_client_packets($1)";
	add1="corenet_receive_rsync_client_packets($1)";
	add_number =1;
}
if(iii==2139){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rsync_client_packets";
	add0="corenet_dontaudit_send_rsync_client_packets($1)";
	add1="corenet_dontaudit_receive_rsync_client_packets($1)";
	add_number =1;
}
if(iii==2140){
	add_number=0;
	raw_interface_name="corenet_relabelto_rsync_client_packets";
	add0="allow $1 rsync_client_packet_t:packet relabelto;";
}
if(iii==2141){
	add_number=0;
	raw_interface_name="corenet_send_rsync_server_packets";
	add0="allow $1 rsync_server_packet_t:packet send;";
}
if(iii==2142){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rsync_server_packets";
	add0="dontaudit $1 rsync_server_packet_t:packet send;";
}
if(iii==2143){
	add_number=0;
	raw_interface_name="corenet_receive_rsync_server_packets";
	add0="allow $1 rsync_server_packet_t:packet recv;";
}
if(iii==2144){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rsync_server_packets";
	add0="dontaudit $1 rsync_server_packet_t:packet recv;";
}
if(iii==2145){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rsync_server_packets";
	add0="corenet_send_rsync_server_packets($1)";
	add1="corenet_receive_rsync_server_packets($1)";
	add_number =1;
}
if(iii==2146){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rsync_server_packets";
	add0="corenet_dontaudit_send_rsync_server_packets($1)";
	add1="corenet_dontaudit_receive_rsync_server_packets($1)";
	add_number =1;
}
if(iii==2147){
	add_number=0;
	raw_interface_name="corenet_relabelto_rsync_server_packets";
	add0="allow $1 rsync_server_packet_t:packet relabelto;";
}
if(iii==2148){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_rwho_port";
	add0="allow $1 rwho_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2149){
	add_number=0;
	raw_interface_name="corenet_udp_send_rwho_port";
	add0="allow $1 rwho_port_t:udp_socket send_msg;";
}
if(iii==2150){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_rwho_port";
	add0="dontaudit $1 rwho_port_t:udp_socket send_msg;";
}
if(iii==2151){
	add_number=0;
	raw_interface_name="corenet_udp_receive_rwho_port";
	add0="allow $1 rwho_port_t:udp_socket recv_msg;";
}
if(iii==2152){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_rwho_port";
	add0="dontaudit $1 rwho_port_t:udp_socket recv_msg;";
}
if(iii==2153){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_rwho_port";
	add0="corenet_udp_send_rwho_port($1)";
	add1="corenet_udp_receive_rwho_port($1)";
	add_number =1;
}
if(iii==2154){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_rwho_port";
	add0="corenet_dontaudit_udp_send_rwho_port($1)";
	add1="corenet_dontaudit_udp_receive_rwho_port($1)";
	add_number =1;
}
if(iii==2155){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_rwho_port";
	add0="allow $1 rwho_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2156){
	add_number=0;
	raw_interface_name="corenet_udp_bind_rwho_port";
	add0="allow $1 rwho_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2157){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_rwho_port";
	add0="allow $1 rwho_port_t:tcp_socket name_connect;";
}
if(iii==2158){
	add_number=0;
	raw_interface_name="corenet_send_rwho_client_packets";
	add0="allow $1 rwho_client_packet_t:packet send;";
}
if(iii==2159){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rwho_client_packets";
	add0="dontaudit $1 rwho_client_packet_t:packet send;";
}
if(iii==2160){
	add_number=0;
	raw_interface_name="corenet_receive_rwho_client_packets";
	add0="allow $1 rwho_client_packet_t:packet recv;";
}
if(iii==2161){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rwho_client_packets";
	add0="dontaudit $1 rwho_client_packet_t:packet recv;";
}
if(iii==2162){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rwho_client_packets";
	add0="corenet_send_rwho_client_packets($1)";
	add1="corenet_receive_rwho_client_packets($1)";
	add_number =1;
}
if(iii==2163){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rwho_client_packets";
	add0="corenet_dontaudit_send_rwho_client_packets($1)";
	add1="corenet_dontaudit_receive_rwho_client_packets($1)";
	add_number =1;
}
if(iii==2164){
	add_number=0;
	raw_interface_name="corenet_relabelto_rwho_client_packets";
	add0="allow $1 rwho_client_packet_t:packet relabelto;";
}
if(iii==2165){
	add_number=0;
	raw_interface_name="corenet_send_rwho_server_packets";
	add0="allow $1 rwho_server_packet_t:packet send;";
}
if(iii==2166){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_rwho_server_packets";
	add0="dontaudit $1 rwho_server_packet_t:packet send;";
}
if(iii==2167){
	add_number=0;
	raw_interface_name="corenet_receive_rwho_server_packets";
	add0="allow $1 rwho_server_packet_t:packet recv;";
}
if(iii==2168){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_rwho_server_packets";
	add0="dontaudit $1 rwho_server_packet_t:packet recv;";
}
if(iii==2169){
	add_number=0;
	raw_interface_name="corenet_sendrecv_rwho_server_packets";
	add0="corenet_send_rwho_server_packets($1)";
	add1="corenet_receive_rwho_server_packets($1)";
	add_number =1;
}
if(iii==2170){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_rwho_server_packets";
	add0="corenet_dontaudit_send_rwho_server_packets($1)";
	add1="corenet_dontaudit_receive_rwho_server_packets($1)";
	add_number =1;
}
if(iii==2171){
	add_number=0;
	raw_interface_name="corenet_relabelto_rwho_server_packets";
	add0="allow $1 rwho_server_packet_t:packet relabelto;";
}
if(iii==2172){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_smbd_port";
	add0="allow $1 smbd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2173){
	add_number=0;
	raw_interface_name="corenet_udp_send_smbd_port";
	add0="allow $1 smbd_port_t:udp_socket send_msg;";
}
if(iii==2174){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_smbd_port";
	add0="dontaudit $1 smbd_port_t:udp_socket send_msg;";
}
if(iii==2175){
	add_number=0;
	raw_interface_name="corenet_udp_receive_smbd_port";
	add0="allow $1 smbd_port_t:udp_socket recv_msg;";
}
if(iii==2176){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_smbd_port";
	add0="dontaudit $1 smbd_port_t:udp_socket recv_msg;";
}
if(iii==2177){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_smbd_port";
	add0="corenet_udp_send_smbd_port($1)";
	add1="corenet_udp_receive_smbd_port($1)";
	add_number =1;
}
if(iii==2178){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_smbd_port";
	add0="corenet_dontaudit_udp_send_smbd_port($1)";
	add1="corenet_dontaudit_udp_receive_smbd_port($1)";
	add_number =1;
}
if(iii==2179){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_smbd_port";
	add0="allow $1 smbd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2180){
	add_number=0;
	raw_interface_name="corenet_udp_bind_smbd_port";
	add0="allow $1 smbd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2181){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_smbd_port";
	add0="allow $1 smbd_port_t:tcp_socket name_connect;";
}
if(iii==2182){
	add_number=0;
	raw_interface_name="corenet_send_smbd_client_packets";
	add0="allow $1 smbd_client_packet_t:packet send;";
}
if(iii==2183){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_smbd_client_packets";
	add0="dontaudit $1 smbd_client_packet_t:packet send;";
}
if(iii==2184){
	add_number=0;
	raw_interface_name="corenet_receive_smbd_client_packets";
	add0="allow $1 smbd_client_packet_t:packet recv;";
}
if(iii==2185){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_smbd_client_packets";
	add0="dontaudit $1 smbd_client_packet_t:packet recv;";
}
if(iii==2186){
	add_number=0;
	raw_interface_name="corenet_sendrecv_smbd_client_packets";
	add0="corenet_send_smbd_client_packets($1)";
	add1="corenet_receive_smbd_client_packets($1)";
	add_number =1;
}
if(iii==2187){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_smbd_client_packets";
	add0="corenet_dontaudit_send_smbd_client_packets($1)";
	add1="corenet_dontaudit_receive_smbd_client_packets($1)";
	add_number =1;
}
if(iii==2188){
	add_number=0;
	raw_interface_name="corenet_relabelto_smbd_client_packets";
	add0="allow $1 smbd_client_packet_t:packet relabelto;";
}
if(iii==2189){
	add_number=0;
	raw_interface_name="corenet_send_smbd_server_packets";
	add0="allow $1 smbd_server_packet_t:packet send;";
}
if(iii==2190){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_smbd_server_packets";
	add0="dontaudit $1 smbd_server_packet_t:packet send;";
}
if(iii==2191){
	add_number=0;
	raw_interface_name="corenet_receive_smbd_server_packets";
	add0="allow $1 smbd_server_packet_t:packet recv;";
}
if(iii==2192){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_smbd_server_packets";
	add0="dontaudit $1 smbd_server_packet_t:packet recv;";
}
if(iii==2193){
	add_number=0;
	raw_interface_name="corenet_sendrecv_smbd_server_packets";
	add0="corenet_send_smbd_server_packets($1)";
	add1="corenet_receive_smbd_server_packets($1)";
	add_number =1;
}
if(iii==2194){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_smbd_server_packets";
	add0="corenet_dontaudit_send_smbd_server_packets($1)";
	add1="corenet_dontaudit_receive_smbd_server_packets($1)";
	add_number =1;
}
if(iii==2195){
	add_number=0;
	raw_interface_name="corenet_relabelto_smbd_server_packets";
	add0="allow $1 smbd_server_packet_t:packet relabelto;";
}
if(iii==2196){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_smtp_port";
	add0="allow $1 smtp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2197){
	add_number=0;
	raw_interface_name="corenet_udp_send_smtp_port";
	add0="allow $1 smtp_port_t:udp_socket send_msg;";
}
if(iii==2198){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_smtp_port";
	add0="dontaudit $1 smtp_port_t:udp_socket send_msg;";
}
if(iii==2199){
	add_number=0;
	raw_interface_name="corenet_udp_receive_smtp_port";
	add0="allow $1 smtp_port_t:udp_socket recv_msg;";
}
if(iii==2200){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_smtp_port";
	add0="dontaudit $1 smtp_port_t:udp_socket recv_msg;";
}
if(iii==2201){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_smtp_port";
	add0="corenet_udp_send_smtp_port($1)";
	add1="corenet_udp_receive_smtp_port($1)";
	add_number =1;
}
if(iii==2202){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_smtp_port";
	add0="corenet_dontaudit_udp_send_smtp_port($1)";
	add1="corenet_dontaudit_udp_receive_smtp_port($1)";
	add_number =1;
}
if(iii==2203){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_smtp_port";
	add0="allow $1 smtp_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2204){
	add_number=0;
	raw_interface_name="corenet_udp_bind_smtp_port";
	add0="allow $1 smtp_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2205){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_smtp_port";
	add0="allow $1 smtp_port_t:tcp_socket name_connect;";
}
if(iii==2206){
	add_number=0;
	raw_interface_name="corenet_send_smtp_client_packets";
	add0="allow $1 smtp_client_packet_t:packet send;";
}
if(iii==2207){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_smtp_client_packets";
	add0="dontaudit $1 smtp_client_packet_t:packet send;";
}
if(iii==2208){
	add_number=0;
	raw_interface_name="corenet_receive_smtp_client_packets";
	add0="allow $1 smtp_client_packet_t:packet recv;";
}
if(iii==2209){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_smtp_client_packets";
	add0="dontaudit $1 smtp_client_packet_t:packet recv;";
}
if(iii==2210){
	add_number=0;
	raw_interface_name="corenet_sendrecv_smtp_client_packets";
	add0="corenet_send_smtp_client_packets($1)";
	add1="corenet_receive_smtp_client_packets($1)";
	add_number =1;
}
if(iii==2211){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_smtp_client_packets";
	add0="corenet_dontaudit_send_smtp_client_packets($1)";
	add1="corenet_dontaudit_receive_smtp_client_packets($1)";
	add_number =1;
}
if(iii==2212){
	add_number=0;
	raw_interface_name="corenet_relabelto_smtp_client_packets";
	add0="allow $1 smtp_client_packet_t:packet relabelto;";
}
if(iii==2213){
	add_number=0;
	raw_interface_name="corenet_send_smtp_server_packets";
	add0="allow $1 smtp_server_packet_t:packet send;";
}
if(iii==2214){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_smtp_server_packets";
	add0="dontaudit $1 smtp_server_packet_t:packet send;";
}
if(iii==2215){
	add_number=0;
	raw_interface_name="corenet_receive_smtp_server_packets";
	add0="allow $1 smtp_server_packet_t:packet recv;";
}
if(iii==2216){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_smtp_server_packets";
	add0="dontaudit $1 smtp_server_packet_t:packet recv;";
}
if(iii==2217){
	add_number=0;
	raw_interface_name="corenet_sendrecv_smtp_server_packets";
	add0="corenet_send_smtp_server_packets($1)";
	add1="corenet_receive_smtp_server_packets($1)";
	add_number =1;
}
if(iii==2218){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_smtp_server_packets";
	add0="corenet_dontaudit_send_smtp_server_packets($1)";
	add1="corenet_dontaudit_receive_smtp_server_packets($1)";
	add_number =1;
}
if(iii==2219){
	add_number=0;
	raw_interface_name="corenet_relabelto_smtp_server_packets";
	add0="allow $1 smtp_server_packet_t:packet relabelto;";
}
if(iii==2220){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_snmp_port";
	add0="allow $1 snmp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2221){
	add_number=0;
	raw_interface_name="corenet_udp_send_snmp_port";
	add0="allow $1 snmp_port_t:udp_socket send_msg;";
}
if(iii==2222){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_snmp_port";
	add0="dontaudit $1 snmp_port_t:udp_socket send_msg;";
}
if(iii==2223){
	add_number=0;
	raw_interface_name="corenet_udp_receive_snmp_port";
	add0="allow $1 snmp_port_t:udp_socket recv_msg;";
}
if(iii==2224){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_snmp_port";
	add0="dontaudit $1 snmp_port_t:udp_socket recv_msg;";
}
if(iii==2225){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_snmp_port";
	add0="corenet_udp_send_snmp_port($1)";
	add1="corenet_udp_receive_snmp_port($1)";
	add_number =1;
}
if(iii==2226){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_snmp_port";
	add0="corenet_dontaudit_udp_send_snmp_port($1)";
	add1="corenet_dontaudit_udp_receive_snmp_port($1)";
	add_number =1;
}
if(iii==2227){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_snmp_port";
	add0="allow $1 snmp_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2228){
	add_number=0;
	raw_interface_name="corenet_udp_bind_snmp_port";
	add0="allow $1 snmp_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2229){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_snmp_port";
	add0="allow $1 snmp_port_t:tcp_socket name_connect;";
}
if(iii==2230){
	add_number=0;
	raw_interface_name="corenet_send_snmp_client_packets";
	add0="allow $1 snmp_client_packet_t:packet send;";
}
if(iii==2231){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_snmp_client_packets";
	add0="dontaudit $1 snmp_client_packet_t:packet send;";
}
if(iii==2232){
	add_number=0;
	raw_interface_name="corenet_receive_snmp_client_packets";
	add0="allow $1 snmp_client_packet_t:packet recv;";
}
if(iii==2233){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_snmp_client_packets";
	add0="dontaudit $1 snmp_client_packet_t:packet recv;";
}
if(iii==2234){
	add_number=0;
	raw_interface_name="corenet_sendrecv_snmp_client_packets";
	add0="corenet_send_snmp_client_packets($1)";
	add1="corenet_receive_snmp_client_packets($1)";
	add_number =1;
}
if(iii==2235){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_snmp_client_packets";
	add0="corenet_dontaudit_send_snmp_client_packets($1)";
	add1="corenet_dontaudit_receive_snmp_client_packets($1)";
	add_number =1;
}
if(iii==2236){
	add_number=0;
	raw_interface_name="corenet_relabelto_snmp_client_packets";
	add0="allow $1 snmp_client_packet_t:packet relabelto;";
}
if(iii==2237){
	add_number=0;
	raw_interface_name="corenet_send_snmp_server_packets";
	add0="allow $1 snmp_server_packet_t:packet send;";
}
if(iii==2238){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_snmp_server_packets";
	add0="dontaudit $1 snmp_server_packet_t:packet send;";
}
if(iii==2239){
	add_number=0;
	raw_interface_name="corenet_receive_snmp_server_packets";
	add0="allow $1 snmp_server_packet_t:packet recv;";
}
if(iii==2240){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_snmp_server_packets";
	add0="dontaudit $1 snmp_server_packet_t:packet recv;";
}
if(iii==2241){
	add_number=0;
	raw_interface_name="corenet_sendrecv_snmp_server_packets";
	add0="corenet_send_snmp_server_packets($1)";
	add1="corenet_receive_snmp_server_packets($1)";
	add_number =1;
}
if(iii==2242){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_snmp_server_packets";
	add0="corenet_dontaudit_send_snmp_server_packets($1)";
	add1="corenet_dontaudit_receive_snmp_server_packets($1)";
	add_number =1;
}
if(iii==2243){
	add_number=0;
	raw_interface_name="corenet_relabelto_snmp_server_packets";
	add0="allow $1 snmp_server_packet_t:packet relabelto;";
}
if(iii==2244){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_spamd_port";
	add0="allow $1 spamd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2245){
	add_number=0;
	raw_interface_name="corenet_udp_send_spamd_port";
	add0="allow $1 spamd_port_t:udp_socket send_msg;";
}
if(iii==2246){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_spamd_port";
	add0="dontaudit $1 spamd_port_t:udp_socket send_msg;";
}
if(iii==2247){
	add_number=0;
	raw_interface_name="corenet_udp_receive_spamd_port";
	add0="allow $1 spamd_port_t:udp_socket recv_msg;";
}
if(iii==2248){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_spamd_port";
	add0="dontaudit $1 spamd_port_t:udp_socket recv_msg;";
}
if(iii==2249){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_spamd_port";
	add0="corenet_udp_send_spamd_port($1)";
	add1="corenet_udp_receive_spamd_port($1)";
	add_number =1;
}
if(iii==2250){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_spamd_port";
	add0="corenet_dontaudit_udp_send_spamd_port($1)";
	add1="corenet_dontaudit_udp_receive_spamd_port($1)";
	add_number =1;
}
if(iii==2251){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_spamd_port";
	add0="allow $1 spamd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2252){
	add_number=0;
	raw_interface_name="corenet_udp_bind_spamd_port";
	add0="allow $1 spamd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2253){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_spamd_port";
	add0="allow $1 spamd_port_t:tcp_socket name_connect;";
}
if(iii==2254){
	add_number=0;
	raw_interface_name="corenet_send_spamd_client_packets";
	add0="allow $1 spamd_client_packet_t:packet send;";
}
if(iii==2255){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_spamd_client_packets";
	add0="dontaudit $1 spamd_client_packet_t:packet send;";
}
if(iii==2256){
	add_number=0;
	raw_interface_name="corenet_receive_spamd_client_packets";
	add0="allow $1 spamd_client_packet_t:packet recv;";
}
if(iii==2257){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_spamd_client_packets";
	add0="dontaudit $1 spamd_client_packet_t:packet recv;";
}
if(iii==2258){
	add_number=0;
	raw_interface_name="corenet_sendrecv_spamd_client_packets";
	add0="corenet_send_spamd_client_packets($1)";
	add1="corenet_receive_spamd_client_packets($1)";
	add_number =1;
}
if(iii==2259){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_spamd_client_packets";
	add0="corenet_dontaudit_send_spamd_client_packets($1)";
	add1="corenet_dontaudit_receive_spamd_client_packets($1)";
	add_number =1;
}
if(iii==2260){
	add_number=0;
	raw_interface_name="corenet_relabelto_spamd_client_packets";
	add0="allow $1 spamd_client_packet_t:packet relabelto;";
}
if(iii==2261){
	add_number=0;
	raw_interface_name="corenet_send_spamd_server_packets";
	add0="allow $1 spamd_server_packet_t:packet send;";
}
if(iii==2262){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_spamd_server_packets";
	add0="dontaudit $1 spamd_server_packet_t:packet send;";
}
if(iii==2263){
	add_number=0;
	raw_interface_name="corenet_receive_spamd_server_packets";
	add0="allow $1 spamd_server_packet_t:packet recv;";
}
if(iii==2264){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_spamd_server_packets";
	add0="dontaudit $1 spamd_server_packet_t:packet recv;";
}
if(iii==2265){
	add_number=0;
	raw_interface_name="corenet_sendrecv_spamd_server_packets";
	add0="corenet_send_spamd_server_packets($1)";
	add1="corenet_receive_spamd_server_packets($1)";
	add_number =1;
}
if(iii==2266){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_spamd_server_packets";
	add0="corenet_dontaudit_send_spamd_server_packets($1)";
	add1="corenet_dontaudit_receive_spamd_server_packets($1)";
	add_number =1;
}
if(iii==2267){
	add_number=0;
	raw_interface_name="corenet_relabelto_spamd_server_packets";
	add0="allow $1 spamd_server_packet_t:packet relabelto;";
}
if(iii==2268){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_ssh_port";
	add0="allow $1 ssh_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2269){
	add_number=0;
	raw_interface_name="corenet_udp_send_ssh_port";
	add0="allow $1 ssh_port_t:udp_socket send_msg;";
}
if(iii==2270){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_ssh_port";
	add0="dontaudit $1 ssh_port_t:udp_socket send_msg;";
}
if(iii==2271){
	add_number=0;
	raw_interface_name="corenet_udp_receive_ssh_port";
	add0="allow $1 ssh_port_t:udp_socket recv_msg;";
}
if(iii==2272){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_ssh_port";
	add0="dontaudit $1 ssh_port_t:udp_socket recv_msg;";
}
if(iii==2273){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_ssh_port";
	add0="corenet_udp_send_ssh_port($1)";
	add1="corenet_udp_receive_ssh_port($1)";
	add_number =1;
}
if(iii==2274){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_ssh_port";
	add0="corenet_dontaudit_udp_send_ssh_port($1)";
	add1="corenet_dontaudit_udp_receive_ssh_port($1)";
	add_number =1;
}
if(iii==2275){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_ssh_port";
	add0="allow $1 ssh_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2276){
	add_number=0;
	raw_interface_name="corenet_udp_bind_ssh_port";
	add0="allow $1 ssh_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2277){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_ssh_port";
	add0="allow $1 ssh_port_t:tcp_socket name_connect;";
}
if(iii==2278){
	add_number=0;
	raw_interface_name="corenet_send_ssh_client_packets";
	add0="allow $1 ssh_client_packet_t:packet send;";
}
if(iii==2279){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ssh_client_packets";
	add0="dontaudit $1 ssh_client_packet_t:packet send;";
}
if(iii==2280){
	add_number=0;
	raw_interface_name="corenet_receive_ssh_client_packets";
	add0="allow $1 ssh_client_packet_t:packet recv;";
}
if(iii==2281){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ssh_client_packets";
	add0="dontaudit $1 ssh_client_packet_t:packet recv;";
}
if(iii==2282){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ssh_client_packets";
	add0="corenet_send_ssh_client_packets($1)";
	add1="corenet_receive_ssh_client_packets($1)";
	add_number =1;
}
if(iii==2283){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ssh_client_packets";
	add0="corenet_dontaudit_send_ssh_client_packets($1)";
	add1="corenet_dontaudit_receive_ssh_client_packets($1)";
	add_number =1;
}
if(iii==2284){
	add_number=0;
	raw_interface_name="corenet_relabelto_ssh_client_packets";
	add0="allow $1 ssh_client_packet_t:packet relabelto;";
}
if(iii==2285){
	add_number=0;
	raw_interface_name="corenet_send_ssh_server_packets";
	add0="allow $1 ssh_server_packet_t:packet send;";
}
if(iii==2286){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_ssh_server_packets";
	add0="dontaudit $1 ssh_server_packet_t:packet send;";
}
if(iii==2287){
	add_number=0;
	raw_interface_name="corenet_receive_ssh_server_packets";
	add0="allow $1 ssh_server_packet_t:packet recv;";
}
if(iii==2288){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_ssh_server_packets";
	add0="dontaudit $1 ssh_server_packet_t:packet recv;";
}
if(iii==2289){
	add_number=0;
	raw_interface_name="corenet_sendrecv_ssh_server_packets";
	add0="corenet_send_ssh_server_packets($1)";
	add1="corenet_receive_ssh_server_packets($1)";
	add_number =1;
}
if(iii==2290){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_ssh_server_packets";
	add0="corenet_dontaudit_send_ssh_server_packets($1)";
	add1="corenet_dontaudit_receive_ssh_server_packets($1)";
	add_number =1;
}
if(iii==2291){
	add_number=0;
	raw_interface_name="corenet_relabelto_ssh_server_packets";
	add0="allow $1 ssh_server_packet_t:packet relabelto;";
}
if(iii==2292){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_soundd_port";
	add0="allow $1 soundd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2293){
	add_number=0;
	raw_interface_name="corenet_udp_send_soundd_port";
	add0="allow $1 soundd_port_t:udp_socket send_msg;";
}
if(iii==2294){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_soundd_port";
	add0="dontaudit $1 soundd_port_t:udp_socket send_msg;";
}
if(iii==2295){
	add_number=0;
	raw_interface_name="corenet_udp_receive_soundd_port";
	add0="allow $1 soundd_port_t:udp_socket recv_msg;";
}
if(iii==2296){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_soundd_port";
	add0="dontaudit $1 soundd_port_t:udp_socket recv_msg;";
}
if(iii==2297){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_soundd_port";
	add0="corenet_udp_send_soundd_port($1)";
	add1="corenet_udp_receive_soundd_port($1)";
	add_number =1;
}
if(iii==2298){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_soundd_port";
	add0="corenet_dontaudit_udp_send_soundd_port($1)";
	add1="corenet_dontaudit_udp_receive_soundd_port($1)";
	add_number =1;
}
if(iii==2299){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_soundd_port";
	add0="allow $1 soundd_port_t:tcp_socket name_bind;";
}
if(iii==2300){
	add_number=0;
	raw_interface_name="corenet_udp_bind_soundd_port";
	add0="allow $1 soundd_port_t:udp_socket name_bind;";
}
if(iii==2301){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_soundd_port";
	add0="allow $1 soundd_port_t:tcp_socket name_connect;";
}
if(iii==2302){
	add_number=0;
	raw_interface_name="corenet_send_soundd_client_packets";
	add0="allow $1 soundd_client_packet_t:packet send;";
}
if(iii==2303){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_soundd_client_packets";
	add0="dontaudit $1 soundd_client_packet_t:packet send;";
}
if(iii==2304){
	add_number=0;
	raw_interface_name="corenet_receive_soundd_client_packets";
	add0="allow $1 soundd_client_packet_t:packet recv;";
}
if(iii==2305){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_soundd_client_packets";
	add0="dontaudit $1 soundd_client_packet_t:packet recv;";
}
if(iii==2306){
	add_number=0;
	raw_interface_name="corenet_sendrecv_soundd_client_packets";
	add0="corenet_send_soundd_client_packets($1)";
	add1="corenet_receive_soundd_client_packets($1)";
	add_number =1;
}
if(iii==2307){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_soundd_client_packets";
	add0="corenet_dontaudit_send_soundd_client_packets($1)";
	add1="corenet_dontaudit_receive_soundd_client_packets($1)";
	add_number =1;
}
if(iii==2308){
	add_number=0;
	raw_interface_name="corenet_relabelto_soundd_client_packets";
	add0="allow $1 soundd_client_packet_t:packet relabelto;";
}
if(iii==2309){
	add_number=0;
	raw_interface_name="corenet_send_soundd_server_packets";
	add0="allow $1 soundd_server_packet_t:packet send;";
}
if(iii==2310){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_soundd_server_packets";
	add0="dontaudit $1 soundd_server_packet_t:packet send;";
}
if(iii==2311){
	add_number=0;
	raw_interface_name="corenet_receive_soundd_server_packets";
	add0="allow $1 soundd_server_packet_t:packet recv;";
}
if(iii==2312){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_soundd_server_packets";
	add0="dontaudit $1 soundd_server_packet_t:packet recv;";
}
if(iii==2313){
	add_number=0;
	raw_interface_name="corenet_sendrecv_soundd_server_packets";
	add0="corenet_send_soundd_server_packets($1)";
	add1="corenet_receive_soundd_server_packets($1)";
	add_number =1;
}
if(iii==2314){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_soundd_server_packets";
	add0="corenet_dontaudit_send_soundd_server_packets($1)";
	add1="corenet_dontaudit_receive_soundd_server_packets($1)";
	add_number =1;
}
if(iii==2315){
	add_number=0;
	raw_interface_name="corenet_relabelto_soundd_server_packets";
	add0="allow $1 soundd_server_packet_t:packet relabelto;";
}
if(iii==2316){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_squid_port";
	add0="allow $1 squid_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2317){
	add_number=0;
	raw_interface_name="corenet_udp_send_squid_port";
	add0="allow $1 squid_port_t:udp_socket send_msg;";
}
if(iii==2318){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_squid_port";
	add0="dontaudit $1 squid_port_t:udp_socket send_msg;";
}
if(iii==2319){
	add_number=0;
	raw_interface_name="corenet_udp_receive_squid_port";
	add0="allow $1 squid_port_t:udp_socket recv_msg;";
}
if(iii==2320){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_squid_port";
	add0="dontaudit $1 squid_port_t:udp_socket recv_msg;";
}
if(iii==2321){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_squid_port";
	add0="corenet_udp_send_squid_port($1)";
	add1="corenet_udp_receive_squid_port($1)";
	add_number =1;
}
if(iii==2322){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_squid_port";
	add0="corenet_dontaudit_udp_send_squid_port($1)";
	add1="corenet_dontaudit_udp_receive_squid_port($1)";
	add_number =1;
}
if(iii==2323){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_squid_port";
	add0="allow $1 squid_port_t:tcp_socket name_bind;";
}
if(iii==2324){
	add_number=0;
	raw_interface_name="corenet_udp_bind_squid_port";
	add0="allow $1 squid_port_t:udp_socket name_bind;";
}
if(iii==2325){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_squid_port";
	add0="allow $1 squid_port_t:tcp_socket name_connect;";
}
if(iii==2326){
	add_number=0;
	raw_interface_name="corenet_send_squid_client_packets";
	add0="allow $1 squid_client_packet_t:packet send;";
}
if(iii==2327){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_squid_client_packets";
	add0="dontaudit $1 squid_client_packet_t:packet send;";
}
if(iii==2328){
	add_number=0;
	raw_interface_name="corenet_receive_squid_client_packets";
	add0="allow $1 squid_client_packet_t:packet recv;";
}
if(iii==2329){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_squid_client_packets";
	add0="dontaudit $1 squid_client_packet_t:packet recv;";
}
if(iii==2330){
	add_number=0;
	raw_interface_name="corenet_sendrecv_squid_client_packets";
	add0="corenet_send_squid_client_packets($1)";
	add1="corenet_receive_squid_client_packets($1)";
	add_number =1;
}
if(iii==2331){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_squid_client_packets";
	add0="corenet_dontaudit_send_squid_client_packets($1)";
	add1="corenet_dontaudit_receive_squid_client_packets($1)";
	add_number =1;
}
if(iii==2332){
	add_number=0;
	raw_interface_name="corenet_relabelto_squid_client_packets";
	add0="allow $1 squid_client_packet_t:packet relabelto;";
}
if(iii==2333){
	add_number=0;
	raw_interface_name="corenet_send_squid_server_packets";
	add0="allow $1 squid_server_packet_t:packet send;";
}
if(iii==2334){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_squid_server_packets";
	add0="dontaudit $1 squid_server_packet_t:packet send;";
}
if(iii==2335){
	add_number=0;
	raw_interface_name="corenet_receive_squid_server_packets";
	add0="allow $1 squid_server_packet_t:packet recv;";
}
if(iii==2336){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_squid_server_packets";
	add0="dontaudit $1 squid_server_packet_t:packet recv;";
}
if(iii==2337){
	add_number=0;
	raw_interface_name="corenet_sendrecv_squid_server_packets";
	add0="corenet_send_squid_server_packets($1)";
	add1="corenet_receive_squid_server_packets($1)";
	add_number =1;
}
if(iii==2338){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_squid_server_packets";
	add0="corenet_dontaudit_send_squid_server_packets($1)";
	add1="corenet_dontaudit_receive_squid_server_packets($1)";
	add_number =1;
}
if(iii==2339){
	add_number=0;
	raw_interface_name="corenet_relabelto_squid_server_packets";
	add0="allow $1 squid_server_packet_t:packet relabelto;";
}
if(iii==2340){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_swat_port";
	add0="allow $1 swat_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2341){
	add_number=0;
	raw_interface_name="corenet_udp_send_swat_port";
	add0="allow $1 swat_port_t:udp_socket send_msg;";
}
if(iii==2342){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_swat_port";
	add0="dontaudit $1 swat_port_t:udp_socket send_msg;";
}
if(iii==2343){
	add_number=0;
	raw_interface_name="corenet_udp_receive_swat_port";
	add0="allow $1 swat_port_t:udp_socket recv_msg;";
}
if(iii==2344){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_swat_port";
	add0="dontaudit $1 swat_port_t:udp_socket recv_msg;";
}
if(iii==2345){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_swat_port";
	add0="corenet_udp_send_swat_port($1)";
	add1="corenet_udp_receive_swat_port($1)";
	add_number =1;
}
if(iii==2346){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_swat_port";
	add0="corenet_dontaudit_udp_send_swat_port($1)";
	add1="corenet_dontaudit_udp_receive_swat_port($1)";
	add_number =1;
}
if(iii==2347){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_swat_port";
	add0="allow $1 swat_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2348){
	add_number=0;
	raw_interface_name="corenet_udp_bind_swat_port";
	add0="allow $1 swat_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2349){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_swat_port";
	add0="allow $1 swat_port_t:tcp_socket name_connect;";
}
if(iii==2350){
	add_number=0;
	raw_interface_name="corenet_send_swat_client_packets";
	add0="allow $1 swat_client_packet_t:packet send;";
}
if(iii==2351){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_swat_client_packets";
	add0="dontaudit $1 swat_client_packet_t:packet send;";
}
if(iii==2352){
	add_number=0;
	raw_interface_name="corenet_receive_swat_client_packets";
	add0="allow $1 swat_client_packet_t:packet recv;";
}
if(iii==2353){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_swat_client_packets";
	add0="dontaudit $1 swat_client_packet_t:packet recv;";
}
if(iii==2354){
	add_number=0;
	raw_interface_name="corenet_sendrecv_swat_client_packets";
	add0="corenet_send_swat_client_packets($1)";
	add1="corenet_receive_swat_client_packets($1)";
	add_number =1;
}
if(iii==2355){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_swat_client_packets";
	add0="corenet_dontaudit_send_swat_client_packets($1)";
	add1="corenet_dontaudit_receive_swat_client_packets($1)";
	add_number =1;
}
if(iii==2356){
	add_number=0;
	raw_interface_name="corenet_relabelto_swat_client_packets";
	add0="allow $1 swat_client_packet_t:packet relabelto;";
}
if(iii==2357){
	add_number=0;
	raw_interface_name="corenet_send_swat_server_packets";
	add0="allow $1 swat_server_packet_t:packet send;";
}
if(iii==2358){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_swat_server_packets";
	add0="dontaudit $1 swat_server_packet_t:packet send;";
}
if(iii==2359){
	add_number=0;
	raw_interface_name="corenet_receive_swat_server_packets";
	add0="allow $1 swat_server_packet_t:packet recv;";
}
if(iii==2360){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_swat_server_packets";
	add0="dontaudit $1 swat_server_packet_t:packet recv;";
}
if(iii==2361){
	add_number=0;
	raw_interface_name="corenet_sendrecv_swat_server_packets";
	add0="corenet_send_swat_server_packets($1)";
	add1="corenet_receive_swat_server_packets($1)";
	add_number =1;
}
if(iii==2362){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_swat_server_packets";
	add0="corenet_dontaudit_send_swat_server_packets($1)";
	add1="corenet_dontaudit_receive_swat_server_packets($1)";
	add_number =1;
}
if(iii==2363){
	add_number=0;
	raw_interface_name="corenet_relabelto_swat_server_packets";
	add0="allow $1 swat_server_packet_t:packet relabelto;";
}
if(iii==2364){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_syslogd_port";
	add0="allow $1 syslogd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2365){
	add_number=0;
	raw_interface_name="corenet_udp_send_syslogd_port";
	add0="allow $1 syslogd_port_t:udp_socket send_msg;";
}
if(iii==2366){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_syslogd_port";
	add0="dontaudit $1 syslogd_port_t:udp_socket send_msg;";
}
if(iii==2367){
	add_number=0;
	raw_interface_name="corenet_udp_receive_syslogd_port";
	add0="allow $1 syslogd_port_t:udp_socket recv_msg;";
}
if(iii==2368){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_syslogd_port";
	add0="dontaudit $1 syslogd_port_t:udp_socket recv_msg;";
}
if(iii==2369){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_syslogd_port";
	add0="corenet_udp_send_syslogd_port($1)";
	add1="corenet_udp_receive_syslogd_port($1)";
	add_number =1;
}
if(iii==2370){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_syslogd_port";
	add0="corenet_dontaudit_udp_send_syslogd_port($1)";
	add1="corenet_dontaudit_udp_receive_syslogd_port($1)";
	add_number =1;
}
if(iii==2371){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_syslogd_port";
	add0="allow $1 syslogd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2372){
	add_number=0;
	raw_interface_name="corenet_udp_bind_syslogd_port";
	add0="allow $1 syslogd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2373){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_syslogd_port";
	add0="allow $1 syslogd_port_t:tcp_socket name_connect;";
}
if(iii==2374){
	add_number=0;
	raw_interface_name="corenet_send_syslogd_client_packets";
	add0="allow $1 syslogd_client_packet_t:packet send;";
}
if(iii==2375){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_syslogd_client_packets";
	add0="dontaudit $1 syslogd_client_packet_t:packet send;";
}
if(iii==2376){
	add_number=0;
	raw_interface_name="corenet_receive_syslogd_client_packets";
	add0="allow $1 syslogd_client_packet_t:packet recv;";
}
if(iii==2377){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_syslogd_client_packets";
	add0="dontaudit $1 syslogd_client_packet_t:packet recv;";
}
if(iii==2378){
	add_number=0;
	raw_interface_name="corenet_sendrecv_syslogd_client_packets";
	add0="corenet_send_syslogd_client_packets($1)";
	add1="corenet_receive_syslogd_client_packets($1)";
	add_number =1;
}
if(iii==2379){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_syslogd_client_packets";
	add0="corenet_dontaudit_send_syslogd_client_packets($1)";
	add1="corenet_dontaudit_receive_syslogd_client_packets($1)";
	add_number =1;
}
if(iii==2380){
	add_number=0;
	raw_interface_name="corenet_relabelto_syslogd_client_packets";
	add0="allow $1 syslogd_client_packet_t:packet relabelto;";
}
if(iii==2381){
	add_number=0;
	raw_interface_name="corenet_send_syslogd_server_packets";
	add0="allow $1 syslogd_server_packet_t:packet send;";
}
if(iii==2382){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_syslogd_server_packets";
	add0="dontaudit $1 syslogd_server_packet_t:packet send;";
}
if(iii==2383){
	add_number=0;
	raw_interface_name="corenet_receive_syslogd_server_packets";
	add0="allow $1 syslogd_server_packet_t:packet recv;";
}
if(iii==2384){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_syslogd_server_packets";
	add0="dontaudit $1 syslogd_server_packet_t:packet recv;";
}
if(iii==2385){
	add_number=0;
	raw_interface_name="corenet_sendrecv_syslogd_server_packets";
	add0="corenet_send_syslogd_server_packets($1)";
	add1="corenet_receive_syslogd_server_packets($1)";
	add_number =1;
}
if(iii==2386){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_syslogd_server_packets";
	add0="corenet_dontaudit_send_syslogd_server_packets($1)";
	add1="corenet_dontaudit_receive_syslogd_server_packets($1)";
	add_number =1;
}
if(iii==2387){
	add_number=0;
	raw_interface_name="corenet_relabelto_syslogd_server_packets";
	add0="allow $1 syslogd_server_packet_t:packet relabelto;";
}
if(iii==2388){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_telnetd_port";
	add0="allow $1 telnetd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2389){
	add_number=0;
	raw_interface_name="corenet_udp_send_telnetd_port";
	add0="allow $1 telnetd_port_t:udp_socket send_msg;";
}
if(iii==2390){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_telnetd_port";
	add0="dontaudit $1 telnetd_port_t:udp_socket send_msg;";
}
if(iii==2391){
	add_number=0;
	raw_interface_name="corenet_udp_receive_telnetd_port";
	add0="allow $1 telnetd_port_t:udp_socket recv_msg;";
}
if(iii==2392){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_telnetd_port";
	add0="dontaudit $1 telnetd_port_t:udp_socket recv_msg;";
}
if(iii==2393){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_telnetd_port";
	add0="corenet_udp_send_telnetd_port($1)";
	add1="corenet_udp_receive_telnetd_port($1)";
	add_number =1;
}
if(iii==2394){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_telnetd_port";
	add0="corenet_dontaudit_udp_send_telnetd_port($1)";
	add1="corenet_dontaudit_udp_receive_telnetd_port($1)";
	add_number =1;
}
if(iii==2395){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_telnetd_port";
	add0="allow $1 telnetd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2396){
	add_number=0;
	raw_interface_name="corenet_udp_bind_telnetd_port";
	add0="allow $1 telnetd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2397){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_telnetd_port";
	add0="allow $1 telnetd_port_t:tcp_socket name_connect;";
}
if(iii==2398){
	add_number=0;
	raw_interface_name="corenet_send_telnetd_client_packets";
	add0="allow $1 telnetd_client_packet_t:packet send;";
}
if(iii==2399){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_telnetd_client_packets";
	add0="dontaudit $1 telnetd_client_packet_t:packet send;";
}
if(iii==2400){
	add_number=0;
	raw_interface_name="corenet_receive_telnetd_client_packets";
	add0="allow $1 telnetd_client_packet_t:packet recv;";
}
if(iii==2401){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_telnetd_client_packets";
	add0="dontaudit $1 telnetd_client_packet_t:packet recv;";
}
if(iii==2402){
	add_number=0;
	raw_interface_name="corenet_sendrecv_telnetd_client_packets";
	add0="corenet_send_telnetd_client_packets($1)";
	add1="corenet_receive_telnetd_client_packets($1)";
	add_number =1;
}
if(iii==2403){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_telnetd_client_packets";
	add0="corenet_dontaudit_send_telnetd_client_packets($1)";
	add1="corenet_dontaudit_receive_telnetd_client_packets($1)";
	add_number =1;
}
if(iii==2404){
	add_number=0;
	raw_interface_name="corenet_relabelto_telnetd_client_packets";
	add0="allow $1 telnetd_client_packet_t:packet relabelto;";
}
if(iii==2405){
	add_number=0;
	raw_interface_name="corenet_send_telnetd_server_packets";
	add0="allow $1 telnetd_server_packet_t:packet send;";
}
if(iii==2406){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_telnetd_server_packets";
	add0="dontaudit $1 telnetd_server_packet_t:packet send;";
}
if(iii==2407){
	add_number=0;
	raw_interface_name="corenet_receive_telnetd_server_packets";
	add0="allow $1 telnetd_server_packet_t:packet recv;";
}
if(iii==2408){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_telnetd_server_packets";
	add0="dontaudit $1 telnetd_server_packet_t:packet recv;";
}
if(iii==2409){
	add_number=0;
	raw_interface_name="corenet_sendrecv_telnetd_server_packets";
	add0="corenet_send_telnetd_server_packets($1)";
	add1="corenet_receive_telnetd_server_packets($1)";
	add_number =1;
}
if(iii==2410){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_telnetd_server_packets";
	add0="corenet_dontaudit_send_telnetd_server_packets($1)";
	add1="corenet_dontaudit_receive_telnetd_server_packets($1)";
	add_number =1;
}
if(iii==2411){
	add_number=0;
	raw_interface_name="corenet_relabelto_telnetd_server_packets";
	add0="allow $1 telnetd_server_packet_t:packet relabelto;";
}
if(iii==2412){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_tftp_port";
	add0="allow $1 tftp_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2413){
	add_number=0;
	raw_interface_name="corenet_udp_send_tftp_port";
	add0="allow $1 tftp_port_t:udp_socket send_msg;";
}
if(iii==2414){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_tftp_port";
	add0="dontaudit $1 tftp_port_t:udp_socket send_msg;";
}
if(iii==2415){
	add_number=0;
	raw_interface_name="corenet_udp_receive_tftp_port";
	add0="allow $1 tftp_port_t:udp_socket recv_msg;";
}
if(iii==2416){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_tftp_port";
	add0="dontaudit $1 tftp_port_t:udp_socket recv_msg;";
}
if(iii==2417){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_tftp_port";
	add0="corenet_udp_send_tftp_port($1)";
	add1="corenet_udp_receive_tftp_port($1)";
	add_number =1;
}
if(iii==2418){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_tftp_port";
	add0="corenet_dontaudit_udp_send_tftp_port($1)";
	add1="corenet_dontaudit_udp_receive_tftp_port($1)";
	add_number =1;
}
if(iii==2419){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_tftp_port";
	add0="allow $1 tftp_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2420){
	add_number=0;
	raw_interface_name="corenet_udp_bind_tftp_port";
	add0="allow $1 tftp_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2421){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_tftp_port";
	add0="allow $1 tftp_port_t:tcp_socket name_connect;";
}
if(iii==2422){
	add_number=0;
	raw_interface_name="corenet_send_tftp_client_packets";
	add0="allow $1 tftp_client_packet_t:packet send;";
}
if(iii==2423){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_tftp_client_packets";
	add0="dontaudit $1 tftp_client_packet_t:packet send;";
}
if(iii==2424){
	add_number=0;
	raw_interface_name="corenet_receive_tftp_client_packets";
	add0="allow $1 tftp_client_packet_t:packet recv;";
}
if(iii==2425){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_tftp_client_packets";
	add0="dontaudit $1 tftp_client_packet_t:packet recv;";
}
if(iii==2426){
	add_number=0;
	raw_interface_name="corenet_sendrecv_tftp_client_packets";
	add0="corenet_send_tftp_client_packets($1)";
	add1="corenet_receive_tftp_client_packets($1)";
	add_number =1;
}
if(iii==2427){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_tftp_client_packets";
	add0="corenet_dontaudit_send_tftp_client_packets($1)";
	add1="corenet_dontaudit_receive_tftp_client_packets($1)";
	add_number =1;
}
if(iii==2428){
	add_number=0;
	raw_interface_name="corenet_relabelto_tftp_client_packets";
	add0="allow $1 tftp_client_packet_t:packet relabelto;";
}
if(iii==2429){
	add_number=0;
	raw_interface_name="corenet_send_tftp_server_packets";
	add0="allow $1 tftp_server_packet_t:packet send;";
}
if(iii==2430){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_tftp_server_packets";
	add0="dontaudit $1 tftp_server_packet_t:packet send;";
}
if(iii==2431){
	add_number=0;
	raw_interface_name="corenet_receive_tftp_server_packets";
	add0="allow $1 tftp_server_packet_t:packet recv;";
}
if(iii==2432){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_tftp_server_packets";
	add0="dontaudit $1 tftp_server_packet_t:packet recv;";
}
if(iii==2433){
	add_number=0;
	raw_interface_name="corenet_sendrecv_tftp_server_packets";
	add0="corenet_send_tftp_server_packets($1)";
	add1="corenet_receive_tftp_server_packets($1)";
	add_number =1;
}
if(iii==2434){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_tftp_server_packets";
	add0="corenet_dontaudit_send_tftp_server_packets($1)";
	add1="corenet_dontaudit_receive_tftp_server_packets($1)";
	add_number =1;
}
if(iii==2435){
	add_number=0;
	raw_interface_name="corenet_relabelto_tftp_server_packets";
	add0="allow $1 tftp_server_packet_t:packet relabelto;";
}
if(iii==2436){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_tor_port";
	add0="allow $1 tor_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2437){
	add_number=0;
	raw_interface_name="corenet_udp_send_tor_port";
	add0="allow $1 tor_port_t:udp_socket send_msg;";
}
if(iii==2438){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_tor_port";
	add0="dontaudit $1 tor_port_t:udp_socket send_msg;";
}
if(iii==2439){
	add_number=0;
	raw_interface_name="corenet_udp_receive_tor_port";
	add0="allow $1 tor_port_t:udp_socket recv_msg;";
}
if(iii==2440){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_tor_port";
	add0="dontaudit $1 tor_port_t:udp_socket recv_msg;";
}
if(iii==2441){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_tor_port";
	add0="corenet_udp_send_tor_port($1)";
	add1="corenet_udp_receive_tor_port($1)";
	add_number =1;
}
if(iii==2442){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_tor_port";
	add0="corenet_dontaudit_udp_send_tor_port($1)";
	add1="corenet_dontaudit_udp_receive_tor_port($1)";
	add_number =1;
}
if(iii==2443){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_tor_port";
	add0="allow $1 tor_port_t:tcp_socket name_bind;";
}
if(iii==2444){
	add_number=0;
	raw_interface_name="corenet_udp_bind_tor_port";
	add0="allow $1 tor_port_t:udp_socket name_bind;";
}
if(iii==2445){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_tor_port";
	add0="allow $1 tor_port_t:tcp_socket name_connect;";
}
if(iii==2446){
	add_number=0;
	raw_interface_name="corenet_send_tor_client_packets";
	add0="allow $1 tor_client_packet_t:packet send;";
}
if(iii==2447){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_tor_client_packets";
	add0="dontaudit $1 tor_client_packet_t:packet send;";
}
if(iii==2448){
	add_number=0;
	raw_interface_name="corenet_receive_tor_client_packets";
	add0="allow $1 tor_client_packet_t:packet recv;";
}
if(iii==2449){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_tor_client_packets";
	add0="dontaudit $1 tor_client_packet_t:packet recv;";
}
if(iii==2450){
	add_number=0;
	raw_interface_name="corenet_sendrecv_tor_client_packets";
	add0="corenet_send_tor_client_packets($1)";
	add1="corenet_receive_tor_client_packets($1)";
	add_number =1;
}
if(iii==2451){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_tor_client_packets";
	add0="corenet_dontaudit_send_tor_client_packets($1)";
	add1="corenet_dontaudit_receive_tor_client_packets($1)";
	add_number =1;
}
if(iii==2452){
	add_number=0;
	raw_interface_name="corenet_relabelto_tor_client_packets";
	add0="allow $1 tor_client_packet_t:packet relabelto;";
}
if(iii==2453){
	add_number=0;
	raw_interface_name="corenet_send_tor_server_packets";
	add0="allow $1 tor_server_packet_t:packet send;";
}
if(iii==2454){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_tor_server_packets";
	add0="dontaudit $1 tor_server_packet_t:packet send;";
}
if(iii==2455){
	add_number=0;
	raw_interface_name="corenet_receive_tor_server_packets";
	add0="allow $1 tor_server_packet_t:packet recv;";
}
if(iii==2456){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_tor_server_packets";
	add0="dontaudit $1 tor_server_packet_t:packet recv;";
}
if(iii==2457){
	add_number=0;
	raw_interface_name="corenet_sendrecv_tor_server_packets";
	add0="corenet_send_tor_server_packets($1)";
	add1="corenet_receive_tor_server_packets($1)";
	add_number =1;
}
if(iii==2458){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_tor_server_packets";
	add0="corenet_dontaudit_send_tor_server_packets($1)";
	add1="corenet_dontaudit_receive_tor_server_packets($1)";
	add_number =1;
}
if(iii==2459){
	add_number=0;
	raw_interface_name="corenet_relabelto_tor_server_packets";
	add0="allow $1 tor_server_packet_t:packet relabelto;";
}
if(iii==2460){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_traceroute_port";
	add0="allow $1 traceroute_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2461){
	add_number=0;
	raw_interface_name="corenet_udp_send_traceroute_port";
	add0="allow $1 traceroute_port_t:udp_socket send_msg;";
}
if(iii==2462){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_traceroute_port";
	add0="dontaudit $1 traceroute_port_t:udp_socket send_msg;";
}
if(iii==2463){
	add_number=0;
	raw_interface_name="corenet_udp_receive_traceroute_port";
	add0="allow $1 traceroute_port_t:udp_socket recv_msg;";
}
if(iii==2464){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_traceroute_port";
	add0="dontaudit $1 traceroute_port_t:udp_socket recv_msg;";
}
if(iii==2465){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_traceroute_port";
	add0="corenet_udp_send_traceroute_port($1)";
	add1="corenet_udp_receive_traceroute_port($1)";
	add_number =1;
}
if(iii==2466){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_traceroute_port";
	add0="corenet_dontaudit_udp_send_traceroute_port($1)";
	add1="corenet_dontaudit_udp_receive_traceroute_port($1)";
	add_number =1;
}
if(iii==2467){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_traceroute_port";
	add0="allow $1 traceroute_port_t:tcp_socket name_bind;";
}
if(iii==2468){
	add_number=0;
	raw_interface_name="corenet_udp_bind_traceroute_port";
	add0="allow $1 traceroute_port_t:udp_socket name_bind;";
}
if(iii==2469){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_traceroute_port";
	add0="allow $1 traceroute_port_t:tcp_socket name_connect;";
}
if(iii==2470){
	add_number=0;
	raw_interface_name="corenet_send_traceroute_client_packets";
	add0="allow $1 traceroute_client_packet_t:packet send;";
}
if(iii==2471){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_traceroute_client_packets";
	add0="dontaudit $1 traceroute_client_packet_t:packet send;";
}
if(iii==2472){
	add_number=0;
	raw_interface_name="corenet_receive_traceroute_client_packets";
	add0="allow $1 traceroute_client_packet_t:packet recv;";
}
if(iii==2473){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_traceroute_client_packets";
	add0="dontaudit $1 traceroute_client_packet_t:packet recv;";
}
if(iii==2474){
	add_number=0;
	raw_interface_name="corenet_sendrecv_traceroute_client_packets";
	add0="corenet_send_traceroute_client_packets($1)";
	add1="corenet_receive_traceroute_client_packets($1)";
	add_number =1;
}
if(iii==2475){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_traceroute_client_packets";
	add0="corenet_dontaudit_send_traceroute_client_packets($1)";
	add1="corenet_dontaudit_receive_traceroute_client_packets($1)";
	add_number =1;
}
if(iii==2476){
	add_number=0;
	raw_interface_name="corenet_relabelto_traceroute_client_packets";
	add0="allow $1 traceroute_client_packet_t:packet relabelto;";
}
if(iii==2477){
	add_number=0;
	raw_interface_name="corenet_send_traceroute_server_packets";
	add0="allow $1 traceroute_server_packet_t:packet send;";
}
if(iii==2478){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_traceroute_server_packets";
	add0="dontaudit $1 traceroute_server_packet_t:packet send;";
}
if(iii==2479){
	add_number=0;
	raw_interface_name="corenet_receive_traceroute_server_packets";
	add0="allow $1 traceroute_server_packet_t:packet recv;";
}
if(iii==2480){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_traceroute_server_packets";
	add0="dontaudit $1 traceroute_server_packet_t:packet recv;";
}
if(iii==2481){
	add_number=0;
	raw_interface_name="corenet_sendrecv_traceroute_server_packets";
	add0="corenet_send_traceroute_server_packets($1)";
	add1="corenet_receive_traceroute_server_packets($1)";
	add_number =1;
}
if(iii==2482){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_traceroute_server_packets";
	add0="corenet_dontaudit_send_traceroute_server_packets($1)";
	add1="corenet_dontaudit_receive_traceroute_server_packets($1)";
	add_number =1;
}
if(iii==2483){
	add_number=0;
	raw_interface_name="corenet_relabelto_traceroute_server_packets";
	add0="allow $1 traceroute_server_packet_t:packet relabelto;";
}
if(iii==2484){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_transproxy_port";
	add0="allow $1 transproxy_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2485){
	add_number=0;
	raw_interface_name="corenet_udp_send_transproxy_port";
	add0="allow $1 transproxy_port_t:udp_socket send_msg;";
}
if(iii==2486){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_transproxy_port";
	add0="dontaudit $1 transproxy_port_t:udp_socket send_msg;";
}
if(iii==2487){
	add_number=0;
	raw_interface_name="corenet_udp_receive_transproxy_port";
	add0="allow $1 transproxy_port_t:udp_socket recv_msg;";
}
if(iii==2488){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_transproxy_port";
	add0="dontaudit $1 transproxy_port_t:udp_socket recv_msg;";
}
if(iii==2489){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_transproxy_port";
	add0="corenet_udp_send_transproxy_port($1)";
	add1="corenet_udp_receive_transproxy_port($1)";
	add_number =1;
}
if(iii==2490){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_transproxy_port";
	add0="corenet_dontaudit_udp_send_transproxy_port($1)";
	add1="corenet_dontaudit_udp_receive_transproxy_port($1)";
	add_number =1;
}
if(iii==2491){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_transproxy_port";
	add0="allow $1 transproxy_port_t:tcp_socket name_bind;";
}
if(iii==2492){
	add_number=0;
	raw_interface_name="corenet_udp_bind_transproxy_port";
	add0="allow $1 transproxy_port_t:udp_socket name_bind;";
}
if(iii==2493){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_transproxy_port";
	add0="allow $1 transproxy_port_t:tcp_socket name_connect;";
}
if(iii==2494){
	add_number=0;
	raw_interface_name="corenet_send_transproxy_client_packets";
	add0="allow $1 transproxy_client_packet_t:packet send;";
}
if(iii==2495){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_transproxy_client_packets";
	add0="dontaudit $1 transproxy_client_packet_t:packet send;";
}
if(iii==2496){
	add_number=0;
	raw_interface_name="corenet_receive_transproxy_client_packets";
	add0="allow $1 transproxy_client_packet_t:packet recv;";
}
if(iii==2497){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_transproxy_client_packets";
	add0="dontaudit $1 transproxy_client_packet_t:packet recv;";
}
if(iii==2498){
	add_number=0;
	raw_interface_name="corenet_sendrecv_transproxy_client_packets";
	add0="corenet_send_transproxy_client_packets($1)";
	add1="corenet_receive_transproxy_client_packets($1)";
	add_number =1;
}
if(iii==2499){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_transproxy_client_packets";
	add0="corenet_dontaudit_send_transproxy_client_packets($1)";
	add1="corenet_dontaudit_receive_transproxy_client_packets($1)";
	add_number =1;
}
if(iii==2500){
	add_number=0;
	raw_interface_name="corenet_relabelto_transproxy_client_packets";
	add0="allow $1 transproxy_client_packet_t:packet relabelto;";
}
if(iii==2501){
	add_number=0;
	raw_interface_name="corenet_send_transproxy_server_packets";
	add0="allow $1 transproxy_server_packet_t:packet send;";
}
if(iii==2502){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_transproxy_server_packets";
	add0="dontaudit $1 transproxy_server_packet_t:packet send;";
}
if(iii==2503){
	add_number=0;
	raw_interface_name="corenet_receive_transproxy_server_packets";
	add0="allow $1 transproxy_server_packet_t:packet recv;";
}
if(iii==2504){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_transproxy_server_packets";
	add0="dontaudit $1 transproxy_server_packet_t:packet recv;";
}
if(iii==2505){
	add_number=0;
	raw_interface_name="corenet_sendrecv_transproxy_server_packets";
	add0="corenet_send_transproxy_server_packets($1)";
	add1="corenet_receive_transproxy_server_packets($1)";
	add_number =1;
}
if(iii==2506){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_transproxy_server_packets";
	add0="corenet_dontaudit_send_transproxy_server_packets($1)";
	add1="corenet_dontaudit_receive_transproxy_server_packets($1)";
	add_number =1;
}
if(iii==2507){
	add_number=0;
	raw_interface_name="corenet_relabelto_transproxy_server_packets";
	add0="allow $1 transproxy_server_packet_t:packet relabelto;";
}
if(iii==2508){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_uucpd_port";
	add0="allow $1 uucpd_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2509){
	add_number=0;
	raw_interface_name="corenet_udp_send_uucpd_port";
	add0="allow $1 uucpd_port_t:udp_socket send_msg;";
}
if(iii==2510){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_uucpd_port";
	add0="dontaudit $1 uucpd_port_t:udp_socket send_msg;";
}
if(iii==2511){
	add_number=0;
	raw_interface_name="corenet_udp_receive_uucpd_port";
	add0="allow $1 uucpd_port_t:udp_socket recv_msg;";
}
if(iii==2512){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_uucpd_port";
	add0="dontaudit $1 uucpd_port_t:udp_socket recv_msg;";
}
if(iii==2513){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_uucpd_port";
	add0="corenet_udp_send_uucpd_port($1)";
	add1="corenet_udp_receive_uucpd_port($1)";
	add_number =1;
}
if(iii==2514){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_uucpd_port";
	add0="corenet_dontaudit_udp_send_uucpd_port($1)";
	add1="corenet_dontaudit_udp_receive_uucpd_port($1)";
	add_number =1;
}
if(iii==2515){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_uucpd_port";
	add0="allow $1 uucpd_port_t:tcp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2516){
	add_number=0;
	raw_interface_name="corenet_udp_bind_uucpd_port";
	add0="allow $1 uucpd_port_t:udp_socket name_bind;";
	add1="allow $1 self:capability net_bind_service;";
	add_number =1;
}
if(iii==2517){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_uucpd_port";
	add0="allow $1 uucpd_port_t:tcp_socket name_connect;";
}
if(iii==2518){
	add_number=0;
	raw_interface_name="corenet_send_uucpd_client_packets";
	add0="allow $1 uucpd_client_packet_t:packet send;";
}
if(iii==2519){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_uucpd_client_packets";
	add0="dontaudit $1 uucpd_client_packet_t:packet send;";
}
if(iii==2520){
	add_number=0;
	raw_interface_name="corenet_receive_uucpd_client_packets";
	add0="allow $1 uucpd_client_packet_t:packet recv;";
}
if(iii==2521){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_uucpd_client_packets";
	add0="dontaudit $1 uucpd_client_packet_t:packet recv;";
}
if(iii==2522){
	add_number=0;
	raw_interface_name="corenet_sendrecv_uucpd_client_packets";
	add0="corenet_send_uucpd_client_packets($1)";
	add1="corenet_receive_uucpd_client_packets($1)";
	add_number =1;
}
if(iii==2523){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_uucpd_client_packets";
	add0="corenet_dontaudit_send_uucpd_client_packets($1)";
	add1="corenet_dontaudit_receive_uucpd_client_packets($1)";
	add_number =1;
}
if(iii==2524){
	add_number=0;
	raw_interface_name="corenet_relabelto_uucpd_client_packets";
	add0="allow $1 uucpd_client_packet_t:packet relabelto;";
}
if(iii==2525){
	add_number=0;
	raw_interface_name="corenet_send_uucpd_server_packets";
	add0="allow $1 uucpd_server_packet_t:packet send;";
}
if(iii==2526){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_uucpd_server_packets";
	add0="dontaudit $1 uucpd_server_packet_t:packet send;";
}
if(iii==2527){
	add_number=0;
	raw_interface_name="corenet_receive_uucpd_server_packets";
	add0="allow $1 uucpd_server_packet_t:packet recv;";
}
if(iii==2528){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_uucpd_server_packets";
	add0="dontaudit $1 uucpd_server_packet_t:packet recv;";
}
if(iii==2529){
	add_number=0;
	raw_interface_name="corenet_sendrecv_uucpd_server_packets";
	add0="corenet_send_uucpd_server_packets($1)";
	add1="corenet_receive_uucpd_server_packets($1)";
	add_number =1;
}
if(iii==2530){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_uucpd_server_packets";
	add0="corenet_dontaudit_send_uucpd_server_packets($1)";
	add1="corenet_dontaudit_receive_uucpd_server_packets($1)";
	add_number =1;
}
if(iii==2531){
	add_number=0;
	raw_interface_name="corenet_relabelto_uucpd_server_packets";
	add0="allow $1 uucpd_server_packet_t:packet relabelto;";
}
if(iii==2532){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_vnc_port";
	add0="allow $1 vnc_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2533){
	add_number=0;
	raw_interface_name="corenet_udp_send_vnc_port";
	add0="allow $1 vnc_port_t:udp_socket send_msg;";
}
if(iii==2534){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_vnc_port";
	add0="dontaudit $1 vnc_port_t:udp_socket send_msg;";
}
if(iii==2535){
	add_number=0;
	raw_interface_name="corenet_udp_receive_vnc_port";
	add0="allow $1 vnc_port_t:udp_socket recv_msg;";
}
if(iii==2536){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_vnc_port";
	add0="dontaudit $1 vnc_port_t:udp_socket recv_msg;";
}
if(iii==2537){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_vnc_port";
	add0="corenet_udp_send_vnc_port($1)";
	add1="corenet_udp_receive_vnc_port($1)";
	add_number =1;
}
if(iii==2538){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_vnc_port";
	add0="corenet_dontaudit_udp_send_vnc_port($1)";
	add1="corenet_dontaudit_udp_receive_vnc_port($1)";
	add_number =1;
}
if(iii==2539){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_vnc_port";
	add0="allow $1 vnc_port_t:tcp_socket name_bind;";
}
if(iii==2540){
	add_number=0;
	raw_interface_name="corenet_udp_bind_vnc_port";
	add0="allow $1 vnc_port_t:udp_socket name_bind;";
}
if(iii==2541){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_vnc_port";
	add0="allow $1 vnc_port_t:tcp_socket name_connect;";
}
if(iii==2542){
	add_number=0;
	raw_interface_name="corenet_send_vnc_client_packets";
	add0="allow $1 vnc_client_packet_t:packet send;";
}
if(iii==2543){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_vnc_client_packets";
	add0="dontaudit $1 vnc_client_packet_t:packet send;";
}
if(iii==2544){
	add_number=0;
	raw_interface_name="corenet_receive_vnc_client_packets";
	add0="allow $1 vnc_client_packet_t:packet recv;";
}
if(iii==2545){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_vnc_client_packets";
	add0="dontaudit $1 vnc_client_packet_t:packet recv;";
}
if(iii==2546){
	add_number=0;
	raw_interface_name="corenet_sendrecv_vnc_client_packets";
	add0="corenet_send_vnc_client_packets($1)";
	add1="corenet_receive_vnc_client_packets($1)";
	add_number =1;
}
if(iii==2547){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_vnc_client_packets";
	add0="corenet_dontaudit_send_vnc_client_packets($1)";
	add1="corenet_dontaudit_receive_vnc_client_packets($1)";
	add_number =1;
}
if(iii==2548){
	add_number=0;
	raw_interface_name="corenet_relabelto_vnc_client_packets";
	add0="allow $1 vnc_client_packet_t:packet relabelto;";
}
if(iii==2549){
	add_number=0;
	raw_interface_name="corenet_send_vnc_server_packets";
	add0="allow $1 vnc_server_packet_t:packet send;";
}
if(iii==2550){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_vnc_server_packets";
	add0="dontaudit $1 vnc_server_packet_t:packet send;";
}
if(iii==2551){
	add_number=0;
	raw_interface_name="corenet_receive_vnc_server_packets";
	add0="allow $1 vnc_server_packet_t:packet recv;";
}
if(iii==2552){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_vnc_server_packets";
	add0="dontaudit $1 vnc_server_packet_t:packet recv;";
}
if(iii==2553){
	add_number=0;
	raw_interface_name="corenet_sendrecv_vnc_server_packets";
	add0="corenet_send_vnc_server_packets($1)";
	add1="corenet_receive_vnc_server_packets($1)";
	add_number =1;
}
if(iii==2554){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_vnc_server_packets";
	add0="corenet_dontaudit_send_vnc_server_packets($1)";
	add1="corenet_dontaudit_receive_vnc_server_packets($1)";
	add_number =1;
}
if(iii==2555){
	add_number=0;
	raw_interface_name="corenet_relabelto_vnc_server_packets";
	add0="allow $1 vnc_server_packet_t:packet relabelto;";
}
if(iii==2556){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_xen_port";
	add0="allow $1 xen_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2557){
	add_number=0;
	raw_interface_name="corenet_udp_send_xen_port";
	add0="allow $1 xen_port_t:udp_socket send_msg;";
}
if(iii==2558){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_xen_port";
	add0="dontaudit $1 xen_port_t:udp_socket send_msg;";
}
if(iii==2559){
	add_number=0;
	raw_interface_name="corenet_udp_receive_xen_port";
	add0="allow $1 xen_port_t:udp_socket recv_msg;";
}
if(iii==2560){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_xen_port";
	add0="dontaudit $1 xen_port_t:udp_socket recv_msg;";
}
if(iii==2561){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_xen_port";
	add0="corenet_udp_send_xen_port($1)";
	add1="corenet_udp_receive_xen_port($1)";
	add_number =1;
}
if(iii==2562){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_xen_port";
	add0="corenet_dontaudit_udp_send_xen_port($1)";
	add1="corenet_dontaudit_udp_receive_xen_port($1)";
	add_number =1;
}
if(iii==2563){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_xen_port";
	add0="allow $1 xen_port_t:tcp_socket name_bind;";
}
if(iii==2564){
	add_number=0;
	raw_interface_name="corenet_udp_bind_xen_port";
	add0="allow $1 xen_port_t:udp_socket name_bind;";
}
if(iii==2565){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_xen_port";
	add0="allow $1 xen_port_t:tcp_socket name_connect;";
}
if(iii==2566){
	add_number=0;
	raw_interface_name="corenet_send_xen_client_packets";
	add0="allow $1 xen_client_packet_t:packet send;";
}
if(iii==2567){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_xen_client_packets";
	add0="dontaudit $1 xen_client_packet_t:packet send;";
}
if(iii==2568){
	add_number=0;
	raw_interface_name="corenet_receive_xen_client_packets";
	add0="allow $1 xen_client_packet_t:packet recv;";
}
if(iii==2569){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_xen_client_packets";
	add0="dontaudit $1 xen_client_packet_t:packet recv;";
}
if(iii==2570){
	add_number=0;
	raw_interface_name="corenet_sendrecv_xen_client_packets";
	add0="corenet_send_xen_client_packets($1)";
	add1="corenet_receive_xen_client_packets($1)";
	add_number =1;
}
if(iii==2571){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_xen_client_packets";
	add0="corenet_dontaudit_send_xen_client_packets($1)";
	add1="corenet_dontaudit_receive_xen_client_packets($1)";
	add_number =1;
}
if(iii==2572){
	add_number=0;
	raw_interface_name="corenet_relabelto_xen_client_packets";
	add0="allow $1 xen_client_packet_t:packet relabelto;";
}
if(iii==2573){
	add_number=0;
	raw_interface_name="corenet_send_xen_server_packets";
	add0="allow $1 xen_server_packet_t:packet send;";
}
if(iii==2574){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_xen_server_packets";
	add0="dontaudit $1 xen_server_packet_t:packet send;";
}
if(iii==2575){
	add_number=0;
	raw_interface_name="corenet_receive_xen_server_packets";
	add0="allow $1 xen_server_packet_t:packet recv;";
}
if(iii==2576){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_xen_server_packets";
	add0="dontaudit $1 xen_server_packet_t:packet recv;";
}
if(iii==2577){
	add_number=0;
	raw_interface_name="corenet_sendrecv_xen_server_packets";
	add0="corenet_send_xen_server_packets($1)";
	add1="corenet_receive_xen_server_packets($1)";
	add_number =1;
}
if(iii==2578){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_xen_server_packets";
	add0="corenet_dontaudit_send_xen_server_packets($1)";
	add1="corenet_dontaudit_receive_xen_server_packets($1)";
	add_number =1;
}
if(iii==2579){
	add_number=0;
	raw_interface_name="corenet_relabelto_xen_server_packets";
	add0="allow $1 xen_server_packet_t:packet relabelto;";
}
if(iii==2580){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_xserver_port";
	add0="allow $1 xserver_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2581){
	add_number=0;
	raw_interface_name="corenet_udp_send_xserver_port";
	add0="allow $1 xserver_port_t:udp_socket send_msg;";
}
if(iii==2582){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_xserver_port";
	add0="dontaudit $1 xserver_port_t:udp_socket send_msg;";
}
if(iii==2583){
	add_number=0;
	raw_interface_name="corenet_udp_receive_xserver_port";
	add0="allow $1 xserver_port_t:udp_socket recv_msg;";
}
if(iii==2584){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_xserver_port";
	add0="dontaudit $1 xserver_port_t:udp_socket recv_msg;";
}
if(iii==2585){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_xserver_port";
	add0="corenet_udp_send_xserver_port($1)";
	add1="corenet_udp_receive_xserver_port($1)";
	add_number =1;
}
if(iii==2586){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_xserver_port";
	add0="corenet_dontaudit_udp_send_xserver_port($1)";
	add1="corenet_dontaudit_udp_receive_xserver_port($1)";
	add_number =1;
}
if(iii==2587){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_xserver_port";
	add0="allow $1 xserver_port_t:tcp_socket name_bind;";
}
if(iii==2588){
	add_number=0;
	raw_interface_name="corenet_udp_bind_xserver_port";
	add0="allow $1 xserver_port_t:udp_socket name_bind;";
}
if(iii==2589){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_xserver_port";
	add0="allow $1 xserver_port_t:tcp_socket name_connect;";
}
if(iii==2590){
	add_number=0;
	raw_interface_name="corenet_send_xserver_client_packets";
	add0="allow $1 xserver_client_packet_t:packet send;";
}
if(iii==2591){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_xserver_client_packets";
	add0="dontaudit $1 xserver_client_packet_t:packet send;";
}
if(iii==2592){
	add_number=0;
	raw_interface_name="corenet_receive_xserver_client_packets";
	add0="allow $1 xserver_client_packet_t:packet recv;";
}
if(iii==2593){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_xserver_client_packets";
	add0="dontaudit $1 xserver_client_packet_t:packet recv;";
}
if(iii==2594){
	add_number=0;
	raw_interface_name="corenet_sendrecv_xserver_client_packets";
	add0="corenet_send_xserver_client_packets($1)";
	add1="corenet_receive_xserver_client_packets($1)";
	add_number =1;
}
if(iii==2595){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_xserver_client_packets";
	add0="corenet_dontaudit_send_xserver_client_packets($1)";
	add1="corenet_dontaudit_receive_xserver_client_packets($1)";
	add_number =1;
}
if(iii==2596){
	add_number=0;
	raw_interface_name="corenet_relabelto_xserver_client_packets";
	add0="allow $1 xserver_client_packet_t:packet relabelto;";
}
if(iii==2597){
	add_number=0;
	raw_interface_name="corenet_send_xserver_server_packets";
	add0="allow $1 xserver_server_packet_t:packet send;";
}
if(iii==2598){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_xserver_server_packets";
	add0="dontaudit $1 xserver_server_packet_t:packet send;";
}
if(iii==2599){
	add_number=0;
	raw_interface_name="corenet_receive_xserver_server_packets";
	add0="allow $1 xserver_server_packet_t:packet recv;";
}
if(iii==2600){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_xserver_server_packets";
	add0="dontaudit $1 xserver_server_packet_t:packet recv;";
}
if(iii==2601){
	add_number=0;
	raw_interface_name="corenet_sendrecv_xserver_server_packets";
	add0="corenet_send_xserver_server_packets($1)";
	add1="corenet_receive_xserver_server_packets($1)";
	add_number =1;
}
if(iii==2602){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_xserver_server_packets";
	add0="corenet_dontaudit_send_xserver_server_packets($1)";
	add1="corenet_dontaudit_receive_xserver_server_packets($1)";
	add_number =1;
}
if(iii==2603){
	add_number=0;
	raw_interface_name="corenet_relabelto_xserver_server_packets";
	add0="allow $1 xserver_server_packet_t:packet relabelto;";
}
if(iii==2604){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_zebra_port";
	add0="allow $1 zebra_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2605){
	add_number=0;
	raw_interface_name="corenet_udp_send_zebra_port";
	add0="allow $1 zebra_port_t:udp_socket send_msg;";
}
if(iii==2606){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_zebra_port";
	add0="dontaudit $1 zebra_port_t:udp_socket send_msg;";
}
if(iii==2607){
	add_number=0;
	raw_interface_name="corenet_udp_receive_zebra_port";
	add0="allow $1 zebra_port_t:udp_socket recv_msg;";
}
if(iii==2608){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_zebra_port";
	add0="dontaudit $1 zebra_port_t:udp_socket recv_msg;";
}
if(iii==2609){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_zebra_port";
	add0="corenet_udp_send_zebra_port($1)";
	add1="corenet_udp_receive_zebra_port($1)";
	add_number =1;
}
if(iii==2610){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_zebra_port";
	add0="corenet_dontaudit_udp_send_zebra_port($1)";
	add1="corenet_dontaudit_udp_receive_zebra_port($1)";
	add_number =1;
}
if(iii==2611){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_zebra_port";
	add0="allow $1 zebra_port_t:tcp_socket name_bind;";
}
if(iii==2612){
	add_number=0;
	raw_interface_name="corenet_udp_bind_zebra_port";
	add0="allow $1 zebra_port_t:udp_socket name_bind;";
}
if(iii==2613){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_zebra_port";
	add0="allow $1 zebra_port_t:tcp_socket name_connect;";
}
if(iii==2614){
	add_number=0;
	raw_interface_name="corenet_send_zebra_client_packets";
	add0="allow $1 zebra_client_packet_t:packet send;";
}
if(iii==2615){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_zebra_client_packets";
	add0="dontaudit $1 zebra_client_packet_t:packet send;";
}
if(iii==2616){
	add_number=0;
	raw_interface_name="corenet_receive_zebra_client_packets";
	add0="allow $1 zebra_client_packet_t:packet recv;";
}
if(iii==2617){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_zebra_client_packets";
	add0="dontaudit $1 zebra_client_packet_t:packet recv;";
}
if(iii==2618){
	add_number=0;
	raw_interface_name="corenet_sendrecv_zebra_client_packets";
	add0="corenet_send_zebra_client_packets($1)";
	add1="corenet_receive_zebra_client_packets($1)";
	add_number =1;
}
if(iii==2619){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_zebra_client_packets";
	add0="corenet_dontaudit_send_zebra_client_packets($1)";
	add1="corenet_dontaudit_receive_zebra_client_packets($1)";
	add_number =1;
}
if(iii==2620){
	add_number=0;
	raw_interface_name="corenet_relabelto_zebra_client_packets";
	add0="allow $1 zebra_client_packet_t:packet relabelto;";
}
if(iii==2621){
	add_number=0;
	raw_interface_name="corenet_send_zebra_server_packets";
	add0="allow $1 zebra_server_packet_t:packet send;";
}
if(iii==2622){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_zebra_server_packets";
	add0="dontaudit $1 zebra_server_packet_t:packet send;";
}
if(iii==2623){
	add_number=0;
	raw_interface_name="corenet_receive_zebra_server_packets";
	add0="allow $1 zebra_server_packet_t:packet recv;";
}
if(iii==2624){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_zebra_server_packets";
	add0="dontaudit $1 zebra_server_packet_t:packet recv;";
}
if(iii==2625){
	add_number=0;
	raw_interface_name="corenet_sendrecv_zebra_server_packets";
	add0="corenet_send_zebra_server_packets($1)";
	add1="corenet_receive_zebra_server_packets($1)";
	add_number =1;
}
if(iii==2626){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_zebra_server_packets";
	add0="corenet_dontaudit_send_zebra_server_packets($1)";
	add1="corenet_dontaudit_receive_zebra_server_packets($1)";
	add_number =1;
}
if(iii==2627){
	add_number=0;
	raw_interface_name="corenet_relabelto_zebra_server_packets";
	add0="allow $1 zebra_server_packet_t:packet relabelto;";
}
if(iii==2628){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_zope_port";
	add0="allow $1 zope_port_t:tcp_socket { send_msg recv_msg };";
}
if(iii==2629){
	add_number=0;
	raw_interface_name="corenet_udp_send_zope_port";
	add0="allow $1 zope_port_t:udp_socket send_msg;";
}
if(iii==2630){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_send_zope_port";
	add0="dontaudit $1 zope_port_t:udp_socket send_msg;";
}
if(iii==2631){
	add_number=0;
	raw_interface_name="corenet_udp_receive_zope_port";
	add0="allow $1 zope_port_t:udp_socket recv_msg;";
}
if(iii==2632){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_receive_zope_port";
	add0="dontaudit $1 zope_port_t:udp_socket recv_msg;";
}
if(iii==2633){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_zope_port";
	add0="corenet_udp_send_zope_port($1)";
	add1="corenet_udp_receive_zope_port($1)";
	add_number =1;
}
if(iii==2634){
	add_number=0;
	raw_interface_name="corenet_dontaudit_udp_sendrecv_zope_port";
	add0="corenet_dontaudit_udp_send_zope_port($1)";
	add1="corenet_dontaudit_udp_receive_zope_port($1)";
	add_number =1;
}
if(iii==2635){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_zope_port";
	add0="allow $1 zope_port_t:tcp_socket name_bind;";
}
if(iii==2636){
	add_number=0;
	raw_interface_name="corenet_udp_bind_zope_port";
	add0="allow $1 zope_port_t:udp_socket name_bind;";
}
if(iii==2637){
	add_number=0;
	raw_interface_name="corenet_tcp_connect_zope_port";
	add0="allow $1 zope_port_t:tcp_socket name_connect;";
}
if(iii==2638){
	add_number=0;
	raw_interface_name="corenet_send_zope_client_packets";
	add0="allow $1 zope_client_packet_t:packet send;";
}
if(iii==2639){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_zope_client_packets";
	add0="dontaudit $1 zope_client_packet_t:packet send;";
}
if(iii==2640){
	add_number=0;
	raw_interface_name="corenet_receive_zope_client_packets";
	add0="allow $1 zope_client_packet_t:packet recv;";
}
if(iii==2641){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_zope_client_packets";
	add0="dontaudit $1 zope_client_packet_t:packet recv;";
}
if(iii==2642){
	add_number=0;
	raw_interface_name="corenet_sendrecv_zope_client_packets";
	add0="corenet_send_zope_client_packets($1)";
	add1="corenet_receive_zope_client_packets($1)";
	add_number =1;
}
if(iii==2643){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_zope_client_packets";
	add0="corenet_dontaudit_send_zope_client_packets($1)";
	add1="corenet_dontaudit_receive_zope_client_packets($1)";
	add_number =1;
}
if(iii==2644){
	add_number=0;
	raw_interface_name="corenet_relabelto_zope_client_packets";
	add0="allow $1 zope_client_packet_t:packet relabelto;";
}
if(iii==2645){
	add_number=0;
	raw_interface_name="corenet_send_zope_server_packets";
	add0="allow $1 zope_server_packet_t:packet send;";
}
if(iii==2646){
	add_number=0;
	raw_interface_name="corenet_dontaudit_send_zope_server_packets";
	add0="dontaudit $1 zope_server_packet_t:packet send;";
}
if(iii==2647){
	add_number=0;
	raw_interface_name="corenet_receive_zope_server_packets";
	add0="allow $1 zope_server_packet_t:packet recv;";
}
if(iii==2648){
	add_number=0;
	raw_interface_name="corenet_dontaudit_receive_zope_server_packets";
	add0="dontaudit $1 zope_server_packet_t:packet recv;";
}
if(iii==2649){
	add_number=0;
	raw_interface_name="corenet_sendrecv_zope_server_packets";
	add0="corenet_send_zope_server_packets($1)";
	add1="corenet_receive_zope_server_packets($1)";
	add_number =1;
}
if(iii==2650){
	add_number=0;
	raw_interface_name="corenet_dontaudit_sendrecv_zope_server_packets";
	add0="corenet_dontaudit_send_zope_server_packets($1)";
	add1="corenet_dontaudit_receive_zope_server_packets($1)";
	add_number =1;
}
if(iii==2651){
	add_number=0;
	raw_interface_name="corenet_relabelto_zope_server_packets";
	add0="allow $1 zope_server_packet_t:packet relabelto;";
}
if(iii==2652){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_compat_ipv4_node";
	add0="allow $1 compat_ipv4_node_t:node { tcp_send tcp_recv };";
}
if(iii==2653){
	add_number=0;
	raw_interface_name="corenet_udp_send_compat_ipv4_node";
	add0="allow $1 compat_ipv4_node_t:node udp_send;";
}
if(iii==2654){
	add_number=0;
	raw_interface_name="corenet_udp_receive_compat_ipv4_node";
	add0="allow $1 compat_ipv4_node_t:node udp_recv;";
}
if(iii==2655){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_compat_ipv4_node";
	add0="corenet_udp_send_compat_ipv4_node($1)";
	add1="corenet_udp_receive_compat_ipv4_node($1)";
	add_number =1;
}
if(iii==2656){
	add_number=0;
	raw_interface_name="corenet_raw_send_compat_ipv4_node";
	add0="allow $1 compat_ipv4_node_t:node rawip_send;";
}
if(iii==2657){
	add_number=0;
	raw_interface_name="corenet_raw_receive_compat_ipv4_node";
	add0="allow $1 compat_ipv4_node_t:node rawip_recv;";
}
if(iii==2658){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_compat_ipv4_node";
	add0="corenet_raw_send_compat_ipv4_node($1)";
	add1="corenet_raw_receive_compat_ipv4_node($1)";
	add_number =1;
}
if(iii==2659){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_compat_ipv4_node";
	add0="allow $1 compat_ipv4_node_t:tcp_socket node_bind;";
}
if(iii==2660){
	add_number=0;
	raw_interface_name="corenet_udp_bind_compat_ipv4_node";
	add0="allow $1 compat_ipv4_node_t:udp_socket node_bind;";
}
if(iii==2661){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_inaddr_any_node";
	add0="allow $1 inaddr_any_node_t:node { tcp_send tcp_recv };";
}
if(iii==2662){
	add_number=0;
	raw_interface_name="corenet_udp_send_inaddr_any_node";
	add0="allow $1 inaddr_any_node_t:node udp_send;";
}
if(iii==2663){
	add_number=0;
	raw_interface_name="corenet_udp_receive_inaddr_any_node";
	add0="allow $1 inaddr_any_node_t:node udp_recv;";
}
if(iii==2664){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_inaddr_any_node";
	add0="corenet_udp_send_inaddr_any_node($1)";
	add1="corenet_udp_receive_inaddr_any_node($1)";
	add_number =1;
}
if(iii==2665){
	add_number=0;
	raw_interface_name="corenet_raw_send_inaddr_any_node";
	add0="allow $1 inaddr_any_node_t:node rawip_send;";
}
if(iii==2666){
	add_number=0;
	raw_interface_name="corenet_raw_receive_inaddr_any_node";
	add0="allow $1 inaddr_any_node_t:node rawip_recv;";
}
if(iii==2667){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_inaddr_any_node";
	add0="corenet_raw_send_inaddr_any_node($1)";
	add1="corenet_raw_receive_inaddr_any_node($1)";
	add_number =1;
}
if(iii==2668){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_inaddr_any_node";
	add0="allow $1 inaddr_any_node_t:tcp_socket node_bind;";
}
if(iii==2669){
	add_number=0;
	raw_interface_name="corenet_udp_bind_inaddr_any_node";
	add0="allow $1 inaddr_any_node_t:udp_socket node_bind;";
}
if(iii==2670){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_link_local_node";
	add0="allow $1 link_local_node_t:node { tcp_send tcp_recv };";
}
if(iii==2671){
	add_number=0;
	raw_interface_name="corenet_udp_send_link_local_node";
	add0="allow $1 link_local_node_t:node udp_send;";
}
if(iii==2672){
	add_number=0;
	raw_interface_name="corenet_udp_receive_link_local_node";
	add0="allow $1 link_local_node_t:node udp_recv;";
}
if(iii==2673){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_link_local_node";
	add0="corenet_udp_send_link_local_node($1)";
	add1="corenet_udp_receive_link_local_node($1)";
	add_number =1;
}
if(iii==2674){
	add_number=0;
	raw_interface_name="corenet_raw_send_link_local_node";
	add0="allow $1 link_local_node_t:node rawip_send;";
}
if(iii==2675){
	add_number=0;
	raw_interface_name="corenet_raw_receive_link_local_node";
	add0="allow $1 link_local_node_t:node rawip_recv;";
}
if(iii==2676){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_link_local_node";
	add0="corenet_raw_send_link_local_node($1)";
	add1="corenet_raw_receive_link_local_node($1)";
	add_number =1;
}
if(iii==2677){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_link_local_node";
	add0="allow $1 link_local_node_t:tcp_socket node_bind;";
}
if(iii==2678){
	add_number=0;
	raw_interface_name="corenet_udp_bind_link_local_node";
	add0="allow $1 link_local_node_t:udp_socket node_bind;";
}
if(iii==2679){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_lo_node";
	add0="allow $1 lo_node_t:node { tcp_send tcp_recv };";
}
if(iii==2680){
	add_number=0;
	raw_interface_name="corenet_udp_send_lo_node";
	add0="allow $1 lo_node_t:node udp_send;";
}
if(iii==2681){
	add_number=0;
	raw_interface_name="corenet_udp_receive_lo_node";
	add0="allow $1 lo_node_t:node udp_recv;";
}
if(iii==2682){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_lo_node";
	add0="corenet_udp_send_lo_node($1)";
	add1="corenet_udp_receive_lo_node($1)";
	add_number =1;
}
if(iii==2683){
	add_number=0;
	raw_interface_name="corenet_raw_send_lo_node";
	add0="allow $1 lo_node_t:node rawip_send;";
}
if(iii==2684){
	add_number=0;
	raw_interface_name="corenet_raw_receive_lo_node";
	add0="allow $1 lo_node_t:node rawip_recv;";
}
if(iii==2685){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_lo_node";
	add0="corenet_raw_send_lo_node($1)";
	add1="corenet_raw_receive_lo_node($1)";
	add_number =1;
}
if(iii==2686){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_lo_node";
	add0="allow $1 lo_node_t:tcp_socket node_bind;";
}
if(iii==2687){
	add_number=0;
	raw_interface_name="corenet_udp_bind_lo_node";
	add0="allow $1 lo_node_t:udp_socket node_bind;";
}
if(iii==2688){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_mapped_ipv4_node";
	add0="allow $1 mapped_ipv4_node_t:node { tcp_send tcp_recv };";
}
if(iii==2689){
	add_number=0;
	raw_interface_name="corenet_udp_send_mapped_ipv4_node";
	add0="allow $1 mapped_ipv4_node_t:node udp_send;";
}
if(iii==2690){
	add_number=0;
	raw_interface_name="corenet_udp_receive_mapped_ipv4_node";
	add0="allow $1 mapped_ipv4_node_t:node udp_recv;";
}
if(iii==2691){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_mapped_ipv4_node";
	add0="corenet_udp_send_mapped_ipv4_node($1)";
	add1="corenet_udp_receive_mapped_ipv4_node($1)";
	add_number =1;
}
if(iii==2692){
	add_number=0;
	raw_interface_name="corenet_raw_send_mapped_ipv4_node";
	add0="allow $1 mapped_ipv4_node_t:node rawip_send;";
}
if(iii==2693){
	add_number=0;
	raw_interface_name="corenet_raw_receive_mapped_ipv4_node";
	add0="allow $1 mapped_ipv4_node_t:node rawip_recv;";
}
if(iii==2694){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_mapped_ipv4_node";
	add0="corenet_raw_send_mapped_ipv4_node($1)";
	add1="corenet_raw_receive_mapped_ipv4_node($1)";
	add_number =1;
}
if(iii==2695){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_mapped_ipv4_node";
	add0="allow $1 mapped_ipv4_node_t:tcp_socket node_bind;";
}
if(iii==2696){
	add_number=0;
	raw_interface_name="corenet_udp_bind_mapped_ipv4_node";
	add0="allow $1 mapped_ipv4_node_t:udp_socket node_bind;";
}
if(iii==2697){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_multicast_node";
	add0="allow $1 multicast_node_t:node { tcp_send tcp_recv };";
}
if(iii==2698){
	add_number=0;
	raw_interface_name="corenet_udp_send_multicast_node";
	add0="allow $1 multicast_node_t:node udp_send;";
}
if(iii==2699){
	add_number=0;
	raw_interface_name="corenet_udp_receive_multicast_node";
	add0="allow $1 multicast_node_t:node udp_recv;";
}
if(iii==2700){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_multicast_node";
	add0="corenet_udp_send_multicast_node($1)";
	add1="corenet_udp_receive_multicast_node($1)";
	add_number =1;
}
if(iii==2701){
	add_number=0;
	raw_interface_name="corenet_raw_send_multicast_node";
	add0="allow $1 multicast_node_t:node rawip_send;";
}
if(iii==2702){
	add_number=0;
	raw_interface_name="corenet_raw_receive_multicast_node";
	add0="allow $1 multicast_node_t:node rawip_recv;";
}
if(iii==2703){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_multicast_node";
	add0="corenet_raw_send_multicast_node($1)";
	add1="corenet_raw_receive_multicast_node($1)";
	add_number =1;
}
if(iii==2704){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_multicast_node";
	add0="allow $1 multicast_node_t:tcp_socket node_bind;";
}
if(iii==2705){
	add_number=0;
	raw_interface_name="corenet_udp_bind_multicast_node";
	add0="allow $1 multicast_node_t:udp_socket node_bind;";
}
if(iii==2706){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_site_local_node";
	add0="allow $1 site_local_node_t:node { tcp_send tcp_recv };";
}
if(iii==2707){
	add_number=0;
	raw_interface_name="corenet_udp_send_site_local_node";
	add0="allow $1 site_local_node_t:node udp_send;";
}
if(iii==2708){
	add_number=0;
	raw_interface_name="corenet_udp_receive_site_local_node";
	add0="allow $1 site_local_node_t:node udp_recv;";
}
if(iii==2709){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_site_local_node";
	add0="corenet_udp_send_site_local_node($1)";
	add1="corenet_udp_receive_site_local_node($1)";
	add_number =1;
}
if(iii==2710){
	add_number=0;
	raw_interface_name="corenet_raw_send_site_local_node";
	add0="allow $1 site_local_node_t:node rawip_send;";
}
if(iii==2711){
	add_number=0;
	raw_interface_name="corenet_raw_receive_site_local_node";
	add0="allow $1 site_local_node_t:node rawip_recv;";
}
if(iii==2712){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_site_local_node";
	add0="corenet_raw_send_site_local_node($1)";
	add1="corenet_raw_receive_site_local_node($1)";
	add_number =1;
}
if(iii==2713){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_site_local_node";
	add0="allow $1 site_local_node_t:tcp_socket node_bind;";
}
if(iii==2714){
	add_number=0;
	raw_interface_name="corenet_udp_bind_site_local_node";
	add0="allow $1 site_local_node_t:udp_socket node_bind;";
}
if(iii==2715){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_unspec_node";
	add0="allow $1 unspec_node_t:node { tcp_send tcp_recv };";
}
if(iii==2716){
	add_number=0;
	raw_interface_name="corenet_udp_send_unspec_node";
	add0="allow $1 unspec_node_t:node udp_send;";
}
if(iii==2717){
	add_number=0;
	raw_interface_name="corenet_udp_receive_unspec_node";
	add0="allow $1 unspec_node_t:node udp_recv;";
}
if(iii==2718){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_unspec_node";
	add0="corenet_udp_send_unspec_node($1)";
	add1="corenet_udp_receive_unspec_node($1)";
	add_number =1;
}
if(iii==2719){
	add_number=0;
	raw_interface_name="corenet_raw_send_unspec_node";
	add0="allow $1 unspec_node_t:node rawip_send;";
}
if(iii==2720){
	add_number=0;
	raw_interface_name="corenet_raw_receive_unspec_node";
	add0="allow $1 unspec_node_t:node rawip_recv;";
}
if(iii==2721){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_unspec_node";
	add0="corenet_raw_send_unspec_node($1)";
	add1="corenet_raw_receive_unspec_node($1)";
	add_number =1;
}
if(iii==2722){
	add_number=0;
	raw_interface_name="corenet_tcp_bind_unspec_node";
	add0="allow $1 unspec_node_t:tcp_socket node_bind;";
}
if(iii==2723){
	add_number=0;
	raw_interface_name="corenet_udp_bind_unspec_node";
	add0="allow $1 unspec_node_t:udp_socket node_bind;";
}
if(iii==2724){
	add_number=0;
	raw_interface_name="corenet_tcp_sendrecv_lo_if";
	add0="allow $1 lo_netif_t:netif { tcp_send tcp_recv };";
}
if(iii==2725){
	add_number=0;
	raw_interface_name="corenet_udp_send_lo_if";
	add0="allow $1 lo_netif_t:netif udp_send;";
}
if(iii==2726){
	add_number=0;
	raw_interface_name="corenet_udp_receive_lo_if";
	add0="allow $1 lo_netif_t:netif udp_recv;";
}
if(iii==2727){
	add_number=0;
	raw_interface_name="corenet_udp_sendrecv_lo_if";
	add0="corenet_udp_send_lo_if($1)";
	add1="corenet_udp_receive_lo_if($1)";
	add_number =1;
}
if(iii==2728){
	add_number=0;
	raw_interface_name="corenet_raw_send_lo_if";
	add0="allow $1 lo_netif_t:netif rawip_send;";
}
if(iii==2729){
	add_number=0;
	raw_interface_name="corenet_raw_receive_lo_if";
	add0="allow $1 lo_netif_t:netif rawip_recv;";
}
if(iii==2730){
	add_number=0;
	raw_interface_name="corenet_raw_sendrecv_lo_if";
	add0="corenet_raw_send_lo_if($1)";
	add1="corenet_raw_receive_lo_if($1)";
	add_number =1;
	add2=":devices.if";
	add_number =2;
}
if(iii==2731){
	add_number=0;
	raw_interface_name="dev_node";
	add0="typeattribute $1 device_node;";
}
if(iii==2732){
	add_number=0;
	raw_interface_name="dev_relabel_all_dev_nodes";
	add0="relabelfrom_dirs_pattern($1,device_t,device_node)";
	add1="relabelfrom_files_pattern($1,device_t,device_node)";
	add_number =1;
	add2="relabelfrom_lnk_files_pattern($1,device_t,device_node)";
	add_number =2;
	add3="relabelfrom_fifo_files_pattern($1,device_t,device_node)";
	add_number =3;
	add4="relabelfrom_sock_files_pattern($1,device_t,device_node)";
	add_number =4;
	add5="relabel_blk_files_pattern($1,device_t,{ device_t device_node })";
	add_number =5;
	add6="relabel_chr_files_pattern($1,device_t,{ device_t device_node })";
	add_number =6;
}
if(iii==2733){
	add_number=0;
	raw_interface_name="dev_list_all_dev_nodes";
	add0="list_dirs_pattern($1,device_t,device_t)";
	add1="read_lnk_files_pattern($1,device_t,device_t)";
	add_number =1;
}
if(iii==2734){
	add_number=0;
	raw_interface_name="dev_setattr_generic_dirs";
	add0="setattr_dirs_pattern($1,device_t,device_t)";
}
if(iii==2735){
	add_number=0;
	raw_interface_name="dev_dontaudit_list_all_dev_nodes";
	add0="dontaudit $1 device_t:dir list_dir_perms;";
}
if(iii==2736){
	add_number=0;
	raw_interface_name="dev_add_entry_generic_dirs";
	add0="allow $1 device_t:dir add_entry_dir_perms;";
}
if(iii==2737){
	add_number=0;
	raw_interface_name="dev_create_generic_dirs";
	add0="allow $1 device_t:dir { ra_dir_perms create };";
	add1="create_dirs_pattern($1,device_t,device_t)";
	add_number =1;
}
if(iii==2738){
	add_number=0;
	raw_interface_name="dev_delete_generic_dirs";
	add0="delete_dirs_pattern($1,device_t,device_t)";
}
if(iii==2739){
	add_number=0;
	raw_interface_name="dev_relabel_generic_dev_dirs";
	add0="relabel_dirs_pattern($1,device_t,device_t)";
}
if(iii==2740){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_generic_files";
	add0="dontaudit $1 device_t:file getattr;";
}
if(iii==2741){
	add_number=0;
	raw_interface_name="dev_rw_generic_files";
	add0="rw_files_pattern($1,device_t,device_t)";
}
if(iii==2742){
	add_number=0;
	raw_interface_name="dev_delete_generic_files";
	add0="delete_files_pattern($1,device_t,device_t)";
}
if(iii==2743){
	add_number=0;
	raw_interface_name="dev_manage_generic_files";
	add0="manage_files_pattern($1,device_t,device_t)";
}
if(iii==2744){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_generic_pipes";
	add0="dontaudit $1 device_t:fifo_file getattr;";
}
if(iii==2745){
	add_number=0;
	raw_interface_name="dev_getattr_generic_blk_files";
	add0="getattr_blk_files_pattern($1,device_t,device_t)";
}
if(iii==2746){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_generic_blk_files";
	add0="dontaudit $1 device_t:blk_file getattr;";
}
if(iii==2747){
	add_number=0;
	raw_interface_name="dev_dontaudit_setattr_generic_blk_files";
	add0="dontaudit $1 device_t:blk_file setattr;";
}
if(iii==2748){
	add_number=0;
	raw_interface_name="dev_create_generic_chr_files";
	add0="create_chr_files_pattern($1,device_t,device_t)";
}
if(iii==2749){
	add_number=0;
	raw_interface_name="dev_getattr_generic_chr_files";
	add0="getattr_chr_files_pattern($1,device_t,device_t)";
}
if(iii==2750){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_generic_chr_files";
	add0="dontaudit $1 device_t:chr_file getattr;";
}
if(iii==2751){
	add_number=0;
	raw_interface_name="dev_dontaudit_setattr_generic_chr_files";
	add0="dontaudit $1 device_t:chr_file setattr;";
}
if(iii==2752){
	add_number=0;
	raw_interface_name="dev_dontaudit_setattr_generic_symlinks";
	add0="dontaudit $1 device_t:lnk_file setattr;";
}
if(iii==2753){
	add_number=0;
	raw_interface_name="dev_create_generic_symlinks";
	add0="create_lnk_files_pattern($1,device_t,device_t)";
}
if(iii==2754){
	add_number=0;
	raw_interface_name="dev_delete_generic_symlinks";
	add0="delete_lnk_files_pattern($1,device_t,device_t)";
}
if(iii==2755){
	add_number=0;
	raw_interface_name="dev_manage_generic_symlinks";
	add0="manage_lnk_files_pattern($1,device_t,device_t)";
}
if(iii==2756){
	add_number=0;
	raw_interface_name="dev_relabel_generic_symlinks";
	add0="relabel_lnk_files_pattern($1,device_t,device_t)";
}
if(iii==2757){
	add_number=0;
	raw_interface_name="dev_manage_all_dev_nodes";
	add0="manage_dirs_pattern($1,device_t,device_t)";
	add1="manage_sock_files_pattern($1,device_t,device_t)";
	add_number =1;
	add2="manage_lnk_files_pattern($1,device_t,device_t)";
	add_number =2;
	add3="manage_chr_files_pattern($1,device_t,{ device_t device_node })";
	add_number =3;
	add4="manage_blk_files_pattern($1,device_t,{ device_t device_node })";
	add_number =4;
	add5="relabel_dirs_pattern($1,device_t,device_t)";
	add_number =5;
	add6="relabel_chr_files_pattern($1,device_t,{ device_t device_node })";
	add_number =6;
	add7="relabel_blk_files_pattern($1,device_t,{ device_t device_node })";
	add_number =7;
	add8="storage_raw_read_fixed_disk($1)";
	add_number =8;
	add9="storage_raw_write_fixed_disk($1)";
	add_number =9;
	add10="storage_read_scsi_generic($1)";
	add_number =10;
	add11="storage_write_scsi_generic($1)";
	add_number =11;
	add12="typeattribute $1 memory_raw_read;";
	add_number =12;
	add13="typeattribute $1 memory_raw_write;";
	add_number =13;
}
if(iii==2758){
	add_number=0;
	raw_interface_name="dev_dontaudit_rw_generic_dev_nodes";
	add0="dontaudit $1 device_t:{ chr_file blk_file } { getattr read write ioctl };";
}
if(iii==2759){
	add_number=0;
	raw_interface_name="dev_manage_generic_blk_files";
	add0="manage_blk_files_pattern($1,device_t,device_t)";
}
if(iii==2760){
	add_number=0;
	raw_interface_name="dev_manage_generic_chr_files";
	add0="manage_chr_files_pattern($1,device_t,device_t)";
}
if(iii==2761){
	add_number=0;
	raw_interface_name="dev_filetrans";
	add0="filetrans_pattern($1,device_t,$2,$3)";
	add1="filetrans_pattern($1,device_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,device_t,$2,$3)";
	add_number =2;
	add3="fs_associate_tmpfs($2)";
	add_number =3;
	add4="files_associate_tmp($2)";
	add_number =4;
}
if(iii==2762){
	add_number=0;
	raw_interface_name="dev_getattr_all_blk_files";
	add0="getattr_blk_files_pattern($1,device_t,device_node)";
}
if(iii==2763){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_all_blk_files";
	add0="dontaudit $1 device_node:blk_file getattr;";
}
if(iii==2764){
	add_number=0;
	raw_interface_name="dev_getattr_all_chr_files";
	add0="getattr_chr_files_pattern($1,device_t,device_node)";
}
if(iii==2765){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_all_chr_files";
	add0="dontaudit $1 device_node:chr_file getattr;";
}
if(iii==2766){
	add_number=0;
	raw_interface_name="dev_setattr_all_blk_files";
	add0="setattr_blk_files_pattern($1,device_t,device_node)";
}
if(iii==2767){
	add_number=0;
	raw_interface_name="dev_setattr_all_chr_files";
	add0="setattr_chr_files_pattern($1,device_t,device_node)";
}
if(iii==2768){
	add_number=0;
	raw_interface_name="dev_dontaudit_read_all_blk_files";
	add0="dontaudit $1 device_node:blk_file { getattr read };";
}
if(iii==2769){
	add_number=0;
	raw_interface_name="dev_dontaudit_read_all_chr_files";
	add0="dontaudit $1 device_node:chr_file { getattr read };";
}
if(iii==2770){
	add_number=0;
	raw_interface_name="dev_create_all_blk_files";
	add0="create_blk_files_pattern($1,device_t,device_node)";
}
if(iii==2771){
	add_number=0;
	raw_interface_name="dev_create_all_chr_files";
	add0="create_chr_files_pattern($1,device_t,device_node)";
}
if(iii==2772){
	add_number=0;
	raw_interface_name="dev_delete_all_blk_files";
	add0="delete_blk_files_pattern($1,device_t,device_node)";
}
if(iii==2773){
	add_number=0;
	raw_interface_name="dev_delete_all_chr_files";
	add0="delete_chr_files_pattern($1,device_t,device_node)";
}
if(iii==2774){
	add_number=0;
	raw_interface_name="dev_rename_all_blk_files";
	add0="rename_blk_files_pattern($1,device_t,device_node)";
}
if(iii==2775){
	add_number=0;
	raw_interface_name="dev_rename_all_chr_files";
	add0="rename_chr_files_pattern($1,device_t,device_node)";
}
if(iii==2776){
	add_number=0;
	raw_interface_name="dev_manage_all_blk_files";
	add0="manage_blk_files_pattern($1,device_t,device_node)";
	add1="storage_raw_read_fixed_disk($1)";
	add_number =1;
	add2="storage_raw_write_fixed_disk($1)";
	add_number =2;
	add3="storage_read_scsi_generic($1)";
	add_number =3;
	add4="storage_write_scsi_generic($1)";
	add_number =4;
}
if(iii==2777){
	add_number=0;
	raw_interface_name="dev_manage_all_chr_files";
	add0="manage_chr_files_pattern($1,device_t,device_node)";
	add1="typeattribute $1 memory_raw_read, memory_raw_write;";
	add_number =1;
}
if(iii==2778){
	add_number=0;
	raw_interface_name="dev_getattr_agp_dev";
	add0="getattr_chr_files_pattern($1,device_t,agp_device_t)";
}
if(iii==2779){
	add_number=0;
	raw_interface_name="dev_rw_agp";
	add0="rw_chr_files_pattern($1,device_t,agp_device_t)";
}
if(iii==2780){
	add_number=0;
	raw_interface_name="dev_getattr_apm_bios_dev";
	add0="getattr_chr_files_pattern($1,device_t,apm_bios_t)";
}
if(iii==2781){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_apm_bios_dev";
	add0="dontaudit $1 apm_bios_t:chr_file getattr;";
}
if(iii==2782){
	add_number=0;
	raw_interface_name="dev_setattr_apm_bios_dev";
	add0="setattr_chr_files_pattern($1,device_t,apm_bios_t)";
}
if(iii==2783){
	add_number=0;
	raw_interface_name="dev_dontaudit_setattr_apm_bios_dev";
	add0="dontaudit $1 apm_bios_t:chr_file setattr;";
}
if(iii==2784){
	add_number=0;
	raw_interface_name="dev_rw_apm_bios";
	add0="rw_chr_files_pattern($1,device_t,apm_bios_t)";
}
if(iii==2785){
	add_number=0;
	raw_interface_name="dev_rw_cardmgr";
	add0="rw_chr_files_pattern($1,device_t,cardmgr_dev_t)";
}
if(iii==2786){
	add_number=0;
	raw_interface_name="dev_dontaudit_rw_cardmgr";
	add0="dontaudit $1 cardmgr_dev_t:chr_file { read write };";
}
if(iii==2787){
	add_number=0;
	raw_interface_name="dev_manage_cardmgr_dev";
	add0="manage_chr_files_pattern($1,device_t,cardmgr_dev_t)";
	add1="manage_blk_files_pattern($1,device_t,cardmgr_dev_t)";
	add_number =1;
}
if(iii==2788){
	add_number=0;
	raw_interface_name="dev_create_cardmgr_dev";
	add0="create_chr_files_pattern($1,device_t,cardmgr_dev_t)";
	add1="create_blk_files_pattern($1,device_t,cardmgr_dev_t)";
	add_number =1;
	add2="filetrans_pattern($1,device_t,cardmgr_dev_t,{ chr_file blk_file })";
	add_number =2;
}
if(iii==2789){
	add_number=0;
	raw_interface_name="dev_getattr_cpu_dev";
	add0="getattr_chr_files_pattern($1,device_t,cpu_device_t)";
}
if(iii==2790){
	add_number=0;
	raw_interface_name="dev_read_cpuid";
	add0="read_chr_files_pattern($1,device_t,cpu_device_t)";
}
if(iii==2791){
	add_number=0;
	raw_interface_name="dev_rw_cpu_microcode";
	add0="rw_chr_files_pattern($1,device_t,cpu_device_t)";
}
if(iii==2792){
	add_number=0;
	raw_interface_name="dev_rw_crypto";
	add0="rw_chr_files_pattern($1,device_t,crypt_device_t)";
}
if(iii==2793){
	add_number=0;
	raw_interface_name="dev_getattr_dri_dev";
	add0="getattr_chr_files_pattern($1,device_t,dri_device_t)";
}
if(iii==2794){
	add_number=0;
	raw_interface_name="dev_setattr_dri_dev";
	add0="setattr_chr_files_pattern($1,device_t,dri_device_t)";
}
if(iii==2795){
	add_number=0;
	raw_interface_name="dev_rw_dri";
	add0="rw_chr_files_pattern($1,device_t,dri_device_t)";
}
if(iii==2796){
	add_number=0;
	raw_interface_name="dev_dontaudit_rw_dri";
	add0="dontaudit $1 dri_device_t:chr_file { getattr read write ioctl };";
}
if(iii==2797){
	add_number=0;
	raw_interface_name="dev_manage_dri_dev";
	add0="manage_chr_files_pattern($1,device_t,dri_device_t)";
	add1="filetrans_pattern($1,device_t,dri_device_t,chr_file)";
	add_number =1;
}
if(iii==2798){
	add_number=0;
	raw_interface_name="dev_read_input";
	add0="read_chr_files_pattern($1,device_t,event_device_t)";
}
if(iii==2799){
	add_number=0;
	raw_interface_name="dev_rw_input_dev";
	add0="rw_chr_files_pattern($1,device_t,event_device_t)";
}
if(iii==2800){
	add_number=0;
	raw_interface_name="dev_getattr_framebuffer_dev";
	add0="getattr_chr_files_pattern($1,device_t,framebuf_device_t)";
}
if(iii==2801){
	add_number=0;
	raw_interface_name="dev_setattr_framebuffer_dev";
	add0="setattr_chr_files_pattern($1,device_t,framebuf_device_t)";
}
if(iii==2802){
	add_number=0;
	raw_interface_name="dev_dontaudit_setattr_framebuffer_dev";
	add0="dontaudit $1 framebuf_device_t:chr_file setattr;";
}
if(iii==2803){
	add_number=0;
	raw_interface_name="dev_read_framebuffer";
	add0="read_chr_files_pattern($1,device_t,framebuf_device_t)";
}
if(iii==2804){
	add_number=0;
	raw_interface_name="dev_dontaudit_read_framebuffer";
	add0="dontaudit $1 framebuf_device_t:chr_file { getattr read };";
}
if(iii==2805){
	add_number=0;
	raw_interface_name="dev_write_framebuffer";
	add0="write_chr_files_pattern($1,device_t,framebuf_device_t)";
}
if(iii==2806){
	add_number=0;
	raw_interface_name="dev_rw_framebuffer";
	add0="rw_chr_files_pattern($1,device_t,framebuf_device_t)";
}
if(iii==2807){
	add_number=0;
	raw_interface_name="dev_read_lvm_control";
	add0="read_chr_files_pattern($1,device_t,lvm_control_t)";
}
if(iii==2808){
	add_number=0;
	raw_interface_name="dev_rw_lvm_control";
	add0="rw_chr_files_pattern($1,device_t,lvm_control_t)";
}
if(iii==2809){
	add_number=0;
	raw_interface_name="dev_delete_lvm_control_dev";
	add0="delete_chr_files_pattern($1,device_t,lvm_control_t)";
}
if(iii==2810){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_memory_dev";
	add0="dontaudit $1 memory_device_t:chr_file getattr;";
}
if(iii==2811){
	add_number=0;
	raw_interface_name="dev_read_raw_memory";
	add0="read_chr_files_pattern($1,device_t,memory_device_t)";
	add1="allow $1 self:capability sys_rawio;";
	add_number =1;
	add2="typeattribute $1 memory_raw_read;";
	add_number =2;
}
if(iii==2812){
	add_number=0;
	raw_interface_name="dev_write_raw_memory";
	add0="write_chr_files_pattern($1,device_t,memory_device_t)";
	add1="allow $1 self:capability sys_rawio;";
	add_number =1;
	add2="typeattribute $1 memory_raw_write;";
	add_number =2;
}
if(iii==2813){
	add_number=0;
	raw_interface_name="dev_rx_raw_memory";
	add0="dev_read_raw_memory($1)";
	add1="allow $1 memory_device_t:chr_file execute;";
	add_number =1;
}
if(iii==2814){
	add_number=0;
	raw_interface_name="dev_wx_raw_memory";
	add0="dev_write_raw_memory($1)";
	add1="allow $1 memory_device_t:chr_file execute;";
	add_number =1;
}
if(iii==2815){
	add_number=0;
	raw_interface_name="dev_getattr_misc_dev";
	add0="getattr_chr_files_pattern($1,device_t,misc_device_t)";
}
if(iii==2816){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_misc_dev";
	add0="dontaudit $1 misc_device_t:chr_file getattr;";
}
if(iii==2817){
	add_number=0;
	raw_interface_name="dev_setattr_misc_dev";
	add0="setattr_chr_files_pattern($1,device_t,misc_device_t)";
}
if(iii==2818){
	add_number=0;
	raw_interface_name="dev_dontaudit_setattr_misc_dev";
	add0="dontaudit $1 misc_device_t:chr_file setattr;";
}
if(iii==2819){
	add_number=0;
	raw_interface_name="dev_read_misc";
	add0="read_chr_files_pattern($1,device_t,misc_device_t)";
}
if(iii==2820){
	add_number=0;
	raw_interface_name="dev_write_misc";
	add0="write_chr_files_pattern($1,device_t,misc_device_t)";
}
if(iii==2821){
	add_number=0;
	raw_interface_name="dev_dontaudit_rw_misc";
	add0="dontaudit $1 misc_device_t:chr_file rw_file_perms;";
}
if(iii==2822){
	add_number=0;
	raw_interface_name="dev_getattr_mouse_dev";
	add0="getattr_chr_files_pattern($1,device_t,mouse_device_t)";
}
if(iii==2823){
	add_number=0;
	raw_interface_name="dev_setattr_mouse_dev";
	add0="setattr_chr_files_pattern($1,device_t,mouse_device_t)";
}
if(iii==2824){
	add_number=0;
	raw_interface_name="dev_read_mouse";
	add0="read_chr_files_pattern($1,device_t,mouse_device_t)";
}
if(iii==2825){
	add_number=0;
	raw_interface_name="dev_rw_mouse";
	add0="rw_chr_files_pattern($1,device_t,mouse_device_t)";
}
if(iii==2826){
	add_number=0;
	raw_interface_name="dev_getattr_mtrr_dev";
	add0="getattr_files_pattern($1,device_t,mtrr_device_t)";
	add1="getattr_chr_files_pattern($1,device_t,mtrr_device_t)";
	add_number =1;
}
if(iii==2827){
	add_number=0;
	raw_interface_name="dev_read_mtrr";
	add0="dev_rw_mtrr($1)";
}
if(iii==2828){
	add_number=0;
	raw_interface_name="dev_write_mtrr";
	add0="dev_rw_mtrr($1)";
}
if(iii==2829){
	add_number=0;
	raw_interface_name="dev_rw_mtrr";
	add0="rw_files_pattern($1,device_t,mtrr_device_t)";
	add1="rw_chr_files_pattern($1,device_t,mtrr_device_t)";
	add_number =1;
}
if(iii==2830){
	add_number=0;
	raw_interface_name="dev_rw_null";
	add0="rw_chr_files_pattern($1,device_t,null_device_t)";
}
if(iii==2831){
	add_number=0;
	raw_interface_name="dev_create_null_dev";
	add0="create_chr_files_pattern($1,device_t,null_device_t)";
}
if(iii==2832){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_nvram_dev";
	add0="dontaudit $1 nvram_device_t:chr_file getattr;";
}
if(iii==2833){
	add_number=0;
	raw_interface_name="dev_rw_nvram";
	add0="rw_chr_files_pattern($1,device_t,nvram_device_t)";
}
if(iii==2834){
	add_number=0;
	raw_interface_name="dev_getattr_printer_dev";
	add0="getattr_chr_files_pattern($1,device_t,printer_device_t)";
}
if(iii==2835){
	add_number=0;
	raw_interface_name="dev_setattr_printer_dev";
	add0="setattr_chr_files_pattern($1,device_t,printer_device_t)";
}
if(iii==2836){
	add_number=0;
	raw_interface_name="dev_append_printer";
	add0="append_chr_files_pattern($1,device_t,printer_device_t)";
}
if(iii==2837){
	add_number=0;
	raw_interface_name="dev_rw_printer";
	add0="rw_chr_files_pattern($1,device_t,printer_device_t)";
}
if(iii==2838){
	add_number=0;
	raw_interface_name="dev_read_rand";
	add0="read_chr_files_pattern($1,device_t,random_device_t)";
}
if(iii==2839){
	add_number=0;
	raw_interface_name="dev_dontaudit_read_rand";
	add0="dontaudit $1 random_device_t:chr_file { getattr read };";
}
if(iii==2840){
	add_number=0;
	raw_interface_name="dev_write_rand";
	add0="write_chr_files_pattern($1,device_t,random_device_t)";
}
if(iii==2841){
	add_number=0;
	raw_interface_name="dev_read_realtime_clock";
	add0="read_chr_files_pattern($1,device_t,clock_device_t)";
}
if(iii==2842){
	add_number=0;
	raw_interface_name="dev_write_realtime_clock";
	add0="write_chr_files_pattern($1,device_t,clock_device_t)";
	add1="allow $1 clock_device_t:chr_file setattr;";
	add_number =1;
}
if(iii==2843){
	add_number=0;
	raw_interface_name="dev_rw_realtime_clock";
	add0="dev_read_realtime_clock($1)";
	add1="dev_write_realtime_clock($1)";
	add_number =1;
}
if(iii==2844){
	add_number=0;
	raw_interface_name="dev_getattr_scanner_dev";
	add0="getattr_chr_files_pattern($1,device_t,scanner_device_t)";
}
if(iii==2845){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_scanner_dev";
	add0="dontaudit $1 scanner_device_t:chr_file getattr;";
}
if(iii==2846){
	add_number=0;
	raw_interface_name="dev_setattr_scanner_dev";
	add0="setattr_chr_files_pattern($1,device_t,scanner_device_t)";
}
if(iii==2847){
	add_number=0;
	raw_interface_name="dev_dontaudit_setattr_scanner_dev";
	add0="dontaudit $1 scanner_device_t:chr_file setattr;";
}
if(iii==2848){
	add_number=0;
	raw_interface_name="dev_rw_scanner";
	add0="rw_chr_files_pattern($1,device_t,scanner_device_t)";
}
if(iii==2849){
	add_number=0;
	raw_interface_name="dev_getattr_sound_dev";
	add0="getattr_chr_files_pattern($1,device_t,sound_device_t)";
}
if(iii==2850){
	add_number=0;
	raw_interface_name="dev_setattr_sound_dev";
	add0="setattr_chr_files_pattern($1,device_t,sound_device_t)";
}
if(iii==2851){
	add_number=0;
	raw_interface_name="dev_read_sound";
	add0="read_chr_files_pattern($1,device_t,sound_device_t)";
}
if(iii==2852){
	add_number=0;
	raw_interface_name="dev_write_sound";
	add0="write_chr_files_pattern($1,device_t,sound_device_t)";
}
if(iii==2853){
	add_number=0;
	raw_interface_name="dev_read_sound_mixer";
	add0="read_chr_files_pattern($1,device_t,sound_device_t)";
}
if(iii==2854){
	add_number=0;
	raw_interface_name="dev_write_sound_mixer";
	add0="write_chr_files_pattern($1,device_t,sound_device_t)";
}
if(iii==2855){
	add_number=0;
	raw_interface_name="dev_getattr_power_mgmt_dev";
	add0="getattr_chr_files_pattern($1,device_t,power_device_t)";
}
if(iii==2856){
	add_number=0;
	raw_interface_name="dev_setattr_power_mgmt_dev";
	add0="setattr_chr_files_pattern($1,device_t,power_device_t)";
}
if(iii==2857){
	add_number=0;
	raw_interface_name="dev_rw_power_management";
	add0="rw_chr_files_pattern($1,device_t,power_device_t)";
}
if(iii==2858){
	add_number=0;
	raw_interface_name="dev_getattr_smartcard_dev";
	add0="allow $1 smartcard_device_t:chr_file getattr;";
}
if(iii==2859){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_smartcard_dev";
	add0="dontaudit $1 smartcard_device_t:chr_file getattr;";
}
if(iii==2860){
	add_number=0;
	raw_interface_name="dev_rw_smartcard";
	add0="rw_chr_files_pattern($1,device_t,smartcard_device_t)";
}
if(iii==2861){
	add_number=0;
	raw_interface_name="dev_manage_smartcard";
	add0="manage_chr_files_pattern($1,device_t,smartcard_device_t)";
}
if(iii==2862){
	add_number=0;
	raw_interface_name="dev_getattr_sysfs_dirs";
	add0="allow $1 sysfs_t:dir getattr_dir_perms;";
}
if(iii==2863){
	add_number=0;
	raw_interface_name="dev_search_sysfs";
	add0="search_dirs_pattern($1,sysfs_t,sysfs_t)";
}
if(iii==2864){
	add_number=0;
	raw_interface_name="dev_dontaudit_search_sysfs";
	add0="dontaudit $1 sysfs_t:dir search_dir_perms;";
}
if(iii==2865){
	add_number=0;
	raw_interface_name="dev_list_sysfs";
	add0="list_dirs_pattern($1,sysfs_t,sysfs_t)";
}
if(iii==2866){
	add_number=0;
	raw_interface_name="dev_write_sysfs_dirs";
	add0="allow $1 sysfs_t:dir write;";
}
if(iii==2867){
	add_number=0;
	raw_interface_name="dev_read_sysfs";
	add0="read_files_pattern($1,sysfs_t,sysfs_t)";
	add1="read_lnk_files_pattern($1,sysfs_t,sysfs_t)";
	add_number =1;
	add2="list_dirs_pattern($1,sysfs_t,sysfs_t)";
	add_number =2;
}
if(iii==2868){
	add_number=0;
	raw_interface_name="dev_rw_sysfs";
	add0="rw_files_pattern($1,sysfs_t,sysfs_t)";
	add1="read_lnk_files_pattern($1,sysfs_t,sysfs_t)";
	add_number =1;
	add2="list_dirs_pattern($1,sysfs_t,sysfs_t)";
	add_number =2;
}
if(iii==2869){
	add_number=0;
	raw_interface_name="dev_read_urand";
	add0="read_chr_files_pattern($1,device_t,urandom_device_t)";
}
if(iii==2870){
	add_number=0;
	raw_interface_name="dev_dontaudit_read_urand";
	add0="dontaudit $1 urandom_device_t:chr_file { getattr read };";
}
if(iii==2871){
	add_number=0;
	raw_interface_name="dev_write_urand";
	add0="write_chr_files_pattern($1,device_t,urandom_device_t)";
}
if(iii==2872){
	add_number=0;
	raw_interface_name="dev_getattr_generic_usb_dev";
	add0="getattr_chr_files_pattern($1,device_t,usb_device_t)";
}
if(iii==2873){
	add_number=0;
	raw_interface_name="dev_setattr_generic_usb_dev";
	add0="setattr_chr_files_pattern($1,device_t,usb_device_t)";
}
if(iii==2874){
	add_number=0;
	raw_interface_name="dev_rw_generic_usb_dev";
	add0="rw_chr_files_pattern($1,device_t,usb_device_t)";
}
if(iii==2875){
	add_number=0;
	raw_interface_name="dev_mount_usbfs";
	add0="allow $1 usbfs_t:filesystem mount;";
}
if(iii==2876){
	add_number=0;
	raw_interface_name="dev_associate_usbfs";
	add0="allow $1 usbfs_t:filesystem associate;";
}
if(iii==2877){
	add_number=0;
	raw_interface_name="dev_getattr_usbfs_dirs";
	add0="allow $1 usbfs_t:dir getattr_dir_perms;";
}
if(iii==2878){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_usbfs_dirs";
	add0="dontaudit $1 usbfs_t:dir getattr_dir_perms;";
}
if(iii==2879){
	add_number=0;
	raw_interface_name="dev_search_usbfs";
	add0="search_dirs_pattern($1,usbfs_t,usbfs_t)";
}
if(iii==2880){
	add_number=0;
	raw_interface_name="dev_list_usbfs";
	add0="read_lnk_files_pattern($1,usbfs_t,usbfs_t)";
	add1="getattr_files_pattern($1,usbfs_t,usbfs_t)";
	add_number =1;
	add2="list_dirs_pattern($1,usbfs_t,usbfs_t)";
	add_number =2;
}
if(iii==2881){
	add_number=0;
	raw_interface_name="dev_setattr_usbfs_files";
	add0="setattr_files_pattern($1,usbfs_t,usbfs_t)";
	add1="list_dirs_pattern($1,usbfs_t,usbfs_t)";
	add_number =1;
}
if(iii==2882){
	add_number=0;
	raw_interface_name="dev_read_usbfs";
	add0="read_files_pattern($1,usbfs_t,usbfs_t)";
	add1="read_lnk_files_pattern($1,usbfs_t,usbfs_t)";
	add_number =1;
	add2="list_dirs_pattern($1,usbfs_t,usbfs_t)";
	add_number =2;
}
if(iii==2883){
	add_number=0;
	raw_interface_name="dev_rw_usbfs";
	add0="list_dirs_pattern($1,usbfs_t,usbfs_t)";
	add1="rw_files_pattern($1,usbfs_t,usbfs_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,usbfs_t,usbfs_t)";
	add_number =2;
}
if(iii==2884){
	add_number=0;
	raw_interface_name="dev_getattr_video_dev";
	add0="getattr_chr_files_pattern($1,device_t,v4l_device_t)";
}
if(iii==2885){
	add_number=0;
	raw_interface_name="dev_dontaudit_getattr_video_dev";
	add0="dontaudit $1 v4l_device_t:chr_file getattr;";
}
if(iii==2886){
	add_number=0;
	raw_interface_name="dev_setattr_video_dev";
	add0="setattr_chr_files_pattern($1,device_t,v4l_device_t)";
}
if(iii==2887){
	add_number=0;
	raw_interface_name="dev_dontaudit_setattr_video_dev";
	add0="dontaudit $1 v4l_device_t:chr_file setattr;";
}
if(iii==2888){
	add_number=0;
	raw_interface_name="dev_read_video_dev";
	add0="read_chr_files_pattern($1,device_t,v4l_device_t)";
}
if(iii==2889){
	add_number=0;
	raw_interface_name="dev_write_video_dev";
	add0="write_chr_files_pattern($1,device_t,v4l_device_t)";
}
if(iii==2890){
	add_number=0;
	raw_interface_name="dev_rw_vmware";
	add0="rw_chr_files_pattern($1,device_t,vmware_device_t)";
}
if(iii==2891){
	add_number=0;
	raw_interface_name="dev_rwx_vmware";
	add0="dev_rw_vmware($1)";
	add1="allow $1 vmware_device_t:chr_file execute;";
	add_number =1;
}
if(iii==2892){
	add_number=0;
	raw_interface_name="dev_write_watchdog";
	add0="write_chr_files_pattern($1,device_t,watchdog_device_t)";
}
if(iii==2893){
	add_number=0;
	raw_interface_name="dev_rw_xen";
	add0="rw_chr_files_pattern($1,device_t,xen_device_t)";
}
if(iii==2894){
	add_number=0;
	raw_interface_name="dev_manage_xen";
	add0="manage_chr_files_pattern($1,device_t,xen_device_t)";
}
if(iii==2895){
	add_number=0;
	raw_interface_name="dev_filetrans_xen";
	add0="filetrans_pattern($1,device_t,xen_device_t,chr_file)";
}
if(iii==2896){
	add_number=0;
	raw_interface_name="dev_getattr_xserver_misc_dev";
	add0="getattr_chr_files_pattern($1,device_t,xserver_misc_device_t)";
}
if(iii==2897){
	add_number=0;
	raw_interface_name="dev_setattr_xserver_misc_dev";
	add0="setattr_chr_files_pattern($1,device_t,xserver_misc_device_t)";
}
if(iii==2898){
	add_number=0;
	raw_interface_name="dev_rw_xserver_misc";
	add0="rw_chr_files_pattern($1,device_t,xserver_misc_device_t)";
}
if(iii==2899){
	add_number=0;
	raw_interface_name="dev_rw_zero";
	add0="rw_chr_files_pattern($1,device_t,zero_device_t)";
}
if(iii==2900){
	add_number=0;
	raw_interface_name="dev_rwx_zero";
	add0="dev_rw_zero($1)";
	add1="allow $1 zero_device_t:chr_file execute;";
	add_number =1;
}
if(iii==2901){
	add_number=0;
	raw_interface_name="dev_execmod_zero";
	add0="dev_rw_zero($1)";
	add1="allow $1 zero_device_t:chr_file execmod;";
	add_number =1;
}
if(iii==2902){
	add_number=0;
	raw_interface_name="dev_create_zero_dev";
	add0="create_chr_files_pattern($1,device_t,zero_device_t)";
}
if(iii==2903){
	add_number=0;
	raw_interface_name="dev_unconfined";
	add0="typeattribute $1 devices_unconfined_type;";
	add1=":domain.if";
	add_number =1;
}
if(iii==2904){
	add_number=0;
	raw_interface_name="domain_base_type";
	add0="typeattribute $1 domain;";
}
if(iii==2905){
	add_number=0;
	raw_interface_name="domain_type";
	add0="domain_base_type($1)";
	add1="unconfined_use_fds($1)";
	add_number =1;
	add2="unconfined_sigchld($1)";
	add_number =2;
	add3="init_sigchld($1)";
	add_number =3;
	add4="init_signull($1)";
	add_number =4;
	add5="rpm_use_fds($1)";
	add_number =5;
	add6="rpm_read_pipes($1)";
	add_number =6;
	add7="selinux_dontaudit_read_fs($1)";
	add_number =7;
	add8="seutil_dontaudit_read_config($1)";
	add_number =8;
}
if(iii==2906){
	add_number=0;
	raw_interface_name="domain_entry_file";
	add0="allow $1 $2:file entrypoint;";
	add1="allow $1 $2:file entrypoint;";
	add_number =1;
	add2="allow $1 $2:file rx_file_perms;";
	add_number =2;
	add3="allow $1 $2:file rx_file_perms;";
	add_number =3;
	add4="typeattribute $2 entry_type;";
	add_number =4;
	add5="corecmd_executable_file($2)";
	add_number =5;
}
if(iii==2907){
	add_number=0;
	raw_interface_name="domain_interactive_fd";
	add0="typeattribute $1 privfd;";
}
if(iii==2908){
	add_number=0;
	raw_interface_name="domain_dyntrans_type";
	add0="typeattribute $1 set_curr_context;";
}
if(iii==2909){
	add_number=0;
	raw_interface_name="domain_system_change_exemption";
	add0="typeattribute $1 can_system_change;";
}
if(iii==2910){
	add_number=0;
	raw_interface_name="domain_subj_id_change_exemption";
	add0="typeattribute $1 can_change_process_identity;";
}
if(iii==2911){
	add_number=0;
	raw_interface_name="domain_role_change_exemption";
	add0="typeattribute $1 can_change_process_role;";
}
if(iii==2912){
	add_number=0;
	raw_interface_name="domain_obj_id_change_exemption";
	add0="typeattribute $1 can_change_object_identity;";
}
if(iii==2913){
	add_number=0;
	raw_interface_name="domain_user_exemption_target";
	add0="typeattribute $1 process_user_target;";
}
if(iii==2914){
	add_number=0;
	raw_interface_name="domain_cron_exemption_source";
	add0="typeattribute $1 cron_source_domain;";
}
if(iii==2915){
	add_number=0;
	raw_interface_name="domain_cron_exemption_target";
	add0="typeattribute $1 cron_job_domain;";
}
if(iii==2916){
	add_number=0;
	raw_interface_name="domain_use_interactive_fds";
	add0="allow $1 privfd:fd use;";
}
if(iii==2917){
	add_number=0;
	raw_interface_name="domain_dontaudit_use_interactive_fds";
	add0="dontaudit $1 privfd:fd use;";
}
if(iii==2918){
	add_number=0;
	raw_interface_name="domain_sigchld_interactive_fds";
	add0="allow $1 privfd:process sigchld;";
}
if(iii==2919){
	add_number=0;
	raw_interface_name="domain_setpriority_all_domains";
	add0="allow $1 domain:process setsched;";
}
if(iii==2920){
	add_number=0;
	raw_interface_name="domain_signal_all_domains";
	add0="allow $1 domain:process signal;";
}
if(iii==2921){
	add_number=0;
	raw_interface_name="domain_signull_all_domains";
	add0="allow $1 domain:process signull;";
}
if(iii==2922){
	add_number=0;
	raw_interface_name="domain_sigstop_all_domains";
	add0="allow $1 domain:process sigstop;";
}
if(iii==2923){
	add_number=0;
	raw_interface_name="domain_sigchld_all_domains";
	add0="allow $1 domain:process sigchld;";
}
if(iii==2924){
	add_number=0;
	raw_interface_name="domain_kill_all_domains";
	add0="allow $1 domain:process sigkill;";
	add1="allow $1 self:capability kill;";
	add_number =1;
}
if(iii==2925){
	add_number=0;
	raw_interface_name="domain_search_all_domains_state";
	add0="kernel_search_proc($1)";
	add1="allow $1 domain:dir search;";
	add_number =1;
}
if(iii==2926){
	add_number=0;
	raw_interface_name="domain_dontaudit_search_all_domains_state";
	add0="dontaudit $1 domain:dir search_dir_perms;";
}
if(iii==2927){
	add_number=0;
	raw_interface_name="domain_read_all_domains_state";
	add0="kernel_search_proc($1)";
	add1="allow $1 domain:dir list_dir_perms;";
	add_number =1;
	add2="read_files_pattern($1,domain,domain)";
	add_number =2;
	add3="read_lnk_files_pattern($1,domain,domain)";
	add_number =3;
}
if(iii==2928){
	add_number=0;
	raw_interface_name="domain_getattr_all_domains";
	add0="allow $1 domain:process getattr;";
}
if(iii==2929){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_domains";
	add0="dontaudit $1 domain:process getattr;";
}
if(iii==2930){
	add_number=0;
	raw_interface_name="domain_read_confined_domains_state";
	add0="kernel_search_proc($1)";
	add1="allow $1 { domain -unconfined_domain_type }:dir list_dir_perms;";
	add_number =1;
	add2="read_files_pattern($1,{ domain -unconfined_domain_type },{ domain -unconfined_domain_type })";
	add_number =2;
	add3="read_lnk_files_pattern($1,{ domain -unconfined_domain_type },{ domain -unconfined_domain_type })";
	add_number =3;
	add4="dontaudit $1 unconfined_domain_type:dir search_dir_perms;";
	add_number =4;
	add5="dontaudit $1 unconfined_domain_type:file { getattr read };";
	add_number =5;
}
if(iii==2931){
	add_number=0;
	raw_interface_name="domain_getattr_confined_domains";
	add0="allow $1 { domain -unconfined_domain_type }:process getattr;";
}
if(iii==2932){
	add_number=0;
	raw_interface_name="domain_ptrace_all_domains";
	add0="allow $1 domain:process ptrace;";
	add1="allow domain $1:process sigchld;";
	add_number =1;
}
if(iii==2933){
	add_number=0;
	raw_interface_name="domain_dontaudit_ptrace_all_domains";
	add0="dontaudit $1 domain:process ptrace;";
}
if(iii==2934){
	add_number=0;
	raw_interface_name="domain_dontaudit_ptrace_confined_domains";
	add0="dontaudit $1 { domain -unconfined_domain_type }:process ptrace;";
}
if(iii==2935){
	add_number=0;
	raw_interface_name="domain_dontaudit_read_all_domains_state";
	add0="dontaudit $1 domain:dir list_dir_perms;";
	add1="dontaudit $1 domain:lnk_file read_file_perms;";
	add_number =1;
	add2="dontaudit $1 domain:file read_file_perms;";
	add_number =2;
	add3="dontaudit $1 domain:sock_file read_file_perms;";
	add_number =3;
	add4="dontaudit $1 domain:fifo_file read_file_perms;";
	add_number =4;
}
if(iii==2936){
	add_number=0;
	raw_interface_name="domain_dontaudit_list_all_domains_state";
	add0="dontaudit $1 domain:dir list_dir_perms;";
}
if(iii==2937){
	add_number=0;
	raw_interface_name="domain_getsession_all_domains";
	add0="allow $1 domain:process getsession;";
}
if(iii==2938){
	add_number=0;
	raw_interface_name="domain_dontaudit_getsession_all_domains";
	add0="dontaudit $1 domain:process getsession;";
}
if(iii==2939){
	add_number=0;
	raw_interface_name="domain_getattr_all_sockets";
	add0="allow $1 domain:socket_class_set getattr;";
}
if(iii==2940){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_sockets";
	add0="dontaudit $1 domain:socket_class_set getattr;";
}
if(iii==2941){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_tcp_sockets";
	add0="dontaudit $1 domain:tcp_socket getattr;";
}
if(iii==2942){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_udp_sockets";
	add0="dontaudit $1 domain:udp_socket getattr;";
}
if(iii==2943){
	add_number=0;
	raw_interface_name="domain_dontaudit_rw_all_udp_sockets";
	add0="dontaudit $1 domain:udp_socket { read write };";
}
if(iii==2944){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_key_sockets";
	add0="dontaudit $1 domain:key_socket getattr;";
}
if(iii==2945){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_packet_sockets";
	add0="dontaudit $1 domain:packet_socket getattr;";
}
if(iii==2946){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_raw_sockets";
	add0="dontaudit $1 domain:rawip_socket getattr;";
}
if(iii==2947){
	add_number=0;
	raw_interface_name="domain_dontaudit_rw_all_key_sockets";
	add0="dontaudit $1 domain:key_socket { read write };";
}
if(iii==2948){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_dgram_sockets";
	add0="dontaudit $1 domain:unix_dgram_socket getattr;";
}
if(iii==2949){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_stream_sockets";
	add0="dontaudit $1 domain:unix_stream_socket getattr;";
}
if(iii==2950){
	add_number=0;
	raw_interface_name="domain_dontaudit_getattr_all_pipes";
	add0="dontaudit $1 domain:fifo_file getattr;";
}
if(iii==2951){
	add_number=0;
	raw_interface_name="domain_ipsec_setcontext_all_domains";
	add0="allow $1 domain:association setcontext;";
}
if(iii==2952){
	add_number=0;
	raw_interface_name="domain_getattr_all_entry_files";
	add0="allow $1 entry_type:lnk_file read_lnk_file_perms;";
	add1="allow $1 entry_type:file getattr;";
	add_number =1;
}
if(iii==2953){
	add_number=0;
	raw_interface_name="domain_read_all_entry_files";
	add0="allow $1 entry_type:lnk_file read_lnk_file_perms;";
	add1="allow $1 entry_type:file read_file_perms;";
	add_number =1;
}
if(iii==2954){
	add_number=0;
	raw_interface_name="domain_exec_all_entry_files";
	add0="allow $1 entry_type:file { read getattr lock execute ioctl execute_no_trans };";
	add1="allow $1 entry_type:file { read getattr lock execute ioctl execute_no_trans };";
	add_number =1;
}
if(iii==2955){
	add_number=0;
	raw_interface_name="domain_dontaudit_exec_all_entry_files";
	add0="dontaudit $1 entry_type:file exec_file_perms;";
}
if(iii==2956){
	add_number=0;
	raw_interface_name="domain_manage_all_entry_files";
	add0="allow $1 entry_type:file manage_file_perms;";
}
if(iii==2957){
	add_number=0;
	raw_interface_name="domain_relabel_all_entry_files";
	add0="allow $1 entry_type:file relabel_file_perms;";
}
if(iii==2958){
	add_number=0;
	raw_interface_name="domain_mmap_all_entry_files";
	add0="allow $1 entry_type:file mmap_file_perms;";
}
if(iii==2959){
	add_number=0;
	raw_interface_name="domain_entry_file_spec_domtrans";
	add0="domain_transition_pattern($1,entry_type,$2)";
	add1="domain_transition_pattern($1,entry_type,$2)";
	add_number =1;
}
if(iii==2960){
	add_number=0;
	raw_interface_name="domain_unconfined";
	add0="typeattribute $1 unconfined_domain_type;";
	add1="typeattribute $1 can_change_process_identity;";
	add_number =1;
	add2="typeattribute $1 can_change_process_role;";
	add_number =2;
	add3="typeattribute $1 can_change_object_identity;";
	add_number =3;
	add4="typeattribute $1 set_curr_context;";
	add_number =4;
}
if(iii==2961){
	add_number=0;
	raw_interface_name="domain_mmap_low";
	add0="allow $1 self:memprotect mmap_zero;";
	add1="typeattribute $1 mmap_low_domain_type;";
	add_number =1;
	add2=":files.if";
	add_number =2;
}
if(iii==2962){
	add_number=0;
	raw_interface_name="files_type";
	add0="typeattribute $1 file_type;";
}
if(iii==2963){
	add_number=0;
	raw_interface_name="files_lock_file";
	add0="files_type($1)";
	add1="typeattribute $1 lockfile;";
	add_number =1;
}
if(iii==2964){
	add_number=0;
	raw_interface_name="files_mountpoint";
	add0="files_type($1)";
	add1="typeattribute $1 mountpoint;";
	add_number =1;
}
if(iii==2965){
	add_number=0;
	raw_interface_name="files_pid_file";
	add0="files_type($1)";
	add1="typeattribute $1 pidfile;";
	add_number =1;
}
if(iii==2966){
	add_number=0;
	raw_interface_name="files_config_file";
	add0="files_type($1)";
}
if(iii==2967){
	add_number=0;
	raw_interface_name="files_poly";
	add0="files_type($1)";
	add1="typeattribute $1 polydir;";
	add_number =1;
}
if(iii==2968){
	add_number=0;
	raw_interface_name="files_poly_parent";
	add0="files_type($1)";
	add1="typeattribute $1 polyparent;";
	add_number =1;
}
if(iii==2969){
	add_number=0;
	raw_interface_name="files_poly_member";
	add0="files_type($1)";
	add1="typeattribute $1 polymember;";
	add_number =1;
}
if(iii==2970){
	add_number=0;
	raw_interface_name="files_poly_member_tmp";
	add0="type_member $1 tmp_t:dir $2;";
	add1="type_member $1 tmp_t:dir $2;";
	add_number =1;
}
if(iii==2971){
	add_number=0;
	raw_interface_name="files_security_file";
	add0="files_type($1)";
	add1="typeattribute $1 security_file_type;";
	add_number =1;
}
if(iii==2972){
	add_number=0;
	raw_interface_name="files_tmp_file";
	add0="files_type($1)";
	add1="files_poly_member($1)";
	add_number =1;
	add2="typeattribute $1 tmpfile;";
	add_number =2;
}
if(iii==2973){
	add_number=0;
	raw_interface_name="files_tmpfs_file";
	add0="files_type($1)";
	add1="typeattribute $1 tmpfsfile;";
	add_number =1;
}
if(iii==2974){
	add_number=0;
	raw_interface_name="files_getattr_all_dirs";
	add0="getattr_dirs_pattern($1,file_type,file_type)";
}
if(iii==2975){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_all_dirs";
	add0="dontaudit $1 file_type:dir getattr;";
}
if(iii==2976){
	add_number=0;
	raw_interface_name="files_list_non_security";
	add0="list_dirs_pattern($1,{ file_type -security_file_type },{ file_type -security_file_type })";
}
if(iii==2977){
	add_number=0;
	raw_interface_name="files_dontaudit_list_non_security";
	add0="dontaudit $1 { file_type -security_file_type }:dir list_dir_perms;";
}
if(iii==2978){
	add_number=0;
	raw_interface_name="files_mounton_non_security";
	add0="allow $1 { file_type -security_file_type }:dir mounton;";
	add1="allow $1 { file_type -security_file_type }:file mounton;";
	add_number =1;
}
if(iii==2979){
	add_number=0;
	raw_interface_name="files_write_non_security_dirs";
	add0="allow $1 { file_type -security_file_type }:dir write;";
}
if(iii==2980){
	add_number=0;
	raw_interface_name="files_getattr_all_files";
	add0="getattr_files_pattern($1,file_type,file_type)";
	add1="getattr_lnk_files_pattern($1,file_type,file_type)";
	add_number =1;
}
if(iii==2981){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_all_files";
	add0="dontaudit $1 file_type:file getattr;";
}
if(iii==2982){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_non_security_files";
	add0="dontaudit $1 { file_type -security_file_type }:file getattr;";
}
if(iii==2983){
	add_number=0;
	raw_interface_name="files_read_all_files";
	add0="allow $1 file_type:dir list_dir_perms;";
	add1="read_files_pattern($1,file_type,file_type)";
	add_number =1;
	add2="auth_read_shadow($1)";
	add_number =2;
}
if(iii==2984){
	add_number=0;
	raw_interface_name="files_execmod_all_files";
	add0="allow $1 file_type:file execmod;";
	add1="refpolicywarn(`$0($1) has no effect in strict policy.')";
	add_number =1;
}
if(iii==2985){
	add_number=0;
	raw_interface_name="files_read_non_security_files";
	add0="read_files_pattern($1,{ file_type -security_file_type },{ file_type -security_file_type })";
	add1="read_lnk_files_pattern($1,{ file_type -security_file_type },{ file_type -security_file_type })";
	add_number =1;
}
if(iii==2986){
	add_number=0;
	raw_interface_name="files_read_all_dirs_except";
	add0="allow $1 { file_type $2 }:dir list_dir_perms;";
	add1="allow $1 { file_type $2 }:dir list_dir_perms;";
	add_number =1;
}
if(iii==2987){
	add_number=0;
	raw_interface_name="files_read_all_files_except";
	add0="read_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add1="read_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =1;
}
if(iii==2988){
	add_number=0;
	raw_interface_name="files_read_all_symlinks_except";
	add0="read_lnk_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add1="read_lnk_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =1;
}
if(iii==2989){
	add_number=0;
	raw_interface_name="files_getattr_all_symlinks";
	add0="getattr_lnk_files_pattern($1,file_type,file_type)";
}
if(iii==2990){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_all_symlinks";
	add0="dontaudit $1 file_type:lnk_file getattr;";
}
if(iii==2991){
	add_number=0;
	raw_interface_name="files_dontaudit_read_all_symlinks";
	add0="dontaudit $1 file_type:lnk_file read;";
}
if(iii==2992){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_non_security_symlinks";
	add0="dontaudit $1 { file_type -security_file_type }:lnk_file getattr;";
}
if(iii==2993){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_non_security_blk_files";
	add0="dontaudit $1 { file_type -security_file_type }:blk_file getattr;";
}
if(iii==2994){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_non_security_chr_files";
	add0="dontaudit $1 { file_type -security_file_type }:chr_file getattr;";
}
if(iii==2995){
	add_number=0;
	raw_interface_name="files_read_all_symlinks";
	add0="allow $1 file_type:dir list_dir_perms;";
	add1="read_lnk_files_pattern($1,file_type,file_type)";
	add_number =1;
}
if(iii==2996){
	add_number=0;
	raw_interface_name="files_getattr_all_pipes";
	add0="allow $1 file_type:dir list_dir_perms;";
	add1="getattr_fifo_files_pattern($1,file_type,file_type)";
	add_number =1;
}
if(iii==2997){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_all_pipes";
	add0="dontaudit $1 file_type:fifo_file getattr;";
}
if(iii==2998){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_non_security_pipes";
	add0="dontaudit $1 { file_type -security_file_type }:fifo_file getattr;";
}
if(iii==2999){
	add_number=0;
	raw_interface_name="files_getattr_all_sockets";
	add0="allow $1 file_type:dir list_dir_perms;";
	add1="getattr_sock_files_pattern($1,file_type,file_type)";
	add_number =1;
}
if(iii==3000){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_all_sockets";
	add0="dontaudit $1 file_type:sock_file getattr;";
}
if(iii==3001){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_non_security_sockets";
	add0="dontaudit $1 { file_type -security_file_type }:sock_file getattr;";
}
if(iii==3002){
	add_number=0;
	raw_interface_name="files_read_all_blk_files";
	add0="read_blk_files_pattern($1,file_type,file_type)";
}
if(iii==3003){
	add_number=0;
	raw_interface_name="files_read_all_chr_files";
	add0="read_chr_files_pattern($1,file_type,file_type)";
}
if(iii==3004){
	add_number=0;
	raw_interface_name="files_relabel_all_files";
	add0="allow $1 { file_type $2 }:dir list_dir_perms;";
	add1="allow $1 { file_type $2 }:dir list_dir_perms;";
	add_number =1;
	add2="relabel_dirs_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =2;
	add3="relabel_dirs_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =3;
	add4="relabel_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =4;
	add5="relabel_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =5;
	add6="relabel_lnk_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =6;
	add7="relabel_lnk_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =7;
	add8="relabel_fifo_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =8;
	add9="relabel_fifo_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =9;
	add10="relabel_sock_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =10;
	add11="relabel_sock_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =11;
	add12="relabelfrom_blk_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =12;
	add13="relabelfrom_blk_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =13;
	add14="relabelfrom_chr_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =14;
	add15="relabelfrom_chr_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =15;
	add16="seutil_relabelto_bin_policy($1)";
	add_number =16;
}
if(iii==3005){
	add_number=0;
	raw_interface_name="files_manage_all_files";
	add0="manage_dirs_pattern($1,{ file_type $2 },{ file_type $2 })";
	add1="manage_dirs_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =1;
	add2="manage_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =2;
	add3="manage_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =3;
	add4="manage_lnk_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =4;
	add5="manage_lnk_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =5;
	add6="manage_fifo_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =6;
	add7="manage_fifo_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =7;
	add8="manage_sock_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =8;
	add9="manage_sock_files_pattern($1,{ file_type $2 },{ file_type $2 })";
	add_number =9;
	add10="seutil_create_bin_policy($1)";
	add_number =10;
	add11="files_manage_kernel_modules($1)";
	add_number =11;
}
if(iii==3006){
	add_number=0;
	raw_interface_name="files_search_all";
	add0="allow $1 file_type:dir search_dir_perms;";
}
if(iii==3007){
	add_number=0;
	raw_interface_name="files_list_all";
	add0="allow $1 file_type:dir list_dir_perms;";
}
if(iii==3008){
	add_number=0;
	raw_interface_name="files_dontaudit_search_all_dirs";
	add0="dontaudit $1 file_type:dir search_dir_perms;";
}
if(iii==3009){
	add_number=0;
	raw_interface_name="files_getattr_all_file_type_fs";
	add0="allow $1 file_type:filesystem getattr;";
}
if(iii==3010){
	add_number=0;
	raw_interface_name="files_relabelto_all_file_type_fs";
	add0="allow $1 file_type:filesystem relabelto;";
}
if(iii==3011){
	add_number=0;
	raw_interface_name="files_mount_all_file_type_fs";
	add0="allow $1 file_type:filesystem mount;";
}
if(iii==3012){
	add_number=0;
	raw_interface_name="files_unmount_all_file_type_fs";
	add0="allow $1 file_type:filesystem unmount;";
}
if(iii==3013){
	add_number=0;
	raw_interface_name="files_mounton_all_mountpoints";
	add0="allow $1 mountpoint:dir { getattr search mounton };";
	add1="allow $1 mountpoint:file { getattr mounton };";
	add_number =1;
}
if(iii==3014){
	add_number=0;
	raw_interface_name="files_getattr_all_mountpoints";
	add0="allow $1 mountpoint:dir getattr;";
}
if(iii==3015){
	add_number=0;
	raw_interface_name="files_list_root";
	add0="allow $1 root_t:dir list_dir_perms;";
	add1="allow $1 root_t:lnk_file r_file_perms;";
	add_number =1;
}
if(iii==3016){
	add_number=0;
	raw_interface_name="files_root_filetrans";
	add0="filetrans_pattern($1,root_t,$2,$3)";
	add1="filetrans_pattern($1,root_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,root_t,$2,$3)";
	add_number =2;
}
if(iii==3017){
	add_number=0;
	raw_interface_name="files_dontaudit_read_root_files";
	add0="dontaudit $1 root_t:file { getattr read };";
}
if(iii==3018){
	add_number=0;
	raw_interface_name="files_dontaudit_rw_root_files";
	add0="dontaudit $1 root_t:file { read write };";
}
if(iii==3019){
	add_number=0;
	raw_interface_name="files_dontaudit_rw_root_chr_files";
	add0="dontaudit $1 root_t:chr_file { read write };";
}
if(iii==3020){
	add_number=0;
	raw_interface_name="files_delete_root_dir_entry";
	add0="allow $1 root_t:dir rw_dir_perms;";
}
if(iii==3021){
	add_number=0;
	raw_interface_name="files_unmount_rootfs";
	add0="allow $1 root_t:filesystem unmount;";
}
if(iii==3022){
	add_number=0;
	raw_interface_name="files_getattr_boot_dirs";
	add0="allow $1 boot_t:dir getattr;";
}
if(iii==3023){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_boot_dirs";
	add0="dontaudit $1 boot_t:dir getattr;";
}
if(iii==3024){
	add_number=0;
	raw_interface_name="files_search_boot";
	add0="allow $1 boot_t:dir search_dir_perms;";
}
if(iii==3025){
	add_number=0;
	raw_interface_name="files_dontaudit_search_boot";
	add0="dontaudit $1 boot_t:dir search_dir_perms;";
}
if(iii==3026){
	add_number=0;
	raw_interface_name="files_create_boot_dirs";
	add0="allow $1 boot_t:dir { create rw_dir_perms };";
}
if(iii==3027){
	add_number=0;
	raw_interface_name="files_boot_filetrans";
	add0="filetrans_pattern($1,boot_t,$2,$3)";
	add1="filetrans_pattern($1,boot_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,boot_t,$2,$3)";
	add_number =2;
}
if(iii==3028){
	add_number=0;
	raw_interface_name="files_manage_boot_files";
	add0="manage_files_pattern($1,boot_t,boot_t)";
}
if(iii==3029){
	add_number=0;
	raw_interface_name="files_relabelfrom_boot_files";
	add0="relabelfrom_files_pattern($1,boot_t,boot_t)";
}
if(iii==3030){
	add_number=0;
	raw_interface_name="files_rw_boot_symlinks";
	add0="allow $1 boot_t:dir list_dir_perms;";
	add1="rw_lnk_files_pattern($1,boot_t,boot_t)";
	add_number =1;
}
if(iii==3031){
	add_number=0;
	raw_interface_name="files_manage_boot_symlinks";
	add0="manage_lnk_files_pattern($1,boot_t,boot_t)";
}
if(iii==3032){
	add_number=0;
	raw_interface_name="files_read_kernel_img";
	add0="allow $1 boot_t:dir list_dir_perms;";
	add1="read_files_pattern($1,boot_t,boot_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,boot_t,boot_t)";
	add_number =2;
}
if(iii==3033){
	add_number=0;
	raw_interface_name="files_create_kernel_img";
	add0="allow $1 boot_t:file { getattr read write create };";
	add1="manage_lnk_files_pattern($1,boot_t,boot_t)";
	add_number =1;
}
if(iii==3034){
	add_number=0;
	raw_interface_name="files_delete_kernel";
	add0="delete_files_pattern($1,boot_t,boot_t)";
}
if(iii==3035){
	add_number=0;
	raw_interface_name="files_getattr_default_dirs";
	add0="allow $1 default_t:dir getattr;";
}
if(iii==3036){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_default_dirs";
	add0="dontaudit $1 default_t:dir getattr;";
}
if(iii==3037){
	add_number=0;
	raw_interface_name="files_search_default";
	add0="allow $1 default_t:dir search_dir_perms;";
}
if(iii==3038){
	add_number=0;
	raw_interface_name="files_list_default";
	add0="allow $1 default_t:dir list_dir_perms;";
}
if(iii==3039){
	add_number=0;
	raw_interface_name="files_dontaudit_list_default";
	add0="dontaudit $1 default_t:dir list_dir_perms;";
}
if(iii==3040){
	add_number=0;
	raw_interface_name="files_mounton_default";
	add0="allow $1 default_t:dir { getattr search mounton };";
}
if(iii==3041){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_default_files";
	add0="dontaudit $1 default_t:file getattr;";
}
if(iii==3042){
	add_number=0;
	raw_interface_name="files_read_default_files";
	add0="allow $1 default_t:file read_file_perms;";
}
if(iii==3043){
	add_number=0;
	raw_interface_name="files_dontaudit_read_default_files";
	add0="dontaudit $1 default_t:file read_file_perms;";
}
if(iii==3044){
	add_number=0;
	raw_interface_name="files_read_default_symlinks";
	add0="allow $1 default_t:lnk_file read_lnk_file_perms;";
}
if(iii==3045){
	add_number=0;
	raw_interface_name="files_read_default_sockets";
	add0="allow $1 default_t:sock_file read_sock_file_perms;";
}
if(iii==3046){
	add_number=0;
	raw_interface_name="files_read_default_pipes";
	add0="allow $1 default_t:fifo_file read_fifo_file_perms;";
}
if(iii==3047){
	add_number=0;
	raw_interface_name="files_search_etc";
	add0="allow $1 etc_t:dir search_dir_perms;";
}
if(iii==3048){
	add_number=0;
	raw_interface_name="files_setattr_etc_dirs";
	add0="allow $1 etc_t:dir setattr;";
}
if(iii==3049){
	add_number=0;
	raw_interface_name="files_list_etc";
	add0="allow $1 etc_t:dir list_dir_perms;";
}
if(iii==3050){
	add_number=0;
	raw_interface_name="files_rw_etc_dirs";
	add0="allow $1 etc_t:dir rw_dir_perms;";
}
if(iii==3051){
	add_number=0;
	raw_interface_name="files_read_etc_files";
	add0="allow $1 etc_t:dir list_dir_perms;";
	add1="read_files_pattern($1,etc_t,etc_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,etc_t,etc_t)";
	add_number =2;
}
if(iii==3052){
	add_number=0;
	raw_interface_name="files_dontaudit_write_etc_files";
	add0="dontaudit $1 etc_t:file write;";
}
if(iii==3053){
	add_number=0;
	raw_interface_name="files_rw_etc_files";
	add0="allow $1 etc_t:dir list_dir_perms;";
	add1="rw_files_pattern($1,etc_t,etc_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,etc_t,etc_t)";
	add_number =2;
}
if(iii==3054){
	add_number=0;
	raw_interface_name="files_manage_etc_files";
	add0="manage_files_pattern($1,etc_t,etc_t)";
	add1="read_lnk_files_pattern($1,etc_t,etc_t)";
	add_number =1;
}
if(iii==3055){
	add_number=0;
	raw_interface_name="files_delete_etc_files";
	add0="delete_files_pattern($1,etc_t,etc_t)";
}
if(iii==3056){
	add_number=0;
	raw_interface_name="files_exec_etc_files";
	add0="allow $1 etc_t:dir list_dir_perms;";
	add1="read_lnk_files_pattern($1,etc_t,etc_t)";
	add_number =1;
	add2="exec_files_pattern($1,etc_t,etc_t)";
	add_number =2;
}
if(iii==3057){
	add_number=0;
	raw_interface_name="files_relabel_etc_files";
	add0="allow $1 etc_t:dir list_dir_perms;";
	add1="relabel_files_pattern($1,etc_t,etc_t)";
	add_number =1;
}
if(iii==3058){
	add_number=0;
	raw_interface_name="files_read_etc_symlinks";
	add0="read_lnk_files_pattern($1,etc_t,etc_t)";
}
if(iii==3059){
	add_number=0;
	raw_interface_name="files_manage_etc_symlinks";
	add0="manage_lnk_files_pattern($1,etc_t,etc_t)";
}
if(iii==3060){
	add_number=0;
	raw_interface_name="files_etc_filetrans";
	add0="filetrans_pattern($1,etc_t,$2,$3)";
	add1="filetrans_pattern($1,etc_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,etc_t,$2,$3)";
	add_number =2;
}
if(iii==3061){
	add_number=0;
	raw_interface_name="files_create_boot_flag";
	add0="allow $1 etc_runtime_t:file manage_file_perms;";
	add1="filetrans_pattern($1,root_t,etc_runtime_t,file)";
	add_number =1;
}
if(iii==3062){
	add_number=0;
	raw_interface_name="files_read_etc_runtime_files";
	add0="allow $1 etc_t:dir list_dir_perms;";
	add1="read_files_pattern($1,etc_t,etc_runtime_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,etc_t,etc_runtime_t)";
	add_number =2;
}
if(iii==3063){
	add_number=0;
	raw_interface_name="files_dontaudit_read_etc_runtime_files";
	add0="dontaudit $1 etc_runtime_t:file { getattr read };";
}
if(iii==3064){
	add_number=0;
	raw_interface_name="files_rw_etc_runtime_files";
	add0="allow $1 etc_t:dir list_dir_perms;";
	add1="rw_files_pattern($1,etc_t,etc_runtime_t)";
	add_number =1;
}
if(iii==3065){
	add_number=0;
	raw_interface_name="files_manage_etc_runtime_files";
	add0="manage_files_pattern($1,{ etc_t etc_runtime_t },etc_runtime_t)";
}
if(iii==3066){
	add_number=0;
	raw_interface_name="files_etc_filetrans_etc_runtime";
	add0="filetrans_pattern($1,etc_t,etc_runtime_t,$2)";
	add1="filetrans_pattern($1,etc_t,etc_runtime_t,$2)";
	add_number =1;
}
if(iii==3067){
	add_number=0;
	raw_interface_name="files_getattr_isid_type_dirs";
	add0="allow $1 file_t:dir getattr;";
}
if(iii==3068){
	add_number=0;
	raw_interface_name="files_dontaudit_search_isid_type_dirs";
	add0="dontaudit $1 file_t:dir search_dir_perms;";
}
if(iii==3069){
	add_number=0;
	raw_interface_name="files_list_isid_type_dirs";
	add0="allow $1 file_t:dir list_dir_perms;";
}
if(iii==3070){
	add_number=0;
	raw_interface_name="files_rw_isid_type_dirs";
	add0="allow $1 file_t:dir rw_dir_perms;";
}
if(iii==3071){
	add_number=0;
	raw_interface_name="files_manage_isid_type_dirs";
	add0="allow $1 file_t:dir manage_dir_perms;";
}
if(iii==3072){
	add_number=0;
	raw_interface_name="files_mounton_isid_type_dirs";
	add0="allow $1 file_t:dir { search_dir_perms mounton };";
}
if(iii==3073){
	add_number=0;
	raw_interface_name="files_read_isid_type_files";
	add0="allow $1 file_t:file read_file_perms;";
}
if(iii==3074){
	add_number=0;
	raw_interface_name="files_manage_isid_type_files";
	add0="allow $1 file_t:file manage_file_perms;";
}
if(iii==3075){
	add_number=0;
	raw_interface_name="files_manage_isid_type_symlinks";
	add0="allow $1 file_t:lnk_file manage_lnk_file_perms;";
}
if(iii==3076){
	add_number=0;
	raw_interface_name="files_rw_isid_type_blk_files";
	add0="allow $1 file_t:blk_file rw_blk_file_perms;";
}
if(iii==3077){
	add_number=0;
	raw_interface_name="files_manage_isid_type_blk_files";
	add0="allow $1 file_t:blk_file manage_blk_file_perms;";
}
if(iii==3078){
	add_number=0;
	raw_interface_name="files_manage_isid_type_chr_files";
	add0="allow $1 file_t:chr_file manage_chr_file_perms;";
}
if(iii==3079){
	add_number=0;
	raw_interface_name="files_getattr_home_dir";
	add0="allow $1 home_root_t:dir getattr;";
}
if(iii==3080){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_home_dir";
	add0="dontaudit $1 home_root_t:dir getattr;";
}
if(iii==3081){
	add_number=0;
	raw_interface_name="files_search_home";
	add0="allow $1 home_root_t:dir search_dir_perms;";
}
if(iii==3082){
	add_number=0;
	raw_interface_name="files_dontaudit_search_home";
	add0="dontaudit $1 home_root_t:dir search_dir_perms;";
}
if(iii==3083){
	add_number=0;
	raw_interface_name="files_dontaudit_list_home";
	add0="dontaudit $1 home_root_t:dir list_dir_perms;";
}
if(iii==3084){
	add_number=0;
	raw_interface_name="files_list_home";
	add0="allow $1 home_root_t:dir list_dir_perms;";
}
if(iii==3085){
	add_number=0;
	raw_interface_name="files_home_filetrans";
	add0="filetrans_pattern($1,home_root_t,$2,$3)";
	add1="filetrans_pattern($1,home_root_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,home_root_t,$2,$3)";
	add_number =2;
}
if(iii==3086){
	add_number=0;
	raw_interface_name="files_getattr_lost_found_dirs";
	add0="allow $1 lost_found_t:dir getattr;";
}
if(iii==3087){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_lost_found_dirs";
	add0="dontaudit $1 lost_found_t:dir getattr;";
}
if(iii==3088){
	add_number=0;
	raw_interface_name="files_manage_lost_found";
	add0="manage_dirs_pattern($1,lost_found_t,lost_found_t)";
	add1="manage_files_pattern($1,lost_found_t,lost_found_t)";
	add_number =1;
	add2="manage_lnk_files_pattern($1,lost_found_t,lost_found_t)";
	add_number =2;
	add3="manage_fifo_files_pattern($1,lost_found_t,lost_found_t)";
	add_number =3;
	add4="manage_sock_files_pattern($1,lost_found_t,lost_found_t)";
	add_number =4;
}
if(iii==3089){
	add_number=0;
	raw_interface_name="files_search_mnt";
	add0="allow $1 mnt_t:dir search_dir_perms;";
}
if(iii==3090){
	add_number=0;
	raw_interface_name="files_dontaudit_search_mnt";
	add0="dontaudit $1 mnt_t:dir search_dir_perms;";
}
if(iii==3091){
	add_number=0;
	raw_interface_name="files_list_mnt";
	add0="allow $1 mnt_t:dir list_dir_perms;";
}
if(iii==3092){
	add_number=0;
	raw_interface_name="files_mounton_mnt";
	add0="allow $1 mnt_t:dir { search_dir_perms mounton };";
}
if(iii==3093){
	add_number=0;
	raw_interface_name="files_manage_mnt_dirs";
	add0="allow $1 mnt_t:dir manage_dir_perms;";
}
if(iii==3094){
	add_number=0;
	raw_interface_name="files_manage_mnt_files";
	add0="manage_files_pattern($1,mnt_t,mnt_t)";
}
if(iii==3095){
	add_number=0;
	raw_interface_name="files_manage_mnt_symlinks";
	add0="manage_lnk_files_pattern($1,mnt_t,mnt_t)";
}
if(iii==3096){
	add_number=0;
	raw_interface_name="files_search_kernel_modules";
	add0="allow $1 modules_object_t:dir search_dir_perms;";
}
if(iii==3097){
	add_number=0;
	raw_interface_name="files_list_kernel_modules";
	add0="allow $1 modules_object_t:dir list_dir_perms;";
}
if(iii==3098){
	add_number=0;
	raw_interface_name="files_getattr_kernel_modules";
	add0="getattr_files_pattern($1,modules_object_t,modules_object_t)";
}
if(iii==3099){
	add_number=0;
	raw_interface_name="files_read_kernel_modules";
	add0="allow $1 modules_object_t:dir list_dir_perms;";
	add1="read_files_pattern($1,modules_object_t,modules_object_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,modules_object_t,modules_object_t)";
	add_number =2;
}
if(iii==3100){
	add_number=0;
	raw_interface_name="files_write_kernel_modules";
	add0="allow $1 modules_object_t:dir list_dir_perms;";
	add1="write_files_pattern($1,modules_object_t,modules_object_t)";
	add_number =1;
}
if(iii==3101){
	add_number=0;
	raw_interface_name="files_delete_kernel_modules";
	add0="delete_files_pattern($1,modules_object_t,modules_object_t)";
}
if(iii==3102){
	add_number=0;
	raw_interface_name="files_manage_kernel_modules";
	add0="manage_files_pattern($1,modules_object_t,modules_object_t)";
}
if(iii==3103){
	add_number=0;
	raw_interface_name="files_relabel_kernel_modules";
	add0="relabel_files_pattern($1,modules_object_t,modules_object_t)";
	add1="allow $1 modules_object_t:dir list_dir_perms;";
	add_number =1;
}
if(iii==3104){
	add_number=0;
	raw_interface_name="files_kernel_modules_filetrans";
	add0="filetrans_pattern($1,modules_object_t,$2,$3)";
	add1="filetrans_pattern($1,modules_object_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,modules_object_t,$2,$3)";
	add_number =2;
}
if(iii==3105){
	add_number=0;
	raw_interface_name="files_list_world_readable";
	add0="allow $1 readable_t:dir list_dir_perms;";
}
if(iii==3106){
	add_number=0;
	raw_interface_name="files_read_world_readable_files";
	add0="allow $1 readable_t:file read_file_perms;";
}
if(iii==3107){
	add_number=0;
	raw_interface_name="files_read_world_readable_symlinks";
	add0="allow $1 readable_t:lnk_file read_lnk_file_perms;";
}
if(iii==3108){
	add_number=0;
	raw_interface_name="files_read_world_readable_pipes";
	add0="allow $1 readable_t:fifo_file read_fifo_file_perms;";
}
if(iii==3109){
	add_number=0;
	raw_interface_name="files_read_world_readable_sockets";
	add0="allow $1 readable_t:sock_file read_sock_file_perms;";
}
if(iii==3110){
	add_number=0;
	raw_interface_name="files_associate_tmp";
	add0="allow $1 tmp_t:filesystem associate;";
}
if(iii==3111){
	add_number=0;
	raw_interface_name="files_getattr_tmp_dirs";
	add0="allow $1 tmp_t:dir getattr;";
}
if(iii==3112){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_tmp_dirs";
	add0="dontaudit $1 tmp_t:dir getattr;";
}
if(iii==3113){
	add_number=0;
	raw_interface_name="files_search_tmp";
	add0="allow $1 tmp_t:dir search_dir_perms;";
}
if(iii==3114){
	add_number=0;
	raw_interface_name="files_dontaudit_search_tmp";
	add0="dontaudit $1 tmp_t:dir search_dir_perms;";
}
if(iii==3115){
	add_number=0;
	raw_interface_name="files_list_tmp";
	add0="allow $1 tmp_t:dir list_dir_perms;";
}
if(iii==3116){
	add_number=0;
	raw_interface_name="files_dontaudit_list_tmp";
	add0="dontaudit $1 tmp_t:dir list_dir_perms;";
}
if(iii==3117){
	add_number=0;
	raw_interface_name="files_read_generic_tmp_files";
	add0="read_files_pattern($1,tmp_t,tmp_t)";
}
if(iii==3118){
	add_number=0;
	raw_interface_name="files_manage_generic_tmp_files";
	add0="manage_files_pattern($1,tmp_t,tmp_t)";
}
if(iii==3119){
	add_number=0;
	raw_interface_name="files_read_generic_tmp_symlinks";
	add0="read_lnk_files_pattern($1,tmp_t,tmp_t)";
}
if(iii==3120){
	add_number=0;
	raw_interface_name="files_rw_generic_tmp_sockets";
	add0="rw_sock_files_pattern($1,tmp_t,tmp_t)";
}
if(iii==3121){
	add_number=0;
	raw_interface_name="files_setattr_all_tmp_dirs";
	add0="allow $1 tmpfile:dir { search_dir_perms setattr };";
}
if(iii==3122){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_all_tmp_files";
	add0="dontaudit $1 tmpfile:file getattr;";
}
if(iii==3123){
	add_number=0;
	raw_interface_name="files_read_all_tmp_files";
	add0="read_files_pattern($1,tmpfile,tmpfile)";
}
if(iii==3124){
	add_number=0;
	raw_interface_name="files_tmp_filetrans";
	add0="filetrans_pattern($1,tmp_t,$2,$3)";
	add1="filetrans_pattern($1,tmp_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,tmp_t,$2,$3)";
	add_number =2;
}
if(iii==3125){
	add_number=0;
	raw_interface_name="files_purge_tmp";
	add0="allow $1 tmpfile:dir list_dir_perms;";
	add1="delete_dirs_pattern($1,tmpfile,tmpfile)";
	add_number =1;
	add2="delete_files_pattern($1,tmpfile,tmpfile)";
	add_number =2;
	add3="delete_lnk_files_pattern($1,tmpfile,tmpfile)";
	add_number =3;
	add4="delete_fifo_files_pattern($1,tmpfile,tmpfile)";
	add_number =4;
	add5="delete_sock_files_pattern($1,tmpfile,tmpfile)";
	add_number =5;
}
if(iii==3126){
	add_number=0;
	raw_interface_name="files_search_usr";
	add0="allow $1 usr_t:dir search_dir_perms;";
}
if(iii==3127){
	add_number=0;
	raw_interface_name="files_list_usr";
	add0="allow $1 usr_t:dir list_dir_perms;";
}
if(iii==3128){
	add_number=0;
	raw_interface_name="files_rw_usr_dirs";
	add0="allow $1 usr_t:dir rw_dir_perms;";
}
if(iii==3129){
	add_number=0;
	raw_interface_name="files_getattr_usr_files";
	add0="getattr_files_pattern($1,usr_t,usr_t)";
}
if(iii==3130){
	add_number=0;
	raw_interface_name="files_read_usr_files";
	add0="allow $1 usr_t:dir list_dir_perms;";
	add1="read_files_pattern($1,usr_t,usr_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,usr_t,usr_t)";
	add_number =2;
}
if(iii==3131){
	add_number=0;
	raw_interface_name="files_exec_usr_files";
	add0="allow $1 usr_t:dir list_dir_perms;";
	add1="exec_files_pattern($1,usr_t,usr_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,usr_t,usr_t)";
	add_number =2;
}
if(iii==3132){
	add_number=0;
	raw_interface_name="files_manage_usr_files";
	add0="manage_files_pattern($1, usr_t, usr_t)";
}
if(iii==3133){
	add_number=0;
	raw_interface_name="files_relabelto_usr_files";
	add0="relabelto_files_pattern($1,usr_t,usr_t)";
}
if(iii==3134){
	add_number=0;
	raw_interface_name="files_read_usr_symlinks";
	add0="read_lnk_files_pattern($1,usr_t,usr_t)";
}
if(iii==3135){
	add_number=0;
	raw_interface_name="files_usr_filetrans";
	add0="filetrans_pattern($1,usr_t,$2,$3)";
	add1="filetrans_pattern($1,usr_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,usr_t,$2,$3)";
	add_number =2;
}
if(iii==3136){
	add_number=0;
	raw_interface_name="files_dontaudit_search_src";
	add0="dontaudit $1 src_t:dir search_dir_perms;";
}
if(iii==3137){
	add_number=0;
	raw_interface_name="files_getattr_usr_src_files";
	add0="getattr_files_pattern($1,src_t,src_t)";
	add1="read_lnk_files_pattern($1,usr_t,src_t)";
	add_number =1;
}
if(iii==3138){
	add_number=0;
	raw_interface_name="files_read_usr_src_files";
	add0="allow $1 usr_t:dir search_dir_perms;";
	add1="read_files_pattern($1,{ usr_t src_t },src_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,{ usr_t src_t },src_t)";
	add_number =2;
	add3="allow $1 src_t:dir list_dir_perms;";
	add_number =3;
}
if(iii==3139){
	add_number=0;
	raw_interface_name="files_exec_usr_src_files";
	add0="list_dirs_pattern($1,usr_t,src_t)";
	add1="exec_files_pattern($1,src_t,src_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,src_t,src_t)";
	add_number =2;
}
if(iii==3140){
	add_number=0;
	raw_interface_name="files_create_kernel_symbol_table";
	add0="allow $1 boot_t:dir ra_dir_perms;";
	add1="allow $1 system_map_t:file { rw_file_perms create };";
	add_number =1;
}
if(iii==3141){
	add_number=0;
	raw_interface_name="files_read_kernel_symbol_table";
	add0="allow $1 boot_t:dir list_dir_perms;";
	add1="read_files_pattern($1,boot_t,system_map_t)";
	add_number =1;
}
if(iii==3142){
	add_number=0;
	raw_interface_name="files_delete_kernel_symbol_table";
	add0="allow $1 boot_t:dir list_dir_perms;";
	add1="delete_files_pattern($1,boot_t,system_map_t)";
	add_number =1;
}
if(iii==3143){
	add_number=0;
	raw_interface_name="files_search_var";
	add0="allow $1 var_t:dir search_dir_perms;";
}
if(iii==3144){
	add_number=0;
	raw_interface_name="files_dontaudit_write_var_dirs";
	add0="dontaudit $1 var_t:dir write;";
}
if(iii==3145){
	add_number=0;
	raw_interface_name="files_write_var_dirs";
	add0="allow $1 var_t:dir write;";
}
if(iii==3146){
	add_number=0;
	raw_interface_name="files_dontaudit_search_var";
	add0="dontaudit $1 var_t:dir search_dir_perms;";
}
if(iii==3147){
	add_number=0;
	raw_interface_name="files_list_var";
	add0="allow $1 var_t:dir list_dir_perms;";
}
if(iii==3148){
	add_number=0;
	raw_interface_name="files_manage_var_dirs";
	add0="allow $1 var_t:dir manage_dir_perms;";
}
if(iii==3149){
	add_number=0;
	raw_interface_name="files_read_var_files";
	add0="read_files_pattern($1,var_t,var_t)";
}
if(iii==3150){
	add_number=0;
	raw_interface_name="files_rw_var_files";
	add0="rw_files_pattern($1,var_t,var_t)";
}
if(iii==3151){
	add_number=0;
	raw_interface_name="files_manage_var_files";
	add0="manage_files_pattern($1,var_t,var_t)";
}
if(iii==3152){
	add_number=0;
	raw_interface_name="files_read_var_symlinks";
	add0="read_lnk_files_pattern($1,var_t,var_t)";
}
if(iii==3153){
	add_number=0;
	raw_interface_name="files_manage_var_symlinks";
	add0="manage_lnk_files_pattern($1,var_t,var_t)";
}
if(iii==3154){
	add_number=0;
	raw_interface_name="files_var_filetrans";
	add0="filetrans_pattern($1,var_t,$2,$3)";
	add1="filetrans_pattern($1,var_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,var_t,$2,$3)";
	add_number =2;
}
if(iii==3155){
	add_number=0;
	raw_interface_name="files_getattr_var_lib_dirs";
	add0="getattr_dirs_pattern($1,var_t,var_lib_t)";
}
if(iii==3156){
	add_number=0;
	raw_interface_name="files_search_var_lib";
	add0="search_dirs_pattern($1,var_t,var_lib_t)";
}
if(iii==3157){
	add_number=0;
	raw_interface_name="files_list_var_lib";
	add0="list_dirs_pattern($1,var_t,var_lib_t)";
}
if(iii==3158){
	add_number=0;
	raw_interface_name="files_var_lib_filetrans";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="filetrans_pattern($1,var_lib_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,var_lib_t,$2,$3)";
	add_number =2;
	add3="filetrans_pattern($1,var_lib_t,$2,$3)";
	add_number =3;
}
if(iii==3159){
	add_number=0;
	raw_interface_name="files_read_var_lib_files";
	add0="allow $1 var_lib_t:dir list_dir_perms;";
	add1="read_files_pattern($1,{ var_t var_lib_t },var_lib_t)";
	add_number =1;
}
if(iii==3160){
	add_number=0;
	raw_interface_name="files_read_var_lib_symlinks";
	add0="read_lnk_files_pattern($1,{ var_t var_lib_t },var_lib_t)";
}
if(iii==3161){
	add_number=0;
	raw_interface_name="files_manage_urandom_seed";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="manage_files_pattern($1,var_lib_t,var_lib_t)";
	add_number =1;
}
if(iii==3162){
	add_number=0;
	raw_interface_name="files_manage_mounttab";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="manage_files_pattern($1,var_lib_t,var_lib_t)";
	add_number =1;
}
if(iii==3163){
	add_number=0;
	raw_interface_name="files_search_locks";
	add0="search_dirs_pattern($1,var_t,var_lock_t)";
}
if(iii==3164){
	add_number=0;
	raw_interface_name="files_dontaudit_search_locks";
	add0="dontaudit $1 var_lock_t:dir search_dir_perms;";
}
if(iii==3165){
	add_number=0;
	raw_interface_name="files_rw_lock_dirs";
	add0="rw_dirs_pattern($1,var_t,var_lock_t)";
}
if(iii==3166){
	add_number=0;
	raw_interface_name="files_getattr_generic_locks";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="allow $1 var_lock_t:dir list_dir_perms;";
	add_number =1;
	add2="getattr_files_pattern($1,var_lock_t,var_lock_t)";
	add_number =2;
}
if(iii==3167){
	add_number=0;
	raw_interface_name="files_manage_generic_locks";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="manage_files_pattern($1,var_lock_t,var_lock_t)";
	add_number =1;
}
if(iii==3168){
	add_number=0;
	raw_interface_name="files_delete_all_locks";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="delete_files_pattern($1,lockfile,lockfile)";
	add_number =1;
}
if(iii==3169){
	add_number=0;
	raw_interface_name="files_read_all_locks";
	add0="allow $1 { var_t var_lock_t }:dir search_dir_perms;";
	add1="allow $1 lockfile:dir list_dir_perms;";
	add_number =1;
	add2="read_files_pattern($1,lockfile,lockfile)";
	add_number =2;
	add3="read_lnk_files_pattern($1,lockfile,lockfile)";
	add_number =3;
}
if(iii==3170){
	add_number=0;
	raw_interface_name="files_lock_filetrans";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="filetrans_pattern($1,var_lock_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,var_lock_t,$2,$3)";
	add_number =2;
	add3="filetrans_pattern($1,var_lock_t,$2,$3)";
	add_number =3;
}
if(iii==3171){
	add_number=0;
	raw_interface_name="files_dontaudit_getattr_pid_dirs";
	add0="dontaudit $1 var_run_t:dir getattr;";
}
if(iii==3172){
	add_number=0;
	raw_interface_name="files_search_pids";
	add0="search_dirs_pattern($1,var_t,var_run_t)";
}
if(iii==3173){
	add_number=0;
	raw_interface_name="files_dontaudit_search_pids";
	add0="dontaudit $1 var_run_t:dir search_dir_perms;";
}
if(iii==3174){
	add_number=0;
	raw_interface_name="files_list_pids";
	add0="list_dirs_pattern($1,var_t,var_run_t)";
}
if(iii==3175){
	add_number=0;
	raw_interface_name="files_pid_filetrans";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="filetrans_pattern($1,var_run_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,var_run_t,$2,$3)";
	add_number =2;
	add3="filetrans_pattern($1,var_run_t,$2,$3)";
	add_number =3;
}
if(iii==3176){
	add_number=0;
	raw_interface_name="files_rw_generic_pids";
	add0="list_dirs_pattern($1,var_t,var_run_t)";
	add1="rw_files_pattern($1,var_run_t,var_run_t)";
	add_number =1;
}
if(iii==3177){
	add_number=0;
	raw_interface_name="files_dontaudit_write_all_pids";
	add0="dontaudit $1 pidfile:file write;";
}
if(iii==3178){
	add_number=0;
	raw_interface_name="files_dontaudit_ioctl_all_pids";
	add0="dontaudit $1 pidfile:file ioctl;";
}
if(iii==3179){
	add_number=0;
	raw_interface_name="files_read_all_pids";
	add0="list_dirs_pattern($1,var_t,pidfile)";
	add1="read_files_pattern($1,pidfile,pidfile)";
	add_number =1;
}
if(iii==3180){
	add_number=0;
	raw_interface_name="files_mounton_all_poly_members";
	add0="allow $1 polymember:dir mounton;";
}
if(iii==3181){
	add_number=0;
	raw_interface_name="files_delete_all_pids";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="allow $1 var_run_t:dir rmdir;";
	add_number =1;
	add2="allow $1 var_run_t:lnk_file delete_lnk_file_perms;";
	add_number =2;
	add3="delete_files_pattern($1,pidfile,pidfile)";
	add_number =3;
	add4="delete_fifo_files_pattern($1,pidfile,pidfile)";
	add_number =4;
	add5="delete_sock_files_pattern($1,pidfile,{ pidfile var_run_t })";
	add_number =5;
}
if(iii==3182){
	add_number=0;
	raw_interface_name="files_delete_all_pid_dirs";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="delete_dirs_pattern($1,pidfile,pidfile)";
	add_number =1;
}
if(iii==3183){
	add_number=0;
	raw_interface_name="files_search_spool";
	add0="search_dirs_pattern($1,var_t,var_spool_t)";
}
if(iii==3184){
	add_number=0;
	raw_interface_name="files_dontaudit_search_spool";
	add0="dontaudit $1 var_spool_t:dir search_dir_perms;";
}
if(iii==3185){
	add_number=0;
	raw_interface_name="files_list_spool";
	add0="list_dirs_pattern($1,var_t,var_spool_t)";
}
if(iii==3186){
	add_number=0;
	raw_interface_name="files_manage_generic_spool_dirs";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="manage_dirs_pattern($1,var_spool_t,var_spool_t)";
	add_number =1;
}
if(iii==3187){
	add_number=0;
	raw_interface_name="files_read_generic_spool";
	add0="list_dirs_pattern($1,var_t,var_spool_t)";
	add1="read_files_pattern($1,var_spool_t,var_spool_t)";
	add_number =1;
}
if(iii==3188){
	add_number=0;
	raw_interface_name="files_manage_generic_spool";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="manage_files_pattern($1,var_spool_t,var_spool_t)";
	add_number =1;
}
if(iii==3189){
	add_number=0;
	raw_interface_name="files_spool_filetrans";
	add0="allow $1 var_t:dir search_dir_perms;";
	add1="filetrans_pattern($1,var_spool_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,var_spool_t,$2,$3)";
	add_number =2;
	add3="filetrans_pattern($1,var_spool_t,$2,$3)";
	add_number =3;
}
if(iii==3190){
	add_number=0;
	raw_interface_name="files_polyinstantiate_all";
	add0="selinux_compute_member($1)";
	add1="allow $1 self:capability { chown fsetid sys_admin };";
	add_number =1;
	add2="allow $1 polydir:dir { create getattr search write add_name setattr mounton rmdir };";
	add_number =2;
	add3="allow $1 polymember:dir search_dir_perms;";
	add_number =3;
	add4="allow $1 polyparent:dir { getattr mounton };";
	add_number =4;
	add5="allow $1 self:process setfscreate;";
	add_number =5;
	add6="allow $1 polymember: dir { create setattr relabelto };";
	add_number =6;
	add7="allow $1 polydir: dir { write add_name };";
	add_number =7;
	add8="allow $1 polyparent:dir { read write remove_name add_name relabelfrom relabelto };";
	add_number =8;
	add9="allow $1 poly_t:dir { create mounton };";
	add_number =9;
	add10="fs_unmount_xattr_fs($1)";
	add_number =10;
}
if(iii==3191){
	add_number=0;
	raw_interface_name="files_unconfined";
	add0="typeattribute $1 files_unconfined_type;";
}
if(iii==3192){
	add_number=0;
	raw_interface_name="files_manage_non_security_dirs";
	add0="allow $1 { file_type -security_file_type }:dir manage_dir_perms;";
	add1=":filesystem.if";
	add_number =1;
}
if(iii==3193){
	add_number=0;
	raw_interface_name="fs_type";
	add0="typeattribute $1 filesystem_type;";
}
if(iii==3194){
	add_number=0;
	raw_interface_name="fs_noxattr_type";
	add0="fs_type($1)";
	add1="typeattribute $1 noxattrfs;";
	add_number =1;
}
if(iii==3195){
	add_number=0;
	raw_interface_name="fs_associate";
	add0="allow $1 fs_t:filesystem associate;";
}
if(iii==3196){
	add_number=0;
	raw_interface_name="fs_associate_noxattr";
	add0="allow $1 noxattrfs:filesystem associate;";
}
if(iii==3197){
	add_number=0;
	raw_interface_name="fs_exec_noxattr";
	add0="allow $1 noxattrfs:file { read getattr lock execute ioctl execute_no_trans };";
	add1="allow $1 noxattrfs:file { read getattr lock execute ioctl execute_no_trans };";
	add_number =1;
}
if(iii==3198){
	add_number=0;
	raw_interface_name="fs_mount_xattr_fs";
	add0="allow $1 fs_t:filesystem mount;";
}
if(iii==3199){
	add_number=0;
	raw_interface_name="fs_remount_xattr_fs";
	add0="allow $1 fs_t:filesystem remount;";
}
if(iii==3200){
	add_number=0;
	raw_interface_name="fs_unmount_xattr_fs";
	add0="allow $1 fs_t:filesystem unmount;";
}
if(iii==3201){
	add_number=0;
	raw_interface_name="fs_getattr_xattr_fs";
	add0="allow $1 fs_t:filesystem getattr;";
}
if(iii==3202){
	add_number=0;
	raw_interface_name="fs_dontaudit_getattr_xattr_fs";
	add0="dontaudit $1 fs_t:filesystem getattr;";
}
if(iii==3203){
	add_number=0;
	raw_interface_name="fs_relabelfrom_xattr_fs";
	add0="allow $1 fs_t:filesystem relabelfrom;";
}
if(iii==3204){
	add_number=0;
	raw_interface_name="fs_get_xattr_fs_quotas";
	add0="allow $1 fs_t:filesystem quotaget;";
}
if(iii==3205){
	add_number=0;
	raw_interface_name="fs_set_xattr_fs_quotas";
	add0="allow $1 fs_t:filesystem quotamod;";
}
if(iii==3206){
	add_number=0;
	raw_interface_name="fs_read_anon_inodefs_files";
	add0="read_files_pattern($1,anon_inodefs_t,anon_inodefs_t)";
}
if(iii==3207){
	add_number=0;
	raw_interface_name="fs_rw_anon_inodefs_files";
	add0="rw_files_pattern($1,anon_inodefs_t,anon_inodefs_t)";
}
if(iii==3208){
	add_number=0;
	raw_interface_name="fs_mount_autofs";
	add0="allow $1 autofs_t:filesystem mount;";
}
if(iii==3209){
	add_number=0;
	raw_interface_name="fs_remount_autofs";
	add0="allow $1 autofs_t:filesystem remount;";
}
if(iii==3210){
	add_number=0;
	raw_interface_name="fs_unmount_autofs";
	add0="allow $1 autofs_t:filesystem unmount;";
}
if(iii==3211){
	add_number=0;
	raw_interface_name="fs_getattr_autofs";
	add0="allow $1 autofs_t:filesystem getattr;";
}
if(iii==3212){
	add_number=0;
	raw_interface_name="fs_search_auto_mountpoints";
	add0="allow $1 autofs_t:dir search_dir_perms;";
}
if(iii==3213){
	add_number=0;
	raw_interface_name="fs_list_auto_mountpoints";
	add0="allow $1 autofs_t:dir list_dir_perms;";
}
if(iii==3214){
	add_number=0;
	raw_interface_name="fs_dontaudit_list_auto_mountpoints";
	add0="dontaudit $1 autofs_t:dir list_dir_perms;";
}
if(iii==3215){
	add_number=0;
	raw_interface_name="fs_manage_autofs_symlinks";
	add0="manage_lnk_files_pattern($1,autofs_t,autofs_t)";
}
if(iii==3216){
	add_number=0;
	raw_interface_name="fs_getattr_binfmt_misc_dirs";
	add0="allow $1 binfmt_misc_t:dir getattr;";
}
if(iii==3217){
	add_number=0;
	raw_interface_name="fs_register_binary_executable_type";
	add0="rw_files_pattern($1,binfmt_misc_fs_t,binfmt_misc_fs_t)";
}
if(iii==3218){
	add_number=0;
	raw_interface_name="fs_mount_cifs";
	add0="allow $1 cifs_t:filesystem mount;";
}
if(iii==3219){
	add_number=0;
	raw_interface_name="fs_remount_cifs";
	add0="allow $1 cifs_t:filesystem remount;";
}
if(iii==3220){
	add_number=0;
	raw_interface_name="fs_unmount_cifs";
	add0="allow $1 cifs_t:filesystem unmount;";
}
if(iii==3221){
	add_number=0;
	raw_interface_name="fs_getattr_cifs";
	add0="allow $1 cifs_t:filesystem getattr;";
}
if(iii==3222){
	add_number=0;
	raw_interface_name="fs_search_cifs";
	add0="allow $1 cifs_t:dir search_dir_perms;";
}
if(iii==3223){
	add_number=0;
	raw_interface_name="fs_list_cifs";
	add0="allow $1 cifs_t:dir list_dir_perms;";
}
if(iii==3224){
	add_number=0;
	raw_interface_name="fs_dontaudit_list_cifs";
	add0="dontaudit $1 cifs_t:dir list_dir_perms;";
}
if(iii==3225){
	add_number=0;
	raw_interface_name="fs_read_cifs_files";
	add0="allow $1 cifs_t:dir list_dir_perms;";
	add1="read_files_pattern($1,cifs_t,cifs_t)";
	add_number =1;
}
if(iii==3226){
	add_number=0;
	raw_interface_name="fs_getattr_noxattr_fs";
	add0="allow $1 noxattrfs:filesystem getattr;";
}
if(iii==3227){
	add_number=0;
	raw_interface_name="fs_list_noxattr_fs";
	add0="allow $1 noxattrfs:dir list_dir_perms;";
}
if(iii==3228){
	add_number=0;
	raw_interface_name="fs_manage_noxattr_fs_dirs";
	add0="allow $1 noxattrfs:dir manage_dir_perms;";
}
if(iii==3229){
	add_number=0;
	raw_interface_name="fs_read_noxattr_fs_files";
	add0="read_files_pattern($1,noxattrfs,noxattrfs)";
}
if(iii==3230){
	add_number=0;
	raw_interface_name="fs_manage_noxattr_fs_files";
	add0="manage_files_pattern($1,noxattrfs,noxattrfs)";
}
if(iii==3231){
	add_number=0;
	raw_interface_name="fs_read_noxattr_fs_symlinks";
	add0="read_lnk_files_pattern($1,noxattrfs,noxattrfs)";
}
if(iii==3232){
	add_number=0;
	raw_interface_name="fs_dontaudit_read_cifs_files";
	add0="dontaudit $1 cifs_t:file read_file_perms;";
}
if(iii==3233){
	add_number=0;
	raw_interface_name="fs_dontaudit_rw_cifs_files";
	add0="dontaudit $1 cifs_t:file { read write };";
}
if(iii==3234){
	add_number=0;
	raw_interface_name="fs_read_cifs_symlinks";
	add0="allow $1 cifs_t:dir list_dir_perms;";
	add1="read_lnk_files_pattern($1,cifs_t,cifs_t)";
	add_number =1;
}
if(iii==3235){
	add_number=0;
	raw_interface_name="fs_exec_cifs_files";
	add0="allow $1 cifs_t:dir list_dir_perms;";
	add1="exec_files_pattern($1,cifs_t,cifs_t)";
	add_number =1;
}
if(iii==3236){
	add_number=0;
	raw_interface_name="fs_manage_cifs_dirs";
	add0="allow $1 cifs_t:dir manage_dir_perms;";
}
if(iii==3237){
	add_number=0;
	raw_interface_name="fs_dontaudit_manage_cifs_dirs";
	add0="dontaudit $1 cifs_t:dir manage_dir_perms;";
}
if(iii==3238){
	add_number=0;
	raw_interface_name="fs_manage_cifs_files";
	add0="manage_files_pattern($1,cifs_t,cifs_t)";
}
if(iii==3239){
	add_number=0;
	raw_interface_name="fs_dontaudit_manage_cifs_files";
	add0="dontaudit $1 cifs_t:file manage_file_perms;";
}
if(iii==3240){
	add_number=0;
	raw_interface_name="fs_manage_cifs_symlinks";
	add0="manage_lnk_files_pattern($1,cifs_t,cifs_t)";
}
if(iii==3241){
	add_number=0;
	raw_interface_name="fs_manage_cifs_named_pipes";
	add0="manage_fifo_files_pattern($1,cifs_t,cifs_t)";
}
if(iii==3242){
	add_number=0;
	raw_interface_name="fs_manage_cifs_named_sockets";
	add0="manage_sock_files_pattern($1,cifs_t,cifs_t)";
}
if(iii==3243){
	add_number=0;
	raw_interface_name="fs_cifs_domtrans";
	add0="allow $1 cifs_t:dir search_dir_perms;";
	add1="domain_auto_transition_pattern($1,cifs_t,$2)";
	add_number =1;
	add2="domain_auto_transition_pattern($1,cifs_t,$2)";
	add_number =2;
}
if(iii==3244){
	add_number=0;
	raw_interface_name="fs_mount_dos_fs";
	add0="allow $1 dosfs_t:filesystem mount;";
}
if(iii==3245){
	add_number=0;
	raw_interface_name="fs_remount_dos_fs";
	add0="allow $1 dosfs_t:filesystem remount;";
}
if(iii==3246){
	add_number=0;
	raw_interface_name="fs_unmount_dos_fs";
	add0="allow $1 dosfs_t:filesystem unmount;";
}
if(iii==3247){
	add_number=0;
	raw_interface_name="fs_getattr_dos_fs";
	add0="allow $1 dosfs_t:filesystem getattr;";
}
if(iii==3248){
	add_number=0;
	raw_interface_name="fs_relabelfrom_dos_fs";
	add0="allow $1 dosfs_t:filesystem relabelfrom;";
}
if(iii==3249){
	add_number=0;
	raw_interface_name="fs_search_dos";
	add0="allow $1 dosfs_t:dir search_dir_perms;";
}
if(iii==3250){
	add_number=0;
	raw_interface_name="fs_read_dos_files";
	add0="read_files_pattern($1,dosfs_t,dosfs_t)";
}
if(iii==3251){
	add_number=0;
	raw_interface_name="fs_manage_dos_files";
	add0="manage_files_pattern($1,dosfs_t,dosfs_t)";
}
if(iii==3252){
	add_number=0;
	raw_interface_name="fs_read_eventpollfs";
}
if(iii==3253){
	add_number=0;
	raw_interface_name="fs_mount_fusefs";
	add0="allow $1 fusefs_t:filesystem mount;";
}
if(iii==3254){
	add_number=0;
	raw_interface_name="fs_unmount_fusefs";
	add0="allow $1 fusefs_t:filesystem unmount;";
}
if(iii==3255){
	add_number=0;
	raw_interface_name="fs_search_inotifyfs";
	add0="allow $1 inotifyfs_t:dir search_dir_perms;";
}
if(iii==3256){
	add_number=0;
	raw_interface_name="fs_list_inotifyfs";
	add0="allow $1 inotifyfs_t:dir list_dir_perms;";
}
if(iii==3257){
	add_number=0;
	raw_interface_name="fs_mount_iso9660_fs";
	add0="allow $1 iso9660_t:filesystem mount;";
}
if(iii==3258){
	add_number=0;
	raw_interface_name="fs_remount_iso9660_fs";
	add0="allow $1 iso9660_t:filesystem remount;";
}
if(iii==3259){
	add_number=0;
	raw_interface_name="fs_unmount_iso9660_fs";
	add0="allow $1 iso9660_t:filesystem unmount;";
}
if(iii==3260){
	add_number=0;
	raw_interface_name="fs_getattr_iso9660_fs";
	add0="allow $1 iso9660_t:filesystem getattr;";
}
if(iii==3261){
	add_number=0;
	raw_interface_name="fs_getattr_iso9660_files";
	add0="allow $1 iso9660_t:dir list_dir_perms;";
	add1="allow $1 iso9660_t:file getattr;";
	add_number =1;
}
if(iii==3262){
	add_number=0;
	raw_interface_name="fs_read_iso9660_files";
	add0="allow $1 iso9660_t:dir list_dir_perms;";
	add1="read_files_pattern($1,iso9660_t,iso9660_t)";
	add_number =1;
	add2="read_lnk_files_pattern($1,iso9660_t,iso9660_t)";
	add_number =2;
}
if(iii==3263){
	add_number=0;
	raw_interface_name="fs_mount_nfs";
	add0="allow $1 nfs_t:filesystem mount;";
}
if(iii==3264){
	add_number=0;
	raw_interface_name="fs_remount_nfs";
	add0="allow $1 nfs_t:filesystem remount;";
}
if(iii==3265){
	add_number=0;
	raw_interface_name="fs_unmount_nfs";
	add0="allow $1 nfs_t:filesystem unmount;";
}
if(iii==3266){
	add_number=0;
	raw_interface_name="fs_getattr_nfs";
	add0="allow $1 nfs_t:filesystem getattr;";
}
if(iii==3267){
	add_number=0;
	raw_interface_name="fs_search_nfs";
	add0="allow $1 nfs_t:dir search_dir_perms;";
}
if(iii==3268){
	add_number=0;
	raw_interface_name="fs_list_nfs";
	add0="allow $1 nfs_t:dir list_dir_perms;";
}
if(iii==3269){
	add_number=0;
	raw_interface_name="fs_dontaudit_list_nfs";
	add0="dontaudit $1 nfs_t:dir list_dir_perms;";
}
if(iii==3270){
	add_number=0;
	raw_interface_name="fs_read_nfs_files";
	add0="allow $1 nfs_t:dir list_dir_perms;";
	add1="read_files_pattern($1,nfs_t,nfs_t)";
	add_number =1;
}
if(iii==3271){
	add_number=0;
	raw_interface_name="fs_dontaudit_read_nfs_files";
	add0="dontaudit $1 nfs_t:file read_file_perms;";
}
if(iii==3272){
	add_number=0;
	raw_interface_name="fs_write_nfs_files";
	add0="allow $1 nfs_t:dir list_dir_perms;";
	add1="write_files_pattern($1,nfs_t,nfs_t)";
	add_number =1;
}
if(iii==3273){
	add_number=0;
	raw_interface_name="fs_exec_nfs_files";
	add0="allow $1 nfs_t:dir list_dir_perms;";
	add1="exec_files_pattern($1,nfs_t,nfs_t)";
	add_number =1;
}
if(iii==3274){
	add_number=0;
	raw_interface_name="fs_dontaudit_rw_nfs_files";
	add0="dontaudit $1 nfs_t:file { read write };";
}
if(iii==3275){
	add_number=0;
	raw_interface_name="fs_read_nfs_symlinks";
	add0="allow $1 nfs_t:dir list_dir_perms;";
	add1="read_lnk_files_pattern($1,nfs_t,nfs_t)";
	add_number =1;
}
if(iii==3276){
	add_number=0;
	raw_interface_name="fs_getattr_rpc_dirs";
	add0="allow $1 rpc_pipefs_t:dir getattr;";
}
if(iii==3277){
	add_number=0;
	raw_interface_name="fs_search_rpc";
	add0="allow $1 rpc_pipefs_t:dir search_dir_perms;";
}
if(iii==3278){
	add_number=0;
	raw_interface_name="fs_search_removable";
	add0="allow $1 removable_t:dir search_dir_perms;";
}
if(iii==3279){
	add_number=0;
	raw_interface_name="fs_dontaudit_list_removable";
	add0="dontaudit $1 removable_t:dir list_dir_perms;";
}
if(iii==3280){
	add_number=0;
	raw_interface_name="fs_read_removable_files";
	add0="read_files_pattern($1,removable_t,removable_t)";
}
if(iii==3281){
	add_number=0;
	raw_interface_name="fs_dontaudit_read_removable_files";
	add0="dontaudit $1 removable_t:file read_file_perms;";
}
if(iii==3282){
	add_number=0;
	raw_interface_name="fs_read_removable_symlinks";
	add0="read_lnk_files_pattern($1,removable_t,removable_t)";
}
if(iii==3283){
	add_number=0;
	raw_interface_name="fs_list_rpc";
	add0="allow $1 rpc_pipefs_t:dir list_dir_perms;";
}
if(iii==3284){
	add_number=0;
	raw_interface_name="fs_read_rpc_files";
	add0="read_files_pattern($1,rpc_pipefs_t,rpc_pipefs_t)";
}
if(iii==3285){
	add_number=0;
	raw_interface_name="fs_read_rpc_symlinks";
	add0="read_lnk_files_pattern($1,rpc_pipefs_t,rpc_pipefs_t)";
}
if(iii==3286){
	add_number=0;
	raw_interface_name="fs_read_rpc_sockets";
	add0="allow $1 rpc_pipefs_t:sock_file { read write };";
}
if(iii==3287){
	add_number=0;
	raw_interface_name="fs_manage_nfs_dirs";
	add0="allow $1 nfs_t:dir manage_dir_perms;";
}
if(iii==3288){
	add_number=0;
	raw_interface_name="fs_dontaudit_manage_nfs_dirs";
	add0="dontaudit $1 nfs_t:dir manage_dir_perms;";
}
if(iii==3289){
	add_number=0;
	raw_interface_name="fs_manage_nfs_files";
	add0="manage_files_pattern($1,nfs_t,nfs_t)";
}
if(iii==3290){
	add_number=0;
	raw_interface_name="fs_dontaudit_manage_nfs_files";
	add0="dontaudit $1 nfs_t:file manage_file_perms;";
}
if(iii==3291){
	add_number=0;
	raw_interface_name="fs_manage_nfs_symlinks";
	add0="manage_lnk_files_pattern($1,nfs_t,nfs_t)";
}
if(iii==3292){
	add_number=0;
	raw_interface_name="fs_manage_nfs_named_pipes";
	add0="manage_fifo_files_pattern($1,nfs_t,nfs_t)";
}
if(iii==3293){
	add_number=0;
	raw_interface_name="fs_manage_nfs_named_sockets";
	add0="manage_sock_files_pattern($1,nfs_t,nfs_t)";
}
if(iii==3294){
	add_number=0;
	raw_interface_name="fs_nfs_domtrans";
	add0="allow $1 nfs_t:dir search_dir_perms;";
	add1="domain_auto_transition_pattern($1,nfs_t,$2)";
	add_number =1;
	add2="domain_auto_transition_pattern($1,nfs_t,$2)";
	add_number =2;
}
if(iii==3295){
	add_number=0;
	raw_interface_name="fs_mount_nfsd_fs";
	add0="allow $1 nfsd_fs_t:filesystem mount;";
}
if(iii==3296){
	add_number=0;
	raw_interface_name="fs_remount_nfsd_fs";
	add0="allow $1 nfsd_fs_t:filesystem remount;";
}
if(iii==3297){
	add_number=0;
	raw_interface_name="fs_unmount_nfsd_fs";
	add0="allow $1 nfsd_fs_t:filesystem unmount;";
}
if(iii==3298){
	add_number=0;
	raw_interface_name="fs_getattr_nfsd_fs";
	add0="allow $1 nfsd_fs_t:filesystem getattr;";
}
if(iii==3299){
	add_number=0;
	raw_interface_name="fs_search_nfsd_fs";
	add0="allow $1 nfsd_fs_t:dir search_dir_perms;";
}
if(iii==3300){
	add_number=0;
	raw_interface_name="fs_rw_nfsd_fs";
	add0="rw_files_pattern($1,nfsd_fs_t,nfsd_fs_t)";
}
if(iii==3301){
	add_number=0;
	raw_interface_name="fs_mount_ramfs";
	add0="allow $1 ramfs_t:filesystem mount;";
}
if(iii==3302){
	add_number=0;
	raw_interface_name="fs_remount_ramfs";
	add0="allow $1 ramfs_t:filesystem remount;";
}
if(iii==3303){
	add_number=0;
	raw_interface_name="fs_unmount_ramfs";
	add0="allow $1 ramfs_t:filesystem unmount;";
}
if(iii==3304){
	add_number=0;
	raw_interface_name="fs_getattr_ramfs";
	add0="allow $1 ramfs_t:filesystem getattr;";
}
if(iii==3305){
	add_number=0;
	raw_interface_name="fs_search_ramfs";
	add0="allow $1 ramfs_t:dir search_dir_perms;";
}
if(iii==3306){
	add_number=0;
	raw_interface_name="fs_dontaudit_search_ramfs";
	add0="dontaudit $1 ramfs_t:dir search_dir_perms;";
}
if(iii==3307){
	add_number=0;
	raw_interface_name="fs_manage_ramfs_dirs";
	add0="allow $1 ramfs_t:dir manage_dir_perms;";
}
if(iii==3308){
	add_number=0;
	raw_interface_name="fs_dontaudit_read_ramfs_files";
	add0="dontaudit $1 ramfs_t:file read;";
}
if(iii==3309){
	add_number=0;
	raw_interface_name="fs_dontaudit_read_ramfs_pipes";
	add0="dontaudit $1 ramfs_t:fifo_file read;";
}
if(iii==3310){
	add_number=0;
	raw_interface_name="fs_manage_ramfs_files";
	add0="manage_files_pattern($1,ramfs_t,ramfs_t)";
}
if(iii==3311){
	add_number=0;
	raw_interface_name="fs_write_ramfs_pipes";
	add0="write_fifo_files_pattern($1,ramfs_t,ramfs_t)";
}
if(iii==3312){
	add_number=0;
	raw_interface_name="fs_dontaudit_write_ramfs_pipes";
	add0="dontaudit $1 ramfs_t:fifo_file write;";
}
if(iii==3313){
	add_number=0;
	raw_interface_name="fs_rw_ramfs_pipes";
	add0="rw_fifo_files_pattern($1,ramfs_t,ramfs_t)";
}
if(iii==3314){
	add_number=0;
	raw_interface_name="fs_manage_ramfs_pipes";
	add0="manage_fifo_files_pattern($1,ramfs_t,ramfs_t)";
}
if(iii==3315){
	add_number=0;
	raw_interface_name="fs_write_ramfs_sockets";
	add0="write_sock_files_pattern($1,ramfs_t,ramfs_t)";
}
if(iii==3316){
	add_number=0;
	raw_interface_name="fs_manage_ramfs_sockets";
	add0="manage_sock_files_pattern($1,ramfs_t,ramfs_t)";
}
if(iii==3317){
	add_number=0;
	raw_interface_name="fs_mount_romfs";
	add0="allow $1 romfs_t:filesystem mount;";
}
if(iii==3318){
	add_number=0;
	raw_interface_name="fs_remount_romfs";
	add0="allow $1 romfs_t:filesystem remount;";
}
if(iii==3319){
	add_number=0;
	raw_interface_name="fs_unmount_romfs";
	add0="allow $1 romfs_t:filesystem unmount;";
}
if(iii==3320){
	add_number=0;
	raw_interface_name="fs_getattr_romfs";
	add0="allow $1 romfs_t:filesystem getattr;";
}
if(iii==3321){
	add_number=0;
	raw_interface_name="fs_mount_rpc_pipefs";
	add0="allow $1 rpc_pipefs_t:filesystem mount;";
}
if(iii==3322){
	add_number=0;
	raw_interface_name="fs_remount_rpc_pipefs";
	add0="allow $1 rpc_pipefs_t:filesystem remount;";
}
if(iii==3323){
	add_number=0;
	raw_interface_name="fs_unmount_rpc_pipefs";
	add0="allow $1 rpc_pipefs_t:filesystem unmount;";
}
if(iii==3324){
	add_number=0;
	raw_interface_name="fs_getattr_rpc_pipefs";
	add0="allow $1 rpc_pipefs_t:filesystem getattr;";
}
if(iii==3325){
	add_number=0;
	raw_interface_name="fs_rw_rpc_named_pipes";
	add0="allow $1 rpc_pipefs_t:fifo_file { read write };";
}
if(iii==3326){
	add_number=0;
	raw_interface_name="fs_mount_tmpfs";
	add0="allow $1 tmpfs_t:filesystem mount;";
}
if(iii==3327){
	add_number=0;
	raw_interface_name="fs_remount_tmpfs";
	add0="allow $1 tmpfs_t:filesystem remount;";
}
if(iii==3328){
	add_number=0;
	raw_interface_name="fs_unmount_tmpfs";
	add0="allow $1 tmpfs_t:filesystem unmount;";
}
if(iii==3329){
	add_number=0;
	raw_interface_name="fs_getattr_tmpfs";
	add0="allow $1 tmpfs_t:filesystem getattr;";
}
if(iii==3330){
	add_number=0;
	raw_interface_name="fs_associate_tmpfs";
	add0="allow $1 tmpfs_t:filesystem associate;";
}
if(iii==3331){
	add_number=0;
	raw_interface_name="fs_getattr_tmpfs_dirs";
	add0="allow $1 tmpfs_t:dir getattr;";
}
if(iii==3332){
	add_number=0;
	raw_interface_name="fs_dontaudit_getattr_tmpfs_dirs";
	add0="dontaudit $1 tmpfs_t:dir getattr;";
}
if(iii==3333){
	add_number=0;
	raw_interface_name="fs_setattr_tmpfs_dirs";
	add0="allow $1 tmpfs_t:dir setattr;";
}
if(iii==3334){
	add_number=0;
	raw_interface_name="fs_search_tmpfs";
	add0="allow $1 tmpfs_t:dir search_dir_perms;";
}
if(iii==3335){
	add_number=0;
	raw_interface_name="fs_list_tmpfs";
	add0="allow $1 tmpfs_t:dir list_dir_perms;";
}
if(iii==3336){
	add_number=0;
	raw_interface_name="fs_dontaudit_list_tmpfs";
	add0="dontaudit $1 tmpfs_t:dir list_dir_perms;";
}
if(iii==3337){
	add_number=0;
	raw_interface_name="fs_manage_tmpfs_dirs";
	add0="allow $1 tmpfs_t:dir manage_dir_perms;";
}
if(iii==3338){
	add_number=0;
	raw_interface_name="fs_tmpfs_filetrans";
	add0="allow $2 tmpfs_t:filesystem associate;";
	add1="filetrans_pattern($1,tmpfs_t,$2,$3)";
	add_number =1;
	add2="filetrans_pattern($1,tmpfs_t,$2,$3)";
	add_number =2;
	add3="filetrans_pattern($1,tmpfs_t,$2,$3)";
	add_number =3;
}
if(iii==3339){
	add_number=0;
	raw_interface_name="fs_dontaudit_getattr_tmpfs_files";
	add0="dontaudit $1 tmpfs_t:file getattr;";
}
if(iii==3340){
	add_number=0;
	raw_interface_name="fs_dontaudit_rw_tmpfs_files";
	add0="dontaudit $1 tmpfs_t:file rw_file_perms;";
}
if(iii==3341){
	add_number=0;
	raw_interface_name="fs_manage_auto_mountpoints";
	add0="allow $1 autofs_t:dir manage_dir_perms;";
}
if(iii==3342){
	add_number=0;
	raw_interface_name="fs_rw_tmpfs_files";
	add0="rw_files_pattern($1,tmpfs_t,tmpfs_t)";
}
if(iii==3343){
	add_number=0;
	raw_interface_name="fs_read_tmpfs_symlinks";
	add0="read_lnk_files_pattern($1,tmpfs_t,tmpfs_t)";
}
if(iii==3344){
	add_number=0;
	raw_interface_name="fs_rw_tmpfs_chr_files";
	add0="allow $1 tmpfs_t:dir list_dir_perms;";
	add1="rw_chr_files_pattern($1,tmpfs_t,tmpfs_t)";
	add_number =1;
}
if(iii==3345){
	add_number=0;
	raw_interface_name="fs_dontaudit_use_tmpfs_chr_dev";
	add0="dontaudit $1 tmpfs_t:dir list_dir_perms;";
	add1="dontaudit $1 tmpfs_t:chr_file rw_chr_file_perms;";
	add_number =1;
}
if(iii==3346){
	add_number=0;
	raw_interface_name="fs_relabel_tmpfs_chr_file";
	add0="allow $1 tmpfs_t:dir list_dir_perms;";
	add1="relabel_chr_files_pattern($1,tmpfs_t,tmpfs_t)";
	add_number =1;
}
if(iii==3347){
	add_number=0;
	raw_interface_name="fs_rw_tmpfs_blk_files";
	add0="allow $1 tmpfs_t:dir list_dir_perms;";
	add1="rw_blk_files_pattern($1,tmpfs_t,tmpfs_t)";
	add_number =1;
}
if(iii==3348){
	add_number=0;
	raw_interface_name="fs_relabel_tmpfs_blk_file";
	add0="allow $1 tmpfs_t:dir list_dir_perms;";
	add1="relabel_blk_files_pattern($1,tmpfs_t,tmpfs_t)";
	add_number =1;
}
if(iii==3349){
	add_number=0;
	raw_interface_name="fs_manage_tmpfs_files";
	add0="manage_files_pattern($1,tmpfs_t,tmpfs_t)";
}
if(iii==3350){
	add_number=0;
	raw_interface_name="fs_manage_tmpfs_symlinks";
	add0="manage_lnk_files_pattern($1,tmpfs_t,tmpfs_t)";
}
if(iii==3351){
	add_number=0;
	raw_interface_name="fs_manage_tmpfs_sockets";
	add0="manage_sock_files_pattern($1,tmpfs_t,tmpfs_t)";
}
if(iii==3352){
	add_number=0;
	raw_interface_name="fs_manage_tmpfs_chr_files";
	add0="manage_chr_files_pattern($1,tmpfs_t,tmpfs_t)";
}
if(iii==3353){
	add_number=0;
	raw_interface_name="fs_manage_tmpfs_blk_files";
	add0="manage_blk_files_pattern($1,tmpfs_t,tmpfs_t)";
}
if(iii==3354){
	add_number=0;
	raw_interface_name="fs_mount_all_fs";
	add0="allow $1 filesystem_type:filesystem mount;";
}
if(iii==3355){
	add_number=0;
	raw_interface_name="fs_remount_all_fs";
	add0="allow $1 filesystem_type:filesystem remount;";
}
if(iii==3356){
	add_number=0;
	raw_interface_name="fs_unmount_all_fs";
	add0="allow $1 filesystem_type:filesystem unmount;";
}
if(iii==3357){
	add_number=0;
	raw_interface_name="fs_getattr_all_fs";
	add0="allow $1 filesystem_type:filesystem getattr;";
}
if(iii==3358){
	add_number=0;
	raw_interface_name="fs_dontaudit_getattr_all_fs";
	add0="dontaudit $1 filesystem_type:filesystem getattr;";
}
if(iii==3359){
	add_number=0;
	raw_interface_name="fs_get_all_fs_quotas";
	add0="allow $1 filesystem_type:filesystem quotaget;";
}
if(iii==3360){
	add_number=0;
	raw_interface_name="fs_set_all_quotas";
	add0="allow $1 filesystem_type:filesystem quotamod;";
}
if(iii==3361){
	add_number=0;
	raw_interface_name="fs_relabelfrom_all_fs";
	add0="allow $1 filesystem_type:filesystem relabelfrom;";
}
if(iii==3362){
	add_number=0;
	raw_interface_name="fs_getattr_all_dirs";
	add0="allow $1 filesystem_type:dir getattr;";
}
if(iii==3363){
	add_number=0;
	raw_interface_name="fs_search_all";
	add0="allow $1 filesystem_type:dir search_dir_perms;";
}
if(iii==3364){
	add_number=0;
	raw_interface_name="fs_list_all";
	add0="allow $1 filesystem_type:dir list_dir_perms;";
}
if(iii==3365){
	add_number=0;
	raw_interface_name="fs_getattr_all_files";
	add0="getattr_files_pattern($1,filesystem_type,filesystem_type)";
}
if(iii==3366){
	add_number=0;
	raw_interface_name="fs_getattr_all_symlinks";
	add0="getattr_lnk_files_pattern($1,filesystem_type,filesystem_type)";
}
if(iii==3367){
	add_number=0;
	raw_interface_name="fs_getattr_all_pipes";
	add0="getattr_fifo_files_pattern($1,filesystem_type,filesystem_type)";
}
if(iii==3368){
	add_number=0;
	raw_interface_name="fs_getattr_all_sockets";
	add0="getattr_sock_files_pattern($1,filesystem_type,filesystem_type)";
}
if(iii==3369){
	add_number=0;
	raw_interface_name="fs_dontaudit_getattr_all_files";
	add0="dontaudit $1 filesystem_type:file getattr;";
}
if(iii==3370){
	add_number=0;
	raw_interface_name="fs_dontaudit_getattr_all_symlinks";
	add0="dontaudit $1 filesystem_type:lnk_file getattr;";
}
if(iii==3371){
	add_number=0;
	raw_interface_name="fs_dontaudit_getattr_all_pipes";
	add0="dontaudit $1 filesystem_type:fifo_file getattr;";
}
if(iii==3372){
	add_number=0;
	raw_interface_name="fs_dontaudit_getattr_all_sockets";
	add0="dontaudit $1 filesystem_type:sock_file getattr;";
}
if(iii==3373){
	add_number=0;
	raw_interface_name="fs_unconfined";
	add0="typeattribute $1 filesystem_unconfined_type;";
}
if(iii==3374){
	add_number=0;
	raw_interface_name="fs_relabelfrom_noxattr_fs";
	add0="allow $1 noxattrfs:dir list_dir_perms;";
	add1="relabelfrom_dirs_pattern($1,noxattrfs,noxattrfs)";
	add_number =1;
	add2="relabelfrom_files_pattern($1,noxattrfs,noxattrfs)";
	add_number =2;
	add3="relabelfrom_lnk_files_pattern($1,noxattrfs,noxattrfs)";
	add_number =3;
	add4="relabelfrom_fifo_files_pattern($1,noxattrfs,noxattrfs)";
	add_number =4;
	add5="relabelfrom_sock_files_pattern($1,noxattrfs,noxattrfs)";
	add_number =5;
	add6="relabelfrom_blk_files_pattern($1,noxattrfs,noxattrfs)";
	add_number =6;
	add7="relabelfrom_chr_files_pattern($1,noxattrfs,noxattrfs)";
	add_number =7;
	add8=":kernel.if";
	add_number =8;
}
if(iii==3375){
	add_number=0;
	raw_interface_name="kernel_domtrans_to";
	add0="domtrans_pattern(kernel_t, $2, $1)";
	add1="domtrans_pattern(kernel_t, $2, $1)";
	add_number =1;
}
if(iii==3376){
	add_number=0;
	raw_interface_name="kernel_ranged_domtrans_to";
	add0="kernel_domtrans_to($1,$2)";
	add1="kernel_domtrans_to($1,$2)";
	add_number =1;
	add2="range_transition kernel_t $2:process $3;";
	add_number =2;
	add3="range_transition kernel_t $2:process $3;";
	add_number =3;
	add4="range_transition kernel_t $2:process $3;";
	add_number =4;
	add5="range_transition kernel_t $2:process $3;";
	add_number =5;
	add6="mls_rangetrans_target($1)";
	add_number =6;
}
if(iii==3377){
	add_number=0;
	raw_interface_name="kernel_rootfs_mountpoint";
	add0="allow kernel_t $1:dir mounton;";
}
if(iii==3378){
	add_number=0;
	raw_interface_name="kernel_setpgid";
	add0="allow $1 kernel_t:process setpgid;";
}
if(iii==3379){
	add_number=0;
	raw_interface_name="kernel_setsched";
	add0="allow $1 kernel_t:process setsched;";
}
if(iii==3380){
	add_number=0;
	raw_interface_name="kernel_sigchld";
	add0="allow $1 kernel_t:process sigchld;";
}
if(iii==3381){
	add_number=0;
	raw_interface_name="kernel_signal";
	add0="allow kernel_t $1:process signal;";
}
if(iii==3382){
	add_number=0;
	raw_interface_name="kernel_share_state";
	add0="allow kernel_t $1:process share;";
}
if(iii==3383){
	add_number=0;
	raw_interface_name="kernel_use_fds";
	add0="allow $1 kernel_t:fd use;";
}
if(iii==3384){
	add_number=0;
	raw_interface_name="kernel_dontaudit_use_fds";
	add0="dontaudit $1 kernel_t:fd use;";
}
if(iii==3385){
	add_number=0;
	raw_interface_name="kernel_rw_pipes";
	add0="allow $1 kernel_t:fifo_file { read write };";
}
if(iii==3386){
	add_number=0;
	raw_interface_name="kernel_rw_unix_dgram_sockets";
	add0="allow $1 kernel_t:unix_dgram_socket { read write ioctl };";
}
if(iii==3387){
	add_number=0;
	raw_interface_name="kernel_dgram_send";
	add0="allow $1 kernel_t:unix_dgram_socket sendto;";
}
if(iii==3388){
	add_number=0;
	raw_interface_name="kernel_tcp_recvfrom";
}
if(iii==3389){
	add_number=0;
	raw_interface_name="kernel_udp_send";
}
if(iii==3390){
	add_number=0;
	raw_interface_name="kernel_udp_recvfrom";
}
if(iii==3391){
	add_number=0;
	raw_interface_name="kernel_load_module";
	add0="allow $1 self:capability sys_module;";
	add1="typeattribute $1 can_load_kernmodule;";
	add_number =1;
}
if(iii==3392){
	add_number=0;
	raw_interface_name="kernel_search_key";
	add0="allow $1 kernel_t:key search;";
}
if(iii==3393){
	add_number=0;
	raw_interface_name="kernel_link_key";
	add0="allow $1 kernel_t:key link;";
}
if(iii==3394){
	add_number=0;
	raw_interface_name="kernel_read_ring_buffer";
	add0="allow $1 kernel_t:system syslog_read;";
}
if(iii==3395){
	add_number=0;
	raw_interface_name="kernel_dontaudit_read_ring_buffer";
	add0="dontaudit $1 kernel_t:system syslog_read;";
}
if(iii==3396){
	add_number=0;
	raw_interface_name="kernel_change_ring_buffer_level";
	add0="allow $1 kernel_t:system syslog_console;";
}
if(iii==3397){
	add_number=0;
	raw_interface_name="kernel_clear_ring_buffer";
	add0="allow $1 kernel_t:system syslog_mod;";
}
if(iii==3398){
	add_number=0;
	raw_interface_name="kernel_get_sysvipc_info";
	add0="allow $1 kernel_t:system ipc_info;";
}
if(iii==3399){
	add_number=0;
	raw_interface_name="kernel_getattr_debugfs";
	add0="allow $1 debugfs_t:filesystem getattr;";
}
if(iii==3400){
	add_number=0;
	raw_interface_name="kernel_mount_debugfs";
	add0="allow $1 debugfs_t:filesystem mount;";
}
if(iii==3401){
	add_number=0;
	raw_interface_name="kernel_unmount_debugfs";
	add0="allow $1 debugfs_t:filesystem unmount;";
}
if(iii==3402){
	add_number=0;
	raw_interface_name="kernel_remount_debugfs";
	add0="allow $1 debugfs_t:filesystem remount;";
}
if(iii==3403){
	add_number=0;
	raw_interface_name="kernel_search_debugfs";
	add0="search_dirs_pattern($1,debugfs_t,debugfs_t)";
}
if(iii==3404){
	add_number=0;
	raw_interface_name="kernel_read_debugfs";
	add0="read_files_pattern($1,debugfs_t,debugfs_t)";
	add1="read_lnk_files_pattern($1,debugfs_t,debugfs_t)";
	add_number =1;
	add2="list_dirs_pattern($1,debugfs_t,debugfs_t)";
	add_number =2;
}
if(iii==3405){
	add_number=0;
	raw_interface_name="kernel_mount_kvmfs";
	add0="allow $1 kvmfs_t:filesystem mount;";
}
if(iii==3406){
	add_number=0;
	raw_interface_name="kernel_unmount_proc";
	add0="allow $1 proc_t:filesystem unmount;";
}
if(iii==3407){
	add_number=0;
	raw_interface_name="kernel_getattr_proc";
	add0="allow $1 proc_t:filesystem getattr;";
}
if(iii==3408){
	add_number=0;
	raw_interface_name="kernel_search_proc";
	add0="search_dirs_pattern($1,proc_t,proc_t)";
}
if(iii==3409){
	add_number=0;
	raw_interface_name="kernel_list_proc";
	add0="list_dirs_pattern($1,proc_t,proc_t)";
}
if(iii==3410){
	add_number=0;
	raw_interface_name="kernel_dontaudit_list_proc";
	add0="dontaudit $1 proc_t:dir list_dir_perms;";
}
if(iii==3411){
	add_number=0;
	raw_interface_name="kernel_getattr_proc_files";
	add0="getattr_files_pattern($1,proc_t,proc_t)";
}
if(iii==3412){
	add_number=0;
	raw_interface_name="kernel_read_proc_symlinks";
	add0="read_lnk_files_pattern($1,proc_t,proc_t)";
}
if(iii==3413){
	add_number=0;
	raw_interface_name="kernel_read_system_state";
	add0="read_files_pattern($1,proc_t,proc_t)";
	add1="read_lnk_files_pattern($1,proc_t,proc_t)";
	add_number =1;
	add2="list_dirs_pattern($1,proc_t,proc_t)";
	add_number =2;
}
if(iii==3414){
	add_number=0;
	raw_interface_name="kernel_write_proc_files";
	add0="write_files_pattern($1,proc_t,proc_t)";
}
if(iii==3415){
	add_number=0;
	raw_interface_name="kernel_dontaudit_read_system_state";
	add0="dontaudit $1 proc_t:file { getattr read };";
}
if(iii==3416){
	add_number=0;
	raw_interface_name="kernel_dontaudit_read_proc_symlinks";
	add0="dontaudit $1 proc_t:lnk_file read;";
}
if(iii==3417){
	add_number=0;
	raw_interface_name="kernel_read_software_raid_state";
	add0="read_files_pattern($1,proc_t,proc_mdstat_t)";
	add1="list_dirs_pattern($1,proc_t,proc_t)";
	add_number =1;
}
if(iii==3418){
	add_number=0;
	raw_interface_name="kernel_rw_software_raid_state";
	add0="rw_files_pattern($1,proc_t,proc_mdstat_t)";
	add1="list_dirs_pattern($1,proc_t,proc_t)";
	add_number =1;
}
if(iii==3419){
	add_number=0;
	raw_interface_name="kernel_getattr_core_if";
	add0="getattr_files_pattern($1,proc_t,proc_kcore_t)";
	add1="list_dirs_pattern($1,proc_t,proc_t)";
	add_number =1;
}
if(iii==3420){
	add_number=0;
	raw_interface_name="kernel_dontaudit_getattr_core_if";
	add0="dontaudit $1 proc_kcore_t:file getattr;";
}
if(iii==3421){
	add_number=0;
	raw_interface_name="kernel_read_messages";
	add0="read_files_pattern($1,proc_t,proc_kmsg_t)";
	add1="typeattribute $1 can_receive_kernel_messages;";
	add_number =1;
}
if(iii==3422){
	add_number=0;
	raw_interface_name="kernel_getattr_message_if";
	add0="getattr_files_pattern($1,proc_t,proc_kmsg_t)";
}
if(iii==3423){
	add_number=0;
	raw_interface_name="kernel_dontaudit_getattr_message_if";
	add0="dontaudit $1 proc_kmsg_t:file getattr;";
}
if(iii==3424){
	add_number=0;
	raw_interface_name="kernel_dontaudit_search_network_state";
	add0="dontaudit $1 proc_net_t:dir search;";
}
if(iii==3425){
	add_number=0;
	raw_interface_name="kernel_search_network_state";
	add0="search_dirs_pattern($1,proc_t,proc_net_t)";
}
if(iii==3426){
	add_number=0;
	raw_interface_name="kernel_read_network_state";
	add0="read_files_pattern($1,{ proc_t proc_net_t },proc_net_t)";
	add1="read_lnk_files_pattern($1,{ proc_t proc_net_t },proc_net_t)";
	add_number =1;
	add2="list_dirs_pattern($1,proc_t,proc_net_t)";
	add_number =2;
}
if(iii==3427){
	add_number=0;
	raw_interface_name="kernel_read_network_state_symlinks";
	add0="read_lnk_files_pattern($1,{ proc_t proc_net_t },proc_net_t)";
	add1="list_dirs_pattern($1,proc_t,proc_net_t)";
	add_number =1;
}
if(iii==3428){
	add_number=0;
	raw_interface_name="kernel_search_xen_state";
	add0="search_dirs_pattern($1,proc_t,proc_xen_t)";
}
if(iii==3429){
	add_number=0;
	raw_interface_name="kernel_dontaudit_search_xen_state";
	add0="dontaudit $1 proc_xen_t:dir search;";
}
if(iii==3430){
	add_number=0;
	raw_interface_name="kernel_read_xen_state";
	add0="read_files_pattern($1,{ proc_t proc_xen_t },proc_xen_t)";
	add1="read_lnk_files_pattern($1,{ proc_t proc_xen_t },proc_xen_t)";
	add_number =1;
	add2="list_dirs_pattern($1,proc_t,proc_xen_t)";
	add_number =2;
}
if(iii==3431){
	add_number=0;
	raw_interface_name="kernel_read_xen_state_symlinks";
	add0="read_lnk_files_pattern($1,{ proc_t proc_xen_t },proc_xen_t)";
	add1="list_dirs_pattern($1,proc_t,proc_xen_t)";
	add_number =1;
}
if(iii==3432){
	add_number=0;
	raw_interface_name="kernel_write_xen_state";
	add0="write_files_pattern($1,{ proc_t proc_xen_t },proc_xen_t)";
}
if(iii==3433){
	add_number=0;
	raw_interface_name="kernel_dontaudit_list_all_proc";
	add0="dontaudit $1 proc_type:dir list_dir_perms;";
}
if(iii==3434){
	add_number=0;
	raw_interface_name="kernel_dontaudit_search_sysctl";
	add0="dontaudit $1 sysctl_t:dir search;";
}
if(iii==3435){
	add_number=0;
	raw_interface_name="kernel_read_sysctl";
	add0="list_dirs_pattern($1,proc_t,sysctl_t)";
}
if(iii==3436){
	add_number=0;
	raw_interface_name="kernel_read_device_sysctls";
	add0="read_files_pattern($1,{ proc_t sysctl_t sysctl_dev_t },sysctl_dev_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_dev_t)";
	add_number =1;
}
if(iii==3437){
	add_number=0;
	raw_interface_name="kernel_rw_device_sysctls";
	add0="rw_files_pattern($1,{ proc_t sysctl_t sysctl_dev_t },sysctl_dev_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_dev_t)";
	add_number =1;
}
if(iii==3438){
	add_number=0;
	raw_interface_name="kernel_search_vm_sysctl";
	add0="search_dirs_pattern($1,{ proc_t sysctl_t },sysctl_vm_t)";
}
if(iii==3439){
	add_number=0;
	raw_interface_name="kernel_read_vm_sysctls";
	add0="read_files_pattern($1,{ proc_t sysctl_t sysctl_vm_t },sysctl_vm_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_vm_t)";
	add_number =1;
}
if(iii==3440){
	add_number=0;
	raw_interface_name="kernel_rw_vm_sysctls";
	add0="rw_files_pattern($1,{ proc_t sysctl_t sysctl_vm_t },sysctl_vm_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_vm_t)";
	add_number =1;
	add2="allow $1 sysctl_vm_t:dir write;";
	add_number =2;
}
if(iii==3441){
	add_number=0;
	raw_interface_name="kernel_search_network_sysctl";
	add0="search_dirs_pattern($1,{ proc_t sysctl_t },sysctl_net_t)";
}
if(iii==3442){
	add_number=0;
	raw_interface_name="kernel_dontaudit_search_network_sysctl";
	add0="dontaudit $1 sysctl_net_t:dir search;";
}
if(iii==3443){
	add_number=0;
	raw_interface_name="kernel_read_net_sysctls";
	add0="read_files_pattern($1,{ proc_t sysctl_t sysctl_net_t },sysctl_net_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_net_t)";
	add_number =1;
}
if(iii==3444){
	add_number=0;
	raw_interface_name="kernel_rw_net_sysctls";
	add0="rw_files_pattern($1,{ proc_t sysctl_t sysctl_net_t },sysctl_net_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_net_t)";
	add_number =1;
}
if(iii==3445){
	add_number=0;
	raw_interface_name="kernel_read_unix_sysctls";
	add0="read_files_pattern($1,{ proc_t sysctl_t sysctl_net_t },sysctl_net_unix_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_net_t)";
	add_number =1;
}
if(iii==3446){
	add_number=0;
	raw_interface_name="kernel_rw_unix_sysctls";
	add0="rw_files_pattern($1,{ proc_t sysctl_t sysctl_net_t },sysctl_net_unix_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_net_t)";
	add_number =1;
}
if(iii==3447){
	add_number=0;
	raw_interface_name="kernel_read_hotplug_sysctls";
	add0="read_files_pattern($1,{ proc_t sysctl_t sysctl_kernel_t },sysctl_hotplug_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_kernel_t)";
	add_number =1;
}
if(iii==3448){
	add_number=0;
	raw_interface_name="kernel_rw_hotplug_sysctls";
	add0="rw_files_pattern($1,{ proc_t sysctl_t sysctl_kernel_t },sysctl_hotplug_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_kernel_t)";
	add_number =1;
}
if(iii==3449){
	add_number=0;
	raw_interface_name="kernel_read_modprobe_sysctls";
	add0="read_files_pattern($1,{ proc_t sysctl_t sysctl_kernel_t },sysctl_modprobe_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_kernel_t)";
	add_number =1;
}
if(iii==3450){
	add_number=0;
	raw_interface_name="kernel_rw_modprobe_sysctls";
	add0="rw_files_pattern($1,{ proc_t sysctl_t sysctl_kernel_t },sysctl_modprobe_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_kernel_t)";
	add_number =1;
}
if(iii==3451){
	add_number=0;
	raw_interface_name="kernel_dontaudit_search_kernel_sysctl";
	add0="dontaudit $1 sysctl_kernel_t:dir search;";
}
if(iii==3452){
	add_number=0;
	raw_interface_name="kernel_read_kernel_sysctls";
	add0="read_files_pattern($1,{ proc_t sysctl_t sysctl_kernel_t },sysctl_kernel_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_kernel_t)";
	add_number =1;
}
if(iii==3453){
	add_number=0;
	raw_interface_name="kernel_dontaudit_write_kernel_sysctl";
	add0="dontaudit $1 sysctl_kernel_t:file write;";
}
if(iii==3454){
	add_number=0;
	raw_interface_name="kernel_rw_kernel_sysctl";
	add0="rw_files_pattern($1,{ proc_t sysctl_t sysctl_kernel_t },sysctl_kernel_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_kernel_t)";
	add_number =1;
}
if(iii==3455){
	add_number=0;
	raw_interface_name="kernel_read_fs_sysctls";
	add0="read_files_pattern($1,{ proc_t sysctl_t sysctl_fs_t },sysctl_fs_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_fs_t)";
	add_number =1;
}
if(iii==3456){
	add_number=0;
	raw_interface_name="kernel_rw_fs_sysctls";
	add0="rw_files_pattern($1,{ proc_t sysctl_t sysctl_fs_t },sysctl_fs_t)";
	add1="list_dirs_pattern($1,{ proc_t sysctl_t },sysctl_fs_t)";
	add_number =1;
}
if(iii==3457){
	add_number=0;
	raw_interface_name="kernel_read_irq_sysctls";
	add0="read_files_pattern($1,{ proc_t sysctl_irq_t },sysctl_irq_t)";
	add1="list_dirs_pattern($1,proc_t,sysctl_irq_t)";
	add_number =1;
}
if(iii==3458){
	add_number=0;
	raw_interface_name="kernel_rw_irq_sysctls";
	add0="rw_files_pattern($1,{ proc_t sysctl_irq_t },sysctl_irq_t)";
	add1="list_dirs_pattern($1,proc_t,sysctl_irq_t)";
	add_number =1;
}
if(iii==3459){
	add_number=0;
	raw_interface_name="kernel_read_rpc_sysctls";
	add0="read_files_pattern($1,{ proc_t proc_net_t sysctl_rpc_t },sysctl_rpc_t)";
	add1="list_dirs_pattern($1,{ proc_t proc_net_t },sysctl_rpc_t)";
	add_number =1;
}
if(iii==3460){
	add_number=0;
	raw_interface_name="kernel_rw_rpc_sysctls";
	add0="rw_files_pattern($1,{ proc_t proc_net_t sysctl_rpc_t },sysctl_rpc_t)";
	add1="list_dirs_pattern($1,{ proc_t proc_net_t },sysctl_rpc_t)";
	add_number =1;
}
if(iii==3461){
	add_number=0;
	raw_interface_name="kernel_dontaudit_list_all_sysctls";
	add0="dontaudit $1 sysctl_type:dir list_dir_perms;";
}
if(iii==3462){
	add_number=0;
	raw_interface_name="kernel_read_all_sysctls";
	add0="read_files_pattern($1,{ proc_t proc_net_t sysctl_type },sysctl_type)";
	add1="list_dirs_pattern($1,{ proc_t proc_net_t },sysctl_type)";
	add_number =1;
}
if(iii==3463){
	add_number=0;
	raw_interface_name="kernel_rw_all_sysctls";
	add0="rw_files_pattern($1,{ proc_t proc_net_t sysctl_type },sysctl_type)";
	add1="allow $1 sysctl_type:dir list_dir_perms;";
	add_number =1;
	add2="allow $1 sysctl_type:file setattr;";
	add_number =2;
}
if(iii==3464){
	add_number=0;
	raw_interface_name="kernel_kill_unlabeled";
	add0="allow $1 unlabeled_t:process sigkill;";
}
if(iii==3465){
	add_number=0;
	raw_interface_name="kernel_signal_unlabeled";
	add0="allow $1 unlabeled_t:process signal;";
}
if(iii==3466){
	add_number=0;
	raw_interface_name="kernel_signull_unlabeled";
	add0="allow $1 unlabeled_t:process signull;";
}
if(iii==3467){
	add_number=0;
	raw_interface_name="kernel_sigstop_unlabeled";
	add0="allow $1 unlabeled_t:process sigstop;";
}
if(iii==3468){
	add_number=0;
	raw_interface_name="kernel_sigchld_unlabeled";
	add0="allow $1 unlabeled_t:process sigchld;";
}
if(iii==3469){
	add_number=0;
	raw_interface_name="kernel_list_unlabeled";
	add0="allow $1 unlabeled_t:dir list_dir_perms;";
}
if(iii==3470){
	add_number=0;
	raw_interface_name="kernel_dontaudit_list_unlabeled";
	add0="dontaudit $1 unlabeled_t:dir list_dir_perms;";
}
if(iii==3471){
	add_number=0;
	raw_interface_name="kernel_rw_unlabeled_dirs";
	add0="allow $1 unlabeled_t:dir rw_dir_perms;";
}
if(iii==3472){
	add_number=0;
	raw_interface_name="kernel_dontaudit_getattr_unlabeled_files";
	add0="dontaudit $1 unlabeled_t:file getattr;";
}
if(iii==3473){
	add_number=0;
	raw_interface_name="kernel_dontaudit_read_unlabeled_files";
	add0="dontaudit $1 unlabeled_t:file { getattr read };";
}
if(iii==3474){
	add_number=0;
	raw_interface_name="kernel_dontaudit_getattr_unlabeled_symlinks";
	add0="dontaudit $1 unlabeled_t:lnk_file getattr;";
}
if(iii==3475){
	add_number=0;
	raw_interface_name="kernel_dontaudit_getattr_unlabeled_pipes";
	add0="dontaudit $1 unlabeled_t:fifo_file getattr;";
}
if(iii==3476){
	add_number=0;
	raw_interface_name="kernel_dontaudit_getattr_unlabeled_sockets";
	add0="dontaudit $1 unlabeled_t:sock_file getattr;";
}
if(iii==3477){
	add_number=0;
	raw_interface_name="kernel_dontaudit_getattr_unlabeled_blk_files";
	add0="dontaudit $1 unlabeled_t:blk_file getattr;";
}
if(iii==3478){
	add_number=0;
	raw_interface_name="kernel_rw_unlabeled_blk_files";
	add0="allow $1 unlabeled_t:blk_file getattr;";
}
if(iii==3479){
	add_number=0;
	raw_interface_name="kernel_dontaudit_getattr_unlabeled_chr_files";
	add0="dontaudit $1 unlabeled_t:chr_file getattr;";
}
if(iii==3480){
	add_number=0;
	raw_interface_name="kernel_relabelfrom_unlabeled_dirs";
	add0="allow $1 unlabeled_t:dir { getattr search read relabelfrom };";
}
if(iii==3481){
	add_number=0;
	raw_interface_name="kernel_relabelfrom_unlabeled_files";
	add0="kernel_list_unlabeled($1)";
	add1="allow $1 unlabeled_t:file { getattr relabelfrom };";
	add_number =1;
}
if(iii==3482){
	add_number=0;
	raw_interface_name="kernel_relabelfrom_unlabeled_symlinks";
	add0="kernel_list_unlabeled($1)";
	add1="allow $1 unlabeled_t:lnk_file { getattr relabelfrom };";
	add_number =1;
}
if(iii==3483){
	add_number=0;
	raw_interface_name="kernel_relabelfrom_unlabeled_pipes";
	add0="kernel_list_unlabeled($1)";
	add1="allow $1 unlabeled_t:fifo_file { getattr relabelfrom };";
	add_number =1;
}
if(iii==3484){
	add_number=0;
	raw_interface_name="kernel_relabelfrom_unlabeled_sockets";
	add0="kernel_list_unlabeled($1)";
	add1="allow $1 unlabeled_t:sock_file { getattr relabelfrom };";
	add_number =1;
}
if(iii==3485){
	add_number=0;
	raw_interface_name="kernel_sendrecv_unlabeled_association";
	add0="allow $1 unlabeled_t:association { sendto recvfrom };";
	add1="allow $1 unlabeled_t:packet { send recv };";
	add_number =1;
}
if(iii==3486){
	add_number=0;
	raw_interface_name="kernel_dontaudit_sendrecv_unlabeled_association";
	add0="dontaudit $1 unlabeled_t:association { sendto recvfrom };";
}
if(iii==3487){
	add_number=0;
	raw_interface_name="kernel_tcp_recvfrom_unlabeled";
	add0="allow $1 unlabeled_t:tcp_socket recvfrom;";
}
if(iii==3488){
	add_number=0;
	raw_interface_name="kernel_dontaudit_tcp_recvfrom_unlabeled";
	add0="dontaudit $1 unlabeled_t:tcp_socket recvfrom;";
}
if(iii==3489){
	add_number=0;
	raw_interface_name="kernel_udp_recvfrom_unlabeled";
	add0="allow $1 unlabeled_t:udp_socket recvfrom;";
}
if(iii==3490){
	add_number=0;
	raw_interface_name="kernel_dontaudit_udp_recvfrom_unlabeled";
	add0="dontaudit $1 unlabeled_t:udp_socket recvfrom;";
}
if(iii==3491){
	add_number=0;
	raw_interface_name="kernel_raw_recvfrom_unlabeled";
	add0="allow $1 unlabeled_t:rawip_socket recvfrom;";
}
if(iii==3492){
	add_number=0;
	raw_interface_name="kernel_dontaudit_raw_recvfrom_unlabeled";
	add0="dontaudit $1 unlabeled_t:rawip_socket recvfrom;";
}
if(iii==3493){
	add_number=0;
	raw_interface_name="kernel_sendrecv_unlabeled_packets";
	add0="allow $1 unlabeled_t:packet { send recv };";
}
if(iii==3494){
	add_number=0;
	raw_interface_name="kernel_unconfined";
	add0="typeattribute $1 kern_unconfined;";
	add1=":mcs.if";
	add_number =1;
}
if(iii==3495){
	add_number=0;
	raw_interface_name="mcs_killall";
	add0="typeattribute $1 mcskillall;";
}
if(iii==3496){
	add_number=0;
	raw_interface_name="mcs_ptrace_all";
	add0="typeattribute $1 mcsptraceall;";
}
if(iii==3497){
	add_number=0;
	raw_interface_name="mcs_process_set_categories";
	add0="typeattribute $1 mcssetcats;";
	add1=":mls.if";
	add_number =1;
}
if(iii==3498){
	add_number=0;
	raw_interface_name="mls_file_read_to_clearance";
	add0="typeattribute $1 mlsfilereadtoclr;";
}
if(iii==3499){
	add_number=0;
	raw_interface_name="mls_file_read_up";
	add0="mls_file_read_all_levels($1)";
}
if(iii==3500){
	add_number=0;
	raw_interface_name="mls_file_read_all_levels";
	add0="typeattribute $1 mlsfileread;";
}
if(iii==3501){
	add_number=0;
	raw_interface_name="mls_file_write_to_clearance";
	add0="typeattribute $1 mlsfilewritetoclr;";
}
if(iii==3502){
	add_number=0;
	raw_interface_name="mls_file_write_down";
	add0="mls_file_write_all_levels($1)";
}
if(iii==3503){
	add_number=0;
	raw_interface_name="mls_file_write_all_levels";
	add0="typeattribute $1 mlsfilewrite;";
}
if(iii==3504){
	add_number=0;
	raw_interface_name="mls_file_upgrade";
	add0="typeattribute $1 mlsfileupgrade;";
}
if(iii==3505){
	add_number=0;
	raw_interface_name="mls_file_downgrade";
	add0="typeattribute $1 mlsfiledowngrade;";
}
if(iii==3506){
	add_number=0;
	raw_interface_name="mls_file_write_within_range";
	add0="typeattribute $1 mlsfilewriteinrange;";
}
if(iii==3507){
	add_number=0;
	raw_interface_name="mls_socket_read_all_levels";
	add0="typeattribute $1 mlsnetread;";
}
if(iii==3508){
	add_number=0;
	raw_interface_name="mls_socket_read_to_clearance";
	add0="typeattribute $1 mlsnetreadtoclr;";
}
if(iii==3509){
	add_number=0;
	raw_interface_name="mls_socket_write_to_clearance";
	add0="typeattribute $1 mlsnetwritetoclr;";
}
if(iii==3510){
	add_number=0;
	raw_interface_name="mls_socket_write_all_levels";
	add0="typeattribute $1 mlsnetwrite;";
}
if(iii==3511){
	add_number=0;
	raw_interface_name="mls_net_receive_all_levels";
	add0="typeattribute $1 mlsnetrecvall;";
}
if(iii==3512){
	add_number=0;
	raw_interface_name="mls_net_write_within_range";
	add0="typeattribute $1 mlsnetwriteranged;";
}
if(iii==3513){
	add_number=0;
	raw_interface_name="mls_sysvipc_read_to_clearance";
	add0="typeattribute $1 mlsipcreadtoclr;";
}
if(iii==3514){
	add_number=0;
	raw_interface_name="mls_sysvipc_read_all_levels";
	add0="typeattribute $1 mlsipcread;";
}
if(iii==3515){
	add_number=0;
	raw_interface_name="mls_sysvipc_write_to_clearance";
	add0="typeattribute $1 mlsipcwritetoclr;";
}
if(iii==3516){
	add_number=0;
	raw_interface_name="mls_sysvipc_write_all_levels";
	add0="typeattribute $1 mlsipcwrite;";
}
if(iii==3517){
	add_number=0;
	raw_interface_name="mls_rangetrans_source";
	add0="typeattribute $1 privrangetrans;";
}
if(iii==3518){
	add_number=0;
	raw_interface_name="mls_rangetrans_target";
	add0="typeattribute $1 mlsrangetrans;";
}
if(iii==3519){
	add_number=0;
	raw_interface_name="mls_process_read_to_clearance";
	add0="typeattribute $1 mlsprocreadtoclr;";
}
if(iii==3520){
	add_number=0;
	raw_interface_name="mls_process_read_up";
	add0="mls_process_read_all_levels($1)";
}
if(iii==3521){
	add_number=0;
	raw_interface_name="mls_process_read_all_levels";
	add0="typeattribute $1 mlsprocread;";
}
if(iii==3522){
	add_number=0;
	raw_interface_name="mls_process_write_to_clearance";
	add0="typeattribute $1 mlsprocwritetoclr;";
}
if(iii==3523){
	add_number=0;
	raw_interface_name="mls_process_write_down";
	add0="mls_process_write_all_levels($1)";
}
if(iii==3524){
	add_number=0;
	raw_interface_name="mls_process_write_all_levels";
	add0="typeattribute $1 mlsprocwrite;";
}
if(iii==3525){
	add_number=0;
	raw_interface_name="mls_process_set_level";
	add0="typeattribute $1 mlsprocsetsl;";
}
if(iii==3526){
	add_number=0;
	raw_interface_name="mls_xwin_read_all_levels";
	add0="typeattribute $1 mlsxwinread;";
}
if(iii==3527){
	add_number=0;
	raw_interface_name="mls_xwin_write_all_levels";
	add0="typeattribute $1 mlsxwinwrite;";
}
if(iii==3528){
	add_number=0;
	raw_interface_name="mls_colormap_read_all_levels";
	add0="typeattribute $1 mlsxwinreadcolormap;";
}
if(iii==3529){
	add_number=0;
	raw_interface_name="mls_colormap_write_all_levels";
	add0="typeattribute $1 mlsxwinwritecolormap;";
}
if(iii==3530){
	add_number=0;
	raw_interface_name="mls_trusted_object";
	add0="typeattribute $1 mlstrustedobject;";
}
if(iii==3531){
	add_number=0;
	raw_interface_name="mls_fd_use_all_levels";
	add0="typeattribute $1 mlsfduse;";
}
if(iii==3532){
	add_number=0;
	raw_interface_name="mls_fd_share_all_levels";
	add0="typeattribute $1 mlsfdshare;";
}
if(iii==3533){
	add_number=0;
	raw_interface_name="mls_context_translate_all_levels";
	add0="typeattribute $1 mlstranslate;";
}
if(iii==3534){
	add_number=0;
	raw_interface_name="mls_db_read_all_levels";
	add0="typeattribute $1 mlsdbread;";
}
if(iii==3535){
	add_number=0;
	raw_interface_name="mls_db_write_all_levels";
	add0="typeattribute $1 mlsdbwrite;";
}
if(iii==3536){
	add_number=0;
	raw_interface_name="mls_db_upgrade";
	add0="typeattribute $1 mlsdbupgrade;";
}
if(iii==3537){
	add_number=0;
	raw_interface_name="mls_db_downgrade";
	add0="typeattribute $1 mlsdbdowngrade;";
	add1=":selinux.if";
	add_number =1;
}
if(iii==3538){
	add_number=0;
	raw_interface_name="selinux_get_fs_mount";
	add0="allow $1 security_t:filesystem getattr;";
	add1="kernel_read_system_state($1)";
	add_number =1;
}
if(iii==3539){
	add_number=0;
	raw_interface_name="selinux_getattr_fs";
	add0="allow $1 security_t:filesystem getattr;";
}
if(iii==3540){
	add_number=0;
	raw_interface_name="selinux_dontaudit_getattr_fs";
	add0="dontaudit $1 security_t:filesystem getattr;";
}
if(iii==3541){
	add_number=0;
	raw_interface_name="selinux_dontaudit_getattr_dir";
	add0="dontaudit $1 security_t:dir getattr;";
}
if(iii==3542){
	add_number=0;
	raw_interface_name="selinux_search_fs";
	add0="allow $1 security_t:dir search_dir_perms;";
}
if(iii==3543){
	add_number=0;
	raw_interface_name="selinux_dontaudit_search_fs";
	add0="dontaudit $1 security_t:dir search_dir_perms;";
}
if(iii==3544){
	add_number=0;
	raw_interface_name="selinux_dontaudit_read_fs";
	add0="dontaudit $1 security_t:dir search_dir_perms;";
	add1="dontaudit $1 security_t:file { getattr read };";
	add_number =1;
}
if(iii==3545){
	add_number=0;
	raw_interface_name="selinux_get_enforce_mode";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read };";
	add_number =1;
}
if(iii==3546){
	add_number=0;
	raw_interface_name="selinux_set_enforce_mode";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="typeattribute $1 can_setenforce;";
	add_number =2;
	add3="allow $1 security_t:security setenforce;";
	add_number =3;
	add4="auditallow $1 security_t:security setenforce;";
	add_number =4;
}
if(iii==3547){
	add_number=0;
	raw_interface_name="selinux_load_policy";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="typeattribute $1 can_load_policy;";
	add_number =2;
	add3="allow $1 security_t:security load_policy;";
	add_number =3;
	add4="auditallow $1 security_t:security load_policy;";
	add_number =4;
}
if(iii==3548){
	add_number=0;
	raw_interface_name="selinux_set_boolean";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="allow $1 security_t:security setbool;";
	add_number =2;
	add3="auditallow $1 security_t:security setbool;";
	add_number =3;
}
if(iii==3549){
	add_number=0;
	raw_interface_name="selinux_set_parameters";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="allow $1 security_t:security setsecparam;";
	add_number =2;
	add3="auditallow $1 security_t:security setsecparam;";
	add_number =3;
	add4="typeattribute $1 can_setsecparam;";
	add_number =4;
}
if(iii==3550){
	add_number=0;
	raw_interface_name="selinux_validate_context";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="allow $1 security_t:security check_context;";
	add_number =2;
}
if(iii==3551){
	add_number=0;
	raw_interface_name="selinux_compute_access_vector";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="allow $1 security_t:security compute_av;";
	add_number =2;
}
if(iii==3552){
	add_number=0;
	raw_interface_name="selinux_compute_create_context";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="allow $1 security_t:security compute_create;";
	add_number =2;
}
if(iii==3553){
	add_number=0;
	raw_interface_name="selinux_compute_member";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="allow $1 security_t:security compute_member;";
	add_number =2;
}
if(iii==3554){
	add_number=0;
	raw_interface_name="selinux_compute_relabel_context";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="allow $1 security_t:security compute_relabel;";
	add_number =2;
}
if(iii==3555){
	add_number=0;
	raw_interface_name="selinux_compute_user_contexts";
	add0="allow $1 security_t:dir list_dir_perms;";
	add1="allow $1 security_t:file { getattr read write };";
	add_number =1;
	add2="allow $1 security_t:security compute_user;";
	add_number =2;
}
if(iii==3556){
	add_number=0;
	raw_interface_name="selinux_unconfined";
	add0="typeattribute $1 selinux_unconfined_type;";
	add1=":storage.if";
	add_number =1;
}
if(iii==3557){
	add_number=0;
	raw_interface_name="storage_getattr_fixed_disk_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 fixed_disk_device_t:blk_file getattr;";
	add_number =1;
}
if(iii==3558){
	add_number=0;
	raw_interface_name="storage_dontaudit_getattr_fixed_disk_dev";
	add0="dontaudit $1 fixed_disk_device_t:blk_file getattr;";
	add1="dontaudit $1 fixed_disk_device_t:chr_file getattr; # /dev/rawctl";
	add_number =1;
}
if(iii==3559){
	add_number=0;
	raw_interface_name="storage_setattr_fixed_disk_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 fixed_disk_device_t:blk_file setattr;";
	add_number =1;
}
if(iii==3560){
	add_number=0;
	raw_interface_name="storage_dontaudit_setattr_fixed_disk_dev";
	add0="dontaudit $1 fixed_disk_device_t:blk_file setattr;";
}
if(iii==3561){
	add_number=0;
	raw_interface_name="storage_raw_read_fixed_disk";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 fixed_disk_device_t:blk_file read_blk_file_perms;";
	add_number =1;
	add2="allow $1 fixed_disk_device_t:chr_file read_chr_file_perms;";
	add_number =2;
	add3="typeattribute $1 fixed_disk_raw_read;";
	add_number =3;
}
if(iii==3562){
	add_number=0;
	raw_interface_name="storage_dontaudit_read_fixed_disk";
	add0="dontaudit $1 fixed_disk_device_t:blk_file { getattr ioctl read };";
}
if(iii==3563){
	add_number=0;
	raw_interface_name="storage_raw_write_fixed_disk";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 fixed_disk_device_t:blk_file write_blk_file_perms;";
	add_number =1;
	add2="allow $1 fixed_disk_device_t:chr_file write_chr_file_perms;";
	add_number =2;
	add3="typeattribute $1 fixed_disk_raw_write;";
	add_number =3;
}
if(iii==3564){
	add_number=0;
	raw_interface_name="storage_dontaudit_write_fixed_disk";
	add0="dontaudit $1 fixed_disk_device_t:blk_file write_blk_file_perms;";
}
if(iii==3565){
	add_number=0;
	raw_interface_name="storage_manage_fixed_disk";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 self:capability mknod;";
	add_number =1;
	add2="allow $1 fixed_disk_device_t:blk_file manage_blk_file_perms;";
	add_number =2;
	add3="typeattribute $1 fixed_disk_raw_read, fixed_disk_raw_write;";
	add_number =3;
}
if(iii==3566){
	add_number=0;
	raw_interface_name="storage_dev_filetrans_fixed_disk";
	add0="dev_filetrans($1,fixed_disk_device_t,blk_file)";
}
if(iii==3567){
	add_number=0;
	raw_interface_name="storage_tmpfs_filetrans_fixed_disk";
	add0="fs_tmpfs_filetrans($1,fixed_disk_device_t,blk_file)";
}
if(iii==3568){
	add_number=0;
	raw_interface_name="storage_relabel_fixed_disk";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 fixed_disk_device_t:blk_file relabel_blk_file_perms;";
	add_number =1;
}
if(iii==3569){
	add_number=0;
	raw_interface_name="storage_swapon_fixed_disk";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 fixed_disk_device_t:blk_file { getattr swapon };";
	add_number =1;
}
if(iii==3570){
	add_number=0;
	raw_interface_name="storage_getattr_scsi_generic_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 scsi_generic_device_t:chr_file getattr;";
	add_number =1;
}
if(iii==3571){
	add_number=0;
	raw_interface_name="storage_setattr_scsi_generic_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 scsi_generic_device_t:chr_file setattr;";
	add_number =1;
}
if(iii==3572){
	add_number=0;
	raw_interface_name="storage_read_scsi_generic";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 scsi_generic_device_t:chr_file read_chr_file_perms;";
	add_number =1;
	add2="typeattribute $1 scsi_generic_read;";
	add_number =2;
}
if(iii==3573){
	add_number=0;
	raw_interface_name="storage_write_scsi_generic";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 scsi_generic_device_t:chr_file write_chr_file_perms;";
	add_number =1;
	add2="typeattribute $1 scsi_generic_write;";
	add_number =2;
}
if(iii==3574){
	add_number=0;
	raw_interface_name="storage_setattr_scsi_generic_dev_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 scsi_generic_device_t:chr_file setattr;";
	add_number =1;
}
if(iii==3575){
	add_number=0;
	raw_interface_name="storage_dontaudit_rw_scsi_generic";
	add0="dontaudit $1 scsi_generic_device_t:chr_file rw_file_perms;";
}
if(iii==3576){
	add_number=0;
	raw_interface_name="storage_getattr_removable_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 removable_device_t:blk_file getattr;";
	add_number =1;
}
if(iii==3577){
	add_number=0;
	raw_interface_name="storage_dontaudit_getattr_removable_dev";
	add0="dontaudit $1 removable_device_t:blk_file getattr;";
}
if(iii==3578){
	add_number=0;
	raw_interface_name="storage_dontaudit_read_removable_device";
	add0="dontaudit $1 removable_device_t:blk_file { getattr ioctl read };";
}
if(iii==3579){
	add_number=0;
	raw_interface_name="storage_setattr_removable_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 removable_device_t:blk_file setattr;";
	add_number =1;
}
if(iii==3580){
	add_number=0;
	raw_interface_name="storage_dontaudit_setattr_removable_dev";
	add0="dontaudit $1 removable_device_t:blk_file setattr;";
}
if(iii==3581){
	add_number=0;
	raw_interface_name="storage_raw_read_removable_device";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 removable_device_t:blk_file read_blk_file_perms;";
	add_number =1;
}
if(iii==3582){
	add_number=0;
	raw_interface_name="storage_dontaudit_raw_read_removable_device";
	add0="dontaudit $1 removable_device_t:blk_file read_blk_file_perms;";
}
if(iii==3583){
	add_number=0;
	raw_interface_name="storage_raw_write_removable_device";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 removable_device_t:blk_file write_blk_file_perms;";
	add_number =1;
}
if(iii==3584){
	add_number=0;
	raw_interface_name="storage_dontaudit_raw_write_removable_device";
	add0="dontaudit $1 removable_device_t:blk_file write_blk_file_perms;";
}
if(iii==3585){
	add_number=0;
	raw_interface_name="storage_read_tape";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tape_device_t:chr_file read_chr_file_perms;";
	add_number =1;
}
if(iii==3586){
	add_number=0;
	raw_interface_name="storage_write_tape";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tape_device_t:chr_file write_chr_file_perms;";
	add_number =1;
}
if(iii==3587){
	add_number=0;
	raw_interface_name="storage_getattr_tape_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tape_device_t:chr_file getattr;";
	add_number =1;
}
if(iii==3588){
	add_number=0;
	raw_interface_name="storage_setattr_tape_dev";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tape_device_t:chr_file setattr;";
	add_number =1;
}
if(iii==3589){
	add_number=0;
	raw_interface_name="storage_unconfined";
	add0="typeattribute $1 storage_unconfined_type;";
	add1=":terminal.if";
	add_number =1;
}
if(iii==3590){
	add_number=0;
	raw_interface_name="term_pty";
	add0="dev_node($1)";
	add1="allow $1 devpts_t:filesystem associate;";
	add_number =1;
	add2="typeattribute $1 ptynode;";
	add_number =2;
}
if(iii==3591){
	add_number=0;
	raw_interface_name="term_user_pty";
	add0="term_pty($2)";
	add1="type_change $1 server_ptynode:chr_file $2;";
	add_number =1;
	add2="type_change $1 server_ptynode:chr_file $2;";
	add_number =2;
}
if(iii==3592){
	add_number=0;
	raw_interface_name="term_login_pty";
	add0="term_pty($1)";
	add1="typeattribute $1 server_ptynode;";
	add_number =1;
}
if(iii==3593){
	add_number=0;
	raw_interface_name="term_tty";
	add0="typeattribute $1 ttynode, serial_device;";
	add1="dev_node($1)";
	add_number =1;
}
if(iii==3594){
	add_number=0;
	raw_interface_name="term_user_tty";
	add0="term_tty($2)";
	add1="type_change $1 tty_device_t:chr_file $2;";
	add_number =1;
	add2="type_change $1 tty_device_t:chr_file $2;";
	add_number =2;
	add3="type_change $1 ttynode:chr_file $2;";
	add_number =3;
	add4="type_change $1 ttynode:chr_file $2;";
	add_number =4;
}
if(iii==3595){
	add_number=0;
	raw_interface_name="term_create_pty";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ptmx_t:chr_file rw_file_perms;";
	add_number =1;
	add2="allow $1 devpts_t:dir list_dir_perms;";
	add_number =2;
	add3="allow $1 devpts_t:filesystem getattr;";
	add_number =3;
	add4="dontaudit $1 bsdpty_device_t:chr_file { getattr read write };";
	add_number =4;
	add5="type_transition $1 devpts_t:chr_file $2;";
	add_number =5;
	add6="type_transition $1 devpts_t:chr_file $2;";
	add_number =6;
}
if(iii==3596){
	add_number=0;
	raw_interface_name="term_use_all_terms";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 devpts_t:dir list_dir_perms;";
	add_number =1;
	add2="allow $1 { console_device_t tty_device_t ttynode ptynode }:chr_file rw_file_perms;";
	add_number =2;
}
if(iii==3597){
	add_number=0;
	raw_interface_name="term_write_console";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 console_device_t:chr_file write_chr_file_perms;";
	add_number =1;
}
if(iii==3598){
	add_number=0;
	raw_interface_name="term_read_console";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 console_device_t:chr_file read_chr_file_perms;";
	add_number =1;
}
if(iii==3599){
	add_number=0;
	raw_interface_name="term_use_console";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 console_device_t:chr_file rw_chr_file_perms;";
	add_number =1;
}
if(iii==3600){
	add_number=0;
	raw_interface_name="term_dontaudit_use_console";
	add0="dontaudit $1 console_device_t:chr_file rw_chr_file_perms;";
}
if(iii==3601){
	add_number=0;
	raw_interface_name="term_setattr_console";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 console_device_t:chr_file setattr;";
	add_number =1;
}
if(iii==3602){
	add_number=0;
	raw_interface_name="term_relabel_console";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 console_device_t:chr_file { relabelfrom relabelto };";
	add_number =1;
}
if(iii==3603){
	add_number=0;
	raw_interface_name="term_create_console_dev";
	add0="dev_add_entry_generic_dirs($1)";
	add1="allow $1 console_device_t:chr_file create;";
	add_number =1;
	add2="allow $1 self:capability mknod;";
	add_number =2;
}
if(iii==3604){
	add_number=0;
	raw_interface_name="term_getattr_pty_fs";
	add0="allow $1 devpts_t:filesystem getattr;";
}
if(iii==3605){
	add_number=0;
	raw_interface_name="term_dontaudit_getattr_pty_dirs";
	add0="dontaudit $1 devpts_t:dir getattr;";
}
if(iii==3606){
	add_number=0;
	raw_interface_name="term_search_ptys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 devpts_t:dir search_dir_perms;";
	add_number =1;
}
if(iii==3607){
	add_number=0;
	raw_interface_name="term_dontaudit_search_ptys";
	add0="dev_dontaudit_list_all_dev_nodes($1)";
	add1="dontaudit $1 devpts_t:dir search_dir_perms;";
	add_number =1;
}
if(iii==3608){
	add_number=0;
	raw_interface_name="term_list_ptys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 devpts_t:dir list_dir_perms;";
	add_number =1;
}
if(iii==3609){
	add_number=0;
	raw_interface_name="term_dontaudit_list_ptys";
	add0="dontaudit $1 devpts_t:dir { getattr search read };";
}
if(iii==3610){
	add_number=0;
	raw_interface_name="term_dontaudit_manage_pty_dirs";
	add0="dontaudit $1 devpts_t:dir manage_dir_perms;";
}
if(iii==3611){
	add_number=0;
	raw_interface_name="term_ioctl_generic_ptys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 devpts_t:dir search;";
	add_number =1;
	add2="allow $1 devpts_t:chr_file ioctl;";
	add_number =2;
}
if(iii==3612){
	add_number=0;
	raw_interface_name="term_setattr_generic_ptys";
	add0="allow $1 devpts_t:chr_file setattr;";
}
if(iii==3613){
	add_number=0;
	raw_interface_name="term_dontaudit_setattr_generic_ptys";
	add0="dontaudit $1 devpts_t:chr_file setattr;";
}
if(iii==3614){
	add_number=0;
	raw_interface_name="term_use_generic_ptys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 devpts_t:dir list_dir_perms;";
	add_number =1;
	add2="allow $1 devpts_t:chr_file { rw_term_perms lock append };";
	add_number =2;
}
if(iii==3615){
	add_number=0;
	raw_interface_name="term_dontaudit_use_generic_ptys";
	add0="dontaudit $1 devpts_t:chr_file { getattr read write ioctl };";
}
if(iii==3616){
	add_number=0;
	raw_interface_name="term_use_controlling_term";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 devtty_t:chr_file { rw_term_perms lock append };";
	add_number =1;
}
if(iii==3617){
	add_number=0;
	raw_interface_name="term_use_ptmx";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ptmx_t:chr_file rw_file_perms;";
	add_number =1;
}
if(iii==3618){
	add_number=0;
	raw_interface_name="term_dontaudit_use_ptmx";
	add0="dontaudit $1 ptmx_t:chr_file { getattr read write };";
}
if(iii==3619){
	add_number=0;
	raw_interface_name="term_getattr_all_user_ptys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 devpts_t:dir list_dir_perms;";
	add_number =1;
	add2="allow $1 ptynode:chr_file getattr;";
	add_number =2;
}
if(iii==3620){
	add_number=0;
	raw_interface_name="term_dontaudit_getattr_all_user_ptys";
	add0="dontaudit $1 ptynode:chr_file getattr;";
}
if(iii==3621){
	add_number=0;
	raw_interface_name="term_setattr_all_user_ptys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 devpts_t:dir list_dir_perms;";
	add_number =1;
	add2="allow $1 ptynode:chr_file setattr;";
	add_number =2;
}
if(iii==3622){
	add_number=0;
	raw_interface_name="term_relabelto_all_user_ptys";
	add0="allow $1 ptynode:chr_file relabelto;";
}
if(iii==3623){
	add_number=0;
	raw_interface_name="term_write_all_user_ptys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ptynode:chr_file write_chr_file_perms;";
	add_number =1;
}
if(iii==3624){
	add_number=0;
	raw_interface_name="term_use_all_user_ptys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 devpts_t:dir list_dir_perms;";
	add_number =1;
	add2="allow $1 ptynode:chr_file { rw_term_perms lock append };";
	add_number =2;
}
if(iii==3625){
	add_number=0;
	raw_interface_name="term_dontaudit_use_all_user_ptys";
	add0="dontaudit $1 ptynode:chr_file { rw_term_perms lock append };";
}
if(iii==3626){
	add_number=0;
	raw_interface_name="term_relabel_all_user_ptys";
	add0="dev_list_all_dev_nodes($1)";
	add1="relabel_chr_files_pattern($1,devpts_t,ptynode)";
	add_number =1;
}
if(iii==3627){
	add_number=0;
	raw_interface_name="term_getattr_unallocated_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tty_device_t:chr_file getattr;";
	add_number =1;
}
if(iii==3628){
	add_number=0;
	raw_interface_name="term_dontaudit_getattr_unallocated_ttys";
	add0="dontaudit $1 tty_device_t:chr_file getattr;";
}
if(iii==3629){
	add_number=0;
	raw_interface_name="term_setattr_unallocated_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tty_device_t:chr_file setattr;";
	add_number =1;
}
if(iii==3630){
	add_number=0;
	raw_interface_name="term_dontaudit_setattr_unallocated_ttys";
	add0="dontaudit $1 tty_device_t:chr_file setattr;";
}
if(iii==3631){
	add_number=0;
	raw_interface_name="term_dontaudit_ioctl_unallocated_ttys";
	add0="dontaudit $1 tty_device_t:chr_file ioctl;";
}
if(iii==3632){
	add_number=0;
	raw_interface_name="term_relabel_unallocated_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tty_device_t:chr_file { relabelfrom relabelto };";
	add_number =1;
}
if(iii==3633){
	add_number=0;
	raw_interface_name="term_reset_tty_labels";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ttynode:chr_file relabelfrom;";
	add_number =1;
	add2="allow $1 tty_device_t:chr_file relabelto;";
	add_number =2;
}
if(iii==3634){
	add_number=0;
	raw_interface_name="term_append_unallocated_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tty_device_t:chr_file { getattr append };";
	add_number =1;
}
if(iii==3635){
	add_number=0;
	raw_interface_name="term_write_unallocated_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tty_device_t:chr_file { getattr write };";
	add_number =1;
}
if(iii==3636){
	add_number=0;
	raw_interface_name="term_use_unallocated_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 tty_device_t:chr_file { rw_term_perms lock append };";
	add_number =1;
}
if(iii==3637){
	add_number=0;
	raw_interface_name="term_dontaudit_use_unallocated_ttys";
	add0="dontaudit $1 tty_device_t:chr_file { rw_term_perms lock append };";
}
if(iii==3638){
	add_number=0;
	raw_interface_name="term_getattr_all_user_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ttynode:chr_file getattr;";
	add_number =1;
}
if(iii==3639){
	add_number=0;
	raw_interface_name="term_dontaudit_getattr_all_user_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="dontaudit $1 ttynode:chr_file getattr;";
	add_number =1;
}
if(iii==3640){
	add_number=0;
	raw_interface_name="term_setattr_all_user_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ttynode:chr_file setattr;";
	add_number =1;
}
if(iii==3641){
	add_number=0;
	raw_interface_name="term_relabel_all_user_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ttynode:chr_file { relabelfrom relabelto };";
	add_number =1;
}
if(iii==3642){
	add_number=0;
	raw_interface_name="term_write_all_user_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ttynode:chr_file { getattr write append };";
	add_number =1;
}
if(iii==3643){
	add_number=0;
	raw_interface_name="term_use_all_user_ttys";
	add0="dev_list_all_dev_nodes($1)";
	add1="allow $1 ttynode:chr_file { rw_term_perms lock append };";
	add_number =1;
}
if(iii==3644){
	add_number=0;
	raw_interface_name="term_dontaudit_use_all_user_ttys";
	add0="dontaudit $1 ttynode:chr_file { read write };";
}				   
					/////////////////////////end-kernel interfaces///////////////////////////////////////////
					/////////now let's convert and add //////////////////////////    
					    //QRegExp rx_interface_name(raw_interface_name);
					    QRegExp rx_interface_name(interface_name_with_var);
					    //for debug
					    QString tt;
					    
					    interface_name_with_var = raw_interface_name + "($1)";

					    //now analize !
					    if(line_analized.find( interface_name_with_var, 0) != -1){
						line_analized.replace( interface_name_with_var , add0 );
						lines_break += line_analized;
						//for debug
						//tt.setNum(iii);
						//lines_break += "iii_interface:" + tt;
						//end-for debug
						if(add_number>=1){
						    lines_break += tab + add1;
						    //lines_break += "iii_add1:" + tt + "add_number:" + "1";
						}
						if(add_number>=2){
						    lines_break += tab + add2;
						    //lines_break += "2";
						}
						if(add_number>=3){
						    lines_break += tab + add3;
						    //lines_break += "3";
						}
						if(add_number>=4){
						    lines_break += tab + add4;
						}
						if(add_number>=5){
						    lines_break += tab + add5;
						}
						if(add_number>=6){
						    lines_break += tab + add6;
						}
						if(add_number>=7){
						    lines_break += tab + add7;
						}
						if(add_number>=8){
						    lines_break += tab + add8;
						}
						if(add_number>=9){
						    lines_break += tab + add9;
						}
						if(add_number>=10){
						    lines_break += tab + add10;
						}
						if(add_number>=11){
						    lines_break += tab + add11;
						}
						if(add_number>=12){
						    lines_break += tab + add12;
						}
						if(add_number>=13){
						    lines_break += tab + add13;
						}
						if(add_number>=14){
						    lines_break += tab + add14;
						}
						if(add_number>=15){
						    lines_break += tab + add15;
						}
						if(add_number>=16){
						    lines_break += tab + add16;
						}
					    }
					}					
					///////////////////////end convert and add //////////////////////////////////
					//////////////////////////files pattern//////////////////////////////////////
					//getattr_dirs_pattern
					if(line_analized.find( rx_getattr_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir getattr_dir_perms;";
				        }					
					//setattr_dirs_pattern
					if(line_analized.find( rx_setattr_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir setattr_dir_perms;";
				        }					
					//search_dirs_pattern
					if(line_analized.find( rx_search_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir search_dir_perms;";
				        }					
					//list_dirs_pattern
					if(line_analized.find( rx_list_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir list_dir_perms;";
				        }						
					//add_entry_dirs_pattern
					if(line_analized.find( rx_add_entry_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir add_entry_dir_perms;";
				        }					
					//del_entry_dirs_pattern
					if(line_analized.find( rx_del_entry_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir del_entry_dir_perms;";
				        }					
					//create_dirs_pattern
					if(line_analized.find( rx_create_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir create_dir_perms;";
				        }					
					//delete_dirs_pattern
					if(line_analized.find( rx_delete_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir delete_dir_perms;";
				        }					
					//rename_dirs_pattern
					if(line_analized.find( rx_rename_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir rename_dir_perms;";
				        }					
					//manage_dirs_pattern
					if(line_analized.find( rx_manage_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir manage_dir_perms;";
				        }					
					//relabelfrom_dirs_pattern
					if(line_analized.find( rx_relabelfrom_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir relabelfrom_dir_perms;";
				        }					
					//relabelto_dirs_pattern
					if(line_analized.find( rx_relabelto_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir relabelto_dir_perms;";
				        }					
					//relabel_dirs_pattern
					if(line_analized.find( rx_relabel_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir relabel_dir_perms;";
				        }					
					//rw_dirs_pattern
					if(line_analized.find( rx_rw_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir del_entry_dir_perms;";
				        }					
					//r_files_pattern
					if(line_analized.find( rx_getattr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file getattr_file_perms;";
				        }					
					//setattr_files_pattern
					if(line_analized.find( rx_setattr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file setattr_file_perms;";
				        }					
					//read_files_pattern
					if(line_analized.find( rx_read_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file read_file_perms;";
				        }					
					//mmap_files_pattern
					if(line_analized.find( rx_mmap_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file mmap_file_perms;";
				        }					
					//exec_files_pattern
					if(line_analized.find( rx_exec_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file exec_file_perms;";
				        }					
					//append_files_pattern
					if(line_analized.find( rx_append_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
 						third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file append_file_perms;";
				        }					
					//write_files_pattern
					if(line_analized.find( rx_write_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file write_file_perms;";
				        }					
					//rw_files_pattern
					if(line_analized.find( rx_rw_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file rw_file_perms;";
				        }					
					//create_files_pattern
					if(line_analized.find( rx_create_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file create_file_perms;";
				        }					
					//delete_files_pattern
					if(line_analized.find( rx_delete_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file delete_file_perms;";
				        }										
					//rename_files_pattern
					if(line_analized.find( rx_rename_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file rename_file_perms;";
				        }					
					//manage_files_pattern
					if(line_analized.find( rx_manage_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file manage_file_perms;";
				        }					
					//relabelfrom_files_pattern
					if(line_analized.find( rx_relabelfrom_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file relabelfrom_file_perms;";
				        }					
					//relabelto_files_pattern
					if(line_analized.find( rx_relabelto_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file relabelto_file_perms;";
				        }					
					//relabel_files_pattern
					if(line_analized.find( rx_relabel_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file relabel_file_perms;";
				        }					
					//getattr_lnk_files_pattern
					if(line_analized.find( rx_getattr_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file getattr_lnk_file_perms;";
				        }						
					//setattr_lnk_files_pattern
					if(line_analized.find( rx_setattr_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file setattr_lnk_file_perms;";
				        }					
					//read_lnk_files_pattern
					if(line_analized.find( rx_read_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file read_lnk_file_perms;";
				        }					
					//append_lnk_files_pattern
					if(line_analized.find( rx_append_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file append_lnk_file_perms;";
				        }					
					//write_lnk_files_pattern
					if(line_analized.find( rx_write_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file write_lnk_file_perms;";
				        }						
					//rw_lnk_files_pattern
					if(line_analized.find( rx_rw_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file rw_lnk_file_perms;";
				        }							
					//create_lnk_files_pattern
					if(line_analized.find( rx_create_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file create_lnk_file_perms;";
				        }					
					//delete_lnk_files_pattern
					if(line_analized.find( rx_delete_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file delete_lnk_file_perms;";
				        }					
					//rename_lnk_files_pattern
					if(line_analized.find( rx_rename_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file rename_lnk_file_perms;";
				        }						
					//manage_lnk_files_pattern
					if(line_analized.find( rx_manage_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file manage_lnk_file_perms;";
				        }					
					//relabelfrom_lnk_files_pattern
					if(line_analized.find( rx_relabelfrom_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file relabelfrom_lnk_file_perms;";
				        }					
					//relabelto_lnk_files_pattern
					if(line_analized.find( rx_relabelto_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file relabelto_lnk_file_perms;";
				        }					
					//relabel_lnk_files_pattern
					if(line_analized.find( rx_relabel_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file relabel_lnk_file_perms;";
				        }					
					//getattr_fifo_files_pattern
					if(line_analized.find( rx_getattr_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file getattr_fifo_file_perms;";
				        }					
					//setattr_fifo_files_pattern
					if(line_analized.find( rx_setattr_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file setattr_fifo_file_perms;";
				        }					
					//read_fifo_files_pattern
					if(line_analized.find( rx_read_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file read_fifo_file_perms;";
				        }					
					//append_fifo_files_pattern
					if(line_analized.find( rx_append_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file append_fifo_file_perms;";
				        }					
					//write_fifo_files_pattern
					if(line_analized.find( rx_write_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file write_fifo_file_perms;";
				        }					
					//rw_fifo_files_pattern
					if(line_analized.find( rx_rw_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file rw_fifo_file_perms;";
				        }					
					//create_fifo_files_pattern
					if(line_analized.find( rx_create_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file create_fifo_file_perms;";
				        }					
					//delete_fifo_files_pattern
					if(line_analized.find( rx_delete_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file delete_fifo_file_perms;";
				        }					
					//rename_fifo_files_pattern
					if(line_analized.find( rx_rename_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file rename_fifo_file_perms;";
				        }					
					//manage_fifo_files_pattern
					if(line_analized.find( rx_manage_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file manage_fifo_file_perms;";
				        }					
					//relabelfrom_fifo_files_pattern
					if(line_analized.find( rx_relabelfrom_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file relabelfrom_fifo_file_perms;";
				        }					
					//relabelto_fifo_files_pattern
					if(line_analized.find( rx_relabelto_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file relabelto_fifo_file_perms;";
				        }					
					//relabel_fifo_files_pattern
					if(line_analized.find( rx_relabel_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file relabel_fifo_file_perms;";
				        }					
					//getattr_sock_files_pattern
					if(line_analized.find( rx_getattr_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file getattr_sock_file_perms;";
				        }					
					//setattr_sock_files_pattern
					if(line_analized.find( rx_setattr_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file setattr_sock_file_perms;";
				        }					
					//read_sock_files_pattern
					if(line_analized.find( rx_read_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file read_sock_file_perms;";
				        }					
					//write_sock_files_pattern
					if(line_analized.find( rx_write_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file write_sock_file_perms;";
				        }
					//rw_sock_files_pattern
					if(line_analized.find( rx_rw_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file rw_sock_file_perms;";
				        }
					//create_sock_files_pattern
					if(line_analized.find( rx_create_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file create_sock_file_perms;";
				        }					
					//delete_sock_files_pattern
					if(line_analized.find( rx_delete_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file delete_sock_file_perms;";
				        }					
					//rename_sock_files_pattern
					if(line_analized.find( rx_rename_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file rename_sock_file_perms;";
				        }					
					//manage_sock_files_pattern
					if(line_analized.find( rx_manage_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file manage_sock_file_perms;";
				        }					
					//relabelfrom_sock_files_pattern
					if(line_analized.find( rx_relabelfrom_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file relabelfrom_sock_file_perms;";
				        }					
					//relabelto_sock_files_pattern
					if(line_analized.find( rx_relabelto_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file relabelto_sock_file_perms;";
				        }					
					//relabel_sock_files_pattern
					if(line_analized.find( rx_relabel_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file relabel_sock_file_perms;";
				        }					
					//getattr_blk_files_pattern
					if(line_analized.find( rx_getattr_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file getattr_blk_file_perms;";
				        }						
					//setattr_blk_files_pattern
					if(line_analized.find( rx_setattr_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file setattr_blk_file_perms;";
				        }					
					//read_blk_files_pattern
					if(line_analized.find( rx_read_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file read_blk_file_perms;";
				        }						
					//append_blk_files_pattern
					if(line_analized.find( rx_append_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file append_blk_file_perms;";
				        }					
					//write_blk_files_pattern
					if(line_analized.find( rx_write_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file write_blk_file_perms;";
				        }						
					//rw_blk_files_pattern
					if(line_analized.find( rx_rw_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file rw_blk_file_perms;";
				        }						
					//create_blk_files_pattern
					if(line_analized.find( rx_create_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + "self:capability mknod;";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file create_blk_file_perms;";
				        }					
					//delete_blk_files_pattern
					if(line_analized.find( rx_delete_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file delete_blk_file_perms;";
				        }					
					//rename_blk_files_pattern
					if(line_analized.find( rx_rename_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file rename_blk_file_perms;";
				        }					
					//manage_blk_files_pattern
					if(line_analized.find( rx_manage_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + "self:capability mknod;";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file manage_blk_file_perms;";
				        }					
					//relabelfrom_blk_files_pattern
					if(line_analized.find( rx_relabelfrom_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file relabelfrom_blk_file_perms;";
				        }							
					//relabelto_blk_files_pattern
					if(line_analized.find( rx_relabelto_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file relabelto_blk_file_perms;";
				        }							
					//relabel_blk_files_pattern
					if(line_analized.find( rx_relabel_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file relabel_blk_file_perms;";
				        }						
					//getattr_chr_files_pattern
					if(line_analized.find( rx_getattr_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file getattr_chr_file_perms;";
				        }					
					//setattr_chr_files_pattern
					if(line_analized.find( rx_read_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file setattr_chr_file_perms;";
				        }					
					//read_chr_files_pattern
					if(line_analized.find( rx_read_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file read_chr_file_perms;";
				        }
					//append_chr_files_pattern
					if(line_analized.find( rx_append_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file append_chr_file_perms;";
				        }						
					//write_chr_files_pattern
					if(line_analized.find( rx_write_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file write_chr_file_perms;";
				        }					
					//rw_chr_files_pattern
					if(line_analized.find( rx_rw_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file rw_chr_file_perms;";
				        }					
					//create_chr_files_pattern
					if(line_analized.find( rx_create_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + "self:capability mknod;";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file create_chr_file_perms;";
				        }					
					//delete_chr_files_pattern
					if(line_analized.find( rx_delete_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
				
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file delete_chr_file_perms;";
				        }					
					//rename_chr_files_pattern
					if(line_analized.find( rx_rename_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
				
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file rename_chr_file_perms;";
				        }					
					//manage_chr_files_pattern
					if(line_analized.find( rx_manage_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + "self:capability mknod;";						
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file manage_chr_file_perms;";
				        }
					//relabelfrom_chr_files_pattern
					if(line_analized.find( rx_relabelfrom_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file relabelfrom_chr_file_perms;";
				        }
					//relabelto_chr_files_pattern
					if(line_analized.find( rx_relabelto_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file relabelto_chr_file_perms;";
				        }
					//relabel_chr_files_pattern
					if(line_analized.find( rx_relabel_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file relabel_chr_file_perms;";
				        }
					//filetrans_add_pattern
					if(line_analized.find( rx_filetrans_add_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						fourth_var = line_analized.section( ',', 3, 3 );
						fourth_var = fourth_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir ra_dir_perms;";
						lines_break += tab + "type_transition " + first_var + " " + second_var + ":" + fourth_var + " " + third_var + ";";
				        }					
					//filetrans_pattern
					if(line_analized.find( rx_filetrans_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						fourth_var = line_analized.section( ',', 3, 3 );
						fourth_var = fourth_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "type_transition " + first_var + " " + second_var + ":" + fourth_var + " " + third_var + ";";
				        }									
					/////////////////end-files pattern//////////////////////
					
				    }
				    //end-this brace should be read only no templates.
				    
				}
				///////////////end-while loop////////////////////////////////////////
				
				
				//almost the end but, change the interfaces which had not been broken(only one-lined *kernel* interfaces and not having file patterns. file patterns should be written above file patterns).
				//lines_break.gres("corecmd_search_bin($1)","allow $1 bin_t:dir { getattr search };");
				//lines_break.gres("search_dirs_pattern($1,bin_t,bin_t)","allow $1 bin_t:dir { getattr search };");
				//lines_break.gres("files_search_usr($1)","allow $1 usr_t:dir { getattr search };");
				//lines_break.gres("files_search_var($1)","allow $1 var_t:dir { getattr search };");
				//lines_break.gres("list_dirs_pattern($1,bin_t,bin_t)","allow $1 bin_t:dir { getattr search };\n\tallow $1 bin_t:dir { getattr search read lock ioctl };");

// it should have space otherwise getattr_dir_perms and r_dir_perms would collide
lines_break.gres(" dir_file_class_set","{ dir file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" file_class_set","{ file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" notdevfile_class_set","{ file lnk_file sock_file fifo_file }");
lines_break.gres(" devfile_class_set","{ chr_file blk_file }");
lines_break.gres(" socket_class_set","{ tcp_socket udp_socket rawip_socket netlink_socket packet_socket unix_stream_socket unix_dgram_socket appletalk_socket netlink_route_socket netlink_firewall_socket netlink_tcpdiag_socket netlink_nflog_socket netlink_xfrm_socket netlink_selinux_socket netlink_audit_socket netlink_ip6fw_socket netlink_dnrt_socket netlink_kobject_uevent_socket }");
lines_break.gres(" dgram_socket_class_set","{ udp_socket unix_dgram_socket }");
lines_break.gres(" stream_socket_class_set","{ tcp_socket unix_stream_socket }");
lines_break.gres(" unpriv_socket_class_set","{ tcp_socket udp_socket unix_stream_socket unix_dgram_socket }");
lines_break.gres(" stat_file_perms","{ getattr }");
lines_break.gres(" x_file_perms","{ getattr execute }");
lines_break.gres(" r_file_perms","{ read getattr lock ioctl }");
lines_break.gres(" rx_file_perms","{ read getattr lock execute ioctl }");
lines_break.gres(" ra_file_perms","{ ioctl read getattr lock append }");
lines_break.gres(" link_file_perms","{ getattr link unlink rename }");
lines_break.gres(" create_lnk_perms","{ create read getattr setattr link unlink rename }");
lines_break.gres(" create_file_perms","{ create ioctl read getattr lock write setattr append link unlink rename }");
lines_break.gres(" r_dir_perms","{ read getattr lock search ioctl }");
lines_break.gres(" rw_dir_perms","{ read getattr lock search ioctl add_name remove_name write }");
lines_break.gres(" ra_dir_perms","{ read getattr lock search ioctl add_name write }");
lines_break.gres(" create_dir_perms","{ create read getattr lock setattr ioctl link unlink rename search add_name remove_name reparent write rmdir }");
lines_break.gres(" mount_fs_perms","{ mount remount unmount getattr }");
lines_break.gres(" rw_socket_perms","{ ioctl read getattr write setattr append bind connect getopt setopt shutdown }");
lines_break.gres(" create_socket_perms","{ create rw_socket_perms }");
lines_break.gres(" rw_stream_socket_perms","{ rw_socket_perms listen accept }");
lines_break.gres(" create_stream_socket_perms","{ create_socket_perms listen accept }");
lines_break.gres(" connected_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" connected_stream_socket_perms","{ connected_socket_perms listen accept }");
lines_break.gres(" create_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" rw_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" r_netlink_socket_perms","{ create_socket_perms nlmsg_read }");
lines_break.gres(" signal_perms","{ sigchld sigkill sigstop signull signal }");
lines_break.gres(" packet_perms","{ tcp_recv tcp_send udp_recv udp_send rawip_recv rawip_send }");
lines_break.gres(" r_sem_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_sem_perms","{ associate getattr read write unix_read unix_write }");
lines_break.gres(" create_sem_perms","{ associate getattr setattr create destroy read write unix_read unix_write }");
lines_break.gres(" r_msgq_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_msgq_perms","{ associate getattr read write enqueue unix_read unix_write }");
lines_break.gres(" create_msgq_perms","{ associate getattr setattr create destroy read write enqueue unix_read unix_write }");
lines_break.gres(" r_shm_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_shm_perms","{ associate getattr read write lock unix_read unix_write }");
lines_break.gres(" create_shm_perms","{ associate getattr setattr create destroy read write lock unix_read unix_write }");
lines_break.gres(" getattr_dir_perms","{ getattr }");
lines_break.gres(" setattr_dir_perms","{ setattr }");
lines_break.gres(" search_dir_perms","{ getattr search }");
lines_break.gres(" list_dir_perms","{ getattr search read lock ioctl }");
lines_break.gres(" add_entry_dir_perms","{ getattr search lock ioctl write add_name }");
lines_break.gres(" del_entry_dir_perms","{ getattr search lock ioctl write remove_name }");
lines_break.gres(" create_dir_perms","{ getattr create }");
lines_break.gres(" rename_dir_perms","{ getattr rename }");
lines_break.gres(" delete_dir_perms","{ getattr rmdir }");
lines_break.gres(" manage_dir_perms","{ create getattr setattr read write link unlink rename search add_name remove_name reparent rmdir lock ioctl }");
lines_break.gres(" relabelfrom_dir_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_dir_perms","{ getattr relabelto }");
lines_break.gres(" relabel_dir_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_file_perms","{ getattr }");
lines_break.gres(" setattr_file_perms","{ setattr }");
lines_break.gres(" read_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" mmap_file_perms","{ getattr read execute }");
lines_break.gres(" exec_file_perms","{ getattr read execute execute_no_trans }");
lines_break.gres(" append_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_file_perms","{ getattr create }");
lines_break.gres(" rename_file_perms","{ getattr rename }");
lines_break.gres(" delete_file_perms","{ getattr unlink }");
lines_break.gres(" manage_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_lnk_file_perms","{ getattr }");
lines_break.gres(" setattr_lnk_file_perms","{ setattr }");
lines_break.gres(" read_lnk_file_perms","{ getattr read }");
lines_break.gres(" write_lnk_file_perms","{ getattr write lock ioctl }");
lines_break.gres(" rw_lnk_file_perms","{ getattr read write lock ioctl }");
lines_break.gres(" create_lnk_file_perms","{ create getattr }");
lines_break.gres(" rename_lnk_file_perms","{ getattr rename }");
lines_break.gres(" delete_lnk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_lnk_file_perms","{ create read getattr setattr unlink rename }");
lines_break.gres(" relabelfrom_lnk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_lnk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_lnk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_fifo_file_perms","{ getattr }");
lines_break.gres(" setattr_fifo_file_perms","{ setattr }");
lines_break.gres(" read_fifo_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_fifo_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_fifo_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_fifo_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_fifo_file_perms","{ getattr create }");
lines_break.gres(" rename_fifo_file_perms","{ getattr rename }");
lines_break.gres(" delete_fifo_file_perms","{ getattr unlink }");
lines_break.gres(" manage_fifo_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_fifo_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_fifo_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_fifo_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_sock_file_perms","{ getattr }");
lines_break.gres(" setattr_sock_file_perms","{ setattr }");
lines_break.gres(" read_sock_file_perms","{ getattr read }");
lines_break.gres(" write_sock_file_perms","{ getattr write append }");
lines_break.gres(" rw_sock_file_perms","{ getattr read write append }");
lines_break.gres(" create_sock_file_perms","{ getattr create }");
lines_break.gres(" rename_sock_file_perms","{ getattr rename }");
lines_break.gres(" delete_sock_file_perms","{ getattr unlink }");
lines_break.gres(" manage_sock_file_perms","{ create getattr setattr read write rename link unlink ioctl lock append }");
lines_break.gres(" relabelfrom_sock_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_sock_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_sock_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_blk_file_perms","{ getattr }");
lines_break.gres(" setattr_blk_file_perms","{ setattr }");
lines_break.gres(" read_blk_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_blk_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_blk_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_blk_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_blk_file_perms","{ getattr create }");
lines_break.gres(" rename_blk_file_perms","{ getattr rename }");
lines_break.gres(" delete_blk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_blk_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_blk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_blk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_blk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_chr_file_perms","{ getattr }");
lines_break.gres(" setattr_chr_file_perms","{ setattr }");
lines_break.gres(" read_chr_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_chr_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_chr_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_chr_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_chr_file_perms","{ getattr create }");
lines_break.gres(" rename_chr_file_perms","{ getattr rename }");
lines_break.gres(" delete_chr_file_perms","{ getattr unlink }");
lines_break.gres(" manage_chr_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_chr_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_chr_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_chr_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" rw_term_perms","{ getattr read write ioctl }");
lines_break.gres(" client_stream_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" server_stream_socket_perms","{ client_stream_socket_perms listen accept }");

				for ( it = lines_break.begin(); it != lines_break.end(); ++it ){
				    //have to convert again for file_patterns stuff...i mean, interfaces which were called from interfaces, does this work? it's working only remaining analized interface...solve it later.after this, again breaking perms stuff.
				    line_analized = *it;
					//////////////////////////files pattern//////////////////////////////////////
					//getattr_dirs_pattern
					if(line_analized.find( rx_getattr_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir getattr_dir_perms;";
				        }					
					//setattr_dirs_pattern
					if(line_analized.find( rx_setattr_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir setattr_dir_perms;";
				        }					
					//search_dirs_pattern
					if(line_analized.find( rx_search_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir search_dir_perms;";
				        }					
					//list_dirs_pattern
					if(line_analized.find( rx_list_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir list_dir_perms;";
				        }						
					//add_entry_dirs_pattern
					if(line_analized.find( rx_add_entry_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir add_entry_dir_perms;";
				        }					
					//del_entry_dirs_pattern
					if(line_analized.find( rx_del_entry_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir del_entry_dir_perms;";
				        }					
					//create_dirs_pattern
					if(line_analized.find( rx_create_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir create_dir_perms;";
				        }					
					//delete_dirs_pattern
					if(line_analized.find( rx_delete_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir delete_dir_perms;";
				        }					
					//rename_dirs_pattern
					if(line_analized.find( rx_rename_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir rename_dir_perms;";
				        }					
					//manage_dirs_pattern
					if(line_analized.find( rx_manage_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir manage_dir_perms;";
				        }					
					//relabelfrom_dirs_pattern
					if(line_analized.find( rx_relabelfrom_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir relabelfrom_dir_perms;";
				        }					
					//relabelto_dirs_pattern
					if(line_analized.find( rx_relabelto_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir relabelto_dir_perms;";
				        }					
					//relabel_dirs_pattern
					if(line_analized.find( rx_relabel_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir relabel_dir_perms;";
				        }					
					//rw_dirs_pattern
					if(line_analized.find( rx_rw_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":dir del_entry_dir_perms;";
				        }					
					//r_files_pattern
					if(line_analized.find( rx_getattr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file getattr_file_perms;";
				        }					
					//setattr_files_pattern
					if(line_analized.find( rx_setattr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file setattr_file_perms;";
				        }					
					//read_files_pattern
					if(line_analized.find( rx_read_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file read_file_perms;";
				        }					
					//mmap_files_pattern
					if(line_analized.find( rx_mmap_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file mmap_file_perms;";
				        }					
					//exec_files_pattern
					if(line_analized.find( rx_exec_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file exec_file_perms;";
				        }					
					//append_files_pattern
					if(line_analized.find( rx_append_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
 						third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file append_file_perms;";
				        }					
					//write_files_pattern
					if(line_analized.find( rx_write_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file write_file_perms;";
				        }					
					//rw_files_pattern
					if(line_analized.find( rx_rw_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file rw_file_perms;";
				        }					
					//create_files_pattern
					if(line_analized.find( rx_create_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file create_file_perms;";
				        }					
					//delete_files_pattern
					if(line_analized.find( rx_delete_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file delete_file_perms;";
				        }										
					//rename_files_pattern
					if(line_analized.find( rx_rename_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file rename_file_perms;";
				        }					
					//manage_files_pattern
					if(line_analized.find( rx_manage_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file manage_file_perms;";
				        }					
					//relabelfrom_files_pattern
					if(line_analized.find( rx_relabelfrom_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file relabelfrom_file_perms;";
				        }					
					//relabelto_files_pattern
					if(line_analized.find( rx_relabelto_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file relabelto_file_perms;";
				        }					
					//relabel_files_pattern
					if(line_analized.find( rx_relabel_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":file relabel_file_perms;";
				        }					
					//getattr_lnk_files_pattern
					if(line_analized.find( rx_getattr_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file getattr_lnk_file_perms;";
				        }						
					//setattr_lnk_files_pattern
					if(line_analized.find( rx_setattr_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file setattr_lnk_file_perms;";
				        }					
					//read_lnk_files_pattern
					if(line_analized.find( rx_read_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file read_lnk_file_perms;";
				        }					
					//append_lnk_files_pattern
					if(line_analized.find( rx_append_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file append_lnk_file_perms;";
				        }					
					//write_lnk_files_pattern
					if(line_analized.find( rx_write_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file write_lnk_file_perms;";
				        }						
					//rw_lnk_files_pattern
					if(line_analized.find( rx_rw_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file rw_lnk_file_perms;";
				        }							
					//create_lnk_files_pattern
					if(line_analized.find( rx_create_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file create_lnk_file_perms;";
				        }					
					//delete_lnk_files_pattern
					if(line_analized.find( rx_delete_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file delete_lnk_file_perms;";
				        }					
					//rename_lnk_files_pattern
					if(line_analized.find( rx_rename_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file rename_lnk_file_perms;";
				        }						
					//manage_lnk_files_pattern
					if(line_analized.find( rx_manage_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file manage_lnk_file_perms;";
				        }					
					//relabelfrom_lnk_files_pattern
					if(line_analized.find( rx_relabelfrom_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file relabelfrom_lnk_file_perms;";
				        }					
					//relabelto_lnk_files_pattern
					if(line_analized.find( rx_relabelto_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file relabelto_lnk_file_perms;";
				        }					
					//relabel_lnk_files_pattern
					if(line_analized.find( rx_relabel_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":lnk_file relabel_lnk_file_perms;";
				        }					
					//getattr_fifo_files_pattern
					if(line_analized.find( rx_getattr_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file getattr_fifo_file_perms;";
				        }					
					//setattr_fifo_files_pattern
					if(line_analized.find( rx_setattr_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file setattr_fifo_file_perms;";
				        }					
					//read_fifo_files_pattern
					if(line_analized.find( rx_read_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file read_fifo_file_perms;";
				        }					
					//append_fifo_files_pattern
					if(line_analized.find( rx_append_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file append_fifo_file_perms;";
				        }					
					//write_fifo_files_pattern
					if(line_analized.find( rx_write_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file write_fifo_file_perms;";
				        }					
					//rw_fifo_files_pattern
					if(line_analized.find( rx_rw_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file rw_fifo_file_perms;";
				        }					
					//create_fifo_files_pattern
					if(line_analized.find( rx_create_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file create_fifo_file_perms;";
				        }					
					//delete_fifo_files_pattern
					if(line_analized.find( rx_delete_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file delete_fifo_file_perms;";
				        }					
					//rename_fifo_files_pattern
					if(line_analized.find( rx_rename_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file rename_fifo_file_perms;";
				        }					
					//manage_fifo_files_pattern
					if(line_analized.find( rx_manage_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file manage_fifo_file_perms;";
				        }					
					//relabelfrom_fifo_files_pattern
					if(line_analized.find( rx_relabelfrom_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file relabelfrom_fifo_file_perms;";
				        }					
					//relabelto_fifo_files_pattern
					if(line_analized.find( rx_relabelto_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file relabelto_fifo_file_perms;";
				        }					
					//relabel_fifo_files_pattern
					if(line_analized.find( rx_relabel_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":fifo_file relabel_fifo_file_perms;";
				        }					
					//getattr_sock_files_pattern
					if(line_analized.find( rx_getattr_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file getattr_sock_file_perms;";
				        }					
					//setattr_sock_files_pattern
					if(line_analized.find( rx_setattr_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file setattr_sock_file_perms;";
				        }					
					//read_sock_files_pattern
					if(line_analized.find( rx_read_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file read_sock_file_perms;";
				        }					
					//write_sock_files_pattern
					if(line_analized.find( rx_write_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file write_sock_file_perms;";
				        }
					//rw_sock_files_pattern
					if(line_analized.find( rx_rw_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file rw_sock_file_perms;";
				        }
					//create_sock_files_pattern
					if(line_analized.find( rx_create_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file create_sock_file_perms;";
				        }					
					//delete_sock_files_pattern
					if(line_analized.find( rx_delete_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file delete_sock_file_perms;";
				        }					
					//rename_sock_files_pattern
					if(line_analized.find( rx_rename_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file rename_sock_file_perms;";
				        }					
					//manage_sock_files_pattern
					if(line_analized.find( rx_manage_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file manage_sock_file_perms;";
				        }					
					//relabelfrom_sock_files_pattern
					if(line_analized.find( rx_relabelfrom_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file relabelfrom_sock_file_perms;";
				        }					
					//relabelto_sock_files_pattern
					if(line_analized.find( rx_relabelto_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file relabelto_sock_file_perms;";
				        }					
					//relabel_sock_files_pattern
					if(line_analized.find( rx_relabel_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":sock_file relabel_sock_file_perms;";
				        }					
					//getattr_blk_files_pattern
					if(line_analized.find( rx_getattr_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file getattr_blk_file_perms;";
				        }						
					//setattr_blk_files_pattern
					if(line_analized.find( rx_setattr_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file setattr_blk_file_perms;";
				        }					
					//read_blk_files_pattern
					if(line_analized.find( rx_read_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file read_blk_file_perms;";
				        }						
					//append_blk_files_pattern
					if(line_analized.find( rx_append_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file append_blk_file_perms;";
				        }					
					//write_blk_files_pattern
					if(line_analized.find( rx_write_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file write_blk_file_perms;";
				        }						
					//rw_blk_files_pattern
					if(line_analized.find( rx_rw_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file rw_blk_file_perms;";
				        }						
					//create_blk_files_pattern
					if(line_analized.find( rx_create_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + "self:capability mknod;";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file create_blk_file_perms;";
				        }					
					//delete_blk_files_pattern
					if(line_analized.find( rx_delete_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file delete_blk_file_perms;";
				        }					
					//rename_blk_files_pattern
					if(line_analized.find( rx_rename_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file rename_blk_file_perms;";
				        }					
					//manage_blk_files_pattern
					if(line_analized.find( rx_manage_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + "self:capability mknod;";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file manage_blk_file_perms;";
				        }					
					//relabelfrom_blk_files_pattern
					if(line_analized.find( rx_relabelfrom_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file relabelfrom_blk_file_perms;";
				        }							
					//relabelto_blk_files_pattern
					if(line_analized.find( rx_relabelto_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file relabelto_blk_file_perms;";
				        }							
					//relabel_blk_files_pattern
					if(line_analized.find( rx_relabel_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":blk_file relabel_blk_file_perms;";
				        }						
					//getattr_chr_files_pattern
					if(line_analized.find( rx_getattr_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file getattr_chr_file_perms;";
				        }					
					//setattr_chr_files_pattern
					if(line_analized.find( rx_read_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file setattr_chr_file_perms;";
				        }					
					//read_chr_files_pattern
					if(line_analized.find( rx_read_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file read_chr_file_perms;";
				        }
					//append_chr_files_pattern
					if(line_analized.find( rx_append_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file append_chr_file_perms;";
				        }						
					//write_chr_files_pattern
					if(line_analized.find( rx_write_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file write_chr_file_perms;";
				        }					
					//rw_chr_files_pattern
					if(line_analized.find( rx_rw_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file rw_chr_file_perms;";
				        }					
					//create_chr_files_pattern
					if(line_analized.find( rx_create_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + "self:capability mknod;";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file create_chr_file_perms;";
				        }					
					//delete_chr_files_pattern
					if(line_analized.find( rx_delete_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
				
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file delete_chr_file_perms;";
				        }					
					//rename_chr_files_pattern
					if(line_analized.find( rx_rename_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
				
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file rename_chr_file_perms;";
				        }					
					//manage_chr_files_pattern
					if(line_analized.find( rx_manage_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + "self:capability mknod;";						
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file manage_chr_file_perms;";
				        }
					//relabelfrom_chr_files_pattern
					if(line_analized.find( rx_relabelfrom_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file relabelfrom_chr_file_perms;";
				        }
					//relabelto_chr_files_pattern
					if(line_analized.find( rx_relabelto_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file relabelto_chr_file_perms;";
				        }
					//relabel_chr_files_pattern
					if(line_analized.find( rx_relabel_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines_break += tab + "allow " + first_var + " " + third_var + ":chr_file relabel_chr_file_perms;";
				        }
					//filetrans_add_pattern
					if(line_analized.find( rx_filetrans_add_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						fourth_var = line_analized.section( ',', 3, 3 );
						fourth_var = fourth_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir ra_dir_perms;";
						lines_break += tab + "type_transition " + first_var + " " + second_var + ":" + fourth_var + " " + third_var + ";";
				        }					
					//filetrans_pattern
					if(line_analized.find( rx_filetrans_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						fourth_var = line_analized.section( ',', 3, 3 );
						fourth_var = fourth_var.replace( QChar(')'), "" );
						line_analized="";
						lines_break += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines_break += tab + "type_transition " + first_var + " " + second_var + ":" + fourth_var + " " + third_var + ";";
				        }									
					/////////////////end-files pattern//////////////////////
				 //(not-needed)line_analized = tab + line_analized + cumma;
				}
				
// it should have space otherwise getattr_dir_perms and r_dir_perms would collide
lines_break.gres(" dir_file_class_set","{ dir file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" file_class_set","{ file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" notdevfile_class_set","{ file lnk_file sock_file fifo_file }");
lines_break.gres(" devfile_class_set","{ chr_file blk_file }");
lines_break.gres(" socket_class_set","{ tcp_socket udp_socket rawip_socket netlink_socket packet_socket unix_stream_socket unix_dgram_socket appletalk_socket netlink_route_socket netlink_firewall_socket netlink_tcpdiag_socket netlink_nflog_socket netlink_xfrm_socket netlink_selinux_socket netlink_audit_socket netlink_ip6fw_socket netlink_dnrt_socket netlink_kobject_uevent_socket }");
lines_break.gres(" dgram_socket_class_set","{ udp_socket unix_dgram_socket }");
lines_break.gres(" stream_socket_class_set","{ tcp_socket unix_stream_socket }");
lines_break.gres(" unpriv_socket_class_set","{ tcp_socket udp_socket unix_stream_socket unix_dgram_socket }");
lines_break.gres(" stat_file_perms","{ getattr }");
lines_break.gres(" x_file_perms","{ getattr execute }");
lines_break.gres(" r_file_perms","{ read getattr lock ioctl }");
lines_break.gres(" rx_file_perms","{ read getattr lock execute ioctl }");
lines_break.gres(" ra_file_perms","{ ioctl read getattr lock append }");
lines_break.gres(" link_file_perms","{ getattr link unlink rename }");
lines_break.gres(" create_lnk_perms","{ create read getattr setattr link unlink rename }");
lines_break.gres(" create_file_perms","{ create ioctl read getattr lock write setattr append link unlink rename }");
lines_break.gres(" r_dir_perms","{ read getattr lock search ioctl }");
lines_break.gres(" rw_dir_perms","{ read getattr lock search ioctl add_name remove_name write }");
lines_break.gres(" ra_dir_perms","{ read getattr lock search ioctl add_name write }");
lines_break.gres(" create_dir_perms","{ create read getattr lock setattr ioctl link unlink rename search add_name remove_name reparent write rmdir }");
lines_break.gres(" mount_fs_perms","{ mount remount unmount getattr }");
lines_break.gres(" rw_socket_perms","{ ioctl read getattr write setattr append bind connect getopt setopt shutdown }");
lines_break.gres(" create_socket_perms","{ create rw_socket_perms }");
lines_break.gres(" rw_stream_socket_perms","{ rw_socket_perms listen accept }");
lines_break.gres(" create_stream_socket_perms","{ create_socket_perms listen accept }");
lines_break.gres(" connected_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" connected_stream_socket_perms","{ connected_socket_perms listen accept }");
lines_break.gres(" create_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" rw_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" r_netlink_socket_perms","{ create_socket_perms nlmsg_read }");
lines_break.gres(" signal_perms","{ sigchld sigkill sigstop signull signal }");
lines_break.gres(" packet_perms","{ tcp_recv tcp_send udp_recv udp_send rawip_recv rawip_send }");
lines_break.gres(" r_sem_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_sem_perms","{ associate getattr read write unix_read unix_write }");
lines_break.gres(" create_sem_perms","{ associate getattr setattr create destroy read write unix_read unix_write }");
lines_break.gres(" r_msgq_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_msgq_perms","{ associate getattr read write enqueue unix_read unix_write }");
lines_break.gres(" create_msgq_perms","{ associate getattr setattr create destroy read write enqueue unix_read unix_write }");
lines_break.gres(" r_shm_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_shm_perms","{ associate getattr read write lock unix_read unix_write }");
lines_break.gres(" create_shm_perms","{ associate getattr setattr create destroy read write lock unix_read unix_write }");
lines_break.gres(" getattr_dir_perms","{ getattr }");
lines_break.gres(" setattr_dir_perms","{ setattr }");
lines_break.gres(" search_dir_perms","{ getattr search }");
lines_break.gres(" list_dir_perms","{ getattr search read lock ioctl }");
lines_break.gres(" add_entry_dir_perms","{ getattr search lock ioctl write add_name }");
lines_break.gres(" del_entry_dir_perms","{ getattr search lock ioctl write remove_name }");
lines_break.gres(" create_dir_perms","{ getattr create }");
lines_break.gres(" rename_dir_perms","{ getattr rename }");
lines_break.gres(" delete_dir_perms","{ getattr rmdir }");
lines_break.gres(" manage_dir_perms","{ create getattr setattr read write link unlink rename search add_name remove_name reparent rmdir lock ioctl }");
lines_break.gres(" relabelfrom_dir_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_dir_perms","{ getattr relabelto }");
lines_break.gres(" relabel_dir_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_file_perms","{ getattr }");
lines_break.gres(" setattr_file_perms","{ setattr }");
lines_break.gres(" read_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" mmap_file_perms","{ getattr read execute }");
lines_break.gres(" exec_file_perms","{ getattr read execute execute_no_trans }");
lines_break.gres(" append_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_file_perms","{ getattr create }");
lines_break.gres(" rename_file_perms","{ getattr rename }");
lines_break.gres(" delete_file_perms","{ getattr unlink }");
lines_break.gres(" manage_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_lnk_file_perms","{ getattr }");
lines_break.gres(" setattr_lnk_file_perms","{ setattr }");
lines_break.gres(" read_lnk_file_perms","{ getattr read }");
lines_break.gres(" write_lnk_file_perms","{ getattr write lock ioctl }");
lines_break.gres(" rw_lnk_file_perms","{ getattr read write lock ioctl }");
lines_break.gres(" create_lnk_file_perms","{ create getattr }");
lines_break.gres(" rename_lnk_file_perms","{ getattr rename }");
lines_break.gres(" delete_lnk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_lnk_file_perms","{ create read getattr setattr unlink rename }");
lines_break.gres(" relabelfrom_lnk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_lnk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_lnk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_fifo_file_perms","{ getattr }");
lines_break.gres(" setattr_fifo_file_perms","{ setattr }");
lines_break.gres(" read_fifo_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_fifo_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_fifo_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_fifo_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_fifo_file_perms","{ getattr create }");
lines_break.gres(" rename_fifo_file_perms","{ getattr rename }");
lines_break.gres(" delete_fifo_file_perms","{ getattr unlink }");
lines_break.gres(" manage_fifo_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_fifo_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_fifo_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_fifo_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_sock_file_perms","{ getattr }");
lines_break.gres(" setattr_sock_file_perms","{ setattr }");
lines_break.gres(" read_sock_file_perms","{ getattr read }");
lines_break.gres(" write_sock_file_perms","{ getattr write append }");
lines_break.gres(" rw_sock_file_perms","{ getattr read write append }");
lines_break.gres(" create_sock_file_perms","{ getattr create }");
lines_break.gres(" rename_sock_file_perms","{ getattr rename }");
lines_break.gres(" delete_sock_file_perms","{ getattr unlink }");
lines_break.gres(" manage_sock_file_perms","{ create getattr setattr read write rename link unlink ioctl lock append }");
lines_break.gres(" relabelfrom_sock_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_sock_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_sock_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_blk_file_perms","{ getattr }");
lines_break.gres(" setattr_blk_file_perms","{ setattr }");
lines_break.gres(" read_blk_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_blk_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_blk_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_blk_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_blk_file_perms","{ getattr create }");
lines_break.gres(" rename_blk_file_perms","{ getattr rename }");
lines_break.gres(" delete_blk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_blk_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_blk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_blk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_blk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_chr_file_perms","{ getattr }");
lines_break.gres(" setattr_chr_file_perms","{ setattr }");
lines_break.gres(" read_chr_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_chr_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_chr_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_chr_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_chr_file_perms","{ getattr create }");
lines_break.gres(" rename_chr_file_perms","{ getattr rename }");
lines_break.gres(" delete_chr_file_perms","{ getattr unlink }");
lines_break.gres(" manage_chr_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_chr_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_chr_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_chr_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" rw_term_perms","{ getattr read write ioctl }");
lines_break.gres(" client_stream_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" server_stream_socket_perms","{ client_stream_socket_perms listen accept }");
				
				//now write to a file using iterator.
				QTextStream stream_w( &file_w );
				for ( it = lines_break.begin(); it != lines_break.end(); ++it ){
				    stream_w << *it << "\n";
				}				
				file.close();
				lines_break.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
}//end-break_services
