/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.webLoader;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import slothLib.portUtil.PortUtil;
import slothLib.web.webLoader.HttpHeader;

public class WebGetResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String url;
    private String localFilePath;
    private HttpHeader header;
    private String response;

    public WebGetResult(String url, String localFilePath, HttpHeader header, String response) {
        this.url = url;
        this.localFilePath = localFilePath;
        this.header = header;
        this.response = response;
        System.err.println("Path: " + this.localFilePath);
    }

    public String getURL() {
        return this.url;
    }

    public String getLocalFilePath() {
        return this.localFilePath;
    }

    public void setLocalFilePath(String value) {
        this.moveFile(value);
    }

    public HttpHeader getHeader() {
        return this.header;
    }

    public String getResponse() {
        return this.response;
    }

    public void changeExtension() {
        String contentType = this.header.getContentType();
        if (contentType.equals("text/html")) {
            this.moveFile(String.valueOf(this.localFilePath) + ".html");
        } else if (contentType.equals("application/pdf")) {
            this.moveFile(String.valueOf(this.localFilePath) + ".pdf");
        } else if (contentType.equals("application/msword")) {
            this.moveFile(String.valueOf(this.localFilePath) + ".doc");
        }
    }

    public void moveFile(String destFileName) {
        File fi = new File(destFileName);
        File di = new File(fi.getParent());
        if (PortUtil.fileExists(di.getAbsolutePath())) {
            di.mkdirs();
        }
        if (PortUtil.fileExists(fi.getAbsolutePath())) {
            try {
                PortUtil.fileDelete(fi.getAbsolutePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        new File(this.localFilePath).renameTo(fi);
        this.localFilePath = destFileName;
    }

    public void deleteFile() {
        if (PortUtil.fileExists(this.localFilePath)) {
            try {
                PortUtil.fileDelete(this.localFilePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

