/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import slothLib.portUtil.PortUtil;
import slothLib.web.search.ISearch;
import slothLib.web.search.OshieteGooElement;
import slothLib.web.search.OshieteGooSearchResult;
import slothLib.web.search.WebSearchException;

public class OshieteGooSearch
implements ISearch {
    private Proxy proxy;

    public void setProxy(String proxyAddress) {
        this.proxy = proxyAddress == null ? null : PortUtil.createProxy(proxyAddress);
    }

    @Override
    public OshieteGooSearchResult doSearch(String query, int maxNumber) {
        return this.doOshieteSearch(query, maxNumber);
    }

    private OshieteGooSearchResult doOshieteSearch(String query, int maxNumber) {
        ArrayList<OshieteGooElement> elements = new ArrayList<OshieteGooElement>();
        long searchTotalResults = 0L;
        int rank = 0;
        int page = 1;
        while (true) {
            Document xmlDoc;
            String requestURL = this.makeRequestURL(query, maxNumber, page);
            try {
                xmlDoc = PortUtil.getDocumentFromURL(requestURL, this.proxy);
            }
            catch (WebSearchException e) {
                e.printStackTrace();
                return null;
            }
            Element xmlRoot = xmlDoc.getDocumentElement();
            searchTotalResults = Long.parseLong(this.getElementString(xmlRoot.getElementsByTagName("oshietegoo:searchTotalResults")));
            NodeList xmlItemList = xmlRoot.getElementsByTagName("item");
            int i = 0;
            while (i < xmlItemList.getLength()) {
                Element xmlItem = (Element)xmlItemList.item(i);
                ++rank;
                String title = this.getElementString(xmlItem.getElementsByTagName("title"));
                String url = this.getElementString(xmlItem.getElementsByTagName("link"));
                String description = this.getElementString(xmlItem.getElementsByTagName("description"));
                String category = this.getElementString(xmlItem.getElementsByTagName("dc:subject"));
                String pubData = this.getElementString(xmlItem.getElementsByTagName("dc:date"));
                String creater = this.getElementString(xmlItem.getElementsByTagName("dc:creator"));
                OshieteGooElement element = new OshieteGooElement(url, title, description, pubData, category, creater, rank);
                elements.add(element);
                if (elements.size() >= maxNumber || (long)elements.size() >= searchTotalResults) {
                    int resultNum = elements.size();
                    return new OshieteGooSearchResult(query, searchTotalResults, elements.toArray(new OshieteGooElement[0]));
                }
                ++i;
            }
            ++page;
        }
    }

    private String makeRequestURL(String query, int maxNumber, int page) {
        StringBuffer builder = new StringBuffer();
        builder.append("http://oshiete.goo.ne.jp/search/search.php?status=select&mt_opt=a&rss=1&MT=");
        try {
            builder.append(URLEncoder.encode(query, "EUC-JP"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            builder.append(URLEncoder.encode(query));
        }
        builder.append("&dc=");
        builder.append(Math.min(maxNumber, 50));
        builder.append("&pg=");
        builder.append(page);
        return builder.toString();
    }

    private String getElementString(NodeList nodeList) {
        if (nodeList.getLength() == 0) {
            return "";
        }
        return nodeList.item(0).getTextContent();
    }
}

