/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import java.net.Proxy;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import slothLib.portUtil.PortUtil;
import slothLib.web.search.FlickrElement;
import slothLib.web.search.FlickrException;
import slothLib.web.search.FlickrSearchResult;
import slothLib.web.search.IImageSearch;
import slothLib.web.search.IImageSearchResult;
import slothLib.web.search.WebSearchException;

public class FlickrSearch
implements IImageSearch {
    private String apiKey;
    private Proxy proxy;

    public FlickrSearch(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getProxy() {
        return PortUtil.getProxyURL(this.proxy);
    }

    public void setProxy(String value) {
        this.proxy = PortUtil.isNullOrEmpty(value) ? null : PortUtil.createProxy(value);
    }

    public FlickrSearchResult doSearch(String query, int num, SearchType searchType, TagMode tagMode) throws WebSearchException {
        if (this.apiKey == "") {
            throw new FlickrException("No APIKey");
        }
        System.err.println("API_Key:" + this.apiKey);
        FlickrSearchResult searchResult = null;
        try {
            searchResult = this.doFlickrSearch(query, num, searchType, tagMode);
        }
        catch (WebSearchException e) {
            System.err.println(e.getMessage());
            throw e;
        }
        return searchResult;
    }

    private FlickrSearchResult doFlickrSearch(String query, int num, SearchType searchType, TagMode tagMode) throws WebSearchException {
        String requestURL = this.makeFlickrQuery(query, num, searchType, tagMode);
        System.err.println("RequestURL:" + requestURL);
        Document xmlDoc = PortUtil.getDocumentFromURL(requestURL, this.proxy);
        Element xmlRoot = xmlDoc.getDocumentElement();
        if (xmlRoot.getAttribute("stat").equals("fail")) {
            String errcode = xmlRoot.getFirstChild().getAttributes().getNamedItem("code").getNodeValue();
            String errmsg = xmlRoot.getFirstChild().getAttributes().getNamedItem("msg").getNodeValue();
            throw new FlickrException(String.valueOf(errcode) + ":" + errmsg);
        }
        Node xmlResultsNode = xmlRoot.getFirstChild();
        long resultNum = Long.parseLong(xmlResultsNode.getAttributes().getNamedItem("total").getNodeValue());
        ArrayList<FlickrElement> resultElementList = new ArrayList<FlickrElement>();
        NodeList xmlResultList = xmlResultsNode.getChildNodes();
        int i = 0;
        while (i < xmlResultList.getLength()) {
            Element xmlResult = (Element)xmlResultList.item(i);
            String id = xmlResult.getAttribute("id");
            String owner = xmlResult.getAttribute("owner");
            String secret = xmlResult.getAttribute("secret");
            String server = xmlResult.getAttribute("server");
            String farm = xmlResult.getAttribute("farm");
            String title = xmlResult.getAttribute("title");
            boolean isPublic = this.bitToBoolean(xmlResult.getAttribute("ispublic"));
            boolean isFriend = this.bitToBoolean(xmlResult.getAttribute("isfriend"));
            boolean isFamily = this.bitToBoolean(xmlResult.getAttribute("isfamily"));
            FlickrElement result = new FlickrElement(id, owner, secret, server, farm, title, isPublic, isFriend, isFamily);
            resultElementList.add(result);
            ++i;
        }
        return new FlickrSearchResult(query, resultNum, resultElementList.toArray(new FlickrElement[0]));
    }

    private String makeFlickrQuery(String query, int results, SearchType searchType, TagMode tagMode) {
        String str = "";
        String mode = "";
        String flickrQuery = "http://api.flickr.com/services/rest/?method=flickr.photos.search";
        String csvQuery = this.makeCSVQuery(query);
        switch (searchType) {
            case Text: {
                str = "&text=" + csvQuery;
                break;
            }
            case Tag: {
                str = "&tags=" + csvQuery;
            }
        }
        switch (tagMode) {
            case Any: {
                mode = "&tag_mode=any";
                break;
            }
            case All: {
                mode = "&tag_mode=all";
            }
        }
        flickrQuery = String.valueOf(flickrQuery) + "&api_key=" + this.apiKey + str + "&per_page=" + results + mode;
        return flickrQuery;
    }

    private String makeCSVQuery(String query) {
        String[] array = query.split(" ");
        String q = "";
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            q = String.valueOf(q) + s + ",";
            ++n2;
        }
        return q.substring(0, q.length() - 1);
    }

    private boolean bitToBoolean(String bit) {
        return bit.contains("1");
    }

    public static SearchType getSearchType(String type) {
        String lower = type.toLowerCase();
        SearchType st = lower.equals("tag") ? SearchType.Tag : (lower.equals("text") ? SearchType.Text : SearchType.Text);
        return st;
    }

    public static TagMode getTagMode(String tagMode) {
        String lower = tagMode.toLowerCase();
        TagMode tm = lower.equals("any") ? TagMode.Any : (lower.equals("all") ? TagMode.All : TagMode.Any);
        return tm;
    }

    @Override
    public IImageSearchResult doSearch(String query, int num) throws WebSearchException {
        return this.doSearch(query, num, SearchType.Text, TagMode.Any);
    }

    public static enum SearchType {
        Text,
        Tag;

    }

    public static enum TagMode {
        Any,
        All;

    }
}

