/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.matrix;

import slothLib.linearAlgebra.matrix.BasicMatrix;
import slothLib.linearAlgebra.matrix.IMatrix;
import slothLib.linearAlgebra.matrix.MatrixOperator;

public class AugNormMatrix
extends BasicMatrix {
    private final double MIN = 0.5;
    private final double MAX = 1.0;

    public AugNormMatrix(IMatrix matrix) {
        super(matrix.rowCount(), matrix.columnCount());
        double absMax = MatrixOperator.getMaxNorm(matrix);
        int i = 0;
        while (i < matrix.rowCount()) {
            int j = 0;
            while (j < matrix.columnCount()) {
                if (absMax != 0.0) {
                    this.set(i, j, 0.5 + 0.5 * matrix.get(i, j) / absMax);
                } else {
                    this.set(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
    }
}

