/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import slothLib.linearAlgebra.featureVector.AddVector;
import slothLib.linearAlgebra.featureVector.IVector;
import slothLib.linearAlgebra.featureVector.MultiplyVector;

public class Cluster<T> {
    IVector<T>[] vectors;
    int[] indices;
    IVector<T> centroidVector;

    public Cluster(IVector<T>[] vectors, int[] indices, IVector<T> centroidVector) {
        this.vectors = vectors;
        this.indices = indices;
        this.centroidVector = centroidVector;
    }

    public IVector<T>[] GetVectors() {
        return this.vectors;
    }

    public int[] GetIndices() {
        return this.indices;
    }

    public int itemCount() {
        return this.vectors.length;
    }

    public boolean contains(IVector<T> vector) {
        IVector<T>[] iVectorArray = this.vectors;
        int n = this.vectors.length;
        int n2 = 0;
        while (n2 < n) {
            IVector<T> v = iVectorArray[n2];
            if (v == vector) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean contains(int index) {
        int[] nArray = this.indices;
        int n = this.indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == index) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IVector<T> getCentroidVector() {
        if (this.centroidVector == null) {
            MultiplyVector v = new MultiplyVector(1.0 / (double)this.itemCount(), new AddVector<T>(this.vectors));
            this.centroidVector = v;
        }
        return this.centroidVector;
    }
}

