/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HankakuZenkaku {
    private static final Map<String, String> zenToHanMap = new HashMap<String, String>();
    private static final Map<String, String> hanToZenMap = new HashMap<String, String>();
    private static final Map<String, String> hankanaToZenMap = new HashMap<String, String>();
    private static final Set<String> daku_ables = new HashSet<String>();
    private static final String zen = "\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff10\uff21\uff22\uff23\uff24\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a\u3000\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff0a\uff0b\uff0c\u30fc\uff0e\uff0f\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff3b\uffe5\uff3d\uff3e\uff3f\u2018\uff5b\uff5c\uff5d\u301c\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3090\u3091\u3092\u3093\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30f3\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30fc\u300c\u300d\u3002\u3001\u30fb";
    private static final String han = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff72\uff74\uff66\uff9d\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff6c\uff6d\uff6e\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff72\uff74\uff66\uff9d\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff6c\uff6d\uff6e-\uff62\uff63\uff61\uff64\uff65";
    private static final String zenKana = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30f3\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7";
    private static final String hanKana = "\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff72\uff74\uff66\uff9d\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff6c\uff6d\uff6e";
    private static final String daku_hira = "\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070\u3073\u3076\u3079\u307c\u3071\u3074\u3077\u307a\u307d\u30f4";
    private static final String daku_kata = "\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc\u30d1\u30d4\u30d7\u30da\u30dd\u30f4";
    private static final String daku_han = "\uff76\uff9e\uff77\uff9e\uff78\uff9e\uff79\uff9e\uff7a\uff9e\uff7b\uff9e\uff7c\uff9e\uff7d\uff9e\uff7e\uff9e\uff7f\uff9e\uff80\uff9e\uff81\uff9e\uff82\uff9e\uff83\uff9e\uff84\uff9e\uff8a\uff9e\uff8b\uff9e\uff8c\uff9e\uff8d\uff9e\uff8e\uff9e\uff8a\uff9f\uff8b\uff9f\uff8c\uff9f\uff8d\uff9f\uff8e\uff9f\uff73\uff9e";

    static {
        int i = 0;
        while (i < zen.length()) {
            zenToHanMap.put(zen.substring(i, i + 1), han.substring(i, i + 1));
            ++i;
        }
        i = 0;
        while (i < daku_hira.length()) {
            zenToHanMap.put(daku_hira.substring(i, i + 1), daku_han.substring(2 * i, 2 * i + 2));
            ++i;
        }
        i = 0;
        while (i < daku_kata.length()) {
            zenToHanMap.put(daku_kata.substring(i, i + 1), daku_han.substring(2 * i, 2 * i + 2));
            ++i;
        }
        i = 0;
        while (i < zen.length()) {
            hanToZenMap.put(han.substring(i, i + 1), zen.substring(i, i + 1));
            ++i;
        }
        i = 0;
        while (i < daku_hira.length()) {
            hanToZenMap.put(daku_han.substring(2 * i, 2 * i + 2), daku_kata.substring(i, i + 1));
            ++i;
        }
        i = 0;
        while (i < zenKana.length()) {
            hankanaToZenMap.put(hanKana.substring(i, i + 1), zenKana.substring(i, i + 1));
            ++i;
        }
        i = 0;
        while (i < daku_hira.length()) {
            hankanaToZenMap.put(daku_han.substring(2 * i, 2 * i + 2), daku_kata.substring(i, i + 1));
            ++i;
        }
        i = 0;
        while (i < daku_han.length()) {
            daku_ables.add(daku_han.substring(i, i + 1));
            i += 2;
        }
    }

    public static String hanToZen(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            String dst;
            String src = str.substring(i, i + 1);
            if (daku_ables.contains(src) && i < str.length() - 1 && (str.charAt(i + 1) == '\uff9f' || str.charAt(i + 1) == '\uff9e')) {
                src = str.substring(i, i + 2);
                ++i;
            }
            if ((dst = hanToZenMap.get(src)) == null) {
                sb.append(src);
            } else {
                sb.append(dst);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String hankanaToZen(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            String dst;
            String src = str.substring(i, i + 1);
            if (daku_ables.contains(src) && i < str.length() - 1 && (str.charAt(i + 1) == '\uff9f' || str.charAt(i + 1) == '\uff9e')) {
                src = str.substring(i, i + 2);
                ++i;
            }
            if ((dst = hankanaToZenMap.get(src)) == null) {
                sb.append(src);
            } else {
                sb.append(dst);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String zenToHan(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            String src = str.substring(i, i + 1);
            String dst = zenToHanMap.get(src);
            if (dst == null) {
                sb.append(src);
            } else {
                sb.append(dst);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String test = "\u3093\u306b...\u3061\u306f\uff0e\u3066\u3059\u3068\u3067\u3059\uff0e\uff1c^>\u3053\u3093\u306b...\u3061\u306f\uff0e\u3066\u3059\u3068\u3067\u3059\uff0e\uff1c^>\u6f22\u5b57\u3082\u5165\u308c\u3066\u307f\u305f\uff0e\u30f1\u30f4\u30a1\u30f3\u30b2\u30ea\u30f2\u30f3 \u3053\u3067";
        String test2 = "\u3042122345\u3042\u3042\uff83\uff7d\uff84";
        System.out.println(test);
        String tmp0 = HankakuZenkaku.zenToHan(test);
        System.out.println(tmp0);
        String tmp1 = HankakuZenkaku.hanToZen(tmp0);
        System.out.println(tmp1);
        String tmp2 = HankakuZenkaku.hankanaToZen(test2);
        System.out.println(tmp2);
    }
}

