/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import slothLib.NLP.HankakuZenkaku;
import slothLib.NLP.MatchEvaluator;

public class Filter {
    private static final Map<String, String> mapNumKanjiToNumRoman = new HashMap<String, String>();
    private static final MatchEvaluator toWideMatchEvaluator;
    private static final MatchEvaluator toNarrowMatchEvaluator;
    private static final Pattern alphaDigitRegex;
    private static final Pattern halfKanaRegex;
    private static final Pattern numRegex;
    private static final Pattern numUseKanjiRegex;
    private static final Pattern numKanjiPre1Regex;
    private static final String[] numKanjiPre2Str;
    private static final Pattern[] numKanjiPre2Patterns;
    private static final Pattern numKanjiPre2Regex;
    private static final String[] numKanjiStr;
    private static final Pattern[] numKanjiPatterns;
    private static final Pattern numKanjiSenRegex;
    private static final Pattern numKanjiOneRegex;
    private static final MatchEvaluator numKanjiToNumRomanMatchEvaluator;

    static {
        mapNumKanjiToNumRoman.put("\u3007", "0");
        mapNumKanjiToNumRoman.put("\u4e00", "1");
        mapNumKanjiToNumRoman.put("\u4e8c", "2");
        mapNumKanjiToNumRoman.put("\u4e09", "3");
        mapNumKanjiToNumRoman.put("\u56db", "4");
        mapNumKanjiToNumRoman.put("\u4e94", "5");
        mapNumKanjiToNumRoman.put("\u516d", "6");
        mapNumKanjiToNumRoman.put("\u4e03", "7");
        mapNumKanjiToNumRoman.put("\u516b", "8");
        mapNumKanjiToNumRoman.put("\u4e5d", "9");
        toWideMatchEvaluator = new MatchEvaluator(){

            @Override
            public String eval(String in) {
                return Filter.matchToWide(in);
            }
        };
        toNarrowMatchEvaluator = new MatchEvaluator(){

            @Override
            public String eval(String in) {
                return Filter.matchToNarrow(in);
            }
        };
        alphaDigitRegex = Pattern.compile("[\uff41-\uff5a\uff21-\uff3a\uff10-\uff19]+");
        halfKanaRegex = Pattern.compile("[\u3002-\u309c]+");
        numRegex = Pattern.compile("\\d+([,\uff0c]\\d+)*([\\.\uff0e]\\d+)?");
        numUseKanjiRegex = Pattern.compile("[\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d]+([,\uff0c\u3001][\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d]+)*");
        numKanjiPre1Regex = Pattern.compile("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07\u5104\u5146\u4eac]+");
        numKanjiPre2Str = new String[5];
        numKanjiPre2Patterns = new Pattern[5];
        Filter.numKanjiPre2Str[4] = "(.+)\u4eac";
        Filter.numKanjiPre2Str[3] = "(.+)\u5146";
        Filter.numKanjiPre2Str[2] = "(.+)\u5104";
        Filter.numKanjiPre2Str[1] = "(.+)\u4e07";
        Filter.numKanjiPre2Str[0] = "(.+)";
        int i = 0;
        while (i < 5) {
            Filter.numKanjiPre2Patterns[i] = Pattern.compile(numKanjiPre2Str[i]);
            ++i;
        }
        numKanjiPre2Regex = Pattern.compile(String.valueOf(numKanjiPre2Str[4]) + "?" + numKanjiPre2Str[3] + "?" + numKanjiPre2Str[2] + "?" + numKanjiPre2Str[1] + "?" + numKanjiPre2Str[0]);
        numKanjiStr = new String[4];
        numKanjiPatterns = new Pattern[4];
        Filter.numKanjiStr[3] = "([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d]?)\u5343";
        Filter.numKanjiStr[2] = "([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d]?)\u767e";
        Filter.numKanjiStr[1] = "([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d]?)\u5341";
        Filter.numKanjiStr[0] = "([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d]?)";
        i = 0;
        while (i < 4) {
            Filter.numKanjiPatterns[i] = Pattern.compile(numKanjiStr[i]);
            ++i;
        }
        numKanjiSenRegex = Pattern.compile(String.valueOf(numKanjiStr[3]) + "?" + numKanjiStr[2] + "?" + numKanjiStr[1] + "?" + numKanjiStr[0] + "?");
        numKanjiOneRegex = Pattern.compile("[\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d]");
        numKanjiToNumRomanMatchEvaluator = new MatchEvaluator(){

            @Override
            public String eval(String in) {
                return Filter.matchNumKanjiToNumRoman(in);
            }
        };
    }

    private static String matchToWide(String m) {
        String wide = HankakuZenkaku.hanToZen(m);
        return wide;
    }

    private static String matchToNarrow(String m) {
        String half = HankakuZenkaku.zenToHan(m);
        return half;
    }

    public static String regexFilter(String str, Pattern include, Pattern exclude) {
        if (include != null && !include.matcher(str).matches()) {
            return null;
        }
        if (exclude != null && !exclude.matcher(str).matches()) {
            return null;
        }
        return str;
    }

    public static String toLower(String str) {
        if (str != null) {
            return str.toLowerCase();
        }
        return null;
    }

    public static String toUpper(String str) {
        if (str != null) {
            return str.toUpperCase();
        }
        return null;
    }

    public static String toTitleCase(String str) {
        if (str != null) {
            return str;
        }
        return null;
    }

    public static String toNarrow(String str) {
        if (str != null) {
            return HankakuZenkaku.zenToHan(str);
        }
        return null;
    }

    public static String toWide(String str) {
        if (str != null) {
            return HankakuZenkaku.hanToZen(str);
        }
        return null;
    }

    public static String halfKanaToWide(String str) {
        if (str != null) {
            return Filter.replace(str, halfKanaRegex, toWideMatchEvaluator);
        }
        return null;
    }

    public static String alphaDigitToNarrow(String str) {
        if (str != null) {
            return Filter.replace(str, alphaDigitRegex, toNarrowMatchEvaluator);
        }
        return null;
    }

    public static String alphaDigitToNarrowHalfKanaToWide(String str) {
        if (str != null) {
            String r = str;
            r = Filter.replace(r, alphaDigitRegex, toNarrowMatchEvaluator);
            r = Filter.replace(r, halfKanaRegex, toWideMatchEvaluator);
            return r;
        }
        return null;
    }

    private static String matchNumKanjiToNumRoman(String m) {
        return mapNumKanjiToNumRoman.get(m);
    }

    private static long numKanjiToNum(String str) {
        return Long.parseLong(Filter.replace(str, numKanjiOneRegex, numKanjiToNumRomanMatchEvaluator));
    }

    private static long kanjiNumSenToNum(String str) {
        Matcher numKanjiSenMatch = numKanjiSenRegex.matcher(str);
        if (numKanjiSenMatch.matches()) {
            String target = numKanjiSenMatch.group();
            long val = 0L;
            int i = 3;
            while (i >= 0) {
                System.out.println("target = " + target);
                Matcher ms = numKanjiPatterns[i].matcher(target);
                if (ms.find()) {
                    String v = ms.group(1);
                    System.out.println("- " + v);
                    if (v.equals("")) {
                        v = "\u4e00";
                    }
                    val = (long)((double)val + Math.pow(10.0, i) * (double)Long.parseLong(mapNumKanjiToNumRoman.get(v)));
                    target = target.substring(ms.end());
                }
                --i;
            }
            return val;
        }
        Matcher numUseKanjiMatch = numUseKanjiRegex.matcher(str);
        if (numUseKanjiMatch.matches()) {
            return Filter.numKanjiToNum(str);
        }
        return 0L;
    }

    public static String toNumerical(String str) {
        Matcher numKanjiPre2Match;
        String v;
        Matcher numMatch = numRegex.matcher(str);
        if (numMatch.matches()) {
            return String.valueOf(Double.parseDouble(Filter.toNarrow(numMatch.group())));
        }
        Matcher numUseKanjiMatch = numUseKanjiRegex.matcher(str);
        if (numUseKanjiMatch.find() && (v = numUseKanjiMatch.group()).length() >= 2) {
            String removeComma = v.replace(",", "").replace("\uff0c", "").replace("\u3001", "");
            return String.valueOf(Filter.numKanjiToNum(removeComma));
        }
        Matcher numKanjiPre1Match = numKanjiPre1Regex.matcher(str);
        if (numKanjiPre1Match.matches() && (numKanjiPre2Match = numKanjiPre2Regex.matcher(numKanjiPre1Match.group())).matches()) {
            String target = numKanjiPre2Match.group();
            long val = 0L;
            int i = 4;
            while (i >= 0) {
                System.out.println("target = " + target);
                Matcher ms = numKanjiPre2Patterns[i].matcher(target);
                if (ms.find()) {
                    String v2 = ms.group(1);
                    val = (long)((double)val + Math.pow(10.0, i * 4) * (double)Filter.kanjiNumSenToNum(v2));
                    target = target.substring(ms.end());
                }
                --i;
            }
            return String.valueOf(val);
        }
        return "0";
    }

    static String replace(String target, Pattern pattern, MatchEvaluator me) {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        Matcher m = pattern.matcher(target);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String str = target.substring(start, end);
            sb.append(target.substring(index, start));
            sb.append(me.eval(str));
            index = end;
        }
        sb.append(target.substring(index));
        return sb.toString();
    }
}

