/*
 * XmlTool.java
 *
 * Created on 2001/09/03, 14:26
 */

package jp.co.areaweb.tools.mail;
import java.util.Calendar;
import org.w3c.dom.*;

/**
 * XML 関連の共通クラス
 * @author kls040
 * @version 1.0
 */
public class XmlTool extends java.lang.Object {
    /**
     * <!ELEMENT entry (hiduke,user)>
     * <!ELEMENT change (hiduke,user)>
     * <!ELEMENT hiduke (#PCDATA)>
     * <!ELEMENT user (#PCDATA)><!ATTLIST user id CDATA #IMPLIED>
     */
    public static Element setEntryElement(Document document, String elementName, java.util.Date hiduke, int userid) {
        return setEntryElement(document, elementName, exchengeDate2TimeInstant(hiduke), userid, "user");
    }

    public static Element setEntryElement(Document document, String elementName, String hidukeStr, int userid, String elementName2) {
        Element element = document.createElement(elementName);
        element.appendChild(element);
        Element hidukeElement = document.createElement("hiduke");
        element.appendChild(hidukeElement);
        hidukeElement.appendChild(document.createTextNode(hidukeStr));
        Element userElement = document.createElement(elementName2);
        element.appendChild(userElement);
        Attr attribute = document.createAttribute("id");
        attribute.setValue(Integer.toString(userid));
        userElement.getAttributes().setNamedItem(attribute);
        return element;
    }

    public static String exchengeDate2TimeInstant(java.sql.Date souce) {
        return exchengeDate2TimeInstant((java.util.Date)souce);
    }
    public static String exchengeDate2TimeInstant(java.util.Date souce) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(souce);
        String CCYY = Integer.toString(calendar.get(Calendar.YEAR));
        String MM = twoNumber(calendar.get(Calendar.MONTH) + 1);
        String DD = twoNumber(calendar.get(Calendar.DAY_OF_MONTH));
        String hh = twoNumber(calendar.get(Calendar.HOUR));
        String mm = twoNumber(calendar.get(Calendar.MINUTE));
        String ss = twoNumber(calendar.get(Calendar.SECOND));
        return (CCYY +"-"+ MM +"-"+ DD +"T"+ hh +":"+ mm +":"+ ss +".000+09:00");
    }
    
    public static String exchengeDate2XMLDate(java.sql.Date souce) {
        return exchengeDate2TimeInstant((java.util.Date)souce);
    }
    public static String exchengeDate2XMLDate(java.util.Date souce) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(souce);
        String CCYY = Integer.toString(calendar.get(Calendar.YEAR));
        String MM = twoNumber(calendar.get(Calendar.MONTH) + 1);
        String DD = twoNumber(calendar.get(Calendar.DAY_OF_MONTH));
        return (CCYY +"-"+ MM +"-"+ DD);
    }
    
    public static String twoNumber(int number) {
        String result = "";
        int calc = number;
        for (int i=10; i >= 1; i /= 10) {
            int syou = calc / i;
            result += Integer.toString(syou);
            calc = calc % i;
        }
        return result;
    }

    public static String sevenNumber(int number) {
        String result = "";
        int calc = number;
        for (int i=1000000; i >= 1; i /= 10) {
            int syou = calc / i;
            result += Integer.toString(syou);
            calc = calc % i;
        }
        return result;
    }
}
