package jp.co.areaweb.tools.gui;
import java.awt.*;
import java.io.*;
import javax.swing.*;

/**
 *	「ReadXML」処理 
 */
@SuppressWarnings("serial")
public class ReadXMLDialog extends JDialog {
	public static final String TITLE = "ReadXML";
	
    // Used for addNotify check.
    boolean fComponentsAdjusted = false;
    
    //{{DECLARE_CONTROLS
    JFrame parentFrame; 	// Manager.class
    JPanel argsPanel;		// パラメータ設定パネル	(上部)
    ParameterPanel arg1Panel;		// parameter 1
    
    JPanel buttonPanel;     // ボタン配置パネル	(下部)
    JButton closeButton;      // [クローズ]ボタン
    JButton doButton;      // [実行]ボタン
    TextArea textArea;      // 実行結果を表示するJTextArea	(中央)
    //}}

    class SymAction implements java.awt.event.ActionListener {
        public void actionPerformed(java.awt.event.ActionEvent event) {
            Object object = event.getSource();
            if (object == closeButton) {
                closeButton_Action(event);
            }
            else if (object == doButton) {
                doButton_Action(event);
            }
        }
    }

    public ReadXMLDialog(JFrame parentFrame) {
        super(parentFrame, true);   // モーダルダイアログを基盤にする
        this.parentFrame = parentFrame;
                
        // INIT_CONTROLS
        Container container = getContentPane();
        container.setLayout(new BorderLayout());
        setVisible(false);
        setSize(getInsets().left + getInsets().right + 500,getInsets().top + getInsets().bottom + 480);
        setTitle(ReadXMLDialog.TITLE);
        setSize(500,480);
        
        // パラメータ設定パネル
        argsPanel = new JPanel();
        argsPanel.setLayout(new BoxLayout(argsPanel, BoxLayout.Y_AXIS));
        
        arg1Panel = new ParameterPanel("ファイル: ", "build.xml");
        argsPanel.add(arg1Panel);
        
        this.getContentPane().add("North", argsPanel);
        
        // コントロールパネル
        buttonPanel = new JPanel();

        doButton = new JButton("実行");
        doButton.setToolTipText("処理を実行します.");
        doButton.setEnabled(true);
        buttonPanel.add(doButton);

        closeButton = new JButton("閉じる");
        closeButton.setToolTipText("処理を終了します.");
        buttonPanel.add(closeButton);
        
        this.getContentPane().add("South", buttonPanel);
        
		// 説明文
        textArea = new TextArea();
        try {
            textArea.append("/**\n");
            textArea.append(" * "+ TITLE +"\n");
            textArea.append(" * 指定したファイルが整形式XML文書であるかどうかを調べる。\n");
            textArea.append(" * exp) java -cp hayashi.jar;xerces.jar jp.co.areaweb.tools.command.ReadXML build.xml\n");
            textArea.append(" */\n\n");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.getContentPane().add("Center", textArea);

        //{{REGISTER_LISTENERS
        SymAction lSymAction = new SymAction();
        closeButton.addActionListener(lSymAction);
        doButton.addActionListener(lSymAction);
        //}}
    }

    /**
    * Shows or hides the component depending on the boolean flag b.
    * @param b	trueのときコンポーネントを表示; その他のとき, componentを隠す.
    * @see java.awt.Component#isVisible
    */
    public void setVisible(boolean b) {
        if(b) {
            setLocation(80, 80);
        }
        super.setVisible(b);
    }

    public void addNotify()	{
        // Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();

        super.addNotify();

        if (fComponentsAdjusted)
            return;

        // Adjust components according to the insets
        setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
        Component components[] = getComponents();
        for (int i = 0; i < components.length; i++)	{
            Point p = components[i].getLocation();
            p.translate(getInsets().left, getInsets().top);
            components[i].setLocation(p);
        }
        fComponentsAdjusted = true;
    }

    /**
     * [実行]ボタンをクリックしたときの動作
     * @param event
     */
    void doButton_Action(java.awt.event.ActionEvent event) {
        doButton.setEnabled(false);
        
        PrintStream defOut = System.out;
        PrintStream defErr = System.err;

    	ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        try {
        	System.setOut(new PrintStream(stdout));
        	System.setErr(new PrintStream(stdout));

        	Command command = new Command(jp.co.areaweb.tools.command.ReadXML.class);
        	String[] args = new String[1];
        	args[0] = arg1Panel.getText();
        	command.setArgs(args);
        	command.start();		// コマンドを実行
        	while (command.isAlive()) {
        		Thread.sleep(1000);
                textArea.append(stdout.toString());
                stdout.reset();
        	}
        	textArea.append(stdout.toString());
        	JOptionPane.showMessageDialog(this, "'"+ TITLE +"'処理を完了しました。", "処理完了", JOptionPane.INFORMATION_MESSAGE);
        }
        catch(Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString(), "Exception", JOptionPane.ERROR_MESSAGE);
        }
        finally {
        	System.setOut(defOut);
        	System.setErr(defErr);
            doButton.setEnabled(true);
        }
    }

    void closeButton_Action(java.awt.event.ActionEvent event) {
        dispose();
    }
    
    void changeSQL_Action(java.awt.event.ActionEvent event) {
        textArea.setText("");
    }
}
