package hayashi.yuu.tools.properties;

import java.awt.event.ActionEvent;
import javax.swing.JComboBox;

@SuppressWarnings("serial")
public class PropertySelectItem extends PropertyItem {

	public PropertySelectItem(hayashi.yuu.tools.properties.Properties prop, String name, String title, boolean editable, String[] items) {
		super(prop, name, title, editable);
		field = new JComboBox();
		((JComboBox)field).addActionListener(this);
		for (int i=0; i < items.length; i++) {
			((JComboBox)field).addItem(items[i]);
		}
		createItem(name, title, prop.getProperty(name), editable);
	}

	void setupField(String name, String value, boolean editable) {
		this.value = value;
		((JComboBox)field).setSelectedItem(value);

		if (!editable) {
			field.setEnabled(editable);
		}
		add(field);
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		this.value = (String) ((JComboBox)this.field).getSelectedItem();
		logger.info("[反映] "+ propertyName +" = "+ this.value);
		prop.setProperty(propertyName, this.value);
	}
}
