package hayashi.kiban;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import java.io.*;

public class ConvCommPt {
	File inputFile;
	String admCodeStr = "";
	int iCounter = 0;

	/** メイン */
	public static void main(String[] argv)
	{
		File dir = new File(".");
		File[] files = dir.listFiles();
		int counter = 0;
		for (File iFile : files) {
			if (checkFile(iFile)) {
				counter++;
				ConvCommPt t = new ConvCommPt(iFile);
				t.runner();
			}
		}
		System.out.println("["+ counter +"]つのファイルを処理しました。");
	}

	public ConvCommPt (File iFile) {
		this.inputFile = iFile;
	}

	public void runner() {
		DocumentBuilderFactory factory;
		DocumentBuilder        builder;
		Node root;

		this.iCounter = 0;
		String iStr = this.inputFile.getName();
		String[] nameAry = iStr.split("-");
		String fileName = "";
		for (int i=0; i < nameAry.length; i++) {
			if (i != 0) {
				fileName = fileName + "-";
			}
			fileName = fileName + nameAry[i];
			if (i == 2) {
				this.admCodeStr = nameAry[2];
			}
		}

		File outputFile = new File(iStr.substring(0, iStr.length() - 4) +".gpx");
		BufferedWriter w = null;
		System.out.print(outputFile.getName() + " => ");

		try {
			w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputFile), "UTF-8"));
			w.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
			w.newLine();
			w.write("<gpx xmlns=\"http://www.topografix.com/GPX/1/1\" version=\"1.1\" creator=\"osmtracker-android\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd \">");
			w.newLine();

			factory = DocumentBuilderFactory.newInstance();
			builder = factory.newDocumentBuilder();
			factory.setIgnoringElementContentWhitespace(true);
			factory.setIgnoringComments(true);
			factory.setValidating(true);
			root    = builder.parse(inputFile.getName());

			showNodes(w, root, "");

			w.write("</gpx>");
			w.newLine();
		} catch (ParserConfigurationException e0) {
			System.out.println(e0.getMessage());
		} catch (SAXException e1){
			System.out.println(e1.getMessage());
		} catch (IOException e2) {
			System.out.println(e2.getMessage());
		}
		finally {
			System.out.println("地名数["+ iCounter +"]");
			if (w != null) {
				try {
					w.close();
				}
				catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public void showNodes(BufferedWriter w, Node node, String space) throws IOException {
		NodeList nodes = node.getChildNodes();
		for (int i=0; i<nodes.getLength(); i++) {
			Node node2 = nodes.item(i);
			if (node2.getNodeName().equals("CommPt")) {
				showCommPt(w, node2);
			}
			else {
				showNodes(w, node2, space + "    ");
			}
		}
	}

	public void showCommPt(BufferedWriter w, Node node) throws IOException {
		String positionStr = "";
		String typeStr = "";
		String nameStr = "";
		String latStr = "";
		String lonStr = "";
		String dateStr = "";
		String idStr = "";

		NodeList nodes = node.getChildNodes();
		NamedNodeMap nodeMap = node.getAttributes();
		if ( null != nodeMap ) {
			for ( int j=0; j<nodeMap.getLength(); j++ ) {
				if (nodeMap.item(j).getNodeName().equals("id")) {
					idStr = nodeMap.item(j).getNodeValue();
				}
				else if (nodeMap.item(j).getNodeName().equals("gml:id")) {
					idStr = nodeMap.item(j).getNodeValue();
				}
			}
		}
		for (int i=0; i < nodes.getLength(); i++) {
			Node node2 = nodes.item(i);
			if (node2.getNodeName().equals("pos")) {
				NodeList nodes3 = node2.getChildNodes();
				for (int j=0; j < nodes3.getLength(); j++) {
					Node node3 = nodes3.item(j);
					if (node3.getNodeName().equals("jps:position")) {
						NodeList nodes4 = node3.getChildNodes();
						for (int k=0; k < nodes4.getLength(); k++) {
							Node node4 = nodes4.item(k);
							if (node4.getNodeName().equals("jps:coordinate")) {
								positionStr = node4.getTextContent();
								String[] str4Ary = positionStr.split(" ");
								latStr = str4Ary[0];
								lonStr = str4Ary[1];
							}
						}
					}
					else if (node3.getNodeName().equals("gml:Point")) {
						NodeList nodes4 = node3.getChildNodes();
						for (int k=0; k < nodes4.getLength(); k++) {
							Node node4 = nodes4.item(k);
							if (node4.getNodeName().equals("gml:pos")) {
								positionStr = node4.getTextContent();
								String[] str4Ary = positionStr.split(" ");
								latStr = str4Ary[0];
								lonStr = str4Ary[1];
							}
						}
					}
				}
			}
			else if (node2.getNodeName().equals("devDate")) {
				NodeList nodes3 = node2.getChildNodes();
				for (int j=0; j < nodes3.getLength(); j++) {
					Node node3 = nodes3.item(j);
					if (node3.getNodeName().equals("jps:position")) {
						NodeList nodes4 = node3.getChildNodes();
						for (int k=0; k < nodes4.getLength(); k++) {
							Node node4 = nodes4.item(k);
							if (node4.getNodeName().equals("jps:date8601")) {
								dateStr = node4.getTextContent();
							}
						}
					}
					else if (node3.getNodeName().equals("gml:timePosition")) {
						dateStr = node3.getTextContent();
					}
				}
			}
			else if (node2.getNodeName().equals("type")) {
				typeStr = node2.getTextContent();

			}
			else if (node2.getNodeName().equals("name")) {
				nameStr = node2.getTextContent();
			}
		}

		String oName = "FG-JPS-"+ admCodeStr +"-CommPt-"+ idStr +".txt";
		this.iCounter++;
		File o2File = new File(oName);
		BufferedWriter w2 = null;
		try {
			w2 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(o2File), "UTF-8"));
			w2.write("name="+ nameStr +"");
			w2.newLine();
			w2.write("place="+ (typeStr.equals("大字・町・丁目") ? "hamlet" : typeStr));
			w2.newLine();
			w2.write("source=GSI/KIBAN Block http://wiki.osm.org/wiki/GSI_KIBAN");
			w2.newLine();
		}
		finally {
			if (w2 != null) {
				try {
					w2.close();
				}
				catch (IOException e) {
					e.printStackTrace();
				}
			}
		}


		//System.out.println(admCodeStr +","+ typeStr +","+ nameStr +","+ latStr +","+ lonStr +","+ dateStr);
		w.write("<wpt lat=\""+ latStr +"\" lon=\""+ lonStr +"\">");
		w.newLine();
		w.write(" <time>"+ dateStr +"T00:00:00Z</time>");
		w.newLine();
		w.write(" <name><![CDATA["+ nameStr +"]]></name>");
		w.newLine();

		w.write(" <link href=\""+ oName +"\"><text>name＝"+ nameStr +"</text></link>");
		w.newLine();

		w.write("</wpt>");
		w.newLine();

	}

	static boolean checkFile(File f) {
		String name = f.getName();
		if (!name.startsWith("FG-")) {
			return false;
		}
		if (!name.toUpperCase().endsWith(".XML")) {
			return false;
		}
		if (name.toUpperCase().indexOf("-COMMPT-") < 0) {
			return false;
		}
		return true;
	}


}