package jp.co.areaweb.tools.gui;
import java.awt.*;
import java.awt.event.*;

@SuppressWarnings("serial")
public class QuitDialog extends Dialog
{
    // Used for addNotify check.
    boolean fComponentsAdjusted = false;

    //{{DECLARE_CONTROLS
    java.awt.Button yesButton;
    java.awt.Button noButton;
    java.awt.Label label1;
    //}}

    class SymWindow extends java.awt.event.WindowAdapter
    {
        public void windowClosing(java.awt.event.WindowEvent event)
        {
            Object object = event.getSource();
            if (object == QuitDialog.this)
                QuitDialog_WindowClosing(event);
        }
    }

    class SymAction implements java.awt.event.ActionListener
    {
        public void actionPerformed(java.awt.event.ActionEvent event)
        {
            Object object = event.getSource();
            if (object == noButton)
                noButton_Clicked(event);
            else if (object == yesButton)
                yesButton_Clicked(event);
        }
    }

	public QuitDialog(Frame parent, boolean modal)
	{
		super(parent, modal);

		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		//{{INIT_CONTROLS
		setLayout(null);
		setSize(getInsets().left + getInsets().right + 337,getInsets().top + getInsets().bottom + 135);
		yesButton = new java.awt.Button(" Yes ");
		yesButton.setBounds(getInsets().left + 72,getInsets().top + 80,79,22);
		yesButton.setFont(new Font("Dialog", Font.BOLD, 12));
		add(yesButton);
		noButton = new java.awt.Button("  No  ");
		noButton.setBounds(getInsets().left + 185,getInsets().top + 80,79,22);
		noButton.setFont(new Font("Dialog", Font.BOLD, 12));
		add(noButton);
		label1 = new java.awt.Label("Do you really want to quit?",Label.CENTER);
		label1.setBounds(78,33,180,23);
		add(label1);
		setTitle("DbMang - Quit");
		setResizable(false);
		//}}

		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		noButton.addActionListener(lSymAction);
		yesButton.addActionListener(lSymAction);
		//}}
	}

    public void addNotify()
    {
        // Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();

		super.addNotify();

		if (fComponentsAdjusted)
		    return;

   		// Adjust components according to the insets
   		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
   		Component components[] = getComponents();
   		for (int i = 0; i < components.length; i++)
   		{
   		    Point p = components[i].getLocation();
   		    p.translate(getInsets().left, getInsets().top);
   		    components[i].setLocation(p);
   		}
   		fComponentsAdjusted = true;
    }

    public QuitDialog(Frame parent, String title, boolean modal)
    {
        this(parent, modal);
        setTitle(title);
    }

    /**
    * Shows or hides the component depending on the boolean flag b.
    * @param b  if true, show the component; otherwise, hide the component.
    * @see java.awt.Component#isVisible
    */
    public void setVisible(boolean b)
    {
        if(b)
        {
            Rectangle bounds = getParent().getBounds();
            Rectangle abounds = getBounds();

            setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
            bounds.y + (bounds.height - abounds.height)/2);
        }
        super.setVisible(b);
    }

    void QuitDialog_WindowClosing(java.awt.event.WindowEvent event)
    {
        dispose();
    }

    void yesButton_Clicked(java.awt.event.ActionEvent event)
    {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((java.awt.Window)getParent(), WindowEvent.WINDOW_CLOSING));
    }

    void noButton_Clicked(java.awt.event.ActionEvent event)
    {
        dispose();
    }
}
