/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;

public class DataFileCacheSession
extends DataFileCache {
    public DataFileCacheSession(Database database, String string) {
        super(database, string);
    }

    @Override
    protected void initParams(Database database, String string) {
        this.dataFileName = string + ".data.tmp";
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        this.cachedRowPadding = this.cacheFileScale = 64;
        this.initialFreePos = this.cacheFileScale;
        this.maxCacheRows = 2048;
        this.maxCacheBytes = this.maxCacheRows * 1024;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.cacheFileScale;
        this.dataFile = null;
    }

    @Override
    public void open(boolean bl) {
        try {
            this.dataFile = new ScaledRAFile(this.database, this.dataFileName, false, false);
            this.fileFreePosition = this.initialFreePos;
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0, 0L);
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent("Failed to open Session RA file", throwable);
            this.close(false);
            throw Error.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    @Override
    public void close(boolean bl) {
        this.writeLock.lock();
        try {
            this.cache.clear();
            if (this.dataFile != null) {
                this.dataFile.close();
                this.dataFile = null;
                this.fa.removeElement(this.dataFileName);
            }
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent("Failed to close Session RA file", throwable);
            throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

