/* 
 * The MIT License
 *
 * Copyright (c) 2014 Yuki SAKAI
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/*******************************************************************************
 * include ********************************************************************/
#if !defined(BMP_H__)
#  include <bmp.h>
#endif
#if !defined(_SYS_TYPES_H) && !defined(_SYS_TYPES_H_)
#  include <sys/types.h>
#endif
#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
#if !defined(_SYS_ENDIAN_H) && !defined(_SYS_ENDIAN_H_)
#  include <sys/endian.h>
#endif
#else
#if !defined(_ENDIAN_H) && !defined(_ENDIAN_H_)
#  include <endian.h>
#endif
#endif

/*+==========================================================================+**
 *: check BMP messages type check
 *: arg:
 *:    version : bmp Version
 *:    msgType : bmp Message type code
 *: return:
 *:    1: O.K.
 *:    0: Bad
 *+==========================================================================+*/
int bmpMessageTypeCheck (const u_int8_t version, const u_int8_t msgType)
{
  switch (msgType) {
  case BMP_MSGTYPE_ROUTEMON:
  case BMP_MSGTYPE_STATISTICS:
  case BMP_MSGTYPE_PEERDOWN:
    return 1;
    break;
  case BMP_MSGTYPE_PEERUP:
    if (version==BMP_VERSION_V2 ||
	version==BMP_VERSION_V3) {return 1;}
    break;
  case BMP_MSGTYPE_INIT:
  case BMP_MSGTYPE_TERMINATE:
    if (version==BMP_VERSION_V3) {return 1;}
    break;
  default:
    break;
  }
  return 0;
}

/*+==========================================================================+**
 *: check BMP peer type check
 *: arg:
 *:    version : bmp Version
 *:    peerType: bmp Peer type code
 *: return:
 *:    1: O.K.
 *:    0: Bad
 *+==========================================================================+*/
int bmpPeerTypeCheck (const u_int8_t version, const u_int8_t peerType)
{
  switch (peerType) {
  case BMP_PEERTYPE_GLOBAL:
  case BMP_PEERTYPE_L3VPN:
    return 1;
    break;
  default:
    break;
  }
  return 0;
}

