/* 
 * The MIT License
 *
 * Copyright (c) 2014 Yuki SAKAI
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */
#if !defined(BMP_H__)
#define BMP_H__ 1

/*******************************************************************************
 * include ********************************************************************/
#if !defined(_SYS_TYPES_H) && !defined(_SYS_TYPES_H_)
#  include <sys/types.h>
#endif
#if !defined(_SYS_TIME_H) && !defined(_SYS_TIME_H_)
#  include <sys/time.h>
#endif

/*******************************************************************************
 * Define *********************************************************************/
/*=Parameter==================================================================*/
#define LIBBMP_MAXHEADERLEN     100     /* 2 * (Header(6B)+PerPeerHeader(42B)+Buffer(2B)) */
/*+==========================================================================+**
 *| BMP Messeages Info                                                       |**
 *+==========================================================================+*/
#define BMP_VERSION_V1          1
#define BMP_VERSION_V2          2
#define BMP_VERSION_V3          3
/*=Messages type==============================================================*/
#define BMP_MSGTYPE_ROUTEMON    0
#define BMP_MSGTYPE_STATISTICS  1
#define BMP_MSGTYPE_PEERDOWN    2
#define BMP_MSGTYPE_PEERUP      3
#define BMP_MSGTYPE_INIT        4
#define BMP_MSGTYPE_TERMINATE   5
/*=Peer Type==================================================================*/
#define BMP_PEERTYPE_GLOBAL     0
#define BMP_PEERTYPE_L3VPN      1
/*=Peer Flags=================================================================*/
#define BMP_PEERFLG_VFLG_GET    0x80
#define BMP_PEERFLG_VFLG_IPv6   0x80
#define BMP_PEERFLG_VFLG_IPv4   0x00
#define BMP_PEERFLG_LFLG_GET    0x40
/* old */
#define BMPPEERFLG_VFLG_GET     0x80
#define BMPPEERFLG_LFLG_GET     0x40
/*=Initiation=================================================================*/
#define BMP_INITMSG_STRING      0
#define BMP_INITMSG_SYSDESCR    1
#define BMP_INITMSG_SYSNAME     2
/* old */
#define BMPINITMSG_STRING       0
#define BMPINITMSG_SYSDESCR     1
#define BMPINITMSG_SYSNAME      2
/*=Termination================================================================*/
#define BMP_TERMMSG_STRING      0
#define BMP_TERMMSG_REASON      1
#define BMP_TERM_REASON_ADMIN_CLOSE     0
#define BMP_TERM_REASON_UNSPECIFIED     1
#define BMP_TERM_REASON_OUT_OF_RESOURCE 2
#define BMP_TERM_REASON_REDUNDANT	3
/* old */
#define BMPTERMMSG_STRING       0
#define BMPTERMMSG_REASON       1
/*=Statistics=================================================================*/
#define BMP_STATS_TYPE_REJECT_BY_INBOUND_POLICY         0x00   /* Number of prefixes rejected by inbound policy. */
#define BMP_STATS_TYPE_DUPLICATE_ADVERTISEMENTS         0x01   /* Number of (known) duplicate prefix. */
#define BMP_STATS_TYPE_DUPLICATE_WITHDRAWS              0x02   /* Number of (known) duplicate withdraws. */
#define BMP_STATS_TYPE_UPDATES_INVALIDATED_CLUSTER      0x03   /* Number of updates invalidated due to CLUSTER_LIST loop. */
#define BMP_STATS_TYPE_UPDATES_INVALIDATED_AS_PATH      0x04   /* Number of updates invalidated due to AS_PATH loop. */
#define BMP_STATS_TYPE_UPDATES_INVALIDATED_ORIGIN       0x05   /* Number of updates invalidated due to ORIGINATOR_ID. */
#define BMP_STATS_TYPE_UPDATES_INVALIDATED_AS_CONF      0x06   /* Number of updates invalidated due to AS_CONFED loop. */
#define BMP_STATS_TYPE_ROUTES_ADJ_RIBs_IN               0x07   /* Number of routes in Adj-RIBs-In. */
#define BMP_STATS_TYPE_ROUTES_LOC_RIB                   0x08   /* Number of routes in Loc-RIB. */
/* old */
#define BMPSTATSTYPE_REJECT_BY_INBOUND_POLICY    0x00   /* Number of prefixes rejected by inbound policy. */
#define BMPSTATSTYPE_DUPLICATE_ADVERTISEMENTS    0x01   /* Number of (known) duplicate prefix. */
#define BMPSTATSTYPE_DUPLICATE_WITHDRAWS         0x02   /* Number of (known) duplicate withdraws. */
#define BMPSTATSTYPE_UPDATES_INVALIDATED_CLUSTER 0x03   /* Number of updates invalidated due to CLUSTER_LIST loop. */
#define BMPSTATSTYPE_UPDATES_INVALIDATED_AS_PATH 0x04   /* Number of updates invalidated due to AS_PATH loop. */
#define BMPSTATSTYPE_UPDATES_INVALIDATED_ORIGIN  0x05   /* Number of updates invalidated due to ORIGINATOR_ID. */
#define BMPSTATSTYPE_UPDATES_INVALIDATED_AS_CONF 0x06   /* Number of updates invalidated due to AS_CONFED loop. */
#define BMPSTATSTYPE_ROUTES_ADJ_RIBs_IN          0x07   /* Number of routes in Adj-RIBs-In. */
#define BMPSTATSTYPE_ROUTES_LOC_RIB              0x08   /* Number of routes in Loc-RIB. */
/*=Peer Down==================================================================*/
#define BMP_PEER_DOWN_LOCAL_NOTIFICATION         1
#define BMP_PEER_DOWN_LOCAL_NO_NOTIFICATION      2
#define BMP_PEER_DOWN_REMOTE_NOTIFICATION        3
#define BMP_PEER_DOWN_REMOTE_NO_NOTIFICATION     4
/* old */
#define BMPPEERDOWN_LOCALCLOSE  1
#define BMPPEERDOWN_



/*******************************************************************************
 * Macro **********************************************************************/

/*******************************************************************************
 * structure & typedef ********************************************************/
/*+==========================================================================+**
 *| BMP Messages Header                                                      |**
 *+==========================================================================+*/
/* Version: 1,2 (Header)
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Version       | msg type      | peer type     | peer flags    |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Peer Distinguisher (8 Byte)                                   |
 * |                                                               |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Peer Address (16 Byte)                                        |
 * |                                                               |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Peer AS                                                       |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Peer BGP ID                                                   |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Timestamp (seconds)                                           |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Timestamp (microseconds)                                      |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | messages(variables: Routemon, statistics, peer down, peer up) |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef struct {
  u_int8_t  version;
  u_int8_t  msgType;
  u_int8_t  peerType;
  u_int8_t  peerFlags;
  u_int32_t peerDist[2];
  u_int32_t peerAddr[4];
  u_int32_t peerAS;
  u_int32_t peerBgpID;
  /* which user "struct timeval"? "u_int32_t"? */
  u_int32_t tv_sec;
  u_int32_t tv_usec;
} __attribute__((__packed__)) BMPv1Header;
#define BMPV1MSGTYPE_ROUTEMON   0
#define BMPV1MSGTYPE_STATISTICS 1
#define BMPV1MSGTYPE_PEERDOWN   2
#define BMPV1MSGTYPE_PEERUP     3
#define BMPV1PEERTYPE_GLOBAL    0
#define BMPV1PEERTYPE_L3VPN     1
#define BMPV1PEERFLG_VFLG_IPv6  0x80
#define BMPV1PEERFLG_VFLG_IPv4  0x00

/* Version: 3 (Header)
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+
 * | Version       |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | msg length                                                    |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | msg type      |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Initiation, Termination, PerPeerHeader(variables)             |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
/* Version: 3 */
typedef struct {
  u_int8_t      version;
  u_int32_t     msgLen;
  u_int8_t      msgType;
} __attribute__((__packed__)) BMPv3Header;
#define BMPV3MSGTYPE_ROUTEMON   0
#define BMPV3MSGTYPE_STATISTICS 1
#define BMPV3MSGTYPE_PEERDOWN   2
#define BMPV3MSGTYPE_PEERUP     3
#define BMPV3MSGTYPE_INIT       4
#define BMPV3MSGTYPE_TERMINATE  5

/* Version: 3 (Per Peer Header)
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | peer type     | peer flags    |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Peer Distinguisher (8 Byte)                                   |
 * |                                                               |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Peer Address (16 Byte)                                        |
 * |                                                               |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Peer AS                                                       |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Peer BGP ID                                                   |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Timestamp (seconds)                                           |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Timestamp (microseconds)                                      |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | messages(variables: Routemon, statistics, peer down, peer up) |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef struct {
  u_int8_t      peerType;
  u_int8_t      peerFlags;
  u_int32_t     peerDist[2];
  u_int32_t     peerAddr[4];
  u_int32_t     peerAS;
  u_int32_t     peerBgpID;
  /* which user "struct timeval"? "u_int32_t"? */
  u_int32_t     tv_sec;
  u_int32_t     tv_usec;
} __attribute__((__packed__)) BMPv3PerPeerHeader;
#define BMPV3PEERTYPE_GLOBAL    0
#define BMPV3PEERTYPE_L3VPN     1
#define BMPV3PEERFLG_VFLG_IPv6  0x80
#define BMPV3PEERFLG_VFLG_IPv4  0x00


/*+==========================================================================+**
 *| BMP Messages                                                             |**
 *+==========================================================================+*/
/*=Initiation Message=========================================================**
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Information type              | Information length            |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Information (variables)                                       |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef struct {
  u_int16_t infoType;
  u_int16_t infoLen;
} __attribute__((__packed__))  BMPMsgInit;

/*=Termination Message========================================================**
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Information type              | Information length            |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Information (variables)                                       |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef struct {
  u_int16_t infoType;
  u_int16_t infoLen;
} __attribute__((__packed__))  BMPMsgTerminate;

/*=Statistics Reports=========================================================**
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | number of Statistics item                                     |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | statistics messages(variables)                                |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Statistics type               | Statistics length             |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | statistics data(variables)                                    |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef u_int32_t BMPMsgStatsNum;
typedef struct {
  u_int16_t statType;
  u_int16_t statLen;
} __attribute__((__packed__)) BMPMsgStatsHeader;
typedef union {
  u_int32_t count32;
  u_int64_t count64;
} BMPMsgStatsData;

/*=Peer Down Notification=====================================================**
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+
 * | reason        |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | statistics messages(variables)                                |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef struct {
  u_int8_t      reason;
} __attribute__((__packed__))  BMPMsgPeerDown;

/*=Peer Up Notification=======================================================**
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Local Address (16 Byte)                                       |
 * |                                                               |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Local Port                    | Remote Port                   |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Send OPEN Messages(variables)                                 |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Received OPEN Messages(variables)                             |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *
 * version 2's peer up message is BGP Open messages
 ******************************************************************************/
typedef struct {
  u_int32_t     localAddr[4];
  u_int16_t     localPort;
  u_int16_t     peerPort;
} __attribute__((__packed__))  BMPMsgPeerUp;

/*******************************************************************************
 * functions ******************************************************************/
/*=bmpSizeCheck===============================================================*/
ssize_t bmpMessageSizeCheck (u_int8_t *, const ssize_t);
ssize_t bmpPeerDownSize     (u_int8_t *, const ssize_t);
ssize_t bmpPeerUpSize       (u_int8_t *, const ssize_t, const u_int8_t);
ssize_t bmpStatisticsSize   (u_int8_t *, const ssize_t);
ssize_t bmpRouteMonSize     (u_int8_t *, const ssize_t);
/*=bmpDataCheck===============================================================*/
int bmpMessageTypeCheck (const u_int8_t, const u_int8_t);
int bmpPeerTypeCheck    (const u_int8_t, const u_int8_t);

#endif



