/*
 * The MIT License
 *
 * Copyright (c) 2014 Yuki SAKAI
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */
#if !defined(BGP_H__)
#define BGP_H__ 1

/*******************************************************************************
 * include ********************************************************************/
#if !defined(_SYS_TYPES_H) && !defined(_SYS_TYPES_H_)
#  include <sys/types.h>
#endif
#if !defined(_SYS_TIME_H) && !defined(_SYS_TIME_H_)
#  include <sys/time.h>
#endif

/*******************************************************************************
 * Define *********************************************************************/
#define LIBBGP_MAXLENGTH        4096
#define LIBBGP_MAXMSGLEN        4096
/*+==========================================================================+**
 *| BGP Messeages Info                                                       |**
 *+==========================================================================+*/
/*=Messages type==============================================================*/
#define BGP_MSGTYPE_OPEN         1
#define BGP_MSGTYPE_UPDATE       2
#define BGP_MSGTYPE_NOTIFICATION 3
#define BGP_MSGTYPE_KEEPALIVE    4
/* OLD */
#define BGPMSGTYPE_OPEN         1
#define BGPMSGTYPE_UPDATE       2
#define BGPMSGTYPE_NOTIFICATION 3
#define BGPMSGTYPE_KEEPALIVE    4
/*=BGP Update path attribute flag=============================================*/
#define BGP_UPDATE_PATHATTR_FLG_OPTIONAL        0x80
#define BGP_UPDATE_PATHATTR_FLG_TRANSITIVE      0x40
#define BGP_UPDATE_PATHATTR_FLG_PARTIAL         0x20
/* extend flag is 0, next(3rd) octet is length.
 * extend flag is 1, 3rd and 4th octet is length
 */
#define BGP_UPDATE_PATHATTR_FLG_EXTEND_LENGTH   0x10
/*=BGP Update path attribute==================================================*/
#define BGP_UPDATE_PATHATTR_TYPE_ORIGIN         1
#define BGP_UPDATE_PATHATTR_TYPE_AS_PATH        2
#define BGP_UPDATE_PATHATTR_TYPE_NEXT_HOP       3
#define BGP_UPDATE_PATHATTR_TYPE_MED            4
#define BGP_UPDATE_PATHATTR_TYPE_LOCAL_PREF     5
#define BGP_UPDATE_PATHATTR_TYPE_ATOMIC_AGG     6
#define BGP_UPDATE_PATHATTR_TYPE_AGGREGATOR     7
#define BGP_UPDATE_PATHATTR_TYPE_COMMUNITY      8
#define BGP_UPDATE_PATHATTR_TYPE_ORIGINATOR     9
#define BGP_UPDATE_PATHATTR_TYPE_CLUSTER_LIST   10


/*******************************************************************************
 * Macro **********************************************************************/

/*******************************************************************************
 * structure & typedef ********************************************************/
/*+==========================================================================+**
 *| BGP Messages Header                                                      |**
 *+==========================================================================+*/
/* BGP header common
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Marker (16 byte)                                              |
 * |                                                               |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Length                        | msg Type      |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef struct {
  u_int32_t     Maker[4];
  u_int16_t     length;
  u_int8_t      type;
} __attribute__((__packed__)) BGPCommonHeader;

/* Open Messages
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+
 * | Version       |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | MY AS(sender)                 |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Hold Time                     |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | BGP Identifier                                                |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | OPt Parm Len  |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | OPtional parameter (variable)                                 |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef struct {
  u_int8_t version;
  u_int16_t asn;
  u_int16_t holdtime;
  u_int32_t BGPid;
  u_int8_t  optLen;
} __attribute__((__packed__)) BGPOpenMessage;


/* BGP Update Messages
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Withdrawn Routes Length       | Withdrawn Routes (variable)   |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Total path attribute length   | path attribute (variable)     |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | NLRI (variable)                                               |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef u_int16_t BGPUpdateLength; /* for withdrawn routes or total path attribute length */
/* BGP update path attributes
 *  0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
 *  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * | Attr. flags   | Attr Type     | length(1 or 2 Byte)           |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ******************************************************************************/
typedef struct {
  u_int8_t attrFlag;
  u_int8_t attrType;
} __attribute__((__packed__)) BGPUpdatePathAttr;

#if 0
typedef u_int8_t  BGPUpdatePathAttr_Origin_Unit;
typedef u_int8_t  BGPUpdatePathAttr_AsPath_Type;
typedef u_int16_t BGPUpdatePathAttr_AsPath_Unit;

#define BGP_UPDATE_PATHATTR_TYPE_ORIGIN         1
#define BGP_UPDATE_PATHATTR_TYPE_AS_PATH        2
#define BGP_UPDATE_PATHATTR_TYPE_NEXT_HOP       3
#define BGP_UPDATE_PATHATTR_TYPE_MED            4
#define BGP_UPDATE_PATHATTR_TYPE_LOCAL_PREF     5
#define BGP_UPDATE_PATHATTR_TYPE_ATOMIC_AGG     6
#define BGP_UPDATE_PATHATTR_TYPE_AGGREGATOR     7
#define BGP_UPDATE_PATHATTR_TYPE_COMMUNITY      8
#define BGP_UPDATE_PATHATTR_TYPE_ORIGINATOR     9
#define BGP_UPDATE_PATHATTR_TYPE_CLUSTER_LIST   10
#endif

#endif
