/* -*- c -*- */
/*-
 * The MIT License
 *
 * Copyright (c) 2014 Yuki SAKAI
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/*******************************************************************************
 * include ********************************************************************/
#if !defined(SELFLIB_H__)
#  include <selfLib.h>
#endif
#if !defined(_STRING_H) && !defined(_STRING_H_)
#  include <string.h>
#endif
#if defined(__NetBSD__) ||  defined(__OpenBSD__)
#if !defined(_TIME_H) && !defined(_TIME_H_)
#  include <time.h>
#endif
#elif defined(__linux__)
#if !defined(_SYS_TIME_H) && !defined(_SYS_TIME_H_)
#  include <sys/time.h>
#endif
#endif

/*******************************************************************************
 * Transration from double to timeval *****************************************/
struct timeval d2tval (double td)
{
  struct timeval tv;
  (void) memset ((char *)&tv, 0, sizeof (struct timeval));
  tv.tv_sec  = (long)td;
  tv.tv_usec = (long)((td-(double)tv.tv_sec)*1e6);
  return tv;
}
