/* -*- c -*- */
/*
 * The MIT License
 *
 * Copyright (c) 2014 Yuki SAKAI
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/*******************************************************************************
 * Include ********************************************************************/
#if !defined(SELFLIB_H__)
#  include <selfLib.h>
#endif
#if !defined(_SYS_TYPES_H_) && !defined(_SYS_TYPES_H)
#  include <sys/types.h>
#endif
#if !defined(_PWD_H)    && !defined(_PWD_H_)
#  include <pwd.h>
#endif
#if !defined(_STRING_H) && !defined(_STRING_H_)
#  include <string.h>
#endif

/*******************************************************************************
 * Get Homedir From UID *******************************************************/
int GetHomeDir (uid_t uid, char *buf, ssize_t blen)
{
  struct passwd *pwd;
  if ((pwd=getpwuid (uid))==(void *)0) {endpwent (); return -1;}
  strncpy (buf, pwd->pw_dir, (blen-1));
  endpwent ();
  return 1;
}
