/* -*- c -*- */
/* 
 * The MIT License
 *
 * Copyright (c) 2014 Yuki SAKAI
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/*******************************************************************************
 * include ********************************************************************/
#if !defined(SELFLIB_H__)
#  include <selfLib.h>
#endif
#if !defined(_SYS_SOCKET_H) && !defined(_SYS_SOCKET_H_)
#  include <sys/socket.h>
#endif
#if !defined(_SYS_TYPES_H) && !defined(_SYS_TYPES_H_)
#  include <sys/types.h>
#endif
#if !defined(_STRING_H) && !defined(_STRING_H_)
#  include <string.h>
#endif
#if !defined(_NETDB_H) && !defined(_NETDB_H_)
#  include <netdb.h>
#endif
#if !defined(_UNISTD_H) && !defined(_UNISTD_H_)
#  include <unistd.h>
#endif
#if !defined(_ARPA_INET_H_) &&  !defined(_ARPA_INET_H)
#  include <arpa/inet.h>
#endif
#if !defined(_NETINET_IN_H) && !defined(_NETINET_IN_H_)
#  include <netinet/in.h>
#endif


/*******************************************************************************
 * Listen socket functions (for IPv4 and IPv6 on TCP and UDP) *****************/
int lsocket (const char *hostname, const char *port, int stype, int accept)
{
  struct addrinfo soc_info, *psinfo;
  int  soc = -1, ret = -1;
  long on  = 1;

  /*****************************************************************************
   * Init Information *********************************************************/
  (void) memset ((char *)&soc_info, 0, sizeof (struct addrinfo));
  if      (hostname==(void *)0)  {soc_info.ai_flags = AI_PASSIVE;}
  else if (strlen (hostname)<=0) {hostname = (void *)0; soc_info.ai_flags = AI_PASSIVE;}
  soc_info.ai_family   = AF_UNSPEC;
  soc_info.ai_socktype = stype;
  /*=Socket Setup=============================================================*/
  if      (getaddrinfo (hostname, port, &soc_info, &psinfo)!=0)                          {ret = -1; goto err_ret;  }
  else if ((soc=socket (psinfo->ai_family, psinfo->ai_socktype, psinfo->ai_protocol))<0) {ret = -2; goto err_ret;  }
  else if (bind (soc, psinfo->ai_addr, psinfo->ai_addrlen)<0)                            {ret = -3; goto err_close;}
  else if (stype==SOCK_DGRAM)                                                            {goto true_fin;}
  else if (listen (soc, accept)<0)                                                       {ret = -4; goto err_close;}
 true_fin:
  setsockopt(soc, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
  freeaddrinfo (psinfo);
  return soc;

  /*=Error Process============================================================*/
 err_close:
  close (soc);
 err_ret:
  freeaddrinfo (psinfo);
  return ret;
}

/*******************************************************************************
 * Get Remote Host address ****************************************************/
int getRemoteHost (const int soc, char *pstr, const int size)
{
  struct sockaddr_storage hostAddr;
  socklen_t               namelen;
  struct sockaddr_in      *ppF;
  struct sockaddr_in6     *ppS;
  (void) memset (pstr     , 0, size);
  (void) memset (&hostAddr, 0, sizeof (struct sockaddr_storage));
  /*=Get IP address ==========================================================*/
  namelen = sizeof (struct sockaddr_storage);
  if (getpeername (soc, (struct sockaddr *)&hostAddr, &namelen)<0) {return 0;}
  if (hostAddr.ss_family == AF_INET) {
    ppF = (struct sockaddr_in *)&hostAddr;
    inet_ntop (AF_INET, &ppF->sin_addr, pstr, size);
  }
  else if (hostAddr.ss_family == AF_INET6) {
    ppS = (struct sockaddr_in6 *)&hostAddr;
    inet_ntop (AF_INET6, &ppS->sin6_addr, pstr, size);
  }
  else {return 0;}

  return 1;
}
