/* -*- c -*- */
/*-
 * The MIT License
 *
 * Copyright (c) 2014 Yuki SAKAI
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */
/*******************************************************************************
 * include ********************************************************************/

/*******************************************************************************
 * Personal system library
 ******************************************************************************/
#ifndef SELFLIB_H__
#define SELFLIB_H__ __DATE__
/*******************************************************************************
 * Include ********************************************************************/
#if !defined(_SYS_TYPES_H_) && !defined(_SYS_TYPES_H)
#  include <sys/types.h>
#endif
#if !defined(_SYS_STAT_H) && !defined(_SYS_STAT_H_)
#  include <sys/stat.h>
#endif
#if !defined(_NETDB_H) && !defined(_NETDB_H_)
#  include <netdb.h>
#endif

/*******************************************************************************
 * Functions ******************************************************************/
/*=memory=====================================================================*/
void *imalloc (size_t);
/*=Network====================================================================*/
int     lsocket        (const char *, const char *, int, int);
int     getRemoteHost  (const int, char *, const int);
/*=Time=======================================================================*/
struct timeval d2tval (double);
/*=pwd========================================================================*/
int GetHomeDir (uid_t, char *, ssize_t);
/*=path=======================================================================*/
ssize_t getLastPathBlock (const char *, char *, ssize_t);
int chkdir (const char *, mode_t);
int mkdirs (const char *, mode_t);
ssize_t rmPathLastBlock (char *);
ssize_t rmPathLastSlash (char *);
ssize_t packPathDupSlash (char *);
/*=log========================================================================*/
int  dateLog  (char *, const int);
void writeLog (const char *, const char *, const int, const char *, ...);
void writeSystemLog (const u_int32_t, const char *, const char *, ...);



#endif

