/* 
 * The MIT License
 *
 * Copyright (c) 2014 Yuki SAKAI
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/*******************************************************************************
 * include ********************************************************************/
#if !defined(BMP_STATION_H__)
# include <bmpStation.h>
#endif
#if !defined(BMP_STATION_INT_H__)
# include <bmpStationInt.h>
#endif
#if !defined(SELFLIB_H__)
#  include <selfLib.h>
#endif
#if !defined(_STDIO_H) && !defined(_STDIO_H_)
#  include <stdio.h>
#endif
#if !defined(_STDARG_H) && !defined(_STDARG_H_)
#  include <stdarg.h>
#endif
#if !defined(_STRING_H) && !defined(_STRING_H_)
#  include <string.h>
#endif
#if !defined(_STDLIB_H_) && !defined(_STDLIB_H)
#  include <stdlib.h>
#endif
#if !defined(_SYS_TYPES_H_) && !defined(_SYS_TYPES_H)
#  include <sys/types.h>
#endif
#if !defined(_SYS_STAT_H_) && !defined(_SYS_STAT_H)
#  include <sys/stat.h>
#endif


/*%''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''%**
 *: write Log                                                                :**
 *%,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,%*/


/*******************************************************************************
 * syslog *********************************************************************/
void writeSystemLog (const u_int32_t lbl, const char *remote, const char *fmt, ...)
{
  FILE    *wfd;
  char    strdate[30];
  char    *strLog;
  char    *jmp, *ser;
  va_list ap;
  mode_t  mode;

  if (!FLGISSET(lastParam.loglevel, lbl)) {return ;}
  /*=Get Infomation===========================================================*/
  if      (!dateLog(strdate      , sizeof (strdate  ))) {goto end_proc;}
  else if ((strLog=(char *)imalloc (LOGSTRMAX))==NULL)  {goto end_proc;}
  /*=Get Log==================================================================*/
  va_start(ap, fmt);
  if (vsnprintf (strLog, LOGSTRMAX-1, fmt, ap)<0 ) {goto fin_va;}
  va_end(ap);

  /*=Open File================================================================*/
  mode = umask (022);
  if ((wfd=fopen (syslogFile, "a"))==NULL) {goto free_data;}
  umask (mode);

  /*=write Log================================================================*/
  ser = strLog;
  for (jmp=strstr (ser, "\n"); ; jmp=strstr (ser, "\n")) {
    if      (jmp==NULL ) {}
    else if (*jmp=='\n') {*jmp = 0x00;}
    if (remote==NULL) {fprintf (wfd, "%s %s(%d): %s\n"          , strdate, prgName, getpid (),         strLog);}
    else              {fprintf (wfd, "%s %s(%d): remote:%s %s\n", strdate, prgName, getpid (), remote, strLog);}
    if (jmp==NULL) {break;}
    ser = jmp + 1;
  }
  fclose (wfd);

  return;

 free_data2:
  umask (mode);
  free (strLog);
  return ;

 fin_va:
  va_end(ap);
 free_data:
  free (strLog);
 end_proc:
  return ;
}
