/* 
 * The MIT License
 *
 * Copyright (c) 2014 Yuki SAKAI
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */
#if !defined(BMP_STATION_INT_H__)
#define BMP_STATION_INT_H__ 1
/*******************************************************************************
 * include ********************************************************************/
#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif
#if !defined(_SYS_TYPES_H) && !defined(_SYS_TYPES_H_)
#  include <sys/types.h>
#endif
#if !defined(_SYS_PARAM_H) && !defined(_SYS_PARAM_H_)
#  include <sys/param.h>
#endif
#if !defined(_NETDB_H) && !defined(_NETDB_H_)
#  include <netdb.h>
#endif
/*******************************************************************************
 * Define *********************************************************************/
#define LOGSTRMAX               512
#define DEFLHOST                ""
#define DEFLPORT                "11019"
#define DEFTCPACCEPTNUM         0
#define DEFLOGLVL               0x8
#define DEFWORKDIR              ".bmpStation"
#define DEFSYSLOG               "system.log"
#define DEFSTATISTICSLOG        "statistics.log"
#define DEFEVENTLOG             "peer_event.log"
/*#define DEFBGPMONLOG    "%H-%L_bgp.log"*/

/*******************************************************************************
 * Macro **********************************************************************/
#define FLGSET(a,b)     (a|=b)
#define FLGISSET(a,b)   ((a&b)==0?0:1)
#define FLGTGL(a,b)     (a^=b)
#define FLGCLR(a,b)     (a^=(a&b))

/*******************************************************************************
 * structure & typedef ********************************************************/
/*=option structure===========================================================*/
typedef struct {
  u_int64_t  enableConfigFlag;          /* active config flag */
#define OPTENABLECFLAGDEBUG             0x0000000000000001
#define OPTENABLECFLAGCHROOT            0x0000000000000002
#define OPTENABLECFLAGWORKDIR           0x0000000000000004
#define OPTENABLECFLAGLHOST             0x0000000000000008
#define OPTENABLECFLAGLPORT             0x0000000000000010
#define OPTENABLECFLAGTCPACCEPTNUM      0x0000000000000020
#define OPTENABLECFLAGLOGLEVEL          0x0000000000000040
#define OPTENABLECFLAGDAEMONIZE         0x0000000000000080
  u_int32_t  flags;                     /* flag option */
#define OPTFLAGDEBUG            0x00000001
#define OPTFLAGCHROOT           0x00000002
#define OPTFLAGDAEMONIZE        0x00000004
  char       workdir[MAXPATHLEN];       /* work directory */
  char       host[NI_MAXHOST];          /* listen address */
  char       ports[NI_MAXSERV];         /* listen service */
  int        acceptNum;                 /* TCP accept Num */
  u_int32_t  loglevel;                  /* log level */
#define LOGLBL_DEBUG    	0x000001
#define LOGLBL_PACKET   	0x000002
#define LOGLBL_NOTIFICATION	0x000004
#define LOGLBL_STATS    	0x000008
} optionParam;

/*******************************************************************************
 * variables ******************************************************************/
/*=System=====================================================================*/
char     *prgName;                              /* arg program name ***********/
char     pname[32];                             /* program name ***************/
uid_t    ruid;                                  /* Real user id ***************/
uid_t    euid;                                  /* Exec user id ***************/
char     syslogFile[MAXPATHLEN];                /* Proc system log ************/
char     statisticsFile[MAXPATHLEN];            /* Statistics log *************/
char     peerEventLog[MAXPATHLEN];              /* Peer event log *************/
/*=Options====================================================================*/
optionParam defParam;
optionParam cfgParam;
optionParam argParam;
optionParam lastParam;
/*******************************************************************************
 * functions ******************************************************************/
int  bmpRead        (int);
void writeSystemLog (const u_int32_t, const char *, const char *, ...);

#endif
