/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.foldermenu;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenuItem;
import org.omegat.core.Core;
import static org.omegat.plugin.foldermenu.MenuHelper.getActionListener;
import static org.omegat.plugin.foldermenu.MenuHelper.getIcon;
import org.omegat.plugin.foldermenu.filepreview.FilePreview;
import org.omegat.util.Log;
import static org.omegat.util.Platform.OsType.MAC32;
import static org.omegat.util.Platform.OsType.MAC64;
import static org.omegat.util.Platform.OsType.WIN32;
import static org.omegat.util.Platform.OsType.WIN64;
import static org.omegat.util.Platform.getOsType;
import org.omegat.util.StaticUtils;

/**
 *
 * @author Yu-Tang
 */
public class ShellLinkMenuItem {

    protected JMenuItem menuItem;

    public ShellLinkMenuItem() {
        menuItem = new JMenuItem();
    }

    public ShellLinkMenuItem(JMenuItem mi) {
        menuItem = mi;
    }
    
    public ShellLinkMenuItem(File file) throws IOException {
        JMenuItem m = new JMenuItem(file.getName(), getIcon(file));
        m.setActionCommand(file.getCanonicalPath());
        m.addActionListener(getActionListener());
        menuItem = m;
    }
    
    public boolean isEnabled() {
        return menuItem.isEnabled();
    }
    
    public JMenuItem getMenuItem() {
        return menuItem;
    }

    public void open() {
        if (! menuItem.isEnabled())
            return;

        String path = menuItem.getActionCommand();
        try {
            switch (getOsType()) {
                case WIN64:
                case WIN32:
                    File file = new File(path);
                    if (! FilePreview.open(file)) {
                        Desktop.getDesktop().open(file);
                    }
                    break;
                case MAC64:
                case MAC32:
                    new ProcessBuilder("open", path).start();
                    break;
                default: // Linux and others
                    new ProcessBuilder("xdg-open", path).start();
                    break;
            }
        } catch (IOException ex) {
            Log.log(ex);
            Core.getMainWindow().showMessageDialog(StaticUtils.format(
                    L10n.getErrMsgFileHasNoAssoc(), path));
        }
    }
}
